/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.os.Build;
import android.text.PrecomputedText;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;

class TextUtil {
    TextUtil() {
    }

    public static void asyncSetText(Executor bgExecutor, AsyncTextProvider asyncTextProvider) {
        final WeakReference<AsyncTextProvider> asyncTextProviderReference = new WeakReference<AsyncTextProvider>(asyncTextProvider);
        bgExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    CharSequence updateText;
                    AsyncTextProvider asyncTextProvider = (AsyncTextProvider)asyncTextProviderReference.get();
                    if (asyncTextProvider == null) {
                        return;
                    }
                    CharSequence longString = asyncTextProvider.getText();
                    if (Build.VERSION.SDK_INT >= 28) {
                        PrecomputedText.Params params = asyncTextProvider.getTextView().getTextMetricsParams();
                        updateText = PrecomputedText.create((CharSequence)longString, (PrecomputedText.Params)params);
                    } else {
                        updateText = longString;
                    }
                    final CharSequence updateTextFinal = updateText;
                    asyncTextProvider.getTextView().post(new Runnable(){

                        @Override
                        public void run() {
                            AsyncTextProvider asyncTextProviderInternal = (AsyncTextProvider)asyncTextProviderReference.get();
                            if (asyncTextProviderInternal == null) {
                                return;
                            }
                            AppCompatTextView textView = asyncTextProviderInternal.getTextView();
                            textView.setText(updateTextFinal, TextView.BufferType.SPANNABLE);
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static boolean isNullOrWhiteSpace(CharSequence text) {
        return text == null || text.length() == 0 || text.toString().trim().length() == 0;
    }

    public static interface AsyncTextProvider {
        public CharSequence getText();

        public AppCompatTextView getTextView();
    }
}

