/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.tonytangandroid.wood.Callback;

class Sampler<V> {
    private final int interval;
    private final Callback<V> callback;
    private final Handler handler;
    private Counter<V> currentRunnable;

    public Sampler(int intervalInMills, @NonNull Callback<V> callback) {
        this.interval = intervalInMills;
        this.callback = callback;
        this.handler = new Handler();
    }

    public void consume(V event) {
        if (this.currentRunnable == null) {
            this.currentRunnable = new Counter<V>(event, this.callback);
            this.handler.postDelayed(this.currentRunnable, (long)this.interval);
        } else if (this.currentRunnable.state == 1 || this.currentRunnable.state == 2) {
            this.currentRunnable.updateEvent(event);
        } else if (this.currentRunnable.state == 3 || this.currentRunnable.state == 4) {
            this.currentRunnable = new Counter<V>(event, this.callback);
            this.handler.postDelayed(this.currentRunnable, (long)this.interval);
        }
    }

    public static class Counter<T>
    implements Runnable {
        static final int STATE_CREATED = 1;
        static final int STATE_QUEUED = 2;
        static final int STATE_RUNNING = 3;
        static final int STATE_FINISHED = 4;
        private final Callback<T> callback;
        int state;
        private T event;

        Counter(T event, Callback<T> callback) {
            this.event = event;
            this.callback = callback;
            this.state = 1;
        }

        void updateEvent(T deliverable) {
            this.event = deliverable;
        }

        @Override
        public void run() {
            this.state = 3;
            this.callback.onEmit(this.event);
            this.state = 4;
        }
    }
}

