/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.content.Context;
import android.graphics.Color;
import androidx.core.content.ContextCompat;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.R;

class WoodColorUtil {
    public static final int SEARCHED_HIGHLIGHT_BACKGROUND_COLOR = Color.parseColor((String)"#FD953F");
    public static final int HIGHLIGHT_BACKGROUND_COLOR = Color.parseColor((String)"#FFFD38");
    public static final int HIGHLIGHT_TEXT_COLOR = 0;
    public static final boolean HIGHLIGHT_UNDERLINE = false;
    private static WoodColorUtil TRANSACTION_COLOR_UTIL_INSTANCE;
    private final int mColorDefault;
    private final int mColorVerbose;
    private final int mColorError;
    private final int mColorAssert;
    private final int mColorInfo;
    private final int mColorWarning;
    private final int mColorDebug;

    private WoodColorUtil(Context context) {
        this.mColorDefault = ContextCompat.getColor((Context)context, (int)R.color.wood_status_default);
        this.mColorVerbose = ContextCompat.getColor((Context)context, (int)R.color.wood_log_verbose);
        this.mColorDebug = ContextCompat.getColor((Context)context, (int)R.color.wood_log_debug);
        this.mColorInfo = ContextCompat.getColor((Context)context, (int)R.color.wood_log_info);
        this.mColorWarning = ContextCompat.getColor((Context)context, (int)R.color.wood_log_warning);
        this.mColorError = ContextCompat.getColor((Context)context, (int)R.color.wood_log_error);
        this.mColorAssert = ContextCompat.getColor((Context)context, (int)R.color.wood_log_assert);
    }

    public static WoodColorUtil getInstance(Context context) {
        if (TRANSACTION_COLOR_UTIL_INSTANCE == null) {
            TRANSACTION_COLOR_UTIL_INSTANCE = new WoodColorUtil(context);
        }
        return TRANSACTION_COLOR_UTIL_INSTANCE;
    }

    public int getTransactionColor(Leaf transaction) {
        return this.getTransactionColor(transaction.getPriority());
    }

    public int getTransactionColor(int priority) {
        if (priority == 2) {
            return this.mColorVerbose;
        }
        if (priority == 3) {
            return this.mColorDebug;
        }
        if (priority == 4) {
            return this.mColorInfo;
        }
        if (priority == 5) {
            return this.mColorWarning;
        }
        if (priority == 6) {
            return this.mColorError;
        }
        if (priority == 7) {
            return this.mColorAssert;
        }
        return this.mColorDefault;
    }
}

