/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.paging.PagedListAdapter;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.LeafViewHolder;
import com.tonytangandroid.wood.ListDiffUtil;
import com.tonytangandroid.wood.R;
import javax.inject.Provider;

class LeafAdapter
extends PagedListAdapter<Leaf, LeafViewHolder>
implements Provider<String> {
    private final Context context;
    private final Listener listener;
    private final LayoutInflater layoutInflater;
    private String searchKey;

    LeafAdapter(Context context, ListDiffUtil listDiffUtil, Listener listener) {
        super((DiffUtil.ItemCallback)listDiffUtil);
        this.context = context;
        this.listener = listener;
        this.layoutInflater = LayoutInflater.from((Context)this.context);
        this.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                LeafAdapter.this.listener.onItemsInserted(positionStart);
            }
        });
    }

    LeafAdapter setSearchKey(String searchKey) {
        this.searchKey = searchKey;
        return this;
    }

    @NonNull
    public LeafViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = this.layoutInflater.inflate(R.layout.wood_list_item_leaf, parent, false);
        return new LeafViewHolder(itemView, this.context, this, this.listener);
    }

    public void onBindViewHolder(@NonNull LeafViewHolder viewHolder, int position) {
        Leaf transaction = (Leaf)this.getItem(position);
        if (transaction != null) {
            viewHolder.bind(transaction);
        }
    }

    public String get() {
        return this.searchKey;
    }

    static interface Listener {
        public void onTransactionClicked(Leaf var1);

        public void onItemsInserted(int var1);
    }
}

