/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.jakewharton.threetenabp.AndroidThreeTen;
import com.tonytangandroid.wood.JobExecutor;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.NotificationHelper;
import com.tonytangandroid.wood.RetentionManager;
import com.tonytangandroid.wood.WoodDatabase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Executor;
import timber.log.Timber;

public class WoodTree
extends Timber.DebugTree {
    @NonNull
    private static final Period DEFAULT_RETENTION = Period.ONE_WEEK;
    private static final String PREF_WOOD_CONFIG = "pref_wood_config";
    private static final String PREF_KEY_AUTO_SCROLL = "pref_key_auto_scroll";
    @NonNull
    private final Context context;
    @NonNull
    private final WoodDatabase woodDatabase;
    private final Executor executor = new JobExecutor();
    @Nullable
    private NotificationHelper notificationHelper;
    @NonNull
    private RetentionManager retentionManager;
    private int maxContentLength = 250000;
    private boolean stickyNotification = false;
    private final SharedPreferences sharedPreferences;

    public WoodTree(@NonNull Context context) {
        this.context = context.getApplicationContext();
        this.woodDatabase = WoodDatabase.getInstance(context);
        this.retentionManager = new RetentionManager(this.context, DEFAULT_RETENTION);
        AndroidThreeTen.init((Context)context);
        this.sharedPreferences = context.getSharedPreferences(PREF_WOOD_CONFIG, 0);
    }

    public static boolean autoScroll(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_WOOD_CONFIG, 0);
        return sharedPreferences.getBoolean(PREF_KEY_AUTO_SCROLL, true);
    }

    @NonNull
    public WoodTree showNotification(boolean sticky) {
        this.stickyNotification = sticky;
        this.notificationHelper = new NotificationHelper(this.context);
        return this;
    }

    @NonNull
    public WoodTree retainDataFor(Period period) {
        this.retentionManager = new RetentionManager(this.context, period);
        return this;
    }

    @NonNull
    public WoodTree autoScroll(boolean autoScroll) {
        this.sharedPreferences.edit().putBoolean(PREF_KEY_AUTO_SCROLL, autoScroll).apply();
        return this;
    }

    @NonNull
    public WoodTree maxLength(int max) {
        this.maxContentLength = Math.min(max, 999999);
        return this;
    }

    protected void log(final int priority, final String tag, final @NonNull String message, final Throwable t) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                WoodTree.this.doLog(priority, tag, message, t);
            }
        });
    }

    private void doLog(int priority, String tag, @NonNull String message, Throwable t) {
        Leaf transaction = new Leaf();
        transaction.setPriority(priority);
        transaction.setCreateAt(System.currentTimeMillis());
        transaction.setTag(tag);
        transaction.setLength(message.length());
        if (t != null) {
            message = message + "\n" + t.getMessage() + "\n" + ErrorUtil.asString(t);
        }
        transaction.setBody(message.substring(0, Math.min(message.length(), this.maxContentLength)) + "");
        this.create(transaction);
    }

    private void create(@NonNull Leaf transaction) {
        long transactionId = this.woodDatabase.leafDao().insertTransaction(transaction);
        transaction.setId(transactionId);
        if (this.notificationHelper != null) {
            this.notificationHelper.show(transaction, this.stickyNotification);
        }
        this.retentionManager.doMaintenance();
    }

    static class ErrorUtil {
        ErrorUtil() {
        }

        public static String asString(Throwable throwable) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            return sw.toString();
        }
    }

    public static enum Period {
        ONE_HOUR,
        ONE_DAY,
        ONE_WEEK,
        FOREVER;

    }
}

