/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.arch.lifecycle.LiveData;
import android.arch.paging.DataSource;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Delete;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;
import android.arch.persistence.room.Update;
import android.support.annotation.IntRange;
import com.tonytangandroid.wood.Leaf;

@Dao
abstract class LeafDao {
    public static final int SEARCH_DEFAULT = 2;

    LeafDao() {
    }

    @Insert(onConflict=1)
    public abstract long insertTransaction(Leaf var1);

    @Update(onConflict=1)
    public abstract int updateTransaction(Leaf var1);

    @Delete
    public abstract int deleteTransactions(Leaf ... var1);

    @Query(value="DELETE FROM Leaf WHERE createAt < :beforeDate")
    public abstract int deleteTransactionsBefore(long var1);

    @Query(value="DELETE FROM Leaf")
    public abstract int clearAll();

    @Query(value="SELECT * FROM Leaf ORDER BY id DESC")
    public abstract DataSource.Factory<Integer, Leaf> getAllTransactions();

    @Query(value="SELECT * FROM Leaf WHERE id = :id")
    public abstract LiveData<Leaf> getTransactionsWithId(long var1);

    public DataSource.Factory<Integer, Leaf> getAllTransactionsWith(String key, @IntRange(from=2L, to=7L) int priority) {
        String endWildCard = key + "%";
        String doubleSideWildCard = "%" + key + "%";
        return this.getAllTransactionsIncludeRequestResponse(endWildCard, doubleSideWildCard, priority);
    }

    @Query(value="SELECT id,createAt,length,priority,body FROM Leaf WHERE (tag LIKE :endWildCard OR body LIKE :doubleWildCard) AND priority >= :priority ORDER BY id DESC")
    abstract DataSource.Factory<Integer, Leaf> getAllTransactionsIncludeRequestResponse(String var1, String var2, int var3);
}

