/*
 * Decompiled with CFR 0.152.
 */
package com.tonytangandroid.wood;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.ViewModelProviders;
import android.arch.paging.PagedList;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import com.tonytangandroid.wood.Callback;
import com.tonytangandroid.wood.Debouncer;
import com.tonytangandroid.wood.Leaf;
import com.tonytangandroid.wood.LeafAdapter;
import com.tonytangandroid.wood.LeafDetailsActivity;
import com.tonytangandroid.wood.LeafListViewModel;
import com.tonytangandroid.wood.ListDiffUtil;
import com.tonytangandroid.wood.NotificationHelper;
import com.tonytangandroid.wood.R;
import com.tonytangandroid.wood.Sampler;

public class LeafListActivity
extends AppCompatActivity
implements LeafAdapter.Listener,
SearchView.OnQueryTextListener {
    private LeafAdapter adapter;
    private ListDiffUtil listDiffUtil;
    private RecyclerView recyclerView;
    private LeafListViewModel viewModel;
    private LiveData<PagedList<Leaf>> currentSubscription;
    private Sampler<TransactionListWithSearchKeyModel> transactionSampler = new Sampler<TransactionListWithSearchKeyModel>(100, new Callback<TransactionListWithSearchKeyModel>(){

        @Override
        public void onEmit(TransactionListWithSearchKeyModel event) {
            LeafListActivity.this.listDiffUtil.setSearchKey(event.searchKey);
            LeafListActivity.this.adapter.setSearchKey(event.searchKey).submitList(event.pagedList);
        }
    });
    private Debouncer<String> searchDebouncer = new Debouncer<String>(300, new Callback<String>(){

        @Override
        public void onEmit(String event) {
            LeafListActivity.this.loadResults(event, (LiveData<PagedList<Leaf>>)LeafListActivity.this.viewModel.getTransactions(event));
        }
    });

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.wood_activity_leaf_list);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.wood_toolbar);
        this.setSupportActionBar(toolbar);
        toolbar.setSubtitle((CharSequence)this.getApplicationName());
        this.recyclerView = (RecyclerView)this.findViewById(R.id.wood_transaction_list);
        this.listDiffUtil = new ListDiffUtil();
        this.adapter = new LeafAdapter((Context)this, this.listDiffUtil, this);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.viewModel = (LeafListViewModel)ViewModelProviders.of((FragmentActivity)this).get(LeafListViewModel.class);
        this.loadResults(null, this.viewModel.getTransactions(null));
    }

    private void loadResults(String searchKey, LiveData<PagedList<Leaf>> pagedListLiveData) {
        if (this.currentSubscription != null && this.currentSubscription.hasObservers()) {
            this.currentSubscription.removeObservers((LifecycleOwner)this);
        }
        this.currentSubscription = pagedListLiveData;
        this.currentSubscription.observe((LifecycleOwner)this, list -> this.consume((PagedList<Leaf>)list, searchKey));
    }

    private void consume(@Nullable PagedList<Leaf> transactionPagedList, String searchKey) {
        this.transactionSampler.consume(new TransactionListWithSearchKeyModel(searchKey, transactionPagedList));
    }

    @Override
    public void onTransactionClicked(Leaf transaction) {
        LeafDetailsActivity.start((Context)this, transaction.getId(), transaction.getPriority());
    }

    @Override
    public void onItemsInserted(int firstInsertedItemPosition) {
        this.recyclerView.smoothScrollToPosition(firstInsertedItemPosition);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.wood_list_menu, menu2);
        MenuItem searchMenuItem = menu2.findItem(R.id.search);
        SearchView searchView = (SearchView)searchMenuItem.getActionView();
        searchView.setOnQueryTextListener((SearchView.OnQueryTextListener)this);
        searchView.setIconifiedByDefault(true);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.clear) {
            this.viewModel.clearAll();
            NotificationHelper.clearBuffer();
            return true;
        }
        if (item.getItemId() == R.id.browse_sql) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    public boolean onQueryTextChange(String newText) {
        this.searchDebouncer.consume(newText);
        return true;
    }

    private String getApplicationName() {
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : this.getString(stringId);
    }

    static class TransactionListWithSearchKeyModel {
        final String searchKey;
        final PagedList<Leaf> pagedList;

        TransactionListWithSearchKeyModel(String searchKey, PagedList<Leaf> pagedList) {
            this.searchKey = searchKey;
            this.pagedList = pagedList;
        }
    }
}

