/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.util;

import com.google.common.base.Preconditions;
import com.squareup.moshi.Moshi;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.util.ElementAdapter;
import com.therandomlabs.curseapi.util.HttpUrlAdapter;
import com.therandomlabs.curseapi.util.ZonedDateTimeAdapter;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

public final class MoshiUtils {
    public static final Moshi moshi = new Moshi.Builder().add((Object)ElementAdapter.INSTANCE).add((Object)HttpUrlAdapter.INSTANCE).add((Object)ZonedDateTimeAdapter.INSTANCE).build();

    private MoshiUtils() {
    }

    public static <T> T fromJSON(String json, Class<T> type) throws CurseException {
        Preconditions.checkNotNull((Object)json, (Object)"json should not be null");
        Preconditions.checkNotNull(type, (Object)"type should not be null");
        try {
            return (T)moshi.adapter(type).fromJson(json);
        }
        catch (IOException ex) {
            throw new CurseException("Failed to read JSON: " + json, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJSON(Path json, Class<T> type) throws CurseException {
        Preconditions.checkNotNull((Object)json, (Object)"json should not be null");
        Preconditions.checkNotNull(type, (Object)"type should not be null");
        try (BufferedSource source = Okio.buffer((Source)Okio.source((Path)json, (OpenOption[])new OpenOption[0]));){
            T t = MoshiUtils.fromJSON(source.readUtf8(), type);
            return t;
        }
        catch (IOException ex) {
            throw new CurseException("Failed to read JSON: " + json, ex);
        }
    }

    public static <T> String toJSON(T value) {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        return moshi.adapter(value.getClass()).indent("  ").toJson(value);
    }

    public static <T> void toJSON(T value, Path path) throws CurseException {
        Preconditions.checkNotNull(value, (Object)"value should not be null");
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        try (BufferedSink sink = Okio.buffer((Sink)Okio.sink((Path)path, (OpenOption[])new OpenOption[0]));){
            sink.writeUtf8(MoshiUtils.toJSON(value)).writeUtf8("\n");
        }
        catch (IOException ex) {
            throw new CurseException("Failed to write JSON: " + path, ex);
        }
    }
}

