/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.project;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.CurseFiles;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseCategorySection;
import com.therandomlabs.curseapi.game.CurseGame;
import com.therandomlabs.curseapi.project.CurseAttachment;
import com.therandomlabs.curseapi.project.CurseMember;
import com.therandomlabs.curseapi.util.JsoupUtils;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Set;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;

public abstract class CurseProject
implements Comparable<CurseProject> {
    public static final Comparator<CurseProject> SORT_BY_OLDEST = Comparator.comparingInt(CurseProject::id);
    public static final Comparator<CurseProject> SORT_BY_NEWEST = SORT_BY_OLDEST.reversed();
    public static final Comparator<CurseProject> SORT_BY_FIRST_UPDATED = Comparator.comparing(CurseProject::lastUpdateTime);
    public static final Comparator<CurseProject> SORT_BY_LAST_UPDATED = SORT_BY_FIRST_UPDATED.reversed();

    public final int hashCode() {
        return this.id();
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof CurseProject && this.id() == ((CurseProject)object).id();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("name", (Object)this.name()).add("url", (Object)this.url()).toString();
    }

    @Override
    public final int compareTo(CurseProject project) {
        return this.name().compareTo(project.name());
    }

    public abstract int id();

    public abstract String name();

    public abstract CurseMember author();

    public abstract Set<CurseMember> authors();

    public @Nullable CurseAttachment attachment(int id) {
        CursePreconditions.checkAttachmentID(id, "id");
        CurseAttachment logo = this.logo();
        if (id == logo.id()) {
            return logo;
        }
        for (CurseAttachment attachment : this.attachments()) {
            if (attachment.id() != id) continue;
            return attachment;
        }
        return null;
    }

    public abstract Set<CurseAttachment> attachments();

    public abstract CurseAttachment logo();

    public abstract HttpUrl url();

    public abstract int gameID();

    public abstract CurseGame game() throws CurseException;

    public abstract CurseGame refreshGame() throws CurseException;

    public abstract String summary();

    public abstract Element description() throws CurseException;

    public String descriptionPlainText() throws CurseException {
        return this.descriptionPlainText(Integer.MAX_VALUE);
    }

    public String descriptionPlainText(int maxLineLength) throws CurseException {
        Preconditions.checkArgument((maxLineLength > 0 ? 1 : 0) != 0, (Object)"maxLineLength should be greater than 0");
        return JsoupUtils.getPlainText(this.description(), maxLineLength).trim();
    }

    public abstract Element refreshDescription() throws CurseException;

    public abstract int downloadCount();

    public abstract CurseFiles<CurseFile> files() throws CurseException;

    public abstract CurseFiles<CurseFile> refreshFiles() throws CurseException;

    public abstract HttpUrl fileURL(int var1);

    public abstract CurseCategory primaryCategory();

    public abstract Set<CurseCategory> categories();

    public abstract CurseCategorySection categorySection();

    public abstract String slug();

    public abstract ZonedDateTime creationTime();

    public abstract ZonedDateTime lastUpdateTime();

    public abstract ZonedDateTime lastModificationTime();

    public abstract boolean experimental();
}

