/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.project;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.util.JsoupUtils;
import com.therandomlabs.curseapi.util.OkHttpUtils;
import java.awt.image.BufferedImage;
import okhttp3.HttpUrl;
import org.jsoup.nodes.Element;

public abstract class CurseAttachment {
    public static final CurseAttachment PLACEHOLDER_LOGO = new CurseAttachment(){
        private final HttpUrl url = HttpUrl.get((String)"https://raw.githubusercontent.com/TheRandomLabs/CurseAPI/master/placeholder-project-logo.png");
        private final HttpUrl thumbnailURL = HttpUrl.get((String)"https://media.forgecdn.net/avatars/0/93/635227964539626926.png");
        private final Element description = new Element("p").text("The placeholder CurseForge project logo.");

        @Override
        public int id() {
            return Integer.MAX_VALUE;
        }

        @Override
        public String title() {
            return "Placeholder project logo";
        }

        @Override
        public Element description() {
            return this.description;
        }

        @Override
        public HttpUrl url() {
            return this.url;
        }

        @Override
        public HttpUrl thumbnailURL() {
            return this.thumbnailURL;
        }
    };

    public final int hashCode() {
        return this.id();
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof CurseAttachment && this.id() == ((CurseAttachment)object).id();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id()).add("title", (Object)this.title()).add("url", (Object)this.url()).toString();
    }

    public abstract int id();

    public abstract String title();

    public abstract Element description() throws CurseException;

    public String descriptionPlainText() throws CurseException {
        return this.descriptionPlainText(Integer.MAX_VALUE);
    }

    public String descriptionPlainText(int maxLineLength) throws CurseException {
        Preconditions.checkArgument((maxLineLength > 0 ? 1 : 0) != 0, (Object)"maxLineLength should be greater than 0");
        return JsoupUtils.getPlainText(this.description(), maxLineLength).trim();
    }

    public abstract HttpUrl url();

    public BufferedImage get() throws CurseException {
        return OkHttpUtils.readImage(this.url());
    }

    public abstract HttpUrl thumbnailURL();

    public BufferedImage thumbnail() throws CurseException {
        return OkHttpUtils.readImage(this.thumbnailURL());
    }
}

