/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.game;

import com.google.common.base.MoreObjects;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.game.CurseCategorySection;
import com.therandomlabs.curseapi.game.CurseGame;
import com.therandomlabs.curseapi.util.OkHttpUtils;
import java.awt.image.BufferedImage;
import java.util.Optional;
import okhttp3.HttpUrl;

public abstract class CurseCategory
implements Comparable<CurseCategory> {
    public final int hashCode() {
        return this.id();
    }

    public final boolean equals(Object object) {
        return this == object || object instanceof CurseCategory && this.id() == ((CurseCategory)object).id();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("gameID", this.gameID()).add("sectionID", this.sectionID()).add("id", this.id()).add("name", (Object)this.name()).add("slug", (Object)this.slug()).toString();
    }

    @Override
    public final int compareTo(CurseCategory category) {
        return this.name().compareTo(category.name());
    }

    public abstract int gameID();

    public abstract CurseGame game() throws CurseException;

    public abstract CurseGame refreshGame() throws CurseException;

    public abstract int sectionID();

    public Optional<CurseCategorySection> section() throws CurseException {
        int sectionID = this.sectionID();
        if (sectionID == 0) {
            return Optional.empty();
        }
        return this.game().categorySection(sectionID);
    }

    public abstract int id();

    public abstract String name();

    public abstract String slug();

    public abstract HttpUrl url() throws CurseException;

    public abstract HttpUrl logoURL();

    public BufferedImage logo() throws CurseException {
        return OkHttpUtils.readImage(this.logoURL());
    }
}

