/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi.file;

import com.google.common.base.Preconditions;

public enum CurseReleaseType {
    RELEASE,
    BETA,
    ALPHA;

    private final int id = this.ordinal() + 1;

    public int id() {
        return this.id;
    }

    public boolean hasMinimumStability(CurseReleaseType releaseType) {
        return this.id <= releaseType.id;
    }

    public static CurseReleaseType fromID(int id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)"id should be positive");
        Preconditions.checkArgument((id <= 3 ? 1 : 0) != 0, (Object)"id should not be above 3");
        return CurseReleaseType.values()[id - 1];
    }
}

