/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.curseapi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.therandomlabs.curseapi.CurseAPIProvider;
import com.therandomlabs.curseapi.CurseException;
import com.therandomlabs.curseapi.CursePreconditions;
import com.therandomlabs.curseapi.cfwidget.CFWidgetProvider;
import com.therandomlabs.curseapi.file.CurseFile;
import com.therandomlabs.curseapi.file.CurseFiles;
import com.therandomlabs.curseapi.forgesvc.ForgeSvcProvider;
import com.therandomlabs.curseapi.game.CurseCategory;
import com.therandomlabs.curseapi.game.CurseGame;
import com.therandomlabs.curseapi.game.CurseGameVersion;
import com.therandomlabs.curseapi.game.CurseGameVersionGroup;
import com.therandomlabs.curseapi.project.CurseProject;
import com.therandomlabs.curseapi.project.CurseSearchQuery;
import com.therandomlabs.curseapi.util.CheckedFunction;
import com.therandomlabs.curseapi.util.JsoupUtils;
import com.therandomlabs.curseapi.util.OkHttpUtils;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.HttpUrl;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CurseAPI {
    public static final int MIN_GAME_ID = 1;
    public static final int MIN_CATEGORY_SECTION_ID = 1;
    public static final int MIN_CATEGORY_ID = 1;
    public static final int MIN_PROJECT_ID = 10;
    public static final int MIN_FILE_ID = 60018;
    public static final int MIN_ATTACHMENT_ID = 76990;
    private static final Logger logger = LoggerFactory.getLogger(CurseAPI.class);
    private static final List<CurseAPIProvider> providers = Lists.newArrayList((Object[])new CurseAPIProvider[]{ForgeSvcProvider.instance, CFWidgetProvider.instance});

    private CurseAPI() {
    }

    public static Optional<CurseProject> project(int id) throws CurseException {
        CursePreconditions.checkProjectID(id, "id");
        return CurseAPI.get(provider -> provider.project(id));
    }

    public static Optional<CurseProject> project(String path) throws CurseException {
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"path should not be empty");
        return CurseAPI.get(provider -> provider.project(path));
    }

    public static Optional<CurseProject> project(HttpUrl url) throws CurseException {
        Preconditions.checkNotNull((Object)url, (Object)"url should not be null");
        Preconditions.checkArgument((boolean)"curseforge.com".equals(url.topPrivateDomain()), (Object)"url should be a CurseForge project URL");
        return CurseAPI.project(url.encodedPath());
    }

    public static Optional<Element> projectDescription(int id) throws CurseException {
        CursePreconditions.checkProjectID(id, "id");
        return CurseAPI.get(provider -> provider.projectDescription(id));
    }

    public static Optional<String> projectDescriptionPlainText(int id) throws CurseException {
        return CurseAPI.projectDescriptionPlainText(id, Integer.MAX_VALUE);
    }

    public static Optional<String> projectDescriptionPlainText(int id, int maxLineLength) throws CurseException {
        CursePreconditions.checkProjectID(id, "id");
        Preconditions.checkArgument((maxLineLength > 0 ? 1 : 0) != 0, (Object)"maxLineLength should be greater than 0");
        return CurseAPI.projectDescription(id).map(description -> JsoupUtils.getPlainText(description, maxLineLength).trim());
    }

    public static Optional<List<CurseProject>> searchProjects(CurseSearchQuery query) throws CurseException {
        Preconditions.checkNotNull((Object)query, (Object)"query should not be null");
        return CurseAPI.get(provider -> provider.searchProjects(query));
    }

    public static Optional<CurseFiles<CurseFile>> files(int projectID) throws CurseException {
        CursePreconditions.checkProjectID(projectID, "projectID");
        return CurseAPI.get(provider -> provider.files(projectID));
    }

    public static Optional<CurseFile> file(int projectID, int fileID) throws CurseException {
        CursePreconditions.checkProjectID(projectID, "projectID");
        CursePreconditions.checkFileID(fileID, "fileID");
        return CurseAPI.get(provider -> provider.file(projectID, fileID));
    }

    public static Optional<Element> fileChangelog(int projectID, int fileID) throws CurseException {
        CursePreconditions.checkProjectID(projectID, "projectID");
        CursePreconditions.checkFileID(fileID, "fileID");
        return CurseAPI.get(provider -> provider.fileChangelog(projectID, fileID));
    }

    public static Optional<String> fileChangelogPlainText(int projectID, int fileID) throws CurseException {
        return CurseAPI.fileChangelogPlainText(projectID, fileID, Integer.MAX_VALUE);
    }

    public static Optional<String> fileChangelogPlainText(int projectID, int fileID, int maxLineLength) throws CurseException {
        CursePreconditions.checkProjectID(projectID, "projectID");
        CursePreconditions.checkFileID(fileID, "fileID");
        Preconditions.checkArgument((maxLineLength > 0 ? 1 : 0) != 0, (Object)"maxLineLength should be greater than 0");
        return CurseAPI.fileChangelog(projectID, fileID).map(changelog -> JsoupUtils.getPlainText(changelog, maxLineLength).trim());
    }

    public static Optional<HttpUrl> fileDownloadURL(int projectID, int fileID) throws CurseException {
        CursePreconditions.checkProjectID(projectID, "projectID");
        CursePreconditions.checkFileID(fileID, "fileID");
        return CurseAPI.get(provider -> provider.fileDownloadURL(projectID, fileID));
    }

    public static boolean downloadFile(int projectID, int fileID, Path path) throws CurseException {
        CursePreconditions.checkProjectID(projectID, "projectID");
        CursePreconditions.checkFileID(fileID, "fileID");
        Preconditions.checkNotNull((Object)path, (Object)"path should not be null");
        Optional<HttpUrl> optionalURL = CurseAPI.fileDownloadURL(projectID, fileID);
        if (!optionalURL.isPresent()) {
            return false;
        }
        OkHttpUtils.download(optionalURL.get(), path);
        return true;
    }

    public static Optional<Path> downloadFileToDirectory(int projectID, int fileID, Path directory) throws CurseException {
        CursePreconditions.checkProjectID(projectID, "projectID");
        CursePreconditions.checkFileID(fileID, "fileID");
        Preconditions.checkNotNull((Object)directory, (Object)"directory should not be null");
        Optional<HttpUrl> optionalURL = CurseAPI.fileDownloadURL(projectID, fileID);
        if (!optionalURL.isPresent()) {
            return Optional.empty();
        }
        HttpUrl url = optionalURL.get();
        return Optional.of(OkHttpUtils.downloadToDirectory(url, directory, OkHttpUtils.getFileNameFromURLPath(url)));
    }

    public static Optional<Set<CurseGame>> games() throws CurseException {
        return CurseAPI.get(CurseAPIProvider::games);
    }

    public static Stream<CurseGame> streamGames() throws CurseException {
        Optional<Set<CurseGame>> optionalGames = CurseAPI.games();
        return optionalGames.map(Collection::stream).orElseGet(Stream::empty);
    }

    public static Optional<CurseGame> game(int id) throws CurseException {
        CursePreconditions.checkGameID(id, "id");
        return CurseAPI.get(provider -> provider.game(id));
    }

    public static <V extends CurseGameVersion<?>> Optional<NavigableSet<V>> gameVersions(int gameID) throws CurseException {
        CursePreconditions.checkGameID(gameID, "gameID");
        return CurseAPI.get(provider -> provider.gameVersions(gameID));
    }

    public static <V extends CurseGameVersion<?>> Optional<V> gameVersion(int gameID, String versionString) throws CurseException {
        CursePreconditions.checkGameID(gameID, "gameID");
        Preconditions.checkNotNull((Object)versionString, (Object)"versionString should not be null");
        return CurseAPI.get(provider -> provider.gameVersion(gameID, versionString));
    }

    public static Optional<Set<CurseCategory>> categories() throws CurseException {
        return CurseAPI.get(CurseAPIProvider::categories);
    }

    public static Optional<Set<CurseCategory>> categories(int sectionID) throws CurseException {
        CursePreconditions.checkCategorySectionID(sectionID, "sectionID");
        return CurseAPI.get(provider -> provider.categories(sectionID));
    }

    public static Stream<CurseCategory> streamCategories() throws CurseException {
        Optional<Set<CurseCategory>> optionalCategories = CurseAPI.categories();
        return optionalCategories.map(Collection::stream).orElseGet(Stream::empty);
    }

    public static Stream<CurseCategory> streamCategories(int sectionID) throws CurseException {
        Optional<Set<CurseCategory>> optionalCategories = CurseAPI.categories(sectionID);
        return optionalCategories.map(Collection::stream).orElseGet(Stream::empty);
    }

    public static Optional<CurseCategory> category(int id) throws CurseException {
        CursePreconditions.checkCategoryID(id, "id");
        return CurseAPI.get(provider -> provider.category(id));
    }

    @SafeVarargs
    public static <V extends CurseGameVersion<?>> Set<CurseGameVersionGroup<V>> gameVersionGroups(V ... versions) {
        return CurseAPI.gameVersionGroups(Arrays.asList(versions));
    }

    public static <V extends CurseGameVersion<?>> Set<CurseGameVersionGroup<V>> gameVersionGroups(Collection<? extends V> versions) {
        return versions.stream().map(version -> version.versionGroup()).filter(group -> !group.isNone()).collect(Collectors.toCollection(HashSet::new));
    }

    public static <E, R, C> C parallelMap(Collection<? extends E> collection, CheckedFunction<? super E, ? extends R, CurseException> function, Collector<? super R, ?, C> collector) throws CurseException {
        try {
            return collection.parallelStream().map(element -> CurseAPI.callCheckedFunction(element, function)).collect(collector);
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof CurseException) {
                throw (CurseException)ex.getCause();
            }
            throw ex;
        }
    }

    public static <E, K, V> Map<K, V> parallelMap(Collection<? extends E> collection, CheckedFunction<? super E, ? extends K, CurseException> keyMapper, CheckedFunction<? super E, ? extends V, CurseException> valueMapper) throws CurseException {
        return CurseAPI.parallelMap(collection, (? super E element) -> new AbstractMap.SimpleEntry(keyMapper.apply((Object)element), valueMapper.apply((Object)element)), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static boolean addProvider(CurseAPIProvider provider, boolean firstPriority) {
        Preconditions.checkNotNull((Object)provider, (Object)"provider should not be null");
        if (providers.contains(provider)) {
            return false;
        }
        if (firstPriority) {
            providers.add(0, provider);
        } else {
            providers.add(provider);
        }
        return true;
    }

    public static boolean removeProvider(CurseAPIProvider provider) {
        Preconditions.checkNotNull((Object)provider, (Object)"provider should not be null");
        return providers.remove(provider);
    }

    public static List<CurseAPIProvider> providers() {
        return new ArrayList<CurseAPIProvider>(providers);
    }

    private static <T> Optional<T> get(CheckedFunction<CurseAPIProvider, T, CurseException> function) throws CurseException {
        if (providers.isEmpty()) {
            logger.warn("No CurseAPIProviders configured");
            return Optional.empty();
        }
        for (CurseAPIProvider provider : providers) {
            T t = function.apply(provider);
            if (t == null) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    private static <E, T> @Nullable T callCheckedFunction(E element, CheckedFunction<E, T, CurseException> function) {
        try {
            return function.apply(element);
        }
        catch (CurseException ex) {
            throw new RuntimeException(ex);
        }
    }
}

