/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Process;
import android.support.annotation.NonNull;
import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.ISoterLogger;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreData;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessNoExtResult;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_net.ISoterNetCallback;
import com.tencent.soter.wrapper.wrap_net.IWrapGetSupportNet;
import com.tencent.soter.wrapper.wrap_task.BaseSoterTask;
import com.tencent.soter.wrapper.wrap_task.InitializeParam;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;

public class TaskInit
extends BaseSoterTask {
    private static final String TAG = "Soter.TaskInit";
    private static final String SOTER_STATUS_SHARED_PREFERENCE_NAME = "soter_status";
    private static final int MAX_SALT_STR_LEN = 24;
    private static final int MAX_CUSTOM_KEY_LEN = 24;
    private boolean isNativeSupport = false;
    private IWrapGetSupportNet getSupportNetWrapper;
    private String distinguishSalt = "";
    private String customAskName = "";
    private int[] scenes;
    private ISoterLogger loggerImp;

    public TaskInit(Context context, @NonNull InitializeParam param) {
        SoterCore.setUp();
        this.isNativeSupport = SoterCore.isNativeSupportSoter() && SoterCore.isSupportFingerprint((Context)context);
        this.getSupportNetWrapper = param.getGetSupportNetWrapper();
        this.scenes = param.getScenes();
        this.distinguishSalt = param.getDistinguishSalt();
        this.customAskName = param.getCustomAppSecureKeyName();
        this.loggerImp = param.getSoterLogger();
        SoterDataCenter.getInstance().setStatusSharedPreference(context.getSharedPreferences(SOTER_STATUS_SHARED_PREFERENCE_NAME, 0));
    }

    @Override
    boolean preExecute() {
        if (this.loggerImp != null) {
            SLogger.setLogImp((ISoterLogger)this.loggerImp);
        }
        if (SoterCoreUtil.isNullOrNil((int[])this.scenes)) {
            SLogger.e((String)TAG, (String)"soter: the salt string used to distinguish is longer than 24", (Object[])new Object[0]);
            this.callback(new SoterProcessNoExtResult(27, "no business scene provided"));
            return true;
        }
        if (SoterCoreUtil.nullAsNil((String)this.distinguishSalt).length() > 24) {
            SLogger.e((String)TAG, (String)"soter: the salt string used to distinguish is longer than 24", (Object[])new Object[0]);
            this.callback(new SoterProcessNoExtResult(28, "the account salt length is too long"));
            return true;
        }
        if (!SoterCoreUtil.isNullOrNil((String)this.customAskName) && this.customAskName.length() > 24) {
            SLogger.e((String)TAG, (String)"soter: the passed ask name is too long (larger than 24).", (Object[])new Object[0]);
            this.callback(new SoterProcessNoExtResult(29, "the passed ask name is too long (larger than 24)"));
            return true;
        }
        if (this.getSupportNetWrapper == null) {
            SLogger.w((String)TAG, (String)"soter: it is strongly recommended to check device support from server, so you'd better provider a net wrapper to check it", (Object[])new Object[0]);
        }
        if (!SoterCoreUtil.isNullOrNil((String)this.customAskName)) {
            SLogger.i((String)TAG, (String)"soter: provided valid ASK name", (Object[])new Object[0]);
            SoterCoreData.getInstance().setAskName(this.customAskName);
        }
        SoterTaskThread.getInstance().postToWorker(new Runnable(){

            @Override
            public void run() {
                TaskInit.this.generateAuthKeyNames(TaskInit.this.distinguishSalt, TaskInit.this.scenes);
                TaskInit.this.removeAbnormalKeys();
            }
        });
        return false;
    }

    private void removeAbnormalKeys() {
        SharedPreferences preferences = SoterDataCenter.getInstance().getStatusSharedPreference();
        int askStatus = preferences.getInt(SoterCoreData.getInstance().getAskName(), 0);
        SLogger.d((String)TAG, (String)"soter: ask status: %d", (Object[])new Object[]{askStatus});
        if (this.isKeyStatusInvalid(askStatus) && SoterCore.hasAppGlobalSecureKey()) {
            SoterCore.removeAppGlobalSecureKey();
        }
        for (int scene : this.scenes) {
            String keyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(scene, (Object)"");
            if (SoterCoreUtil.isNullOrNil((String)keyName)) continue;
            int keyStatus = preferences.getInt(keyName, 0);
            SLogger.d((String)TAG, (String)"soter: %s status: %d", (Object[])new Object[]{keyName, keyStatus});
            if (!this.isKeyStatusInvalid(keyStatus) || !SoterCore.hasAuthKey((String)keyName)) continue;
            SoterCore.removeAuthKey((String)keyName, (boolean)false);
        }
    }

    @Override
    boolean isSingleInstance() {
        return true;
    }

    @Override
    void onRemovedFromTaskPoolActively() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void execute() {
        if (this.isNativeSupport) {
            if (this.getSupportNetWrapper == null) {
                SoterDataCenter.getInstance().setSupportSoter(true);
                SoterDataCenter.getInstance().setInit(true);
                this.callback(new SoterProcessNoExtResult(0));
                return;
            } else {
                String deviceFpKey = SoterCore.generateRemoteCheckRequestParam();
                this.getSupportNetWrapper.setRequest(new IWrapGetSupportNet.GetSupportRequest(deviceFpKey));
                this.getSupportNetWrapper.setCallback(new ISoterNetCallback<IWrapGetSupportNet.GetSupportResult>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void onNetEnd(IWrapGetSupportNet.GetSupportResult callbackDataModel) {
                        if (callbackDataModel != null) {
                            SLogger.i((String)TaskInit.TAG, (String)"soter: got support tag from backend: %b", (Object[])new Object[]{callbackDataModel.isSupport});
                            Class<SoterDataCenter> clazz = SoterDataCenter.class;
                            synchronized (SoterDataCenter.class) {
                                SoterDataCenter.getInstance().setSupportSoter(callbackDataModel.isSupport);
                                SoterDataCenter.getInstance().setInit(true);
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                TaskInit.this.callback(new SoterProcessNoExtResult(0));
                                return;
                            }
                        }
                        SLogger.w((String)TaskInit.TAG, (String)"soter: not return data from remote", (Object[])new Object[0]);
                        Class<SoterDataCenter> clazz = SoterDataCenter.class;
                        synchronized (SoterDataCenter.class) {
                            SoterDataCenter.getInstance().setSupportSoter(false);
                            SoterDataCenter.getInstance().setInit(true);
                            // ** MonitorExit[var2_3] (shouldn't be in output)
                            TaskInit.this.callback(new SoterProcessNoExtResult(8));
                            return;
                        }
                    }
                });
                this.getSupportNetWrapper.execute();
            }
            return;
        }
        this.callback(new SoterProcessNoExtResult(2));
        Class<SoterDataCenter> clazz = SoterDataCenter.class;
        synchronized (SoterDataCenter.class) {
            SoterDataCenter.getInstance().setSupportSoter(false);
            SoterDataCenter.getInstance().setInit(true);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    protected void generateAuthKeyNames(String distinguishSalt, int[] scenes) {
        for (int scene : scenes) {
            String authKeyName = String.format("%suid%d_%s_scene%d", "Wechat", Process.myUid(), SoterCoreUtil.nullAsNil((String)distinguishSalt), scene);
            SoterDataCenter.getInstance().getAuthKeyNames().put(scene, (Object)authKeyName);
        }
    }

    private boolean isKeyStatusInvalid(int keyStatus) {
        return keyStatus == 2 || keyStatus == 1;
    }
}

