/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessCallback;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessResultBase;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;
import com.tencent.soter.wrapper.wrap_task.SoterTaskManager;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;

public abstract class BaseSoterTask
implements SoterProcessErrCode {
    private static final String TAG = "Soter.BaseSoterTask";
    private SoterProcessCallback mCallback;
    private boolean mIsCallbacked = false;

    abstract boolean preExecute();

    abstract boolean isSingleInstance();

    public void setTaskCallback(SoterProcessCallback callback) {
        this.mCallback = callback;
    }

    abstract void onRemovedFromTaskPoolActively();

    abstract void execute();

    synchronized void callback(final SoterProcessResultBase result) {
        if (this.mIsCallbacked) {
            SLogger.w((String)TAG, (String)"soter: warning: already removed the task!", (Object[])new Object[0]);
            return;
        }
        SoterTaskManager.getInstance().removeFromTask(this);
        SoterTaskThread.getInstance().postToMainThread(new Runnable(){

            @Override
            public void run() {
                BaseSoterTask.this.callbackInternal(result);
            }
        });
    }

    private void callbackInternal(SoterProcessResultBase result) {
        if (this.mCallback != null && !this.mIsCallbacked) {
            this.mCallback.onResult(result);
            this.mIsCallbacked = true;
        }
    }

    public boolean isFinished() {
        return this.mIsCallbacked;
    }
}

