/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.core.model.SoterPubKeyModel;
import com.tencent.soter.wrapper.SoterWrapperApi;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessCallback;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessKeyPreparationResult;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;
import com.tencent.soter.wrapper.wrap_key.ISoterKeyGenerateCallback;
import com.tencent.soter.wrapper.wrap_key.SoterKeyGenerateEngine;
import com.tencent.soter.wrapper.wrap_net.ISoterNetCallback;
import com.tencent.soter.wrapper.wrap_net.IWrapUploadKeyNet;
import com.tencent.soter.wrapper.wrap_task.BaseSoterPrepareKeyTask;

public class TaskPrepareAuthKey
extends BaseSoterPrepareKeyTask
implements SoterProcessErrCode {
    private static final String TAG = "Soter.TaskPrepareAuthKey";
    private String mAuthKeyName = null;
    private int mScene = -1;
    private IWrapUploadKeyNet mAuthKeyNetWrapper = null;
    private IWrapUploadKeyNet mASKNetWrapper = null;
    private boolean mIsAutoDeleteWhenAlreadyGenerated = false;
    private boolean mIsAutoPrepareASKWhenNotFound = false;

    public TaskPrepareAuthKey(int scene, IWrapUploadKeyNet authKeyNetWrapper, IWrapUploadKeyNet askNetWrapper, boolean isAutoDeleteWhenAlreadyGenerated, boolean isAutoPrepareASKWhenNotFound) {
        this.mScene = scene;
        this.mAuthKeyNetWrapper = authKeyNetWrapper;
        this.mIsAutoDeleteWhenAlreadyGenerated = isAutoDeleteWhenAlreadyGenerated;
        this.mIsAutoPrepareASKWhenNotFound = isAutoPrepareASKWhenNotFound;
        this.mASKNetWrapper = askNetWrapper;
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    boolean preExecute() {
        if (!SoterDataCenter.getInstance().isInit()) {
            SLogger.w((String)TAG, (String)"soter: not initialized yet", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(1008));
            return true;
        }
        if (!SoterDataCenter.getInstance().isSupportSoter()) {
            SLogger.w((String)TAG, (String)"soter: not support soter", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(2));
            return true;
        }
        this.mAuthKeyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(this.mScene, (Object)"");
        if (SoterCoreUtil.isNullOrNil((String)this.mAuthKeyName)) {
            SLogger.w((String)TAG, (String)"soter: request prepare auth key scene: %d, but key name is not registered. Please make sure you register the scene in init", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(1009, String.format("auth scene %d not initialized in map", this.mScene)));
            return true;
        }
        boolean isASKValid = SoterCore.isAppGlobalSecureKeyValid();
        if (!isASKValid && SoterCore.hasAuthKey((String)this.mAuthKeyName)) {
            SLogger.w((String)TAG, (String)"soter: no ask but has auth key. delete the auth key as well", (Object[])new Object[0]);
            SoterCore.removeAuthKey((String)this.mAuthKeyName, (boolean)false);
        }
        if (!isASKValid && !this.mIsAutoPrepareASKWhenNotFound) {
            SLogger.w((String)TAG, (String)"soter: has not generate app secure key yet and not require to generate it", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(3));
            return true;
        }
        if (SoterCore.hasAuthKey((String)this.mAuthKeyName) && !SoterCore.isAuthKeyValid((String)this.mAuthKeyName, (boolean)true)) {
            SLogger.w((String)TAG, (String)"soter: already has auth key but not valid. delete it already and re-generate", (Object[])new Object[0]);
            return false;
        }
        if (SoterCore.hasAuthKey((String)this.mAuthKeyName) && !this.mIsAutoDeleteWhenAlreadyGenerated) {
            SLogger.i((String)TAG, (String)"soter: already has key. do not need generate again", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(0, SoterCore.getAuthKeyModel((String)this.mAuthKeyName)));
            return true;
        }
        if (this.mAuthKeyNetWrapper == null) {
            SLogger.w((String)TAG, (String)"soter: it is strongly recommended that you provide a net wrapper to check and upload AuthKey validation from server! Please make sure you upload it later", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    boolean isSingleInstance() {
        return true;
    }

    @Override
    void onRemovedFromTaskPoolActively() {
        SLogger.w((String)TAG, (String)"soter: cancelled prepare authkey: %s", (Object[])new Object[]{this.mAuthKeyName});
        SoterCore.removeAuthKey((String)this.mAuthKeyName, (boolean)false);
    }

    @Override
    void execute() {
        if (!SoterCore.isAppGlobalSecureKeyValid() && this.mIsAutoPrepareASKWhenNotFound) {
            SLogger.d((String)TAG, (String)"soter: ask not found, but required to generate it. start generate", (Object[])new Object[0]);
            SoterWrapperApi.prepareAppSecureKey(new SoterProcessCallback<SoterProcessKeyPreparationResult>(){

                @Override
                public void onResult(@NonNull SoterProcessKeyPreparationResult result) {
                    SLogger.d((String)TaskPrepareAuthKey.TAG, (String)"soter: prepare ask end: %s", (Object[])new Object[]{result.toString()});
                    if (result.errCode == 0) {
                        TaskPrepareAuthKey.this.generateAuthKey();
                    } else {
                        TaskPrepareAuthKey.this.callback(result);
                    }
                }
            }, false, this.mASKNetWrapper);
        } else {
            this.generateAuthKey();
        }
    }

    private void generateAuthKey() {
        this.markKeyStatus(this.mAuthKeyName, 1);
        SoterKeyGenerateEngine.SoterKeyGenerateEngineBuilder builder = new SoterKeyGenerateEngine.SoterKeyGenerateEngineBuilder().markGenAuthKey(this.mAuthKeyName, this.mIsAutoDeleteWhenAlreadyGenerated).setKeyGenCallback(new ISoterKeyGenerateCallback(){

            @Override
            public void onError(int errorCode, String errMsg) {
                SLogger.w((String)TaskPrepareAuthKey.TAG, (String)"soter: auth key %s generate failed. errcode: %d, errmsg: %s", (Object[])new Object[]{TaskPrepareAuthKey.this.mAuthKeyName, errorCode, errMsg});
                TaskPrepareAuthKey.this.markKeyStatus(TaskPrepareAuthKey.this.mAuthKeyName, 0);
                TaskPrepareAuthKey.this.callback(new SoterProcessKeyPreparationResult(errorCode, errMsg));
            }

            @Override
            public void onSuccess() {
                SLogger.i((String)TaskPrepareAuthKey.TAG, (String)"soter: auth key generate successfully. start upload", (Object[])new Object[0]);
                if (TaskPrepareAuthKey.this.mAuthKeyNetWrapper != null) {
                    TaskPrepareAuthKey.this.markKeyStatus(TaskPrepareAuthKey.this.mAuthKeyName, 2);
                } else {
                    TaskPrepareAuthKey.this.markKeyStatus(TaskPrepareAuthKey.this.mAuthKeyName, 0);
                }
                TaskPrepareAuthKey.this.startUploadAuthKeyAfterGenerate();
            }
        });
        builder.build().generate();
    }

    private void startUploadAuthKeyAfterGenerate() {
        final SoterPubKeyModel authKeyModel = SoterCore.getAuthKeyModel((String)this.mAuthKeyName);
        if (authKeyModel == null) {
            SLogger.e((String)TAG, (String)"soter: auth key model is null even after generation. fatal error", (Object[])new Object[0]);
            SoterCore.removeAuthKey((String)this.mAuthKeyName, (boolean)false);
            this.callback(new SoterProcessKeyPreparationResult(1006, "auth key model is null even after generation."));
            return;
        }
        if (this.mAuthKeyNetWrapper != null) {
            this.mAuthKeyNetWrapper.setRequest(new IWrapUploadKeyNet.UploadRequest(authKeyModel.getSignature(), authKeyModel.getRawJson()));
            this.mAuthKeyNetWrapper.setCallback(new ISoterNetCallback<IWrapUploadKeyNet.UploadResult>(){

                @Override
                public void onNetEnd(IWrapUploadKeyNet.UploadResult callbackDataModel) {
                    TaskPrepareAuthKey.this.markKeyStatus(TaskPrepareAuthKey.this.mAuthKeyName, 0);
                    boolean isUploadAndVerified = callbackDataModel.mIsUploadAndVerifiedSuccess;
                    SLogger.i((String)TaskPrepareAuthKey.TAG, (String)"soter: auth key upload result: %b", (Object[])new Object[]{isUploadAndVerified});
                    if (isUploadAndVerified) {
                        TaskPrepareAuthKey.this.callback(new SoterProcessKeyPreparationResult(0, authKeyModel));
                    } else {
                        SoterCore.removeAuthKey((String)TaskPrepareAuthKey.this.mAuthKeyName, (boolean)false);
                        TaskPrepareAuthKey.this.callback(new SoterProcessKeyPreparationResult(1004, String.format("upload auth key: %s failed", TaskPrepareAuthKey.this.mAuthKeyName)));
                    }
                }
            });
            this.mAuthKeyNetWrapper.execute();
        } else {
            SLogger.d((String)TAG, (String)"soter: not provide network wrapper instance. please check if it is what you want. we treat it as normal", (Object[])new Object[0]);
            this.callback(new SoterProcessKeyPreparationResult(0, "treat as normal because you do not provide the net wrapper", authKeyModel));
        }
    }
}

