/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.tencent.soter.core.model.SLogger;

public class SoterTaskThread {
    private static final String TAG = "Soter.SoterTaskThread";
    private static final String HANDLER_THREAD_NAME = "SoterGenKeyHandlerThreadName";
    private static volatile SoterTaskThread mInstance = null;
    private HandlerThread mTaskHandlerThread;
    private Handler mTaskHandler = null;
    private Handler mMainLooperHandler = null;

    private SoterTaskThread() {
        if (this.mTaskHandlerThread == null) {
            this.mTaskHandlerThread = new HandlerThread(HANDLER_THREAD_NAME);
            this.mTaskHandlerThread.start();
            Looper taskLooper = this.mTaskHandlerThread.getLooper();
            if (taskLooper != null) {
                this.mTaskHandler = new Handler(this.mTaskHandlerThread.getLooper());
            } else {
                SLogger.e((String)TAG, (String)"soter: task looper is null! use main looper as the task looper", (Object[])new Object[0]);
                this.mTaskHandler = new Handler(Looper.getMainLooper());
            }
        }
        this.mMainLooperHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoterTaskThread getInstance() {
        if (mInstance == null) {
            Class<SoterTaskThread> clazz = SoterTaskThread.class;
            synchronized (SoterTaskThread.class) {
                if (mInstance == null) {
                    mInstance = new SoterTaskThread();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return mInstance;
            }
        }
        return mInstance;
    }

    public void setTaskHandlerThread(HandlerThread handlerThread) {
        if (this.mTaskHandlerThread != null && this.mTaskHandlerThread.isAlive()) {
            SLogger.i((String)TAG, (String)"quit the previous thread", (Object[])new Object[0]);
            this.mTaskHandlerThread.quit();
        }
        this.mTaskHandlerThread = handlerThread;
        this.mTaskHandlerThread.setName(HANDLER_THREAD_NAME);
        if (!handlerThread.isAlive()) {
            handlerThread.start();
        }
        this.mTaskHandler = new Handler(this.mTaskHandlerThread.getLooper());
    }

    public void postToWorker(Runnable task) {
        this.mTaskHandler.post(task);
    }

    public void postToWorkerDelayed(Runnable task, long delayInMs) {
        this.mTaskHandler.postDelayed(task, delayInMs);
    }

    public void postToMainThread(Runnable task) {
        this.mMainLooperHandler.post(task);
    }

    public void postToMainThreadDelayed(Runnable task, long delayInMs) {
        this.mMainLooperHandler.postDelayed(task, delayInMs);
    }
}

