/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.util.SparseArray;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessResultBase;
import com.tencent.soter.wrapper.wrap_core.SoterProcessErrCode;
import com.tencent.soter.wrapper.wrap_task.AuthCancellationCallable;
import com.tencent.soter.wrapper.wrap_task.BaseSoterTask;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;

public class SoterTaskManager
implements SoterProcessErrCode {
    private static final String TAG = "Soter.SoterTaskManager";
    private static volatile SoterTaskManager sInstance = null;
    private static volatile SparseArray<BaseSoterTask> sTaskPool = null;
    private final Object mTaskPoolLock = new Object();

    private SoterTaskManager() {
        sTaskPool = new SparseArray(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SoterTaskManager getInstance() {
        if (sInstance == null) {
            Class<SoterTaskManager> clazz = SoterTaskManager.class;
            synchronized (SoterTaskManager.class) {
                if (sInstance == null) {
                    sInstance = new SoterTaskManager();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToTask(final BaseSoterTask task, SoterProcessResultBase instanceOnError) {
        if (task == null) {
            SLogger.e((String)TAG, (String)"soter: task is null. should not happen", (Object[])new Object[0]);
            return false;
        }
        if (instanceOnError == null) {
            SLogger.e((String)TAG, (String)"soter: instanceOnError is null. should not happen", (Object[])new Object[0]);
            return false;
        }
        boolean isEat = task.preExecute();
        if (!isEat) {
            int taskClassIndex = task.hashCode();
            if (!task.isSingleInstance()) {
                SLogger.i((String)TAG, (String)"soter: not single instance. directly execute", (Object[])new Object[0]);
                Object object = this.mTaskPoolLock;
                synchronized (object) {
                    sTaskPool.put(taskClassIndex, (Object)task);
                }
                SoterTaskThread.getInstance().postToWorker(new Runnable(){

                    @Override
                    public void run() {
                        task.execute();
                    }
                });
                return true;
            }
            Object object = this.mTaskPoolLock;
            synchronized (object) {
                for (int i = 0; i < sTaskPool.size(); ++i) {
                    int key = sTaskPool.keyAt(i);
                    if (sTaskPool.get(key) == null || !((BaseSoterTask)sTaskPool.get(key)).getClass().getName().equals(task.getClass().getName())) continue;
                    SLogger.w((String)TAG, (String)"soter: already such type of task. abandon add task", (Object[])new Object[0]);
                    instanceOnError.setErrCode(1023);
                    instanceOnError.setErrMsg("add SOTER task to queue failed. check the logcat for further information");
                    task.callback(instanceOnError);
                    return false;
                }
                sTaskPool.put(taskClassIndex, (Object)task);
            }
            SoterTaskThread.getInstance().postToWorker(new Runnable(){

                @Override
                public void run() {
                    task.execute();
                }
            });
            return true;
        }
        SLogger.d((String)TAG, (String)"soter: prepare eat execute.", (Object[])new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTask() {
        Object object = this.mTaskPoolLock;
        synchronized (object) {
            SLogger.i((String)TAG, (String)"soter: request cancel all", (Object[])new Object[0]);
            if (sTaskPool.size() != 0) {
                for (int i = 0; i < sTaskPool.size(); ++i) {
                    final int key = sTaskPool.keyAt(i);
                    SoterTaskThread.getInstance().postToWorker(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = SoterTaskManager.this.mTaskPoolLock;
                            synchronized (object) {
                                BaseSoterTask task = (BaseSoterTask)sTaskPool.get(key);
                                if (task != null) {
                                    task.onRemovedFromTaskPoolActively();
                                }
                            }
                        }
                    });
                }
            }
            sTaskPool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromTask(BaseSoterTask task) {
        SLogger.i((String)TAG, (String)"soter: removing task: %d", (Object[])new Object[]{task != null ? Integer.valueOf(task.hashCode()) : "null"});
        if (task == null) {
            SLogger.e((String)TAG, (String)"soter: task is null", (Object[])new Object[0]);
            return;
        }
        Object object = this.mTaskPoolLock;
        synchronized (object) {
            if (sTaskPool.get(task.hashCode()) == null) {
                SLogger.i((String)TAG, (String)"soter: no such task: %d. maybe this task did not pass preExecute", (Object[])new Object[]{task.hashCode()});
            } else {
                sTaskPool.remove(task.hashCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishAuthCancellation() {
        Object object = this.mTaskPoolLock;
        synchronized (object) {
            SLogger.i((String)TAG, (String)"soter: request publish cancellation", (Object[])new Object[0]);
            if (sTaskPool.size() != 0) {
                for (int i = 0; i < sTaskPool.size(); ++i) {
                    final int key = sTaskPool.keyAt(i);
                    SoterTaskThread.getInstance().postToWorker(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            BaseSoterTask task = null;
                            Object object = SoterTaskManager.this.mTaskPoolLock;
                            synchronized (object) {
                                task = (BaseSoterTask)sTaskPool.get(key);
                            }
                            if (task != null && task instanceof AuthCancellationCallable && !((AuthCancellationCallable)((Object)task)).isCancelled()) {
                                ((AuthCancellationCallable)((Object)task)).callCancellationInternal();
                            }
                        }
                    });
                }
            }
        }
    }
}

