/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.soter.wrapper.wrap_task;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.tencent.soter.core.SoterCore;
import com.tencent.soter.core.fingerprint.FingerprintManagerCompat;
import com.tencent.soter.core.model.SLogger;
import com.tencent.soter.core.model.SoterCoreUtil;
import com.tencent.soter.core.model.SoterSignatureResult;
import com.tencent.soter.soterserver.SoterSessionResult;
import com.tencent.soter.wrapper.SoterWrapperApi;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessAuthenticationResult;
import com.tencent.soter.wrapper.wrap_callback.SoterProcessResultBase;
import com.tencent.soter.wrapper.wrap_core.RemoveASKStrategy;
import com.tencent.soter.wrapper.wrap_core.SoterDataCenter;
import com.tencent.soter.wrapper.wrap_fingerprint.SoterFingerprintCanceller;
import com.tencent.soter.wrapper.wrap_fingerprint.SoterFingerprintStateCallback;
import com.tencent.soter.wrapper.wrap_net.ISoterNetCallback;
import com.tencent.soter.wrapper.wrap_net.IWrapGetChallengeStr;
import com.tencent.soter.wrapper.wrap_net.IWrapUploadSignature;
import com.tencent.soter.wrapper.wrap_task.AuthCancellationCallable;
import com.tencent.soter.wrapper.wrap_task.AuthenticationParam;
import com.tencent.soter.wrapper.wrap_task.BaseSoterTask;
import com.tencent.soter.wrapper.wrap_task.SoterTaskThread;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.security.Signature;
import java.security.SignatureException;
import junit.framework.Assert;

@Deprecated
public class TaskAuthentication
extends BaseSoterTask
implements AuthCancellationCallable {
    private static final String TAG = "Soter.TaskAuthentication";
    private int mScene = -1;
    private String mAuthKeyName = null;
    private String mChallenge = null;
    private IWrapGetChallengeStr mGetChallengeStrWrapper = null;
    private IWrapUploadSignature mUploadSignatureWrapper = null;
    private WeakReference<Context> mContextWeakReference = null;
    private SoterFingerprintCanceller mFingerprintCancelSignal = null;
    private SoterFingerprintStateCallback mFingerprintStateCallback = null;
    private SoterSignatureResult mFinalResult = null;
    private AuthenticationCallbackImpl mAuthenticationCallbackIml = null;
    private boolean mShouldOperateCompatWhenHint = Build.VERSION.SDK_INT < 23 && Build.MANUFACTURER.equalsIgnoreCase("vivo");
    private boolean mShouldOperateCompatWhenDone = Build.VERSION.SDK_INT < 23;
    private boolean mIsAuthenticationAlreadyCancelled = false;

    public TaskAuthentication(AuthenticationParam param) {
        if (param == null) {
            throw new IllegalArgumentException("param is null!");
        }
        this.mScene = param.getScene();
        this.mGetChallengeStrWrapper = param.getIWrapGetChallengeStr();
        this.mUploadSignatureWrapper = param.getIWrapUploadSignature();
        this.mContextWeakReference = new WeakReference<Context>(param.getContext());
        this.mFingerprintStateCallback = param.getSoterFingerprintStateCallback();
        this.mFingerprintCancelSignal = param.getFingerprintCanceller();
        this.mChallenge = param.getChallenge();
    }

    @Override
    @SuppressLint(value={"DefaultLocale", "NewApi"})
    boolean preExecute() {
        if (!SoterDataCenter.getInstance().isInit()) {
            SLogger.w((String)TAG, (String)"soter: not initialized yet", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1008));
            return true;
        }
        if (!SoterDataCenter.getInstance().isSupportSoter()) {
            SLogger.w((String)TAG, (String)"soter: not support soter", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(2));
            return true;
        }
        Assert.assertTrue((Build.VERSION.SDK_INT >= 16 ? 1 : 0) != 0);
        this.mAuthKeyName = (String)SoterDataCenter.getInstance().getAuthKeyNames().get(this.mScene, (Object)"");
        if (SoterCoreUtil.isNullOrNil((String)this.mAuthKeyName)) {
            SLogger.w((String)TAG, (String)"soter: request prepare auth key scene: %d, but key name is not registered. Please make sure you register the scene in init", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1009, String.format("auth scene %d not initialized in map", this.mScene)));
            return true;
        }
        if (!SoterCore.hasAuthKey((String)this.mAuthKeyName)) {
            SLogger.w((String)TAG, (String)"soter: auth key %s not exists. need re-generate", (Object[])new Object[]{this.mAuthKeyName});
            this.callback(new SoterProcessAuthenticationResult(1006, String.format("the auth key to scene %d not exists. it may because you haven't prepare it, or user removed them already in system settings. please prepare the key again", this.mScene)));
            return true;
        }
        if (this.mGetChallengeStrWrapper == null && SoterCoreUtil.isNullOrNil((String)this.mChallenge)) {
            SLogger.w((String)TAG, (String)"soter: challenge wrapper is null!", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1010, "neither get challenge wrapper nor challenge str is found in request parameter"));
            return true;
        }
        Context context = (Context)this.mContextWeakReference.get();
        if (context == null) {
            SLogger.w((String)TAG, (String)"soter: context instance released in preExecute", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1011));
            return true;
        }
        boolean hasFingerprints = FingerprintManagerCompat.from((Context)context).hasEnrolledFingerprints();
        if (!hasFingerprints) {
            SLogger.w((String)TAG, (String)"soter: user has not enrolled any fingerprint in system.", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1012));
            return true;
        }
        if (SoterCore.isCurrentFingerprintFrozen((Context)context)) {
            SLogger.w((String)TAG, (String)"soter: fingerprint sensor frozen", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1021, "Too many failed times"));
            return true;
        }
        if (this.mFingerprintCancelSignal == null) {
            SLogger.w((String)TAG, (String)"soter: did not pass cancellation obj. We suggest you pass one", (Object[])new Object[0]);
            this.mFingerprintCancelSignal = new SoterFingerprintCanceller();
            return false;
        }
        if (this.mUploadSignatureWrapper == null) {
            SLogger.w((String)TAG, (String)"hy: we strongly recommend you to check the final authentication data in server! Please make sure you upload and check later", (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    boolean isSingleInstance() {
        return true;
    }

    @Override
    @RequiresApi(api=16)
    void onRemovedFromTaskPoolActively() {
        if (this.mFingerprintCancelSignal != null) {
            this.mFingerprintCancelSignal.asyncCancelFingerprintAuthentication();
        }
    }

    @Override
    @RequiresApi(api=16)
    void execute() {
        if (SoterCoreUtil.isNullOrNil((String)this.mChallenge)) {
            SLogger.i((String)TAG, (String)"soter: not provide the challenge. we will do the job", (Object[])new Object[0]);
            this.mGetChallengeStrWrapper.setRequest(new IWrapGetChallengeStr.GetChallengeRequest());
            this.mGetChallengeStrWrapper.setCallback(new ISoterNetCallback<IWrapGetChallengeStr.GetChallengeResult>(){

                @Override
                public void onNetEnd(IWrapGetChallengeStr.GetChallengeResult callbackDataModel) {
                    if (callbackDataModel != null && !SoterCoreUtil.isNullOrNil((String)callbackDataModel.challenge)) {
                        TaskAuthentication.this.mChallenge = callbackDataModel.challenge;
                        TaskAuthentication.this.startAuthenticate();
                    } else {
                        SLogger.w((String)TaskAuthentication.TAG, (String)"soter: get challenge failed", (Object[])new Object[0]);
                        TaskAuthentication.this.callback(new SoterProcessAuthenticationResult(1014));
                    }
                }
            });
            this.mGetChallengeStrWrapper.execute();
        } else {
            SLogger.i((String)TAG, (String)"soter: already provided the challenge. directly authenticate", (Object[])new Object[0]);
            this.startAuthenticate();
        }
    }

    @Override
    void onExecuteCallback(SoterProcessResultBase result) {
        if ((result.getErrCode() == 1018 || result.getErrCode() == 1007 || result.getErrCode() == 1015) && RemoveASKStrategy.shouldRemoveAllKey(this.getClass(), result)) {
            SLogger.i((String)TAG, (String)"soter: same error happen too much, delete ask", (Object[])new Object[0]);
            SoterWrapperApi.clearAllKey();
        }
    }

    @RequiresApi(api=16)
    private void startAuthenticate() {
        if (SoterCore.getSoterCoreType() == 1) {
            SoterSessionResult soterSessionResult = SoterCore.initSigh((String)this.mAuthKeyName, (String)this.mChallenge);
            if (soterSessionResult == null) {
                SLogger.w((String)TAG, (String)"soter: error occurred when init sign soterSessionResult is null", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(1007));
                return;
            }
            if (soterSessionResult.resultCode != 0) {
                SLogger.w((String)TAG, (String)"soter: error occurred when init sign resultCode error", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(1007));
                return;
            }
            SLogger.d((String)TAG, (String)"soter: session is %d", (Object[])new Object[]{soterSessionResult.session});
            this.mAuthenticationCallbackIml = new AuthenticationCallbackImpl(null);
            this.mAuthenticationCallbackIml.session = soterSessionResult.session;
            this.performStartFingerprintLogic(null);
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskAuthentication.this.mFingerprintStateCallback != null) {
                        TaskAuthentication.this.mFingerprintStateCallback.onStartAuthentication();
                    }
                }
            });
        } else {
            Signature signatureToAuth = SoterCore.getAuthInitAndSign((String)this.mAuthKeyName);
            if (signatureToAuth == null) {
                SLogger.w((String)TAG, (String)"soter: error occurred when init sign", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(1007));
                return;
            }
            this.mAuthenticationCallbackIml = new AuthenticationCallbackImpl(signatureToAuth);
            this.performStartFingerprintLogic(signatureToAuth);
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskAuthentication.this.mFingerprintStateCallback != null) {
                        TaskAuthentication.this.mFingerprintStateCallback.onStartAuthentication();
                    }
                }
            });
        }
    }

    @SuppressLint(value={"NewApi"})
    private void performStartFingerprintLogic(Signature signatureToAuth) {
        if (this.isFinished()) {
            SLogger.w((String)TAG, (String)"soter: already finished. can not authenticate", (Object[])new Object[0]);
            return;
        }
        Context context = (Context)this.mContextWeakReference.get();
        if (context == null) {
            SLogger.w((String)TAG, (String)"soter: context instance released in startAuthenticate", (Object[])new Object[0]);
            this.callback(new SoterProcessAuthenticationResult(1011));
            return;
        }
        try {
            SLogger.v((String)TAG, (String)"soter: performing start", (Object[])new Object[0]);
            FingerprintManagerCompat.from((Context)context).authenticate(new FingerprintManagerCompat.CryptoObject(signatureToAuth), 0, this.mFingerprintCancelSignal != null ? this.mFingerprintCancelSignal.getSignalObj() : null, (FingerprintManagerCompat.AuthenticationCallback)this.mAuthenticationCallbackIml, null);
        }
        catch (Exception e) {
            String cause = e.getMessage();
            SLogger.e((String)TAG, (String)"soter: caused exception when authenticating: %s", (Object[])new Object[]{cause});
            SLogger.printErrStackTrace((String)TAG, (Throwable)e, (String)"soter: caused exception when authenticating");
            this.callback(new SoterProcessAuthenticationResult(1015, String.format("start authentication failed due to %s", cause)));
        }
    }

    private void executeWhenAuthenticatedWithSession(@NonNull Signature signature, long session) {
        try {
            byte[] rawResult = SoterCore.finishSign((long)session);
            this.mFinalResult = SoterCore.convertFromBytesToSignatureResult((byte[])rawResult);
            if (this.mUploadSignatureWrapper != null) {
                this.uploadSignature();
            } else {
                SLogger.i((String)TAG, (String)"soter: no upload wrapper, return directly", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(0, this.mFinalResult));
            }
        }
        catch (Exception e) {
            SLogger.e((String)TAG, (String)"soter: finish sign failed due to exception: %s", (Object[])new Object[]{e.getMessage()});
            SLogger.printErrStackTrace((String)TAG, (Throwable)e, (String)"soter: sign failed due to exception");
            this.callback(new SoterProcessAuthenticationResult(1018, "sign failed even after user authenticated the key."));
        }
    }

    private void executeWhenAuthenticated(@NonNull Signature signature) {
        try {
            this.mFinalResult = SoterCore.convertFromBytesToSignatureResult((byte[])signature.sign());
            if (this.mUploadSignatureWrapper != null) {
                this.uploadSignature();
            } else {
                SLogger.i((String)TAG, (String)"soter: no upload wrapper, return directly", (Object[])new Object[0]);
                this.callback(new SoterProcessAuthenticationResult(0, this.mFinalResult));
            }
        }
        catch (SignatureException e) {
            SLogger.e((String)TAG, (String)"soter: sign failed due to exception: %s", (Object[])new Object[]{e.getMessage()});
            SLogger.printErrStackTrace((String)TAG, (Throwable)e, (String)"soter: sign failed due to exception");
            this.callback(new SoterProcessAuthenticationResult(1018, "sign failed even after user authenticated the key."));
        }
    }

    private void uploadSignature() {
        if (this.mFinalResult == null) {
            this.callback(new SoterProcessAuthenticationResult(1018, "sign failed even after user authenticated the key."));
            return;
        }
        this.mUploadSignatureWrapper.setRequest(new IWrapUploadSignature.UploadSignatureRequest(this.mFinalResult.getSignature(), this.mFinalResult.getJsonValue(), this.mFinalResult.getSaltLen()));
        this.mUploadSignatureWrapper.setCallback(new ISoterNetCallback<IWrapUploadSignature.UploadSignatureResult>(){

            @Override
            public void onNetEnd(IWrapUploadSignature.UploadSignatureResult callbackDataModel) {
                if (callbackDataModel != null && callbackDataModel.isVerified) {
                    SLogger.i((String)TaskAuthentication.TAG, (String)"soter: upload and verify succeed", (Object[])new Object[0]);
                    TaskAuthentication.this.callback(new SoterProcessAuthenticationResult(0, TaskAuthentication.this.mFinalResult));
                } else {
                    SLogger.w((String)TaskAuthentication.TAG, (String)"soter: upload or verify failed", (Object[])new Object[0]);
                    TaskAuthentication.this.callback(new SoterProcessAuthenticationResult(1019));
                }
            }
        });
        this.mUploadSignatureWrapper.execute();
    }

    @Override
    public void callCancellationInternal() {
        SLogger.i((String)TAG, (String)"soter: called from cancellation signal", (Object[])new Object[0]);
        if (this.mAuthenticationCallbackIml != null) {
            this.mAuthenticationCallbackIml.onAuthenticationCancelled();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mIsAuthenticationAlreadyCancelled;
    }

    private class AuthenticationCallbackImpl
    extends FingerprintManagerCompat.AuthenticationCallback {
        private Signature mSignatureToAuth = null;
        private static final long MAGIC_CANCELLATION_WAIT = 1000L;
        private long session;

        private AuthenticationCallbackImpl(Signature signature) {
            this.mSignatureToAuth = signature;
        }

        private String charSequenceToStringNullAsNil(CharSequence sequence) {
            return sequence == null ? "unknown error" : sequence.toString();
        }

        public void onAuthenticationError(final int errMsgId, final CharSequence errString) {
            SLogger.e((String)TaskAuthentication.TAG, (String)"soter: on authentication fatal error: %d, %s", (Object[])new Object[]{errMsgId, errString});
            if (errMsgId != 10308) {
                SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        if (TaskAuthentication.this.mFingerprintStateCallback != null) {
                            TaskAuthentication.this.mFingerprintStateCallback.onAuthenticationError(errMsgId, errString);
                        }
                    }
                });
                TaskAuthentication.this.callback(new SoterProcessAuthenticationResult(1016, this.charSequenceToStringNullAsNil(errString)));
            } else {
                TaskAuthentication.this.callback(new SoterProcessAuthenticationResult(1021, this.charSequenceToStringNullAsNil(errString)));
            }
            this.compatLogicWhenDone();
        }

        public void onAuthenticationHelp(final int helpMsgId, final CharSequence helpString) {
            SLogger.w((String)TaskAuthentication.TAG, (String)"soter: on authentication help. you do not need to cancel the authentication: %d, %s", (Object[])new Object[]{helpMsgId, helpString});
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskAuthentication.this.mFingerprintStateCallback != null) {
                        TaskAuthentication.this.mFingerprintStateCallback.onAuthenticationHelp(helpMsgId, AuthenticationCallbackImpl.this.charSequenceToStringNullAsNil(helpString));
                    }
                }
            });
        }

        public void onAuthenticationSucceeded(FingerprintManagerCompat.AuthenticationResult result) {
            SLogger.i((String)TaskAuthentication.TAG, (String)"soter: authentication succeed. start sign and upload upload signature", (Object[])new Object[0]);
            SoterTaskThread.getInstance().postToWorker(new Runnable(){

                @Override
                public void run() {
                    if (!SoterCoreUtil.isNullOrNil((String)TaskAuthentication.this.mChallenge)) {
                        if (SoterCore.getSoterCoreType() == 1) {
                            TaskAuthentication.this.executeWhenAuthenticatedWithSession(AuthenticationCallbackImpl.this.mSignatureToAuth, AuthenticationCallbackImpl.this.session);
                        } else {
                            try {
                                AuthenticationCallbackImpl.this.mSignatureToAuth.update(TaskAuthentication.this.mChallenge.getBytes(Charset.forName("UTF-8")));
                            }
                            catch (SignatureException e) {
                                SLogger.e((String)TaskAuthentication.TAG, (String)"soter: exception in update", (Object[])new Object[0]);
                                SLogger.printErrStackTrace((String)TaskAuthentication.TAG, (Throwable)e, (String)"soter: exception in update");
                                SLogger.e((String)TaskAuthentication.TAG, (String)"soter: remove the auth key: %s", (Object[])new Object[]{TaskAuthentication.this.mAuthKeyName});
                                SoterCore.removeAuthKey((String)TaskAuthentication.this.mAuthKeyName, (boolean)false);
                                TaskAuthentication.this.callback(new SoterProcessAuthenticationResult(1027, "update signature failed. authkey removed after this failure, please check"));
                            }
                            try {
                                TaskAuthentication.this.executeWhenAuthenticated(AuthenticationCallbackImpl.this.mSignatureToAuth);
                            }
                            catch (Exception e) {
                                SLogger.e((String)TaskAuthentication.TAG, (String)"soter: exception in executeWhenAuthenticated method", (Object[])new Object[0]);
                                SLogger.printErrStackTrace((String)TaskAuthentication.TAG, (Throwable)e, (String)"soter: exception when execute");
                                AuthenticationCallbackImpl.this.onAuthenticationError(-1000, "execute failed");
                            }
                        }
                    } else {
                        SLogger.e((String)TaskAuthentication.TAG, (String)"soter: challenge is null. should not happen here", (Object[])new Object[0]);
                        AuthenticationCallbackImpl.this.onAuthenticationError(-1000, "challenge is null");
                    }
                }
            });
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskAuthentication.this.mFingerprintStateCallback != null) {
                        TaskAuthentication.this.mFingerprintStateCallback.onAuthenticationSucceed();
                    }
                }
            });
            this.compatLogicWhenDone();
        }

        public void onAuthenticationFailed() {
            super.onAuthenticationFailed();
            SLogger.w((String)TaskAuthentication.TAG, (String)"soter: authentication failed once", (Object[])new Object[0]);
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskAuthentication.this.mFingerprintStateCallback != null) {
                        TaskAuthentication.this.mFingerprintStateCallback.onAuthenticationFailed();
                    }
                }
            });
            this.compatLogicWhenFail();
        }

        public void onAuthenticationCancelled() {
            SLogger.i((String)TaskAuthentication.TAG, (String)"soter: called onAuthenticationCancelled", (Object[])new Object[0]);
            if (TaskAuthentication.this.mIsAuthenticationAlreadyCancelled) {
                SLogger.v((String)TaskAuthentication.TAG, (String)"soter: during ignore cancel period", (Object[])new Object[0]);
                return;
            }
            super.onAuthenticationCancelled();
            SoterTaskThread.getInstance().postToMainThread(new Runnable(){

                @Override
                public void run() {
                    if (TaskAuthentication.this.mFingerprintStateCallback != null) {
                        TaskAuthentication.this.mFingerprintStateCallback.onAuthenticationCancelled();
                    }
                }
            });
            TaskAuthentication.this.callback(new SoterProcessAuthenticationResult(1020, "user cancelled authentication"));
            this.compatLogicWhenDone();
        }

        @SuppressLint(value={"NewApi"})
        private void compatLogicWhenFail() {
            if (TaskAuthentication.this.mShouldOperateCompatWhenHint) {
                SLogger.i((String)TaskAuthentication.TAG, (String)"soter: should compat lower android version logic.", (Object[])new Object[0]);
                TaskAuthentication.this.mFingerprintCancelSignal.asyncCancelFingerprintAuthenticationInnerImp(false);
                SoterTaskThread.getInstance().postToWorker(new Runnable(){

                    @Override
                    public void run() {
                        TaskAuthentication.this.mFingerprintCancelSignal.refreshCancellationSignal();
                    }
                });
                SoterTaskThread.getInstance().postToWorkerDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TaskAuthentication.this.performStartFingerprintLogic(AuthenticationCallbackImpl.this.mSignatureToAuth);
                    }
                }, 1000L);
            }
        }

        @SuppressLint(value={"NewApi"})
        private void compatLogicWhenDone() {
            if (TaskAuthentication.this.mShouldOperateCompatWhenDone) {
                TaskAuthentication.this.mFingerprintCancelSignal.asyncCancelFingerprintAuthenticationInnerImp(false);
                TaskAuthentication.this.mIsAuthenticationAlreadyCancelled = true;
            }
        }
    }
}

