/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.JSONObject;
import apijson.JSONRequest;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.AbstractSQLExecutor;
import apijson.orm.AbstractVerifier;
import apijson.orm.Entry;
import apijson.orm.Join;
import apijson.orm.ObjectParser;
import apijson.orm.Operation;
import apijson.orm.Pair;
import apijson.orm.Parser;
import apijson.orm.ParserCreator;
import apijson.orm.SQLConfig;
import apijson.orm.SQLCreator;
import apijson.orm.SQLExecutor;
import apijson.orm.Subquery;
import apijson.orm.Verifier;
import apijson.orm.VerifierCreator;
import apijson.orm.Visitor;
import apijson.orm.exception.CommonException;
import apijson.orm.exception.ConflictException;
import apijson.orm.exception.UnsupportedDataTypeException;
import com.alibaba.fastjson.JSONArray;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;

public abstract class AbstractParser<T>
implements Parser<T>,
ParserCreator<T>,
VerifierCreator<T>,
SQLCreator {
    protected static final String TAG = "AbstractParser";
    protected Map<Object, Map<String, Object>> keyObjectAttributesMap = new HashMap<Object, Map<String, Object>>();
    public static boolean IS_PRINT_REQUEST_STRING_LOG = false;
    public static boolean IS_PRINT_BIG_LOG = false;
    public static boolean IS_PRINT_REQUEST_ENDTIME_LOG = false;
    public static int DEFAULT_QUERY_COUNT = 10;
    public static int MAX_QUERY_PAGE = 100;
    public static int MAX_QUERY_COUNT = 100;
    public static int MAX_UPDATE_COUNT = 10;
    public static int MAX_SQL_COUNT = 200;
    public static int MAX_OBJECT_COUNT = 5;
    public static int MAX_ARRAY_COUNT = 5;
    public static int MAX_QUERY_DEPTH = 5;
    protected boolean isRoot = true;
    public static final String KEY_REF = "Reference";
    protected Map<String, String> warnMap = new LinkedHashMap<String, String>();
    @NotNull
    protected Visitor<T> visitor;
    protected RequestMethod requestMethod;
    protected int version;
    protected String tag;
    protected String requestURL;
    protected com.alibaba.fastjson.JSONObject requestObject;
    protected Boolean globalFormat;
    protected String globalRole;
    protected String globalDatabase;
    protected String globalSchema;
    protected String globalDatasource;
    protected Boolean globalExplain;
    protected String globalCache;
    protected boolean needVerifyLogin;
    protected boolean needVerifyRole;
    protected boolean needVerifyContent;
    protected SQLExecutor sqlExecutor;
    protected Verifier<T> verifier;
    protected Map<String, Object> queryResultMap;
    private int queryDepth;
    private long executedSQLDuration;
    protected Map<String, ObjectParser> arrayObjectParserCacheMap = new HashMap<String, ObjectParser>();
    private static final List<String> JOIN_COPY_KEY_LIST = new ArrayList<String>();
    public static final String KEY_CONFIG = "config";
    public static final String KEY_SQL = "sql";
    protected Map<String, List<com.alibaba.fastjson.JSONObject>> arrayMainCacheMap = new HashMap<String, List<com.alibaba.fastjson.JSONObject>>();
    private int transactionIsolation = 0;

    @Override
    public int getDefaultQueryCount() {
        return DEFAULT_QUERY_COUNT;
    }

    @Override
    public int getMaxQueryPage() {
        return MAX_QUERY_PAGE;
    }

    @Override
    public int getMaxQueryCount() {
        return MAX_QUERY_COUNT;
    }

    @Override
    public int getMaxUpdateCount() {
        return MAX_UPDATE_COUNT;
    }

    @Override
    public int getMaxSQLCount() {
        return MAX_SQL_COUNT;
    }

    @Override
    public int getMaxObjectCount() {
        return MAX_OBJECT_COUNT;
    }

    @Override
    public int getMaxArrayCount() {
        return MAX_ARRAY_COUNT;
    }

    @Override
    public int getMaxQueryDepth() {
        return MAX_QUERY_DEPTH;
    }

    public AbstractParser() {
        this(null);
    }

    public AbstractParser(RequestMethod method) {
        this.setMethod(method);
        this.setNeedVerifyRole(AbstractVerifier.ENABLE_VERIFY_ROLE);
        this.setNeedVerifyContent(AbstractVerifier.ENABLE_VERIFY_CONTENT);
    }

    public AbstractParser(RequestMethod method, boolean needVerify) {
        this.setMethod(method);
        this.setNeedVerify(needVerify);
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public AbstractParser<T> setRoot(boolean isRoot) {
        this.isRoot = isRoot;
        return this;
    }

    public String getWarn(String type) {
        return this.warnMap == null ? null : this.warnMap.get(type);
    }

    public AbstractParser<T> putWarnIfNeed(String type, String warn) {
        String w;
        if (Log.DEBUG && StringUtil.isEmpty(w = this.getWarn(type), true)) {
            this.putWarn(type, warn);
        }
        return this;
    }

    public AbstractParser<T> putWarn(String type, String warn) {
        if (this.warnMap == null) {
            this.warnMap = new LinkedHashMap<String, String>();
        }
        this.warnMap.put(type, warn);
        return this;
    }

    public String getWarnString() {
        Set<Map.Entry<String, String>> set;
        Set<Map.Entry<String, String>> set2 = set = this.warnMap == null ? null : this.warnMap.entrySet();
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : set) {
            String k = e == null ? null : e.getKey();
            String v = k == null ? null : e.getValue();
            if (StringUtil.isEmpty(v, true)) continue;
            if (StringUtil.isNotEmpty(k, true)) {
                sb.append("[" + k + "]: ");
            }
            sb.append(v + "; ");
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public Visitor<T> getVisitor() {
        if (this.visitor == null) {
            this.visitor = new Visitor<T>(){

                @Override
                public T getId() {
                    return null;
                }

                @Override
                public List<T> getContactIdList() {
                    return null;
                }
            };
        }
        return this.visitor;
    }

    @Override
    public AbstractParser<T> setVisitor(@NotNull Visitor<T> visitor) {
        this.visitor = visitor;
        return this;
    }

    @Override
    @NotNull
    public RequestMethod getMethod() {
        return this.requestMethod;
    }

    @Override
    @NotNull
    public AbstractParser<T> setMethod(RequestMethod method) {
        this.requestMethod = method == null ? RequestMethod.GET : method;
        this.transactionIsolation = RequestMethod.isQueryMethod(method) ? 0 : 4;
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public AbstractParser<T> setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public AbstractParser<T> setTag(String tag) {
        this.tag = tag;
        return this;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public AbstractParser<T> setRequestURL(String requestURL) {
        this.requestURL = requestURL;
        return this;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getRequest() {
        return this.requestObject;
    }

    @Override
    public AbstractParser<T> setRequest(com.alibaba.fastjson.JSONObject request) {
        this.requestObject = request;
        return this;
    }

    public AbstractParser<T> setGlobalFormat(Boolean globalFormat) {
        this.globalFormat = globalFormat;
        return this;
    }

    @Override
    public Boolean getGlobalFormat() {
        return this.globalFormat;
    }

    public AbstractParser<T> setGlobalRole(String globalRole) {
        this.globalRole = globalRole;
        return this;
    }

    @Override
    public String getGlobalRole() {
        return this.globalRole;
    }

    public AbstractParser<T> setGlobalDatabase(String globalDatabase) {
        this.globalDatabase = globalDatabase;
        return this;
    }

    @Override
    public String getGlobalDatabase() {
        return this.globalDatabase;
    }

    public AbstractParser<T> setGlobalSchema(String globalSchema) {
        this.globalSchema = globalSchema;
        return this;
    }

    @Override
    public String getGlobalSchema() {
        return this.globalSchema;
    }

    @Override
    public String getGlobalDatasource() {
        return this.globalDatasource;
    }

    public AbstractParser<T> setGlobalDatasource(String globalDatasource) {
        this.globalDatasource = globalDatasource;
        return this;
    }

    public AbstractParser<T> setGlobalExplain(Boolean globalExplain) {
        this.globalExplain = globalExplain;
        return this;
    }

    @Override
    public Boolean getGlobalExplain() {
        return this.globalExplain;
    }

    public AbstractParser<T> setGlobalCache(String globalCache) {
        this.globalCache = globalCache;
        return this;
    }

    @Override
    public String getGlobalCache() {
        return this.globalCache;
    }

    @Override
    public AbstractParser<T> setNeedVerify(boolean needVerify) {
        this.setNeedVerifyLogin(needVerify);
        this.setNeedVerifyRole(needVerify);
        this.setNeedVerifyContent(needVerify);
        return this;
    }

    @Override
    public boolean isNeedVerifyLogin() {
        return this.needVerifyLogin;
    }

    @Override
    public AbstractParser<T> setNeedVerifyLogin(boolean needVerifyLogin) {
        this.needVerifyLogin = needVerifyLogin;
        return this;
    }

    @Override
    public boolean isNeedVerifyRole() {
        return this.needVerifyRole;
    }

    @Override
    public AbstractParser<T> setNeedVerifyRole(boolean needVerifyRole) {
        this.needVerifyRole = needVerifyRole;
        return this;
    }

    @Override
    public boolean isNeedVerifyContent() {
        return this.needVerifyContent;
    }

    @Override
    public AbstractParser<T> setNeedVerifyContent(boolean needVerifyContent) {
        this.needVerifyContent = needVerifyContent;
        return this;
    }

    @Override
    public SQLExecutor getSQLExecutor() {
        if (this.sqlExecutor == null) {
            this.sqlExecutor = this.createSQLExecutor();
            this.sqlExecutor.setParser(this);
        }
        return this.sqlExecutor;
    }

    @Override
    public Verifier<T> getVerifier() {
        if (this.verifier == null) {
            this.verifier = this.createVerifier().setVisitor(this.getVisitor());
        }
        return this.verifier;
    }

    @Override
    public String parse(String request) {
        return JSON.toJSONString(this.parseResponse(request));
    }

    @Override
    @NotNull
    public String parse(com.alibaba.fastjson.JSONObject request) {
        return JSON.toJSONString(this.parseResponse(request));
    }

    @Override
    @NotNull
    public com.alibaba.fastjson.JSONObject parseResponse(String request) {
        Log.d(TAG, "\n\n\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n" + this.requestMethod + "/parseResponse  request = \n" + request + "\n\n");
        try {
            this.requestObject = AbstractParser.parseRequest(request);
        }
        catch (Exception e) {
            return AbstractParser.newErrorResult(e, this.isRoot);
        }
        return this.parseResponse(this.requestObject);
    }

    @Override
    @NotNull
    public com.alibaba.fastjson.JSONObject parseResponse(com.alibaba.fastjson.JSONObject request) {
        long startTime = System.currentTimeMillis();
        Log.d(TAG, "parseResponse  startTime = " + startTime + "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\n\n ");
        this.requestObject = request;
        try {
            this.setVersion(this.requestObject.getIntValue("version"));
            this.requestObject.remove((Object)"version");
            if (this.getMethod() != RequestMethod.CRUD) {
                this.setTag(this.requestObject.getString("tag"));
                this.requestObject.remove((Object)"tag");
            }
        }
        catch (Exception e) {
            return AbstractParser.extendErrorResult(this.requestObject, e, this.requestMethod, this.getRequestURL(), this.isRoot);
        }
        this.verifier = this.createVerifier().setVisitor(this.getVisitor());
        if (!RequestMethod.isPublicMethod(this.requestMethod)) {
            try {
                if (this.isNeedVerifyLogin()) {
                    this.onVerifyLogin();
                }
                if (this.isNeedVerifyContent()) {
                    this.onVerifyContent();
                }
            }
            catch (Exception e) {
                return AbstractParser.extendErrorResult(this.requestObject, e, this.requestMethod, this.getRequestURL(), this.isRoot);
            }
        }
        if (this.isNeedVerifyRole() && this.globalRole == null) {
            try {
                this.setGlobalRole(this.requestObject.getString("@role"));
                this.requestObject.remove((Object)"@role");
            }
            catch (Exception e) {
                return AbstractParser.extendErrorResult(this.requestObject, e, this.requestMethod, this.getRequestURL(), this.isRoot);
            }
        }
        try {
            this.setGlobalFormat(this.requestObject.getBoolean("format"));
            this.setGlobalDatabase(this.requestObject.getString("@database"));
            this.setGlobalSchema(this.requestObject.getString("@schema"));
            this.setGlobalDatasource(this.requestObject.getString("@datasource"));
            this.setGlobalExplain(this.requestObject.getBoolean("@explain"));
            this.setGlobalCache(this.requestObject.getString("@cache"));
            this.requestObject.remove((Object)"format");
            this.requestObject.remove((Object)"@database");
            this.requestObject.remove((Object)"@schema");
            this.requestObject.remove((Object)"@datasource");
            this.requestObject.remove((Object)"@explain");
            this.requestObject.remove((Object)"@cache");
        }
        catch (Exception e) {
            return AbstractParser.extendErrorResult(this.requestObject, e, this.requestMethod, this.getRequestURL(), this.isRoot);
        }
        String requestString = JSON.toJSONString(request);
        this.queryResultMap = new HashMap<String, Object>();
        Exception error = null;
        this.sqlExecutor = this.createSQLExecutor();
        this.onBegin();
        try {
            this.queryDepth = 0;
            this.executedSQLDuration = 0L;
            this.requestObject = this.onObjectParse(request, null, null, null, false);
            this.onCommit();
        }
        catch (Exception e) {
            e.printStackTrace();
            error = e;
            this.onRollback();
        }
        String warn = !Log.DEBUG || error != null ? null : this.getWarnString();
        this.requestObject = error == null ? AbstractParser.extendSuccessResult(this.requestObject, warn, this.isRoot) : AbstractParser.extendErrorResult(this.requestObject, error, this.requestMethod, this.getRequestURL(), this.isRoot);
        com.alibaba.fastjson.JSONObject res = this.globalFormat != null && this.globalFormat != false && JSONResponse.isSuccess(this.requestObject) ? new JSONResponse(this.requestObject) : this.requestObject;
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        res.putIfAbsent((Object)"time", (Object)endTime);
        if (Log.DEBUG) {
            res.put("sql:generate|cache|execute|maxExecute", (Object)(this.getSQLExecutor().getGeneratedSQLCount() + "|" + this.getSQLExecutor().getCachedSQLCount() + "|" + this.getSQLExecutor().getExecutedSQLCount() + "|" + this.getMaxSQLCount()));
            res.put("depth:count|max", (Object)(this.queryDepth + "|" + this.getMaxQueryDepth()));
            this.executedSQLDuration += this.sqlExecutor.getExecutedSQLDuration() + this.sqlExecutor.getSqlResultDuration();
            long parseDuration = duration - this.executedSQLDuration;
            res.put("time:start|duration|end|parse|sql", (Object)(startTime + "|" + duration + "|" + endTime + "|" + parseDuration + "|" + this.executedSQLDuration));
            if (error != null) {
                Exception t = error instanceof CommonException && error.getCause() != null ? error.getCause() : error;
                res.put("trace:throw", (Object)t.getClass().getName());
                res.put("trace:stack", (Object)t.getStackTrace());
            }
        }
        this.onClose();
        if (IS_PRINT_REQUEST_STRING_LOG || Log.DEBUG || error != null) {
            Log.sl("\n\n\n", '<', "");
            Log.fd(TAG, this.requestMethod + "/parseResponse  request = \n" + requestString + "\n\n");
        }
        if (IS_PRINT_BIG_LOG || Log.DEBUG || error != null) {
            Log.fd(TAG, this.requestMethod + "/parseResponse return response = \n" + JSON.toJSONString(this.requestObject) + "\n\n");
        }
        if (IS_PRINT_REQUEST_ENDTIME_LOG || Log.DEBUG || error != null) {
            Log.fd(TAG, this.requestMethod + "/parseResponse  endTime = " + endTime + ";  duration = " + duration);
            Log.sl("", '>', "\n\n\n");
        }
        return res;
    }

    @Override
    public void onVerifyLogin() throws Exception {
        this.getVerifier().verifyLogin();
    }

    @Override
    public void onVerifyContent() throws Exception {
        this.requestObject = this.parseCorrectRequest();
    }

    @Override
    public void onVerifyRole(@NotNull SQLConfig<T> config) throws Exception {
        if (Log.DEBUG) {
            Log.i(TAG, "onVerifyRole  config = " + JSON.toJSONString(config));
        }
        if (this.isNeedVerifyRole()) {
            if (config.getRole() == null) {
                if (this.globalRole != null) {
                    config.setRole(this.globalRole);
                } else {
                    config.setRole(this.getVisitor().getId() == null ? "UNKNOWN" : "LOGIN");
                }
            }
            this.getVerifier().verifyAccess(config);
        }
    }

    @NotNull
    public static com.alibaba.fastjson.JSONObject parseRequest(String request) throws Exception {
        com.alibaba.fastjson.JSONObject obj = JSON.parseObject(request);
        if (obj == null) {
            throw new UnsupportedEncodingException("JSON\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        return obj;
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseCorrectRequest(RequestMethod method, String tag, int version, String name, @NotNull com.alibaba.fastjson.JSONObject request, int maxUpdateCount, SQLCreator creator) throws Exception {
        if (RequestMethod.isPublicMethod(method)) {
            return request;
        }
        return this.batchVerify(method, tag, version, name, request, maxUpdateCount, creator);
    }

    public static com.alibaba.fastjson.JSONObject wrapRequest(RequestMethod method, String tag, com.alibaba.fastjson.JSONObject object, boolean isStructure) {
        boolean isArrayKey;
        boolean putTag;
        boolean bl = putTag = !isStructure;
        if (object == null || object.containsKey((Object)tag)) {
            if (putTag) {
                if (object == null) {
                    object = new com.alibaba.fastjson.JSONObject(true);
                }
                object.put("tag", (Object)tag);
            }
            return object;
        }
        boolean isDiffArrayKey = tag.endsWith(":[]");
        boolean bl2 = isArrayKey = isDiffArrayKey || JSONRequest.isArrayKey(tag);
        String key = isArrayKey ? tag.substring(0, tag.length() - (isDiffArrayKey ? 3 : 2)) : tag;
        com.alibaba.fastjson.JSONObject target = object;
        if (JSONObject.isTableKey(key)) {
            if (isDiffArrayKey) {
                if (isStructure && (method == RequestMethod.POST || method == RequestMethod.PUT)) {
                    String arrKey = key + "[]";
                    if (!target.containsKey((Object)arrKey)) {
                        target.put(arrKey, (Object)new JSONArray());
                    }
                    try {
                        com.alibaba.fastjson.JSONObject type = target.getJSONObject(Operation.TYPE.name());
                        if (type == null || !type.containsKey((Object)arrKey)) {
                            if (type == null) {
                                type = new com.alibaba.fastjson.JSONObject(true);
                            }
                            type.put(arrKey, (Object)"OBJECT[]");
                            target.put(Operation.TYPE.name(), (Object)type);
                        }
                    }
                    catch (Throwable e) {
                        Log.w(TAG, "wrapRequest try { JSONObject type = target.getJSONObject(Operation.TYPE.name()); } catch (Exception e) = " + e.getMessage());
                    }
                }
            } else if (!isArrayKey || RequestMethod.isGetMethod(method, true)) {
                target = new com.alibaba.fastjson.JSONObject(true);
                target.put(tag, (Object)object);
            } else if (!target.containsKey((Object)key)) {
                target = new com.alibaba.fastjson.JSONObject(true);
                target.put(key, (Object)object);
            }
        }
        if (putTag) {
            target.put("tag", (Object)tag);
        }
        return target;
    }

    public static com.alibaba.fastjson.JSONObject newResult(int code, String msg) {
        return AbstractParser.newResult(code, msg, null);
    }

    public static com.alibaba.fastjson.JSONObject newResult(int code, String msg, String warn) {
        return AbstractParser.newResult(code, msg, warn, false);
    }

    public static com.alibaba.fastjson.JSONObject newResult(int code, String msg, String warn, boolean isRoot) {
        return AbstractParser.extendResult(null, code, msg, warn, isRoot);
    }

    public static com.alibaba.fastjson.JSONObject extendResult(com.alibaba.fastjson.JSONObject object, int code, String msg, String warn, boolean isRoot) {
        String m;
        int index;
        int n = index = !Log.DEBUG || !isRoot || msg == null ? -1 : ((String)msg).lastIndexOf("\n---|-----APIJSON SYSTEM INFO-----|---\n");
        String debug = !Log.DEBUG || !isRoot ? null : (index >= 0 ? ((String)msg).substring(index + "\n---|-----APIJSON SYSTEM INFO-----|---\n".length()).trim() : " \n\u63d0 bug \u8bf7\u53d1\u8bf7\u6c42\u548c\u54cd\u5e94\u7684\u3010\u5b8c\u6574\u622a\u5c4f\u3011\uff0c\u6ca1\u56fe\u7684\u81ea\u884c\u89e3\u51b3\uff01 \n\u5f00\u53d1\u8005\u6709\u9650\u7684\u65f6\u95f4\u548c\u7cbe\u529b\u4e3b\u8981\u653e\u5728\u3010\u7ef4\u62a4\u9879\u76ee\u6e90\u7801\u548c\u6587\u6863\u3011\u4e0a\uff01 \n\u3010\u63cf\u8ff0\u4e0d\u8be6\u7ec6\u3011 \u6216 \u3010\u6587\u6863/\u5e38\u89c1\u95ee\u9898 \u5df2\u6709\u7b54\u6848\u3011 \u7684\u95ee\u9898\u53ef\u80fd\u4f1a\u88ab\u5ffd\u7565\uff01\uff01 \n\u3010\u6001\u5ea6 \u4e0d\u6587\u660e/\u4e0d\u53cb\u5584\u3011\u7684\u53ef\u80fd\u4f1a\u88ab\u8e22\u51fa\u7fa4\uff0c\u95ee\u9898\u4e5f\u53ef\u80fd\u4e0d\u4e88\u89e3\u7b54\uff01\uff01\uff01 \n\n **\u73af\u5883\u4fe1\u606f**  \n\u7cfb\u7edf: " + Log.OS_NAME + " " + Log.OS_VERSION + " \n\u6570\u636e\u5e93: DEFAULT_DATABASE = " + AbstractSQLConfig.DEFAULT_DATABASE + " \nJDK: " + Log.JAVA_VERSION + " " + Log.OS_ARCH + " \nAPIJSON: 7.0.3 \n   \n\u3010\u5e38\u89c1\u95ee\u9898\u3011\uff1ahttps://github.com/Tencent/APIJSON/issues/36 \n\u3010\u901a\u7528\u6587\u6863\u3011\uff1ahttps://github.com/Tencent/APIJSON/blob/master/Document.md \n\u3010\u89c6\u9891\u6559\u7a0b\u3011\uff1ahttps://search.bilibili.com/all?keyword=APIJSON");
        Object object2 = msg = index >= 0 ? ((String)msg).substring(0, index) : msg;
        if (object == null) {
            object = new com.alibaba.fastjson.JSONObject(true);
        }
        if (object.get((Object)JSONResponse.KEY_OK) == null) {
            object.put(JSONResponse.KEY_OK, (Object)JSONResponse.isSuccess(code));
        }
        if (object.get((Object)JSONResponse.KEY_CODE) == null) {
            object.put(JSONResponse.KEY_CODE, (Object)code);
        }
        if (!(m = StringUtil.getString(object.getString(JSONResponse.KEY_MSG))).isEmpty()) {
            msg = m + " ;\n " + StringUtil.getString((String)msg);
        }
        object.put(JSONResponse.KEY_MSG, msg);
        if (debug != null) {
            if (StringUtil.isNotEmpty(warn, true)) {
                debug = debug + "\n \u3010\u8b66\u544a\u3011\uff1a" + warn;
            }
            object.put("debug:info|help", (Object)debug);
        }
        return object;
    }

    public static com.alibaba.fastjson.JSONObject extendSuccessResult(com.alibaba.fastjson.JSONObject object) {
        return AbstractParser.extendSuccessResult(object, false);
    }

    public static com.alibaba.fastjson.JSONObject extendSuccessResult(com.alibaba.fastjson.JSONObject object, boolean isRoot) {
        return AbstractParser.extendSuccessResult(object, null, isRoot);
    }

    public static com.alibaba.fastjson.JSONObject extendSuccessResult(com.alibaba.fastjson.JSONObject object, String warn, boolean isRoot) {
        return AbstractParser.extendResult(object, 200, "success", warn, isRoot);
    }

    public static com.alibaba.fastjson.JSONObject newSuccessResult() {
        return AbstractParser.newSuccessResult(null);
    }

    public static com.alibaba.fastjson.JSONObject newSuccessResult(String warn) {
        return AbstractParser.newSuccessResult(warn, false);
    }

    public static com.alibaba.fastjson.JSONObject newSuccessResult(String warn, boolean isRoot) {
        return AbstractParser.newResult(200, "success", warn, isRoot);
    }

    public static com.alibaba.fastjson.JSONObject extendErrorResult(com.alibaba.fastjson.JSONObject object, Throwable e) {
        return AbstractParser.extendErrorResult(object, e, false);
    }

    public static com.alibaba.fastjson.JSONObject extendErrorResult(com.alibaba.fastjson.JSONObject object, Throwable e, boolean isRoot) {
        return AbstractParser.extendErrorResult(object, e, null, null, isRoot);
    }

    public static com.alibaba.fastjson.JSONObject extendErrorResult(com.alibaba.fastjson.JSONObject object, Throwable e, RequestMethod requestMethod, String url, boolean isRoot) {
        Object msg = CommonException.getMsg(e);
        if (Log.DEBUG && isRoot) {
            try {
                Object env;
                boolean isCommon = e instanceof CommonException;
                Object object2 = env = isCommon ? ((CommonException)e).getEnvironment() : null;
                if (StringUtil.isEmpty((String)env)) {
                    env = " \n **\u73af\u5883\u4fe1\u606f**  \n \u7cfb\u7edf: " + Log.OS_NAME + " " + Log.OS_VERSION + " \n \u6570\u636e\u5e93: <!-- \u8bf7\u586b\u5199\uff0c\u4f8b\u5982 MySQL 5.7\u3002\u9ed8\u8ba4\u6570\u636e\u5e93\u4e3a " + AbstractSQLConfig.DEFAULT_DATABASE + " --> \n JDK: " + Log.JAVA_VERSION + " " + Log.OS_ARCH + " \n APIJSON: 7.0.3";
                }
                String encodedMsg = URLEncoder.encode((String)msg, "UTF-8");
                if (StringUtil.isEmpty((String)url, true)) {
                    String host = "localhost";
                    try {
                        host = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    String port = "8080";
                    try {
                        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
                        Set<ObjectName> objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
                        String p = objectNames.iterator().next().getKeyProperty("port");
                        port = StringUtil.isEmpty(p, true) ? port : p;
                    }
                    catch (Throwable beanServer) {
                        // empty catch block
                    }
                    url = "http://" + host + ":" + port + "/" + (requestMethod == null ? RequestMethod.GET : requestMethod).name().toLowerCase();
                }
                String req = JSON.toJSONString(object);
                try {
                    req = URLEncoder.encode(req, "UTF-8");
                }
                catch (Throwable port) {
                    // empty catch block
                }
                Throwable t = isCommon ? e.getCause() : e;
                boolean isSQLException = t instanceof SQLException;
                String apiatuoAndGitHubLink = "\n\n\u3010APIAuto\u3011\uff1a \n http://apijson.cn/api?type=JSON&url=" + URLEncoder.encode((String)url, "UTF-8") + "&json=" + req + "        \n\n\u3010GitHub\u3011\uff1a \n https://www.google.com/search?q=site%3Agithub.com%2FTencent%2FAPIJSON+++" + encodedMsg;
                msg = (String)msg + "\n---|-----APIJSON SYSTEM INFO-----|---\n    \u6d4f\u89c8\u5668\u6253\u5f00\u4ee5\u4e0b\u94fe\u63a5\u67e5\u770b\u89e3\u7b54" + (String)(isSQLException ? "" : apiatuoAndGitHubLink) + "        \n\n\u3010Google\u3011\uff1a\n https://www.google.com/search?q=" + encodedMsg + "        \n\n\u3010\u767e\u5ea6\u3011\uff1a\n https://www.baidu.com/s?ie=UTF-8&wd=" + encodedMsg + (String)(isSQLException ? apiatuoAndGitHubLink : "") + "        \n\n\u90fd\u6ca1\u627e\u5230\u7b54\u6848\uff1f\u6253\u5f00\u8fd9\u4e2a\u94fe\u63a5 \n https://github.com/Tencent/APIJSON/issues/new?assignees=&labels=&template=--bug.md   \n\u7136\u540e\u63d0\u4ea4\u95ee\u9898\uff0c\u63a8\u8350\u7528\u4ee5\u4e0b\u6a21\u677f\u4fee\u6539\uff0c\u6ce8\u610f\u8981\u6362\u884c\u4fdd\u6301\u6e05\u6670\u53ef\u8bfb\u3002 \n\u3010\u6807\u9898\u3011\uff1a" + (String)msg + " \n\u3010\u5185\u5bb9\u3011\uff1a" + (String)env + "\n\n**\u95ee\u9898\u63cf\u8ff0**\n" + (String)msg + " \n\n<!-- \u5c3d\u91cf\u5b8c\u6574\u622a\u5c4f(\u81f3\u5c11\u5305\u542b\u8bf7\u6c42\u548c\u56de\u5305\u7ed3\u679c\uff0c\u8fd8\u53ef\u4ee5\u52a0\u4e0a\u63a7\u5236\u53f0\u62a5\u9519\u65e5\u5fd7)\uff0c\u7136\u540e\u590d\u5236\u7c98\u8d34\u5230\u8fd9\u91cc --> \n\nPOST " + (String)url + " \n\u53d1\u9001\u8bf7\u6c42 Request JSON\uff1a\n ```js \n \u8bf7\u586b\u5199\uff0c\u4f8b\u5982 { \"Users\":{} } \n``` \n\n\u8fd4\u56de\u7ed3\u679c Response JSON\uff1a\n ```js \n \u8bf7\u586b\u5199\uff0c\u4f8b\u5982 { \"Users\": {}, \"code\": 401, \"msg\": \"Users \u4e0d\u5141\u8bb8 UNKNOWN \u7528\u6237\u7684 GET \u8bf7\u6c42\uff01\" } \n```";
            }
            catch (Throwable isCommon) {
                // empty catch block
            }
        }
        int code = CommonException.getCode(e);
        return AbstractParser.extendResult(object, code, (String)msg, null, isRoot);
    }

    public static com.alibaba.fastjson.JSONObject newErrorResult(Exception e) {
        return AbstractParser.newErrorResult(e, false);
    }

    public static com.alibaba.fastjson.JSONObject newErrorResult(Exception e, boolean isRoot) {
        if (e != null) {
            e.printStackTrace();
            String msg = CommonException.getMsg(e);
            Integer code = CommonException.getCode(e);
            return AbstractParser.newResult(code, msg, null, isRoot);
        }
        return AbstractParser.newResult(500, "Internal Server Error!", null, isRoot);
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseCorrectRequest() throws Exception {
        return this.parseCorrectRequest(this.requestMethod, this.tag, this.version, "", this.requestObject, this.getMaxUpdateCount(), this);
    }

    @Override
    public com.alibaba.fastjson.JSONObject getStructure(@NotNull String table, String method, String tag, int version) throws Exception {
        com.alibaba.fastjson.JSONObject result;
        String cacheKey = AbstractVerifier.getCacheKeyForRequest(method, tag);
        SortedMap<Integer, com.alibaba.fastjson.JSONObject> versionedMap = AbstractVerifier.REQUEST_MAP.get(cacheKey);
        com.alibaba.fastjson.JSONObject jSONObject = result = versionedMap == null ? null : (com.alibaba.fastjson.JSONObject)versionedMap.get(version);
        if (result == null) {
            Set<Map.Entry<Integer, com.alibaba.fastjson.JSONObject>> set;
            Set<Map.Entry<Integer, com.alibaba.fastjson.JSONObject>> set2 = set = versionedMap == null ? null : versionedMap.entrySet();
            if (set != null && !set.isEmpty()) {
                Map.Entry<Integer, com.alibaba.fastjson.JSONObject> maxEntry = null;
                for (Map.Entry<Integer, com.alibaba.fastjson.JSONObject> entry : set) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                    if (version <= 0 || version == entry.getKey()) {
                        maxEntry = entry;
                        break;
                    }
                    if (entry.getKey() < version) break;
                    maxEntry = entry;
                }
                com.alibaba.fastjson.JSONObject jSONObject2 = result = maxEntry == null ? null : (com.alibaba.fastjson.JSONObject)maxEntry.getValue();
            }
            if (result != null) {
                if (versionedMap == null) {
                    versionedMap = new TreeMap<Integer, com.alibaba.fastjson.JSONObject>((o1, o2) -> o2 == null ? -1 : o2.compareTo((Integer)o1));
                }
                versionedMap.put(version, result);
                AbstractVerifier.REQUEST_MAP.put(cacheKey, versionedMap);
            }
        }
        if (result == null) {
            if (!Log.DEBUG && !AbstractVerifier.REQUEST_MAP.isEmpty()) {
                return null;
            }
            SQLConfig config = this.createSQLConfig().setMethod(RequestMethod.GET).setTable(table);
            config.setPrepared(false);
            config.setColumn(Arrays.asList("structure"));
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("method", method);
            where.put("tag", tag);
            if (version > 0) {
                where.put("version>=", version);
            }
            config.setWhere(where);
            config.setOrder("version" + (version > 0 ? "+" : "-"));
            config.setCount(1);
            result = this.getSQLExecutor().execute(config, false);
        }
        return AbstractParser.getJSONObject(result, "structure");
    }

    @Override
    public com.alibaba.fastjson.JSONObject onObjectParse(com.alibaba.fastjson.JSONObject request, String parentPath, String name, SQLConfig<T> arrayConfig, boolean isSubquery) throws Exception {
        if (Log.DEBUG) {
            Log.i(TAG, "\ngetObject:  parentPath = " + parentPath + ";\n name = " + name + "; request = " + JSON.toJSONString(request));
        }
        if (request == null) {
            return null;
        }
        int type = arrayConfig == null ? 0 : arrayConfig.getType();
        int position = arrayConfig == null ? 0 : arrayConfig.getPosition();
        String[] arr = StringUtil.split(parentPath, "/");
        if (position == 0) {
            int d;
            int n = d = arr == null ? 1 : arr.length + 1;
            if (this.queryDepth < d) {
                this.queryDepth = d;
                int maxQueryDepth = this.getMaxQueryDepth();
                if (this.queryDepth > maxQueryDepth) {
                    throw new IllegalArgumentException(parentPath + "/" + name + ":{} \u7684\u6df1\u5ea6(\u6216\u8005\u8bf4\u5c42\u7ea7) \u4e3a " + this.queryDepth + " \u5df2\u8d85\u9650\uff0c\u5fc5\u987b\u5728 1-" + maxQueryDepth + " \u5185 !");
                }
            }
        }
        Entry<String, String> entry = Pair.parseEntry(name, true);
        String table = entry.getKey();
        boolean isTable = JSONObject.isTableKey(table);
        boolean isArrayMainTable = !isSubquery && isTable && type == 2 && arrayConfig != null && RequestMethod.isGetMethod(arrayConfig.getMethod(), true);
        boolean isReuse = isArrayMainTable && position > 0;
        ObjectParser op = null;
        if (isReuse) {
            op = this.arrayObjectParserCacheMap.get(parentPath.substring(0, parentPath.lastIndexOf("[]") + 2));
            op.setParentPath(parentPath);
        }
        if (op == null) {
            op = this.createObjectParser(request, parentPath, arrayConfig, isSubquery, isTable, isArrayMainTable);
        }
        this.setOpMethod(request, op, name);
        op = op.parse(name, isReuse);
        Object response = null;
        if (op != null) {
            if (arrayConfig == null) {
                response = op.setSQLConfig().executeSQL().response();
            } else {
                int query = arrayConfig.getQuery();
                if (type == 2 && query != 0 && position == 0) {
                    int index;
                    com.alibaba.fastjson.JSONObject rp;
                    Boolean compat = arrayConfig.getCompat();
                    if (compat != null && compat.booleanValue()) {
                        SQLConfig cfg = op.setSQLConfig(0, 0, 0).getSQLConfig();
                        boolean isExplain = cfg.isExplain();
                        cfg.setExplain(false);
                        Subquery subqy = new Subquery();
                        subqy.setFrom(cfg.getTable());
                        subqy.setConfig(cfg);
                        SQLConfig countSQLCfg = this.createSQLConfig();
                        countSQLCfg.setColumn(Arrays.asList("count(*):count"));
                        countSQLCfg.setFrom(subqy);
                        rp = this.executeSQL(countSQLCfg, false);
                        cfg.setExplain(isExplain);
                    } else {
                        RequestMethod method = op.getMethod();
                        rp = op.setMethod(RequestMethod.HEAD).setSQLConfig().executeSQL().getSqlResponse();
                        op.setMethod(method);
                    }
                    if (rp != null && (index = parentPath.lastIndexOf("]/")) >= 0) {
                        int total = rp.getIntValue("count");
                        String pathPrefix = parentPath.substring(0, index) + "]/";
                        this.putQueryResult(pathPrefix + "total", total);
                        int count = arrayConfig.getCount();
                        int page = arrayConfig.getPage();
                        int max = (total - 1) / count;
                        if (max < 0) {
                            max = 0;
                        }
                        com.alibaba.fastjson.JSONObject pagination = new com.alibaba.fastjson.JSONObject(true);
                        Object explain = rp.get((Object)"@explain");
                        if (explain instanceof com.alibaba.fastjson.JSONObject) {
                            pagination.put("@explain", explain);
                        }
                        pagination.put("total", (Object)total);
                        pagination.put("count", (Object)count);
                        pagination.put("page", (Object)page);
                        pagination.put("max", (Object)max);
                        pagination.put("more", (Object)(page < max ? 1 : 0));
                        pagination.put("first", (Object)(page == 0 ? 1 : 0));
                        pagination.put("last", (Object)(page == max ? 1 : 0));
                        this.putQueryResult(pathPrefix + "info", pagination);
                        if (total <= count * page) {
                            query = 1;
                        }
                    }
                    op.setMethod(this.requestMethod);
                }
                response = query == 1 ? null : op.setSQLConfig(arrayConfig.getCount(), arrayConfig.getPage(), position).executeSQL().response();
            }
            if (isArrayMainTable && position == 0) {
                this.arrayObjectParserCacheMap.put(parentPath.substring(0, parentPath.lastIndexOf("[]") + 2), op);
            }
            op = null;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONArray onArrayParse(com.alibaba.fastjson.JSONObject request, String parentPath, String name, boolean isSubquery) throws Exception {
        int max;
        int query2;
        RequestMethod _method;
        if (Log.DEBUG) {
            Log.i(TAG, "\n\n\n onArrayParse parentPath = " + parentPath + "; name = " + name + "; request = " + JSON.toJSONString(request));
        }
        RequestMethod requestMethod = _method = request.get((Object)"@method") == null ? this.requestMethod : RequestMethod.valueOf(request.getString("@method"));
        if (!isSubquery && !RequestMethod.isGetMethod(_method, true)) {
            throw new UnsupportedOperationException("key[]:{} \u53ea\u652f\u6301 GET, GETS \u65b9\u6cd5\uff01\u5176\u5b83\u65b9\u6cd5\u4e0d\u5141\u8bb8\u4f20 " + name + ":{} \u7b49\u8fd9\u79cd key[]:{} \u683c\u5f0f\uff01");
        }
        if (request == null || request.isEmpty()) {
            return null;
        }
        String path = AbstractParser.getAbsPath(parentPath, name);
        String query = request.getString("query");
        Boolean compat = request.getBoolean("compat");
        Integer count = request.getInteger("count");
        Integer page = request.getInteger("page");
        Object join = request.get((Object)"join");
        if (query == null) {
            query2 = 0;
        } else {
            switch (query) {
                case "0": 
                case "TABLE": {
                    query2 = 0;
                    break;
                }
                case "1": 
                case "TOTAL": {
                    query2 = 1;
                    break;
                }
                case "2": 
                case "ALL": {
                    query2 = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(path + "/query:value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 [0,1,2] \u6216 [TABLE, TOTAL, ALL] \u5185 !");
                }
            }
        }
        int page2 = page == null ? 0 : page;
        int maxPage = this.getMaxQueryPage();
        if (page2 < 0 || page2 > maxPage) {
            throw new IllegalArgumentException(path + "/page:value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 0-" + maxPage + " \u5185 !");
        }
        int count2 = isSubquery || count != null ? (count == null ? 0 : count) : this.getDefaultQueryCount();
        int n = max = isSubquery ? count2 : this.getMaxQueryCount();
        if (count2 < 0 || count2 > max) {
            throw new IllegalArgumentException(path + "/count:value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 0-" + max + " \u5185 !");
        }
        request.remove((Object)"query");
        request.remove((Object)"compat");
        request.remove((Object)"count");
        request.remove((Object)"page");
        request.remove((Object)"join");
        Log.d(TAG, "onArrayParse  query = " + query + "; count = " + count + "; page = " + page + "; join = " + join);
        if (request.isEmpty()) {
            Log.e(TAG, "onArrayParse  request.isEmpty() >> return null;");
            return null;
        }
        JSONArray response = null;
        try {
            com.alibaba.fastjson.JSONObject parent;
            int size = count2 == 0 ? max : count2;
            Log.d(TAG, "onArrayParse  size = " + size + "; page = " + page2);
            int index = isSubquery || name == null ? -1 : name.lastIndexOf("[]");
            String childPath = index <= 0 ? null : Pair.parseEntry(name.substring(0, index), true).getKey();
            String arrTableKey = null;
            String[] childKeys = StringUtil.split(childPath, "-", false);
            if (childKeys == null || childKeys.length <= 0 || !request.containsKey((Object)childKeys[0])) {
                childKeys = null;
            } else if (childKeys.length == 1 && JSONRequest.isTableKey(childKeys[0])) {
                arrTableKey = childKeys[0];
            }
            response = new JSONArray();
            SQLConfig config = this.createSQLConfig().setMethod(this.requestMethod).setCount(size).setPage(page2).setQuery(query2).setCompat(compat).setTable(arrTableKey).setJoinList(this.onJoinParse(join, request));
            boolean isExtract = true;
            for (int i = 0; i < (isSubquery ? 1 : size) && (parent = this.onObjectParse(request, isSubquery ? parentPath : path, (String)(isSubquery ? name : "" + i), config.setType(1).setPosition(i), isSubquery)) != null && !parent.isEmpty(); ++i) {
                List list;
                long startTime = System.currentTimeMillis();
                com.alibaba.fastjson.JSONObject fo = i != 0 || arrTableKey == null ? null : parent.getJSONObject(arrTableKey);
                List list2 = list = fo == null ? null : (List)fo.remove((Object)AbstractSQLExecutor.KEY_RAW_LIST);
                if (list != null && !list.isEmpty()) {
                    isExtract = false;
                    list.set(0, fo);
                    response.addAll((Collection)list);
                    long endTime = System.currentTimeMillis();
                    Log.d(TAG, "\n onArrayParse <<<<<<<<<<<<<<<<<<<<<<<<<<<<\n for (int i = 0; i < (isSubquery ? 1 : size); i++)  startTime = " + startTime + "; endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
                    break;
                }
                response.add(AbstractParser.getValue(parent, childKeys));
            }
            if (isExtract) {
                Object fo;
                long startTime = System.currentTimeMillis();
                Object object = fo = childKeys == null || response.isEmpty() ? null : response.get(0);
                if (fo instanceof Boolean || fo instanceof Number || fo instanceof String) {
                    this.putQueryResult(path, response);
                }
                long endTime = System.currentTimeMillis();
                Log.d(TAG, "\n onArrayParse <<<<<<<<<<<<<<<<<<<<<<<<<<<<\n isExtract >> putQueryResult  startTime = " + startTime + "; endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
            }
        }
        finally {
            request.put("query", (Object)query);
            request.put("compat", (Object)compat);
            request.put("count", (Object)count);
            request.put("page", (Object)page);
            request.put("join", join);
        }
        if (Log.DEBUG) {
            Log.i(TAG, "onArrayParse  return response = \n" + JSON.toJSONString(response) + "\n>>>>>>>>>>>>>>>\n\n\n");
        }
        return response;
    }

    private List<Join> onJoinParse(Object join, com.alibaba.fastjson.JSONObject request) throws Exception {
        Set set;
        com.alibaba.fastjson.JSONObject joinMap = null;
        if (join instanceof com.alibaba.fastjson.JSONObject) {
            joinMap = (com.alibaba.fastjson.JSONObject)join;
        } else if (join instanceof String) {
            String[] sArr;
            String[] stringArray = sArr = request == null || request.isEmpty() ? null : StringUtil.split((String)join);
            if (sArr != null && sArr.length > 0) {
                joinMap = new com.alibaba.fastjson.JSONObject(true);
                for (int i = 0; i < sArr.length; ++i) {
                    joinMap.put(sArr[i], (Object)new com.alibaba.fastjson.JSONObject());
                }
            }
        } else if (join != null) {
            throw new UnsupportedDataTypeException("AbstractParser.onJoinParse  join \u53ea\u80fd\u662f String \u6216 JSONObject \u7c7b\u578b\uff01");
        }
        Set set2 = set = joinMap == null ? null : joinMap.entrySet();
        if (set == null || set.isEmpty()) {
            Log.e(TAG, "onJoinParse  set == null || set.isEmpty() >> return null;");
            return null;
        }
        ArrayList<Join> joinList = new ArrayList<Join>();
        for (Map.Entry e : set) {
            String key;
            com.alibaba.fastjson.JSONObject tableObj;
            com.alibaba.fastjson.JSONObject parentPathObj;
            String arrKey;
            int index;
            Object outer;
            String path = e == null ? null : (String)e.getKey();
            Object v2 = outer = path == null ? null : e.getValue();
            if (!(outer instanceof com.alibaba.fastjson.JSONObject)) {
                throw new IllegalArgumentException("join:value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0/key0,</Table1/key1,... \u6216 { '&/Table0/key0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u5f62\u5f0f\uff01");
            }
            int n = index = path == null ? -1 : path.indexOf("/");
            if (index < 0) {
                throw new IllegalArgumentException("join:value \u4e2d value \u503c " + path + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0,</Table1/key1,@/Table1:alias2/key2,... \u6216 { '&/Table0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u5f62\u5f0f\uff01");
            }
            String joinType = path.substring(0, index);
            String tableKey = (index = (path = path.substring(index + 1)).lastIndexOf("/")) < 0 ? path : path.substring(0, index);
            int index2 = tableKey.lastIndexOf("/");
            String string = arrKey = index2 < 0 ? null : tableKey.substring(0, index2);
            if (arrKey != null && !JSONRequest.isArrayKey(arrKey)) {
                throw new IllegalArgumentException("join:'" + (String)e.getKey() + "' \u5bf9\u5e94\u7684 " + arrKey + " \u4e0d\u662f\u5408\u6cd5\u7684\u6570\u7ec4 key[] \uff01@ APP JOIN \u6700\u591a\u5141\u8bb8\u8de8 1 \u5c42\uff0c\u53ea\u80fd\u662f\u5b50\u6570\u7ec4\uff0c\u4e14\u6570\u7ec4\u5bf9\u8c61\u4e2d\u4e0d\u80fd\u6709 join: value \u952e\u503c\u5bf9\uff01");
            }
            tableKey = index2 < 0 ? tableKey : tableKey.substring(index2 + 1);
            Entry<String, String> entry = Pair.parseEntry(tableKey, true);
            String table = entry.getKey();
            if (!StringUtil.isName(table)) {
                throw new IllegalArgumentException("join:value \u4e2d value \u7684 Table \u503c " + table + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0,</Table1/key1,@/Table1:alias2/key2,... \u6216 { '&/Table0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u683c\u5f0f\uff01\u4e14 Table \u5fc5\u987b\u6ee1\u8db3\u5927\u5199\u5b57\u6bcd\u5f00\u5934\u7684\u8868\u5bf9\u8c61\u82f1\u6587\u5355\u8bcd key \u683c\u5f0f\uff01");
            }
            String alias = entry.getValue();
            if (StringUtil.isNotEmpty(alias, true) && !StringUtil.isName(alias)) {
                throw new IllegalArgumentException("join:value \u4e2d value \u7684 alias \u503c " + alias + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0,</Table1/key1,@/Table1:alias2/key2,... \u6216 { '&/Table0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u683c\u5f0f\uff01\u4e14 Table:alias \u7684 alias \u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
            }
            try {
                parentPathObj = arrKey == null ? request : request.getJSONObject(arrKey);
                com.alibaba.fastjson.JSONObject jSONObject = tableObj = parentPathObj == null ? null : parentPathObj.getJSONObject(tableKey);
                if (tableObj == null) {
                    throw new NullPointerException("tableObj == null");
                }
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("join:'" + (String)e.getKey() + "' \u5bf9\u5e94\u7684 " + tableKey + ":value \u4e2d value \u7c7b\u578b\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u662f {} \u8fd9\u79cd JSONObject \u683c\u5f0f\uff01" + e2.getMessage());
            }
            if (arrKey != null) {
                if (parentPathObj.get((Object)"join") != null) {
                    throw new IllegalArgumentException("join:'" + (String)e.getKey() + "' \u5bf9\u5e94\u7684 " + arrKey + ":{ join: value } \u4e2d value \u4e0d\u5408\u6cd5\uff01@ APP JOIN \u6700\u591a\u5141\u8bb8\u8de8 1 \u5c42\uff0c\u53ea\u80fd\u662f\u5b50\u6570\u7ec4\uff0c\u4e14\u6570\u7ec4\u5bf9\u8c61\u4e2d\u4e0d\u80fd\u6709 join: value \u952e\u503c\u5bf9\uff01");
                }
                Integer subPage = parentPathObj.getInteger("page");
                if (subPage != null && subPage != 0) {
                    throw new IllegalArgumentException("join:'" + (String)e.getKey() + "' \u5bf9\u5e94\u7684 " + arrKey + ":{ page: value } \u4e2d value \u4e0d\u5408\u6cd5\uff01@ APP JOIN \u6700\u591a\u5141\u8bb8\u8de8 1 \u5c42\uff0c\u53ea\u80fd\u662f\u5b50\u6570\u7ec4\uff0c\u4e14\u6570\u7ec4\u5bf9\u8c61\u4e2d page \u503c\u53ea\u80fd\u4e3a null \u6216 0 \uff01");
                }
            }
            boolean isAppJoin = "@".equals(joinType);
            com.alibaba.fastjson.JSONObject refObj = new com.alibaba.fastjson.JSONObject(tableObj.size(), true);
            String string2 = key = index < 0 ? null : path.substring(index + 1);
            if (key != null) {
                if (key.indexOf("@") != key.length() - 1) {
                    throw new IllegalArgumentException("join:" + (String)e.getKey() + " \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0,</Table1/key1,@/Table1:alias2/key2,... \u6216 { '&/Table0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u683c\u5f0f\uff01\u4e14 Table:alias \u7684 alias \u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                }
                if (!(tableObj.get((Object)key) instanceof String)) {
                    throw new IllegalArgumentException("join:" + (String)e.getKey() + "' \u5bf9\u5e94\u7684 " + tableKey + ":{ " + key + ": value } \u4e2d value \u7c7b\u578b\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a\u540c\u5c42\u7ea7\u5f15\u7528\u8d4b\u503c\u8def\u5f84 String\uff01");
                }
                if (isAppJoin && !StringUtil.isName(key.substring(0, key.length() - 1))) {
                    throw new IllegalArgumentException("join:'" + (String)e.getKey() + "' \u4e2d " + key + " \u4e0d\u5408\u6cd5 \uff01@ APP JOIN \u53ea\u5141\u8bb8 key@:/Table/refKey \u8fd9\u79cd = \u7b49\u4ef7\u8fde\u63a5\uff01");
                }
                refObj.put(key, (Object)tableObj.getString(key));
            }
            Set tableSet = tableObj.entrySet();
            com.alibaba.fastjson.JSONObject requestObj = new com.alibaba.fastjson.JSONObject(true);
            boolean matchSingle = false;
            for (Map.Entry tableEntry : tableSet) {
                String k = (String)tableEntry.getKey();
                Object v = k == null ? null : tableEntry.getValue();
                if (v == null || (matchSingle = !matchSingle && k.equals(key))) continue;
                if (k.length() > 1 && k.indexOf("@") == k.length() - 1 && v instanceof String) {
                    Object rv;
                    int ind;
                    String sv = v;
                    int n2 = ind = sv.endsWith("@") ? -1 : sv.indexOf("/");
                    if (ind == 0 && key == null) {
                        Entry<String, String> te;
                        String p = sv.substring(1);
                        int ind2 = p.indexOf("/");
                        String tk = ind2 < 0 ? null : p.substring(0, ind2);
                        Entry<String, String> entry2 = te = tk == null || p.substring(ind2 + 1).indexOf("/") >= 0 ? null : Pair.parseEntry(tk, true);
                        if (te != null && JSONRequest.isTableKey((String)te.getKey()) && request.get((Object)tk) instanceof com.alibaba.fastjson.JSONObject) {
                            if (isAppJoin) {
                                if (refObj.size() >= 1) {
                                    throw new IllegalArgumentException("join:" + (String)e.getKey() + " \u4e2d " + k + " \u4e0d\u5408\u6cd5\uff01@ APP JOIN \u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u5f15\u7528\u8d4b\u503c\u952e\u503c\u5bf9\uff01");
                                }
                                if (!StringUtil.isName(k.substring(0, k.length() - 1))) {
                                    throw new IllegalArgumentException("join:'" + (String)e.getKey() + "' \u4e2d " + k + " \u4e0d\u5408\u6cd5 \uff01@ APP JOIN \u53ea\u5141\u8bb8 key@:/Table/refKey \u8fd9\u79cd = \u7b49\u4ef7\u8fde\u63a5\uff01");
                                }
                            }
                            refObj.put(k, v);
                            continue;
                        }
                    }
                    if ((rv = this.getValueByPath(sv)) != null && !rv.equals(sv)) {
                        requestObj.put(k.substring(0, k.length() - 1), rv);
                        continue;
                    }
                    throw new UnsupportedOperationException(table + "/" + k + " \u4e0d\u5408\u6cd5\uff01join \u5173\u8054\u7684 Table \u4e2d\uff0cjoin: ?/Table/key \u65f6\u53ea\u80fd\u6709 1 \u4e2a key@:value\uff1bjoin: ?/Table \u65f6\u6240\u6709 key@:value \u8981\u4e48\u662f\u7b26\u5408 join \u683c\u5f0f\uff0c\u8981\u4e48\u80fd\u76f4\u63a5\u89e3\u6790\u6210\u5177\u4f53\u503c\uff01");
                }
                if (k.startsWith("@")) {
                    if (!JOIN_COPY_KEY_LIST.contains(k)) continue;
                    requestObj.put(k, v);
                    continue;
                }
                if (k.endsWith("@")) {
                    throw new UnsupportedOperationException(table + "/" + k + " \u4e0d\u5408\u6cd5\uff01join \u5173\u8054\u7684 Table \u4e2d\uff0cjoin: ?/Table/key \u65f6\u53ea\u80fd\u6709 1 \u4e2a key@:value\uff1bjoin: ?/Table \u65f6\u6240\u6709 key@:value \u8981\u4e48\u662f\u7b26\u5408 join \u683c\u5f0f\uff0c\u8981\u4e48\u80fd\u76f4\u63a5\u89e3\u6790\u6210\u5177\u4f53\u503c\uff01");
                }
                if (k.contains("()")) continue;
                requestObj.put(k, v);
            }
            Set refSet = refObj.entrySet();
            if (refSet.isEmpty() && !"*".equals(joinType)) {
                throw new IllegalArgumentException("join:value \u4e2d value \u7684 alias \u503c " + alias + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a &/Table0,</Table1/key1,@/Table1:alias2/key2,... \u6216 { '&/Table0':{}, '</Table1/key1':{},... } \u8fd9\u79cd\u683c\u5f0f\uff01\u4e14 Table:alias \u7684 alias \u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
            }
            Join j = new Join();
            j.setPath((String)e.getKey());
            j.setJoinType(joinType);
            j.setTable(table);
            j.setAlias(alias);
            j.setOuter(outer);
            j.setRequest(requestObj);
            if (arrKey != null) {
                Integer count = parentPathObj.getInteger("count");
                j.setCount(count == null ? this.getDefaultQueryCount() : count.intValue());
            }
            ArrayList<Join.On> onList = new ArrayList<Join.On>();
            for (Map.Entry refEntry : refSet) {
                com.alibaba.fastjson.JSONObject targetObj;
                String targetKey;
                String originKey = (String)refEntry.getKey();
                String targetPath = (String)refEntry.getValue();
                if (StringUtil.isEmpty(targetPath, true)) {
                    throw new IllegalArgumentException((String)e.getKey() + ":value \u4e2d value \u503c " + targetPath + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a\u5f15\u7528\u8d4b\u503c\u7684\u8def\u5f84 '/targetTable/targetKey' \uff01");
                }
                index = targetPath.lastIndexOf("/");
                String string3 = targetKey = index < 0 ? null : targetPath.substring(index + 1);
                if (!StringUtil.isName(targetKey)) {
                    throw new IllegalArgumentException((String)e.getKey() + ":'/targetTable/targetKey' \u4e2d targetKey \u503c " + targetKey + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                }
                String targetTableKey = (index = (targetPath = targetPath.substring(0, index)).lastIndexOf("/")) < 0 ? targetPath : targetPath.substring(index + 1);
                Entry<String, String> targetEntry = Pair.parseEntry(targetTableKey, true);
                String targetTable = targetEntry.getKey();
                if (!StringUtil.isName(targetTable)) {
                    throw new IllegalArgumentException((String)e.getKey() + ":'/targetTable/targetKey' \u4e2d targetTable \u503c " + targetTable + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u5927\u5199\u5b57\u6bcd\u5f00\u5934\u7684\u8868\u5bf9\u8c61\u82f1\u6587\u5355\u8bcd key \u683c\u5f0f\uff01");
                }
                String targetAlias = targetEntry.getValue();
                if (StringUtil.isNotEmpty(targetAlias, true) && !StringUtil.isName(targetAlias)) {
                    throw new IllegalArgumentException((String)e.getKey() + ":'/targetTable:targetAlias/targetKey' \u4e2d targetAlias \u503c " + targetAlias + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                }
                targetTable = targetTableKey;
                if (!StringUtil.isName(targetTable)) {
                    throw new IllegalArgumentException((String)e.getKey() + ":'/targetTable/targetKey' \u4e2d targetTable \u503c " + targetTable + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u5927\u5199\u5b57\u6bcd\u5f00\u5934\u7684\u8868\u5bf9\u8c61\u82f1\u6587\u5355\u8bcd key \u683c\u5f0f\uff01");
                }
                try {
                    targetObj = request.getJSONObject(targetTableKey);
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException((String)e.getKey() + ":'/targetTable/targetKey' \u4e2d\u8def\u5f84\u5bf9\u5e94\u7684 '" + targetTableKey + "':value \u4e2d value \u7c7b\u578b\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u662f {} \u8fd9\u79cd JSONObject \u683c\u5f0f\uff01" + e2.getMessage());
                }
                if (targetObj == null) {
                    throw new IllegalArgumentException((String)e.getKey() + ":'/targetTable/targetKey' \u4e2d\u8def\u5f84\u5bf9\u5e94\u7684\u5bf9\u8c61 '" + targetTableKey + "':{} \u4e0d\u5b58\u5728\u6216\u503c\u4e3a null \uff01\u5fc5\u987b\u662f {} \u8fd9\u79cd JSONObject \u683c\u5f0f\uff01");
                }
                Join.On on = new Join.On();
                on.setKeyAndType(j.getJoinType(), j.getTable(), originKey);
                if (!StringUtil.isName(on.getKey())) {
                    throw new IllegalArgumentException("join:value \u4e2d value \u7684 key@ \u4e2d key \u503c " + on.getKey() + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u6ee1\u8db3\u82f1\u6587\u5355\u8bcd\u53d8\u91cf\u540d\u683c\u5f0f\uff01");
                }
                on.setOriginKey(originKey);
                on.setOriginValue((String)refEntry.getValue());
                on.setTargetTable(targetTable);
                on.setTargetAlias(targetAlias);
                on.setTargetKey(targetKey);
                onList.add(on);
            }
            j.setOnList(onList);
            joinList.add(j);
            if (refObj.size() == tableObj.size()) continue;
            refObj.putAll((Map)tableObj);
            parentPathObj.put(tableKey, (Object)refObj);
        }
        return joinList;
    }

    public static <V> V getValue(com.alibaba.fastjson.JSONObject parent, String[] pathKeys) {
        if (parent == null || pathKeys == null || pathKeys.length <= 0) {
            Log.w(TAG, "getChild  parent == null || pathKeys == null || pathKeys.length <= 0 >> return parent;");
            return (V)parent;
        }
        int last = pathKeys.length - 1;
        for (int i = 0; i < last && parent != null; ++i) {
            String k = AbstractParser.getDecodedKey(pathKeys[i]);
            parent = AbstractParser.getJSONObject(parent, k);
        }
        return (V)(parent == null ? null : parent.get((Object)AbstractParser.getDecodedKey(pathKeys[last])));
    }

    public static String getValuePath(String parentPath, String valuePath) {
        valuePath = valuePath.startsWith("/") ? AbstractParser.getAbsPath(parentPath, valuePath) : AbstractParser.replaceArrayChildPath(parentPath, valuePath);
        return valuePath;
    }

    public static String getAbsPath(String path, String name) {
        Log.i(TAG, "getPath  path = " + (String)path + "; name = " + name + " <<<<<<<<<<<<<");
        path = StringUtil.getString((String)path);
        name = StringUtil.getString(name);
        if (StringUtil.isNotEmpty((String)path, false)) {
            if (StringUtil.isNotEmpty(name, false)) {
                path = (String)path + (name.startsWith("/") ? "" : "/") + name;
            }
        } else {
            path = name;
        }
        if (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        Log.i(TAG, "getPath  return " + (String)path + " >>>>>>>>>>>>>>>>");
        return path;
    }

    public static String replaceArrayChildPath(String parentPath, String valuePath) {
        Object[] vs;
        String[] ps = StringUtil.split(parentPath, "]/");
        if (ps != null && ps.length > 1 && (vs = StringUtil.split(valuePath, "]/")) != null && vs.length > 0) {
            for (int i = 0; i < ps.length - 1 && ps[i] != null && ps[i].equals(vs[i]); ++i) {
                String pos;
                String string = pos = !ps[i + 1].contains("/") ? ps[i + 1] : ps[i + 1].substring(0, ps[i + 1].indexOf("/"));
                if (((String)vs[i + 1]).startsWith(pos + "/")) continue;
                vs[i + 1] = pos + "/" + (String)vs[i + 1];
            }
            return StringUtil.getString(vs, "]/");
        }
        return valuePath;
    }

    @Override
    public void putQueryResult(String path, Object result) {
        Log.i(TAG, "\n putQueryResult  valuePath = " + path + "; result = " + result + "\n <<<<<<<<<<<<<<<<<<<<<<<");
        Log.d(TAG, "putQueryResult  queryResultMap.containsKey(valuePath) >> queryResultMap.put(path, result);");
        this.queryResultMap.put(path, result);
    }

    @Override
    public Object getValueByPath(String valuePath) {
        int last;
        Log.i(TAG, "<<<<<<<<<<<<<<< \n getValueByPath  valuePath = " + valuePath + "\n <<<<<<<<<<<<<<<<<<");
        if (StringUtil.isEmpty(valuePath, true)) {
            Log.e(TAG, "getValueByPath  StringUtil.isNotEmpty(valuePath, true) == false >> return null;");
            return null;
        }
        Object target = this.queryResultMap.get(valuePath);
        if (target != null) {
            return target;
        }
        com.alibaba.fastjson.JSONObject parent = null;
        String[] keys = null;
        for (Map.Entry<String, Object> entry : this.queryResultMap.entrySet()) {
            String path = entry.getKey();
            if (!valuePath.startsWith(path + "/")) continue;
            try {
                parent = (com.alibaba.fastjson.JSONObject)entry.getValue();
            }
            catch (Exception e) {
                Log.e(TAG, "getValueByPath  try { parent = (JSONObject) queryResultMap.get(path); } catch { \n parent not instanceof JSONObject!");
                parent = null;
            }
            if (parent == null) break;
            keys = StringUtil.splitPath(valuePath.substring(path.length()));
            break;
        }
        int n = last = keys == null ? -1 : keys.length - 1;
        if (last >= 1) {
            for (int i = 0; i < last && parent != null; ++i) {
                String k = AbstractParser.getDecodedKey((String)keys[i]);
                parent = AbstractParser.getJSONObject(parent, k);
            }
        }
        if (parent != null) {
            Log.i(TAG, "getValueByPath >> get from queryResultMap >> return  parent.get(keys[keys.length - 1]);");
            Object object = target = last < 0 ? parent : parent.get((Object)AbstractParser.getDecodedKey((String)keys[last]));
            if (target != null) {
                Log.i(TAG, "getValueByPath >> getValue >> return target = " + target);
                return target;
            }
        }
        if ((target = AbstractParser.getValue(this.requestObject, StringUtil.splitPath(valuePath))) != null) {
            Log.i(TAG, "getValueByPath >> getValue >> return target = " + target);
            return target;
        }
        Log.i(TAG, "getValueByPath  return null;");
        return null;
    }

    public static String getDecodedKey(String key) {
        try {
            return URLDecoder.decode(key, StandardCharsets.UTF_8);
        }
        catch (Throwable e) {
            return key;
        }
    }

    public static com.alibaba.fastjson.JSONObject getJSONObject(com.alibaba.fastjson.JSONObject object, String key) {
        try {
            return object.getJSONObject(key);
        }
        catch (Exception e) {
            Log.i(TAG, "getJSONObject  try { return object.getJSONObject(key); } catch (Exception e) { \n" + e.getMessage());
            return null;
        }
    }

    public void putArrayMainCache(String arrayPath, List<com.alibaba.fastjson.JSONObject> mainTableDataList) {
        this.arrayMainCacheMap.put(arrayPath, mainTableDataList);
    }

    public List<com.alibaba.fastjson.JSONObject> getArrayMainCache(String arrayPath) {
        return this.arrayMainCacheMap.get(arrayPath);
    }

    public com.alibaba.fastjson.JSONObject getArrayMainCacheItem(String arrayPath, int position) {
        List<com.alibaba.fastjson.JSONObject> list = this.getArrayMainCache(arrayPath);
        return list == null || position >= list.size() ? null : list.get(position);
    }

    @Override
    public com.alibaba.fastjson.JSONObject executeSQL(SQLConfig<T> config, boolean isSubquery) throws Exception {
        if (config == null) {
            Log.d(TAG, "executeSQL  config == null >> return null;");
            return null;
        }
        config.setParser(this);
        config.setVersion(this.getVersion());
        config.setTag(this.getTag());
        if (isSubquery) {
            com.alibaba.fastjson.JSONObject sqlObj = new com.alibaba.fastjson.JSONObject(true);
            sqlObj.put(KEY_CONFIG, config);
            return sqlObj;
        }
        try {
            com.alibaba.fastjson.JSONObject result;
            boolean explain = config.isExplain();
            if (explain) {
                config.setExplain(false);
                com.alibaba.fastjson.JSONObject res = this.getSQLExecutor().execute(config, false);
                if (RequestMethod.isQueryMethod(config.getMethod()) && !config.isElasticsearch()) {
                    com.alibaba.fastjson.JSONObject explainResult;
                    config.setExplain(explain);
                    com.alibaba.fastjson.JSONObject jSONObject = explainResult = config.isMain() && config.getPosition() != 0 ? null : this.getSQLExecutor().execute(config, false);
                    if (explainResult == null) {
                        result = res;
                    } else {
                        result = new com.alibaba.fastjson.JSONObject(true);
                        result.put("@explain", (Object)explainResult);
                        result.putAll((Map)res);
                    }
                } else {
                    result = new com.alibaba.fastjson.JSONObject(true);
                    result.put(KEY_SQL, (Object)config.getSQL(false));
                    result.putAll((Map)res);
                }
            } else {
                this.sqlExecutor = this.getSQLExecutor();
                result = this.sqlExecutor.execute(config, false);
            }
            com.alibaba.fastjson.JSONObject jSONObject = result;
            return jSONObject;
        }
        catch (Exception e) {
            throw CommonException.wrap(e, config);
        }
        finally {
            if (config.getPosition() == 0 && config.limitSQLCount()) {
                int maxSQLCount = this.getMaxSQLCount();
                int sqlCount = this.getSQLExecutor().getExecutedSQLCount();
                Log.d(TAG, "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< \n\n\n \u5df2\u6267\u884c " + sqlCount + "/" + maxSQLCount + " \u6761 SQL \n\n\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                if (sqlCount > maxSQLCount) {
                    throw new IllegalArgumentException("\u622a\u81f3 " + config.getTable() + " \u5df2\u6267\u884c " + sqlCount + " \u6761 SQL\uff0c\u6570\u91cf\u5df2\u8d85\u9650\uff0c\u5fc5\u987b\u5728 0-" + maxSQLCount + " \u5185 !");
                }
            }
        }
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public void begin(int transactionIsolation) {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< begin transactionIsolation = " + transactionIsolation + " >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().setTransactionIsolation(transactionIsolation);
    }

    @Override
    public void rollback() throws SQLException {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< rollback >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< rollback savepoint " + (savepoint == null ? "" : "!") + "= null >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().rollback(savepoint);
    }

    @Override
    public void commit() throws SQLException {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< commit >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().commit();
    }

    @Override
    public void close() {
        Log.d("\n\nAbstractParser", "<<<<<<<<<<<<<<<<<<<<<<< close >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.getSQLExecutor().close();
    }

    protected void onBegin() {
        if (RequestMethod.isQueryMethod(this.requestMethod)) {
            return;
        }
        this.begin(this.getTransactionIsolation());
    }

    protected void onCommit() {
        if (RequestMethod.isQueryMethod(this.requestMethod) && this.getSQLExecutor().getTransactionIsolation() == 0) {
            return;
        }
        try {
            this.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void onRollback() {
        if (RequestMethod.isQueryMethod(this.requestMethod)) {
            return;
        }
        try {
            this.rollback();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            try {
                this.rollback(null);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
        }
    }

    protected void onClose() {
        this.close();
        this.verifier = null;
        this.sqlExecutor = null;
        this.queryResultMap.clear();
        this.queryResultMap = null;
    }

    private void setOpMethod(com.alibaba.fastjson.JSONObject request, ObjectParser<T> op, String key) {
        String _method;
        String string = _method = key == null ? null : request.getString("@method");
        if (_method != null) {
            RequestMethod method = RequestMethod.valueOf(_method);
            this.setMethod(method);
            op.setMethod(method);
        }
    }

    protected com.alibaba.fastjson.JSONObject getRequestStructure(RequestMethod method, String tag, int version) throws Exception {
        com.alibaba.fastjson.JSONObject object = null;
        String error = "";
        try {
            object = this.getStructure("Request", method.name(), tag, version);
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        if (object == null) {
            throw new UnsupportedOperationException("\u627e\u4e0d\u5230 version: " + version + ", method: " + method.name() + ", tag: " + tag + " \u5bf9\u5e94\u7684 structure \uff01\u975e\u5f00\u653e\u8bf7\u6c42\u5fc5\u987b\u662f\u540e\u7aef Request \u8868\u4e2d\u6821\u9a8c\u89c4\u5219\u5141\u8bb8\u7684\u64cd\u4f5c\uff01\n " + error + "\n\u5982\u679c\u9700\u8981\u5219\u5728 Request \u8868\u4e2d\u65b0\u589e\u914d\u7f6e\uff01");
        }
        return object;
    }

    protected com.alibaba.fastjson.JSONObject batchVerify(RequestMethod method, String tag, int version, String name, @NotNull com.alibaba.fastjson.JSONObject request, int maxUpdateCount, SQLCreator creator) throws Exception {
        Set reqSet;
        com.alibaba.fastjson.JSONObject correctRequest = new com.alibaba.fastjson.JSONObject(true);
        ArrayList<String> removeTmpKeys = new ArrayList<String>();
        Set set = reqSet = request == null ? null : request.keySet();
        if (reqSet == null || request.isEmpty()) {
            throw new IllegalArgumentException("JSON \u5bf9\u8c61\u683c\u5f0f\u4e0d\u6b63\u786e \uff01\u6b63\u786e\u793a\u4f8b\u4f8b\u5982 \"User\": {}");
        }
        for (String key : reqSet) {
            if (correctRequest.containsKey((Object)key) || correctRequest.containsKey((Object)(key + "[]"))) {
                throw new IllegalArgumentException("\u5bf9\u8c61\u540d\u91cd\u590d,\u8bf7\u6dfb\u52a0\u522b\u540d\u533a\u5206 ! \u91cd\u590d\u5bf9\u8c61\u540d\u4e3a: " + key);
            }
            boolean isPost = "@post".equals(key);
            try {
                RequestMethod keyMethod;
                RequestMethod requestMethod = keyMethod = isPost ? RequestMethod.POST : (RequestMethod)((Object)JSONRequest.KEY_METHOD_ENUM_MAP.get(key));
                if (keyMethod != null) {
                    com.alibaba.fastjson.JSONObject obj;
                    removeTmpKeys.add(key);
                    Object val = request.get((Object)key);
                    com.alibaba.fastjson.JSONObject jSONObject = obj = val instanceof com.alibaba.fastjson.JSONObject ? request.getJSONObject(key) : null;
                    if (obj == null) {
                        if (val instanceof String) {
                            String[] tbls = StringUtil.split((String)val);
                            if (tbls != null && tbls.length > 0) {
                                obj = new com.alibaba.fastjson.JSONObject(true);
                                for (int i = 0; i < tbls.length; ++i) {
                                    String tbl = tbls[i];
                                    if (obj.containsKey((Object)tbl)) {
                                        throw new ConflictException(key + ": value \u4e2d " + tbl + " \u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
                                    }
                                    obj.put(tbl, isPost && JSONRequest.isTableArray(tbl) ? tbl.substring(0, tbl.length() - 2) + ":[]" : "");
                                }
                            }
                        } else {
                            throw new IllegalArgumentException(key + ": value \u4e2d value \u7c7b\u578b\u9519\u8bef\uff0c\u53ea\u80fd\u662f String \u6216 JSONObject {} \uff01");
                        }
                    }
                    Set set2 = obj == null ? new HashSet() : obj.entrySet();
                    for (Map.Entry objEntry : set2) {
                        com.alibaba.fastjson.JSONObject objAttrJson;
                        String objKey;
                        String string = objKey = objEntry == null ? null : (String)objEntry.getKey();
                        if (objKey == null) continue;
                        HashMap<String, Object> objAttrMap = new HashMap<String, Object>();
                        objAttrMap.put("@method", (Object)keyMethod);
                        this.keyObjectAttributesMap.put(objKey, objAttrMap);
                        Object objVal = objEntry.getValue();
                        com.alibaba.fastjson.JSONObject jSONObject2 = objAttrJson = objVal instanceof com.alibaba.fastjson.JSONObject ? obj.getJSONObject(objKey) : null;
                        if (objAttrJson == null) {
                            if (objVal instanceof String) {
                                objAttrMap.put("tag", "".equals(objVal) ? objKey : objVal);
                                continue;
                            }
                            throw new IllegalArgumentException(key + ": { " + objKey + ": value \u4e2d value \u7c7b\u578b\u9519\u8bef\uff0c\u53ea\u80fd\u662f String \u6216 JSONObject {} \uff01");
                        }
                        Set objSet = objAttrJson.entrySet();
                        boolean hasTag = false;
                        for (Map.Entry entry : objSet) {
                            String objAttrKey;
                            String string2 = objAttrKey = entry == null ? null : (String)entry.getKey();
                            if (objAttrKey == null) continue;
                            switch (objAttrKey) {
                                case "@datasource": 
                                case "@schema": 
                                case "@database": 
                                case "version": 
                                case "@role": {
                                    objAttrMap.put(objAttrKey, entry.getValue());
                                    break;
                                }
                                case "tag": {
                                    hasTag = true;
                                    objAttrMap.put(objAttrKey, entry.getValue());
                                    break;
                                }
                            }
                        }
                        if (hasTag) continue;
                        objAttrMap.put("tag", isPost && JSONRequest.isTableArray(objKey) ? objKey.substring(0, objKey.length() - 2) + ":[]" : objKey);
                    }
                    continue;
                }
                Object obj = request.get((Object)key);
                if (obj instanceof com.alibaba.fastjson.JSONObject) {
                    Map<String, Object> attrMap = this.keyObjectAttributesMap.get(key);
                    if (attrMap == null) {
                        if (this.keyObjectAttributesMap.get(key + "[]") == null) {
                            if (method == RequestMethod.CRUD || key.endsWith("@")) {
                                ((com.alibaba.fastjson.JSONObject)obj).put("@method", (Object)RequestMethod.GET);
                                objAttrMap = new HashMap<String, RequestMethod>();
                                objAttrMap.put("@method", RequestMethod.GET);
                                this.keyObjectAttributesMap.put(key, objAttrMap);
                            } else {
                                ((com.alibaba.fastjson.JSONObject)obj).put("@method", (Object)method);
                                objAttrMap = new HashMap();
                                objAttrMap.put("@method", method);
                                this.keyObjectAttributesMap.put(key, objAttrMap);
                            }
                        } else {
                            this.setRequestAttribute(key, true, "@method", request);
                            this.setRequestAttribute(key, true, "@datasource", request);
                            this.setRequestAttribute(key, true, "@schema", request);
                            this.setRequestAttribute(key, true, "@database", request);
                            this.setRequestAttribute(key, true, "1.2.83", request);
                            this.setRequestAttribute(key, true, "@role", request);
                        }
                    } else {
                        this.setRequestAttribute(key, false, "@method", request);
                        this.setRequestAttribute(key, false, "@datasource", request);
                        this.setRequestAttribute(key, false, "@schema", request);
                        this.setRequestAttribute(key, false, "@database", request);
                        this.setRequestAttribute(key, false, "1.2.83", request);
                        this.setRequestAttribute(key, false, "@role", request);
                    }
                }
                if (key.startsWith("@") || key.endsWith("@")) {
                    correctRequest.put(key, obj);
                    continue;
                }
                if (obj instanceof com.alibaba.fastjson.JSONObject || obj instanceof JSONArray) {
                    RequestMethod _method;
                    if (obj instanceof com.alibaba.fastjson.JSONObject) {
                        String combine;
                        com.alibaba.fastjson.JSONObject tblObj = request.getJSONObject(key);
                        String mn = tblObj == null ? null : tblObj.getString("@method");
                        _method = mn == null ? null : RequestMethod.valueOf(mn);
                        String string = combine = _method == null ? null : tblObj.getString("@combine");
                        if (combine != null && !RequestMethod.isPublicMethod(_method)) {
                            throw new IllegalArgumentException(key + ":{} \u91cc\u7684 @combine:value \u4e0d\u5408\u6cd5\uff01\u5f00\u653e\u8bf7\u6c42 GET\u3001HEAD \u624d\u5141\u8bb8\u4f20 @combine:value !");
                        }
                    } else {
                        Map<String, Object> attrMap = this.keyObjectAttributesMap.get(key);
                        if (attrMap == null) {
                            if (method == RequestMethod.CRUD) {
                                _method = RequestMethod.GET;
                                objAttrMap = new HashMap<String, RequestMethod>();
                                objAttrMap.put("@method", RequestMethod.GET);
                                this.keyObjectAttributesMap.put(key, objAttrMap);
                            } else {
                                _method = method;
                                objAttrMap = new HashMap();
                                objAttrMap.put("@method", method);
                                this.keyObjectAttributesMap.put(key, objAttrMap);
                            }
                        } else {
                            _method = (RequestMethod)((Object)attrMap.get("@method"));
                        }
                    }
                    if (method != RequestMethod.CRUD && _method != method) {
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u5728 " + method + " \u4e2d " + _method + " \uff01");
                    }
                    if (RequestMethod.isPublicMethod(_method)) {
                        correctRequest.put(key, obj);
                        continue;
                    }
                    if (tag != null && !tag.contains(":")) {
                        com.alibaba.fastjson.JSONObject object = this.getRequestStructure(_method, tag, version);
                        com.alibaba.fastjson.JSONObject ret = this.objectVerify(_method, tag, version, name, request, maxUpdateCount, creator, object);
                        correctRequest.putAll((Map)ret);
                        break;
                    }
                    String _tag = this.buildTag(request, key, method, tag);
                    com.alibaba.fastjson.JSONObject object = this.getRequestStructure(_method, _tag, version);
                    if (method == RequestMethod.CRUD && StringUtil.isEmpty(tag, true)) {
                        com.alibaba.fastjson.JSONObject requestItem = new com.alibaba.fastjson.JSONObject();
                        requestItem.put(key, obj);
                        com.alibaba.fastjson.JSONObject ret = this.objectVerify(_method, _tag, version, name, requestItem, maxUpdateCount, creator, object);
                        correctRequest.put(key, ret.get((Object)key));
                        continue;
                    }
                    return this.objectVerify(_method, _tag, version, name, request, maxUpdateCount, creator, object);
                }
                correctRequest.put(key, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        for (String removeKey : removeTmpKeys) {
            request.remove((Object)removeKey);
        }
        return correctRequest;
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName, E defaultEnum) {
        if (enumName == null) {
            return defaultEnum;
        }
        try {
            return Enum.valueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException ex) {
            return defaultEnum;
        }
    }

    protected void setRequestAttribute(String key, boolean isArray, String attrKey, @NotNull com.alibaba.fastjson.JSONObject request) {
        com.alibaba.fastjson.JSONObject obj;
        Map<String, Object> attrMap = this.keyObjectAttributesMap.get(isArray ? key + "[]" : key);
        Object attrVal = attrMap == null ? null : attrMap.get(attrKey);
        com.alibaba.fastjson.JSONObject jSONObject = obj = attrVal == null ? null : request.getJSONObject(key);
        if (obj != null && obj.get((Object)attrKey) == null) {
            obj.put(attrKey, attrVal);
        }
    }

    protected String buildTag(com.alibaba.fastjson.JSONObject request, String key, RequestMethod method, String tag) {
        if (method == RequestMethod.CRUD) {
            Object _tag;
            Map<String, Object> attrMap = this.keyObjectAttributesMap.get(key);
            Object object = _tag = attrMap == null ? null : attrMap.get("tag");
            return _tag != null ? _tag.toString() : (StringUtil.isEmpty(tag) ? key : tag);
        }
        if (StringUtil.isEmpty(tag, true)) {
            throw new IllegalArgumentException("\u8bf7\u5728\u6700\u5916\u5c42\u4f20 tag \uff01\u4e00\u822c\u662f Table \u540d\uff0c\u4f8b\u5982 \"tag\": \"User\" ");
        }
        return tag;
    }

    protected com.alibaba.fastjson.JSONObject objectVerify(RequestMethod method, String tag, int version, String name, @NotNull com.alibaba.fastjson.JSONObject request, int maxUpdateCount, SQLCreator creator, com.alibaba.fastjson.JSONObject object) throws Exception {
        com.alibaba.fastjson.JSONObject target = AbstractParser.wrapRequest(method, tag, object, true);
        return this.getVerifier().verifyRequest(method, name, target, request, maxUpdateCount, this.getGlobalDatabase(), this.getGlobalSchema(), creator);
    }

    public RequestMethod getRealMethod(RequestMethod method, String key, Object value) {
        if (method == RequestMethod.CRUD && (value instanceof com.alibaba.fastjson.JSONObject || value instanceof JSONArray)) {
            Object _method;
            Map<String, Object> attrMap = this.keyObjectAttributesMap.get(key);
            Object object = _method = attrMap == null ? null : attrMap.get("@method");
            if (_method instanceof RequestMethod) {
                return (RequestMethod)((Object)_method);
            }
        }
        return method;
    }

    static {
        JOIN_COPY_KEY_LIST.add("@role");
        JOIN_COPY_KEY_LIST.add("@database");
        JOIN_COPY_KEY_LIST.add("@schema");
        JOIN_COPY_KEY_LIST.add("@datasource");
        JOIN_COPY_KEY_LIST.add("@column");
        JOIN_COPY_KEY_LIST.add("@null");
        JOIN_COPY_KEY_LIST.add("@cast");
        JOIN_COPY_KEY_LIST.add("@combine");
        JOIN_COPY_KEY_LIST.add("@group");
        JOIN_COPY_KEY_LIST.add("@having");
        JOIN_COPY_KEY_LIST.add("@having&");
        JOIN_COPY_KEY_LIST.add("@order");
        JOIN_COPY_KEY_LIST.add("@key");
        JOIN_COPY_KEY_LIST.add("@raw");
    }
}

