/*
 * Decompiled with CFR 0.152.
 */
package apijson;

import apijson.StringUtil;

public class SQL {
    public static final String JOIN = " JOIN ";
    public static final String ON = " ON ";
    public static final String OR = " OR ";
    public static final String AND = " AND ";
    public static final String NOT = " NOT ";
    public static final String AS = " AS ";
    public static final String IS = " IS ";
    public static final String NULL = " NULL ";
    public static final String IS_NOT = " IS NOT ";
    public static final String IS_NULL = " IS NULL ";
    public static final String IS_NOT_NULL = " IS NOT NULL ";
    public static final String COUNT = "count";
    public static final String SUM = "sum";
    public static final String MAX = "max";
    public static final String MIN = "min";
    public static final String AVG = "avg";
    public static final int SEARCH_TYPE_CONTAIN_FULL = 0;
    public static final int SEARCH_TYPE_CONTAIN_ORDER = 1;
    public static final int SEARCH_TYPE_CONTAIN_SINGLE = 2;
    public static final int SEARCH_TYPE_CONTAIN_ANY = 3;
    public static final int SEARCH_TYPE_START = 4;
    public static final int SEARCH_TYPE_END = 5;
    public static final int SEARCH_TYPE_START_SINGLE = 6;
    public static final int SEARCH_TYPE_END_SINGLE = 7;
    public static final int SEARCH_TYPE_PART_MATCH = 8;

    public static String isNull() {
        return SQL.isNull(true);
    }

    public static String isNull(boolean isNull) {
        return IS + (isNull ? "" : NOT) + NULL;
    }

    public static String isNull(String s) {
        return SQL.isNull(s, true);
    }

    public static String isNull(String s, boolean isNull) {
        return s + SQL.isNull(isNull);
    }

    public static String isEmpty(String s) {
        return SQL.isEmpty(s, true);
    }

    public static String isEmpty(String s, boolean isEmpty) {
        return SQL.isEmpty(s, isEmpty, false);
    }

    public static String isEmpty(String s, boolean isEmpty, boolean trim) {
        return SQL.isEmpty(s, isEmpty, trim, true);
    }

    public static String isEmpty(String s, boolean isEmpty, boolean trim, boolean nullable) {
        if (trim) {
            s = SQL.trim(s);
        }
        return (String)(nullable ? SQL.isNull(s, true) + OR : "") + SQL.lengthCompare(s, (isEmpty ? "<=" : ">") + "0");
    }

    public static String lengthCompare(String s, String compare) {
        return SQL.length(s) + compare;
    }

    public static String length(String s) {
        return "length(" + s + ")";
    }

    public static String charLength(String s) {
        return "char_length(" + s + ")";
    }

    public static String trim(String s) {
        return "trim(" + s + ")";
    }

    public static String trimLeft(String s) {
        return "ltrim(" + s + ")";
    }

    public static String trimRight(String s) {
        return "rtrim(" + s + ")";
    }

    public static String left(String s, int n) {
        return "left(" + s + "," + n + ")";
    }

    public static String right(String s, int n) {
        return "right(" + s + "," + n + ")";
    }

    public static String subString(String s, int start, int end) {
        return "substring(" + s + "," + start + "," + (end - start) + ")";
    }

    public static String indexOf(String s, String c) {
        return "instr(" + s + ", " + c + ")";
    }

    public static String replace(String s, String c1, String c2) {
        return "replace(" + s + ", " + c1 + ", " + c2 + ")";
    }

    public static String concat(String s1, String s2) {
        return "concat(" + s1 + ", " + s2 + ")";
    }

    public static String equals(String s1, String s2) {
        return "strcmp(" + s1 + ", " + s2 + ")";
    }

    public static String toUpperCase(String s) {
        return "upper(" + s + ")";
    }

    public static String toLowerCase(String s) {
        return "lower(" + s + ")";
    }

    public static String column(String column) {
        return (column = StringUtil.getTrimedString(column)).isEmpty() ? "*" : column;
    }

    public static String columnAs(String column) {
        return SQL.count(column) + AS;
    }

    public static String function(String fun, String column) {
        return " " + fun + "(" + SQL.column(column) + ") ";
    }

    public static String functionAs(String fun, String column) {
        return SQL.function(fun, column) + AS + fun + " ";
    }

    public static String count() {
        return SQL.count(null);
    }

    public static String count(String column) {
        return SQL.functionAs(COUNT, column);
    }

    public static String sum(String column) {
        return SQL.functionAs(SUM, column);
    }

    public static String max(String column) {
        return SQL.functionAs(MAX, column);
    }

    public static String min(String column) {
        return SQL.functionAs(MIN, column);
    }

    public static String avg(String column) {
        return SQL.functionAs(AVG, column);
    }

    public static String search(String s) {
        return SQL.search(s, 0);
    }

    public static String search(String s, int type) {
        return SQL.search(s, type, true);
    }

    public static String search(String s, int type, boolean ignoreCase) {
        if (s == null) {
            return null;
        }
        switch (type) {
            case 2: {
                return "_" + s + "_";
            }
            case 1: {
                char[] cs = s.toCharArray();
                if (cs == null) {
                    return null;
                }
                Object value = "%";
                for (int i = 0; i < cs.length; ++i) {
                    value = (String)value + cs[i] + "%";
                }
                return value;
            }
            case 4: {
                return s + "%";
            }
            case 5: {
                return "%" + s;
            }
            case 6: {
                return s + "_";
            }
            case 7: {
                return "_" + s;
            }
            case 3: 
            case 8: {
                char[] cs = s.toCharArray();
                if (cs == null) {
                    return null;
                }
                Object value = "";
                for (int i = 0; i < cs.length; ++i) {
                    value = (String)value + SQL.search("" + cs[i], 0, ignoreCase);
                }
                return value;
            }
        }
        return "%" + s + "%";
    }

    public static boolean isBooleanOrNumber(String type) {
        return (type = StringUtil.toUpperCase(type, true)).isEmpty() || type.endsWith("INT") && !type.endsWith("POINT") || type.endsWith("BOOLEAN") || type.endsWith("ENUM") || type.endsWith("FLOAT") || type.endsWith("DOUBLE") || type.endsWith("DECIMAL");
    }
}

