/*
 * Decompiled with CFR 0.152.
 */
package apijson;

import java.text.SimpleDateFormat;

public class Log {
    public static boolean DEBUG = true;
    public static final String VERSION = "7.0.3";
    public static final String KEY_SYSTEM_INFO_DIVIDER = "\n---|-----APIJSON SYSTEM INFO-----|---\n";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");

    public static void setDateFormat(String dateFormatString) {
        DATE_FORMAT = new SimpleDateFormat(dateFormatString);
    }

    public static void logInfo(String TAG, String msg, String level) {
        if (level.equals("DEBUG") || level.equals("ERROR") || level.equals("WARN")) {
            System.err.println(DATE_FORMAT.format(System.currentTimeMillis()) + ": " + TAG + "." + level + ": " + msg);
        } else if (level.equals("VERBOSE") || level.equals("INFO")) {
            System.out.println(DATE_FORMAT.format(System.currentTimeMillis()) + ": " + TAG + "." + level + ": " + msg);
        }
    }

    public static void d(String TAG, String msg) {
        if (DEBUG) {
            Log.logInfo(TAG, msg, "DEBUG");
        }
    }

    public static void fd(String TAG, String msg) {
        Log.logInfo(TAG, msg, "DEBUG");
    }

    public static void sl(String pre, char symbol, String post) {
        System.err.println(pre + new String(new char[48]).replace('\u0000', symbol) + post);
    }

    public static void v(String TAG, String msg) {
        if (DEBUG) {
            Log.logInfo(TAG, msg, "VERBOSE");
        }
    }

    public static void i(String TAG, String msg) {
        if (DEBUG) {
            Log.logInfo(TAG, msg, "INFO");
        }
    }

    public static void e(String TAG, String msg) {
        if (DEBUG) {
            Log.logInfo(TAG, msg, "ERROR");
        }
    }

    public static void w(String TAG, String msg) {
        if (DEBUG) {
            Log.logInfo(TAG, msg, "WARN");
        }
    }
}

