/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.JSONObject;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.SQL;
import apijson.StringUtil;
import apijson.orm.AbstractFunctionParser;
import apijson.orm.AbstractVerifier;
import apijson.orm.Entry;
import apijson.orm.Join;
import apijson.orm.Logic;
import apijson.orm.ObjectParser;
import apijson.orm.Pair;
import apijson.orm.Parser;
import apijson.orm.SQLConfig;
import apijson.orm.Subquery;
import apijson.orm.exception.NotExistException;
import apijson.orm.exception.UnsupportedDataTypeException;
import apijson.orm.model.Access;
import apijson.orm.model.AllColumn;
import apijson.orm.model.AllColumnComment;
import apijson.orm.model.AllTable;
import apijson.orm.model.AllTableComment;
import apijson.orm.model.Column;
import apijson.orm.model.Document;
import apijson.orm.model.ExtendedProperty;
import apijson.orm.model.Function;
import apijson.orm.model.PgAttribute;
import apijson.orm.model.PgClass;
import apijson.orm.model.Request;
import apijson.orm.model.SysColumn;
import apijson.orm.model.SysTable;
import apijson.orm.model.Table;
import apijson.orm.model.TestRecord;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractSQLConfig<T>
implements SQLConfig<T> {
    private static final String TAG = "AbstractSQLConfig";
    public static boolean IS_HAVING_DEFAULT_AND = false;
    public static boolean IS_HAVING_ALLOW_NOT_FUNCTION = false;
    public static boolean ENABLE_WITH_AS = false;
    public static List<RequestMethod> IGNORE_EMPTY_STRING_METHOD_LIST = null;
    public static List<RequestMethod> IGNORE_BLANK_STRING_METHOD_LIST = null;
    public static String KEY_DELETED_KEY = "deletedKey";
    public static String KEY_DELETED_VALUE = "deletedValue";
    public static String KEY_NOT_DELETED_VALUE = "notDeletedValue";
    public static int MAX_HAVING_COUNT = 5;
    public static int MAX_WHERE_COUNT = 10;
    public static int MAX_COMBINE_DEPTH = 2;
    public static int MAX_COMBINE_COUNT = 5;
    public static int MAX_COMBINE_KEY_COUNT = 2;
    public static float MAX_COMBINE_RATIO = 1.0f;
    public static String DEFAULT_DATABASE = "MYSQL";
    public static String DEFAULT_SCHEMA = "sys";
    public static String PREFIX_DISTINCT = "DISTINCT ";
    public static Pattern PATTERN_SCHEMA = Pattern.compile("^[A-Za-z0-9_-]+$");
    public static Pattern PATTERN_RANGE = Pattern.compile("^[0-9%,!=\\<\\>/\\.\\+\\-\\*\\^]+$");
    public static Pattern PATTERN_FUNCTION = Pattern.compile("^[A-Za-z0-9%,:_@&~`!=\\<\\>\\|\\[\\]\\{\\} /\\.\\+\\-\\*\\^\\?\\(\\)\\$]+$");
    public static Map<String, String> TABLE_KEY_MAP = new HashMap<String, String>();
    public static Map<String, String> ALLOW_PARTIAL_UPDATE_FAIL_TABLE_MAP;
    public static List<String> CONFIG_TABLE_LIST;
    public static List<String> DATABASE_LIST;
    public static Map<String, String> RAW_MAP;
    public static Map<String, String> SQL_AGGREGATE_FUNCTION_MAP;
    public static Map<String, String> SQL_FUNCTION_MAP;
    private Parser<T> parser;
    private ObjectParser objectParser;
    private int version;
    private String tag;
    private List<String> withAsExprSqlList = null;
    protected List<Object> withAsExprPreparedValueList = new ArrayList<Object>();
    private int[] dbVersionNums = null;
    private RequestMethod method;
    private boolean prepared = true;
    private boolean main = true;
    private Object id;
    private Object idIn;
    private Object userId;
    private Object userIdIn;
    private String role;
    private boolean distinct = false;
    private String database;
    private String schema;
    private String datasource;
    private String table;
    private String alias;
    private String group;
    private String havingCombine;
    private Map<String, Object> having;
    private String order;
    private List<String> raw;
    private List<String> json;
    private Subquery from;
    private List<String> column;
    private List<List<Object>> values;
    private List<String> nulls;
    private Map<String, String> cast;
    private Map<String, Object> content;
    private Map<String, Object> where;
    private String combine;
    private Map<String, List<String>> combineMap;
    private int count;
    private int page;
    private int position;
    private int query;
    private Boolean compat;
    private int type;
    private int cache;
    private boolean explain;
    private List<Join> joinList;
    private boolean test;
    private String procedure;
    protected List<Object> preparedValueList = new ArrayList<Object>();
    private boolean keyPrefix;
    public static Long LAST_ID;

    @Override
    public Parser<T> getParser() {
        return this.parser;
    }

    @Override
    public AbstractSQLConfig setParser(Parser<T> parser) {
        this.parser = parser;
        return this;
    }

    @Override
    public ObjectParser getObjectParser() {
        return this.objectParser;
    }

    @Override
    public AbstractSQLConfig setObjectParser(ObjectParser objectParser) {
        this.objectParser = objectParser;
        return this;
    }

    @Override
    public int getVersion() {
        if (this.version <= 0 && this.parser != null) {
            this.version = this.parser.getVersion();
        }
        return this.version;
    }

    @Override
    public AbstractSQLConfig setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public String getTag() {
        if (StringUtil.isEmpty(this.tag) && this.parser != null) {
            this.tag = this.parser.getTag();
        }
        return this.tag;
    }

    @Override
    public AbstractSQLConfig setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public int[] getDBVersionNums() {
        if (this.dbVersionNums == null || this.dbVersionNums.length <= 0) {
            this.dbVersionNums = SQLConfig.super.getDBVersionNums();
        }
        return this.dbVersionNums;
    }

    @Override
    public boolean limitSQLCount() {
        return !Log.DEBUG || !AbstractVerifier.SYSTEM_ACCESS_MAP.containsKey(this.getTable());
    }

    @Override
    public boolean allowPartialUpdateFailed() {
        return AbstractSQLConfig.allowPartialUpdateFailed(this.getTable());
    }

    public static boolean allowPartialUpdateFailed(String table) {
        return ALLOW_PARTIAL_UPDATE_FAIL_TABLE_MAP.containsKey(table);
    }

    @Override
    @NotNull
    public String getIdKey() {
        return JSONObject.KEY_ID;
    }

    @Override
    @NotNull
    public String getUserIdKey() {
        return JSONObject.KEY_USER_ID;
    }

    @Override
    public SQLConfig setProcedure(String procedure) {
        this.procedure = procedure;
        return this;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public AbstractSQLConfig(RequestMethod method) {
        this.setMethod(method);
    }

    public AbstractSQLConfig(RequestMethod method, String table) {
        this(method);
        this.setTable(table);
    }

    public AbstractSQLConfig(RequestMethod method, int count, int page) {
        this(method);
        this.setCount(count);
        this.setPage(page);
    }

    @Override
    @NotNull
    public RequestMethod getMethod() {
        if (this.method == null) {
            this.method = RequestMethod.GET;
        }
        return this.method;
    }

    @Override
    public AbstractSQLConfig setMethod(RequestMethod method) {
        this.method = method;
        return this;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public AbstractSQLConfig setPrepared(boolean prepared) {
        this.prepared = prepared;
        return this;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public AbstractSQLConfig setMain(boolean main) {
        this.main = main;
        return this;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public AbstractSQLConfig setId(Object id) {
        this.id = id;
        return this;
    }

    @Override
    public Object getIdIn() {
        return this.idIn;
    }

    @Override
    public AbstractSQLConfig setIdIn(Object idIn) {
        this.idIn = idIn;
        return this;
    }

    @Override
    public Object getUserId() {
        return this.userId;
    }

    @Override
    public AbstractSQLConfig setUserId(Object userId) {
        this.userId = userId;
        return this;
    }

    @Override
    public Object getUserIdIn() {
        return this.userIdIn;
    }

    @Override
    public AbstractSQLConfig setUserIdIn(Object userIdIn) {
        this.userIdIn = userIdIn;
        return this;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    @Override
    public AbstractSQLConfig setRole(String role) {
        this.role = role;
        return this;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public SQLConfig setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public SQLConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    @NotNull
    public String getSQLDatabase() {
        String db = this.getDatabase();
        return db == null ? DEFAULT_DATABASE : db;
    }

    @Override
    public boolean isMySQL() {
        return AbstractSQLConfig.isMySQL(this.getSQLDatabase());
    }

    public static boolean isMySQL(String db) {
        return "MYSQL".equals(db);
    }

    @Override
    public boolean isPostgreSQL() {
        return AbstractSQLConfig.isPostgreSQL(this.getSQLDatabase());
    }

    public static boolean isPostgreSQL(String db) {
        return "POSTGRESQL".equals(db);
    }

    @Override
    public boolean isSQLServer() {
        return AbstractSQLConfig.isSQLServer(this.getSQLDatabase());
    }

    public static boolean isSQLServer(String db) {
        return "SQLSERVER".equals(db);
    }

    @Override
    public boolean isOracle() {
        return AbstractSQLConfig.isOracle(this.getSQLDatabase());
    }

    public static boolean isOracle(String db) {
        return "ORACLE".equals(db);
    }

    @Override
    public boolean isDb2() {
        return AbstractSQLConfig.isDb2(this.getSQLDatabase());
    }

    public static boolean isDb2(String db) {
        return "DB2".equals(db);
    }

    @Override
    public boolean isMariaDB() {
        return AbstractSQLConfig.isMariaDB(this.getSQLDatabase());
    }

    public static boolean isMariaDB(String db) {
        return "MARIADB".equals(db);
    }

    @Override
    public boolean isTiDB() {
        return AbstractSQLConfig.isTiDB(this.getSQLDatabase());
    }

    public static boolean isTiDB(String db) {
        return "TIDB".equals(db);
    }

    @Override
    public boolean isDameng() {
        return AbstractSQLConfig.isDameng(this.getSQLDatabase());
    }

    public static boolean isDameng(String db) {
        return "DAMENG".equals(db);
    }

    @Override
    public boolean isKingBase() {
        return AbstractSQLConfig.isKingBase(this.getSQLDatabase());
    }

    public static boolean isKingBase(String db) {
        return "KINGBASE".equals(db);
    }

    @Override
    public boolean isElasticsearch() {
        return AbstractSQLConfig.isElasticsearch(this.getSQLDatabase());
    }

    public static boolean isElasticsearch(String db) {
        return "ELASTICSEARCH".equals(db);
    }

    @Override
    public boolean isClickHouse() {
        return AbstractSQLConfig.isClickHouse(this.getSQLDatabase());
    }

    public static boolean isClickHouse(String db) {
        return "CLICKHOUSE".equals(db);
    }

    @Override
    public boolean isHive() {
        return AbstractSQLConfig.isHive(this.getSQLDatabase());
    }

    public static boolean isHive(String db) {
        return "HIVE".equals(db);
    }

    @Override
    public boolean isPresto() {
        return AbstractSQLConfig.isPresto(this.getSQLDatabase());
    }

    public static boolean isPresto(String db) {
        return "PRESTO".equals(db);
    }

    @Override
    public boolean isSnowflake() {
        return AbstractSQLConfig.isSnowflake(this.getSQLDatabase());
    }

    public static boolean isSnowflake(String db) {
        return "SNOWFLAKE".equals(db);
    }

    @Override
    public boolean isDatabricks() {
        return AbstractSQLConfig.isDatabricks(this.getSQLDatabase());
    }

    public static boolean isDatabricks(String db) {
        return "DATABRICKS".equals(db);
    }

    @Override
    public boolean isCassandra() {
        return AbstractSQLConfig.isCassandra(this.getSQLDatabase());
    }

    public static boolean isCassandra(String db) {
        return "CASSANDRA".equals(db);
    }

    @Override
    public boolean isTrino() {
        return AbstractSQLConfig.isTrino(this.getSQLDatabase());
    }

    public static boolean isTrino(String db) {
        return "TRINO".equals(db);
    }

    @Override
    public boolean isInfluxDB() {
        return AbstractSQLConfig.isInfluxDB(this.getSQLDatabase());
    }

    public static boolean isInfluxDB(String db) {
        return "INFLUXDB".equals(db);
    }

    @Override
    public boolean isTDengine() {
        return AbstractSQLConfig.isTDengine(this.getSQLDatabase());
    }

    public static boolean isTDengine(String db) {
        return "TDENGINE".equals(db);
    }

    @Override
    public boolean isRedis() {
        return AbstractSQLConfig.isRedis(this.getSQLDatabase());
    }

    public static boolean isRedis(String db) {
        return "REDIS".equals(db);
    }

    @Override
    public boolean isMQ() {
        return AbstractSQLConfig.isMQ(this.getSQLDatabase());
    }

    public static boolean isMQ(String db) {
        return "MQ".equals(db);
    }

    @Override
    public String getQuote() {
        if (this.isElasticsearch()) {
            return "";
        }
        return this.isMySQL() || this.isMariaDB() || this.isTiDB() || this.isClickHouse() || this.isTDengine() ? "`" : "\"";
    }

    public String quote(String s) {
        String q = this.getQuote();
        return q + s + q;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @NotNull
    public String getSQLSchema() {
        String table = this.getTable();
        if ("Table".equals(table) || "Column".equals(table)) {
            return "information_schema";
        }
        if ("PgClass".equals(table) || "PgAttribute".equals(table)) {
            return "";
        }
        if ("SysTable".equals(table) || "SysColumn".equals(table) || "ExtendedProperty".equals(table)) {
            return "sys";
        }
        if ("AllTable".equals(table) || "AllColumn".equals(table) || "AllTableComment".equals(table) || "AllTableComment".equals(table)) {
            return "";
        }
        String sch = this.getSchema();
        return sch == null ? DEFAULT_SCHEMA : sch;
    }

    @Override
    public AbstractSQLConfig setSchema(String schema) {
        if (schema != null) {
            AbstractFunctionParser.verifySchema(schema, this.getTable());
        }
        this.schema = schema;
        return this;
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }

    @Override
    public SQLConfig setDatasource(String datasource) {
        this.datasource = datasource;
        return this;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    @JSONField(serialize=false)
    public String getSQLTable() {
        String ot = this.getTable();
        String nt = TABLE_KEY_MAP.get(ot);
        return StringUtil.isEmpty(nt) ? ot : nt;
    }

    @Override
    @JSONField(serialize=false)
    public String getTablePath() {
        String q = this.getQuote();
        String sch = this.getSQLSchema();
        String sqlTable = this.getSQLTable();
        return (StringUtil.isEmpty(sch, true) ? "" : q + sch + q + ".") + q + sqlTable + q + (this.isKeyPrefix() ? " AS " + this.getAliasWithQuote() : "");
    }

    @Override
    public AbstractSQLConfig setTable(String table) {
        this.table = table;
        return this;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public AbstractSQLConfig setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public String getAliasWithQuote() {
        String a = this.getAlias();
        if (StringUtil.isEmpty(a, true)) {
            a = this.getTable();
        }
        String q = this.getQuote();
        return q + a + q;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    public AbstractSQLConfig setGroup(String ... keys) {
        return this.setGroup(StringUtil.getString(keys));
    }

    @Override
    public AbstractSQLConfig setGroup(String group) {
        this.group = group;
        return this;
    }

    @JSONField(serialize=false)
    public String getGroupString(boolean hasPrefix) {
        String joinGroup = "";
        if (this.joinList != null) {
            boolean first = true;
            for (Join j : this.joinList) {
                String c;
                SQLConfig ocfg;
                SQLConfig cfg;
                if (j.isAppJoin() || (cfg = (ocfg = j.getOuterConfig()) != null && ocfg.getGroup() != null || j.isLeftOrRightJoin() ? ocfg : j.getJoinConfig()) == null) continue;
                cfg.setMain(false).setKeyPrefix(true);
                if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                    cfg.setAlias(cfg.getTable());
                }
                if (StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getGroupString(false), true)) continue;
                joinGroup = joinGroup + (first ? "" : ", ") + c;
                first = false;
            }
        }
        this.group = StringUtil.getTrimedString(this.group);
        Object[] keys = StringUtil.split(this.group);
        if (keys == null || keys.length <= 0) {
            return StringUtil.isEmpty(joinGroup, true) ? "" : (hasPrefix ? " GROUP BY " : "") + joinGroup;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.isPrepared() && !StringUtil.isName(keys[i])) {
                throw new IllegalArgumentException("@group:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879\u90fd\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u7a7a\u683c\uff01");
            }
            keys[i] = this.getKey(keys[i]);
        }
        return (hasPrefix ? " GROUP BY " : "") + StringUtil.concat(StringUtil.getString(keys), joinGroup, ", ");
    }

    @Override
    public String getHavingCombine() {
        return this.havingCombine;
    }

    @Override
    public SQLConfig setHavingCombine(String havingCombine) {
        this.havingCombine = havingCombine;
        return this;
    }

    @Override
    public Map<String, Object> getHaving() {
        return this.having;
    }

    @Override
    public SQLConfig setHaving(Map<String, Object> having) {
        this.having = having;
        return this;
    }

    public AbstractSQLConfig setHaving(String ... conditions) {
        return this.setHaving(StringUtil.getString(conditions));
    }

    @JSONField(serialize=false)
    public String getHavingString(boolean hasPrefix) throws Exception {
        Map<String, Object> map;
        Set<Map.Entry<String, Object>> set;
        String joinHaving = "";
        if (this.joinList != null) {
            boolean first = true;
            for (Join j : this.joinList) {
                String c;
                SQLConfig ocfg;
                SQLConfig cfg;
                if (j.isAppJoin() || (cfg = (ocfg = j.getOuterConfig()) != null && ocfg.getHaving() != null || j.isLeftOrRightJoin() ? ocfg : j.getJoinConfig()) == null) continue;
                cfg.setMain(false).setKeyPrefix(true);
                if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                    cfg.setAlias(cfg.getTable());
                }
                if (StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getHavingString(false), true)) continue;
                joinHaving = joinHaving + (first ? "" : ", ") + c;
                first = false;
            }
        }
        Set<Map.Entry<String, Object>> set2 = set = (map = this.getHaving()) == null ? null : map.entrySet();
        if (set == null || set.isEmpty()) {
            return StringUtil.isEmpty(joinHaving, true) ? "" : (hasPrefix ? " HAVING " : "") + joinHaving;
        }
        List<String> raw = this.getRaw();
        boolean containRaw = raw != null && raw.contains("@having");
        String havingString = this.parseCombineExpression(this.getMethod(), this.getQuote(), this.getTable(), this.getAliasWithQuote(), map, this.getHavingCombine(), true, containRaw, true);
        return (hasPrefix ? " HAVING " : "") + StringUtil.concat(havingString, joinHaving, " AND ");
    }

    protected String getHavingItem(String quote, String table, String alias, String key, String expression, boolean containRaw) throws Exception {
        String rawSQL;
        if (containRaw && (rawSQL = this.getRawSQL("@having", expression)) != null) {
            return rawSQL;
        }
        if (expression.length() > 100) {
            throw new UnsupportedOperationException("@having:value \u7684 value \u4e2d\u5b57\u7b26\u4e32 " + expression + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26\u7684\u51fd\u6570\u6216\u8868\u8fbe\u5f0f\uff01\u8bf7\u7528 @raw \u7b80\u5316\u4f20\u53c2\uff01");
        }
        int start = expression.indexOf("(");
        if (start < 0) {
            if (this.isPrepared() && !PATTERN_FUNCTION.matcher(expression).matches()) {
                throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + expression + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d column?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_FUNCTION + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \uff01\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
            }
            return expression;
        }
        int end = expression.lastIndexOf(")");
        if (start >= end) {
            throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01@having:value \u4e2d value \u91cc\u7684 SQL\u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
        }
        String method = expression.substring(0, start);
        if (!method.isEmpty()) {
            if (SQL_FUNCTION_MAP == null || SQL_FUNCTION_MAP.isEmpty()) {
                if (!StringUtil.isName(method)) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + method + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @having:\"column?value;function(arg0,arg1,...)?value...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01");
                }
            } else if (!SQL_FUNCTION_MAP.containsKey(method)) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + method + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e14\u5fc5\u987b\u662f\u540e\u7aef\u5141\u8bb8\u8c03\u7528\u7684 SQL \u51fd\u6570!");
            }
        }
        return method + this.parseSQLExpression("@having", expression.substring(start), containRaw, false, null);
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    public AbstractSQLConfig setOrder(String ... conditions) {
        return this.setOrder(StringUtil.getString(conditions));
    }

    @Override
    public AbstractSQLConfig setOrder(String order) {
        this.order = order;
        return this;
    }

    @JSONField(serialize=false)
    public String getOrderString(boolean hasPrefix) {
        Object[] keys;
        String joinOrder = "";
        if (this.joinList != null) {
            boolean first = true;
            for (Join j : this.joinList) {
                String c;
                SQLConfig ocfg;
                SQLConfig cfg;
                if (j.isAppJoin() || (cfg = (ocfg = j.getOuterConfig()) != null && ocfg.getOrder() != null || j.isLeftOrRightJoin() ? ocfg : j.getJoinConfig()) == null) continue;
                cfg.setMain(false).setKeyPrefix(true);
                if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                    cfg.setAlias(cfg.getTable());
                }
                if (StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getOrderString(false), true)) continue;
                joinOrder = joinOrder + (first ? "" : ", ") + c;
                first = false;
            }
        }
        String order = StringUtil.getTrimedString(this.getOrder());
        if (this.getCount() > 0 && (this.isSQLServer() || this.isDb2()) && StringUtil.isEmpty(order, true)) {
            String idKey = this.getIdKey();
            if (StringUtil.isEmpty(idKey, true)) {
                idKey = "id";
            }
            order = idKey;
        }
        if ((keys = StringUtil.split(order)) == null || keys.length <= 0) {
            return StringUtil.isEmpty(joinOrder, true) ? "" : (hasPrefix ? " ORDER BY " : "") + joinOrder;
        }
        for (int i = 0; i < keys.length; ++i) {
            String origin;
            String sort;
            int index;
            String item = keys[i];
            if ("rand()".equals(item)) continue;
            int n = index = item.endsWith("+") ? item.length() - 1 : -1;
            if (index < 0) {
                index = item.endsWith("-") ? item.length() - 1 : -1;
                sort = index <= 0 ? "" : " DESC ";
            } else {
                sort = " ASC ";
            }
            String string = origin = index < 0 ? item : item.substring(0, index);
            if (this.isPrepared() && !StringUtil.isName(origin)) {
                throw new IllegalArgumentException("\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @order:value \u4e2d " + item + " \u4e0d\u5408\u6cd5! value \u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879\u5fc5\u987b\u662f \u968f\u673a\u51fd\u6570 rand() \u6216 column+ / column- \u4e14\u5176\u4e2d column \u5fc5\u987b\u662f 1 \u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
            }
            keys[i] = this.getKey(origin) + sort;
        }
        return (hasPrefix ? " ORDER BY " : "") + StringUtil.concat(StringUtil.getString(keys), joinOrder, ", ");
    }

    @Override
    public List<String> getRaw() {
        return this.raw;
    }

    @Override
    public SQLConfig setRaw(List<String> raw) {
        this.raw = raw;
        return this;
    }

    @Override
    public String getRawSQL(String key, Object value) throws Exception {
        return this.getRawSQL(key, value, false);
    }

    @Override
    public String getRawSQL(String key, Object value, boolean throwWhenMissing) throws Exception {
        String rawSQL;
        boolean containRaw;
        if (value == null) {
            return null;
        }
        List<String> rawList = this.getRaw();
        boolean bl = containRaw = rawList != null && rawList.contains(key);
        if (containRaw && !(value instanceof String)) {
            throw new UnsupportedOperationException("@raw:value \u7684 value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01\u5bf9\u5e94\u7684 " + key + ":value \u4e2d value \u7c7b\u578b\u53ea\u80fd\u4e3a String\uff01");
        }
        String string = rawSQL = containRaw ? RAW_MAP.get(value) : null;
        if (containRaw) {
            if (rawSQL == null) {
                if (throwWhenMissing) {
                    throw new UnsupportedOperationException("@raw:value \u7684 value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01\u5bf9\u5e94\u7684 " + key + ":value \u4e2d value \u503c " + value + " \u672a\u5728\u540e\u7aef RAW_MAP \u4e2d\u914d\u7f6e \uff01");
                }
            } else if (rawSQL.isEmpty()) {
                return (String)value;
            }
        }
        return rawSQL;
    }

    @Override
    public List<String> getJson() {
        return this.json;
    }

    @Override
    public AbstractSQLConfig setJson(List<String> json) {
        this.json = json;
        return this;
    }

    @Override
    public Subquery getFrom() {
        return this.from;
    }

    @Override
    public AbstractSQLConfig setFrom(Subquery from) {
        this.from = from;
        return this;
    }

    @Override
    public List<String> getColumn() {
        return this.column;
    }

    @Override
    public AbstractSQLConfig setColumn(List<String> column) {
        this.column = column;
        return this;
    }

    @JSONField(serialize=false)
    public String getColumnString() throws Exception {
        return this.getColumnString(false);
    }

    @JSONField(serialize=false)
    public String getColumnString(boolean inSQLJoin) throws Exception {
        List<String> column = this.getColumn();
        switch (this.getMethod()) {
            case HEAD: 
            case HEADS: {
                String c0;
                if (this.isPrepared() && column != null) {
                    List<String> raw = this.getRaw();
                    boolean containRaw = raw != null && raw.contains("@column");
                    for (String c : column) {
                        String alias;
                        if (containRaw && ("".equals(RAW_MAP.get(c)) || RAW_MAP.containsValue(c))) continue;
                        int index = c.lastIndexOf(":");
                        String origin = index < 0 ? c : c.substring(0, index);
                        String string = alias = index < 0 ? null : c.substring(index + 1);
                        if (alias != null && !StringUtil.isName(alias)) {
                            throw new IllegalArgumentException("HEAD\u8bf7\u6c42: \u5b57\u7b26 " + alias + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                        }
                        if (StringUtil.isName(origin)) continue;
                        int start = origin.indexOf("(");
                        if (start < 0 || origin.lastIndexOf(")") <= start) {
                            throw new IllegalArgumentException("HEAD\u8bf7\u6c42: \u5b57\u7b26" + origin + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219 alias \u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                        }
                        if (start <= 0 || StringUtil.isName(origin.substring(0, start))) continue;
                        throw new IllegalArgumentException("HEAD\u8bf7\u6c42: \u5b57\u7b26 " + origin.substring(0, start) + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                    }
                }
                boolean onlyOne = column != null && column.size() == 1;
                String string = c0 = onlyOne ? column.get(0) : null;
                if (onlyOne) {
                    int end;
                    int index;
                    int n = index = c0 == null ? -1 : c0.lastIndexOf(":");
                    if (index > 0) {
                        c0 = c0.substring(0, index);
                    }
                    int start = c0 == null ? -1 : c0.indexOf("(");
                    int n2 = end = start <= 0 ? -1 : c0.lastIndexOf(")");
                    if (start > 0 && end > start) {
                        String[] args;
                        String fun = c0.substring(0, start);
                        if (SQL_AGGREGATE_FUNCTION_MAP.containsKey(fun)) {
                            String group = this.getGroup();
                            return StringUtil.isEmpty(group, true) ? "1" : "count(DISTINCT " + group + ")";
                        }
                        String[] stringArray = args = start == end - 1 ? null : StringUtil.split(c0.substring(start + 1, end));
                        if (args == null || args.length <= 0) {
                            return SQL.count(c0);
                        }
                        List<String> raw = this.getRaw();
                        boolean containRaw = raw != null && raw.contains("@column");
                        return SQL.count(this.parseSQLExpression("@column", c0, containRaw, false, null));
                    }
                }
                return SQL.count(onlyOne ? this.getKey(c0) : "*");
            }
            case POST: {
                if (column == null || column.isEmpty()) {
                    throw new IllegalArgumentException("POST \u8bf7\u6c42\u5fc5\u987b\u5728Table\u5185\u8bbe\u7f6e\u8981\u4fdd\u5b58\u7684 key:value \uff01");
                }
                String s = "";
                boolean pfirst = true;
                for (String c : column) {
                    if (this.isPrepared() && !StringUtil.isName(c)) {
                        throw new IllegalArgumentException("POST\u8bf7\u6c42: \u6bcf\u4e00\u4e2a key:value \u4e2d\u7684key\u90fd\u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01");
                    }
                    s = s + (pfirst ? "" : ",") + this.getKey(c);
                    pfirst = false;
                }
                return "(" + s + ")";
            }
            case GET: 
            case GETS: {
                Object[] keys;
                String joinColumn = "";
                if (this.joinList != null) {
                    boolean first = true;
                    for (Join j : this.joinList) {
                        if (j.isAppJoin()) continue;
                        SQLConfig ocfg = j.getOuterConfig();
                        boolean isEmpty = ocfg == null || ocfg.getColumn() == null;
                        boolean isLeftOrRightJoin = j.isLeftOrRightJoin();
                        if (isEmpty && isLeftOrRightJoin) {
                            String quote = this.getQuote();
                            joinColumn = joinColumn + (first ? "" : ", ") + quote + (StringUtil.isEmpty(j.getAlias(), true) ? j.getTable() : j.getAlias()) + quote + ".*";
                            first = false;
                        } else {
                            SQLConfig cfg;
                            SQLConfig sQLConfig = cfg = !isLeftOrRightJoin && isEmpty ? j.getJoinConfig() : ocfg;
                            if (cfg != null) {
                                String c;
                                cfg.setMain(false).setKeyPrefix(true);
                                if (StringUtil.isEmpty(cfg.getAlias(), true)) {
                                    cfg.setAlias(cfg.getTable());
                                }
                                if (!StringUtil.isEmpty(c = ((AbstractSQLConfig)cfg).getColumnString(true), true)) {
                                    joinColumn = joinColumn + (first ? "" : ", ") + c;
                                    first = false;
                                }
                            }
                        }
                        inSQLJoin = true;
                    }
                }
                String tableAlias = this.getAliasWithQuote();
                Object[] objectArray = keys = column == null ? null : column.toArray(new String[0]);
                if (keys == null || keys.length <= 0) {
                    boolean noColumn;
                    boolean bl = noColumn = column != null && inSQLJoin;
                    String mc = !this.isKeyPrefix() ? (noColumn ? "" : "*") : (noColumn ? "" : tableAlias + ".*");
                    return StringUtil.concat(mc, joinColumn, ", ", true);
                }
                List<String> raw = this.getRaw();
                boolean containRaw = raw != null && raw.contains("@column");
                for (int i = 0; i < keys.length; ++i) {
                    Object expression = keys[i];
                    if (containRaw && ("".equals(RAW_MAP.get(expression)) || RAW_MAP.containsValue(expression))) continue;
                    if (((String)expression).length() > 100) {
                        throw new UnsupportedOperationException("@column:value \u7684 value \u4e2d\u5b57\u7b26\u4e32 " + (String)expression + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26\u7684\u51fd\u6570\u6216\u8868\u8fbe\u5f0f\uff01\u8bf7\u7528 @raw \u7b80\u5316\u4f20\u53c2\uff01");
                    }
                    keys[i] = this.parseSQLExpression("@column", (String)expression, containRaw, true, "@column:\"column0,column1:alias1;function0(arg0,arg1,...);function1(...):alias2...\"");
                }
                String c = StringUtil.getString(keys);
                c = c + (StringUtil.isEmpty(joinColumn, true) ? "" : ", " + joinColumn);
                return this.isMain() && this.isDistinct() ? PREFIX_DISTINCT + c : c;
            }
        }
        throw new UnsupportedOperationException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1agetColumnString \u4e0d\u652f\u6301 " + RequestMethod.getName(this.getMethod()) + " \u7b49 [GET,GETS,HEAD,HEADS,POST] \u5916\u7684ReuqestMethod\uff01");
    }

    public String parseSQLExpression(String key, String expression, boolean containRaw, boolean allowAlias) {
        return this.parseSQLExpression(key, expression, containRaw, allowAlias, null);
    }

    public String parseSQLExpression(String key, String expression, boolean containRaw, boolean allowAlias, String example) {
        String quote = this.getQuote();
        int start = expression.indexOf(40);
        if (start < 0) {
            Object[] cks = this.parseArgsSplitWithComma(expression, true, containRaw, allowAlias);
            expression = StringUtil.getString(cks);
        } else {
            boolean containAgainst;
            if (StringUtil.isEmpty(example)) {
                example = "@column".equals(key) ? key + ":\"column0,column1:alias1;function0(arg0,arg1,...);function1(...):alias2...\"" : key + ":\"column0!=0;column1+3*2<=10;function0(arg0,arg1,...)>1;function1(...)%5<=3...\"";
            }
            int overIndex = expression.indexOf(")OVER(");
            int againstIndex = expression.indexOf(")AGAINST(");
            boolean containOver = overIndex > 0 && overIndex < expression.length() - ")OVER(".length();
            boolean bl = containAgainst = againstIndex > 0 && againstIndex < expression.length() - ")AGAINST(".length();
            if (containOver && containAgainst) {
                throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + example + " \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u7a97\u53e3\u51fd\u6570\u5173\u952e\u8bcd OVER \u548c\u5168\u6587\u7d22\u5f15\u5173\u952e\u8bcd AGAINST\uff01");
            }
            if (!containOver && !containAgainst) {
                String s;
                boolean distinct;
                int end = expression.lastIndexOf(41);
                if (start >= end) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01" + key + ":value \u4e2d value \u91cc\u7684 SQL\u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
                }
                String fun = expression.substring(0, start);
                if (!fun.isEmpty()) {
                    if (SQL_FUNCTION_MAP == null || SQL_FUNCTION_MAP.isEmpty()) {
                        if (!StringUtil.isName(fun)) {
                            throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + example + " \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01");
                        }
                    } else if (!SQL_FUNCTION_MAP.containsKey(fun)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + example + " \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e14\u5fc5\u987b\u662f\u540e\u7aef\u5141\u8bb8\u8c03\u7528\u7684 SQL \u51fd\u6570!");
                    }
                }
                if (distinct = (s = expression.substring(start + 1, end)).startsWith(PREFIX_DISTINCT)) {
                    s = s.substring(PREFIX_DISTINCT.length());
                }
                Object[] ckeys = this.parseArgsSplitWithComma(s, false, containRaw, allowAlias);
                String suffix = expression.substring(end + 1, expression.length());
                String alias = null;
                if (allowAlias) {
                    int index = suffix.lastIndexOf(":");
                    alias = index < 0 ? "" : suffix.substring(index + 1);
                    String string = suffix = index < 0 ? suffix : suffix.substring(0, index);
                    if (!alias.isEmpty() && !StringUtil.isName(alias)) {
                        throw new IllegalArgumentException("\u5b57\u7b26\u4e32 " + alias + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + key + ":value \u4e2d value\u91cc\u9762\u7528 ; \u5206\u5272\u7684\u6bcf\u4e00\u9879 function(arg0,arg1,...):alias \u4e2d alias \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                    }
                }
                if (!suffix.isEmpty() && (suffix.contains("--") || suffix.contains("/*") || !PATTERN_RANGE.matcher(suffix).matches())) {
                    throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + suffix + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + key + ":\"column?value;function(arg0,arg1,...)?value...\" \u4e2d ?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_RANGE + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \u6216\u6ce8\u91ca\u7b26 /* \uff01\u4e0d\u5141\u8bb8\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                }
                String origin = fun + "(" + (distinct ? PREFIX_DISTINCT : "") + StringUtil.getString(ckeys) + ")" + suffix;
                expression = origin + (StringUtil.isEmpty(alias, true) ? "" : " AS " + quote + alias + quote);
            } else {
                String alias;
                int end;
                int keyIndex = containOver ? overIndex : againstIndex;
                String s1 = expression.substring(0, keyIndex + 1);
                String s2 = expression.substring(keyIndex + 1);
                int index1 = s1.indexOf("(");
                if (index1 >= (end = s2.lastIndexOf(")")) + s1.length()) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + expression + " \u4e0d\u5408\u6cd5\uff01" + key + ":value \u4e2d value \u91cc\u7684 SQL \u51fd\u6570\u5fc5\u987b\u4e3a function(arg0,arg1,...) \u8fd9\u79cd\u683c\u5f0f\uff01");
                }
                String fun = s1.substring(0, index1);
                if (!fun.isEmpty()) {
                    if (SQL_FUNCTION_MAP == null || SQL_FUNCTION_MAP.isEmpty()) {
                        if (!StringUtil.isName(fun)) {
                            throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + example + " \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01");
                        }
                    } else if (!SQL_FUNCTION_MAP.containsKey(fun)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + fun + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + example + " \u4e2d function \u5fc5\u987b\u7b26\u5408\u5c0f\u5199\u82f1\u6587\u5355\u8bcd\u7684 SQL \u51fd\u6570\u540d\u683c\u5f0f\uff01\u4e14\u5fc5\u987b\u662f\u540e\u7aef\u5141\u8bb8\u8c03\u7528\u7684 SQL \u51fd\u6570!");
                    }
                }
                Object[] agrsString1 = this.parseArgsSplitWithComma(s1.substring(index1 + 1, s1.lastIndexOf(")")), false, containRaw, allowAlias);
                int index2 = s2.indexOf("(");
                String argString2 = s2.substring(index2 + 1, end);
                int aliasIndex = !allowAlias ? -1 : s2.lastIndexOf(":");
                String string = alias = aliasIndex < 0 ? "" : s2.substring(aliasIndex + 1);
                if (!alias.isEmpty() && !StringUtil.isName(alias)) {
                    throw new IllegalArgumentException("\u5b57\u7b26\u4e32 " + alias + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + key + ":value \u4e2d value\u91cc\u9762\u7528 ; \u5206\u5272\u7684\u6bcf\u4e00\u9879 function(arg0,arg1,...):alias \u4e2d alias \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5e76\u4e14\u4e0d\u8981\u6709\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                }
                String suffix = s2.substring(end + 1, aliasIndex < 0 ? s2.length() : aliasIndex);
                if (!suffix.isEmpty() && (suffix.contains("--") || suffix.contains("/*") || !PATTERN_RANGE.matcher(suffix).matches())) {
                    throw new UnsupportedOperationException("\u5b57\u7b26\u4e32 " + suffix + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b " + key + ":\"column?value;function(arg0,arg1,...)?value...\" \u4e2d ?value \u5fc5\u987b\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_RANGE + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \u6216\u6ce8\u91ca\u7b26 /* \uff01\u4e0d\u5141\u8bb8\u591a\u4f59\u7684\u7a7a\u683c\uff01");
                }
                Object[] argsString2 = this.parseArgsSplitWithComma(argString2, false, containRaw, allowAlias);
                expression = fun + "(" + StringUtil.getString(agrsString1) + (containOver ? ") OVER (" : ") AGAINST (") + StringUtil.getString(argsString2) + ")" + suffix + (StringUtil.isEmpty(alias, true) ? "" : " AS " + quote + alias + quote);
            }
        }
        return expression;
    }

    private String[] parseArgsSplitWithComma(String param, boolean isColumn, boolean containRaw, boolean allowAlias) {
        String quote = this.getQuote();
        boolean isKeyPrefix = this.isKeyPrefix();
        String tableAlias = this.getAliasWithQuote();
        String[] ckeys = StringUtil.split(param);
        if (ckeys != null && ckeys.length > 0) {
            for (int i = 0; i < ckeys.length; ++i) {
                String origin;
                String ck = ckeys[i];
                if (ck.startsWith("`") && ck.endsWith("`")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.startsWith("_") || !StringUtil.isName(origin)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"`column0`,`column1`:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709\u5b57\u7b26\u4e32 column \u90fd\u5fc5\u987b\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd \uff01");
                    }
                    origin = this.getKey(origin).toString();
                } else if (ck.startsWith("'") && ck.endsWith("'")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.contains("'")) {
                        throw new IllegalArgumentException("\u5b57\u7b26\u4e32 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u5b57\u7b26\u4e32\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4ee5 ' \u5f00\u5934, ' \u7ed3\u5c3e,\u5b57\u7b26\u4e32\u4e2d\u4e0d\u80fd\u5305\u542b ' ");
                    }
                    origin = this.getValue(origin).toString();
                } else if ("=null".equals(ck)) {
                    origin = SQL.isNull();
                } else if ("!=null".equals(ck)) {
                    origin = SQL.isNull(false);
                } else {
                    String[] stringArray;
                    origin = ck;
                    String alias = null;
                    if (allowAlias) {
                        int index = isColumn ? ck.lastIndexOf(":") : -1;
                        origin = index < 0 ? ck : ck.substring(0, index);
                        String string = alias = index < 0 ? null : ck.substring(index + 1);
                        if (this.isPrepared()) {
                            if (isColumn) {
                                if (!StringUtil.isName(origin) || alias != null && !StringUtil.isName(alias)) {
                                    throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:value \u4e2d value\u91cc\u9762\u7528 , \u5206\u5272\u7684\u6bcf\u4e00\u9879 column:alias \u4e2d column \u5fc5\u987b\u662f1\u4e2a\u5355\u8bcd\uff01\u5982\u679c\u6709alias\uff0c\u5219alias\u4e5f\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd\uff01\u5173\u952e\u5b57\u5fc5\u987b\u5168\u5927\u5199\uff0c\u4e14\u4ee5\u7a7a\u683c\u5206\u9694\u7684\u53c2\u6570\uff0c\u7a7a\u683c\u5fc5\u987b\u53ea\u6709 1 \u4e2a\uff01\u5176\u5b83\u60c5\u51b5\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                                }
                            } else if (origin.startsWith("_") || origin.contains("--")) {
                                throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709 arg \u90fd\u5fc5\u987b\u662f1\u4e2a\u4e0d\u4ee5 _ \u5f00\u5934\u7684\u5355\u8bcd \u6216\u8005\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_FUNCTION + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \uff01DISTINCT \u5fc5\u987b\u5168\u5927\u5199\uff0c\u4e14\u540e\u9762\u5fc5\u987b\u6709\u4e14\u53ea\u6709 1 \u4e2a\u7a7a\u683c\uff01\u5176\u5b83\u60c5\u51b5\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                            }
                        }
                    }
                    if (containRaw) {
                        stringArray = StringUtil.split(ck, " ", true);
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = ck;
                    }
                    String[] mkes = stringArray;
                    if (mkes != null && mkes.length >= 2) {
                        origin = this.parseArgsSplitWithSpace(mkes);
                    } else {
                        String mk = RAW_MAP.get(origin);
                        if (mk != null) {
                            if (mk.length() > 0) {
                                origin = mk;
                            }
                        } else if (!StringUtil.isNumer(origin)) {
                            String s;
                            int len;
                            String[] keys = origin.split("[.]");
                            StringBuilder sb = new StringBuilder();
                            int n = len = keys == null ? 0 : keys.length;
                            if (len > 0) {
                                boolean first = true;
                                for (String k : keys) {
                                    if (!StringUtil.isName(k)) {
                                        sb = null;
                                        break;
                                    }
                                    sb.append(first ? "" : ".").append(quote).append(k).append(quote);
                                    first = false;
                                }
                            }
                            String string = s = sb == null ? null : sb.toString();
                            origin = StringUtil.isNotEmpty(s, true) ? (len == 1 && isKeyPrefix ? tableAlias + "." : "") + s : this.getValue(origin).toString();
                        }
                        if (isColumn && !StringUtil.isEmpty(alias, true)) {
                            origin = origin + " AS " + quote + alias + quote;
                        }
                    }
                }
                ckeys[i] = origin;
            }
        }
        return ckeys;
    }

    private String parseArgsSplitWithSpace(String[] mkes) {
        String quote = this.getQuote();
        boolean isKeyPrefix = this.isKeyPrefix();
        String tableAlias = this.getAliasWithQuote();
        if (mkes != null && mkes.length > 0) {
            for (int j = 0; j < mkes.length; ++j) {
                String origin = mkes[j];
                String mk = RAW_MAP.get(origin);
                if (mk != null) {
                    if (mk.length() <= 0) continue;
                    mkes[j] = mk;
                    continue;
                }
                String ck = origin;
                if (ck.startsWith("`") && ck.endsWith("`")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.startsWith("_") || !StringUtil.isName(origin)) {
                        throw new IllegalArgumentException("\u5b57\u7b26 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"`column0`,`column1`:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709\u5b57\u7b26\u4e32 column \u90fd\u5fc5\u987b\u5fc5\u987b\u4e3a1\u4e2a\u5355\u8bcd \uff01");
                    }
                    mkes[j] = this.getKey(origin);
                    continue;
                }
                if (ck.startsWith("'") && ck.endsWith("'")) {
                    origin = ck.substring(1, ck.length() - 1);
                    if (origin.contains("'")) {
                        throw new IllegalArgumentException("\u5b57\u7b26\u4e32 " + ck + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u5b57\u7b26\u4e32\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4ee5 ' \u5f00\u5934, ' \u7ed3\u5c3e,\u5b57\u7b26\u4e32\u4e2d\u4e0d\u80fd\u5305\u542b ' ");
                    }
                    mkes[j] = this.getValue(origin).toString();
                    continue;
                }
                if (ck.contains("`") || ck.contains("'") || origin.startsWith("_") || origin.contains("--")) {
                    throw new IllegalArgumentException("\u5b57\u7b26 " + origin + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b @column:\"column0,column1:alias;function0(arg0,arg1,...);function1(...):alias...\" \u4e2d\u6240\u6709 arg \u90fd\u5fc5\u987b\u662f1\u4e2a\u4e0d\u4ee5 _ \u5f00\u5934\u7684\u5355\u8bcd \u6216\u8005\u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_FUNCTION + " \u4e14\u4e0d\u5305\u542b\u8fde\u7eed\u51cf\u53f7 -- \uff01DISTINCT \u5fc5\u987b\u5168\u5927\u5199\uff0c\u4e14\u540e\u9762\u5fc5\u987b\u6709\u4e14\u53ea\u6709 1 \u4e2a\u7a7a\u683c\uff01\u5176\u5b83\u60c5\u51b5\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                }
                if (!StringUtil.isNumer(origin)) {
                    String s;
                    int len;
                    String[] keys = origin.split("[.]");
                    StringBuilder sb = new StringBuilder();
                    int n = len = keys == null ? 0 : keys.length;
                    if (len > 0) {
                        boolean first = true;
                        for (String k : keys) {
                            if (!StringUtil.isName(k)) {
                                sb = null;
                                break;
                            }
                            sb.append(first ? "" : ".").append(quote).append(k).append(quote);
                            first = false;
                        }
                    }
                    String string = s = sb == null ? null : sb.toString();
                    origin = StringUtil.isNotEmpty(s, true) ? (len == 1 && isKeyPrefix ? tableAlias + "." : "") + s : this.getValue(origin).toString();
                }
                mkes[j] = origin;
            }
        }
        return StringUtil.join(mkes, " ");
    }

    @Override
    public List<List<Object>> getValues() {
        return this.values;
    }

    @JSONField(serialize=false)
    public String getValuesString() {
        String s = "";
        if (this.values != null && this.values.size() > 0) {
            Object[] items = new Object[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                List<Object> vs = this.values.get(i);
                if (vs == null) continue;
                items[i] = "(";
                for (int j = 0; j < vs.size(); ++j) {
                    int n = i;
                    items[n] = items[n] + (j <= 0 ? "" : ",") + this.getValue(vs.get(j));
                }
                int n = i;
                items[n] = items[n] + ")";
            }
            s = StringUtil.getString(items);
        }
        return s;
    }

    @Override
    public AbstractSQLConfig setValues(List<List<Object>> valuess) {
        this.values = valuess;
        return this;
    }

    @Override
    public Map<String, Object> getContent() {
        return this.content;
    }

    @Override
    public AbstractSQLConfig setContent(Map<String, Object> content) {
        this.content = content;
        return this;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public AbstractSQLConfig setCount(int count) {
        this.count = count;
        return this;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public AbstractSQLConfig setPage(int page) {
        this.page = page;
        return this;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public AbstractSQLConfig setPosition(int position) {
        this.position = position;
        return this;
    }

    @Override
    public int getQuery() {
        return this.query;
    }

    @Override
    public AbstractSQLConfig setQuery(int query) {
        this.query = query;
        return this;
    }

    @Override
    public Boolean getCompat() {
        return this.compat;
    }

    @Override
    public AbstractSQLConfig setCompat(Boolean compat) {
        this.compat = compat;
        return this;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public AbstractSQLConfig setType(int type) {
        this.type = type;
        return this;
    }

    @Override
    public int getCache() {
        return this.cache;
    }

    @Override
    public AbstractSQLConfig setCache(int cache) {
        this.cache = cache;
        return this;
    }

    public AbstractSQLConfig setCache(String cache) {
        return this.setCache(AbstractSQLConfig.getCache(cache));
    }

    public static int getCache(String cache) {
        int cache2;
        if (cache == null) {
            cache2 = 0;
        } else {
            switch (cache) {
                case "0": 
                case "ALL": {
                    cache2 = 0;
                    break;
                }
                case "1": 
                case "ROM": {
                    cache2 = 1;
                    break;
                }
                case "2": 
                case "RAM": {
                    cache2 = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("@cache:value \u4e2d value \u7684\u503c\u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u5728 [0,1,2] \u6216 [ALL, ROM, RAM] \u5185 !");
                }
            }
        }
        return cache2;
    }

    @Override
    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public AbstractSQLConfig setExplain(boolean explain) {
        this.explain = explain;
        return this;
    }

    @Override
    public List<Join> getJoinList() {
        return this.joinList;
    }

    @Override
    public SQLConfig setJoinList(List<Join> joinList) {
        this.joinList = joinList;
        return this;
    }

    @Override
    public boolean hasJoin() {
        return this.joinList != null && !this.joinList.isEmpty();
    }

    @Override
    public boolean isTest() {
        return this.test;
    }

    @Override
    public AbstractSQLConfig setTest(boolean test) {
        this.test = test;
        return this;
    }

    @JSONField(serialize=false)
    public int getOffset() {
        return AbstractSQLConfig.getOffset(this.getPage(), this.getCount());
    }

    public static int getOffset(int page, int count) {
        return page * count;
    }

    @JSONField(serialize=false)
    public String getLimitString() {
        if (this.count <= 0 || RequestMethod.isHeadMethod(this.getMethod(), true)) {
            return "";
        }
        return AbstractSQLConfig.getLimitString(this.getPage(), this.getCount(), this.isOracle() || this.isSQLServer() || this.isDb2(), this.isOracle() || this.isDameng() || this.isKingBase(), this.isPresto() || this.isTrino());
    }

    public static String getLimitString(int page, int count, boolean isTSQL, boolean isOracle) {
        return AbstractSQLConfig.getLimitString(page, count, isTSQL, isOracle, false);
    }

    public static String getLimitString(int page, int count, boolean isTSQL, boolean isOracle, boolean isPresto) {
        int offset = AbstractSQLConfig.getOffset(page, count);
        if (isOracle) {
            return " WHERE ROWNUM BETWEEN " + offset + " AND " + (offset + count);
        }
        if (isTSQL) {
            return " OFFSET " + offset + " ROWS FETCH FIRST " + count + " ROWS ONLY";
        }
        if (isPresto) {
            return (offset <= 0 ? "" : " OFFSET " + offset) + " LIMIT " + count;
        }
        return " LIMIT " + count + (offset <= 0 ? "" : " OFFSET " + offset);
    }

    @Override
    public List<String> getNull() {
        return this.nulls;
    }

    @Override
    public SQLConfig setNull(List<String> nulls) {
        this.nulls = nulls;
        return this;
    }

    @Override
    public Map<String, String> getCast() {
        return this.cast;
    }

    @Override
    public SQLConfig setCast(Map<String, String> cast) {
        this.cast = cast;
        return this;
    }

    protected int getMaxHavingCount() {
        return MAX_HAVING_COUNT;
    }

    protected int getMaxWhereCount() {
        return MAX_WHERE_COUNT;
    }

    protected int getMaxCombineDepth() {
        return MAX_COMBINE_DEPTH;
    }

    protected int getMaxCombineCount() {
        return MAX_COMBINE_COUNT;
    }

    protected int getMaxCombineKeyCount() {
        return MAX_COMBINE_KEY_COUNT;
    }

    protected float getMaxCombineRatio() {
        return MAX_COMBINE_RATIO;
    }

    @Override
    public String getCombine() {
        return this.combine;
    }

    @Override
    public AbstractSQLConfig setCombine(String combine) {
        this.combine = combine;
        return this;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getCombineMap() {
        List<String> andList;
        List<String> list = andList = this.combineMap == null ? null : this.combineMap.get("&");
        if (andList == null) {
            List<String> list2 = andList = this.where == null ? new ArrayList<String>() : new ArrayList<String>(this.where.keySet());
            if (this.combineMap == null) {
                this.combineMap = new HashMap<String, List<String>>();
            }
            this.combineMap.put("&", andList);
        }
        return this.combineMap;
    }

    @Override
    public AbstractSQLConfig setCombineMap(Map<String, List<String>> combineMap) {
        this.combineMap = combineMap;
        return this;
    }

    @Override
    public Map<String, Object> getWhere() {
        return this.where;
    }

    @Override
    public AbstractSQLConfig setWhere(Map<String, Object> where) {
        this.where = where;
        return this;
    }

    @Override
    @JSONField(serialize=false)
    public Object getWhere(String key) {
        return this.getWhere(key, false);
    }

    @Override
    @JSONField(serialize=false)
    public Object getWhere(String key, boolean exactMatch) {
        if (exactMatch) {
            return this.where == null ? null : this.where.get(key);
        }
        if (key == null || this.where == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : this.where.entrySet()) {
            String k = entry.getKey();
            int index = k.indexOf(key);
            if (index < 0 || StringUtil.isName(k.substring(index, index + 1))) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public AbstractSQLConfig putWhere(String key, Object value, boolean prior) {
        if (key != null) {
            if (this.where == null) {
                this.where = new LinkedHashMap<String, Object>();
            }
            if (value == null) {
                this.where.remove(key);
            } else {
                this.where.put(key, value);
            }
            Map<String, List<String>> combineMap = this.getCombineMap();
            List<String> andList = combineMap.get("&");
            if (value == null) {
                if (andList != null) {
                    andList.remove(key);
                }
            } else if (andList == null || !andList.contains(key)) {
                int i = 0;
                if (andList == null) {
                    andList = new ArrayList<String>();
                } else if (prior && !andList.isEmpty()) {
                    int lastIndex;
                    String idKey = this.getIdKey();
                    String idInKey = idKey + "{}";
                    String userIdKey = this.getUserIdKey();
                    String userIdInKey = userIdKey + "{}";
                    if (key.equals(idKey)) {
                        this.setId(value);
                        lastIndex = -1;
                    } else if (key.equals(idInKey)) {
                        this.setIdIn(value);
                        lastIndex = andList.lastIndexOf(idKey);
                    } else if (key.equals(userIdKey)) {
                        this.setUserId(value);
                        lastIndex = andList.lastIndexOf(idInKey);
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idKey);
                        }
                    } else if (key.equals(userIdInKey)) {
                        this.setUserIdIn(value);
                        lastIndex = andList.lastIndexOf(userIdKey);
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idInKey);
                        }
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idKey);
                        }
                    } else {
                        lastIndex = andList.lastIndexOf(userIdInKey);
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(userIdKey);
                        }
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idInKey);
                        }
                        if (lastIndex < 0) {
                            lastIndex = andList.lastIndexOf(idKey);
                        }
                    }
                    i = lastIndex + 1;
                }
                if (prior) {
                    andList.add(i, key);
                } else {
                    andList.add(key);
                }
            }
            combineMap.put("&", andList);
        }
        return this;
    }

    @Override
    @JSONField(serialize=false)
    public String getWhereString(boolean hasPrefix) throws Exception {
        String combineExpr = this.getCombine();
        if (StringUtil.isEmpty(combineExpr, false)) {
            return this.getWhereString(hasPrefix, this.getMethod(), this.getWhere(), this.getCombineMap(), this.getJoinList(), !this.isTest());
        }
        return this.getWhereString(hasPrefix, this.getMethod(), this.getWhere(), combineExpr, this.getJoinList(), !this.isTest());
    }

    @JSONField(serialize=false)
    public String getWhereString(boolean hasPrefix, RequestMethod method, Map<String, Object> where, String combine, List<Join> joinList, boolean verifyName) throws Exception {
        String result;
        String whereString = this.parseCombineExpression(method, this.getQuote(), this.getTable(), this.getAliasWithQuote(), where, combine, verifyName, false, false);
        String string = StringUtil.isEmpty(whereString = this.concatJoinWhereString(whereString), true) ? "" : (result = (hasPrefix ? " WHERE " : "") + whereString);
        if (result.isEmpty() && !RequestMethod.isQueryMethod(method)) {
            throw new UnsupportedOperationException("\u5199\u64cd\u4f5c\u8bf7\u6c42\u5fc5\u987b\u5e26\u6761\u4ef6\uff01\uff01\uff01");
        }
        return result;
    }

    protected String parseCombineExpression(RequestMethod method, String quote, String table, String alias, Map<String, Object> conditionMap, String combine, boolean verifyName, boolean containRaw, boolean isHaving) throws Exception {
        int maxCount;
        String errPrefix = table + (isHaving ? ":{ @having:{ " : ":{ ") + "@combine:'" + combine + (isHaving ? "' } }" : "' }");
        String s = StringUtil.getString(combine);
        if (s.startsWith(" ") || s.endsWith(" ")) {
            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s + "' \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u9996\u5c3e\u6709\u7a7a\u683c\uff0c\u4e5f\u4e0d\u5141\u8bb8\u8fde\u7eed\u7a7a\u683c\uff01\u7a7a\u683c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01\u903b\u8f91\u8fde\u63a5\u7b26 & | \u5de6\u53f3\u5fc5\u987b\u5404\u4e00\u4e2a\u76f8\u90bb\u7a7a\u683c\uff01\u5de6\u62ec\u53f7 ( \u53f3\u8fb9\u548c\u53f3\u62ec\u53f7 ) \u5de6\u8fb9\u90fd\u4e0d\u5141\u8bb8\u6709\u76f8\u90bb\u7a7a\u683c\uff01");
        }
        if (conditionMap == null) {
            conditionMap = new HashMap<String, Object>();
        }
        int size = conditionMap.size();
        int n = maxCount = isHaving ? this.getMaxHavingCount() : this.getMaxWhereCount();
        if (maxCount > 0 && size > maxCount) {
            throw new IllegalArgumentException(table + (isHaving ? ":{ @having:{ " : ":{ ") + "key0:value0, key1:value1... " + combine + (isHaving ? " } }" : " }") + " \u4e2d\u6761\u4ef6 key:value \u6570\u91cf " + size + " \u5df2\u8d85\u8fc7\u6700\u5927\u6570\u91cf\uff0c\u5fc5\u987b\u5728 0-" + maxCount + " \u5185\uff01");
        }
        String result = "";
        List<Object> preparedValues = this.getPreparedValueList();
        if (preparedValues == null && !isHaving) {
            preparedValues = new ArrayList<Object>();
        }
        HashMap<String, Integer> usedKeyCountMap = new HashMap<String, Integer>(size);
        int n2 = s.length();
        if (n2 > 0) {
            if (!isHaving) {
                this.setPreparedValueList((List)new ArrayList());
            }
            int maxDepth = this.getMaxCombineDepth();
            int maxCombineCount = this.getMaxCombineCount();
            int maxCombineKeyCount = this.getMaxCombineKeyCount();
            float maxCombineRatio = this.getMaxCombineRatio();
            int depth = 0;
            int allCount = 0;
            int lastLogic = 0;
            char last = '\u0000';
            boolean first = true;
            boolean isNot = false;
            String key = "";
            for (int i = 0; i <= n2; ++i) {
                boolean isBlankOrRightParenthesis;
                boolean isOver = i >= n2;
                char c = isOver ? (char)'\u0000' : s.charAt(i);
                boolean bl = isBlankOrRightParenthesis = c == ' ' || c == ')';
                if (isOver || isBlankOrRightParenthesis) {
                    boolean isEmpty = StringUtil.isEmpty(key, true);
                    if (isEmpty && last != ')') {
                        throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + (isOver ? s : s.substring(i)) + "' \u4e0d\u5408\u6cd5\uff01" + (c == ' ' ? "\u7a7a\u683c ' ' " : "\u53f3\u62ec\u53f7 ')'") + " \u5de6\u8fb9\u7f3a\u5c11\u6761\u4ef6 key \uff01\u903b\u8f91\u8fde\u63a5\u7b26 & | \u5de6\u53f3\u5fc5\u987b\u5404\u4e00\u4e2a\u76f8\u90bb\u7a7a\u683c\uff01\u7a7a\u683c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01\u4e0d\u5141\u8bb8\u9996\u5c3e\u6709\u7a7a\u683c\uff0c\u4e5f\u4e0d\u5141\u8bb8\u8fde\u7eed\u7a7a\u683c\uff01\u5de6\u62ec\u53f7 ( \u7684\u53f3\u8fb9 \u548c \u53f3\u62ec\u53f7 ) \u7684\u5de6\u8fb9 \u90fd\u4e0d\u5141\u8bb8\u6709\u76f8\u90bb\u7a7a\u683c\uff01");
                    }
                    if (!isEmpty) {
                        if (!first && lastLogic <= 0) {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s.substring(i - key.length() - (isOver ? 1 : 0)) + "' \u4e0d\u5408\u6cd5\uff01\u5de6\u8fb9\u7f3a\u5c11 & | \u5176\u4e2d\u4e00\u4e2a\u903b\u8f91\u8fde\u63a5\u7b26\uff01");
                        }
                        if (++allCount > maxCombineCount && maxCombineCount > 0) {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s + "' \u4e0d\u5408\u6cd5\uff01\u5176\u4e2d key \u6570\u91cf " + allCount + " \u5df2\u8d85\u8fc7\u6700\u5927\u503c\uff0c\u5fc5\u987b\u5728\u6761\u4ef6\u952e\u503c\u5bf9\u6570\u91cf 0-" + maxCombineCount + " \u5185\uff01");
                        }
                        String column = key;
                        int keyIndex = column.indexOf(":");
                        column = keyIndex > 0 ? column.substring(0, keyIndex) : column;
                        Object value = conditionMap.get(column);
                        String wi = "";
                        if (value == null && !conditionMap.containsKey(column)) {
                            isNot = false;
                            ++size;
                            String string = wi = keyIndex > 0 ? key.substring(keyIndex + 1) : "";
                            if (StringUtil.isEmpty(wi)) {
                                throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + key + "' \u5bf9\u5e94\u7684\u6761\u4ef6\u952e\u503c\u5bf9 " + column + ":value \u4e0d\u5b58\u5728\uff01");
                            }
                        } else {
                            String string = wi = isHaving ? this.getHavingItem(quote, table, alias, column, (String)value, containRaw) : this.getWhereItem(column, value, method, verifyName);
                        }
                        if (1.0f * (float)allCount / (float)size > maxCombineRatio && maxCombineRatio > 0.0f) {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s + "' \u4e0d\u5408\u6cd5\uff01\u5176\u4e2d key \u6570\u91cf " + allCount + " / \u6761\u4ef6\u952e\u503c\u5bf9\u6570\u91cf " + size + " = " + 1.0f * (float)allCount / (float)size + " \u5df2\u8d85\u8fc7 \u6700\u5927\u500d\u6570\uff0c\u5fc5\u987b\u5728\u6761\u4ef6\u952e\u503c\u5bf9\u6570\u91cf 0-" + maxCombineRatio + " \u500d\u5185\uff01");
                        }
                        if (StringUtil.isEmpty(wi, true)) {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + key + "' \u5bf9\u5e94\u7684 " + column + ":value \u4e0d\u662f\u6709\u6548\u6761\u4ef6\u952e\u503c\u5bf9\uff01");
                        }
                        Integer count = (Integer)usedKeyCountMap.get(column);
                        count = count == null ? 1 : count + 1;
                        if (count > maxCombineKeyCount && maxCombineKeyCount > 0) {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s + "' \u4e0d\u5408\u6cd5\uff01\u5176\u4e2d '" + column + "' \u91cd\u590d\u5f15\u7528\uff0c\u6b21\u6570 " + count + " \u5df2\u8d85\u8fc7\u6700\u5927\u503c\uff0c\u5fc5\u987b\u5728 0-" + maxCombineKeyCount + " \u5185\uff01");
                        }
                        usedKeyCountMap.put(column, count);
                        result = result + "( " + AbstractSQLConfig.getCondition(isNot, wi) + " )";
                        isNot = false;
                        first = false;
                    }
                    key = "";
                    lastLogic = 0;
                    if (isOver) break;
                }
                if (c != ' ') {
                    if (c == '&') {
                        if (last == ' ') {
                            if (i >= n2 - 1 || s.charAt(i + 1) != ' ') {
                                throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + (i >= n2 - 1 ? s : s.substring(0, i + 1)) + "' \u4e0d\u5408\u6cd5\uff01\u903b\u8f91\u8fde\u63a5\u7b26 & \u53f3\u8fb9\u7f3a\u5c11\u4e00\u4e2a\u7a7a\u683c \uff01\u903b\u8f91\u8fde\u63a5\u7b26 & | \u5de6\u53f3\u5fc5\u987b\u5404\u4e00\u4e2a\u76f8\u90bb\u7a7a\u683c\uff01\u7a7a\u683c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01\u4e0d\u5141\u8bb8\u9996\u5c3e\u6709\u7a7a\u683c\uff0c\u4e5f\u4e0d\u5141\u8bb8\u8fde\u7eed\u7a7a\u683c\uff01\u5de6\u62ec\u53f7 ( \u7684\u53f3\u8fb9 \u548c \u53f3\u62ec\u53f7 ) \u7684\u5de6\u8fb9 \u90fd\u4e0d\u5141\u8bb8\u6709\u76f8\u90bb\u7a7a\u683c\uff01");
                            }
                            result = result + " AND ";
                            lastLogic = c;
                            ++i;
                        } else {
                            key = key + c;
                        }
                    } else if (c == '|') {
                        if (last == ' ') {
                            if (i >= n2 - 1 || s.charAt(i + 1) != ' ') {
                                throw new IllegalArgumentException(table + ":{ @combine: '" + combine + "' } \u4e2d\u5b57\u7b26 '" + (i >= n2 - 1 ? s : s.substring(0, i + 1)) + "' \u4e0d\u5408\u6cd5\uff01\u903b\u8f91\u8fde\u63a5\u7b26 | \u53f3\u8fb9\u7f3a\u5c11\u4e00\u4e2a\u7a7a\u683c \uff01\u903b\u8f91\u8fde\u63a5\u7b26 & | \u5de6\u53f3\u5fc5\u987b\u5404\u4e00\u4e2a\u76f8\u90bb\u7a7a\u683c\uff01\u7a7a\u683c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01\u4e0d\u5141\u8bb8\u9996\u5c3e\u6709\u7a7a\u683c\uff0c\u4e5f\u4e0d\u5141\u8bb8\u8fde\u7eed\u7a7a\u683c\uff01\u5de6\u62ec\u53f7 ( \u53f3\u8fb9\u548c\u53f3\u62ec\u53f7 ) \u5de6\u8fb9\u90fd\u4e0d\u5141\u8bb8\u6709\u76f8\u90bb\u7a7a\u683c\uff01");
                            }
                            result = result + " OR ";
                            lastLogic = c;
                            ++i;
                        } else {
                            key = key + c;
                        }
                    } else if (c == '!') {
                        char next;
                        last = i <= 0 ? (char)'\u0000' : s.charAt(i - 1);
                        char c2 = next = i >= n2 - 1 ? (char)'\u0000' : s.charAt(i + 1);
                        if (last == ' ' || last == '(') {
                            if (next == ' ') {
                                throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s.substring(0, i + 1) + "' \u4e0d\u5408\u6cd5\uff01\u975e\u903b\u8f91\u7b26 '!' \u53f3\u8fb9\u591a\u4e86\u4e00\u4e2a\u7a7a\u683c ' ' \uff01\u975e\u903b\u8f91\u7b26 '!' \u53f3\u8fb9\u4e0d\u5141\u8bb8\u4efb\u4f55\u76f8\u90bb\u7a7a\u683c ' '\uff0c\u4e5f\u4e0d\u5141\u8bb8 ')' '&' '|' \u4e2d\u4efb\u4f55\u4e00\u4e2a\uff01");
                            }
                            if (next == ')' || next == '&' || next == '!') {
                                throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s.substring(0, i + 1) + "' \u4e0d\u5408\u6cd5\uff01\u975e\u903b\u8f91\u7b26 '!' \u53f3\u8fb9\u591a\u4e86\u4e00\u4e2a\u5b57\u7b26 '" + next + "' \uff01\u975e\u903b\u8f91\u7b26 '!' \u53f3\u8fb9\u4e0d\u5141\u8bb8\u4efb\u4f55\u76f8\u90bb\u7a7a\u683c ' '\uff0c\u4e5f\u4e0d\u5141\u8bb8 ')' '&' '|' \u4e2d\u4efb\u4f55\u4e00\u4e2a\uff01");
                            }
                            if (i > 0 && lastLogic <= 0 && last != '(') {
                                throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s.substring(i) + "' \u4e0d\u5408\u6cd5\uff01\u5de6\u8fb9\u7f3a\u5c11 & | \u903b\u8f91\u8fde\u63a5\u7b26\uff01\u903b\u8f91\u8fde\u63a5\u7b26 & | \u5de6\u53f3\u5fc5\u987b\u5404\u4e00\u4e2a\u76f8\u90bb\u7a7a\u683c\uff01\u7a7a\u683c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01\u4e0d\u5141\u8bb8\u9996\u5c3e\u6709\u7a7a\u683c\uff0c\u4e5f\u4e0d\u5141\u8bb8\u8fde\u7eed\u7a7a\u683c\uff01\u5de6\u62ec\u53f7 ( \u7684\u53f3\u8fb9 \u548c \u53f3\u62ec\u53f7 ) \u7684\u5de6\u8fb9 \u90fd\u4e0d\u5141\u8bb8\u6709\u76f8\u90bb\u7a7a\u683c\uff01");
                            }
                        }
                        if (next == '(') {
                            result = result + " NOT ";
                            lastLogic = c;
                        } else if (last <= '\u0000' || last == ' ' || last == '(') {
                            isNot = true;
                        } else {
                            key = key + c;
                        }
                    } else if (c == '(') {
                        if (!key.isEmpty() || i > 0 && lastLogic <= 0 && last != '(') {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s.substring(i) + "' \u4e0d\u5408\u6cd5\uff01\u5de6\u8fb9\u7f3a\u5c11 & | \u903b\u8f91\u8fde\u63a5\u7b26\uff01\u903b\u8f91\u8fde\u63a5\u7b26 & | \u5de6\u53f3\u5fc5\u987b\u5404\u4e00\u4e2a\u76f8\u90bb\u7a7a\u683c\uff01\u7a7a\u683c\u4e0d\u80fd\u591a\u4e5f\u4e0d\u80fd\u5c11\uff01\u4e0d\u5141\u8bb8\u9996\u5c3e\u6709\u7a7a\u683c\uff0c\u4e5f\u4e0d\u5141\u8bb8\u8fde\u7eed\u7a7a\u683c\uff01\u5de6\u62ec\u53f7 ( \u7684\u53f3\u8fb9 \u548c \u53f3\u62ec\u53f7 ) \u7684\u5de6\u8fb9 \u90fd\u4e0d\u5141\u8bb8\u6709\u76f8\u90bb\u7a7a\u683c\uff01");
                        }
                        if (++depth > maxDepth && maxDepth > 0) {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s.substring(0, i + 1) + "' \u4e0d\u5408\u6cd5\uff01\u62ec\u53f7 (()) \u5d4c\u5957\u5c42\u7ea7 " + depth + " \u5df2\u8d85\u8fc7\u6700\u5927\u503c\uff0c\u5fc5\u987b\u5728 0-" + maxDepth + " \u5185\uff01");
                        }
                        result = result + c;
                        lastLogic = 0;
                        first = true;
                    } else if (c == ')') {
                        if (--depth < 0) {
                            throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s.substring(0, i + 1) + "' \u4e0d\u5408\u6cd5\uff01\u5de6\u62ec\u53f7 ( \u6bd4 \u53f3\u62ec\u53f7 ) \u5c11\uff01\u6570\u91cf\u5fc5\u987b\u76f8\u7b49\u4ece\u800c\u5b8c\u6574\u95ed\u5408 (...) \uff01");
                        }
                        result = result + c;
                        lastLogic = 0;
                    } else {
                        key = key + c;
                    }
                }
                last = c;
            }
            if (depth != 0) {
                throw new IllegalArgumentException(errPrefix + " \u4e2d\u5b57\u7b26 '" + s + "' \u4e0d\u5408\u6cd5\uff01\u5de6\u62ec\u53f7 ( \u6bd4 \u53f3\u62ec\u53f7 ) \u591a\uff01\u6570\u91cf\u5fc5\u987b\u76f8\u7b49\u4ece\u800c\u5b8c\u6574\u95ed\u5408 (...) \uff01");
            }
        }
        List<Object> exprPreparedValues = this.getPreparedValueList();
        if (!isHaving) {
            this.setPreparedValueList((List)new ArrayList());
        }
        Set<Map.Entry<String, Object>> set = conditionMap.entrySet();
        String andCond = "";
        boolean isItemFirst = true;
        for (Map.Entry<String, Object> entry : set) {
            String wi;
            String key = entry == null ? null : entry.getKey();
            if (key == null || usedKeyCountMap.containsKey(key)) continue;
            String string = wi = isHaving ? this.getHavingItem(quote, table, alias, key, (String)entry.getValue(), containRaw) : this.getWhereItem(key, entry.getValue(), method, verifyName);
            if (StringUtil.isEmpty(wi, true)) continue;
            andCond = andCond + (isItemFirst ? "" : " AND ") + "(" + wi + ")";
            isItemFirst = false;
        }
        if (!isHaving) {
            preparedValues.addAll(this.getPreparedValueList());
        }
        if (StringUtil.isEmpty(result, true)) {
            result = andCond;
        } else if (StringUtil.isNotEmpty(andCond, true)) {
            result = isHaving ? "( " + result + " )" + " AND " + andCond : andCond + " AND " + "( " + result + " )";
        }
        if (!isHaving) {
            if (exprPreparedValues != null && !exprPreparedValues.isEmpty()) {
                preparedValues.addAll(exprPreparedValues);
            }
            this.setPreparedValueList((List)preparedValues);
        }
        return result;
    }

    public String getWhereString(boolean hasPrefix, RequestMethod method, Map<String, Object> where, Map<String, List<String>> combine, List<Join> joinList, boolean verifyName) throws Exception {
        String s;
        Set<Map.Entry<String, List<String>>> combineSet;
        Set<Map.Entry<String, List<String>>> set = combineSet = combine == null ? null : combine.entrySet();
        if (combineSet == null || combineSet.isEmpty()) {
            Log.w(TAG, "getWhereString  combineSet == null || combineSet.isEmpty() >> return \"\";");
            return "";
        }
        String whereString = "";
        boolean isCombineFirst = true;
        for (Map.Entry<String, List<String>> ce : combineSet) {
            List<String> keyList = ce == null ? null : ce.getValue();
            if (keyList == null || keyList.isEmpty()) continue;
            int logic = "|".equals(ce.getKey()) ? 0 : ("!".equals(ce.getKey()) ? 2 : 1);
            boolean isItemFirst = true;
            String cs = "";
            for (String key : keyList) {
                String c = this.getWhereItem(key, where.get(key), method, verifyName);
                if (StringUtil.isEmpty(c, true)) continue;
                cs = cs + (isItemFirst ? "" : (Logic.isAnd(logic) ? " AND " : " OR ")) + "(" + c + ")";
                isItemFirst = false;
            }
            if (StringUtil.isEmpty(cs, true)) continue;
            whereString = whereString + (isCombineFirst ? "" : " AND ") + (Logic.isNot(logic) ? " NOT " : "") + " (  " + cs + "  ) ";
            isCombineFirst = false;
        }
        String string = StringUtil.isEmpty(whereString = this.concatJoinWhereString(whereString), true) ? "" : (s = (hasPrefix ? " WHERE " : "") + whereString);
        if (s.isEmpty() && !RequestMethod.isQueryMethod(method)) {
            throw new UnsupportedOperationException("\u5199\u64cd\u4f5c\u8bf7\u6c42\u5fc5\u987b\u5e26\u6761\u4ef6\uff01\uff01\uff01");
        }
        return s;
    }

    protected String concatJoinWhereString(String whereString) throws Exception {
        List<Join> joinList = this.getJoinList();
        if (joinList != null) {
            String newWs = "";
            String ws = whereString;
            ArrayList<Object> newPvl = new ArrayList<Object>();
            ArrayList<Object> pvl = new ArrayList<Object>(this.getPreparedValueList());
            boolean changed = false;
            block17: for (Join j : joinList) {
                String jt;
                switch (jt = j.getJoinType()) {
                    case "*": 
                    case "@": 
                    case "<": 
                    case ">": {
                        continue block17;
                    }
                    case "&": 
                    case "": 
                    case "|": 
                    case "!": 
                    case "^": 
                    case "(": 
                    case ")": {
                        SQLConfig jc = j.getJoinConfig();
                        boolean isMain = jc.isMain();
                        jc.setMain(false).setPrepared(this.isPrepared()).setPreparedValueList(new ArrayList<Object>());
                        String js = jc.getWhereString(false);
                        jc.setMain(isMain);
                        boolean isOuterJoin = "!".equals(jt);
                        boolean isSideJoin = "^".equals(jt);
                        boolean isAntiJoin = "(".equals(jt);
                        boolean isForeignJoin = ")".equals(jt);
                        boolean isWsEmpty = StringUtil.isEmpty(ws, true);
                        if (isWsEmpty) {
                            if (isOuterJoin) {
                                throw new NotExistException("no result for ! OUTER JOIN( ! (A | B) ) when A or B is empty!");
                            }
                            if (isForeignJoin) {
                                throw new NotExistException("no result for ) FOREIGN JOIN( B & ! A ) when A is empty!");
                            }
                        }
                        if (StringUtil.isEmpty(js, true)) {
                            if (isOuterJoin) {
                                throw new NotExistException("no result for ! OUTER JOIN( ! (A | B) ) when A or B is empty!");
                            }
                            if (isAntiJoin) {
                                throw new NotExistException("no result for ( ANTI JOIN( A & ! B ) when B is empty!");
                            }
                            if (isWsEmpty) {
                                if (!isSideJoin) continue block17;
                                throw new NotExistException("no result for ^ SIDE JOIN( ! (A & B) ) when both A and B are empty!");
                            }
                            if (!isSideJoin && !isForeignJoin) continue block17;
                            newWs = newWs + " ( " + AbstractSQLConfig.getCondition(true, ws) + " ) ";
                            newPvl.addAll(pvl);
                            newPvl.addAll(jc.getPreparedValueList());
                            changed = true;
                            continue block17;
                        }
                        if (!StringUtil.isEmpty(newWs, true)) {
                            newWs = newWs + " AND ";
                        }
                        if (isAntiJoin) {
                            newWs = newWs + " ( " + (isWsEmpty ? "" : ws + " AND ") + " NOT " + " ( " + js + " )  ) ";
                        } else if (isForeignJoin) {
                            newWs = newWs + " (  NOT  ( " + ws + " ) ) " + " AND " + " ( " + js + " ) ";
                        } else if (isSideJoin) {
                            newWs = newWs + " ( " + AbstractSQLConfig.getCondition(true, (isWsEmpty ? "" : ws + " AND ") + " ( " + js + " ) ") + " ) ";
                        } else {
                            int logic = Logic.getType(jt);
                            newWs = newWs + " ( " + AbstractSQLConfig.getCondition(Logic.isNot(logic), ws + (isWsEmpty ? "" : (Logic.isAnd(logic) ? " AND " : " OR ")) + " ( " + js + " ) ") + " ) ";
                        }
                        newPvl.addAll(pvl);
                        newPvl.addAll(jc.getPreparedValueList());
                        changed = true;
                        continue block17;
                    }
                }
                throw new UnsupportedOperationException("join:value \u4e2d value \u91cc\u7684 " + jt + "/" + j.getPath() + "\u9519\u8bef\uff01\u4e0d\u652f\u6301 " + jt + " \u7b49 [ @ APP, < LEFT, > RIGHT, * CROSS, & INNER, | FULL, ! OUTER, ^ SIDE, ( ANTI, ) FOREIGN ] \u4e4b\u5916\u7684 JOIN \u7c7b\u578b !");
            }
            if (changed) {
                whereString = newWs;
                this.setPreparedValueList(newPvl);
            }
        }
        return whereString;
    }

    protected String getWhereItem(String key, Object value, RequestMethod method, boolean verifyName) throws Exception {
        Log.d(TAG, "getWhereItem  key = " + key);
        if (key == null || key.endsWith("()") || key.startsWith("@")) {
            Log.d(TAG, "getWhereItem  key == null || key.endsWith(()) || key.startsWith(@) >> continue;");
            return null;
        }
        if (key.endsWith("@")) {
            throw new IllegalArgumentException("AbstractSQLConfig.getWhereItem: \u5b57\u7b26 " + key + " \u4e0d\u5408\u6cd5\uff01");
        }
        if (value == null) {
            return null;
        }
        int keyType = key.endsWith("$") ? 1 : (key.endsWith("~") ? (key.charAt(key.length() - 2) == '*' ? -2 : 2) : (key.endsWith("%") ? 3 : (key.endsWith("{}") ? 4 : (key.endsWith("}{") ? 5 : (key.endsWith("<>") ? 6 : (key.endsWith(">=") ? 7 : (key.endsWith("<=") ? 8 : (key.endsWith(">") ? 9 : (key.endsWith("<") ? 10 : 0)))))))));
        String column = AbstractSQLConfig.getRealKey(method, key, false, true, verifyName);
        String rawSQL = this.getRawSQL(key, value, keyType != 4 || !(value instanceof String));
        switch (keyType) {
            case 1: {
                return this.getSearchString(key, column, value, rawSQL);
            }
            case -2: 
            case 2: {
                return this.getRegExpString(key, column, value, keyType < 0, rawSQL);
            }
            case 3: {
                return this.getBetweenString(key, column, value, rawSQL);
            }
            case 4: {
                return this.getRangeString(key, column, value, rawSQL);
            }
            case 5: {
                return this.getExistsString(key, column, value, rawSQL);
            }
            case 6: {
                return this.getContainString(key, column, value, rawSQL);
            }
            case 7: {
                return this.getCompareString(key, column, value, ">=", rawSQL);
            }
            case 8: {
                return this.getCompareString(key, column, value, "<=", rawSQL);
            }
            case 9: {
                return this.getCompareString(key, column, value, ">", rawSQL);
            }
            case 10: {
                return this.getCompareString(key, column, value, "<", rawSQL);
            }
        }
        return this.getEqualString(key, column, value, rawSQL);
    }

    @JSONField(serialize=false)
    public String getEqualString(String key, String column, Object value, String rawSQL) throws Exception {
        if (value != null && !JSON.isBooleanOrNumberOrString(value) && !(value instanceof Subquery)) {
            throw new IllegalArgumentException(key + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u975ePUT\u8bf7\u6c42\u53ea\u652f\u6301 [Boolean, Number, String] \u5185\u7684\u7c7b\u578b \uff01");
        }
        boolean not = column.endsWith("!");
        if (not) {
            column = column.substring(0, column.length() - 1);
        }
        if (!StringUtil.isName(column)) {
            throw new IllegalArgumentException(key + ":value \u4e2dkey\u4e0d\u5408\u6cd5\uff01\u4e0d\u652f\u6301 ! \u4ee5\u5916\u7684\u903b\u8f91\u7b26 \uff01");
        }
        String logic = value == null && rawSQL == null ? (not ? " IS NOT " : " IS ") : (not ? " != " : " = ");
        return this.getKey(column) + logic + (value instanceof Subquery ? this.getSubqueryString((Subquery)value) : (rawSQL != null ? rawSQL : this.getValue(key, column, value)));
    }

    @JSONField(serialize=false)
    public String getCompareString(String key, String column, Object value, String type, String rawSQL) throws Exception {
        if (value != null && !JSON.isBooleanOrNumberOrString(value) && !(value instanceof Subquery)) {
            throw new IllegalArgumentException(key + ":value \u4e2d value \u4e0d\u5408\u6cd5\uff01\u6bd4\u8f83\u8fd0\u7b97 [>, <, >=, <=] \u53ea\u652f\u6301 [Boolean, Number, String] \u5185\u7684\u7c7b\u578b \uff01");
        }
        if (!StringUtil.isName(column)) {
            throw new IllegalArgumentException(key + ":value \u4e2d key \u4e0d\u5408\u6cd5\uff01\u6bd4\u8f83\u8fd0\u7b97 [>, <, >=, <=] \u4e0d\u652f\u6301 [&, !, |] \u4e2d\u4efb\u4f55\u903b\u8f91\u8fd0\u7b97\u7b26 \uff01");
        }
        return this.getKey(column) + " " + type + " " + (value instanceof Subquery ? this.getSubqueryString((Subquery)value) : (rawSQL != null ? rawSQL : this.getValue(key, column, value)));
    }

    public String getKey(String key) {
        if (this.isTest()) {
            if (key.contains("'")) {
                throw new IllegalArgumentException("\u53c2\u6570 " + key + " \u4e0d\u5408\u6cd5\uff01key \u4e2d\u4e0d\u5141\u8bb8\u6709\u5355\u5f15\u53f7 ' \uff01");
            }
            return this.getSQLValue(key).toString();
        }
        return this.getSQLKey(key);
    }

    public String getSQLKey(String key) {
        String q = this.getQuote();
        return (this.isKeyPrefix() ? this.getAliasWithQuote() + "." : "") + q + key + q;
    }

    protected Object getValue(@NotNull Object value) {
        return this.getValue(null, null, value);
    }

    protected Object getValue(String key, String column, Object value) {
        if (this.isPrepared()) {
            if (value == null) {
                return null;
            }
            Map<String, String> castMap = this.getCast();
            String type = key == null || castMap == null ? null : castMap.get(key);
            this.preparedValueList.add(value);
            return StringUtil.isEmpty(type, true) ? "?" : "cast(? AS " + type + ")";
        }
        return key == null ? this.getSQLValue(value) : this.getSQLValue(key, column, value);
    }

    public Object getSQLValue(String key, String column, @NotNull Object value) {
        Map<String, String> castMap = this.getCast();
        String type = key == null || castMap == null ? null : castMap.get(key);
        Object val = this.getSQLValue(value);
        return StringUtil.isEmpty(type, true) ? val : "cast(" + val + " AS " + type + ")";
    }

    public Object getSQLValue(@NotNull Object value) {
        if (value == null) {
            return " NULL ";
        }
        return value instanceof Number || value instanceof Boolean ? value : "'" + value.toString().replaceAll("\\'", "\\\\'") + "'";
    }

    @Override
    public List<Object> getPreparedValueList() {
        return this.preparedValueList;
    }

    @Override
    public AbstractSQLConfig setPreparedValueList(List<Object> preparedValueList) {
        this.preparedValueList = preparedValueList;
        return this;
    }

    @JSONField(serialize=false)
    public String getSearchString(String key, String column, Object value, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key$ \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(column);
        column = logic.getKey();
        Log.i(TAG, "getSearchString column = " + column);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getSearchString(key, column, arr.toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getSearchString(String key, String column, Object[] values, int type) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (!(v instanceof String)) {
                throw new IllegalArgumentException(key + ":value \u4e2d value \u7684\u7c7b\u578b\u53ea\u80fd\u4e3a String \u6216 String[]\uff01");
            }
            if (((String)v).isEmpty()) {
                throw new IllegalArgumentException(key + ":value \u4e2d value \u503c " + v + "\u662f\u7a7a\u5b57\u7b26\u4e32\uff0c\u6ca1\u6709\u610f\u4e49\uff0c\u4e0d\u5141\u8bb8\u8fd9\u6837\u4f20\uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + this.getLikeString(key, column, (String)v);
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getLikeString(@NotNull String key, @NotNull String column, String value) {
        char l;
        String k = key.substring(0, key.length() - 1);
        char r = k.charAt(k.length() - 1);
        if (r == '%' || r == '_' || r == '?') {
            l = (k = k.substring(0, k.length() - 1)).charAt(k.length() - 1);
            if (l == '%' || l == '_' || l == '?') {
                if (l == r) {
                    throw new IllegalArgumentException(key + ":value \u4e2d\u5b57\u7b26 " + k + " \u4e0d\u5408\u6cd5\uff01key$:value \u4e2d\u4e0d\u5141\u8bb8 key \u4e2d\u6709\u8fde\u7eed\u76f8\u540c\u7684\u5360\u4f4d\u7b26\uff01");
                }
                k = k.substring(0, k.length() - 1);
            } else if (l > '\u0000' && StringUtil.isName(String.valueOf(l))) {
                l = r;
            }
            if (l == '?') {
                l = '\u0000';
            }
            if (r == '?') {
                r = '\u0000';
            }
        } else {
            r = '\u0000';
            l = '\u0000';
        }
        if (l > '\u0000' || r > '\u0000') {
            if (value == null) {
                throw new IllegalArgumentException(key + ":value \u4e2d value \u4e3a null\uff01key$:value \u4e2d value \u4e0d\u80fd\u4e3a null\uff0c\u4e14\u7c7b\u578b\u5fc5\u987b\u662f String \uff01");
            }
            value = value.replaceAll("\\\\", "\\\\\\\\");
            value = value.replaceAll("\\%", "\\\\%");
            value = value.replaceAll("\\_", "\\\\_");
            if (l > '\u0000') {
                value = l + value;
            }
            if (r > '\u0000') {
                value = value + r;
            }
        }
        return this.getKey(column) + " LIKE " + this.getValue(key, column, value);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, String column, Object value, boolean ignoreCase, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key~ \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(column);
        column = logic.getKey();
        Log.i(TAG, "getRegExpString column = " + column);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getRegExpString(key, column, arr.toArray(), logic.getType(), ignoreCase);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, String column, Object[] values, int type, boolean ignoreCase) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof String)) {
                throw new IllegalArgumentException(key + ":value \u4e2dvalue\u7684\u7c7b\u578b\u53ea\u80fd\u4e3aString\u6216String[]\uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + this.getRegExpString(key, column, (String)values[i], ignoreCase);
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getRegExpString(String key, String column, String value, boolean ignoreCase) {
        if (this.isPostgreSQL() || this.isInfluxDB()) {
            return this.getKey(column) + " ~" + (ignoreCase ? "* " : " ") + this.getValue(key, column, value);
        }
        if (this.isOracle() || this.isDameng() || this.isKingBase() || this.isMySQL() && this.getDBVersionNums()[0] >= 8) {
            return "regexp_like(" + this.getKey(column) + ", " + this.getValue(key, column, value) + (ignoreCase ? ", 'i'" : ", 'c'") + ")";
        }
        if (this.isPresto() || this.isTrino()) {
            return "regexp_like(" + (ignoreCase ? "lower(" : "") + this.getKey(column) + (ignoreCase ? ")" : "") + ", " + (ignoreCase ? "lower(" : "") + this.getValue(key, column, value) + (ignoreCase ? ")" : "") + ")";
        }
        if (this.isClickHouse()) {
            return "match(" + (ignoreCase ? "lower(" : "") + this.getKey(column) + (ignoreCase ? ")" : "") + ", " + (ignoreCase ? "lower(" : "") + this.getValue(key, column, value) + (ignoreCase ? ")" : "") + ")";
        }
        if (this.isElasticsearch()) {
            return this.getKey(column) + " RLIKE " + this.getValue(key, column, value);
        }
        if (this.isHive()) {
            return (ignoreCase ? "lower(" : "") + this.getKey(column) + (ignoreCase ? ")" : "") + " REGEXP " + (ignoreCase ? "lower(" : "") + this.getValue(key, column, value) + (ignoreCase ? ")" : "");
        }
        return this.getKey(column) + " REGEXP " + (ignoreCase ? "" : "BINARY ") + this.getValue(key, column, value);
    }

    @JSONField(serialize=false)
    public String getBetweenString(String key, String column, Object value, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key% \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        Logic logic = new Logic(column);
        column = logic.getKey();
        Log.i(TAG, "getBetweenString column = " + column);
        JSONArray arr = AbstractSQLConfig.newJSONArray(value);
        if (arr.isEmpty()) {
            return "";
        }
        return this.getBetweenString(key, column, arr.toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getBetweenString(String key, String column, Object[] values, int type) throws IllegalArgumentException {
        if (values == null || values.length <= 0) {
            return "";
        }
        String condition = "";
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] instanceof String)) {
                throw new IllegalArgumentException(key + ":value \u4e2d value \u7684\u7c7b\u578b\u53ea\u80fd\u4e3a String \u6216 String[] \uff01");
            }
            String[] vs = StringUtil.split((String)values[i]);
            if (vs == null || vs.length != 2) {
                throw new IllegalArgumentException(key + ":value \u4e2d value \u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u4e3a String \u65f6\u5fc5\u987b\u5305\u62ec1\u4e2a\u9017\u53f7 , \u4e14\u5de6\u53f3\u4e24\u4fa7\u90fd\u6709\u503c\uff01\u7c7b\u578b\u4e3a String[] \u91cc\u9762\u6bcf\u4e2a\u5143\u7d20\u8981\u7b26\u5408\u524d\u9762\u7c7b\u578b\u4e3a String \u7684\u89c4\u5219 \uff01");
            }
            condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR ")) + "(" + this.getBetweenString(key, column, (Object)vs[0], (Object)vs[1]) + ")";
        }
        return AbstractSQLConfig.getCondition(Logic.isNot(type), condition);
    }

    @JSONField(serialize=false)
    public String getBetweenString(String key, String column, Object start, Object end) throws IllegalArgumentException {
        if (!JSON.isBooleanOrNumberOrString(start) || !JSON.isBooleanOrNumberOrString(end)) {
            throw new IllegalArgumentException(key + ":value \u4e2d value \u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u4e3a String \u65f6\u5fc5\u987b\u5305\u62ec1\u4e2a\u9017\u53f7 , \u4e14\u5de6\u53f3\u4e24\u4fa7\u90fd\u6709\u503c\uff01\u7c7b\u578b\u4e3a String[] \u91cc\u9762\u6bcf\u4e2a\u5143\u7d20\u8981\u7b26\u5408\u524d\u9762\u7c7b\u578b\u4e3a String \u7684\u89c4\u5219 \uff01");
        }
        return this.getKey(column) + " BETWEEN " + this.getValue(key, column, start) + " AND " + this.getValue(key, column, end);
    }

    @JSONField(serialize=false)
    public String getRangeString(String key, String column, Object range, String rawSQL) throws Exception {
        Log.i(TAG, "getRangeString column = " + column);
        if (range == null) {
            throw new NotExistException("AbstractSQLConfiggetRangeString(" + column + ", " + range + ") range == null");
        }
        Logic logic = new Logic(column);
        String k = logic.getKey();
        Log.i(TAG, "getRangeString k = " + k);
        if (range instanceof List) {
            if (rawSQL != null) {
                throw new UnsupportedOperationException("@raw:value \u7684 value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01Raw SQL \u4e0d\u652f\u6301 key{}:[] \u8fd9\u79cd\u952e\u503c\u5bf9\uff01");
            }
            if (logic.isOr() || logic.isNot()) {
                List l = (List)range;
                if (logic.isNot() && l.isEmpty()) {
                    return "";
                }
                return this.getKey(k) + this.getInString(k, column, l.toArray(), logic.isNot());
            }
            throw new IllegalArgumentException(key + ":[] \u4e2d {} \u524d\u9762\u7684\u903b\u8f91\u8fd0\u7b97\u7b26\u9519\u8bef\uff01\u53ea\u80fd\u7528'|','!'\u4e2d\u7684\u4e00\u79cd \uff01");
        }
        if (range instanceof String) {
            String[] cs;
            String condition = "";
            String[] stringArray = cs = rawSQL != null ? null : StringUtil.split((String)range, ";", false);
            if (rawSQL != null) {
                int index = rawSQL.indexOf("(");
                condition = (index >= 0 && index < rawSQL.lastIndexOf(")") ? "" : this.getKey(k) + " ") + rawSQL;
            }
            if (cs != null) {
                List<String> raw = this.getRaw();
                boolean containRaw = raw == null ? false : raw.contains(key);
                String lk = logic.isAnd() ? " AND " : " OR ";
                for (int i = 0; i < cs.length; ++i) {
                    int index;
                    String expr = cs[i];
                    if (expr.length() > 100) {
                        throw new UnsupportedOperationException(key + ":value \u7684 value \u4e2d\u5b57\u7b26\u4e32 " + expr + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20\u8d85\u8fc7 100 \u4e2a\u5b57\u7b26\u7684\u51fd\u6570\u6216\u8868\u8fbe\u5f0f\uff01\u8bf7\u7528 @raw \u7b80\u5316\u4f20\u53c2\uff01");
                    }
                    int n = index = expr == null ? -1 : expr.indexOf("(");
                    if (index >= 0) {
                        expr = this.parseSQLExpression(key, expr, containRaw, false, key + ":\"!=null;+3*2<=10;function0(arg0,arg1,...)>1;function1(...)%5<=3...\"");
                    } else {
                        String fk = this.getKey(k) + " ";
                        String[] ccs = StringUtil.split(expr, false);
                        expr = "";
                        for (int j = 0; j < ccs.length; ++j) {
                            String c = ccs[j];
                            if ("=null".equals(c)) {
                                c = SQL.isNull();
                            } else if ("!=null".equals(c)) {
                                c = SQL.isNull(false);
                            } else if (this.isPrepared() && (c.contains("--") || !PATTERN_RANGE.matcher(c).matches())) {
                                throw new UnsupportedOperationException(key + ":value \u7684 value \u4e2d " + c + " \u4e0d\u5408\u6cd5\uff01\u9884\u7f16\u8bd1\u6a21\u5f0f\u4e0b key{}:\"condition\" \u4e2d condition \u5fc5\u987b \u4e3a =null \u6216 !=null \u6216 \u7b26\u5408\u6b63\u5219\u8868\u8fbe\u5f0f " + PATTERN_RANGE + " \uff01\u4e0d\u5141\u8bb8\u8fde\u7eed\u51cf\u53f7 -- \uff01\u4e0d\u5141\u8bb8\u7a7a\u683c\uff01");
                            }
                            expr = expr + (j <= 0 ? "" : lk) + fk + c;
                        }
                    }
                    condition = condition + (i <= 0 ? "" : lk) + expr;
                }
            }
            if (condition.isEmpty()) {
                return "";
            }
            return AbstractSQLConfig.getCondition(logic.isNot(), condition);
        }
        if (range instanceof Subquery) {
            return this.getKey(k) + (logic.isNot() ? " NOT " : "") + " IN " + this.getSubqueryString((Subquery)range);
        }
        throw new IllegalArgumentException(key + ":range \u7c7b\u578b\u4e3a" + range.getClass().getSimpleName() + "\uff01range \u53ea\u80fd\u662f \u7528','\u5206\u9694\u6761\u4ef6\u7684\u5b57\u7b26\u4e32 \u6216\u8005 \u53ef\u53d6\u9009\u9879JSONArray\uff01");
    }

    @JSONField(serialize=false)
    public String getInString(String key, String column, Object[] in, boolean not) throws NotExistException {
        String condition = "";
        if (in != null) {
            for (int i = 0; i < in.length; ++i) {
                condition = condition + (i > 0 ? "," : "") + this.getValue(key, column, in[i]);
            }
        }
        if (condition.isEmpty()) {
            throw new NotExistException("AbstractSQLConfig.getInString(" + key + "," + column + ", [], " + not + ") >> condition.isEmpty() >> IN()");
        }
        return (not ? " NOT " : "") + " IN (" + condition + ")";
    }

    @JSONField(serialize=false)
    public String getExistsString(String key, String column, Object value, String rawSQL) throws Exception {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key}{ \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        if (value == null) {
            return "";
        }
        if (!(value instanceof Subquery)) {
            throw new IllegalArgumentException(key + ":subquery \u7c7b\u578b\u4e3a" + value.getClass().getSimpleName() + "\uff01subquery \u53ea\u80fd\u662f \u5b50\u67e5\u8be2JSONObejct\uff01");
        }
        Logic logic = new Logic(column);
        column = logic.getKey();
        Log.i(TAG, "getExistsString column = " + column);
        return (logic.isNot() ? " NOT " : "") + " EXISTS " + this.getSubqueryString((Subquery)value);
    }

    @JSONField(serialize=false)
    public String getContainString(String key, String column, Object value, String rawSQL) throws IllegalArgumentException {
        if (rawSQL != null) {
            throw new UnsupportedOperationException("@raw:value \u4e2d " + key + " \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 key<> \u8fd9\u79cd\u529f\u80fd\u7b26 \uff01\u53ea\u652f\u6301 key, key!, key<, key{} \u7b49\u6bd4\u8f83\u8fd0\u7b97 \u548c @column, @having \uff01");
        }
        Logic logic = new Logic(column);
        column = logic.getKey();
        Log.i(TAG, "getContainString column = " + column);
        return this.getContainString(key, column, AbstractSQLConfig.newJSONArray(value).toArray(), logic.getType());
    }

    @JSONField(serialize=false)
    public String getContainString(String key, String column, Object[] childs, int type) throws IllegalArgumentException {
        boolean not = Logic.isNot(type);
        String condition = "";
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                String v;
                Object c = childs[i];
                if (c instanceof Collection) {
                    throw new IllegalArgumentException(key + ":value \u4e2d value \u7c7b\u578b\u4e0d\u80fd\u4e3a [JSONArray, Collection] \u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a \uff01");
                }
                String path = "";
                if (c instanceof Map) {
                    path = ((Map)c).get("path");
                    if (path != null && !(path instanceof String)) {
                        throw new IllegalArgumentException(key + ":{ path:path, value:value } \u4e2d path \u7c7b\u578b\u9519\u8bef\uff0c\u53ea\u80fd\u662f $, $.key1, $[0].key2 \u7b49\u7b26\u5408 SQL \u4e2d JSON \u8def\u5f84\u7684 String \uff01");
                    }
                    if ((c = ((Map)c).get("value")) instanceof Collection || c instanceof Map) {
                        throw new IllegalArgumentException(key + ":{ path:path, value:value } \u4e2d value \u7c7b\u578b\u4e0d\u80fd\u4e3a [JSONObject, JSONArray, Collection, Map] \u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a \uff01");
                    }
                }
                condition = condition + (i <= 0 ? "" : (Logic.isAnd(type) ? " AND " : " OR "));
                if (this.isPostgreSQL() || this.isInfluxDB()) {
                    condition = condition + this.getKey(column) + " @> " + this.getValue(key, column, AbstractSQLConfig.newJSONArray(c));
                    continue;
                }
                if (this.isOracle() || this.isDameng() || this.isKingBase()) {
                    condition = condition + "json_textcontains(" + this.getKey(column) + ", " + (StringUtil.isEmpty((Object)path, true) ? "'$'" : this.getValue(key, column, path)) + ", " + this.getValue(key, column, c == null ? null : c.toString()) + ")";
                    continue;
                }
                if (this.isPresto() || this.isTrino()) {
                    condition = condition + "json_array_contains(cast(" + this.getKey(column) + " AS VARCHAR), " + this.getValue(key, column, c) + (StringUtil.isEmpty((Object)path, true) ? "" : ", " + this.getValue(key, column, path)) + ")";
                    continue;
                }
                String string = c == null ? "null" : (v = c instanceof Boolean || c instanceof Number ? c.toString() : "\"" + c + "\"");
                condition = this.isClickHouse() ? condition + condition + "has(JSONExtractArrayRaw(assumeNotNull(" + this.getKey(column) + ")), " + this.getValue(key, column, v) + (StringUtil.isEmpty((Object)path, true) ? "" : ", " + this.getValue(key, column, path)) + ")" : condition + "json_contains(" + this.getKey(column) + ", " + this.getValue(key, column, v) + (StringUtil.isEmpty((Object)path, true) ? "" : ", " + this.getValue(key, column, path)) + ")";
            }
            condition = condition.isEmpty() ? this.getKey(column) + SQL.isNull(true) + " OR " + this.getLikeString(key, column, "[]") : this.getKey(column) + SQL.isNull(false) + " AND " + "(" + condition + ")";
        }
        if (condition.isEmpty()) {
            return "";
        }
        return AbstractSQLConfig.getCondition(not, condition);
    }

    private String withAsExpreSubqueryString(SQLConfig cfg, Subquery subquery) throws Exception {
        String withAsExpreSql;
        List<String> list;
        boolean isWithAsEnable = this.isWithAsEnable();
        List<String> list2 = list = isWithAsEnable ? this.getWithAsExprSqlList() : null;
        if (cfg.getMethod() != RequestMethod.POST && list == null) {
            this.clearWithAsExprListIfNeed();
        }
        String quote = this.getQuote();
        if (list != null) {
            String withQuoteName = quote + subquery.getKey() + quote;
            list.add(" " + withQuoteName + " AS (" + cfg.getSQL(this.isPrepared()) + ") ");
            withAsExpreSql = " SELECT * FROM " + withQuoteName;
            List<Object> subPvl = cfg.getPreparedValueList();
            if (subPvl != null && !subPvl.isEmpty()) {
                List<Object> valueList = this.getWithAsExprPreparedValueList();
                if (valueList == null) {
                    valueList = new ArrayList<Object>();
                }
                valueList.addAll(subPvl);
                this.setWithAsExprPreparedValueList((List)valueList);
                cfg.setPreparedValueList(new ArrayList<Object>());
            }
        } else {
            withAsExpreSql = cfg.getSQL(this.isPrepared());
            if (isWithAsEnable && this.isMySQL() && StringUtil.equals(this.getTable(), subquery.getFrom())) {
                withAsExpreSql = " SELECT * FROM (" + withAsExpreSql + ") AS " + quote + subquery.getKey() + quote;
            }
        }
        return withAsExpreSql;
    }

    @Override
    public String getSubqueryString(Subquery subquery) throws Exception {
        if (subquery == null) {
            return "";
        }
        String range = subquery.getRange();
        SQLConfig cfg = subquery.getConfig();
        if (!StringUtil.equals(this.getTable(), subquery.getFrom()) && !cfg.hasJoin()) {
            cfg.setDatasource(this.getDatasource());
        }
        cfg.setPreparedValueList(new ArrayList<Object>());
        String withAsExprSql = this.withAsExpreSubqueryString(cfg, subquery);
        String sql = (range == null || range.isEmpty() ? "" : range) + "(" + withAsExprSql + ") ";
        List<Object> subPvl = cfg.getPreparedValueList();
        if (subPvl != null && !subPvl.isEmpty()) {
            List<Object> pvl = this.getPreparedValueList();
            if (pvl == null || pvl.isEmpty()) {
                pvl = subPvl;
            } else {
                pvl.addAll(subPvl);
            }
            this.setPreparedValueList((List)pvl);
        }
        return sql;
    }

    public static String getCondition(boolean not, String condition) {
        return AbstractSQLConfig.getCondition(not, condition, false);
    }

    public static String getCondition(boolean not, String condition, boolean addOuterBracket) {
        String s = not ? " NOT (" + condition + ")" : condition;
        return addOuterBracket ? "( " + s + " )" : s;
    }

    @NotNull
    public static JSONArray newJSONArray(Object obj) {
        JSONArray array = new JSONArray();
        if (obj != null) {
            if (obj instanceof Collection) {
                array.addAll((Collection)obj);
            } else {
                array.add(obj);
            }
        }
        return array;
    }

    @JSONField(serialize=false)
    public String getSetString() throws Exception {
        return this.getSetString(this.getMethod(), this.getContent(), !this.isTest());
    }

    @JSONField(serialize=false)
    public String getSetString(RequestMethod method, Map<String, Object> content, boolean verifyName) throws Exception {
        Set<String> set = content == null ? null : content.keySet();
        String setString = "";
        if (set != null && set.size() > 0) {
            boolean isFirst = true;
            String idKey = this.getIdKey();
            for (Map.Entry<String, Object> entry : content.entrySet()) {
                String key = entry.getKey();
                if (key == null || idKey.equals(key)) continue;
                int keyType = key.endsWith("+") ? 1 : (key.endsWith("-") ? 2 : 0);
                Object value = entry.getValue();
                String column = AbstractSQLConfig.getRealKey(method, key, false, true, verifyName);
                setString = setString + (isFirst ? "" : ", ") + this.getKey(column) + " = " + (keyType == 1 ? this.getAddString(key, column, value) : (keyType == 2 ? this.getRemoveString(key, column, value) : this.getValue(key, column, value)));
                isFirst = false;
            }
        }
        if (setString.isEmpty()) {
            throw new IllegalArgumentException("PUT \u8bf7\u6c42\u5fc5\u987b\u5728Table\u5185\u8bbe\u7f6e\u8981\u4fee\u6539\u7684 key:value \uff01");
        }
        return (this.isClickHouse() ? " " : " SET ") + setString;
    }

    @JSONField(serialize=false)
    public String getAddString(String key, String column, Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return this.getKey(column) + " + " + value;
        }
        if (value instanceof String) {
            return SQL.concat(this.getKey(column), (String)this.getValue(key, column, value));
        }
        throw new IllegalArgumentException(key + ":value \u4e2d value \u7c7b\u578b\u9519\u8bef\uff0c\u5fc5\u987b\u662f Number,String,Array \u4e2d\u7684\u4efb\u4f55\u4e00\u79cd\uff01");
    }

    @JSONField(serialize=false)
    public String getRemoveString(String key, String column, Object value) throws IllegalArgumentException {
        if (value instanceof Number) {
            return this.getKey(column) + " - " + value;
        }
        if (value instanceof String) {
            return SQL.replace(this.getKey(column), (String)this.getValue(key, column, value), "''");
        }
        throw new IllegalArgumentException(key + ":value \u4e2d value \u7c7b\u578b\u9519\u8bef\uff0c\u5fc5\u987b\u662f Number,String,Array \u4e2d\u7684\u4efb\u4f55\u4e00\u79cd\uff01");
    }

    @Override
    public boolean isFakeDelete() {
        return false;
    }

    @Override
    public Map<String, Object> onFakeDelete(Map<String, Object> map) {
        return map;
    }

    @Override
    @JSONField(serialize=false)
    public String getSQL(boolean prepared) throws Exception {
        boolean isPrepared = this.isPrepared();
        if (isPrepared == prepared) {
            return AbstractSQLConfig.getSQL(this);
        }
        String sql = AbstractSQLConfig.getSQL(this.setPrepared(prepared));
        this.setPrepared(isPrepared);
        return sql;
    }

    public static String getSQL(AbstractSQLConfig config) throws Exception {
        String explain;
        if (config == null) {
            Log.i(TAG, "getSQL  config == null >> return null;");
            return null;
        }
        String procedure = config.getProcedure();
        if (StringUtil.isNotEmpty(procedure, true)) {
            int ind = procedure.indexOf(".");
            boolean hasPrefix = ind >= 0 && ind < procedure.indexOf("(");
            String sch = hasPrefix ? AbstractFunctionParser.extractSchema(procedure.substring(0, ind), config.getTable()) : config.getSQLSchema();
            String q = config.getQuote();
            return "CALL " + q + sch + q + "." + (hasPrefix ? procedure.substring(ind + 1) : procedure);
        }
        String tablePath = config.getTablePath();
        if (!StringUtil.isNotEmpty(tablePath, true)) {
            Log.i(TAG, "getSQL  StringUtil.isNotEmpty(tablePath, true) == false >> return null;");
            return null;
        }
        config.setPreparedValueList((List)new ArrayList());
        String cSql = null;
        switch (config.getMethod()) {
            case POST: {
                return "INSERT INTO " + tablePath + config.getColumnString() + " VALUES" + config.getValuesString();
            }
            case PUT: {
                if (config.isClickHouse()) {
                    return "ALTER TABLE " + tablePath + " UPDATE" + config.getSetString() + config.getWhereString(true);
                }
                cSql = "UPDATE " + tablePath + config.getSetString() + config.getWhereString(true) + (config.isMySQL() ? config.getLimitString() : "");
                cSql = AbstractSQLConfig.buildWithAsExprSql(config, cSql);
                return cSql;
            }
            case DELETE: {
                if (config.isClickHouse()) {
                    return "ALTER TABLE " + tablePath + " DELETE" + config.getWhereString(true);
                }
                cSql = "DELETE FROM " + tablePath + config.getWhereString(true) + (config.isMySQL() ? config.getLimitString() : "");
                cSql = AbstractSQLConfig.buildWithAsExprSql(config, cSql);
                return cSql;
            }
        }
        String string = config.isExplain() ? (config.isSQLServer() ? "SET STATISTICS PROFILE ON  " : (config.isOracle() || config.isDameng() || config.isKingBase() ? "EXPLAIN PLAN FOR " : "EXPLAIN ")) : (explain = "");
        if (config.isTest() && RequestMethod.isGetMethod(config.getMethod(), true)) {
            String q = config.getQuote();
            return explain + "SELECT " + config.getWhereString(false) + " AS " + q + "count" + q + config.getLimitString();
        }
        config.setPreparedValueList((List)new ArrayList());
        String column = config.getColumnString();
        if (config.isOracle() || config.isDameng() || config.isKingBase()) {
            if (StringUtil.isNotEmpty(config.getGroup(), true) && RequestMethod.isHeadMethod(config.getMethod(), true)) {
                return explain + "SELECT count(*) FROM (SELECT " + (config.getCache() == 2 ? "SQL_NO_CACHE " : "") + column + " FROM " + AbstractSQLConfig.getConditionString(tablePath, config) + ") " + config.getLimitString();
            }
            String sql = "SELECT " + (config.getCache() == 2 ? "SQL_NO_CACHE " : "") + column + " FROM " + AbstractSQLConfig.getConditionString(tablePath, config);
            return explain + config.getOraclePageSql(sql);
        }
        cSql = "SELECT " + (config.getCache() == 2 ? "SQL_NO_CACHE " : "") + column + " FROM " + AbstractSQLConfig.getConditionString(tablePath, config) + config.getLimitString();
        cSql = AbstractSQLConfig.buildWithAsExprSql(config, cSql);
        if (config.isElasticsearch()) {
            return cSql;
        }
        return explain + cSql;
    }

    private static String buildWithAsExprSql(@NotNull AbstractSQLConfig config, String cSql) throws Exception {
        int size;
        if (!config.isWithAsEnable()) {
            return cSql;
        }
        List<String> list = config.getWithAsExprSqlList();
        int n = size = list == null ? 0 : list.size();
        if (size > 0) {
            String withAsExpreSql = "WITH ";
            for (int i = 0; i < size; ++i) {
                withAsExpreSql = withAsExpreSql + (i <= 0 ? "" : ",") + list.get(i) + "\n";
            }
            cSql = withAsExpreSql + cSql;
            config.clearWithAsExprListIfNeed();
        }
        return cSql;
    }

    @Override
    public boolean isWithAsEnable() {
        return ENABLE_WITH_AS && (!this.isMySQL() || this.getDBVersionNums()[0] >= 8);
    }

    protected String getOraclePageSql(String sql) {
        int count = this.getCount();
        int offset = AbstractSQLConfig.getOffset(this.getPage(), count);
        String alias = this.getAliasWithQuote();
        return "SELECT * FROM (SELECT " + alias + ".*, ROWNUM RN FROM (" + sql + ") " + alias + "  WHERE ROWNUM <= " + (offset + count) + ") WHERE RN > " + offset;
    }

    private static String getConditionString(String table, AbstractSQLConfig config) throws Exception {
        Subquery from = config.getFrom();
        if (from != null) {
            table = config.getSubqueryString(from) + " AS " + config.getAliasWithQuote() + " ";
        }
        String join = config.getJoinString();
        String where = config.getWhereString(true);
        String aggregation = RequestMethod.isGetMethod(config.getMethod(), true) ? config.getGroupString(true) + config.getHavingString(true) + config.getOrderString(true) : (RequestMethod.isHeadMethod(config.getMethod(), true) ? config.getGroupString(true) + config.getHavingString(true) : (config.getMethod() == RequestMethod.PUT || config.getMethod() == RequestMethod.DELETE ? config.getHavingString(true) : ""));
        String condition = table + join + where + aggregation;
        return condition;
    }

    @Override
    public boolean isKeyPrefix() {
        return this.keyPrefix;
    }

    @Override
    public AbstractSQLConfig setKeyPrefix(boolean keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    public String getJoinString() throws Exception {
        String joinOns = "";
        if (this.joinList != null) {
            String quote = this.getQuote();
            List<Object> pvl = this.getPreparedValueList();
            for (Join j : this.joinList) {
                String sql;
                this.onGetJoinString(j);
                if (j.isAppJoin()) continue;
                String type = j.getJoinType();
                SQLConfig jc = j.getJoinConfig();
                jc.setPrepared(this.isPrepared());
                jc.setDatasource(this.getDatasource());
                String jt = StringUtil.isEmpty(jc.getAlias(), true) ? jc.getTable() : jc.getAlias();
                List<Join.On> onList = j.getOnList();
                switch (type) {
                    case "*": {
                        this.onGetCrossJoinString(j);
                    }
                    case "<": 
                    case ">": {
                        jc.setMain(true).setKeyPrefix(false);
                        sql = ("<".equals(type) ? " LEFT" : (">".equals(type) ? " RIGHT" : " CROSS")) + " JOIN ( " + jc.getSQL(this.isPrepared()) + " ) AS " + quote + jt + quote;
                        sql = this.concatJoinOn(sql, quote, j, jt, onList);
                        jc.setMain(false).setKeyPrefix(true);
                        pvl.addAll(jc.getPreparedValueList());
                        break;
                    }
                    case "&": 
                    case "": 
                    case "|": 
                    case "!": 
                    case "^": 
                    case "(": 
                    case ")": {
                        sql = " INNER JOIN " + jc.getTablePath();
                        sql = this.concatJoinOn(sql, quote, j, jt, onList);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("join:value \u4e2d value \u91cc\u7684 " + jt + "/" + j.getPath() + "\u9519\u8bef\uff01\u4e0d\u652f\u6301 " + jt + " \u7b49 [ @ APP, < LEFT, > RIGHT, * CROSS, & INNER, | FULL, ! OUTER, ^ SIDE, ( ANTI, ) FOREIGN ] \u4e4b\u5916\u7684 JOIN \u7c7b\u578b !");
                    }
                }
                SQLConfig oc = j.getOuterConfig();
                String ow = null;
                if (oc != null) {
                    oc.setPrepared(this.isPrepared());
                    oc.setPreparedValueList(new ArrayList<Object>());
                    oc.setMain(false).setKeyPrefix(true);
                    ow = oc.getWhereString(false);
                    pvl.addAll(oc.getPreparedValueList());
                }
                joinOns = joinOns + "  \n  " + sql + (StringUtil.isEmpty(ow, true) ? "" : " AND ( " + ow + " ) ");
            }
            this.setPreparedValueList((List)pvl);
        }
        return StringUtil.isEmpty(joinOns, true) ? "" : joinOns + "  \n";
    }

    protected String concatJoinOn(@NotNull String sql, @NotNull String quote, @NotNull Join j, @NotNull String jt, List<Join.On> onList) {
        if (onList != null) {
            boolean first = true;
            for (Join.On on : onList) {
                String rt;
                boolean isNot;
                Logic logic = on.getLogic();
                boolean bl = isNot = logic == null ? false : logic.isNot();
                if (isNot) {
                    this.onJoinNotRelation(sql, quote, j, jt, onList, on);
                }
                if (StringUtil.isEmpty(rt = on.getRelateType(), false)) {
                    sql = sql + (first ? " ON " : " AND ") + quote + jt + quote + "." + quote + on.getKey() + quote + (isNot ? " != " : " = ") + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote;
                } else {
                    this.onJoinComplextRelation(sql, quote, j, jt, onList, on);
                    if (">=".equals(rt) || "<=".equals(rt) || ">".equals(rt) || "<".equals(rt)) {
                        if (isNot) {
                            throw new IllegalArgumentException("join:value \u4e2d value \u91cc\u7684 " + jt + "/" + j.getPath() + " \u4e2d JOIN ON \u6761\u4ef6\u5173\u8054\u903b\u8f91\u7b26 " + rt + " \u4e0d\u5408\u6cd5\uff01 >, <, >=, <= \u4e0d\u652f\u6301\u4e0e\u6216\u975e\u903b\u8f91\u7b26 & | ! \uff01");
                        }
                        sql = sql + (first ? " ON " : " AND ") + quote + jt + quote + "." + quote + on.getKey() + quote + " " + rt + " " + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote;
                    } else if (rt.endsWith("$")) {
                        char l;
                        char r;
                        String t = rt.substring(0, rt.length() - 1);
                        char c = r = t.isEmpty() ? (char)'\u0000' : (char)t.charAt(t.length() - 1);
                        if (r == '%' || r == '_' || r == '?') {
                            if ((t = t.substring(0, t.length() - 1)).isEmpty()) {
                                if (r == '?') {
                                    throw new IllegalArgumentException(on.getOriginKey() + ":value \u4e2d\u5b57\u7b26 " + on.getOriginKey() + " \u4e0d\u5408\u6cd5\uff01key$:value \u4e2d\u4e0d\u5141\u8bb8\u53ea\u6709\u5355\u72ec\u7684 '?'\uff0c\u5fc5\u987b\u548c '%', '_' \u4e4b\u4e00\u914d\u5408\u4f7f\u7528 \uff01");
                                }
                                l = r;
                            } else {
                                l = t.charAt(t.length() - 1);
                                if (l == '%' || l == '_' || l == '?') {
                                    if (l == r) {
                                        throw new IllegalArgumentException(on.getOriginKey() + ":value \u4e2d\u5b57\u7b26 " + t + " \u4e0d\u5408\u6cd5\uff01key$:value \u4e2d\u4e0d\u5141\u8bb8 key \u4e2d\u6709\u8fde\u7eed\u76f8\u540c\u7684\u5360\u4f4d\u7b26\uff01");
                                    }
                                    t = t.substring(0, t.length() - 1);
                                } else if (l > '\u0000' && StringUtil.isName(String.valueOf(l))) {
                                    l = r;
                                }
                            }
                            if (l == '?') {
                                l = '\u0000';
                            }
                            if (r == '?') {
                                r = '\u0000';
                            }
                        } else {
                            r = '\u0000';
                            l = '\u0000';
                        }
                        sql = l <= '\u0000' && r <= '\u0000' ? sql + (first ? " ON " : " AND ") + quote + jt + quote + "." + quote + on.getKey() + quote + (isNot ? " NOT " : "") + " LIKE " + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote : sql + (first ? " ON " : " AND ") + quote + jt + quote + "." + quote + on.getKey() + quote + (isNot ? " NOT " : "") + (l <= '\u0000' ? " LIKE concat(" : " LIKE concat('" + l + "', ") + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote + (r <= '\u0000' ? ")" : ", '" + r + "')");
                    } else if (rt.endsWith("~")) {
                        boolean ignoreCase = "*~".equals(rt);
                        sql = this.isPostgreSQL() || this.isInfluxDB() ? sql + (first ? " ON " : " AND ") + quote + jt + quote + "." + quote + on.getKey() + quote + (isNot ? " NOT " : "") + " ~" + (ignoreCase ? "* " : " ") + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote : (this.isOracle() || this.isDameng() || this.isKingBase() ? sql + (first ? " ON " : " AND ") + "regexp_like(" + quote + jt + quote + "." + quote + on.getKey() + quote + ", " + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote + (ignoreCase ? ", 'i'" : ", 'c'") + ")" : (this.isPresto() || this.isTrino() ? sql + (first ? " ON " : " AND ") + "regexp_like(" + (ignoreCase ? "lower(" : "") + quote + jt + quote + "." + quote + on.getKey() + quote + (ignoreCase ? ")" : "") + ", " + (ignoreCase ? "lower(" : "") + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote + (ignoreCase ? ")" : "") + ")" : (this.isClickHouse() ? sql + (first ? " ON " : " AND ") + "match(" + (ignoreCase ? "lower(" : "") + quote + jt + quote + "." + quote + on.getKey() + quote + (ignoreCase ? ")" : "") + ", " + (ignoreCase ? "lower(" : "") + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote + (ignoreCase ? ")" : "") + ")" : (this.isElasticsearch() ? sql + (first ? " ON " : " AND ") + quote + jt + quote + "." + quote + on.getKey() + quote + (isNot ? " NOT " : "") + " RLIKE " + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote : (this.isHive() ? sql + (first ? " ON " : " AND ") + (ignoreCase ? "lower(" : "") + quote + jt + quote + "." + quote + on.getKey() + quote + (ignoreCase ? ")" : "") + " REGEXP " + (ignoreCase ? "lower(" : "") + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote + (ignoreCase ? ")" : "") : sql + (first ? " ON " : " AND ") + quote + jt + quote + "." + quote + on.getKey() + quote + (isNot ? " NOT " : "") + " REGEXP " + (ignoreCase ? "" : "BINARY ") + quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote)))));
                    } else if ("{}".equals(rt) || "<>".equals(rt)) {
                        String itemKeyPath;
                        String arrKeyPath;
                        String tt = on.getTargetTable();
                        String ta = on.getTargetAlias();
                        Map<String, String> cast = null;
                        if (tt.equals(this.getTable()) && (ta == null && this.getAlias() == null || ta.equals(this.getAlias()))) {
                            cast = this.getCast();
                        } else {
                            boolean find = false;
                            for (Join jn : this.joinList) {
                                if (!tt.equals(jn.getTable()) || (ta != null || jn.getAlias() != null) && !ta.equals(jn.getAlias())) continue;
                                cast = this.getCast();
                                find = true;
                                break;
                            }
                            if (!find) {
                                throw new IllegalArgumentException("join:value \u4e2d value \u91cc\u7684 " + jt + "/" + j.getPath() + " \u4e2d JOIN ON \u6761\u4ef6\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684 " + rt + " \u4e0d\u5408\u6cd5\uff01\u53ea\u652f\u6301 =, {}, <> \u8fd9\u51e0\u79cd\uff01");
                            }
                        }
                        boolean isBoolOrNum = SQL.isBooleanOrNumber(cast == null ? null : cast.get(on.getTargetKey()));
                        if ("{}".equals(rt)) {
                            arrKeyPath = quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote;
                            itemKeyPath = quote + jt + quote + "." + quote + on.getKey() + quote;
                        } else {
                            arrKeyPath = quote + jt + quote + "." + quote + on.getKey() + quote;
                            itemKeyPath = quote + on.getTargetTable() + quote + "." + quote + on.getTargetKey() + quote;
                        }
                        sql = this.isPostgreSQL() || this.isInfluxDB() ? sql + (first ? " ON " : " AND ") + (isNot ? "( " : "") + AbstractSQLConfig.getCondition(isNot, arrKeyPath + " IS NOT NULL AND " + arrKeyPath + " @> " + itemKeyPath) + (isNot ? ") " : "") : (this.isOracle() || this.isDameng() || this.isKingBase() ? sql + (first ? " ON " : " AND ") + (isNot ? "( " : "") + AbstractSQLConfig.getCondition(isNot, arrKeyPath + " IS NOT NULL AND json_textcontains(" + arrKeyPath + ", '$', " + itemKeyPath + ")") + (isNot ? ") " : "") : (this.isPresto() || this.isTrino() ? sql + (first ? " ON " : " AND ") + (isNot ? "( " : "") + AbstractSQLConfig.getCondition(isNot, arrKeyPath + " IS NOT NULL AND json_array_contains(cast(" + arrKeyPath + " AS VARCHAR), " + itemKeyPath + ")") + (isNot ? ") " : "") : (this.isClickHouse() ? sql + (first ? " ON " : " AND ") + (isNot ? "( " : "") + AbstractSQLConfig.getCondition(isNot, arrKeyPath + " IS NOT NULL AND has(JSONExtractArrayRaw(assumeNotNull(" + arrKeyPath + ")), " + itemKeyPath + ")") + (isNot ? ") " : "") : sql + (first ? " ON " : " AND ") + (isNot ? "( " : "") + AbstractSQLConfig.getCondition(isNot, arrKeyPath + " IS NOT NULL AND json_contains(" + arrKeyPath + (isBoolOrNum ? ", cast(" + itemKeyPath + " AS CHAR), '$')" : ", concat('\"', " + itemKeyPath + ", '\"'), '$')")) + (isNot ? ") " : ""))));
                    } else {
                        throw new IllegalArgumentException("join:value \u4e2d value \u91cc\u7684 " + jt + "/" + j.getPath() + " \u4e2d JOIN ON \u6761\u4ef6\u5173\u8054\u7c7b\u578b " + rt + " \u4e0d\u5408\u6cd5\uff01\u53ea\u652f\u6301 =, >, <, >=, <=, !=, $, ~, {}, <> \u8fd9\u51e0\u79cd\uff01");
                    }
                }
                first = false;
            }
        }
        return sql;
    }

    protected void onJoinNotRelation(String sql, String quote, Join join, String table, List<Join.On> onList, Join.On on) {
        throw new UnsupportedOperationException("JOIN \u5df2\u7981\u7528 '!' \u975e\u903b\u8f91\u8fde\u63a5\u7b26 \uff01\u6027\u80fd\u5f88\u5dee\u3001\u9700\u6c42\u6781\u5c11\uff0c\u5982\u8981\u53d6\u6d88\u7981\u7528\u53ef\u5728\u540e\u7aef\u91cd\u5199\u76f8\u5173\u65b9\u6cd5\uff01");
    }

    protected void onJoinComplexRelation(String sql, String quote, Join join, String table, List<Join.On> onList, Join.On on) {
        throw new UnsupportedOperationException("JOIN \u5df2\u7981\u7528 $, ~, {}, <>, >, <, >=, <= \u7b49\u590d\u6742\u5173\u8054 \uff01\u6027\u80fd\u5f88\u5dee\u3001\u9700\u6c42\u6781\u5c11\uff0c\u9ed8\u8ba4\u53ea\u5141\u8bb8 = \u7b49\u4ef7\u5173\u8054\uff0c\u5982\u8981\u53d6\u6d88\u7981\u7528\u53ef\u5728\u540e\u7aef\u91cd\u5199\u76f8\u5173\u65b9\u6cd5\uff01");
    }

    @Deprecated
    protected void onJoinComplextRelation(String sql, String quote, Join join, String table, List<Join.On> onList, Join.On on) {
        this.onJoinComplexRelation(sql, quote, join, table, onList, on);
    }

    protected void onGetJoinString(Join join) throws UnsupportedOperationException {
    }

    protected void onGetCrossJoinString(Join join) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("\u5df2\u7981\u7528 * CROSS JOIN \uff01\u6027\u80fd\u5f88\u5dee\u3001\u9700\u6c42\u6781\u5c11\uff0c\u5982\u8981\u53d6\u6d88\u7981\u7528\u53ef\u5728\u540e\u7aef\u91cd\u5199\u76f8\u5173\u65b9\u6cd5\uff01");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> SQLConfig newSQLConfig(RequestMethod method, String table, String alias, com.alibaba.fastjson.JSONObject request, List<Join> joinList, boolean isProcedure, Callback<T> callback) throws Exception {
        Object userId;
        ArrayList<Object> userIdIn;
        Object id;
        if (request == null) {
            throw new NullPointerException("AbstractSQLConfig: newSQLConfig  request == null!");
        }
        boolean explain = request.getBooleanValue("@explain");
        if (explain && !Log.DEBUG) {
            throw new UnsupportedOperationException("\u975eDEBUG\u6a21\u5f0f, \u4e0d\u5141\u8bb8\u4f20 @explain \uff01");
        }
        String database = request.getString("@database");
        if (!StringUtil.isEmpty(database, false) && !DATABASE_LIST.contains(database)) {
            throw new UnsupportedDataTypeException("@database:value \u4e2d value \u9519\u8bef\uff0c\u53ea\u80fd\u662f [" + StringUtil.getString(DATABASE_LIST.toArray()) + "] \u4e2d\u7684\u4e00\u79cd\uff01");
        }
        String schema = request.getString("@schema");
        String datasource = request.getString("@datasource");
        SQLConfig config = callback.getSQLConfig(method, database, schema, datasource, table);
        config.setAlias(alias);
        config.setDatabase(database);
        config.setSchema(schema);
        config.setDatasource(datasource);
        if (isProcedure) {
            return config;
        }
        config = AbstractSQLConfig.parseJoin(method, config, joinList, callback);
        if (request.isEmpty()) {
            return config;
        }
        String idKey = callback.getIdKey(datasource, database, schema, table);
        String idInKey = idKey + "{}";
        String userIdKey = callback.getUserIdKey(datasource, database, schema, table);
        String userIdInKey = userIdKey + "{}";
        ArrayList<Object> idIn = request.get((Object)idInKey);
        if (idIn instanceof Collection) {
            Collection ids = idIn;
            ArrayList<Object> newIdIn = new ArrayList<Object>();
            for (Object d : ids) {
                if ((!(d instanceof Number) || ((Number)d).longValue() <= 0L) && (!(d instanceof String) || !StringUtil.isNotEmpty(d, true)) || newIdIn.contains(d)) continue;
                newIdIn.add(d);
            }
            if (newIdIn.isEmpty()) {
                throw new NotExistException("AbstractSQLConfig: newSQLConfig idIn instanceof List >> \u53bb\u6389\u65e0\u6548 id \u540e newIdIn.isEmpty()");
            }
            idIn = newIdIn;
            if (method == RequestMethod.DELETE || method == RequestMethod.PUT) {
                config.setCount(newIdIn.size());
            }
        }
        if ((id = request.get((Object)idKey)) == null && method == RequestMethod.POST) {
            id = callback.newId(method, database, schema, datasource, table);
        }
        if (id != null) {
            if (id instanceof Number) {
                if (((Number)id).longValue() <= 0L) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig " + table + ".id <= 0");
                }
            } else if (id instanceof String) {
                if (StringUtil.isEmpty(id, true)) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig StringUtil.isEmpty(" + table + ".id, true)");
                }
            } else if (!(id instanceof Subquery)) {
                throw new IllegalArgumentException(idKey + ":value \u4e2d value \u7684\u7c7b\u578b\u53ea\u80fd\u662f Long\u00a0, String \u6216 Subquery \uff01");
            }
            if (idIn instanceof Collection) {
                boolean contains = false;
                Collection idList = idIn;
                for (Iterator d : idList) {
                    if (d == null || !id.toString().equals(d.toString())) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig  idIn != null && (((List<?>) idIn).contains(id) == false");
                }
            }
            if (method == RequestMethod.DELETE || method == RequestMethod.PUT) {
                config.setCount(1);
            }
        }
        ArrayList<Object> arrayList = userIdIn = userIdInKey.equals(idInKey) ? null : request.get((Object)userIdInKey);
        if (userIdIn instanceof Collection) {
            Collection userIds = userIdIn;
            ArrayList<Object> newUserIdIn = new ArrayList<Object>();
            for (Object d : userIds) {
                if ((!(d instanceof Number) || ((Number)d).longValue() <= 0L) && (!(d instanceof String) || !StringUtil.isNotEmpty(d, true)) || newUserIdIn.contains(d)) continue;
                newUserIdIn.add(d);
            }
            if (newUserIdIn.isEmpty()) {
                throw new NotExistException("AbstractSQLConfig: newSQLConfig userIdIn instanceof List >> \u53bb\u6389\u65e0\u6548 userId \u540e newIdIn.isEmpty()");
            }
            userIdIn = newUserIdIn;
        }
        Object object = userId = userIdKey.equals(idKey) ? null : request.get((Object)userIdKey);
        if (userId != null) {
            if (userId instanceof Number) {
                if (((Number)userId).longValue() <= 0L) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig " + table + ".userId <= 0");
                }
            } else if (userId instanceof String) {
                if (StringUtil.isEmpty(userId, true)) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig StringUtil.isEmpty(" + table + ".userId, true)");
                }
            } else if (!(userId instanceof Subquery)) {
                throw new IllegalArgumentException(userIdKey + ":value \u4e2d value \u7684\u7c7b\u578b\u53ea\u80fd\u662f Long\u00a0, String \u6216 Subquery \uff01");
            }
            if (userIdIn instanceof Collection) {
                boolean contains = false;
                Collection userIds = userIdIn;
                for (Object d : userIds) {
                    if (d == null || !userId.toString().equals(d.toString())) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    throw new NotExistException("AbstractSQLConfig: newSQLConfig  userIdIn != null && (((List<?>) userIdIn).contains(userId) == false");
                }
            }
        }
        String role = request.getString("@role");
        String cache = request.getString("@cache");
        Subquery from = (Subquery)request.get((Object)"@from");
        String column = request.getString("@column");
        String nulls = request.getString("@null");
        String cast = request.getString("@cast");
        String combine = request.getString("@combine");
        String group = request.getString("@group");
        Object having = request.get((Object)"@having");
        String havingAnd = request.getString("@having&");
        String order = request.getString("@order");
        String raw = request.getString("@raw");
        String json = request.getString("@json");
        try {
            String[] fks;
            boolean distinct;
            boolean containColumnHavingAnd;
            Map<String, Object> accessFakeDeleteMap;
            Object deletedKey;
            String[] rawArr;
            request.remove((Object)idKey);
            request.remove((Object)idInKey);
            request.remove((Object)userIdKey);
            request.remove((Object)userIdInKey);
            request.remove((Object)"@role");
            request.remove((Object)"@explain");
            request.remove((Object)"@cache");
            request.remove((Object)"@datasource");
            request.remove((Object)"@database");
            request.remove((Object)"@schema");
            request.remove((Object)"@from");
            request.remove((Object)"@column");
            request.remove((Object)"@null");
            request.remove((Object)"@cast");
            request.remove((Object)"@combine");
            request.remove((Object)"@group");
            request.remove((Object)"@having");
            request.remove((Object)"@having&");
            request.remove((Object)"@order");
            request.remove((Object)"@raw");
            request.remove((Object)"@json");
            request.remove((Object)"@method");
            String[] nullKeys = StringUtil.split(nulls);
            if (nullKeys != null && nullKeys.length > 0) {
                for (String nk : nullKeys) {
                    if (StringUtil.isEmpty(nk, true)) {
                        throw new IllegalArgumentException(table + ":{ @null: value } \u4e2d\u7684\u5b57\u7b26 '" + nk + "' \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
                    }
                    if (request.get((Object)nk) != null) {
                        throw new IllegalArgumentException(table + ":{ @null: value } \u4e2d\u7684\u5b57\u7b26 '" + nk + "' \u5df2\u5728\u5f53\u524d\u5bf9\u8c61\u6709\u975e null \u503c\uff01\u4e0d\u5141\u8bb8\u5bf9\u540c\u4e00\u4e2a JSON key \u8bbe\u7f6e\u4e0d\u540c\u503c\uff01");
                    }
                    request.put(nk, null);
                }
            }
            String[] casts = StringUtil.split(cast);
            HashMap<String, String> castMap = null;
            if (casts != null && casts.length > 0) {
                castMap = new HashMap<String, String>(casts.length);
                for (String c : casts) {
                    Entry<String, String> p = Pair.parseEntry(c);
                    if (StringUtil.isEmpty(p.getKey(), true)) {
                        throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @cast: 'key0:type0,key1:type1..' \u4e2d '" + c + "' \u5bf9\u5e94\u7684 key \u7684\u5b57\u7b26 '" + p.getKey() + "' \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
                    }
                    if (!StringUtil.isName(p.getValue())) {
                        throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @cast: 'key0:type0,key1:type1..' \u4e2d '" + c + "' \u5bf9\u5e94\u7684 type \u7684\u5b57\u7b26 '" + p.getValue() + "' \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u7b26\u5408\u7c7b\u578b\u540d\u79f0\u683c\u5f0f\uff01");
                    }
                    if (castMap.get(p.getKey()) != null) {
                        throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @cast: 'key0:type0,key1:type1..' \u4e2d '" + c + "' \u5bf9\u5e94\u7684 key \u7684\u5b57\u7b26 '" + p.getKey() + "' \u5df2\u5b58\u5728\uff01\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u7c7b\u578b\uff01");
                    }
                    castMap.put(p.getKey(), p.getValue());
                }
            }
            config.setRaw((rawArr = StringUtil.split(raw)) == null || rawArr.length <= 0 ? null : new ArrayList<String>(Arrays.asList(rawArr)));
            LinkedHashMap<String, Object> tableWhere = new LinkedHashMap<String, Object>();
            boolean ignoreBlankStr = IGNORE_BLANK_STRING_METHOD_LIST != null && IGNORE_BLANK_STRING_METHOD_LIST.contains((Object)method);
            boolean ignoreEmptyStr = ignoreBlankStr || IGNORE_EMPTY_STRING_METHOD_LIST != null && IGNORE_EMPTY_STRING_METHOD_LIST.contains((Object)method);
            boolean ignoreEmptyOrBlankStr = ignoreEmptyStr || ignoreBlankStr;
            boolean enableFakeDelete = config.isFakeDelete();
            Set set = request.keySet();
            if (method == RequestMethod.POST) {
                if (idIn != null) {
                    throw new IllegalArgumentException(table + ":{" + idInKey + ": value} \u91cc\u7684 key \u4e0d\u5408\u6cd5\uff01POST \u8bf7\u6c42\u4e2d\u4e0d\u5141\u8bb8\u4f20 " + idInKey + " \u8fd9\u79cd\u975e\u5b57\u6bb5\u547d\u540d key \uff01\u5fc5\u987b\u4e3a \u82f1\u6587\u5b57\u6bcd \u5f00\u5934\u4e14\u53ea\u5305\u542b \u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684 \u5b57\u6bb5\u547d\u540d\uff01");
                }
                if (userIdIn != null) {
                    throw new IllegalArgumentException(table + ":{" + userIdInKey + ": value} \u91cc\u7684 key \u4e0d\u5408\u6cd5\uff01POST \u8bf7\u6c42\u4e2d\u4e0d\u5141\u8bb8\u4f20 " + userIdInKey + " \u8fd9\u79cd\u975e\u5b57\u6bb5\u547d\u540d key \uff01\u5fc5\u987b\u4e3a \u82f1\u6587\u5b57\u6bcd \u5f00\u5934\u4e14\u53ea\u5305\u542b \u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684 \u5b57\u6bb5\u547d\u540d\uff01");
                }
                if (set != null && !set.isEmpty()) {
                    Object[] values;
                    for (String k : set) {
                        if (StringUtil.isName(k)) continue;
                        throw new IllegalArgumentException(table + ":{" + k + ": value} \u91cc\u7684 key \u4e0d\u5408\u6cd5\uff01POST \u8bf7\u6c42\u4e2d\u4e0d\u5141\u8bb8\u4f20 " + k + " \u8fd9\u79cd\u975e\u5b57\u6bb5\u547d\u540d key \uff01\u5fc5\u987b\u4e3a \u82f1\u6587\u5b57\u6bcd \u5f00\u5934\u4e14\u53ea\u5305\u542b \u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7684 \u5b57\u6bb5\u547d\u540d\uff01");
                    }
                    Object[] columns = set.toArray(new String[0]);
                    Collection valueCollection = request.values();
                    Object[] objectArray = values = valueCollection == null ? null : valueCollection.toArray();
                    if (values == null || values.length != columns.length) {
                        throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef:\nAbstractSQLConfig newSQLConfig  values == null || values.length != columns.length !");
                    }
                    column = (id == null ? "" : idKey + ",") + (userId == null ? "" : userIdKey + ",") + StringUtil.getString(columns);
                    int idCount = id == null ? (userId == null ? 0 : 1) : (userId == null ? 1 : 2);
                    int size = idCount + columns.length;
                    ArrayList<Object> items = new ArrayList<Object>(size);
                    if (id != null) {
                        items.add(id);
                    }
                    if (userId != null) {
                        items.add(userId);
                    }
                    for (int j = 0; j < values.length; ++j) {
                        items.add(values[j]);
                    }
                    ArrayList<List<Object>> valuess = new ArrayList<List<Object>>(1);
                    valuess.add(items);
                    config.setValues(valuess);
                }
            } else {
                boolean isWhere = method != RequestMethod.PUT;
                String[] ws = StringUtil.split(combine);
                String combineExpr = ws == null || ws.length != 1 ? null : ws[0];
                LinkedHashMap<String, List<String>> combineMap = new LinkedHashMap<String, List<String>>();
                ArrayList<Object> andList = new ArrayList<Object>();
                ArrayList<Object> orList = new ArrayList<Object>();
                ArrayList<Object> notList = new ArrayList<Object>();
                String[] whereList = new ArrayList();
                if (id != null) {
                    tableWhere.put(idKey, id);
                    andList.add(idKey);
                    whereList.add(idKey);
                }
                if (idIn != null) {
                    tableWhere.put(idInKey, idIn);
                    andList.add(idInKey);
                    whereList.add(idInKey);
                }
                if (userId != null) {
                    tableWhere.put(userIdKey, userId);
                    andList.add(userIdKey);
                    whereList.add(userIdKey);
                }
                if (userIdIn != null) {
                    tableWhere.put(userIdInKey, userIdIn);
                    andList.add(userIdInKey);
                    whereList.add(userIdInKey);
                }
                if (enableFakeDelete) {
                    Object notDeletedValue;
                    Map<String, Object> accessFakeDeleteMap2 = method == RequestMethod.DELETE ? null : AbstractVerifier.ACCESS_FAKE_DELETE_MAP.get(config.getTable());
                    Iterator<String> deletedKey2 = accessFakeDeleteMap2 == null ? null : accessFakeDeleteMap2.get(KEY_DELETED_KEY);
                    boolean hasKey = deletedKey2 instanceof String && StringUtil.isNotEmpty(deletedKey2, true);
                    Object deletedValue = hasKey ? accessFakeDeleteMap2.get(KEY_DELETED_VALUE) : null;
                    boolean containNotDeletedValue = hasKey ? Boolean.valueOf(accessFakeDeleteMap2.containsKey(KEY_NOT_DELETED_VALUE)) : null;
                    Object object2 = notDeletedValue = containNotDeletedValue ? accessFakeDeleteMap2.get(KEY_NOT_DELETED_VALUE) : null;
                    if (deletedValue != null || containNotDeletedValue) {
                        boolean isFakeDelete = true;
                        if (from != null) {
                            List<Join> jl;
                            SQLConfig cfg = from.getConfig();
                            if (cfg != null && StringUtil.equals(table, cfg.getTable())) {
                                isFakeDelete = false;
                            }
                            List<Join> list = jl = isFakeDelete && cfg != null ? cfg.getJoinList() : null;
                            if (jl != null) {
                                for (Join join : jl) {
                                    if (join == null || !StringUtil.equals(table, join.getTable())) continue;
                                    isFakeDelete = false;
                                    break;
                                }
                            }
                        }
                        if (isFakeDelete) {
                            String key;
                            if (deletedValue != null) {
                                key = deletedKey2 + "!";
                                tableWhere.put(key, deletedValue);
                                andList.add(key);
                                whereList.add(key);
                            }
                            if (containNotDeletedValue) {
                                key = deletedKey2.toString();
                                tableWhere.put(key, notDeletedValue);
                                andList.add(key);
                                whereList.add(key);
                            }
                        }
                    }
                }
                if (StringUtil.isNotEmpty(combineExpr, true)) {
                    List<String> banKeyList = Arrays.asList(idKey, idInKey, userIdKey, userIdInKey);
                    for (String key : banKeyList) {
                        if (!AbstractSQLConfig.keyInCombineExpr(combineExpr, key)) continue;
                        throw new UnsupportedOperationException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684 value \u91cc " + key + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20 [" + idKey + ", " + idInKey + ", " + userIdKey + ", " + userIdInKey + "] \u5176\u4e2d\u4efb\u4f55\u4e00\u4e2a\uff01");
                    }
                } else if (ws != null) {
                    for (int i = 0; i < ws.length; ++i) {
                        Object w = ws[i];
                        if (w != null) {
                            if (((String)w).startsWith("&")) {
                                w = ((String)w).substring(1);
                                andList.add(w);
                            } else if (((String)w).startsWith("|")) {
                                if (method == RequestMethod.PUT) {
                                    throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01PUT\u8bf7\u6c42\u7684 @combine:\"key0,key1,...\" \u4e0d\u5141\u8bb8\u4f20 |key \u6216 !key !");
                                }
                                w = ((String)w).substring(1);
                                orList.add(w);
                            } else if (((String)w).startsWith("!")) {
                                if (method == RequestMethod.PUT) {
                                    throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01PUT\u8bf7\u6c42\u7684 @combine:\"key0,key1,...\" \u4e0d\u5141\u8bb8\u4f20 |key \u6216 !key !");
                                }
                                w = ((String)w).substring(1);
                                notList.add(w);
                            } else {
                                orList.add(w);
                            }
                            if (((String)w).isEmpty()) {
                                throw new IllegalArgumentException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc\u6761\u4ef6 " + ws[i] + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u503c\uff01");
                            }
                            if (idKey.equals(w) || idInKey.equals(w) || userIdKey.equals(w) || userIdInKey.equals(w)) {
                                throw new UnsupportedOperationException(table + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684 value \u91cc " + ws[i] + " \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4f20 [" + idKey + ", " + idInKey + ", " + userIdKey + ", " + userIdInKey + "] \u5176\u4e2d\u4efb\u4f55\u4e00\u4e2a\uff01");
                            }
                            whereList.add(w);
                        }
                        if (request.containsKey(w)) continue;
                        callback.onMissingKey4Combine(table, request, combine, ws[i], (String)w);
                    }
                }
                LinkedHashMap<String, Object> tableContent = new LinkedHashMap<String, Object>();
                for (String key : set) {
                    Object value = request.get((Object)key);
                    if (ignoreEmptyOrBlankStr && value instanceof String && StringUtil.isEmpty(value, ignoreBlankStr)) continue;
                    if (!key.endsWith("<>") && value instanceof Map) {
                        throw new IllegalArgumentException(table + ":{ " + key + ":value } \u4e2d value \u7c7b\u578b\u9519\u8bef\uff01\u9664\u4e86 key<>:{} \u5916\uff0c\u4e0d\u5141\u8bb8 " + key + " \u7b49\u5176\u5b83\u4efb\u4f55 key \u5bf9\u5e94 value \u7684\u7c7b\u578b\u4e3a JSONObject {} !");
                    }
                    if (isWhere || !StringUtil.isName(key.replaceFirst("[+-]$", "")) || !isWhere && StringUtil.isNotEmpty(combineExpr, true) && AbstractSQLConfig.keyInCombineExpr(combineExpr, key)) {
                        tableWhere.put(key, value);
                        if (whereList.contains(key)) continue;
                        andList.add(key);
                        continue;
                    }
                    if (whereList.contains(key)) {
                        tableWhere.put(key, value);
                        continue;
                    }
                    tableContent.put(key, value);
                }
                if (combineMap != null) {
                    combineMap.put("&", andList);
                    combineMap.put("|", orList);
                    combineMap.put("!", notList);
                }
                config.setCombineMap(combineMap);
                config.setCombine(combineExpr);
                config.setContent(tableContent);
            }
            if (enableFakeDelete && method == RequestMethod.DELETE && StringUtil.isNotEmpty(deletedKey = (accessFakeDeleteMap = AbstractVerifier.ACCESS_FAKE_DELETE_MAP.get(config.getTable())).get(KEY_DELETED_KEY), true)) {
                Map<String, Object> fakeDeleteMap = new HashMap<String, Object>();
                fakeDeleteMap.put(deletedKey.toString(), accessFakeDeleteMap.get(KEY_DELETED_VALUE));
                fakeDeleteMap = config.onFakeDelete(fakeDeleteMap);
                Map<String, Object> content = config.getContent();
                if (content == null || content.isEmpty()) {
                    content = fakeDeleteMap;
                } else {
                    content.putAll(fakeDeleteMap);
                }
                config.setMethod(RequestMethod.PUT);
                config.setContent(content);
            }
            ArrayList<String> cs = new ArrayList<String>();
            List<String> rawList = config.getRaw();
            boolean bl = containColumnHavingAnd = rawList != null && rawList.contains("@having&");
            if (containColumnHavingAnd) {
                throw new IllegalArgumentException(table + ":{ @raw:value } \u7684 value \u91cc\u5b57\u7b26 @having& \u4e0d\u5408\u6cd5\uff01@raw \u4e0d\u652f\u6301 @having&\uff0c\u8bf7\u7528 @having \u66ff\u4ee3\uff01");
            }
            boolean containColumnRaw = rawList != null && rawList.contains("@column");
            String rawColumnSQL = null;
            if (containColumnRaw && (rawColumnSQL = config.getRawSQL("@column", column)) != null) {
                cs.add(rawColumnSQL);
            }
            boolean bl2 = distinct = rawColumnSQL == null && column != null && column.startsWith(PREFIX_DISTINCT);
            if (rawColumnSQL == null && (fks = StringUtil.split(distinct ? column.substring(PREFIX_DISTINCT.length()) : column, ";")) != null) {
                for (String fk : fks) {
                    String rawSQL;
                    if (containColumnRaw && (rawSQL = config.getRawSQL("@column", fk)) != null) {
                        cs.add(rawSQL);
                        continue;
                    }
                    if (fk.contains("(")) {
                        cs.add(fk);
                        continue;
                    }
                    String[] ks = StringUtil.split(fk);
                    if (ks == null || ks.length <= 0) continue;
                    cs.addAll(Arrays.asList(ks));
                }
            }
            Object newHaving = having;
            boolean isHavingAnd = false;
            LinkedHashMap<String, Object> havingMap = new LinkedHashMap<String, Object>();
            if (havingAnd != null) {
                if (having != null) {
                    throw new IllegalArgumentException(table + ":{ @having: value1, @having&: value2 } \u4e2d value1 \u4e0e value2 \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u540c\u65f6\u4f20 @having \u548c @having& \uff0c\u4e24\u8005\u6700\u591a\u4f20\u4e00\u4e2a\uff01");
                }
                newHaving = havingAnd;
                isHavingAnd = true;
            }
            String havingKey = isHavingAnd ? "@having&" : "@having";
            String havingCombine = "";
            if (newHaving instanceof String) {
                String[] havingss = StringUtil.split((String)newHaving, ";");
                if (havingss != null) {
                    int ind = -1;
                    for (int i = 0; i < havingss.length; ++i) {
                        String[] havings;
                        String[] stringArray;
                        int end;
                        String havingsStr = havingss[i];
                        int start = havingsStr == null ? -1 : havingsStr.indexOf("(");
                        int n = end = havingsStr == null ? -1 : havingsStr.lastIndexOf(")");
                        if (!(IS_HAVING_ALLOW_NOT_FUNCTION || start >= 0 && start < end)) {
                            throw new IllegalArgumentException(table + ":{ " + havingKey + ":value } \u91cc\u7684 value \u4e2d\u7684\u7b2c " + i + " \u4e2a\u5b57\u7b26 '" + havingsStr + "' \u4e0d\u5408\u6cd5\uff01\u91cc\u9762\u6ca1\u6709\u5305\u542b SQL \u51fd\u6570\uff01\u5fc5\u987b\u4e3a fun(col1,col2..)?val \u683c\u5f0f\uff01");
                        }
                        if (start >= 0 && end > start) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = havingsStr;
                        } else {
                            stringArray = havings = StringUtil.split(havingsStr);
                        }
                        if (havings == null) continue;
                        for (int j = 0; j < havings.length; ++j) {
                            ++ind;
                            String h = havings[j];
                            if (StringUtil.isEmpty(h, true)) {
                                throw new IllegalArgumentException(table + ":{ " + havingKey + ":value } \u91cc\u7684 value \u4e2d\u7684\u7b2c " + ind + " \u4e2a\u5b57\u7b26 '" + h + "' \u4e0d\u5408\u6cd5\uff01\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
                            }
                            havingMap.put("having" + ind, h);
                            if (isHavingAnd || IS_HAVING_DEFAULT_AND) continue;
                            havingCombine = havingCombine + (ind <= 0 ? "" : " | ") + "having" + ind;
                        }
                    }
                }
            } else if (newHaving instanceof com.alibaba.fastjson.JSONObject) {
                if (isHavingAnd) {
                    throw new IllegalArgumentException(table + ":{ " + havingKey + ":value } \u91cc\u7684 value \u7c7b\u578b\u4e0d\u5408\u6cd5\uff01@having&:value \u4e2d value \u53ea\u80fd\u662f String\uff0c@having:value \u4e2d value \u53ea\u80fd\u662f String \u6216 JSONObject \uff01");
                }
                com.alibaba.fastjson.JSONObject havingObj = (com.alibaba.fastjson.JSONObject)newHaving;
                Set havingSet = havingObj.entrySet();
                for (Map.Entry entry : havingSet) {
                    String k = entry == null ? null : (String)entry.getKey();
                    Object v = k == null ? null : entry.getValue();
                    if (v == null) continue;
                    if (!(v instanceof String)) {
                        throw new IllegalArgumentException(table + ":{ " + havingKey + ":{ " + k + ":value } } \u91cc\u7684 value \u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u53ea\u80fd\u662f String\uff0c\u4e14\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
                    }
                    if (ignoreEmptyOrBlankStr && StringUtil.isEmpty(v, ignoreBlankStr)) continue;
                    if ("@combine".equals(k)) {
                        havingCombine = v;
                        continue;
                    }
                    if (!StringUtil.isName(k)) {
                        throw new IllegalArgumentException(table + ":{ " + havingKey + ":{ " + k + ":value } } \u91cc\u7684 key \u5bf9\u5e94\u5b57\u7b26 " + k + " \u4e0d\u5408\u6cd5\uff01\u5fc5\u987b\u4e3a \u82f1\u6587\u5b57\u6bcd \u5f00\u5934\uff0c\u4e14\u53ea\u5305\u542b \u82f1\u6587\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\u3001\u6570\u5b57 \u7684\u5408\u6cd5\u53d8\u91cf\u540d\uff01");
                    }
                    havingMap.put(k, v);
                }
            } else if (newHaving != null) {
                throw new IllegalArgumentException(table + ":{ " + havingKey + ":value } \u91cc\u7684 value \u7c7b\u578b\u4e0d\u5408\u6cd5\uff01@having:value \u4e2d value \u53ea\u80fd\u662f String \u6216 JSONObject\uff0c@having&:value \u4e2d value \u53ea\u80fd\u662f String \uff01");
            }
            config.setExplain(explain);
            config.setCache(AbstractSQLConfig.getCache(cache));
            config.setDistinct(distinct);
            config.setColumn(column == null ? null : cs);
            config.setFrom(from);
            config.setRole(role);
            config.setId(id);
            config.setIdIn(idIn);
            config.setUserId(userId);
            config.setUserIdIn(userIdIn);
            config.setNull(nullKeys == null || nullKeys.length <= 0 ? null : new ArrayList<String>(Arrays.asList(nullKeys)));
            config.setCast(castMap);
            config.setWhere(tableWhere);
            config.setGroup(group);
            config.setHaving(havingMap);
            config.setHavingCombine(havingCombine);
            config.setOrder(order);
            String[] jsons = StringUtil.split(json);
            config.setJson(jsons == null || jsons.length <= 0 ? null : new ArrayList<String>(Arrays.asList(jsons)));
        }
        finally {
            if (id != null) {
                request.put(idKey, id);
            }
            if (idIn != null) {
                request.put(idInKey, idIn);
            }
            if (userId != null) {
                request.put(userIdKey, userId);
            }
            if (userIdIn != null) {
                request.put(userIdInKey, userIdIn);
            }
            request.put("@database", (Object)database);
            request.put("@role", (Object)role);
            request.put("@explain", (Object)explain);
            request.put("@cache", (Object)cache);
            request.put("@datasource", (Object)datasource);
            request.put("@schema", (Object)schema);
            request.put("@from", (Object)from);
            request.put("@column", (Object)column);
            request.put("@null", (Object)nulls);
            request.put("@cast", (Object)cast);
            request.put("@combine", (Object)combine);
            request.put("@group", (Object)group);
            request.put("@having", having);
            request.put("@having&", (Object)havingAnd);
            request.put("@order", (Object)order);
            request.put("@raw", (Object)raw);
            request.put("@json", (Object)json);
        }
        return config;
    }

    public static <T> SQLConfig parseJoin(RequestMethod method, SQLConfig config, List<Join> joinList, Callback<T> callback) throws Exception {
        boolean isQuery = RequestMethod.isQueryMethod(method);
        config.setKeyPrefix(isQuery && !config.isMain());
        if (joinList == null || joinList.isEmpty() || !RequestMethod.isQueryMethod(method)) {
            return config;
        }
        for (Join j : joinList) {
            SQLConfig cacheConfig;
            String table = j.getTable();
            String alias = j.getAlias();
            SQLConfig joinConfig = AbstractSQLConfig.newSQLConfig(method, table, alias, j.getRequest(), null, false, callback);
            SQLConfig sQLConfig = cacheConfig = !j.canCacheViceTable() ? null : AbstractSQLConfig.newSQLConfig(method, table, alias, j.getRequest(), null, false, callback).setCount(j.getCount());
            if (!j.isAppJoin()) {
                if (joinConfig.getDatabase() == null) {
                    joinConfig.setDatabase(config.getDatabase());
                } else if (!joinConfig.getDatabase().equals(config.getDatabase())) {
                    throw new IllegalArgumentException("\u4e3b\u8868 " + config.getTable() + " \u7684 @database:" + config.getDatabase() + " \u548c\u5b83 SQL JOIN \u7684\u526f\u8868 " + table + " \u7684 @database:" + joinConfig.getDatabase() + " \u4e0d\u4e00\u81f4\uff01");
                }
                if (joinConfig.getSchema() == null) {
                    joinConfig.setSchema(config.getSchema());
                }
                if (cacheConfig != null) {
                    cacheConfig.setDatabase(joinConfig.getDatabase()).setSchema(joinConfig.getSchema());
                }
                if (isQuery) {
                    config.setKeyPrefix(true);
                }
                joinConfig.setMain(false).setKeyPrefix(true);
                if (j.getOuter() != null) {
                    SQLConfig outterConfig = AbstractSQLConfig.newSQLConfig(method, table, alias, j.getOuter(), null, false, callback);
                    outterConfig.setMain(false).setKeyPrefix(true).setDatabase(joinConfig.getDatabase()).setSchema(joinConfig.getSchema());
                    j.setOuterConfig(outterConfig);
                }
            }
            if (RequestMethod.isHeadMethod(method, true)) {
                ArrayList<String> column;
                List<Join.On> onList = j.getOnList();
                ArrayList<String> arrayList = column = onList == null ? null : new ArrayList<String>(onList.size());
                if (column != null) {
                    for (Join.On on : onList) {
                        column.add(on.getKey());
                    }
                }
                joinConfig.setMethod(RequestMethod.GET);
                joinConfig.setColumn(column);
                if (cacheConfig != null) {
                    cacheConfig.setMethod(RequestMethod.GET);
                    cacheConfig.setColumn(column);
                }
            }
            j.setJoinConfig(joinConfig);
            j.setCacheConfig(cacheConfig);
        }
        config.setJoinList(joinList);
        return config;
    }

    public static String getRealKey(RequestMethod method, String originKey, boolean isTableKey, boolean saveLogic) throws Exception {
        return AbstractSQLConfig.getRealKey(method, originKey, isTableKey, saveLogic, true);
    }

    public static String getRealKey(RequestMethod method, String originKey, boolean isTableKey, boolean saveLogic, boolean verifyName) throws Exception {
        String last;
        Log.i(TAG, "getRealKey  saveLogic = " + saveLogic + "; originKey = " + originKey);
        if (originKey == null || JSONObject.isArrayKey(originKey)) {
            Log.w(TAG, "getRealKey  originKey == null || apijson.JSONObject.isArrayKey(originKey) >>  return originKey;");
            return originKey;
        }
        String key = new String(originKey);
        if (key.endsWith("$")) {
            int c;
            String k = key.substring(0, key.length() - 1);
            int n = c = k.isEmpty() ? 0 : (int)k.charAt(k.length() - 1);
            if (c == 37 || c == 95 || c == 63) {
                int c2;
                int n2 = c2 = (k = k.substring(0, k.length() - 1)).isEmpty() ? 0 : (int)k.charAt(k.length() - 1);
                if (c2 == 37 || c2 == 95 || c2 == 63) {
                    if (c2 == c) {
                        throw new IllegalArgumentException(originKey + ":value \u4e2d\u5b57\u7b26 " + k + " \u4e0d\u5408\u6cd5\uff01key$:value \u4e2d\u4e0d\u5141\u8bb8 key \u4e2d\u6709\u8fde\u7eed\u76f8\u540c\u7684\u5360\u4f4d\u7b26\uff01");
                    }
                    k = k.substring(0, k.length() - 1);
                } else if (c == 63) {
                    throw new IllegalArgumentException(originKey + ":value \u4e2d\u5b57\u7b26 " + originKey + " \u4e0d\u5408\u6cd5\uff01key$:value \u4e2d\u4e0d\u5141\u8bb8\u53ea\u6709\u5355\u72ec\u7684 '?'\uff0c\u5fc5\u987b\u548c '%', '_' \u4e4b\u4e00\u914d\u5408\u4f7f\u7528 \uff01");
                }
            }
            key = k;
        } else if (key.endsWith("~")) {
            if ((key = key.substring(0, key.length() - 1)).endsWith("*")) {
                key = key.substring(0, key.length() - 1);
            }
        } else if (key.endsWith("%")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("{}")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("}{")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("<>")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("()")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("@")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith(">=")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith("<=")) {
            key = key.substring(0, key.length() - 2);
        } else if (key.endsWith(">")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("<")) {
            key = key.substring(0, key.length() - 1);
        } else if (key.endsWith("+")) {
            if (method == RequestMethod.PUT) {
                key = key.substring(0, key.length() - 1);
            }
        } else if (key.endsWith("-") && method == RequestMethod.PUT) {
            key = key.substring(0, key.length() - 1);
        }
        String string = last = key.isEmpty() ? "" : key.substring(key.length() - 1);
        if ("&".equals(last) || "|".equals(last) || "!".equals(last)) {
            key = key.substring(0, key.length() - 1);
        } else {
            last = null;
        }
        key = isTableKey ? Pair.parseEntry(key, true).getKey() : Pair.parseEntry(key).getValue();
        if (verifyName && !StringUtil.isName(key.startsWith("@") ? key.substring(1) : key)) {
            throw new IllegalArgumentException((Object)((Object)method) + "\u8bf7\u6c42\uff0c\u5b57\u7b26 " + originKey + " \u4e0d\u5408\u6cd5\uff01 key:value \u4e2d\u7684key\u53ea\u80fd\u5173\u952e\u8bcd '@key' \u6216 'key[\u903b\u8f91\u7b26][\u6761\u4ef6\u7b26]' \u6216 PUT\u8bf7\u6c42\u4e0b\u7684 'key+' / 'key-' \uff01");
        }
        if (saveLogic && last != null) {
            key = key + last;
        }
        Log.i(TAG, "getRealKey  return key = " + key);
        return key;
    }

    private static boolean keyInCombineExpr(String combineExpr, String key) {
        while (!combineExpr.isEmpty()) {
            int right;
            int index = combineExpr.indexOf(key);
            if (index < 0) {
                return false;
            }
            int left = index <= 0 ? 32 : (int)combineExpr.charAt(index - 1);
            int n = right = index >= combineExpr.length() - key.length() ? 32 : (int)combineExpr.charAt(index + key.length());
            if (!(left != 32 && left != 40 && left != 38 && left != 124 && left != 33 || right != 32 && right != 41 && right != 58)) {
                return true;
            }
            int newIndex = index + key.length() + 1;
            if (combineExpr.length() <= newIndex) break;
            combineExpr = combineExpr.substring(newIndex);
        }
        return false;
    }

    public List<String> getWithAsExprSqlList() {
        return this.withAsExprSqlList;
    }

    private void clearWithAsExprListIfNeed() {
        if (this.isMySQL() && this.getDBVersionNums()[0] >= 8) {
            this.withAsExprSqlList = new ArrayList<String>();
        }
    }

    @Override
    public List<Object> getWithAsExprPreparedValueList() {
        return this.withAsExprPreparedValueList;
    }

    @Override
    public AbstractSQLConfig setWithAsExprPreparedValueList(List<Object> list) {
        this.withAsExprPreparedValueList = list;
        return this;
    }

    static {
        TABLE_KEY_MAP.put(Table.class.getSimpleName(), "tables");
        TABLE_KEY_MAP.put(Column.class.getSimpleName(), "columns");
        TABLE_KEY_MAP.put(PgClass.class.getSimpleName(), "pg_class");
        TABLE_KEY_MAP.put(PgAttribute.class.getSimpleName(), "pg_attribute");
        TABLE_KEY_MAP.put(SysTable.class.getSimpleName(), "tables");
        TABLE_KEY_MAP.put(SysColumn.class.getSimpleName(), "columns");
        TABLE_KEY_MAP.put(ExtendedProperty.class.getSimpleName(), "extended_properties");
        TABLE_KEY_MAP.put(AllTable.class.getSimpleName(), "ALL_TABLES");
        TABLE_KEY_MAP.put(AllColumn.class.getSimpleName(), "ALL_TAB_COLUMNS");
        TABLE_KEY_MAP.put(AllTableComment.class.getSimpleName(), "ALL_TAB_COMMENTS");
        TABLE_KEY_MAP.put(AllColumnComment.class.getSimpleName(), "ALL_COL_COMMENTS");
        ALLOW_PARTIAL_UPDATE_FAIL_TABLE_MAP = new HashMap<String, String>();
        CONFIG_TABLE_LIST = new ArrayList<String>();
        CONFIG_TABLE_LIST.add(Function.class.getSimpleName());
        CONFIG_TABLE_LIST.add(Request.class.getSimpleName());
        CONFIG_TABLE_LIST.add(Access.class.getSimpleName());
        CONFIG_TABLE_LIST.add(Document.class.getSimpleName());
        CONFIG_TABLE_LIST.add(TestRecord.class.getSimpleName());
        DATABASE_LIST = new ArrayList<String>();
        DATABASE_LIST.add("MYSQL");
        DATABASE_LIST.add("POSTGRESQL");
        DATABASE_LIST.add("SQLSERVER");
        DATABASE_LIST.add("ORACLE");
        DATABASE_LIST.add("DB2");
        DATABASE_LIST.add("MARIADB");
        DATABASE_LIST.add("TIDB");
        DATABASE_LIST.add("DAMENG");
        DATABASE_LIST.add("KINGBASE");
        DATABASE_LIST.add("ELASTICSEARCH");
        DATABASE_LIST.add("CLICKHOUSE");
        DATABASE_LIST.add("HIVE");
        DATABASE_LIST.add("PRESTO");
        DATABASE_LIST.add("TRINO");
        DATABASE_LIST.add("INFLUXDB");
        DATABASE_LIST.add("TDENGINE");
        DATABASE_LIST.add("REDIS");
        DATABASE_LIST.add("MQ");
        RAW_MAP = new LinkedHashMap<String, String>();
        RAW_MAP.put("+", "");
        RAW_MAP.put("-", "");
        RAW_MAP.put("*", "");
        RAW_MAP.put("/", "");
        RAW_MAP.put("=", "");
        RAW_MAP.put("!=", "");
        RAW_MAP.put(">", "");
        RAW_MAP.put(">=", "");
        RAW_MAP.put("<", "");
        RAW_MAP.put("<=", "");
        RAW_MAP.put("%", "");
        RAW_MAP.put("(", "");
        RAW_MAP.put(")", "");
        RAW_MAP.put("AS", "");
        RAW_MAP.put("IS NOT NULL", "");
        RAW_MAP.put("IS NULL", "");
        RAW_MAP.put("IS", "");
        RAW_MAP.put("NULL", "");
        RAW_MAP.put("AND", "");
        RAW_MAP.put("OR", "");
        RAW_MAP.put("NOT", "");
        RAW_MAP.put("VALUE", "");
        RAW_MAP.put("DISTINCT", "");
        RAW_MAP.put("CASE", "");
        RAW_MAP.put("WHEN", "");
        RAW_MAP.put("THEN", "");
        RAW_MAP.put("ELSE", "");
        RAW_MAP.put("END", "");
        RAW_MAP.put("now()", "");
        RAW_MAP.put("DATE", "");
        RAW_MAP.put("TIME", "");
        RAW_MAP.put("DATETIME", "");
        RAW_MAP.put("TIMESTAMP", "");
        RAW_MAP.put("DateTime", "");
        RAW_MAP.put("SECOND", "");
        RAW_MAP.put("MINUTE", "");
        RAW_MAP.put("HOUR", "");
        RAW_MAP.put("DAY", "");
        RAW_MAP.put("WEEK", "");
        RAW_MAP.put("MONTH", "");
        RAW_MAP.put("QUARTER", "");
        RAW_MAP.put("YEAR", "");
        RAW_MAP.put("BINARY", "");
        RAW_MAP.put("SIGNED", "");
        RAW_MAP.put("DECIMAL", "");
        RAW_MAP.put("DOUBLE", "");
        RAW_MAP.put("FLOAT", "");
        RAW_MAP.put("BOOLEAN", "");
        RAW_MAP.put("ENUM", "");
        RAW_MAP.put("SET", "");
        RAW_MAP.put("POINT", "");
        RAW_MAP.put("BLOB", "");
        RAW_MAP.put("LONGBLOB", "");
        RAW_MAP.put("BINARY", "");
        RAW_MAP.put("UNSIGNED", "");
        RAW_MAP.put("BIT", "");
        RAW_MAP.put("TINYINT", "");
        RAW_MAP.put("SMALLINT", "");
        RAW_MAP.put("INT", "");
        RAW_MAP.put("BIGINT", "");
        RAW_MAP.put("CHAR", "");
        RAW_MAP.put("VARCHAR", "");
        RAW_MAP.put("TEXT", "");
        RAW_MAP.put("LONGTEXT", "");
        RAW_MAP.put("JSON", "");
        RAW_MAP.put("OVER", "");
        RAW_MAP.put("INTERVAL", "");
        RAW_MAP.put("GROUP BY", "");
        RAW_MAP.put("GROUP", "");
        RAW_MAP.put("ORDER BY", "");
        RAW_MAP.put("ORDER", "");
        RAW_MAP.put("PARTITION BY", "");
        RAW_MAP.put("PARTITION", "");
        RAW_MAP.put("BY", "");
        RAW_MAP.put("DESC", "");
        RAW_MAP.put("ASC", "");
        RAW_MAP.put("FOLLOWING", "");
        RAW_MAP.put("BETWEEN", "");
        RAW_MAP.put("AND", "");
        RAW_MAP.put("ROWS", "");
        RAW_MAP.put("AGAINST", "");
        RAW_MAP.put("IN NATURAL LANGUAGE MODE", "");
        RAW_MAP.put("IN BOOLEAN MODE", "");
        RAW_MAP.put("IN", "");
        RAW_MAP.put("BOOLEAN", "");
        RAW_MAP.put("NATURAL", "");
        RAW_MAP.put("LANGUAGE", "");
        RAW_MAP.put("MODE", "");
        SQL_AGGREGATE_FUNCTION_MAP = new LinkedHashMap<String, String>();
        SQL_AGGREGATE_FUNCTION_MAP.put("max", "");
        SQL_AGGREGATE_FUNCTION_MAP.put("min", "");
        SQL_AGGREGATE_FUNCTION_MAP.put("avg", "");
        SQL_AGGREGATE_FUNCTION_MAP.put("count", "");
        SQL_AGGREGATE_FUNCTION_MAP.put("sum", "");
        SQL_FUNCTION_MAP = new LinkedHashMap<String, String>();
        SQL_FUNCTION_MAP.put("rank", "");
        SQL_FUNCTION_MAP.put("dense_rank", "");
        SQL_FUNCTION_MAP.put("row_num", "");
        SQL_FUNCTION_MAP.put("row_number", "");
        SQL_FUNCTION_MAP.put("ntile", "");
        SQL_FUNCTION_MAP.put("first_value", "");
        SQL_FUNCTION_MAP.put("last_value", "");
        SQL_FUNCTION_MAP.put("lag", "");
        SQL_FUNCTION_MAP.put("lead", "");
        SQL_FUNCTION_MAP.put("cume_dist", "");
        SQL_FUNCTION_MAP.put("percent_rank", "");
        SQL_FUNCTION_MAP.put("ascii", "");
        SQL_FUNCTION_MAP.put("char_length", "");
        SQL_FUNCTION_MAP.put("character_length", "");
        SQL_FUNCTION_MAP.put("concat", "");
        SQL_FUNCTION_MAP.put("concat_ws", "");
        SQL_FUNCTION_MAP.put("field", "");
        SQL_FUNCTION_MAP.put("find_in_set", "");
        SQL_FUNCTION_MAP.put("format", "");
        SQL_FUNCTION_MAP.put("insert", "");
        SQL_FUNCTION_MAP.put("locate", "");
        SQL_FUNCTION_MAP.put("lcase", "");
        SQL_FUNCTION_MAP.put("left", "");
        SQL_FUNCTION_MAP.put("length", "");
        SQL_FUNCTION_MAP.put("lower", "");
        SQL_FUNCTION_MAP.put("lpad", "");
        SQL_FUNCTION_MAP.put("ltrim", "");
        SQL_FUNCTION_MAP.put("mid", "");
        SQL_FUNCTION_MAP.put("position", "");
        SQL_FUNCTION_MAP.put("repeat", "");
        SQL_FUNCTION_MAP.put("replace", "");
        SQL_FUNCTION_MAP.put("reverse", "");
        SQL_FUNCTION_MAP.put("right", "");
        SQL_FUNCTION_MAP.put("rpad", "");
        SQL_FUNCTION_MAP.put("rtrim", "");
        SQL_FUNCTION_MAP.put("space", "");
        SQL_FUNCTION_MAP.put("strcmp", "");
        SQL_FUNCTION_MAP.put("substr", "");
        SQL_FUNCTION_MAP.put("substring", "");
        SQL_FUNCTION_MAP.put("substring_index", "");
        SQL_FUNCTION_MAP.put("trim", "");
        SQL_FUNCTION_MAP.put("ucase", "");
        SQL_FUNCTION_MAP.put("upper", "");
        SQL_FUNCTION_MAP.put("abs", "");
        SQL_FUNCTION_MAP.put("acos", "");
        SQL_FUNCTION_MAP.put("asin", "");
        SQL_FUNCTION_MAP.put("atan", "");
        SQL_FUNCTION_MAP.put("atan2", "");
        SQL_FUNCTION_MAP.put("avg", "");
        SQL_FUNCTION_MAP.put("ceil", "");
        SQL_FUNCTION_MAP.put("ceiling", "");
        SQL_FUNCTION_MAP.put("cos", "");
        SQL_FUNCTION_MAP.put("cot", "");
        SQL_FUNCTION_MAP.put("count", "");
        SQL_FUNCTION_MAP.put("degrees", "");
        SQL_FUNCTION_MAP.put("div", "");
        SQL_FUNCTION_MAP.put("exp", "");
        SQL_FUNCTION_MAP.put("floor", "");
        SQL_FUNCTION_MAP.put("greatest", "");
        SQL_FUNCTION_MAP.put("least", "");
        SQL_FUNCTION_MAP.put("ln", "");
        SQL_FUNCTION_MAP.put("log", "");
        SQL_FUNCTION_MAP.put("log10", "");
        SQL_FUNCTION_MAP.put("log2", "");
        SQL_FUNCTION_MAP.put("max", "");
        SQL_FUNCTION_MAP.put("min", "");
        SQL_FUNCTION_MAP.put("mod", "");
        SQL_FUNCTION_MAP.put("pi", "");
        SQL_FUNCTION_MAP.put("pow", "");
        SQL_FUNCTION_MAP.put("power", "");
        SQL_FUNCTION_MAP.put("radians", "");
        SQL_FUNCTION_MAP.put("rand", "");
        SQL_FUNCTION_MAP.put("round", "");
        SQL_FUNCTION_MAP.put("sign", "");
        SQL_FUNCTION_MAP.put("sin", "");
        SQL_FUNCTION_MAP.put("sqrt", "");
        SQL_FUNCTION_MAP.put("sum", "");
        SQL_FUNCTION_MAP.put("tan", "");
        SQL_FUNCTION_MAP.put("truncate", "");
        SQL_FUNCTION_MAP.put("adddate", "");
        SQL_FUNCTION_MAP.put("addtime", "");
        SQL_FUNCTION_MAP.put("curdate", "");
        SQL_FUNCTION_MAP.put("current_date", "");
        SQL_FUNCTION_MAP.put("current_time", "");
        SQL_FUNCTION_MAP.put("current_timestamp", "");
        SQL_FUNCTION_MAP.put("curtime", "");
        SQL_FUNCTION_MAP.put("date", "");
        SQL_FUNCTION_MAP.put("datediff", "");
        SQL_FUNCTION_MAP.put("date_add", "");
        SQL_FUNCTION_MAP.put("date_format", "");
        SQL_FUNCTION_MAP.put("date_sub", "");
        SQL_FUNCTION_MAP.put("day", "");
        SQL_FUNCTION_MAP.put("dayname", "");
        SQL_FUNCTION_MAP.put("dayofmonth", "");
        SQL_FUNCTION_MAP.put("dayofweek", "");
        SQL_FUNCTION_MAP.put("dayofyear", "");
        SQL_FUNCTION_MAP.put("extract", "");
        SQL_FUNCTION_MAP.put("from_days", "");
        SQL_FUNCTION_MAP.put("hour", "");
        SQL_FUNCTION_MAP.put("last_day", "");
        SQL_FUNCTION_MAP.put("localtime", "");
        SQL_FUNCTION_MAP.put("localtimestamp", "");
        SQL_FUNCTION_MAP.put("makedate", "");
        SQL_FUNCTION_MAP.put("maketime", "");
        SQL_FUNCTION_MAP.put("microsecond", "");
        SQL_FUNCTION_MAP.put("minute", "");
        SQL_FUNCTION_MAP.put("monthname", "");
        SQL_FUNCTION_MAP.put("month", "");
        SQL_FUNCTION_MAP.put("now", "");
        SQL_FUNCTION_MAP.put("period_add", "");
        SQL_FUNCTION_MAP.put("period_diff", "");
        SQL_FUNCTION_MAP.put("quarter", "");
        SQL_FUNCTION_MAP.put("second", "");
        SQL_FUNCTION_MAP.put("sec_to_time", "");
        SQL_FUNCTION_MAP.put("str_to_date", "");
        SQL_FUNCTION_MAP.put("subdate", "");
        SQL_FUNCTION_MAP.put("subtime", "");
        SQL_FUNCTION_MAP.put("sysdate", "");
        SQL_FUNCTION_MAP.put("time", "");
        SQL_FUNCTION_MAP.put("time_format", "");
        SQL_FUNCTION_MAP.put("time_to_sec", "");
        SQL_FUNCTION_MAP.put("timediff", "");
        SQL_FUNCTION_MAP.put("timestamp", "");
        SQL_FUNCTION_MAP.put("to_days", "");
        SQL_FUNCTION_MAP.put("week", "");
        SQL_FUNCTION_MAP.put("weekday", "");
        SQL_FUNCTION_MAP.put("weekofyear", "");
        SQL_FUNCTION_MAP.put("year", "");
        SQL_FUNCTION_MAP.put("yearweek", "");
        SQL_FUNCTION_MAP.put("unix_timestamp", "");
        SQL_FUNCTION_MAP.put("from_unixtime", "");
        SQL_FUNCTION_MAP.put("json_append", "");
        SQL_FUNCTION_MAP.put("json_array", "");
        SQL_FUNCTION_MAP.put("json_array_append", "");
        SQL_FUNCTION_MAP.put("json_array_insert", "");
        SQL_FUNCTION_MAP.put("json_array_get", "");
        SQL_FUNCTION_MAP.put("json_contains", "");
        SQL_FUNCTION_MAP.put("json_array_contains", "");
        SQL_FUNCTION_MAP.put("json_contains_path", "");
        SQL_FUNCTION_MAP.put("json_depth", "");
        SQL_FUNCTION_MAP.put("json_extract", "");
        SQL_FUNCTION_MAP.put("json_extract_scalar", "");
        SQL_FUNCTION_MAP.put("json_insert", "");
        SQL_FUNCTION_MAP.put("json_keys", "");
        SQL_FUNCTION_MAP.put("json_length", "");
        SQL_FUNCTION_MAP.put("json_size", "");
        SQL_FUNCTION_MAP.put("json_array_length", "");
        SQL_FUNCTION_MAP.put("json_format", "");
        SQL_FUNCTION_MAP.put("json_parse", "");
        SQL_FUNCTION_MAP.put("json_merge", "");
        SQL_FUNCTION_MAP.put("json_merge_patch", "");
        SQL_FUNCTION_MAP.put("json_merge_preserve", "");
        SQL_FUNCTION_MAP.put("json_object", "");
        SQL_FUNCTION_MAP.put("json_overlaps", "");
        SQL_FUNCTION_MAP.put("json_pretty", "");
        SQL_FUNCTION_MAP.put("json_quote", "");
        SQL_FUNCTION_MAP.put("json_remove", "");
        SQL_FUNCTION_MAP.put("json_replace", "");
        SQL_FUNCTION_MAP.put("json_schema_valid", "");
        SQL_FUNCTION_MAP.put("json_schema_validation_report", "");
        SQL_FUNCTION_MAP.put("json_search", "");
        SQL_FUNCTION_MAP.put("json_set", "");
        SQL_FUNCTION_MAP.put("json_table", "");
        SQL_FUNCTION_MAP.put("json_type", "");
        SQL_FUNCTION_MAP.put("json_unquote", "");
        SQL_FUNCTION_MAP.put("json_valid", "");
        SQL_FUNCTION_MAP.put("json_arrayagg", "");
        SQL_FUNCTION_MAP.put("json_objectagg", "");
        SQL_FUNCTION_MAP.put("is_json_scalar", "");
        SQL_FUNCTION_MAP.put("case", "");
        SQL_FUNCTION_MAP.put("cast", "");
        SQL_FUNCTION_MAP.put("coalesce", "");
        SQL_FUNCTION_MAP.put("if", "");
        SQL_FUNCTION_MAP.put("ifnull", "");
        SQL_FUNCTION_MAP.put("isnull", "");
        SQL_FUNCTION_MAP.put("nullif", "");
        SQL_FUNCTION_MAP.put("group_concat", "");
        SQL_FUNCTION_MAP.put("match", "");
        SQL_FUNCTION_MAP.put("any_value", "");
        SQL_FUNCTION_MAP.put("empty", "");
        SQL_FUNCTION_MAP.put("notEmpty", "");
        SQL_FUNCTION_MAP.put("lengthUTF8", "");
        SQL_FUNCTION_MAP.put("lcase", "");
        SQL_FUNCTION_MAP.put("ucase", "");
        SQL_FUNCTION_MAP.put("lowerUTF8", "");
        SQL_FUNCTION_MAP.put("upperUTF8", "");
        SQL_FUNCTION_MAP.put("isValidUTF8", "");
        SQL_FUNCTION_MAP.put("toValidUTF8", "");
        SQL_FUNCTION_MAP.put("reverseUTF8", "");
        SQL_FUNCTION_MAP.put("concatAssumeInjective", "");
        SQL_FUNCTION_MAP.put("substringUTF8", "");
        SQL_FUNCTION_MAP.put("appendTrailingCharIfAbsent", "");
        SQL_FUNCTION_MAP.put("convertCharset", "");
        SQL_FUNCTION_MAP.put("base64Encode", "");
        SQL_FUNCTION_MAP.put("base64Decode", "");
        SQL_FUNCTION_MAP.put("tryBase64Decode", "");
        SQL_FUNCTION_MAP.put("endsWith", "");
        SQL_FUNCTION_MAP.put("startsWith", "");
        SQL_FUNCTION_MAP.put("trimLeft", "");
        SQL_FUNCTION_MAP.put("trimRight", "");
        SQL_FUNCTION_MAP.put("trimBoth", "");
        SQL_FUNCTION_MAP.put("extractAllGroups", "");
        SQL_FUNCTION_MAP.put("normalizeQuery", "");
        SQL_FUNCTION_MAP.put("normalizedQueryHash", "");
        SQL_FUNCTION_MAP.put("positionUTF8", "");
        SQL_FUNCTION_MAP.put("multiSearchFirstIndex", "");
        SQL_FUNCTION_MAP.put("multiSearchAny", "");
        SQL_FUNCTION_MAP.put("match", "");
        SQL_FUNCTION_MAP.put("multiMatchAny", "");
        SQL_FUNCTION_MAP.put("multiMatchAnyIndex", "");
        SQL_FUNCTION_MAP.put("extract", "");
        SQL_FUNCTION_MAP.put("extractAll", "");
        SQL_FUNCTION_MAP.put("like", "");
        SQL_FUNCTION_MAP.put("notLike", "");
        SQL_FUNCTION_MAP.put("countSubstrings", "");
        SQL_FUNCTION_MAP.put("countMatches", "");
        SQL_FUNCTION_MAP.put("replaceOne", "");
        SQL_FUNCTION_MAP.put("replaceAll", "");
        SQL_FUNCTION_MAP.put("replaceRegexpOne", "");
        SQL_FUNCTION_MAP.put("replaceRegexpAll", "");
        SQL_FUNCTION_MAP.put("regexpQuoteMeta", "");
        SQL_FUNCTION_MAP.put("toYear", "");
        SQL_FUNCTION_MAP.put("toQuarter", "");
        SQL_FUNCTION_MAP.put("toMonth", "");
        SQL_FUNCTION_MAP.put("toDayOfYear", "");
        SQL_FUNCTION_MAP.put("toDayOfMonth", "");
        SQL_FUNCTION_MAP.put("toDayOfWeek", "");
        SQL_FUNCTION_MAP.put("toHour", "");
        SQL_FUNCTION_MAP.put("toMinute", "");
        SQL_FUNCTION_MAP.put("toSecond", "");
        SQL_FUNCTION_MAP.put("toUnixTimestamp", "");
        SQL_FUNCTION_MAP.put("toStartOfYear", "");
        SQL_FUNCTION_MAP.put("toStartOfISOYear", "");
        SQL_FUNCTION_MAP.put("toStartOfQuarter", "");
        SQL_FUNCTION_MAP.put("toStartOfMonth", "");
        SQL_FUNCTION_MAP.put("toMonday", "");
        SQL_FUNCTION_MAP.put("toStartOfWeek", "");
        SQL_FUNCTION_MAP.put("toStartOfDay", "");
        SQL_FUNCTION_MAP.put("toStartOfHour", "");
        SQL_FUNCTION_MAP.put("toStartOfMinute", "");
        SQL_FUNCTION_MAP.put("toStartOfSecond", "");
        SQL_FUNCTION_MAP.put("toStartOfFiveMinute", "");
        SQL_FUNCTION_MAP.put("toStartOfTenMinutes", "");
        SQL_FUNCTION_MAP.put("toStartOfFifteenMinutes", "");
        SQL_FUNCTION_MAP.put("toStartOfInterval", "");
        SQL_FUNCTION_MAP.put("toTime", "");
        SQL_FUNCTION_MAP.put("toISOYear", "");
        SQL_FUNCTION_MAP.put("toISOWeek", "");
        SQL_FUNCTION_MAP.put("toWeek", "");
        SQL_FUNCTION_MAP.put("toYearWeek", "");
        SQL_FUNCTION_MAP.put("date_trunc", "");
        SQL_FUNCTION_MAP.put("date_diff", "");
        SQL_FUNCTION_MAP.put("yesterday", "");
        SQL_FUNCTION_MAP.put("today", "");
        SQL_FUNCTION_MAP.put("timeSlot", "");
        SQL_FUNCTION_MAP.put("toYYYYMM", "");
        SQL_FUNCTION_MAP.put("toYYYYMMDD", "");
        SQL_FUNCTION_MAP.put("toYYYYMMDDhhmmss", "");
        SQL_FUNCTION_MAP.put("addYears", "");
        SQL_FUNCTION_MAP.put("addMonths", "");
        SQL_FUNCTION_MAP.put("addWeeks", "");
        SQL_FUNCTION_MAP.put("addDays", "");
        SQL_FUNCTION_MAP.put("addHours", "");
        SQL_FUNCTION_MAP.put("addMinutes", "");
        SQL_FUNCTION_MAP.put("addSeconds", "");
        SQL_FUNCTION_MAP.put("addQuarters", "");
        SQL_FUNCTION_MAP.put("subtractYears", "");
        SQL_FUNCTION_MAP.put("subtractMonths", "");
        SQL_FUNCTION_MAP.put("subtractWeeks", "");
        SQL_FUNCTION_MAP.put("subtractDays", "");
        SQL_FUNCTION_MAP.put("subtractours", "");
        SQL_FUNCTION_MAP.put("subtractMinutes", "");
        SQL_FUNCTION_MAP.put("subtractSeconds", "");
        SQL_FUNCTION_MAP.put("subtractQuarters", "");
        SQL_FUNCTION_MAP.put("formatDateTime", "");
        SQL_FUNCTION_MAP.put("timestamp_add", "");
        SQL_FUNCTION_MAP.put("timestamp_sub", "");
        SQL_FUNCTION_MAP.put("visitParamHas", "");
        SQL_FUNCTION_MAP.put("visitParamExtractUInt", "");
        SQL_FUNCTION_MAP.put("visitParamExtractInt", "");
        SQL_FUNCTION_MAP.put("visitParamExtractFloat", "");
        SQL_FUNCTION_MAP.put("visitParamExtractBool", "");
        SQL_FUNCTION_MAP.put("visitParamExtractRaw", "");
        SQL_FUNCTION_MAP.put("visitParamExtractString", "");
        SQL_FUNCTION_MAP.put("JSONHas", "");
        SQL_FUNCTION_MAP.put("JSONLength", "");
        SQL_FUNCTION_MAP.put("JSONType", "");
        SQL_FUNCTION_MAP.put("JSONExtractUInt", "");
        SQL_FUNCTION_MAP.put("JSONExtractInt", "");
        SQL_FUNCTION_MAP.put("JSONExtractFloat", "");
        SQL_FUNCTION_MAP.put("JSONExtractBool", "");
        SQL_FUNCTION_MAP.put("JSONExtractString", "");
        SQL_FUNCTION_MAP.put("JSONExtract", "");
        SQL_FUNCTION_MAP.put("JSONExtractKeysAndValues", "");
        SQL_FUNCTION_MAP.put("JSONExtractRaw", "");
        SQL_FUNCTION_MAP.put("toJSONString", "");
        SQL_FUNCTION_MAP.put("toInt8", "");
        SQL_FUNCTION_MAP.put("toInt16", "");
        SQL_FUNCTION_MAP.put("toInt32", "");
        SQL_FUNCTION_MAP.put("toInt64", "");
        SQL_FUNCTION_MAP.put("toInt8OrZero", "");
        SQL_FUNCTION_MAP.put("toInt16OrZero", "");
        SQL_FUNCTION_MAP.put("toInt32OrZero", "");
        SQL_FUNCTION_MAP.put("toInt64OrZero", "");
        SQL_FUNCTION_MAP.put("toInt8OrNull", "");
        SQL_FUNCTION_MAP.put("toInt16OrNull", "");
        SQL_FUNCTION_MAP.put("toInt32OrNull", "");
        SQL_FUNCTION_MAP.put("toInt64OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt8", "");
        SQL_FUNCTION_MAP.put("toUInt16", "");
        SQL_FUNCTION_MAP.put("toUInt32", "");
        SQL_FUNCTION_MAP.put("toUInt64", "");
        SQL_FUNCTION_MAP.put("toUInt8OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt16OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt32OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt64OrZero", "");
        SQL_FUNCTION_MAP.put("toUInt8OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt16OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt32OrNull", "");
        SQL_FUNCTION_MAP.put("toUInt64OrNull", "");
        SQL_FUNCTION_MAP.put("toFloat32", "");
        SQL_FUNCTION_MAP.put("toFloat64", "");
        SQL_FUNCTION_MAP.put("toFloat32OrZero", "");
        SQL_FUNCTION_MAP.put("toFloat64OrZero", "");
        SQL_FUNCTION_MAP.put("toFloat32OrNull", "");
        SQL_FUNCTION_MAP.put("toFloat64OrNull", "");
        SQL_FUNCTION_MAP.put("toDate", "");
        SQL_FUNCTION_MAP.put("toDateOrZero", "");
        SQL_FUNCTION_MAP.put("toDateOrNull", "");
        SQL_FUNCTION_MAP.put("toDateTimeOrZero", "");
        SQL_FUNCTION_MAP.put("toDateTimeOrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal32", "");
        SQL_FUNCTION_MAP.put("toFixedString", "");
        SQL_FUNCTION_MAP.put("toStringCutToZero", "");
        SQL_FUNCTION_MAP.put("toDecimal256", "");
        SQL_FUNCTION_MAP.put("toDecimal32OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal64OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal128OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal256OrNull", "");
        SQL_FUNCTION_MAP.put("toDecimal32OrZero", "");
        SQL_FUNCTION_MAP.put("toDecimal64OrZero", "");
        SQL_FUNCTION_MAP.put("toDecimal128OrZero", "");
        SQL_FUNCTION_MAP.put("toDecimal256OrZero", "");
        SQL_FUNCTION_MAP.put("toIntervalSecond", "");
        SQL_FUNCTION_MAP.put("toIntervalMinute", "");
        SQL_FUNCTION_MAP.put("toIntervalHour", "");
        SQL_FUNCTION_MAP.put("toIntervalDay", "");
        SQL_FUNCTION_MAP.put("toIntervalWeek", "");
        SQL_FUNCTION_MAP.put("toIntervalMonth", "");
        SQL_FUNCTION_MAP.put("toIntervalQuarter", "");
        SQL_FUNCTION_MAP.put("toIntervalYear", "");
        SQL_FUNCTION_MAP.put("parseDateTimeBestEffort", "");
        SQL_FUNCTION_MAP.put("parseDateTimeBestEffortOrNull", "");
        SQL_FUNCTION_MAP.put("parseDateTimeBestEffortOrZero", "");
        SQL_FUNCTION_MAP.put("toLowCardinality", "");
        SQL_FUNCTION_MAP.put("halfMD5", "");
        SQL_FUNCTION_MAP.put("MD5", "");
        SQL_FUNCTION_MAP.put("IPv4NumToString", "");
        SQL_FUNCTION_MAP.put("IPv4StringToNum", "");
        SQL_FUNCTION_MAP.put("IPv6NumToString", "");
        SQL_FUNCTION_MAP.put("IPv6StringToNum", "");
        SQL_FUNCTION_MAP.put("IPv4ToIPv6", "");
        SQL_FUNCTION_MAP.put("cutIPv6", "");
        SQL_FUNCTION_MAP.put("toIPv4", "");
        SQL_FUNCTION_MAP.put("toIPv6", "");
        SQL_FUNCTION_MAP.put("isIPAddressInRange", "");
        SQL_FUNCTION_MAP.put("isNull", "");
        SQL_FUNCTION_MAP.put("isNotNull", "");
        SQL_FUNCTION_MAP.put("ifNull", "");
        SQL_FUNCTION_MAP.put("assumeNotNull", "");
        SQL_FUNCTION_MAP.put("toNullable", "");
        SQL_FUNCTION_MAP.put("generateUUIDv4", "");
        SQL_FUNCTION_MAP.put("toUUID", "");
        SQL_FUNCTION_MAP.put("hostName", "");
        SQL_FUNCTION_MAP.put("getMacro", "");
        SQL_FUNCTION_MAP.put("FQDN", "");
        SQL_FUNCTION_MAP.put("basename", "");
        SQL_FUNCTION_MAP.put("currentUser", "");
        SQL_FUNCTION_MAP.put("version", "");
        SQL_FUNCTION_MAP.put("uptime", "");
        SQL_FUNCTION_MAP.put("least", "");
        SQL_FUNCTION_MAP.put("greatest", "");
        SQL_FUNCTION_MAP.put("plus", "");
        SQL_FUNCTION_MAP.put("minus", "");
        SQL_FUNCTION_MAP.put("multiply", "");
        SQL_FUNCTION_MAP.put("divide", "");
        SQL_FUNCTION_MAP.put("intDiv", "");
        SQL_FUNCTION_MAP.put("intDivOrZero", "");
        SQL_FUNCTION_MAP.put("modulo", "");
        SQL_FUNCTION_MAP.put("moduloOrZero", "");
        SQL_FUNCTION_MAP.put("negate", "");
        SQL_FUNCTION_MAP.put("gcd", "");
        SQL_FUNCTION_MAP.put("lcm", "");
        SQL_FUNCTION_MAP.put("e", "");
        SQL_FUNCTION_MAP.put("pi", "");
        SQL_FUNCTION_MAP.put("exp2", "");
        SQL_FUNCTION_MAP.put("exp10", "");
        SQL_FUNCTION_MAP.put("cbrt", "");
        SQL_FUNCTION_MAP.put("lgamma", "");
        SQL_FUNCTION_MAP.put("tgamma", "");
        SQL_FUNCTION_MAP.put("intExp2", "");
        SQL_FUNCTION_MAP.put("intExp10", "");
        SQL_FUNCTION_MAP.put("cosh", "");
        SQL_FUNCTION_MAP.put("sinh", "");
        SQL_FUNCTION_MAP.put("asinh", "");
        SQL_FUNCTION_MAP.put("atanh", "");
        SQL_FUNCTION_MAP.put("atan2", "");
        SQL_FUNCTION_MAP.put("hypot", "");
        SQL_FUNCTION_MAP.put("log1p", "");
        SQL_FUNCTION_MAP.put("trunc", "");
        SQL_FUNCTION_MAP.put("roundToExp2", "");
        SQL_FUNCTION_MAP.put("roundDuration", "");
        SQL_FUNCTION_MAP.put("roundAge", "");
        SQL_FUNCTION_MAP.put("roundDown", "");
        SQL_FUNCTION_MAP.put("bitAnd", "");
        SQL_FUNCTION_MAP.put("bitOr", "");
        SQL_FUNCTION_MAP.put("obj_description", "");
        SQL_FUNCTION_MAP.put("col_description", "");
        SQL_FUNCTION_MAP.put("len", "");
        SQL_FUNCTION_MAP.put("datalength", "");
        LAST_ID = System.currentTimeMillis();
    }

    public static abstract class SimpleCallback<T>
    implements Callback<T> {
        @Override
        public T newId(RequestMethod method, String database, String schema, String datasource, String table) {
            Long id = System.currentTimeMillis();
            if (id <= LAST_ID) {
                id = LAST_ID + 1L;
            }
            LAST_ID = id;
            return (T)id;
        }

        @Override
        public String getIdKey(String database, String schema, String datasource, String table) {
            return JSONObject.KEY_ID;
        }

        @Override
        public String getUserIdKey(String database, String schema, String datasource, String table) {
            return JSONObject.KEY_USER_ID;
        }

        @Override
        public void onMissingKey4Combine(String name, com.alibaba.fastjson.JSONObject request, String combine, String item, String key) throws Exception {
            throw new IllegalArgumentException(name + ":{} \u91cc\u7684 @combine:value \u4e2d\u7684value\u91cc " + item + " \u5bf9\u5e94\u7684\u6761\u4ef6 " + key + ":value \u4e2d value \u4e0d\u80fd\u4e3a null\uff01");
        }
    }

    public static interface Callback<T>
    extends IdCallback<T> {
        public SQLConfig getSQLConfig(RequestMethod var1, String var2, String var3, String var4, String var5);

        public void onMissingKey4Combine(String var1, com.alibaba.fastjson.JSONObject var2, String var3, String var4, String var5) throws Exception;
    }

    public static interface IdCallback<T> {
        public T newId(RequestMethod var1, String var2, String var3, String var4, String var5);

        public String getIdKey(String var1, String var2, String var3, String var4);

        public String getUserIdKey(String var1, String var2, String var3, String var4);
    }
}

