/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSONObject;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractFunctionParser;
import apijson.orm.AbstractParser;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.Entry;
import apijson.orm.JSONRequest;
import apijson.orm.Join;
import apijson.orm.ObjectParser;
import apijson.orm.Pair;
import apijson.orm.SQLConfig;
import apijson.orm.Subquery;
import apijson.orm.exception.ConflictException;
import apijson.orm.exception.NotExistException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.UnsupportedDataTypeException;

public abstract class AbstractObjectParser
implements ObjectParser {
    private static final String TAG = "AbstractObjectParser";
    @NotNull
    protected AbstractParser<?> parser;
    protected com.alibaba.fastjson.JSONObject request;
    protected String parentPath;
    protected SQLConfig arrayConfig;
    protected boolean isSubquery;
    protected final int type;
    protected final String arrayTable;
    protected final List<Join> joinList;
    protected final boolean isTable;
    protected final boolean isArrayMainTable;
    protected final boolean tri;
    protected final boolean drop;
    protected int position;
    private boolean invalidate = false;
    private boolean breakParse = false;
    protected String name;
    protected String table;
    protected String alias;
    protected boolean isReuse;
    protected String path;
    protected com.alibaba.fastjson.JSONObject response;
    protected com.alibaba.fastjson.JSONObject sqlRequest;
    protected com.alibaba.fastjson.JSONObject sqlReponse;
    protected Map<String, Object> customMap;
    protected Map<String, Map<String, String>> functionMap;
    protected Map<String, com.alibaba.fastjson.JSONObject> childMap;
    private int objectCount;
    private int arrayCount;
    protected SQLConfig sqlConfig = null;
    protected RequestMethod method;

    public AbstractObjectParser setParser(AbstractParser<?> parser) {
        this.parser = parser;
        return this;
    }

    public AbstractObjectParser(@NotNull com.alibaba.fastjson.JSONObject request, String parentPath, SQLConfig arrayConfig, boolean isSubquery, boolean isTable, boolean isArrayMainTable) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("AbstractObjectParser.ObjectParser  request == null!!!");
        }
        this.request = request;
        this.parentPath = parentPath;
        this.arrayConfig = arrayConfig;
        this.isSubquery = isSubquery;
        this.type = arrayConfig == null ? 0 : arrayConfig.getType();
        this.arrayTable = arrayConfig == null ? null : arrayConfig.getTable();
        this.joinList = arrayConfig == null ? null : arrayConfig.getJoinList();
        this.isTable = isTable;
        this.isArrayMainTable = isArrayMainTable;
        this.objectCount = 0;
        this.arrayCount = 0;
        boolean isEmpty = request.isEmpty();
        if (isEmpty) {
            this.tri = false;
            this.drop = false;
        } else {
            this.tri = request.getBooleanValue("@try");
            this.drop = request.getBooleanValue("@drop");
            request.remove((Object)"@try");
            request.remove((Object)"@drop");
        }
    }

    @Override
    public String getParentPath() {
        return this.parentPath;
    }

    @Override
    public AbstractObjectParser setParentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public AbstractObjectParser setPosition(int position) {
        this.position = position;
        return this;
    }

    public void invalidate() {
        this.invalidate = true;
    }

    public boolean isInvalidate() {
        return this.invalidate;
    }

    public void breakParse() {
        this.breakParse = true;
    }

    public boolean isBreakParse() {
        return this.breakParse || this.isInvalidate();
    }

    @Override
    public AbstractObjectParser parse(String name, boolean isReuse) throws Exception {
        if (!this.isInvalidate()) {
            this.isReuse = isReuse;
            this.name = name;
            this.path = AbstractParser.getAbsPath(this.parentPath, name);
            Entry<String, String> tentry = Pair.parseEntry(name, true);
            this.table = tentry.getKey();
            this.alias = tentry.getValue();
            Log.d(TAG, "AbstractObjectParser  parentPath = " + this.parentPath + "; name = " + name + "; table = " + this.table + "; alias = " + this.alias);
            Log.d(TAG, "AbstractObjectParser  type = " + this.type + "; isTable = " + this.isTable + "; isArrayMainTable = " + this.isArrayMainTable);
            Log.d(TAG, "AbstractObjectParser  isEmpty = " + this.request.isEmpty() + "; tri = " + this.tri + "; drop = " + this.drop);
            this.breakParse = false;
            this.response = new com.alibaba.fastjson.JSONObject(true);
            this.sqlReponse = null;
            if (!isReuse) {
                LinkedHashSet set;
                this.sqlRequest = new com.alibaba.fastjson.JSONObject(true);
                this.customMap = null;
                this.functionMap = null;
                this.childMap = null;
                LinkedHashSet linkedHashSet = set = this.request.isEmpty() ? null : new LinkedHashSet(this.request.entrySet());
                if (set != null && !set.isEmpty()) {
                    if (this.isTable) {
                        this.customMap = new LinkedHashMap<String, Object>();
                        this.childMap = new LinkedHashMap<String, com.alibaba.fastjson.JSONObject>();
                    }
                    this.functionMap = new LinkedHashMap<String, Map<String, String>>();
                    ArrayList<String> whereList = null;
                    if (this.method == RequestMethod.PUT) {
                        String[] combine = StringUtil.split(this.request.getString("@combine"));
                        if (combine != null) {
                            for (int i = 0; i < combine.length; ++i) {
                                String w = combine[i];
                                if (w == null || !w.startsWith("&") && !w.startsWith("|") && !w.startsWith("!")) continue;
                                combine[i] = w.substring(1);
                            }
                        }
                        whereList = new ArrayList<String>(Arrays.asList(combine != null ? combine : new String[]{}));
                        whereList.add(apijson.JSONRequest.KEY_ID);
                        whereList.add(apijson.JSONRequest.KEY_ID_IN);
                    }
                    int index = 0;
                    for (Map.Entry entry : set) {
                        if (this.isBreakParse()) break;
                        Object value = entry.getValue();
                        if (value == null) continue;
                        String key = (String)entry.getKey();
                        try {
                            if (key.startsWith("@") || key.endsWith("@")) {
                                if (this.onParse(key, value)) continue;
                                this.invalidate();
                                continue;
                            }
                            if (value instanceof com.alibaba.fastjson.JSONObject) {
                                if (this.childMap != null) {
                                    this.childMap.put(key, (com.alibaba.fastjson.JSONObject)value);
                                    continue;
                                }
                                this.response.put(key, (Object)this.onChildParse(index, key, (com.alibaba.fastjson.JSONObject)value));
                                ++index;
                                continue;
                            }
                            if ((this.method == RequestMethod.POST || this.method == RequestMethod.PUT) && value instanceof JSONArray && JSONRequest.isTableArray(key)) {
                                this.onTableArrayParse(key, (JSONArray)value);
                                continue;
                            }
                            if (this.method == RequestMethod.PUT && value instanceof JSONArray && (whereList == null || !whereList.contains(key)) && StringUtil.isName(key.replaceFirst("[+-]$", ""))) {
                                this.onPUTArrayParse(key, (JSONArray)value);
                                continue;
                            }
                            if (this.onParse(key, value)) continue;
                            this.invalidate();
                        }
                        catch (Exception e) {
                            if (!this.tri) {
                                if (Log.DEBUG && this.sqlConfig != null && !e.getMessage().contains("---|-----APIJSON SYSTEM INFO-----|---")) {
                                    try {
                                        String db = this.sqlConfig.getDatabase();
                                        if (db == null) {
                                            db = this.sqlConfig.isMySQL() ? "MYSQL" : (this.sqlConfig.isPostgreSQL() ? "POSTGRESQL" : (this.sqlConfig.isSQLServer() ? "SQLSERVER" : (this.sqlConfig.isOracle() ? "ORACLE" : (this.sqlConfig.isDb2() ? "DB2" : (this.sqlConfig.isClickHouse() ? "CLICKHOUSE" : AbstractSQLConfig.DEFAULT_DATABASE)))));
                                        }
                                        Class<?> clazz = e.getClass();
                                        e = (Exception)clazz.getConstructor(String.class).newInstance(e.getMessage() + "       " + "---|-----APIJSON SYSTEM INFO-----|---" + "       \n **\u73af\u5883\u4fe1\u606f**  \n \u7cfb\u7edf: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " \n \u6570\u636e\u5e93: " + db + " " + this.sqlConfig.getDBVersion() + " \n JDK: " + System.getProperty("java.version") + " " + System.getProperty("os.arch") + " \n APIJSON: " + "4.9.0");
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                throw e;
                            }
                            this.invalidate();
                        }
                    }
                }
                if (this.isTable) {
                    if (this.parser.getGlobleDatabase() != null && this.sqlRequest.get((Object)"@database") == null) {
                        this.sqlRequest.put("@database", (Object)this.parser.getGlobleDatabase());
                    }
                    if (this.parser.getGlobleSchema() != null && this.sqlRequest.get((Object)"@schema") == null) {
                        this.sqlRequest.put("@schema", (Object)this.parser.getGlobleSchema());
                    }
                    if (this.parser.getGlobleDatasource() != null && this.sqlRequest.get((Object)"@datasource") == null) {
                        this.sqlRequest.put("@datasource", (Object)this.parser.getGlobleDatasource());
                    }
                    if (!this.isSubquery) {
                        if (this.parser.getGlobleExplain() != null && this.sqlRequest.get((Object)"@explain") == null) {
                            this.sqlRequest.put("@explain", (Object)this.parser.getGlobleExplain());
                        }
                        if (this.parser.getGlobleCache() != null && this.sqlRequest.get((Object)"@cache") == null) {
                            this.sqlRequest.put("@cache", (Object)this.parser.getGlobleCache());
                        }
                    }
                }
            }
            if (this.isTable) {
                this.onFunctionResponse("-");
            }
        }
        if (this.isInvalidate()) {
            this.recycle();
            return null;
        }
        return this;
    }

    @Override
    public boolean onParse(@NotNull String key, @NotNull Object value) throws Exception {
        if (key.endsWith("@")) {
            String replaceKey;
            if (value instanceof com.alibaba.fastjson.JSONObject) {
                com.alibaba.fastjson.JSONObject arrObj;
                com.alibaba.fastjson.JSONObject obj;
                replaceKey = key.substring(0, key.length() - 1);
                com.alibaba.fastjson.JSONObject subquery = (com.alibaba.fastjson.JSONObject)value;
                String range = subquery.getString("range");
                if (range != null && !"ALL".equals(range) && !"ANY".equals(range)) {
                    throw new IllegalArgumentException("\u5b50\u67e5\u8be2 " + this.path + "/" + key + ":{ range:value } \u4e2d value \u53ea\u80fd\u4e3a [" + "ALL" + ", " + "ANY" + "] \u4e2d\u7684\u4e00\u4e2a\uff01");
                }
                JSONArray arr = this.parser.onArrayParse(subquery, this.path, key, true);
                com.alibaba.fastjson.JSONObject jSONObject = obj = arr == null || arr.isEmpty() ? null : arr.getJSONObject(0);
                if (obj == null) {
                    throw new Exception("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0c\u89e3\u6790\u5b50\u67e5\u8be2 " + this.path + "/" + key + ":{ } \u4e3a Subquery \u5bf9\u8c61\u5931\u8d25\uff01");
                }
                String from = subquery.getString("from");
                com.alibaba.fastjson.JSONObject jSONObject2 = arrObj = from == null ? null : obj.getJSONObject(from);
                if (arrObj == null) {
                    throw new IllegalArgumentException("\u5b50\u67e5\u8be2 " + this.path + "/" + key + ":{ from:value } \u4e2d value \u5bf9\u5e94\u7684\u4e3b\u8868\u5bf9\u8c61 " + from + ":{} \u4e0d\u5b58\u5728\uff01");
                }
                SQLConfig cfg = (SQLConfig)arrObj.get((Object)"config");
                if (cfg == null) {
                    throw new NotExistException("AbstractObjectParser.onParse  cfg == null");
                }
                Subquery s = new Subquery();
                s.setPath(this.path);
                s.setOriginKey(key);
                s.setOriginValue(subquery);
                s.setFrom(from);
                s.setRange(range);
                s.setKey(replaceKey);
                s.setConfig(cfg);
                key = replaceKey;
                value = s;
                this.parser.putQueryResult(AbstractParser.getAbsPath(this.path, key), s);
            } else if (value instanceof String) {
                replaceKey = key.substring(0, key.length() - 1);
                String targetPath = AbstractParser.getValuePath(this.type == 1 ? this.path : this.parentPath, new String((String)value));
                Object target = this.onReferenceParse(targetPath);
                Log.i(TAG, "onParse targetPath = " + targetPath + "; target = " + target);
                if (target == null) {
                    Log.d(TAG, "onParse  target == null  >>  return true;");
                    return true;
                }
                if (target instanceof Map && (this.isTable || !targetPath.endsWith("[]/info"))) {
                    Log.d(TAG, "onParse  target instanceof Map  >>  return false;");
                    return false;
                }
                if (targetPath.equals(target)) {
                    Log.d(TAG, "onParse  targetPath.equals(target)  >>");
                    if (this.isTable && (!key.startsWith("@") || JSONRequest.TABLE_KEY_LIST.contains(key))) {
                        Log.e(TAG, "onParse  isTable && (key.startsWith(@) == false || JSONRequest.TABLE_KEY_LIST.contains(key)) >>  return null;");
                        return false;
                    }
                    Log.d(TAG, "onParse  isTable(table) == false >> return true;");
                    return true;
                }
                Log.i(TAG, "onParse    >>  key = replaceKey; value = target;");
                key = replaceKey;
                value = target;
                Log.d(TAG, "onParse key = " + key + "; value = " + value);
            } else {
                throw new IllegalArgumentException(this.path + "/" + key + ":value \u4e2d value \u5fc5\u987b\u4e3a \u4f9d\u8d56\u8def\u5f84String \u6216 SQL\u5b50\u67e5\u8be2JSONObject \uff01");
            }
        }
        if (key.endsWith("()")) {
            String type;
            if (!(value instanceof String)) {
                throw new IllegalArgumentException(this.path + "/" + key + ":value \u4e2d value \u5fc5\u987b\u4e3a\u51fd\u6570String\uff01");
            }
            String k = key.substring(0, key.length() - 2);
            boolean isMinus = k.endsWith("-");
            if (isMinus) {
                type = "-";
                k = k.substring(0, k.length() - 1);
                if (!this.isTable) {
                    this.parseFunction(k, (String)value, this.parentPath, this.name, this.request);
                }
            } else if (k.endsWith("+")) {
                type = "+";
                k = k.substring(0, k.length() - 1);
            } else {
                type = "0";
            }
            if (!isMinus || this.isTable) {
                Map<String, String> map = this.functionMap.get(type);
                if (map == null) {
                    map = new LinkedHashMap<String, String>();
                }
                map.put(k, (String)value);
                this.functionMap.put(type, map);
            }
        } else if (this.isTable && key.startsWith("@") && !JSONRequest.TABLE_KEY_LIST.contains(key)) {
            this.customMap.put(key, value);
        } else {
            this.sqlRequest.put(key, value);
        }
        return true;
    }

    @Override
    public JSON onChildParse(int index, String key, com.alibaba.fastjson.JSONObject value) throws Exception {
        boolean isEmpty;
        JSONArray child;
        boolean isMain;
        boolean isFirst = index <= 0;
        boolean bl = isMain = isFirst && this.type == 1;
        if (JSONObject.isArrayKey(key)) {
            if (isMain) {
                throw new IllegalArgumentException(this.parentPath + "/" + key + ":{} \u4e0d\u5408\u6cd5\uff01\u6570\u7ec4 []:{} \u4e2d\u7b2c\u4e00\u4e2a key:{} \u5fc5\u987b\u662f\u4e3b\u8868 TableKey:{} \uff01\u4e0d\u80fd\u4e3a arrayKey[]:{} \uff01");
            }
            if (this.arrayConfig == null || this.arrayConfig.getPosition() == 0) {
                ++this.arrayCount;
                int maxArrayCount = this.parser.getMaxArrayCount();
                if (this.arrayCount > maxArrayCount) {
                    throw new IllegalArgumentException(this.path + " \u5185\u622a\u81f3 " + key + ":{} \u65f6\u6570\u7ec4\u5bf9\u8c61 key[]:{} \u7684\u6570\u91cf\u8fbe\u5230 " + this.arrayCount + " \u5df2\u8d85\u9650\uff0c\u5fc5\u987b\u5728 0-" + maxArrayCount + " \u5185 !");
                }
            }
            isEmpty = (child = this.parser.onArrayParse(value, this.path, key, this.isSubquery)) == null || child.isEmpty();
        } else {
            boolean isTableKey = JSONRequest.isTableKey(Pair.parseEntry(key, true).getKey());
            if (this.type == 1 && !isTableKey) {
                throw new IllegalArgumentException(this.parentPath + "/" + key + ":{} \u4e0d\u5408\u6cd5\uff01\u6570\u7ec4 []:{} \u4e2d\u6bcf\u4e2a key:{} \u90fd\u5fc5\u987b\u662f\u8868 TableKey:{} \u6216 \u6570\u7ec4 arrayKey[]:{} \uff01");
            }
            if (this.arrayConfig == null || this.arrayConfig.getPosition() == 0) {
                ++this.objectCount;
                int maxObjectCount = this.parser.getMaxObjectCount();
                if (this.objectCount > maxObjectCount) {
                    throw new IllegalArgumentException(this.path + " \u5185\u622a\u81f3 " + key + ":{} \u65f6\u5bf9\u8c61 key:{} \u7684\u6570\u91cf\u8fbe\u5230 " + this.objectCount + " \u5df2\u8d85\u9650\uff0c\u5fc5\u987b\u5728 0-" + maxObjectCount + " \u5185 !");
                }
            }
            child = this.parser.onObjectParse(value, this.path, key, isMain ? this.arrayConfig.setType(2) : null, this.isSubquery);
            boolean bl2 = isEmpty = child == null || ((com.alibaba.fastjson.JSONObject)child).isEmpty();
            if (isFirst && isEmpty) {
                this.invalidate();
            }
        }
        Log.i(TAG, "onChildParse  ObjectParser.onParse  key = " + key + "; child = " + child);
        return isEmpty ? null : child;
    }

    @Override
    public void onPUTArrayParse(@NotNull String key, @NotNull JSONArray array) throws Exception {
        JSONArray targetArray;
        if (!this.isTable || array.isEmpty()) {
            this.sqlRequest.put(key, (Object)array);
            Log.e(TAG, "onPUTArrayParse  isTable == false || array == null || array.isEmpty() >> return;");
            return;
        }
        int putType = 0;
        if (key.endsWith("+")) {
            putType = 1;
        } else if (key.endsWith("-")) {
            putType = 2;
        }
        String realKey = AbstractSQLConfig.getRealKey(this.method, key, false, false);
        com.alibaba.fastjson.JSONObject rq = new com.alibaba.fastjson.JSONObject();
        rq.put(JSONRequest.KEY_ID, this.request.get((Object)JSONRequest.KEY_ID));
        rq.put("@column", (Object)realKey);
        com.alibaba.fastjson.JSONObject rp = this.parseResponse(RequestMethod.GET, this.table, null, rq, null, false);
        JSONArray jSONArray = targetArray = rp == null ? null : rp.getJSONArray(realKey);
        if (targetArray == null) {
            targetArray = new JSONArray();
        }
        for (Object obj : array) {
            if (obj == null) continue;
            if (putType == 1) {
                if (targetArray.contains(obj)) {
                    throw new ConflictException("PUT " + this.path + ", " + realKey + ":" + obj + " \u5df2\u5b58\u5728\uff01");
                }
                targetArray.add(obj);
                continue;
            }
            if (putType != 2) continue;
            if (!targetArray.contains(obj)) {
                throw new NullPointerException("PUT " + this.path + ", " + realKey + ":" + obj + " \u4e0d\u5b58\u5728\uff01");
            }
            targetArray.remove(obj);
        }
        this.sqlRequest.put(realKey, (Object)targetArray);
    }

    @Override
    public void onTableArrayParse(String key, JSONArray value) throws Exception {
        String childKey = key.substring(0, key.length() - "[]".length());
        JSONArray valueArray = value;
        int allCount = 0;
        JSONArray ids = new JSONArray();
        int version = this.parser.getVersion();
        int maxUpdateCount = this.parser.getMaxUpdateCount();
        String idKey = this.parser.createSQLConfig().getIdKey();
        boolean isNeedVerifyContent = this.parser.isNeedVerifyContent();
        for (int i = 0; i < valueArray.size(); ++i) {
            com.alibaba.fastjson.JSONObject item;
            try {
                item = valueArray.getJSONObject(i);
            }
            catch (Exception e) {
                throw new UnsupportedDataTypeException("\u6279\u91cf\u65b0\u589e/\u4fee\u6539\u5931\u8d25\uff01" + key + "/" + i + ":value \u4e2dvalue\u4e0d\u5408\u6cd5\uff01\u7c7b\u578b\u5fc5\u987b\u662f OBJECT \uff0c\u7ed3\u6784\u4e3a {} !");
            }
            JSONRequest req = new JSONRequest(childKey, item);
            com.alibaba.fastjson.JSONObject result = (com.alibaba.fastjson.JSONObject)this.onChildParse(0, "" + i, !isNeedVerifyContent ? req : this.parser.parseCorrectRequest(this.method, childKey, version, "", req, maxUpdateCount, this.parser));
            result = result.getJSONObject(childKey);
            boolean success = JSONResponse.isSuccess(result);
            int count = result == null ? null : Integer.valueOf(result.getIntValue("count"));
            if (!success || count != 1) {
                throw new ServerException("\u6279\u91cf\u65b0\u589e/\u4fee\u6539\u5931\u8d25\uff01" + key + "/" + i + "\uff1a" + (success ? "\u6210\u529f\u4f46 count != 1 \uff01" : (result == null ? "null" : result.getString(JSONResponse.KEY_MSG))));
            }
            allCount += count;
            ids.add(result.get((Object)idKey));
        }
        com.alibaba.fastjson.JSONObject allResult = AbstractParser.newSuccessResult();
        allResult.put("count", (Object)allCount);
        allResult.put(idKey + "[]", (Object)ids);
        this.response.put(childKey, (Object)allResult);
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseResponse(RequestMethod method, String table, String alias, com.alibaba.fastjson.JSONObject request, List<Join> joinList, boolean isProcedure) throws Exception {
        SQLConfig config = this.newSQLConfig(method, table, alias, request, joinList, isProcedure);
        return this.parseResponse(config, isProcedure);
    }

    @Override
    public com.alibaba.fastjson.JSONObject parseResponse(SQLConfig config, boolean isProcedure) throws Exception {
        if (this.parser.getSQLExecutor() == null) {
            this.parser.createSQLExecutor();
        }
        return this.parser.getSQLExecutor().execute(config, isProcedure);
    }

    @Override
    public SQLConfig newSQLConfig(boolean isProcedure) throws Exception {
        return this.newSQLConfig(this.method, this.table, this.alias, this.sqlRequest, this.joinList, isProcedure);
    }

    @Override
    public AbstractObjectParser setSQLConfig() throws Exception {
        return this.setSQLConfig(RequestMethod.isQueryMethod(this.method) ? 1 : 0, 0, 0);
    }

    @Override
    public AbstractObjectParser setSQLConfig(int count, int page, int position) throws Exception {
        if (!this.isTable || this.isReuse) {
            return this.setPosition(position);
        }
        if (this.sqlConfig == null) {
            try {
                this.sqlConfig = this.newSQLConfig(false);
            }
            catch (NotExistException e) {
                e.printStackTrace();
                return this;
            }
        }
        this.sqlConfig.setCount(this.sqlConfig.getCount() <= 0 ? count : this.sqlConfig.getCount()).setPage(page).setPosition(position);
        this.parser.onVerifyRole(this.sqlConfig);
        return this;
    }

    @Override
    public AbstractObjectParser executeSQL() throws Exception {
        if (!this.isTable) {
            this.sqlReponse = new com.alibaba.fastjson.JSONObject((Map)this.sqlRequest);
        } else {
            try {
                this.sqlReponse = this.onSQLExecute();
            }
            catch (NotExistException e) {
                this.sqlReponse = null;
            }
        }
        if (this.drop) {
            this.sqlReponse = null;
        }
        return this;
    }

    @Override
    public com.alibaba.fastjson.JSONObject response() throws Exception {
        if (this.sqlReponse == null || this.sqlReponse.isEmpty()) {
            if (this.isTable) {
                return null;
            }
        } else {
            this.response.putAll((Map)this.sqlReponse);
        }
        if (this.customMap != null) {
            this.response.putAll(this.customMap);
        }
        this.onFunctionResponse("0");
        this.onChildResponse();
        this.onFunctionResponse("+");
        this.onComplete();
        return this.response;
    }

    @Override
    public void onFunctionResponse(String type) throws Exception {
        Set<Map.Entry<String, String>> functionSet;
        Map<String, String> map = this.functionMap == null ? null : this.functionMap.get(type);
        Set<Map.Entry<String, String>> set = functionSet = map == null ? null : map.entrySet();
        if (functionSet != null && !functionSet.isEmpty()) {
            com.alibaba.fastjson.JSONObject json = "-".equals(type) ? this.request : this.response;
            for (Map.Entry<String, String> entry : functionSet) {
                this.parseFunction(entry.getKey(), entry.getValue(), this.parentPath, this.name, json);
            }
        }
    }

    public void parseFunction(String key, String value, String parentPath, String currentName, com.alibaba.fastjson.JSONObject currentObject) throws Exception {
        Object result;
        if (key.startsWith("@")) {
            AbstractFunctionParser.FunctionBean fb = AbstractFunctionParser.parseFunction(value, currentObject, true);
            SQLConfig config = this.newSQLConfig(true);
            config.setProcedure(fb.toFunctionCallString(true));
            result = this.parseResponse(config, true);
            key = key.substring(1);
        } else {
            result = this.parser.onFunctionParse(key, value, parentPath, currentName, currentObject);
        }
        if (result != null) {
            String k = AbstractSQLConfig.getRealKey(this.method, key, false, false);
            this.response.put(k, result);
            this.parser.putQueryResult(AbstractParser.getAbsPath(this.path, k), result);
        }
    }

    @Override
    public void onChildResponse() throws Exception {
        Set<Map.Entry<String, com.alibaba.fastjson.JSONObject>> set;
        Set<Map.Entry<String, com.alibaba.fastjson.JSONObject>> set2 = set = this.childMap == null ? null : this.childMap.entrySet();
        if (set != null) {
            int index = 0;
            for (Map.Entry<String, com.alibaba.fastjson.JSONObject> entry : set) {
                JSON child = entry == null ? null : this.onChildParse(index, entry.getKey(), entry.getValue());
                if (child == null || child instanceof com.alibaba.fastjson.JSONObject && ((com.alibaba.fastjson.JSONObject)child).isEmpty() || child instanceof JSONArray && ((JSONArray)child).isEmpty()) continue;
                this.response.put(entry.getKey(), (Object)child);
                ++index;
            }
        }
    }

    @Override
    public Object onReferenceParse(@NotNull String path) {
        return this.parser.getValueByPath(path);
    }

    @Override
    public com.alibaba.fastjson.JSONObject onSQLExecute() throws Exception {
        com.alibaba.fastjson.JSONObject result;
        int position = this.getPosition();
        if (this.isArrayMainTable && position > 0) {
            result = this.parser.getArrayMainCacheItem(this.parentPath.substring(0, this.parentPath.lastIndexOf("[]") + 2), position);
        } else {
            result = this.parser.executeSQL(this.sqlConfig, this.isSubquery);
            boolean isSimpleArray = false;
            List rawList = null;
            if (this.isArrayMainTable && position == 0 && result != null) {
                isSimpleArray = !(this.functionMap != null && !this.functionMap.isEmpty() || this.customMap != null && !this.customMap.isEmpty() || this.childMap != null && !this.childMap.isEmpty() || !this.table.equals(this.arrayTable));
                rawList = (List)result.remove((Object)"@RAW@LIST");
                if (rawList != null) {
                    String arrayPath = this.parentPath.substring(0, this.parentPath.lastIndexOf("[]") + 2);
                    if (!isSimpleArray) {
                        long startTime = System.currentTimeMillis();
                        for (int i = 1; i < rawList.size(); ++i) {
                            com.alibaba.fastjson.JSONObject obj = (com.alibaba.fastjson.JSONObject)rawList.get(i);
                            if (obj == null) continue;
                            this.parser.putQueryResult(arrayPath + "/" + i + "/" + this.name, obj);
                        }
                        long endTime = System.currentTimeMillis();
                        Log.e(TAG, "\n onSQLExecute <<<<<<<<<<<<<<<<<<<<<<<<<<<<\n for (int i = 1; i < list.size(); i++)  startTime = " + startTime + "; endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n >>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n ");
                    }
                    this.parser.putArrayMainCache(arrayPath, rawList);
                }
            }
            if (!this.isSubquery && result != null) {
                this.parser.putQueryResult(this.path, result);
                if (isSimpleArray && rawList != null) {
                    result.put("@RAW@LIST", (Object)rawList);
                }
            }
        }
        return result;
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void recycle() {
        if (this.tri) {
            this.request.put("@try", (Object)this.tri);
        }
        if (this.drop) {
            this.request.put("@drop", (Object)this.drop);
        }
        this.method = null;
        this.parentPath = null;
        this.arrayConfig = null;
        this.request = null;
        this.response = null;
        this.sqlRequest = null;
        this.sqlReponse = null;
        this.functionMap = null;
        this.customMap = null;
        this.childMap = null;
    }

    @Override
    public AbstractObjectParser setMethod(RequestMethod method) {
        if (this.method != method) {
            this.method = method;
            this.sqlConfig = null;
        }
        return this;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public boolean isTable() {
        return this.isTable;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public SQLConfig getArrayConfig() {
        return this.arrayConfig;
    }

    @Override
    public SQLConfig getSQLConfig() {
        return this.sqlConfig;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getResponse() {
        return this.response;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getSqlRequest() {
        return this.sqlRequest;
    }

    @Override
    public com.alibaba.fastjson.JSONObject getSqlReponse() {
        return this.sqlReponse;
    }

    @Override
    public Map<String, Object> getCustomMap() {
        return this.customMap;
    }

    @Override
    public Map<String, Map<String, String>> getFunctionMap() {
        return this.functionMap;
    }

    @Override
    public Map<String, com.alibaba.fastjson.JSONObject> getChildMap() {
        return this.childMap;
    }
}

