/*
 * Decompiled with CFR 0.152.
 */
package apijson;

import apijson.Log;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String TAG = "StringUtil";
    public static final String UTF_8 = "utf-8";
    public static final String EMPTY = "\u65e0";
    public static final String UNKNOWN = "\u672a\u77e5";
    public static final String UNLIMITED = "\u4e0d\u9650";
    public static final String I = "\u6211";
    public static final String YOU = "\u4f60";
    public static final String HE = "\u4ed6";
    public static final String SHE = "\u5979";
    public static final String IT = "\u5b83";
    public static final String MALE = "\u7537";
    public static final String FEMALE = "\u5973";
    public static final String TODO = "\u672a\u5b8c\u6210";
    public static final String DONE = "\u5df2\u5b8c\u6210";
    public static final String FAIL = "\u5931\u8d25";
    public static final String SUCCESS = "\u6210\u529f";
    public static final String SUNDAY = "\u65e5";
    public static final String MONDAY = "\u4e00";
    public static final String TUESDAY = "\u4e8c";
    public static final String WEDNESDAY = "\u4e09";
    public static final String THURSDAY = "\u56db";
    public static final String FRIDAY = "\u4e94";
    public static final String SATURDAY = "\u516d";
    public static final String YUAN = "\u5143";
    private static String currentString = "";
    public static final Pattern PATTERN_NUMBER = Pattern.compile("^[0-9]+$");
    public static final Pattern PATTERN_PHONE;
    public static final Pattern PATTERN_EMAIL;
    public static final Pattern PATTERN_ID_CARD;
    public static final Pattern PATTERN_ALPHA;
    public static final Pattern PATTERN_PASSWORD;
    public static final Pattern PATTERN_NAME;
    public static final Pattern PATTERN_ALPHA_BIG;
    public static final Pattern PATTERN_ALPHA_SMALL;
    public static final String HTTP = "http";
    public static final String URL_PREFIX = "http://";
    public static final String URL_PREFIXs = "https://";
    public static final String URL_STAFFIX = "http://";
    public static final String URL_STAFFIXs = "https://";
    public static final String FILE_PATH_PREFIX = "file://";
    public static final String SEPARATOR = "/";
    public static final int PRICE_FORMAT_DEFAULT = 0;
    public static final int PRICE_FORMAT_PREFIX = 1;
    public static final int PRICE_FORMAT_SUFFIX = 2;
    public static final int PRICE_FORMAT_PREFIX_WITH_BLANK = 3;
    public static final int PRICE_FORMAT_SUFFIX_WITH_BLANK = 4;
    public static final String[] PRICE_FORMATS;

    public static String getCurrentString() {
        return currentString == null ? "" : currentString;
    }

    public static String getString(Object object) {
        return object == null ? "" : object.toString();
    }

    public static String getString(CharSequence cs) {
        return cs == null ? "" : cs.toString();
    }

    public static String getString(String s) {
        return s == null ? "" : s;
    }

    public static String getString(Object[] array) {
        return StringUtil.getString(array, false);
    }

    public static String getString(Object[] array, boolean ignoreEmptyItem) {
        return StringUtil.getString(array, null, ignoreEmptyItem);
    }

    public static String getString(Object[] array, String split) {
        return StringUtil.getString(array, split, false);
    }

    public static String getString(Object[] array, String split, boolean ignoreEmptyItem) {
        StringBuilder s = new StringBuilder("");
        if (array != null) {
            if (split == null) {
                split = ",";
            }
            for (int i = 0; i < array.length; ++i) {
                if (ignoreEmptyItem && StringUtil.isEmpty(array[i], true)) continue;
                s.append((i > 0 ? split : "") + array[i]);
            }
        }
        return StringUtil.getString(s.toString());
    }

    public static String getTrimedString(Object object) {
        return StringUtil.getTrimedString(StringUtil.getString(object));
    }

    public static String getTrimedString(CharSequence cs) {
        return StringUtil.getTrimedString(StringUtil.getString(cs));
    }

    public static String getTrimedString(String s) {
        return StringUtil.getString(s).trim();
    }

    public static String getNoBlankString(Object object) {
        return StringUtil.getNoBlankString(StringUtil.getString(object));
    }

    public static String getNoBlankString(CharSequence cs) {
        return StringUtil.getNoBlankString(StringUtil.getString(cs));
    }

    public static String getNoBlankString(String s) {
        return StringUtil.getString(s).replaceAll("\\s", "");
    }

    public static int getLength(Object object, boolean trim) {
        return StringUtil.getLength(StringUtil.getString(object), trim);
    }

    public static int getLength(CharSequence cs, boolean trim) {
        return StringUtil.getLength(StringUtil.getString(cs), trim);
    }

    public static int getLength(String s, boolean trim) {
        s = trim ? StringUtil.getTrimedString(s) : s;
        return StringUtil.getString(s).length();
    }

    public static boolean isEmpty(Object object, boolean trim) {
        return StringUtil.isEmpty(StringUtil.getString(object), trim);
    }

    public static boolean isEmpty(CharSequence cs, boolean trim) {
        return StringUtil.isEmpty(StringUtil.getString(cs), trim);
    }

    public static boolean isEmpty(String s, boolean trim) {
        if (s == null) {
            return true;
        }
        if (trim) {
            s = s.trim();
        }
        if (s.isEmpty()) {
            return true;
        }
        currentString = s;
        return false;
    }

    public static boolean isNotEmpty(Object object, boolean trim) {
        return StringUtil.isNotEmpty(StringUtil.getString(object), trim);
    }

    public static boolean isNotEmpty(CharSequence cs, boolean trim) {
        return StringUtil.isNotEmpty(StringUtil.getString(cs), trim);
    }

    public static boolean isNotEmpty(String s, boolean trim) {
        return !StringUtil.isEmpty(s, trim);
    }

    public static boolean isPhone(String phone) {
        if (!StringUtil.isNotEmpty(phone, true)) {
            return false;
        }
        currentString = phone;
        return PATTERN_PHONE.matcher(phone).matches();
    }

    public static boolean isPassword(String s) {
        return StringUtil.getLength(s, false) >= 6 && PATTERN_PASSWORD.matcher(s).matches();
    }

    public static boolean isNumberPassword(String s) {
        return StringUtil.getLength(s, false) == 6 && StringUtil.isNumer(s);
    }

    public static boolean isEmail(String email) {
        if (!StringUtil.isNotEmpty(email, true)) {
            return false;
        }
        currentString = email;
        return PATTERN_EMAIL.matcher(email).matches();
    }

    public static boolean isVerify(String s) {
        return StringUtil.getLength(s, false) >= 4 && StringUtil.isNumer(s);
    }

    public static boolean isNumer(String s) {
        if (!StringUtil.isNotEmpty(s, true)) {
            return false;
        }
        currentString = s;
        return PATTERN_NUMBER.matcher(s).matches();
    }

    public static boolean isAlpha(String s) {
        if (StringUtil.isEmpty(s, true)) {
            return false;
        }
        currentString = s;
        return PATTERN_ALPHA.matcher(s).matches();
    }

    public static boolean isNumberOrAlpha(String s) {
        return StringUtil.isNumer(s) || StringUtil.isAlpha(s);
    }

    public static boolean isName(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        String first = s.substring(0, 1);
        if (!"_".equals(first) && !PATTERN_ALPHA.matcher(first).matches()) {
            return false;
        }
        return s.length() <= 1 ? true : PATTERN_NAME.matcher(s.substring(1)).matches();
    }

    public static boolean isBigName(String s) {
        if (s == null || s.isEmpty() || !PATTERN_ALPHA_BIG.matcher(s.substring(0, 1)).matches()) {
            return false;
        }
        return s.length() <= 1 ? true : PATTERN_NAME.matcher(s.substring(1)).matches();
    }

    public static boolean isSmallName(String s) {
        if (s == null || s.isEmpty() || !PATTERN_ALPHA_SMALL.matcher(s.substring(0, 1)).matches()) {
            return false;
        }
        return s.length() <= 1 ? true : PATTERN_NAME.matcher(s.substring(1)).matches();
    }

    public static boolean isIDCard(String number) {
        if (!StringUtil.isNumberOrAlpha(number)) {
            return false;
        }
        if ((number = StringUtil.getString(number)).length() == 15) {
            Log.i(TAG, "isIDCard number.length() == 15 old IDCard");
            currentString = number;
            return true;
        }
        if (number.length() == 18) {
            currentString = number;
            return true;
        }
        return false;
    }

    public static boolean isUrl(String url) {
        if (!StringUtil.isNotEmpty(url, true)) {
            return false;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            return false;
        }
        currentString = url;
        return true;
    }

    public static boolean isFilePathExist(String path) {
        return StringUtil.isFilePath(path) && new File(path).exists();
    }

    public static boolean isPath(String path) {
        return StringUtil.isNotEmpty(path, true) && path.contains(SEPARATOR) && !path.contains("//") && !path.endsWith(SEPARATOR);
    }

    public static boolean isFilePath(String path) {
        if (!StringUtil.isNotEmpty(path, true)) {
            return false;
        }
        if (!path.contains(".") || path.endsWith(".")) {
            return false;
        }
        currentString = path;
        return true;
    }

    public static String getNumber(Object object) {
        return StringUtil.getNumber(StringUtil.getString(object));
    }

    public static String getNumber(CharSequence cs) {
        return StringUtil.getNumber(StringUtil.getString(cs));
    }

    public static String getNumber(String s) {
        return StringUtil.getNumber(s, false);
    }

    public static String getNumber(String s, boolean onlyStart) {
        if (!StringUtil.isNotEmpty(s, true)) {
            return "";
        }
        StringBuilder numberString = new StringBuilder("");
        for (int i = 0; i < s.length(); ++i) {
            String single = s.substring(i, i + 1);
            if (StringUtil.isNumer(single)) {
                numberString.append(single);
                continue;
            }
            if (!onlyStart) continue;
            return numberString.toString();
        }
        return numberString.toString();
    }

    public static String getCorrectUrl(String url) {
        Log.i(TAG, "getCorrectUrl : \n" + url);
        if (!StringUtil.isNotEmpty(url, true)) {
            return "";
        }
        if (!StringUtil.isUrl(url)) {
            return "http://" + url;
        }
        return url;
    }

    public static String getCorrectPhone(String phone) {
        if (!StringUtil.isNotEmpty(phone, true)) {
            return "";
        }
        phone = StringUtil.getNoBlankString(phone);
        if ((phone = phone.replaceAll("-", "")).startsWith("+86")) {
            phone = phone.substring(3);
        }
        return phone;
    }

    public static String getCorrectEmail(String email) {
        if (!StringUtil.isNotEmpty(email, true)) {
            return "";
        }
        if (!StringUtil.isEmail(email = StringUtil.getNoBlankString(email)) && !email.endsWith(".com")) {
            email = email + ".com";
        }
        return email;
    }

    public static String getPrice(String price) {
        return StringUtil.getPrice(price, 0);
    }

    public static String getPrice(String price, int formatType) {
        if (!StringUtil.isNotEmpty(price, true)) {
            return StringUtil.getPrice(0.0, formatType);
        }
        StringBuilder correctPriceBuilder = new StringBuilder("");
        for (int i = 0; i < price.length(); ++i) {
            String s = price.substring(i, i + 1);
            if (!".".equals(s) && !StringUtil.isNumer(s)) continue;
            correctPriceBuilder.append(s);
        }
        String correctPrice = correctPriceBuilder.toString();
        Log.i(TAG, "getPrice  <<<<<<<<<<<<<<<<<< correctPrice =  " + correctPrice);
        if (correctPrice.contains(".") && correctPrice.endsWith(".")) {
            correctPrice = correctPrice.replaceAll(".", "");
        }
        Log.i(TAG, "getPrice correctPrice =  " + correctPrice + " >>>>>>>>>>>>>>>>");
        return StringUtil.isNotEmpty(correctPrice, true) ? StringUtil.getPrice(new BigDecimal(0 + correctPrice), formatType) : StringUtil.getPrice(0.0, formatType);
    }

    public static String getPrice(BigDecimal price) {
        return StringUtil.getPrice(price, 0);
    }

    public static String getPrice(double price) {
        return StringUtil.getPrice(price, 0);
    }

    public static String getPrice(BigDecimal price, int formatType) {
        return StringUtil.getPrice(price == null ? 0.0 : price.doubleValue(), formatType);
    }

    public static String getPrice(double price, int formatType) {
        String s = new DecimalFormat("#########0.00").format(price);
        switch (formatType) {
            case 1: {
                return PRICE_FORMATS[1] + s;
            }
            case 2: {
                return s + PRICE_FORMATS[2];
            }
            case 3: {
                return PRICE_FORMATS[3] + s;
            }
            case 4: {
                return s + PRICE_FORMATS[4];
            }
        }
        return s;
    }

    public static String join(String[] arr, String s) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            stringBuilder.append(arr[i]);
            if (i >= arr.length - 1) continue;
            stringBuilder.append(s);
        }
        return stringBuilder.toString();
    }

    public static String[] splitPath(String path) {
        String[] stringArray;
        if (!StringUtil.isNotEmpty(path, true)) {
            return null;
        }
        if (StringUtil.isPath(path)) {
            stringArray = StringUtil.split(path, SEPARATOR);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = path;
        }
        return stringArray;
    }

    public static String[] split(String s) {
        return StringUtil.split(s, null);
    }

    public static String[] split(String s, String split) {
        return StringUtil.split(s, split, true);
    }

    public static String[] split(String s, boolean trim) {
        return StringUtil.split(s, null, trim);
    }

    public static String[] split(String s, String split, boolean trim) {
        String[] stringArray;
        if ((s = StringUtil.getString(s)).isEmpty()) {
            return null;
        }
        if (StringUtil.isEmpty(split, false)) {
            split = ",";
        }
        if (trim) {
            while (s.startsWith(split)) {
                s = s.substring(split.length());
            }
            while (s.endsWith(split)) {
                s = s.substring(0, s.length() - split.length());
            }
        }
        if (s.contains(split)) {
            stringArray = s.split(split);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        }
        return stringArray;
    }

    public static String addSuffix(String key, String suffix) {
        if ((key = StringUtil.getNoBlankString(key)).isEmpty()) {
            return StringUtil.firstCase(suffix);
        }
        return StringUtil.firstCase(key) + StringUtil.firstCase(suffix, true);
    }

    public static String firstCase(String key) {
        return StringUtil.firstCase(key, false);
    }

    public static String firstCase(String key, boolean upper) {
        if ((key = StringUtil.getString(key)).isEmpty()) {
            return "";
        }
        String first = key.substring(0, 1);
        key = (upper ? first.toUpperCase() : first.toLowerCase()) + key.substring(1, key.length());
        return key;
    }

    public static String toUpperCase(String s) {
        return StringUtil.toUpperCase(s, false);
    }

    public static String toUpperCase(String s, boolean trim) {
        s = trim ? StringUtil.getTrimedString(s) : StringUtil.getString(s);
        return s.toUpperCase();
    }

    public static String toLowerCase(String s) {
        return StringUtil.toLowerCase(s, false);
    }

    public static String toLowerCase(String s, boolean trim) {
        s = trim ? StringUtil.getTrimedString(s) : StringUtil.getString(s);
        return s.toLowerCase();
    }

    public static String concat(String left, String right) {
        return StringUtil.concat(left, right, null);
    }

    public static String concat(String left, String right, String split) {
        return StringUtil.concat(left, right, split, true);
    }

    public static String concat(String left, String right, boolean trim) {
        return StringUtil.concat(left, right, null, trim);
    }

    public static String concat(String left, String right, String split, boolean trim) {
        if (StringUtil.isEmpty(left, trim)) {
            return right;
        }
        if (StringUtil.isEmpty(right, trim)) {
            return left;
        }
        if (split == null) {
            split = ",";
        }
        return left + split + right;
    }

    public static boolean equals(Object s1, Object s2) {
        return Objects.equals(s1, s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    static {
        PATTERN_ALPHA = Pattern.compile("^[a-zA-Z]+$");
        PATTERN_ALPHA_BIG = Pattern.compile("^[A-Z]+$");
        PATTERN_ALPHA_SMALL = Pattern.compile("^[a-z]+$");
        PATTERN_NAME = Pattern.compile("^[0-9a-zA-Z_]+$");
        PATTERN_PHONE = Pattern.compile("^1(?:3\\d{3}|5[^4\\D]\\d{2}|8\\d{3}|7(?:[0-35-9]\\d{2}|4(?:0\\d|1[0-2]|9\\d))|9[0-35-9]\\d{2}|6[2567]\\d{2}|4(?:(?:10|4[01])\\d{3}|[68]\\d{4}|[579]\\d{2}))\\d{6}$");
        PATTERN_EMAIL = Pattern.compile("^([a-zA-Z0-9_\\-\\.]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
        PATTERN_ID_CARD = Pattern.compile("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$)");
        PATTERN_PASSWORD = Pattern.compile("^[0-9a-zA-Z]+$");
        PRICE_FORMATS = new String[]{"", "\uffe5", YUAN, "\uffe5 ", " \u5143"};
    }
}

