/*
 * Decompiled with CFR 0.152.
 */
package apijson;

import apijson.JSONObject;
import apijson.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JSONRequest
extends JSONObject {
    private static final long serialVersionUID = 1L;
    public static final String KEY_TAG = "tag";
    public static final String KEY_VERSION = "version";
    public static final String KEY_FORMAT = "format";
    public static final int QUERY_TABLE = 0;
    public static final int QUERY_TOTAL = 1;
    public static final int QUERY_ALL = 2;
    public static final String QUERY_TABLE_STRING = "TABLE";
    public static final String QUERY_TOTAL_STRING = "TOTAL";
    public static final String QUERY_ALL_STRING = "ALL";
    public static final String SUBQUERY_RANGE_ALL = "ALL";
    public static final String SUBQUERY_RANGE_ANY = "ANY";
    public static final String KEY_QUERY = "query";
    public static final String KEY_COUNT = "count";
    public static final String KEY_PAGE = "page";
    public static final String KEY_JOIN = "join";
    public static final String KEY_SUBQUERY_RANGE = "range";
    public static final String KEY_SUBQUERY_FROM = "from";
    public static final List<String> ARRAY_KEY_LIST = new ArrayList<String>();

    public JSONRequest() {
    }

    public JSONRequest(Object object) {
        this(null, object);
    }

    public JSONRequest(String name, Object object) {
        this();
        this.puts(name, object);
    }

    public JSONRequest setTag(String tag) {
        return this.puts(KEY_TAG, tag);
    }

    public JSONRequest setVersion(Integer version) {
        return this.puts(KEY_VERSION, version);
    }

    public JSONRequest setFormat(Boolean format) {
        return this.puts(KEY_FORMAT, format);
    }

    public JSONRequest setQuery(int query) {
        return this.puts(KEY_QUERY, query);
    }

    public JSONRequest setCount(int count) {
        return this.puts(KEY_COUNT, count);
    }

    public JSONRequest setPage(int page) {
        return this.puts(KEY_PAGE, page);
    }

    public JSONRequest setJoin(String ... joins) {
        return this.puts(KEY_JOIN, StringUtil.getString(joins));
    }

    public JSONRequest setSubqueryRange(String range) {
        return this.puts(KEY_SUBQUERY_RANGE, range);
    }

    public JSONRequest setSubqueryFrom(String from) {
        return this.puts(KEY_SUBQUERY_FROM, from);
    }

    public JSONRequest toArray(int count, int page) {
        return this.toArray(count, page, null);
    }

    public JSONRequest toArray(int count, int page, String name) {
        return new JSONRequest(StringUtil.getString(name) + "[]", (Object)this.setCount(count).setPage(page));
    }

    @Override
    public JSONObject putsAll(Map<? extends String, ? extends Object> map) {
        super.putsAll(map);
        return this;
    }

    @Override
    public JSONRequest puts(Object value) {
        return this.puts(null, value);
    }

    @Override
    public JSONRequest puts(String key, Object value) {
        super.puts(key, value);
        return this;
    }

    static {
        ARRAY_KEY_LIST.add(KEY_QUERY);
        ARRAY_KEY_LIST.add(KEY_COUNT);
        ARRAY_KEY_LIST.add(KEY_PAGE);
        ARRAY_KEY_LIST.add(KEY_JOIN);
        ARRAY_KEY_LIST.add(KEY_SUBQUERY_RANGE);
        ARRAY_KEY_LIST.add(KEY_SUBQUERY_FROM);
    }
}

