/*
 * Decompiled with CFR 0.152.
 */
package apijson.orm;

import apijson.JSON;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.orm.AbstractParser;
import apijson.orm.Join;
import apijson.orm.SQLConfig;
import apijson.orm.SQLExecutor;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSQLExecutor
implements SQLExecutor {
    private static final String TAG = "AbstractSQLExecutor";
    private int generatedSQLCount = 0;
    private int cachedSQLCount = 0;
    private int executedSQLCount = 0;
    protected Map<String, List<JSONObject>> cacheMap = new HashMap<String, List<JSONObject>>();
    protected Map<String, Connection> connectionMap = new HashMap<String, Connection>();
    protected Connection connection;
    private int transactionIsolation;

    @Override
    public int getGeneratedSQLCount() {
        return this.generatedSQLCount;
    }

    @Override
    public int getCachedSQLCount() {
        return this.cachedSQLCount;
    }

    @Override
    public int getExecutedSQLCount() {
        return this.executedSQLCount;
    }

    @Override
    public synchronized void putCache(String sql, List<JSONObject> list, int type) {
        if (sql == null || list == null) {
            Log.i(TAG, "saveList  sql == null || list == null >> return;");
            return;
        }
        this.cacheMap.put(sql, list);
    }

    @Override
    public synchronized void removeCache(String sql, int type) {
        if (sql == null) {
            Log.i(TAG, "removeList  sql == null >> return;");
            return;
        }
        this.cacheMap.remove(sql);
    }

    @Override
    public List<JSONObject> getCache(String sql, int type) {
        return this.cacheMap.get(sql);
    }

    @Override
    public JSONObject getCacheItem(String sql, int position, int type) {
        List<JSONObject> list = this.getCache(sql, type);
        if (list == null) {
            return null;
        }
        JSONObject result = position >= list.size() ? null : list.get(position);
        return result != null ? result : new JSONObject();
    }

    @Override
    public ResultSet executeQuery(@NotNull Statement statement, String sql) throws Exception {
        ++this.executedSQLCount;
        return statement.executeQuery(sql);
    }

    @Override
    public int executeUpdate(@NotNull Statement statement, String sql) throws Exception {
        ++this.executedSQLCount;
        return statement.executeUpdate(sql);
    }

    @Override
    public ResultSet execute(@NotNull Statement statement, String sql) throws Exception {
        ++this.executedSQLCount;
        statement.execute(sql);
        return statement.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject execute(@NotNull SQLConfig config, boolean unknowType) throws Exception {
        JSONObject result;
        boolean isPrepared = config.isPrepared();
        String sql = config.getSQL(false);
        config.setPrepared(isPrepared);
        if (StringUtil.isEmpty(sql, true)) {
            Log.e(TAG, "execute  StringUtil.isEmpty(sql, true) >> return null;");
            return null;
        }
        boolean isExplain = config.isExplain();
        boolean isHead = RequestMethod.isHeadMethod(config.getMethod(), true);
        int position = config.getPosition();
        if (!isExplain) {
            ++this.generatedSQLCount;
        }
        long startTime = System.currentTimeMillis();
        Log.d(TAG, "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n\u5df2\u751f\u6210 " + this.generatedSQLCount + " \u6761 SQL\nexecute  startTime = " + startTime + "\ndatabase = " + StringUtil.getString(config.getDatabase()) + "; schema = " + StringUtil.getString(config.getSchema()) + "; sql = \n" + sql + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
        ResultSet rs = null;
        List<JSONObject> resultList = null;
        HashMap<String, JSONObject> childMap = null;
        try {
            if (unknowType) {
                PreparedStatement statement = this.getStatement(config);
                rs = this.execute(statement, sql);
                result = new JSONObject(true);
                int updateCount2 = statement.getUpdateCount();
                result.put("count", (Object)updateCount2);
                result.put("update", (Object)(updateCount2 >= 0 ? 1 : 0));
            } else {
                switch (config.getMethod()) {
                    case POST: 
                    case PUT: 
                    case DELETE: {
                        ++this.executedSQLCount;
                        int updateCount = this.executeUpdate(config);
                        if (updateCount <= 0) {
                            throw new IllegalAccessException("\u6ca1\u6743\u9650\u8bbf\u95ee\u6216\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01");
                        }
                        JSONObject result2 = AbstractParser.newSuccessResult();
                        result2.put("count", (Object)updateCount);
                        if (config.getId() != null) {
                            result2.put(config.getIdKey(), config.getId());
                        } else {
                            result2.put(config.getIdKey() + "[]", config.getWhere(config.getIdKey() + "{}", true));
                        }
                        JSONObject updateCount2 = result2;
                        return updateCount2;
                    }
                    case GET: 
                    case GETS: 
                    case HEAD: 
                    case HEADS: {
                        result = isHead ? null : this.getCacheItem(sql, position, config.getCache());
                        Log.i(TAG, ">>> execute  result = getCache('" + sql + "', " + position + ") = " + result);
                        if (result != null) {
                            ++this.cachedSQLCount;
                            Log.d(TAG, "\n\n execute  result != null >> return result;\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
                            JSONObject updateCount2 = result;
                            return updateCount2;
                        }
                        rs = this.executeQuery(config);
                        if (isExplain) break;
                        ++this.executedSQLCount;
                        break;
                    }
                    default: {
                        Log.e(TAG, "execute  sql = " + sql + " ; method = " + (Object)((Object)config.getMethod()) + " >> return null;");
                        JSONObject updateCount2 = null;
                        return updateCount2;
                    }
                }
            }
            if (!isExplain && isHead) {
                if (!rs.next()) {
                    JSONObject updateCount = AbstractParser.newErrorResult(new SQLException("\u6570\u636e\u5e93\u9519\u8bef, rs.next() \u5931\u8d25\uff01"));
                    return updateCount;
                }
                result = AbstractParser.newSuccessResult();
                result.put("count", (Object)rs.getLong(1));
                resultList = new ArrayList(1);
                resultList.add(result);
            } else {
                resultList = new ArrayList<JSONObject>(config.getCount() <= 0 ? 100 : config.getCount());
                int index = -1;
                ResultSetMetaData rsmd = rs.getMetaData();
                int length = rsmd.getColumnCount();
                childMap = new HashMap<String, JSONObject>();
                boolean hasJoin = config.hasJoin();
                int viceColumnStart = length + 1;
                while (rs.next()) {
                    Log.d(TAG, "\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n execute while (rs.next()){  index = " + ++index + "\n\n");
                    JSONObject item = new JSONObject(true);
                    for (int i = 1; i <= length; ++i) {
                        if (!isExplain && hasJoin && viceColumnStart > length) {
                            List<String> column = config.getColumn();
                            if (column != null && !column.isEmpty()) {
                                viceColumnStart = column.size() + 1;
                            } else if (!config.getSQLTable().equalsIgnoreCase(rsmd.getTableName(i))) {
                                viceColumnStart = i;
                            }
                        }
                        item = this.onPutColumn(config, rs, rsmd, index, item, i, !isExplain && hasJoin && i >= viceColumnStart ? childMap : null);
                    }
                    resultList = this.onPutTable(config, rs, rsmd, resultList, index, item);
                    Log.d(TAG, "\n execute  while (rs.next()) { resultList.put( " + index + ", result); \n >>>>>>>>>>>>>>>>>>>>>>>>>>> \n\n");
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (resultList == null) {
            return null;
        }
        if (unknowType || isExplain) {
            if (isExplain) {
                if (result == null) {
                    result = new JSONObject(true);
                }
                config.setExplain(false);
                result.put("sql", (Object)config.getSQL(false));
                config.setExplain(isExplain);
                config.setPrepared(isPrepared);
            }
            result.put("list", resultList);
            return result;
        }
        if (!isHead) {
            this.executeAppJoin(config, resultList, childMap);
            Set set = childMap.entrySet();
            for (Map.Entry entry : set) {
                ArrayList<JSONObject> l = new ArrayList<JSONObject>();
                l.add((JSONObject)entry.getValue());
                this.putCache((String)entry.getKey(), l, 1);
            }
            this.putCache(sql, resultList, config.getCache());
            Log.i(TAG, ">>> execute  putCache('" + sql + "', resultList);  resultList.size() = " + resultList.size());
            JSONObject jSONObject = result = position >= resultList.size() ? new JSONObject() : resultList.get(position);
            if (position == 0 && resultList.size() > 1 && result != null && !result.isEmpty()) {
                Log.i(TAG, ">>> execute  position == 0 && resultList.size() > 1 && result != null && result.isEmpty() == false >> result = new JSONObject(result); result.put(KEY_RAW_LIST, resultList);");
                result = new JSONObject((Map)result);
                result.put("@RAW@LIST", resultList);
            }
        }
        long endTime = System.currentTimeMillis();
        Log.d(TAG, "\n\n execute  endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n return resultList.get(" + position + ");\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAppJoin(SQLConfig config, List<JSONObject> resultList, Map<String, JSONObject> childMap) throws Exception {
        List<Join> joinList = config.getJoinList();
        if (joinList != null) {
            for (Join j : joinList) {
                if (!j.isAppJoin()) {
                    Log.i(TAG, "executeAppJoin  for (Join j : joinList) >> j.isAppJoin() == false >>  continue;");
                    continue;
                }
                SQLConfig cc = j.getCacheConfig();
                if (cc == null) {
                    if (!Log.DEBUG) continue;
                    throw new NullPointerException("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef, executeAppJoin cc == null ! \u5bfc\u81f4\u4e0d\u80fd\u7f13\u5b58 @ APP JOIN \u7684\u526f\u8868\u6570\u636e\uff01");
                }
                SQLConfig jc = j.getJoinConfig();
                ArrayList<Object> targetValueList = new ArrayList<Object>();
                for (int i = 0; i < resultList.size(); ++i) {
                    Object targetValue;
                    JSONObject mainTable = resultList.get(i);
                    Object object = targetValue = mainTable == null ? null : mainTable.get((Object)j.getTargetKey());
                    if (targetValue == null || targetValueList.contains(targetValue)) continue;
                    targetValueList.add(targetValue);
                }
                jc.putWhere(j.getOriginKey(), null, false);
                jc.putWhere(j.getKey() + "{}", targetValueList, true);
                jc.setMain(true).setPreparedValueList(new ArrayList<Object>());
                boolean prepared = jc.isPrepared();
                String sql = jc.getSQL(false);
                jc.setPrepared(prepared);
                if (StringUtil.isEmpty(sql, true)) {
                    throw new NullPointerException("AbstractSQLExecutor.executeAppJoin  StringUtil.isEmpty(sql, true) >> return null;");
                }
                long startTime = System.currentTimeMillis();
                Log.d(TAG, "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n executeAppJoin  startTime = " + startTime + "\n sql = \n " + sql + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");
                ResultSet rs = null;
                try {
                    rs = this.executeQuery(jc);
                    int index = -1;
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int length = rsmd.getColumnCount();
                    while (rs.next()) {
                        Log.d(TAG, "\n\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n executeAppJoin while (rs.next()){  index = " + ++index + "\n\n");
                        JSONObject result = new JSONObject(true);
                        for (int i = 1; i <= length; ++i) {
                            result = this.onPutColumn(jc, rs, rsmd, index, result, i, null);
                        }
                        Log.d(TAG, "\n executeAppJoin  while (rs.next()) { resultList.put( " + index + ", result); \n >>>>>>>>>>>>>>>>>>>>>>>>>>> \n\n");
                        cc.putWhere(j.getKey(), result.get((Object)j.getKey()), true);
                        String cacheSql = cc.getSQL(false);
                        childMap.put(cacheSql, result);
                        Log.d(TAG, ">>> executeAppJoin childMap.put('" + cacheSql + "', result);  childMap.size() = " + childMap.size());
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                long endTime = System.currentTimeMillis();
                Log.d(TAG, "\n\n executeAppJoin  endTime = " + endTime + "; duration = " + (endTime - startTime) + "\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n\n");
            }
        }
    }

    protected JSONObject onPutColumn(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, Map<String, JSONObject> childMap) throws Exception {
        if (rsmd.getColumnName(columnIndex).startsWith("_")) {
            Log.i(TAG, "select while (rs.next()){ ... >>  rsmd.getColumnName(i).startsWith(_) >> continue;");
            return table;
        }
        String lable = this.getKey(config, rs, rsmd, tablePosition, table, columnIndex, childMap);
        String childTable = childMap == null ? null : rsmd.getTableName(columnIndex);
        JSONObject finalTable = null;
        String childSql = null;
        SQLConfig childConfig = null;
        if (childTable == null) {
            finalTable = table;
        } else {
            List<Join> joinList = config.getJoinList();
            if (joinList != null) {
                for (Join j : joinList) {
                    childConfig = j.isAppJoin() ? null : j.getCacheConfig();
                    if (childConfig == null || !childTable.equalsIgnoreCase(childConfig.getSQLTable())) continue;
                    childConfig.putWhere(j.getKey(), table.get((Object)j.getTargetKey()), true);
                    childSql = childConfig.getSQL(false);
                    if (StringUtil.isEmpty(childSql, true)) {
                        return table;
                    }
                    finalTable = childMap.get(childSql);
                    break;
                }
            }
        }
        Object value = this.getValue(config, rs, rsmd, tablePosition, table, columnIndex, lable, childMap);
        if (value != null) {
            if (finalTable == null) {
                finalTable = new JSONObject(true);
                childMap.put(childSql, finalTable);
            }
            finalTable.put(lable, value);
        }
        return table;
    }

    protected List<JSONObject> onPutTable(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, @NotNull List<JSONObject> resultList, int position, @NotNull JSONObject table) {
        resultList.add(table);
        return resultList;
    }

    protected String getKey(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, Map<String, JSONObject> childMap) throws Exception {
        return rsmd.getColumnLabel(columnIndex);
    }

    protected Object getValue(@NotNull SQLConfig config, @NotNull ResultSet rs, @NotNull ResultSetMetaData rsmd, int tablePosition, @NotNull JSONObject table, int columnIndex, String lable, Map<String, JSONObject> childMap) throws Exception {
        Object value = rs.getObject(columnIndex);
        boolean castToJson = false;
        if (!(value instanceof Boolean) && !(value instanceof Number)) {
            if (value instanceof Timestamp) {
                value = ((Timestamp)value).toString();
            } else if (value instanceof Date) {
                value = ((Date)value).toString();
            } else if (value instanceof Time) {
                value = ((Time)value).toString();
            } else if (value instanceof String && this.isJSONType(config, rsmd, columnIndex, lable)) {
                castToJson = true;
            } else if (value instanceof Blob) {
                castToJson = true;
                value = new String(((Blob)value).getBytes(1L, (int)((Blob)value).length()), "UTF-8");
            } else if (value instanceof Clob) {
                castToJson = true;
                StringBuffer sb = new StringBuffer();
                BufferedReader br = new BufferedReader(((Clob)value).getCharacterStream());
                String s = br.readLine();
                while (s != null) {
                    sb.append(s);
                    s = br.readLine();
                }
                value = sb.toString();
                try {
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!castToJson) {
            List<String> json = config.getJson();
            boolean bl = castToJson = json != null && json.contains(lable);
        }
        if (castToJson) {
            try {
                value = com.alibaba.fastjson.JSON.parse((String)((String)value));
            }
            catch (Exception e) {
                Log.e(TAG, "getValue  try { value = JSON.parse((String) value); } catch (Exception e) { \n" + e.getMessage());
            }
        }
        return value;
    }

    @Override
    public boolean isJSONType(@NotNull SQLConfig config, ResultSetMetaData rsmd, int position, String lable) {
        try {
            String column = rsmd.getColumnTypeName(position);
            if (column.toLowerCase().contains("json")) {
                return true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public PreparedStatement getStatement(@NotNull SQLConfig config) throws Exception {
        List<Object> valueList;
        PreparedStatement statement = config.getMethod() == RequestMethod.POST && config.getId() == null ? this.getConnection(config).prepareStatement(config.getSQL(config.isPrepared()), 1) : this.getConnection(config).prepareStatement(config.getSQL(config.isPrepared()));
        List<Object> list = valueList = config.isPrepared() ? config.getPreparedValueList() : null;
        if (valueList != null && !valueList.isEmpty()) {
            for (int i = 0; i < valueList.size(); ++i) {
                statement = this.setArgument(config, statement, i, valueList.get(i));
            }
        }
        return statement;
    }

    public PreparedStatement setArgument(@NotNull SQLConfig config, @NotNull PreparedStatement statement, int index, Object value) throws SQLException {
        if (JSON.isBooleanOrNumberOrString(value)) {
            statement.setObject(index + 1, value);
        } else {
            statement.setString(index + 1, value == null ? null : value.toString());
        }
        return statement;
    }

    @Override
    @NotNull
    public Connection getConnection(@NotNull SQLConfig config) throws Exception {
        int ti;
        String connectionKey = config.getDatasource() + "-" + config.getDatabase();
        this.connection = this.connectionMap.get(connectionKey);
        if (this.connection == null || this.connection.isClosed()) {
            Log.i(TAG, "select  connection " + (this.connection == null ? " = null" : "isClosed = " + this.connection.isClosed()));
            this.connection = DriverManager.getConnection(config.getDBUri(), config.getDBAccount(), config.getDBPassword());
            this.connectionMap.put(connectionKey, this.connection);
        }
        if ((ti = this.getTransactionIsolation()) != 0) {
            this.begin(ti);
        }
        return this.connection;
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public void begin(int transactionIsolation) throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION begin transactionIsolation = " + transactionIsolation + " >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        this.connection.setTransactionIsolation(transactionIsolation);
        this.connection.setAutoCommit(false);
    }

    @Override
    public void rollback() throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION rollback >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        if (this.connection == null) {
            return;
        }
        this.connection.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION rollback savepoint " + (savepoint == null ? "" : "!") + "= null >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        if (this.connection == null) {
            return;
        }
        this.connection.rollback(savepoint);
    }

    @Override
    public void commit() throws SQLException {
        Log.d("\n\nAbstractSQLExecutor", "<<<<<<<<<<<<<< TRANSACTION commit >>>>>>>>>>>>>>>>>>>>>>> \n\n");
        if (this.connection == null) {
            return;
        }
        this.connection.commit();
    }

    @Override
    public void close() {
        this.cacheMap.clear();
        this.cacheMap = null;
        this.generatedSQLCount = 0;
        this.cachedSQLCount = 0;
        this.executedSQLCount = 0;
        if (this.connectionMap == null) {
            return;
        }
        Collection<Connection> connections = this.connectionMap.values();
        if (connections != null) {
            for (Connection connection : connections) {
                try {
                    if (connection == null || connection.isClosed()) continue;
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        this.connectionMap.clear();
        this.connectionMap = null;
    }

    @Override
    public ResultSet executeQuery(@NotNull SQLConfig config) throws Exception {
        return this.getStatement(config).executeQuery();
    }

    @Override
    public int executeUpdate(@NotNull SQLConfig config) throws Exception {
        ResultSet rs;
        PreparedStatement s = this.getStatement(config);
        int count = s.executeUpdate();
        if (config.getMethod() == RequestMethod.POST && config.getId() == null && (rs = s.getGeneratedKeys()) != null && rs.next()) {
            config.setId(rs.getLong(1));
        }
        return count;
    }
}

