/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import me.ryanhamshire.GriefPrevention.BlockSnapshot;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.RestoreNatureExecutionTask;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class RestoreNatureProcessingTask
implements Runnable {
    private static final Set<NamespacedKey> DENSE_LOG_BIOMES = Set.of(NamespacedKey.minecraft((String)"jungle"), NamespacedKey.minecraft((String)"bamboo_jungle"), NamespacedKey.minecraft((String)"modified_jungle"), NamespacedKey.minecraft((String)"jungle_hills"), NamespacedKey.minecraft((String)"bamboo_jungle_hills"));
    private static final Set<NamespacedKey> SAND_SOIL_BIOMES = Set.of(NamespacedKey.minecraft((String)"snowy_beach"), NamespacedKey.minecraft((String)"beach"), NamespacedKey.minecraft((String)"desert"), NamespacedKey.minecraft((String)"desert_hills"), NamespacedKey.minecraft((String)"desert_lakes"));
    private final BlockSnapshot[][][] snapshots;
    private int miny;
    private final World.Environment environment;
    private final Location lesserBoundaryCorner;
    private final Location greaterBoundaryCorner;
    private final Player player;
    private final Biome biome;
    private final boolean creativeMode;
    private final int seaLevel;
    private final boolean aggressiveMode;
    private final Set<Material> notAllowedToHang;
    private final Set<Material> playerBlocks;

    public RestoreNatureProcessingTask(BlockSnapshot[][][] snapshots, int miny, World.Environment environment, Biome biome, Location lesserBoundaryCorner, Location greaterBoundaryCorner, int seaLevel, boolean aggressiveMode, boolean creativeMode, Player player) {
        this.snapshots = snapshots;
        this.miny = miny;
        if (this.miny < 0) {
            this.miny = 0;
        }
        this.environment = environment;
        this.lesserBoundaryCorner = lesserBoundaryCorner;
        this.greaterBoundaryCorner = greaterBoundaryCorner;
        this.biome = biome;
        this.seaLevel = seaLevel;
        this.aggressiveMode = aggressiveMode;
        this.player = player;
        this.creativeMode = creativeMode;
        this.notAllowedToHang = EnumSet.noneOf(Material.class);
        this.notAllowedToHang.add(Material.DIRT);
        this.notAllowedToHang.add(Material.GRASS);
        this.notAllowedToHang.add(Material.SNOW);
        this.notAllowedToHang.add(Material.OAK_LOG);
        this.notAllowedToHang.add(Material.SPRUCE_LOG);
        this.notAllowedToHang.add(Material.BIRCH_LOG);
        this.notAllowedToHang.add(Material.JUNGLE_LOG);
        this.notAllowedToHang.add(Material.ACACIA_LOG);
        this.notAllowedToHang.add(Material.DARK_OAK_LOG);
        if (this.aggressiveMode) {
            this.notAllowedToHang.add(Material.GRASS);
            this.notAllowedToHang.add(Material.STONE);
        }
        this.playerBlocks = EnumSet.noneOf(Material.class);
        this.playerBlocks.addAll(RestoreNatureProcessingTask.getPlayerBlocks(this.environment, this.biome));
        if (this.aggressiveMode || this.creativeMode) {
            this.playerBlocks.add(Material.IRON_ORE);
            this.playerBlocks.add(Material.GOLD_ORE);
            this.playerBlocks.add(Material.DIAMOND_ORE);
            this.playerBlocks.add(Material.MELON);
            this.playerBlocks.add(Material.MELON_STEM);
            this.playerBlocks.add(Material.BEDROCK);
            this.playerBlocks.add(Material.COAL_ORE);
            this.playerBlocks.add(Material.PUMPKIN);
            this.playerBlocks.add(Material.PUMPKIN_STEM);
        }
        if (this.aggressiveMode) {
            this.playerBlocks.add(Material.OAK_LEAVES);
            this.playerBlocks.add(Material.SPRUCE_LEAVES);
            this.playerBlocks.add(Material.BIRCH_LEAVES);
            this.playerBlocks.add(Material.JUNGLE_LEAVES);
            this.playerBlocks.add(Material.ACACIA_LEAVES);
            this.playerBlocks.add(Material.DARK_OAK_LEAVES);
            this.playerBlocks.add(Material.OAK_LOG);
            this.playerBlocks.add(Material.SPRUCE_LOG);
            this.playerBlocks.add(Material.BIRCH_LOG);
            this.playerBlocks.add(Material.JUNGLE_LOG);
            this.playerBlocks.add(Material.ACACIA_LOG);
            this.playerBlocks.add(Material.DARK_OAK_LOG);
            this.playerBlocks.add(Material.VINE);
        }
    }

    @Override
    public void run() {
        this.removeSandstone();
        this.removePlayerBlocks();
        this.reduceStone();
        this.reduceLogs();
        this.removeHanging();
        this.removeWallsAndTowers();
        this.fillHolesAndTrenches();
        this.removeDumpedFluids();
        this.coverSurfaceStone();
        RestoreNatureExecutionTask task = new RestoreNatureExecutionTask(this.snapshots, this.miny, this.lesserBoundaryCorner, this.greaterBoundaryCorner, this.player);
        GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)task);
    }

    private void removePlayerLeaves() {
        if (this.seaLevel < 1) {
            return;
        }
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = this.seaLevel - 1; y < this.snapshots[0].length; ++y) {
                    BlockSnapshot block = this.snapshots[x][y][z];
                    if (!Tag.LEAVES.isTagged((Keyed)block.typeId) || !((Leaves)block.data).isPersistent()) continue;
                    block.typeId = Material.AIR;
                }
            }
        }
    }

    private void removeSandstone() {
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = this.snapshots[0].length - 2; y > this.miny; --y) {
                    if (this.snapshots[x][y][z].typeId != Material.SANDSTONE) continue;
                    BlockSnapshot leftBlock = this.snapshots[x + 1][y][z];
                    BlockSnapshot rightBlock = this.snapshots[x - 1][y][z];
                    BlockSnapshot upBlock = this.snapshots[x][y][z + 1];
                    BlockSnapshot downBlock = this.snapshots[x][y][z - 1];
                    BlockSnapshot underBlock = this.snapshots[x][y - 1][z];
                    BlockSnapshot aboveBlock = this.snapshots[x][y + 1][z];
                    if (aboveBlock.typeId == Material.SAND && underBlock.typeId == Material.AIR) continue;
                    this.snapshots[x][y][z].typeId = leftBlock.typeId == Material.SAND || rightBlock.typeId == Material.SAND || upBlock.typeId == Material.SAND || downBlock.typeId == Material.SAND || aboveBlock.typeId == Material.SAND || underBlock.typeId == Material.SAND ? Material.SAND : Material.AIR;
                }
            }
        }
    }

    private void reduceStone() {
        if (this.seaLevel < 1) {
            return;
        }
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int thisy = this.highestY(x, z, true); thisy > this.seaLevel - 1 && (this.snapshots[x][thisy][z].typeId == Material.STONE || this.snapshots[x][thisy][z].typeId == Material.SANDSTONE); --thisy) {
                    BlockSnapshot leftBlock = this.snapshots[x + 1][thisy][z];
                    BlockSnapshot rightBlock = this.snapshots[x - 1][thisy][z];
                    BlockSnapshot upBlock = this.snapshots[x][thisy][z + 1];
                    BlockSnapshot downBlock = this.snapshots[x][thisy][z - 1];
                    int adjacentBlockCount = 0;
                    if (leftBlock.typeId != Material.AIR && !Tag.LEAVES.isTagged((Keyed)leftBlock.typeId) && leftBlock.typeId != Material.VINE) {
                        adjacentBlockCount = (byte)(adjacentBlockCount + 1);
                    }
                    if (rightBlock.typeId != Material.AIR && !Tag.LEAVES.isTagged((Keyed)rightBlock.typeId) && rightBlock.typeId != Material.VINE) {
                        adjacentBlockCount = (byte)(adjacentBlockCount + 1);
                    }
                    if (downBlock.typeId != Material.AIR && !Tag.LEAVES.isTagged((Keyed)downBlock.typeId) && downBlock.typeId != Material.VINE) {
                        adjacentBlockCount = (byte)(adjacentBlockCount + 1);
                    }
                    if (upBlock.typeId != Material.AIR && !Tag.LEAVES.isTagged((Keyed)upBlock.typeId) && upBlock.typeId != Material.VINE) {
                        adjacentBlockCount = (byte)(adjacentBlockCount + 1);
                    }
                    if (adjacentBlockCount >= 3) continue;
                    this.snapshots[x][thisy][z].typeId = Material.AIR;
                }
            }
        }
    }

    private void reduceLogs() {
        if (this.seaLevel < 1) {
            return;
        }
        boolean jungleBiome = DENSE_LOG_BIOMES.contains(this.biome.getKey());
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = this.seaLevel - 1; y < this.snapshots[0].length; ++y) {
                    BlockSnapshot block = this.snapshots[x][y][z];
                    if (!Tag.LOGS.isTagged((Keyed)block.typeId) || jungleBiome && block.typeId == Material.JUNGLE_LOG) continue;
                    BlockSnapshot leftBlock = this.snapshots[x + 1][y][z];
                    BlockSnapshot rightBlock = this.snapshots[x - 1][y][z];
                    BlockSnapshot upBlock = this.snapshots[x][y][z + 1];
                    BlockSnapshot downBlock = this.snapshots[x][y][z - 1];
                    if (!Tag.LOGS.isTagged((Keyed)leftBlock.typeId) && !Tag.LOGS.isTagged((Keyed)rightBlock.typeId) && !Tag.LOGS.isTagged((Keyed)upBlock.typeId) && !Tag.LOGS.isTagged((Keyed)downBlock.typeId)) continue;
                    this.snapshots[x][y][z].typeId = Material.AIR;
                }
            }
        }
    }

    private void removePlayerBlocks() {
        int miny = this.miny;
        if (miny < 1) {
            miny = 1;
        }
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = miny; y < this.snapshots[0].length - 1; ++y) {
                    BlockSnapshot block = this.snapshots[x][y][z];
                    if (!this.playerBlocks.contains(block.typeId)) continue;
                    block.typeId = Material.AIR;
                }
            }
        }
    }

    private void removeHanging() {
        int miny = this.miny;
        if (miny < 1) {
            miny = 1;
        }
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = miny; y < this.snapshots[0].length - 1; ++y) {
                    BlockSnapshot block = this.snapshots[x][y][z];
                    BlockSnapshot underBlock = this.snapshots[x][y - 1][z];
                    if (underBlock.typeId != Material.AIR && underBlock.typeId != Material.WATER && !Tag.LEAVES.isTagged((Keyed)underBlock.typeId) || !this.notAllowedToHang.contains(block.typeId)) continue;
                    block.typeId = Material.AIR;
                }
            }
        }
    }

    private void removeWallsAndTowers() {
        boolean changed;
        Material[] excludedBlocksArray = new Material[]{Material.CACTUS, Material.GRASS, Material.RED_MUSHROOM, Material.BROWN_MUSHROOM, Material.DEAD_BUSH, Material.DANDELION, Material.POPPY, Material.ALLIUM, Material.BLUE_ORCHID, Material.AZURE_BLUET, Material.RED_TULIP, Material.ORANGE_TULIP, Material.WHITE_TULIP, Material.PINK_TULIP, Material.OXEYE_DAISY, Material.SUGAR_CANE, Material.VINE, Material.PUMPKIN, Material.LILY_PAD};
        ArrayList<Material> excludedBlocks = new ArrayList<Material>(Arrays.asList(excludedBlocksArray));
        excludedBlocks.addAll(Tag.SAPLINGS.getValues());
        excludedBlocks.addAll(Tag.LEAVES.getValues());
        do {
            changed = false;
            for (int x = 1; x < this.snapshots.length - 1; ++x) {
                for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                    int thisy = this.highestY(x, z, false);
                    if (excludedBlocks.contains(this.snapshots[x][thisy][z].typeId)) continue;
                    int righty = this.highestY(x + 1, z, false);
                    int lefty = this.highestY(x - 1, z, false);
                    while (lefty < thisy && righty < thisy) {
                        this.snapshots[x][thisy--][z].typeId = Material.AIR;
                        changed = true;
                    }
                    int upy = this.highestY(x, z + 1, false);
                    int downy = this.highestY(x, z - 1, false);
                    while (upy < thisy && downy < thisy) {
                        this.snapshots[x][thisy--][z].typeId = Material.AIR;
                        changed = true;
                    }
                }
            }
        } while (changed);
    }

    private void coverSurfaceStone() {
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                int y = this.highestY(x, z, true);
                BlockSnapshot block = this.snapshots[x][y][z];
                if (block.typeId != Material.STONE && block.typeId != Material.GRAVEL && block.typeId != Material.FARMLAND && block.typeId != Material.DIRT && block.typeId != Material.SANDSTONE) continue;
                this.snapshots[x][y][z].typeId = SAND_SOIL_BIOMES.contains(this.biome.getKey()) ? Material.SAND : Material.GRASS_BLOCK;
            }
        }
    }

    private void fillHolesAndTrenches() {
        boolean changed;
        ArrayList<Material> fillableBlocks = new ArrayList<Material>();
        fillableBlocks.add(Material.AIR);
        fillableBlocks.add(Material.WATER);
        fillableBlocks.add(Material.LAVA);
        fillableBlocks.add(Material.GRASS);
        ArrayList<Material> notSuitableForFillBlocks = new ArrayList<Material>();
        notSuitableForFillBlocks.add(Material.GRASS);
        notSuitableForFillBlocks.add(Material.CACTUS);
        notSuitableForFillBlocks.add(Material.WATER);
        notSuitableForFillBlocks.add(Material.LAVA);
        notSuitableForFillBlocks.addAll(Tag.LOGS.getValues());
        do {
            changed = false;
            for (int x = 1; x < this.snapshots.length - 1; ++x) {
                for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                    for (int y = 0; y < this.snapshots[0].length - 1; ++y) {
                        BlockSnapshot block = this.snapshots[x][y][z];
                        if (!fillableBlocks.contains(block.typeId)) continue;
                        BlockSnapshot leftBlock = this.snapshots[x + 1][y][z];
                        BlockSnapshot rightBlock = this.snapshots[x - 1][y][z];
                        if (!(fillableBlocks.contains(leftBlock.typeId) || fillableBlocks.contains(rightBlock.typeId) || notSuitableForFillBlocks.contains(rightBlock.typeId))) {
                            block.typeId = rightBlock.typeId;
                            changed = true;
                        }
                        BlockSnapshot upBlock = this.snapshots[x][y][z + 1];
                        BlockSnapshot downBlock = this.snapshots[x][y][z - 1];
                        if (fillableBlocks.contains(upBlock.typeId) || fillableBlocks.contains(downBlock.typeId) || notSuitableForFillBlocks.contains(downBlock.typeId)) continue;
                        block.typeId = downBlock.typeId;
                        changed = true;
                    }
                }
            }
        } while (changed);
    }

    private void fixWater() {
        boolean changed;
        BlockSnapshot block;
        int miny = this.miny;
        if (miny < 1) {
            miny = 1;
        }
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = miny; y < this.snapshots[0].length - 1; ++y) {
                    block = this.snapshots[x][y][z];
                    BlockSnapshot underBlock = this.snapshots[x][y--][z];
                    if (block.typeId != Material.WATER && block.typeId != Material.LAVA || underBlock.typeId != Material.AIR && (underBlock.typeId != Material.WATER || ((Levelled)underBlock.data).getLevel() == 0)) continue;
                    block.typeId = Material.AIR;
                }
            }
        }
        do {
            changed = false;
            for (int y = Math.max(this.seaLevel - 10, 0); y <= this.seaLevel; ++y) {
                for (int x = 1; x < this.snapshots.length - 1; ++x) {
                    for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                        block = this.snapshots[x][y][z];
                        if (block.typeId != Material.AIR && (block.typeId != Material.WATER || ((Levelled)block.data).getLevel() == 0)) continue;
                        BlockSnapshot leftBlock = this.snapshots[x + 1][y][z];
                        BlockSnapshot rightBlock = this.snapshots[x - 1][y][z];
                        BlockSnapshot upBlock = this.snapshots[x][y][z + 1];
                        BlockSnapshot downBlock = this.snapshots[x][y][z - 1];
                        BlockSnapshot underBlock = this.snapshots[x][y - 1][z];
                        if (underBlock.typeId != Material.WATER || ((Levelled)underBlock.data).getLevel() != 0) continue;
                        int adjacentSourceWaterCount = 0;
                        if (leftBlock.typeId == Material.WATER && ((Levelled)leftBlock.data).getLevel() == 0) {
                            adjacentSourceWaterCount = (byte)(adjacentSourceWaterCount + 1);
                        }
                        if (rightBlock.typeId == Material.WATER && ((Levelled)rightBlock.data).getLevel() == 0) {
                            adjacentSourceWaterCount = (byte)(adjacentSourceWaterCount + 1);
                        }
                        if (upBlock.typeId == Material.WATER && ((Levelled)upBlock.data).getLevel() == 0) {
                            adjacentSourceWaterCount = (byte)(adjacentSourceWaterCount + 1);
                        }
                        if (downBlock.typeId == Material.WATER && ((Levelled)downBlock.data).getLevel() == 0) {
                            adjacentSourceWaterCount = (byte)(adjacentSourceWaterCount + 1);
                        }
                        if (adjacentSourceWaterCount < 2) continue;
                        block.typeId = Material.WATER;
                        ((Levelled)downBlock.data).setLevel(0);
                        changed = true;
                    }
                }
            }
        } while (changed);
    }

    private void removeDumpedFluids() {
        if (this.seaLevel < 1) {
            return;
        }
        if (this.environment == World.Environment.NETHER) {
            return;
        }
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = this.seaLevel; y < this.snapshots[0].length - 1; ++y) {
                    BlockSnapshot block = this.snapshots[x][y][z];
                    if (block.typeId != Material.WATER && block.typeId != Material.LAVA) continue;
                    block.typeId = Material.AIR;
                }
            }
        }
    }

    private int highestY(int x, int z, boolean ignoreLeaves) {
        int y;
        for (y = this.snapshots[0].length - 1; y > 0; --y) {
            BlockSnapshot block = this.snapshots[x][y][z];
            if (block.typeId == Material.AIR || ignoreLeaves && block.typeId == Material.SNOW || ignoreLeaves && Tag.LEAVES.isTagged((Keyed)block.typeId) || block.typeId == Material.WATER || block.typeId == Material.LAVA) continue;
            return y;
        }
        return y;
    }

    static Set<Material> getPlayerBlocks(World.Environment environment, Biome biome) {
        EnumSet<Material> playerBlocks = EnumSet.noneOf(Material.class);
        playerBlocks.addAll(Tag.ANVIL.getValues());
        playerBlocks.addAll(Tag.BANNERS.getValues());
        playerBlocks.addAll(Tag.BEACON_BASE_BLOCKS.getValues());
        playerBlocks.addAll(Tag.BEDS.getValues());
        playerBlocks.addAll(Tag.BUTTONS.getValues());
        playerBlocks.addAll(Tag.CAMPFIRES.getValues());
        playerBlocks.addAll(Tag.CANDLE_CAKES.getValues());
        playerBlocks.addAll(Tag.CANDLES.getValues());
        playerBlocks.addAll(Tag.CARPETS.getValues());
        playerBlocks.addAll(Tag.CAULDRONS.getValues());
        playerBlocks.addAll(Tag.DOORS.getValues());
        playerBlocks.addAll(Tag.FENCE_GATES.getValues());
        playerBlocks.addAll(Tag.FENCES.getValues());
        playerBlocks.addAll(Tag.FIRE.getValues());
        playerBlocks.addAll(Tag.FLOWER_POTS.getValues());
        playerBlocks.addAll(Tag.IMPERMEABLE.getValues());
        playerBlocks.addAll(Tag.LOGS.getValues());
        playerBlocks.addAll(Tag.PLANKS.getValues());
        playerBlocks.addAll(Tag.PRESSURE_PLATES.getValues());
        playerBlocks.addAll(Tag.RAILS.getValues());
        playerBlocks.addAll(Tag.SHULKER_BOXES.getValues());
        playerBlocks.addAll(Tag.SIGNS.getValues());
        playerBlocks.addAll(Tag.SLABS.getValues());
        playerBlocks.addAll(Tag.STAIRS.getValues());
        playerBlocks.addAll(Tag.STONE_BRICKS.getValues());
        playerBlocks.addAll(Tag.TRAPDOORS.getValues());
        playerBlocks.addAll(Tag.WALLS.getValues());
        playerBlocks.addAll(Tag.WOOL.getValues());
        playerBlocks.add(Material.BOOKSHELF);
        playerBlocks.add(Material.BREWING_STAND);
        playerBlocks.add(Material.BRICK);
        playerBlocks.add(Material.COBBLESTONE);
        playerBlocks.add(Material.LAPIS_BLOCK);
        playerBlocks.add(Material.DISPENSER);
        playerBlocks.add(Material.NOTE_BLOCK);
        playerBlocks.add(Material.STICKY_PISTON);
        playerBlocks.add(Material.PISTON);
        playerBlocks.add(Material.PISTON_HEAD);
        playerBlocks.add(Material.MOVING_PISTON);
        playerBlocks.add(Material.WHEAT);
        playerBlocks.add(Material.TNT);
        playerBlocks.add(Material.MOSSY_COBBLESTONE);
        playerBlocks.add(Material.TORCH);
        playerBlocks.add(Material.CHEST);
        playerBlocks.add(Material.REDSTONE_WIRE);
        playerBlocks.add(Material.CRAFTING_TABLE);
        playerBlocks.add(Material.FURNACE);
        playerBlocks.add(Material.LADDER);
        playerBlocks.add(Material.SCAFFOLDING);
        playerBlocks.add(Material.LEVER);
        playerBlocks.add(Material.REDSTONE_TORCH);
        playerBlocks.add(Material.SNOW_BLOCK);
        playerBlocks.add(Material.JUKEBOX);
        playerBlocks.add(Material.NETHER_PORTAL);
        playerBlocks.add(Material.JACK_O_LANTERN);
        playerBlocks.add(Material.CAKE);
        playerBlocks.add(Material.REPEATER);
        playerBlocks.add(Material.MUSHROOM_STEM);
        playerBlocks.add(Material.RED_MUSHROOM_BLOCK);
        playerBlocks.add(Material.BROWN_MUSHROOM_BLOCK);
        playerBlocks.add(Material.IRON_BARS);
        playerBlocks.add(Material.GLASS_PANE);
        playerBlocks.add(Material.MELON_STEM);
        playerBlocks.add(Material.ENCHANTING_TABLE);
        playerBlocks.add(Material.COBWEB);
        playerBlocks.add(Material.GRAVEL);
        playerBlocks.add(Material.SANDSTONE);
        playerBlocks.add(Material.ENDER_CHEST);
        playerBlocks.add(Material.COMMAND_BLOCK);
        playerBlocks.add(Material.REPEATING_COMMAND_BLOCK);
        playerBlocks.add(Material.CHAIN_COMMAND_BLOCK);
        playerBlocks.add(Material.BEACON);
        playerBlocks.add(Material.CARROT);
        playerBlocks.add(Material.POTATO);
        playerBlocks.add(Material.SKELETON_SKULL);
        playerBlocks.add(Material.WITHER_SKELETON_SKULL);
        playerBlocks.add(Material.CREEPER_HEAD);
        playerBlocks.add(Material.ZOMBIE_HEAD);
        playerBlocks.add(Material.PLAYER_HEAD);
        playerBlocks.add(Material.DRAGON_HEAD);
        playerBlocks.add(Material.SPONGE);
        playerBlocks.add(Material.WHITE_STAINED_GLASS_PANE);
        playerBlocks.add(Material.ORANGE_STAINED_GLASS_PANE);
        playerBlocks.add(Material.MAGENTA_STAINED_GLASS_PANE);
        playerBlocks.add(Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        playerBlocks.add(Material.YELLOW_STAINED_GLASS_PANE);
        playerBlocks.add(Material.LIME_STAINED_GLASS_PANE);
        playerBlocks.add(Material.PINK_STAINED_GLASS_PANE);
        playerBlocks.add(Material.GRAY_STAINED_GLASS_PANE);
        playerBlocks.add(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        playerBlocks.add(Material.CYAN_STAINED_GLASS_PANE);
        playerBlocks.add(Material.PURPLE_STAINED_GLASS_PANE);
        playerBlocks.add(Material.BLUE_STAINED_GLASS_PANE);
        playerBlocks.add(Material.BROWN_STAINED_GLASS_PANE);
        playerBlocks.add(Material.GREEN_STAINED_GLASS_PANE);
        playerBlocks.add(Material.RED_STAINED_GLASS_PANE);
        playerBlocks.add(Material.BLACK_STAINED_GLASS_PANE);
        playerBlocks.add(Material.TRAPPED_CHEST);
        playerBlocks.add(Material.COMPARATOR);
        playerBlocks.add(Material.DAYLIGHT_DETECTOR);
        playerBlocks.add(Material.REDSTONE_BLOCK);
        playerBlocks.add(Material.HOPPER);
        playerBlocks.add(Material.QUARTZ_BLOCK);
        playerBlocks.add(Material.DROPPER);
        playerBlocks.add(Material.SLIME_BLOCK);
        playerBlocks.add(Material.PRISMARINE);
        playerBlocks.add(Material.HAY_BLOCK);
        playerBlocks.add(Material.SEA_LANTERN);
        playerBlocks.add(Material.COAL_BLOCK);
        playerBlocks.add(Material.REDSTONE_LAMP);
        playerBlocks.add(Material.RED_NETHER_BRICKS);
        playerBlocks.add(Material.POLISHED_ANDESITE);
        playerBlocks.add(Material.POLISHED_DIORITE);
        playerBlocks.add(Material.POLISHED_GRANITE);
        playerBlocks.add(Material.POLISHED_BASALT);
        playerBlocks.add(Material.POLISHED_DEEPSLATE);
        playerBlocks.add(Material.DEEPSLATE_BRICKS);
        playerBlocks.add(Material.CRACKED_DEEPSLATE_BRICKS);
        playerBlocks.add(Material.DEEPSLATE_TILES);
        playerBlocks.add(Material.CRACKED_DEEPSLATE_TILES);
        playerBlocks.add(Material.CHISELED_DEEPSLATE);
        playerBlocks.add(Material.RAW_COPPER_BLOCK);
        playerBlocks.add(Material.RAW_IRON_BLOCK);
        playerBlocks.add(Material.RAW_GOLD_BLOCK);
        playerBlocks.add(Material.LIGHTNING_ROD);
        if (environment != World.Environment.NORMAL && environment != World.Environment.CUSTOM) {
            playerBlocks.addAll(Tag.BASE_STONE_OVERWORLD.getValues());
            playerBlocks.addAll(Tag.DIRT.getValues());
            playerBlocks.addAll(Tag.SAND.getValues());
        }
        if (environment != World.Environment.NETHER) {
            playerBlocks.addAll(Tag.NYLIUM.getValues());
            playerBlocks.addAll(Tag.WART_BLOCKS.getValues());
            playerBlocks.addAll(Tag.BASE_STONE_NETHER.getValues());
            playerBlocks.add(Material.POLISHED_BLACKSTONE);
            playerBlocks.add(Material.CHISELED_POLISHED_BLACKSTONE);
            playerBlocks.add(Material.CRACKED_POLISHED_BLACKSTONE_BRICKS);
            playerBlocks.add(Material.GILDED_BLACKSTONE);
            playerBlocks.add(Material.BONE_BLOCK);
            playerBlocks.add(Material.SOUL_SAND);
            playerBlocks.add(Material.SOUL_SOIL);
            playerBlocks.add(Material.GLOWSTONE);
            playerBlocks.add(Material.NETHER_BRICK);
            playerBlocks.add(Material.MAGMA_BLOCK);
            playerBlocks.add(Material.ANCIENT_DEBRIS);
            playerBlocks.add(Material.CHAIN);
            playerBlocks.add(Material.SHROOMLIGHT);
            playerBlocks.add(Material.NETHER_GOLD_ORE);
            playerBlocks.add(Material.NETHER_SPROUTS);
            playerBlocks.add(Material.CRIMSON_FUNGUS);
            playerBlocks.add(Material.CRIMSON_ROOTS);
            playerBlocks.add(Material.NETHER_WART_BLOCK);
            playerBlocks.add(Material.WEEPING_VINES);
            playerBlocks.add(Material.WEEPING_VINES_PLANT);
            playerBlocks.add(Material.WARPED_FUNGUS);
            playerBlocks.add(Material.WARPED_ROOTS);
            playerBlocks.add(Material.WARPED_WART_BLOCK);
            playerBlocks.add(Material.TWISTING_VINES);
            playerBlocks.add(Material.TWISTING_VINES_PLANT);
        } else {
            playerBlocks.remove(Material.CRIMSON_STEM);
            playerBlocks.remove(Material.CRIMSON_HYPHAE);
            playerBlocks.remove(Material.NETHER_BRICK_FENCE);
            playerBlocks.remove(Material.NETHER_BRICK_STAIRS);
            playerBlocks.remove(Material.SOUL_FIRE);
            playerBlocks.remove(Material.WARPED_STEM);
            playerBlocks.remove(Material.WARPED_HYPHAE);
        }
        if (environment != World.Environment.THE_END) {
            playerBlocks.add(Material.CHORUS_PLANT);
            playerBlocks.add(Material.CHORUS_FLOWER);
            playerBlocks.add(Material.END_ROD);
            playerBlocks.add(Material.END_STONE);
            playerBlocks.add(Material.END_STONE_BRICKS);
            playerBlocks.add(Material.OBSIDIAN);
            playerBlocks.add(Material.PURPUR_BLOCK);
            playerBlocks.add(Material.PURPUR_PILLAR);
        } else {
            playerBlocks.remove(Material.PURPUR_SLAB);
            playerBlocks.remove(Material.PURPUR_STAIRS);
        }
        if (SAND_SOIL_BIOMES.contains(biome.getKey()) || environment != World.Environment.NORMAL) {
            playerBlocks.addAll(Tag.LEAVES.getValues());
        } else {
            playerBlocks.remove(Material.OAK_LOG);
            playerBlocks.remove(Material.SPRUCE_LOG);
            playerBlocks.remove(Material.BIRCH_LOG);
            playerBlocks.remove(Material.JUNGLE_LOG);
            playerBlocks.remove(Material.ACACIA_LOG);
            playerBlocks.remove(Material.DARK_OAK_LOG);
        }
        return playerBlocks;
    }
}

