/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention.metrics;

import java.util.concurrent.Callable;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.metrics.Metrics;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class MetricsHandler {
    private final Metrics metrics;

    public MetricsHandler(GriefPrevention plugin, String dataMode) {
        this.metrics = new Metrics((Plugin)plugin);
        try {
            this.addSimplePie("custom_build", plugin.getDescription().getVersion().equals("15.2.2"));
            this.addSimplePie("bukkit_impl", plugin.getServer().getVersion().split("-")[1]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.addSimplePie("lock_death_drops_pvp", plugin.config_lockDeathDropsInPvpWorlds);
        this.addSimplePie("lock_death_drops_nonpvp", plugin.config_lockDeathDropsInNonPvpWorlds);
        boolean pvpApplies = false;
        for (World world : plugin.getServer().getWorlds()) {
            if (!plugin.pvpRulesApply(world)) continue;
            this.addSimplePie("no_pvp_in_player_claims", plugin.config_pvp_noCombatInPlayerLandClaims);
            this.addSimplePie("protect_pets_pvp", plugin.config_pvp_protectPets);
            this.addSimplePie("protect_fresh_spawns_pvp", plugin.config_pvp_protectFreshSpawns);
            pvpApplies = true;
            break;
        }
        this.addSimplePie("uses_pvp", pvpApplies);
        this.addSimplePie("uses_spam", plugin.config_spam_enabled);
        if (plugin.config_spam_enabled) {
            this.addSimplePie("ban_spam_offenders", plugin.config_spam_banOffenders);
            this.addSimplePie("use_ban_command", plugin.config_ban_useCommand);
        }
        this.addSimplePie("endermen_move_blocks", plugin.config_endermenMoveBlocks);
        this.addSimplePie("silverfish_break_blocks", plugin.config_silverfishBreakBlocks);
        this.addSimplePie("rabbits_eat_crops", plugin.config_rabbitsEatCrops);
        this.addSimplePie("zombies_break_doors", plugin.config_zombiesBreakDoors);
        this.addSimplePie("mob_projectiles_change_blocks", plugin.config_mobProjectilesChangeBlocks);
        boolean claimsEnabled = false;
        for (ClaimsMode mode : plugin.config_claims_worldModes.values()) {
            if (mode == ClaimsMode.Disabled) continue;
            claimsEnabled = true;
            break;
        }
        this.addSimplePie("uses_claims", claimsEnabled);
        if (!claimsEnabled) {
            return;
        }
        this.addSimplePie("fire_spreads", plugin.config_fireSpreads);
        this.addSimplePie("fire_destroys", plugin.config_fireDestroys);
        this.addSimplePie("lock_wooden_doors", plugin.config_claims_lockWoodenDoors);
        this.addSimplePie("lock_fence_gates", plugin.config_claims_lockFenceGates);
        this.addSimplePie("lock_trapdoors", plugin.config_claims_lockTrapDoors);
        this.addSimplePie("protect_horses", plugin.config_claims_protectHorses);
        this.addSimplePie("protect_donkeys", plugin.config_claims_protectDonkeys);
        this.addSimplePie("protect_llamas", plugin.config_claims_protectLlamas);
        this.addSimplePie("protect_creatures", plugin.config_claims_protectCreatures);
        this.addSimplePie("prevent_buttons_switches", plugin.config_claims_preventButtonsSwitches);
        this.addSimplePie("prevent_theft", plugin.config_claims_preventTheft);
        this.addSimplePie("ender_pearls_require_accesstrust", plugin.config_claims_enderPearlsRequireAccessTrust);
        this.addSimplePie("raid_triggers_require_buildtrust", plugin.config_claims_raidTriggersRequireBuildTrust);
        this.addSimplePie("villager_trading_requires_trust", plugin.config_claims_villagerTradingRequiresTrust);
        this.addSimplePie("lectern_reading_requires_accesstrust", plugin.config_claims_lecternReadingRequiresAccessTrust);
        this.addSimplePie("survival_nature_restoration", plugin.config_claims_survivalAutoNatureRestoration);
        this.addSimplePie("prevent_portals", plugin.config_claims_preventNonPlayerCreatedPortals);
        this.addSimplePie("block_sky_trees", plugin.config_blockSkyTrees);
        this.addSimplePie("limit_tree_growth", plugin.config_limitTreeGrowth);
        this.addSimplePie("pistons_only_work_in_claims", plugin.config_pistonMovement.name().toLowerCase().replace('_', ' '));
        this.addSimplePie("creatures_trample_crops", plugin.config_creaturesTrampleCrops);
        this.addSimplePie("ravagers_break_blocks", plugin.config_claims_ravagersBreakBlocks);
        this.addSimplePie("claim_tool", plugin.config_claims_modificationTool.name());
        this.addSimplePie("claim_inspect_tool", plugin.config_claims_investigationTool.name());
        this.addSimplePie("block_surface_creeper_explosions", plugin.config_blockSurfaceCreeperExplosions);
        this.addSimplePie("block_surface_other_explosions", plugin.config_blockSurfaceOtherExplosions);
        this.addSimplePie("endermen_move_blocks", plugin.config_endermenMoveBlocks);
        this.addSimplePie("storage_mode", dataMode);
        this.addSimplePie("uses_siege", !plugin.config_siege_enabledWorlds.isEmpty());
        this.addSimplePie("uses_claims_survival", () -> String.valueOf(plugin.config_claims_worldModes.values().stream().anyMatch(mode -> mode == ClaimsMode.Survival)));
        this.addSimplePie("uses_claims_survival_req_claim", () -> String.valueOf(plugin.config_claims_worldModes.values().stream().anyMatch(mode -> mode == ClaimsMode.SurvivalRequiringClaims)));
        this.addSimplePie("uses_claims_creative", () -> String.valueOf(plugin.config_claims_worldModes.values().stream().anyMatch(mode -> mode == ClaimsMode.Creative)));
        this.addSimplePie("supply_player_manual", plugin.config_claims_supplyPlayerManual);
        this.addSimplePie("manual_delivery_delay", String.valueOf(plugin.config_claims_manualDeliveryDelaySeconds));
        this.addSimplePie("uses_claimblock_economy", plugin.config_economy_claimBlocksPurchaseCost != 0.0 || plugin.config_economy_claimBlocksSellValue != 0.0);
    }

    private void addSimplePie(String id, boolean value) {
        this.addSimplePie(id, Boolean.toString(value));
    }

    private void addSimplePie(String id, final String value) {
        this.addSimplePie(id, new Callable<String>(){

            @Override
            public String call() throws Exception {
                return value;
            }
        });
    }

    private void addSimplePie(String id, Callable<String> callable) {
        this.metrics.addCustomChart(new Metrics.SimplePie(id, callable));
    }
}

