/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention.events;

import java.util.UUID;
import java.util.function.Supplier;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.events.ClaimEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaimPermissionCheckEvent
extends ClaimEvent
implements Cancellable {
    @Nullable
    private final Player checkedPlayer;
    @NotNull
    private final UUID checkedUUID;
    @NotNull
    private final ClaimPermission requiredPermission;
    @Nullable
    private final Event triggeringEvent;
    @Nullable
    private Supplier<String> cancelReason = null;
    private static final HandlerList HANDLERS = new HandlerList();

    public ClaimPermissionCheckEvent(@NotNull Player checked, @NotNull Claim claim, @NotNull ClaimPermission required, @Nullable Event triggeringEvent) {
        this(checked, checked.getUniqueId(), claim, required, triggeringEvent);
    }

    public ClaimPermissionCheckEvent(@NotNull UUID checked, @NotNull Claim claim, @NotNull ClaimPermission required, @Nullable Event triggeringEvent) {
        this(Bukkit.getPlayer((UUID)checked), checked, claim, required, triggeringEvent);
    }

    private ClaimPermissionCheckEvent(@Nullable Player checkedPlayer, @NotNull UUID checkedUUID, @NotNull Claim claim, @NotNull ClaimPermission required, @Nullable Event triggeringEvent) {
        super(claim);
        this.checkedPlayer = checkedPlayer;
        this.checkedUUID = checkedUUID;
        this.requiredPermission = required;
        this.triggeringEvent = triggeringEvent;
    }

    @Nullable
    public Player getCheckedPlayer() {
        return this.checkedPlayer;
    }

    @NotNull
    public UUID getCheckedUUID() {
        return this.checkedUUID;
    }

    @NotNull
    public ClaimPermission getRequiredPermission() {
        return this.requiredPermission;
    }

    @Nullable
    public Event getTriggeringEvent() {
        return this.triggeringEvent;
    }

    public boolean isCancelled() {
        return this.cancelReason != null;
    }

    @Deprecated
    public void setCancelled(boolean cancelled) {
        this.cancelReason = !cancelled ? null : () -> "";
    }

    @Nullable
    public Supplier<String> getDenialReason() {
        return this.cancelReason;
    }

    public void setDenialReason(@Nullable Supplier<String> denial) {
        this.cancelReason = denial;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }
}

