/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.OfflinePlayer;

class UUIDFetcher {
    private static int PROFILES_PER_REQUEST = 100;
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    private final Gson gson = new Gson();
    private final List<String> names;
    private final boolean rateLimiting;
    static HashMap<String, UUID> lookupCache;
    static HashMap<String, String> correctedNames;

    public UUIDFetcher(List<String> names, boolean rateLimiting) {
        this.names = names;
        this.rateLimiting = rateLimiting;
    }

    public UUIDFetcher(List<String> names) {
        this(names, true);
    }

    public void call() throws Exception {
        int i;
        OfflinePlayer[] players;
        if (lookupCache == null) {
            lookupCache = new HashMap();
        }
        if (correctedNames == null) {
            correctedNames = new HashMap();
        }
        GriefPrevention.AddLogEntry("UUID conversion process started.  Please be patient - this may take a while.");
        GriefPrevention.AddLogEntry("Mining your local world data to save calls to Mojang...");
        for (OfflinePlayer player : players = GriefPrevention.instance.getServer().getOfflinePlayers()) {
            if (player.getName() == null || player.getUniqueId() == null) continue;
            lookupCache.put(player.getName(), player.getUniqueId());
            lookupCache.put(player.getName().toLowerCase(), player.getUniqueId());
            correctedNames.put(player.getName().toLowerCase(), player.getName());
        }
        GriefPrevention.AddLogEntry("Checking local server data to get correct casing for player names...");
        for (i = 0; i < this.names.size(); ++i) {
            String name2 = this.names.get(i);
            String correctCasingName = correctedNames.get(name2);
            if (correctCasingName == null || name2.equals(correctCasingName)) continue;
            GriefPrevention.AddLogEntry(name2 + " --> " + correctCasingName);
            this.names.set(i, correctCasingName);
        }
        GriefPrevention.AddLogEntry("Checking local server data for UUIDs already seen...");
        for (i = 0; i < this.names.size(); ++i) {
            String name3 = this.names.get(i);
            UUID uuid = lookupCache.get(name3);
            if (uuid == null) continue;
            GriefPrevention.AddLogEntry(name3 + " --> " + uuid.toString());
            this.names.remove(i--);
        }
        this.names.removeIf(Objects::isNull);
        if (GriefPrevention.instance.getServer().getOnlineMode()) {
            Pattern validNamePattern = Pattern.compile("^\\w+$");
            this.names.removeIf(name -> {
                if (name.length() >= 3 && name.length() <= 16 && validNamePattern.matcher((CharSequence)name).find()) {
                    return false;
                }
                GriefPrevention.AddLogEntry(String.format("Cannot convert invalid name: %s", name));
                return true;
            });
            GriefPrevention.AddLogEntry("Calling Mojang to get UUIDs for remaining unresolved players (this is the slowest step)...");
            int i2 = 0;
            while (i2 * PROFILES_PER_REQUEST < this.names.size()) {
                boolean retry = false;
                JsonArray array = null;
                do {
                    HttpURLConnection connection = UUIDFetcher.createConnection();
                    String body = this.gson.toJson(this.names.subList(i2 * PROFILES_PER_REQUEST, Math.min((i2 + 1) * PROFILES_PER_REQUEST, this.names.size())));
                    UUIDFetcher.writeBody(connection, body);
                    retry = false;
                    array = null;
                    try {
                        array = (JsonArray)this.gson.fromJson((Reader)new InputStreamReader(connection.getInputStream()), JsonArray.class);
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("429")) {
                            retry = true;
                            if (i2 == 0 && PROFILES_PER_REQUEST > 1) {
                                GriefPrevention.AddLogEntry("Batch size " + PROFILES_PER_REQUEST + " seems too large.  Looking for a workable batch size...");
                                PROFILES_PER_REQUEST = Math.max(PROFILES_PER_REQUEST - 5, 1);
                                continue;
                            }
                            GriefPrevention.AddLogEntry("Mojang says we're sending requests too fast.  Will retry every 30 seconds until we succeed...");
                            Thread.sleep(30000L);
                            continue;
                        }
                        throw e;
                    }
                } while (retry);
                for (JsonElement profile : array) {
                    JsonObject jsonProfile = profile.getAsJsonObject();
                    String id = jsonProfile.get("id").getAsString();
                    String name4 = jsonProfile.get("name").getAsString();
                    UUID uuid = UUIDFetcher.getUUID(id);
                    GriefPrevention.AddLogEntry(name4 + " --> " + uuid.toString());
                    lookupCache.put(name4, uuid);
                    lookupCache.put(name4.toLowerCase(), uuid);
                }
                if (this.rateLimiting) {
                    Thread.sleep(200L);
                }
                ++i2;
            }
        } else {
            GriefPrevention.AddLogEntry("Generating offline mode UUIDs for remaining unresolved players...");
            for (String name5 : this.names) {
                UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name5).getBytes(Charsets.UTF_8));
                GriefPrevention.AddLogEntry(name5 + " --> " + uuid.toString());
                lookupCache.put(name5, uuid);
                lookupCache.put(name5.toLowerCase(), uuid);
            }
        }
    }

    private static void writeBody(HttpURLConnection connection, String body) throws Exception {
        OutputStream stream = connection.getOutputStream();
        stream.write(body.getBytes());
        stream.flush();
        stream.close();
    }

    private static HttpURLConnection createConnection() throws Exception {
        URL url = new URL(PROFILE_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        return connection;
    }

    private static UUID getUUID(String id) {
        return UUID.fromString(id.substring(0, 8) + "-" + id.substring(8, 12) + "-" + id.substring(12, 16) + "-" + id.substring(16, 20) + "-" + id.substring(20, 32));
    }

    public static byte[] toBytes(UUID uuid) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uuid.getMostSignificantBits());
        byteBuffer.putLong(uuid.getLeastSignificantBits());
        return byteBuffer.array();
    }

    public static UUID fromBytes(byte[] array) {
        if (array.length != 16) {
            throw new IllegalArgumentException("Illegal byte array length: " + array.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        long mostSignificant = byteBuffer.getLong();
        long leastSignificant = byteBuffer.getLong();
        return new UUID(mostSignificant, leastSignificant);
    }

    public static UUID getUUIDOf(String name) throws Exception {
        UUID result = lookupCache.get(name);
        if (result == null) {
            throw new IllegalArgumentException(name);
        }
        return result;
    }
}

