/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.ryanhamshire.GriefPrevention.ChatterData;
import me.ryanhamshire.GriefPrevention.SpamAnalysisResult;

class SpamDetector {
    private String lastChatMessage = "";
    private long lastChatMessageTimestamp = 0L;
    private int duplicateMessageCount = 0;
    ConcurrentHashMap<UUID, ChatterData> dataStore = new ConcurrentHashMap();

    SpamDetector() {
    }

    private ChatterData getChatterData(UUID chatterID) {
        ChatterData data = this.dataStore.get(chatterID);
        if (data == null) {
            data = new ChatterData();
            this.dataStore.put(chatterID, data);
        }
        return data;
    }

    SpamAnalysisResult AnalyzeMessage(UUID chatterID, String message, long timestamp) {
        SpamAnalysisResult result = new SpamAnalysisResult();
        result.finalMessage = message;
        if (message.length() > 4 && this.stringsAreSimilar(message.toUpperCase(), message)) {
            result.finalMessage = message = message.toLowerCase();
        }
        boolean spam = false;
        ChatterData chatterData = this.getChatterData(chatterID);
        if (message.length() > 50 && chatterData.getTotalRecentLength(timestamp) > 200) {
            spam = true;
            result.muteReason = "too much chat sent in 10 seconds";
            ++chatterData.spamLevel;
        }
        if (result.finalMessage.equals(this.lastChatMessage) && timestamp - this.lastChatMessageTimestamp < 2000L) {
            chatterData.spamLevel += ++this.duplicateMessageCount;
            spam = true;
            result.muteReason = "repeat message";
        } else {
            this.lastChatMessage = message;
            this.lastChatMessageTimestamp = timestamp;
            this.duplicateMessageCount = 0;
        }
        long millisecondsSinceLastMessage = timestamp - chatterData.lastMessageTimestamp;
        if (millisecondsSinceLastMessage < 1500L) {
            ++chatterData.spamLevel;
            spam = true;
        }
        if (result.muteReason == null && millisecondsSinceLastMessage < 30000L && result.finalMessage.equalsIgnoreCase(chatterData.lastMessage)) {
            ++chatterData.spamLevel;
            spam = true;
            result.muteReason = "repeat message";
        }
        if (result.muteReason == null && millisecondsSinceLastMessage < 10000L && this.stringsAreSimilar(message.toLowerCase(), chatterData.lastMessage.toLowerCase())) {
            ++chatterData.spamLevel;
            spam = true;
            if (chatterData.spamLevel > 2) {
                result.muteReason = "similar message";
            }
        }
        if (result.muteReason == null && message.length() > 5) {
            int symbolsCount = 0;
            int whitespaceCount = 0;
            for (int i = 0; i < message.length(); ++i) {
                char character = message.charAt(i);
                if (!Character.isLetterOrDigit(character)) {
                    ++symbolsCount;
                }
                if (!Character.isWhitespace(character)) continue;
                ++whitespaceCount;
            }
            if (symbolsCount > message.length() / 2 || message.length() > 15 && whitespaceCount < message.length() / 10) {
                spam = true;
                if (chatterData.spamLevel > 0) {
                    result.muteReason = "gibberish";
                }
                ++chatterData.spamLevel;
            }
        }
        if (result.muteReason == null && message.length() < 5 && millisecondsSinceLastMessage < 3000L) {
            spam = true;
            ++chatterData.spamLevel;
        }
        if (spam) {
            if (chatterData.spamLevel > 8 && chatterData.spamWarned) {
                result.shouldBanChatter = true;
            } else if (chatterData.spamLevel >= 4) {
                if (!chatterData.spamWarned) {
                    chatterData.spamWarned = true;
                    result.shouldWarnChatter = true;
                }
                if (result.muteReason == null) {
                    result.muteReason = "too-frequent text";
                }
            }
        } else {
            chatterData.spamLevel = 0;
            chatterData.spamWarned = false;
        }
        chatterData.AddMessage(message, timestamp);
        return result;
    }

    private boolean stringsAreSimilar(String message, String lastMessage) {
        int i;
        String longerString;
        String shorterString;
        message = message.replaceAll("[^\\p{Alpha}]", "");
        if ((lastMessage = lastMessage.replaceAll("[^\\p{Alpha}]", "")).length() < message.length()) {
            shorterString = lastMessage;
            longerString = message;
        } else {
            shorterString = message;
            longerString = lastMessage;
        }
        if (shorterString.length() <= 5) {
            return shorterString.equals(longerString);
        }
        int maxIdenticalCharacters = longerString.length() - longerString.length() / 4;
        if (shorterString.length() < maxIdenticalCharacters) {
            return false;
        }
        int identicalCount = 0;
        for (i = 0; i < shorterString.length(); ++i) {
            if (shorterString.charAt(i) == longerString.charAt(i)) {
                ++identicalCount;
            }
            if (identicalCount <= maxIdenticalCharacters) continue;
            return true;
        }
        for (int j = 0; j < shorterString.length() - i; ++j) {
            if (shorterString.charAt(shorterString.length() - j - 1) == longerString.charAt(longerString.length() - j - 1)) {
                ++identicalCount;
            }
            if (identicalCount <= maxIdenticalCharacters) continue;
            return true;
        }
        return false;
    }
}

