/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.VisualizationApplicationTask;
import me.ryanhamshire.GriefPrevention.VisualizationElement;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class Visualization {
    public ArrayList<VisualizationElement> elements = new ArrayList();

    public static void Apply(Player player, Visualization visualization) {
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.currentVisualization != null) {
            Visualization.Revert(player);
        }
        if (player.isOnline() && visualization.elements.size() > 0 && visualization.elements.get((int)0).location.getWorld().equals(player.getWorld())) {
            GriefPrevention.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)GriefPrevention.instance, (Runnable)new VisualizationApplicationTask(player, playerData, visualization), 1L);
        }
    }

    public static void Revert(Player player) {
        if (!player.isOnline()) {
            return;
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        Visualization visualization = playerData.currentVisualization;
        if (playerData.currentVisualization != null) {
            int minx = player.getLocation().getBlockX() - 100;
            int minz = player.getLocation().getBlockZ() - 100;
            int maxx = player.getLocation().getBlockX() + 100;
            int maxz = player.getLocation().getBlockZ() + 100;
            visualization.removeElementsOutOfRange(visualization.elements, minx, minz, maxx, maxz);
            for (int i = 0; i < visualization.elements.size(); ++i) {
                VisualizationElement element = visualization.elements.get(i);
                if (i == 0 && !player.getWorld().equals(element.location.getWorld())) {
                    return;
                }
                player.sendBlockChange(element.location, element.realBlock);
            }
            playerData.currentVisualization = null;
        }
    }

    public static Visualization FromClaim(Claim claim, int height, VisualizationType visualizationType, Location locality) {
        if (claim.parent != null) {
            return Visualization.FromClaim(claim.parent, height, visualizationType, locality);
        }
        Visualization visualization = new Visualization();
        for (int i = 0; i < claim.children.size(); ++i) {
            Claim child = claim.children.get(i);
            if (!child.inDataStore) continue;
            visualization.addClaimElements(child, height, VisualizationType.Subdivision, locality);
        }
        if (claim.isAdminClaim() && visualizationType == VisualizationType.Claim) {
            visualizationType = VisualizationType.AdminClaim;
        }
        visualization.addClaimElements(claim, height, visualizationType, locality);
        return visualization;
    }

    public void addClaimElements(Claim claim, int height, VisualizationType visualizationType, Location locality) {
        BlockData accentBlockData;
        BlockData cornerBlockData;
        if (visualizationType == VisualizationType.Claim) {
            cornerBlockData = Material.GLOWSTONE.createBlockData();
            accentBlockData = Material.GOLD_BLOCK.createBlockData();
        } else if (visualizationType == VisualizationType.AdminClaim) {
            cornerBlockData = Material.GLOWSTONE.createBlockData();
            accentBlockData = Material.PUMPKIN.createBlockData();
        } else if (visualizationType == VisualizationType.Subdivision) {
            cornerBlockData = Material.IRON_BLOCK.createBlockData();
            accentBlockData = Material.WHITE_WOOL.createBlockData();
        } else if (visualizationType == VisualizationType.RestoreNature) {
            cornerBlockData = Material.DIAMOND_BLOCK.createBlockData();
            accentBlockData = Material.DIAMOND_BLOCK.createBlockData();
        } else {
            cornerBlockData = Material.REDSTONE_ORE.createBlockData();
            ((Lightable)cornerBlockData).setLit(true);
            accentBlockData = Material.NETHERRACK.createBlockData();
        }
        this.addClaimElements(claim.getLesserBoundaryCorner(), claim.getGreaterBoundaryCorner(), locality, height, cornerBlockData, accentBlockData, 10);
    }

    public void addClaimElements(Location min, Location max, Location locality, int height, BlockData cornerBlockData, BlockData accentBlockData, int STEP) {
        int z;
        int x;
        World world = min.getWorld();
        boolean waterIsTransparent = locality.getBlock().getType() == Material.WATER;
        int smallx = min.getBlockX();
        int smallz = min.getBlockZ();
        int bigx = max.getBlockX();
        int bigz = max.getBlockZ();
        ArrayList<VisualizationElement> newElements = new ArrayList<VisualizationElement>();
        int minx = locality.getBlockX() - 75;
        int minz = locality.getBlockZ() - 75;
        int maxx = locality.getBlockX() + 75;
        int maxz = locality.getBlockZ() + 75;
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)bigz), cornerBlockData, Material.AIR.createBlockData()));
        newElements.add(new VisualizationElement(new Location(world, (double)(smallx + 1), 0.0, (double)bigz), accentBlockData, Material.AIR.createBlockData()));
        for (x = smallx + STEP; x < bigx - STEP / 2; x += STEP) {
            if (x <= minx || x >= maxx) continue;
            newElements.add(new VisualizationElement(new Location(world, (double)x, 0.0, (double)bigz), accentBlockData, Material.AIR.createBlockData()));
        }
        newElements.add(new VisualizationElement(new Location(world, (double)(bigx - 1), 0.0, (double)bigz), accentBlockData, Material.AIR.createBlockData()));
        newElements.add(new VisualizationElement(new Location(world, (double)(smallx + 1), 0.0, (double)smallz), accentBlockData, Material.AIR.createBlockData()));
        for (x = smallx + STEP; x < bigx - STEP / 2; x += STEP) {
            if (x <= minx || x >= maxx) continue;
            newElements.add(new VisualizationElement(new Location(world, (double)x, 0.0, (double)smallz), accentBlockData, Material.AIR.createBlockData()));
        }
        newElements.add(new VisualizationElement(new Location(world, (double)(bigx - 1), 0.0, (double)smallz), accentBlockData, Material.AIR.createBlockData()));
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)smallz), cornerBlockData, Material.AIR.createBlockData()));
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)(smallz + 1)), accentBlockData, Material.AIR.createBlockData()));
        for (z = smallz + STEP; z < bigz - STEP / 2; z += STEP) {
            if (z <= minz || z >= maxz) continue;
            newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)z), accentBlockData, Material.AIR.createBlockData()));
        }
        newElements.add(new VisualizationElement(new Location(world, (double)smallx, 0.0, (double)(bigz - 1)), accentBlockData, Material.AIR.createBlockData()));
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)smallz), cornerBlockData, Material.AIR.createBlockData()));
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)(smallz + 1)), accentBlockData, Material.AIR.createBlockData()));
        for (z = smallz + STEP; z < bigz - STEP / 2; z += STEP) {
            if (z <= minz || z >= maxz) continue;
            newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)z), accentBlockData, Material.AIR.createBlockData()));
        }
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)(bigz - 1)), accentBlockData, Material.AIR.createBlockData()));
        newElements.add(new VisualizationElement(new Location(world, (double)bigx, 0.0, (double)bigz), cornerBlockData, Material.AIR.createBlockData()));
        this.removeElementsOutOfRange(newElements, minx, minz, maxx, maxz);
        BoundingBox box = BoundingBox.of((Location)min, (Location)max);
        for (int i = 0; i < newElements.size(); ++i) {
            VisualizationElement element = newElements.get(i);
            if (this.containsIncludingIgnoringHeight(box, element.location.toVector())) continue;
            newElements.remove(i--);
        }
        for (VisualizationElement element : newElements) {
            Location tempLocation = element.location;
            element.location = Visualization.getVisibleLocation(tempLocation.getWorld(), tempLocation.getBlockX(), height, tempLocation.getBlockZ(), waterIsTransparent);
            height = element.location.getBlockY();
            element.realBlock = element.location.getBlock().getBlockData();
        }
        this.elements.addAll(newElements);
    }

    private boolean containsIncludingIgnoringHeight(BoundingBox box, Vector vector) {
        return (double)vector.getBlockX() >= box.getMinX() && (double)vector.getBlockX() <= box.getMaxX() && (double)vector.getBlockZ() >= box.getMinZ() && (double)vector.getBlockZ() <= box.getMaxZ();
    }

    private void removeElementsOutOfRange(ArrayList<VisualizationElement> elements, int minx, int minz, int maxx, int maxz) {
        for (int i = 0; i < elements.size(); ++i) {
            Location location = elements.get((int)i).location;
            if (!(location.getX() < (double)minx || location.getX() > (double)maxx || location.getZ() < (double)minz) && !(location.getZ() > (double)maxz)) continue;
            elements.remove(i--);
        }
    }

    private static Location getVisibleLocation(World world, int x, int y, int z, boolean waterIsTransparent) {
        BlockFace direction;
        Block block = world.getBlockAt(x, y, z);
        BlockFace blockFace = direction = Visualization.isTransparent(block, waterIsTransparent) ? BlockFace.DOWN : BlockFace.UP;
        while (block.getY() >= 1 && block.getY() < world.getMaxHeight() - 1 && (!Visualization.isTransparent(block.getRelative(BlockFace.UP), waterIsTransparent) || Visualization.isTransparent(block, waterIsTransparent))) {
            block = block.getRelative(direction);
        }
        return block.getLocation();
    }

    private static boolean isTransparent(Block block, boolean waterIsTransparent) {
        Material blockMaterial = block.getType();
        switch (blockMaterial) {
            case SNOW: {
                return false;
            }
        }
        switch (blockMaterial) {
            case AIR: 
            case OAK_FENCE: 
            case ACACIA_FENCE: 
            case BIRCH_FENCE: 
            case DARK_OAK_FENCE: 
            case JUNGLE_FENCE: 
            case NETHER_BRICK_FENCE: 
            case SPRUCE_FENCE: 
            case OAK_FENCE_GATE: 
            case ACACIA_FENCE_GATE: 
            case BIRCH_FENCE_GATE: 
            case DARK_OAK_FENCE_GATE: 
            case SPRUCE_FENCE_GATE: 
            case JUNGLE_FENCE_GATE: {
                return true;
            }
        }
        if (Tag.SIGNS.isTagged((Keyed)blockMaterial) || Tag.WALL_SIGNS.isTagged((Keyed)blockMaterial)) {
            return true;
        }
        return waterIsTransparent && block.getType() == Material.WATER || block.getType().isTransparent();
    }

    public static Visualization fromClaims(Iterable<Claim> claims, int height, VisualizationType type, Location locality) {
        Visualization visualization = new Visualization();
        for (Claim claim : claims) {
            visualization.addClaimElements(claim, height, type, locality);
        }
        return visualization;
    }
}

