/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import me.ryanhamshire.GriefPrevention.BlockSnapshot;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;

class RestoreNatureExecutionTask
implements Runnable {
    private final BlockSnapshot[][][] snapshots;
    private final int miny;
    private final Location lesserCorner;
    private final Location greaterCorner;
    private final Player player;

    public RestoreNatureExecutionTask(BlockSnapshot[][][] snapshots, int miny, Location lesserCorner, Location greaterCorner, Player player) {
        this.snapshots = snapshots;
        this.miny = miny;
        this.lesserCorner = lesserCorner;
        this.greaterCorner = greaterCorner;
        this.player = player;
    }

    @Override
    public void run() {
        Entity[] entities;
        Claim cachedClaim = null;
        for (int x = 1; x < this.snapshots.length - 1; ++x) {
            block3: for (int z = 1; z < this.snapshots[0][0].length - 1; ++z) {
                for (int y = this.miny; y < this.snapshots[0].length; ++y) {
                    BlockSnapshot blockUpdate = this.snapshots[x][y][z];
                    Block currentBlock = blockUpdate.location.getBlock();
                    if (blockUpdate.typeId == currentBlock.getType() && blockUpdate.data.equals(currentBlock.getBlockData())) continue;
                    Claim claim = GriefPrevention.instance.dataStore.getClaimAt(blockUpdate.location, false, cachedClaim);
                    if (claim != null) {
                        cachedClaim = claim;
                        continue block3;
                    }
                    try {
                        currentBlock.setType(blockUpdate.typeId, false);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        Chunk chunk = this.lesserCorner.getChunk();
        for (Entity entity : entities = chunk.getEntities()) {
            if (!(entity instanceof Player) && !(entity instanceof Animals)) {
                if (entity instanceof Hanging && GriefPrevention.instance.dataStore.getClaimAt(entity.getLocation(), false, null) != null) continue;
                entity.remove();
                continue;
            }
            Block feetBlock = entity.getLocation().getBlock();
            feetBlock.setType(Material.AIR);
            feetBlock.getRelative(BlockFace.UP).setType(Material.AIR);
        }
        if (this.player != null) {
            Claim claim = new Claim(this.lesserCorner, this.greaterCorner, null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null);
            Visualization visualization = Visualization.FromClaim(claim, this.player.getLocation().getBlockY(), VisualizationType.RestoreNature, this.player.getLocation());
            Visualization.Apply(this.player, visualization);
        }
    }
}

