/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import me.ryanhamshire.GriefPrevention.BroadcastMessageTask;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.CommandCategory;
import me.ryanhamshire.GriefPrevention.CreateClaimResult;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.EquipShovelProcessingTask;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.IgnoreLoaderThread;
import me.ryanhamshire.GriefPrevention.IpBanInfo;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.PlayerKickBanTask;
import me.ryanhamshire.GriefPrevention.ShovelMode;
import me.ryanhamshire.GriefPrevention.SpamAnalysisResult;
import me.ryanhamshire.GriefPrevention.SpamDetector;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import me.ryanhamshire.GriefPrevention.WelcomeTask;
import me.ryanhamshire.GriefPrevention.WordFinder;
import me.ryanhamshire.GriefPrevention.events.ClaimInspectionEvent;
import me.ryanhamshire.GriefPrevention.events.VisualizationEvent;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.BlockIterator;

class PlayerEventHandler
implements Listener {
    private final DataStore dataStore;
    private final GriefPrevention instance;
    private final ArrayList<IpBanInfo> tempBannedIps = new ArrayList();
    private final long MILLISECONDS_IN_DAY = 86400000L;
    private final ArrayList<Long> recentLoginLogoutNotifications = new ArrayList();
    private Pattern howToClaimPattern = null;
    private final WordFinder bannedWordFinder;
    SpamDetector spamDetector = new SpamDetector();
    private final ConcurrentHashMap<String, CommandCategory> commandCategoryMap = new ConcurrentHashMap();
    static int longestNameLength = 10;
    private final ConcurrentHashMap<UUID, Date> lastLoginThisServerSessionMap = new ConcurrentHashMap();
    private final HashMap<UUID, Long> deathTimestamps = new HashMap();
    private final HashMap<UUID, Integer> heldLogoutMessages = new HashMap();
    private final Set<Material> commonAdjacentBlocks_water = EnumSet.of(Material.WATER, Material.FARMLAND, Material.DIRT, Material.STONE);
    private final Set<Material> commonAdjacentBlocks_lava = EnumSet.of(Material.LAVA, Material.DIRT, Material.STONE);
    private final ConcurrentHashMap<Material, Boolean> inventoryHolderCache = new ConcurrentHashMap();

    PlayerEventHandler(DataStore dataStore, GriefPrevention plugin) {
        this.dataStore = dataStore;
        this.instance = plugin;
        this.bannedWordFinder = new WordFinder(this.instance.dataStore.loadBannedWords());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    synchronized void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!player.isOnline()) {
            event.setCancelled(true);
            return;
        }
        String message = event.getMessage();
        boolean muted = this.handlePlayerChat(player, message, (PlayerEvent)event);
        Set recipients = event.getRecipients();
        if (muted) {
            recipients.clear();
            recipients.add(player);
        } else if (this.dataStore.isSoftMuted(player.getUniqueId())) {
            String notificationMessage = "(Muted " + player.getName() + "): " + message;
            HashSet<Player> recipientsToKeep = new HashSet<Player>();
            for (Player recipient : recipients) {
                if (this.dataStore.isSoftMuted(recipient.getUniqueId())) {
                    recipientsToKeep.add(recipient);
                    continue;
                }
                if (!recipient.hasPermission("griefprevention.eavesdrop")) continue;
                recipient.sendMessage(ChatColor.GRAY + notificationMessage);
            }
            recipients.clear();
            recipients.addAll(recipientsToKeep);
            GriefPrevention.AddLogEntry(notificationMessage, CustomLogEntryTypes.MutedChat, false);
        } else if (!player.hasPermission("griefprevention.spam") && this.bannedWordFinder.hasMatch(message)) {
            String notificationMessage = "(Muted " + player.getName() + "): " + message;
            for (Player recipient : recipients) {
                if (!recipient.hasPermission("griefprevention.eavesdrop")) continue;
                recipient.sendMessage(ChatColor.GRAY + notificationMessage);
            }
            recipients.clear();
            recipients.add(player);
            if (!GriefPrevention.isNewToServer(player)) {
                PlayerData playerData = this.instance.dataStore.getPlayerData(player.getUniqueId());
                if (!playerData.profanityWarned) {
                    playerData.profanityWarned = true;
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoProfanity, new String[0]);
                    event.setCancelled(true);
                    return;
                }
            } else if (this.instance.config_trollFilterEnabled) {
                GriefPrevention.AddLogEntry("Auto-muted new player " + player.getName() + " for profanity shortly after join.  Use /SoftMute to undo.", CustomLogEntryTypes.AdminActivity);
                GriefPrevention.AddLogEntry(notificationMessage, CustomLogEntryTypes.MutedChat, false);
                this.instance.dataStore.toggleSoftMute(player.getUniqueId());
            }
        } else {
            PlayerEventHandler.makeSocialLogEntry(player.getName(), message);
            if (!player.hasPermission("griefprevention.notignorable")) {
                HashSet<Player> recipientsToRemove = new HashSet<Player>();
                PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
                for (Player recipient : recipients) {
                    if (recipient.hasPermission("griefprevention.notignorable")) continue;
                    if (playerData.ignoredPlayers.containsKey(recipient.getUniqueId())) {
                        recipientsToRemove.add(recipient);
                        continue;
                    }
                    PlayerData targetPlayerData = this.dataStore.getPlayerData(recipient.getUniqueId());
                    if (!targetPlayerData.ignoredPlayers.containsKey(player.getUniqueId())) continue;
                    recipientsToRemove.add(recipient);
                }
                recipients.removeAll(recipientsToRemove);
            }
        }
    }

    private boolean handlePlayerChat(Player player, String message, PlayerEvent event) {
        String trappedwords;
        if (this.howToClaimPattern == null) {
            this.howToClaimPattern = Pattern.compile(this.dataStore.getMessage(Messages.HowToClaimRegex, new String[0]), 2);
        }
        if (this.howToClaimPattern.matcher(message).matches()) {
            if (this.instance.creativeRulesApply(player.getLocation())) {
                GriefPrevention.sendMessage(player, TextMode.Info, Messages.CreativeBasicsVideo2, 10L, DataStore.CREATIVE_VIDEO_URL);
            } else {
                GriefPrevention.sendMessage(player, TextMode.Info, Messages.SurvivalBasicsVideo2, 10L, DataStore.SURVIVAL_VIDEO_URL);
            }
        }
        if (!(trappedwords = this.dataStore.getMessage(Messages.TrappedChatKeyword, new String[0])).isEmpty()) {
            String[] checkWords;
            for (String checkWord : checkWords = trappedwords.split(";")) {
                if (message.contains("/trapped") || !message.contains(checkWord)) continue;
                GriefPrevention.sendMessage(player, TextMode.Info, Messages.TrappedInstructions, 10L, new String[0]);
                break;
            }
        }
        if (!this.instance.config_spam_enabled) {
            return false;
        }
        if (player.hasPermission("griefprevention.spam")) {
            return false;
        }
        SpamAnalysisResult result = this.spamDetector.AnalyzeMessage(player.getUniqueId(), message, System.currentTimeMillis());
        if (event instanceof AsyncPlayerChatEvent) {
            ((AsyncPlayerChatEvent)event).setMessage(result.finalMessage);
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.noChatLocation != null) {
            Location currentLocation = player.getLocation();
            if (currentLocation.getBlockX() == playerData.noChatLocation.getBlockX() && currentLocation.getBlockZ() == playerData.noChatLocation.getBlockZ()) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoChatUntilMove, 10L, new String[0]);
                result.muteReason = "pre-movement chat";
            } else {
                playerData.noChatLocation = null;
            }
        }
        if (result.muteReason == null && this.instance.containsBlockedIP(message)) {
            result.muteReason = "IP address";
        }
        if (result.shouldBanChatter) {
            if (this.instance.config_spam_banOffenders) {
                GriefPrevention.AddLogEntry("Banning " + player.getName() + " for spam.", CustomLogEntryTypes.AdminActivity);
                PlayerKickBanTask task = new PlayerKickBanTask(player, this.instance.config_spam_banMessage, "GriefPrevention Anti-Spam", true);
                this.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)task, 1L);
            } else {
                GriefPrevention.AddLogEntry("Kicking " + player.getName() + " for spam.", CustomLogEntryTypes.AdminActivity);
                PlayerKickBanTask task = new PlayerKickBanTask(player, "", "GriefPrevention Anti-Spam", false);
                this.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)task, 1L);
            }
        } else if (result.shouldWarnChatter) {
            GriefPrevention.sendMessage(player, TextMode.Warn, this.instance.config_spam_warningMessage, 10L);
            GriefPrevention.AddLogEntry("Warned " + player.getName() + " about spam penalties.", CustomLogEntryTypes.Debug, true);
        }
        if (result.muteReason != null) {
            GriefPrevention.AddLogEntry("Muted " + result.muteReason + ".");
            GriefPrevention.AddLogEntry("Muted " + player.getName() + " " + result.muteReason + ":" + message, CustomLogEntryTypes.Debug, true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    synchronized void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Claim claim;
        boolean isMonitoredCommand;
        String message = event.getMessage();
        String[] args = message.split(" ");
        String command = args[0].toLowerCase();
        CommandCategory category = this.getCommandCategory(command);
        Player player = event.getPlayer();
        PlayerData playerData = null;
        if (category == CommandCategory.Whisper && args.length > 1) {
            Player targetPlayer = this.instance.getServer().getPlayer(args[1]);
            if (this.dataStore.isSoftMuted(player.getUniqueId()) && targetPlayer != null && !this.dataStore.isSoftMuted(targetPlayer.getUniqueId())) {
                event.setCancelled(true);
                return;
            }
            if (!(!this.instance.config_whisperNotifications || player.hasPermission("griefprevention.eavesdropimmune") || targetPlayer != null && targetPlayer.hasPermission("griefprevention.eavesdropimmune"))) {
                void var10_12;
                StringBuilder logMessageBuilder = new StringBuilder();
                logMessageBuilder.append("[[").append(event.getPlayer().getName()).append("]] ");
                boolean bl = true;
                while (var10_12 < args.length) {
                    logMessageBuilder.append(args[var10_12]).append(" ");
                    ++var10_12;
                }
                String string = logMessageBuilder.toString();
                Collection players = this.instance.getServer().getOnlinePlayers();
                for (Player onlinePlayer : players) {
                    if (!onlinePlayer.hasPermission("griefprevention.eavesdrop") || onlinePlayer.equals(targetPlayer) || onlinePlayer.equals(player)) continue;
                    onlinePlayer.sendMessage(ChatColor.GRAY + string);
                }
            }
            if (targetPlayer != null && targetPlayer.isOnline()) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
                if (playerData.ignoredPlayers.containsKey(targetPlayer.getUniqueId()) && !targetPlayer.hasPermission("griefprevention.notignorable")) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.IsIgnoringYou, new String[0]);
                    return;
                }
                PlayerData targetPlayerData = this.dataStore.getPlayerData(targetPlayer.getUniqueId());
                if (targetPlayerData.ignoredPlayers.containsKey(player.getUniqueId()) && !player.hasPermission("griefprevention.notignorable")) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.IsIgnoringYou, new String[0]);
                    return;
                }
            }
        }
        if (playerData == null) {
            playerData = this.dataStore.getPlayerData(event.getPlayer().getUniqueId());
        }
        if ((playerData.inPvpCombat() || playerData.siegeData != null) && this.instance.config_pvp_blockedCommands.contains(command)) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(event.getPlayer(), TextMode.Err, Messages.CommandBannedInPvP, new String[0]);
            return;
        }
        if (category == CommandCategory.Chat && this.dataStore.isSoftMuted(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        boolean bl = isMonitoredCommand = category == CommandCategory.Chat || category == CommandCategory.Whisper;
        if (isMonitoredCommand) {
            if (this.instance.config_spam_enabled) {
                event.setCancelled(this.handlePlayerChat(event.getPlayer(), event.getMessage(), (PlayerEvent)event));
            }
            if (!player.hasPermission("griefprevention.spam") && this.bannedWordFinder.hasMatch(message)) {
                event.setCancelled(true);
            }
            if (!event.isCancelled()) {
                StringBuilder builder = new StringBuilder();
                for (String arg : args) {
                    builder.append(arg).append(' ');
                }
                PlayerEventHandler.makeSocialLogEntry(event.getPlayer().getName(), builder.toString());
            }
        }
        isMonitoredCommand = false;
        String lowerCaseMessage = message.toLowerCase();
        for (String monitoredCommand : this.instance.config_claims_commandsRequiringAccessTrust) {
            if (!lowerCaseMessage.startsWith(monitoredCommand)) continue;
            isMonitoredCommand = true;
            break;
        }
        if (isMonitoredCommand && (claim = this.dataStore.getClaimAt(player.getLocation(), false, playerData.lastClaim)) != null) {
            playerData.lastClaim = claim;
            String reason = claim.allowAccess(player);
            if (reason != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, reason);
                event.setCancelled(true);
            }
        }
    }

    private CommandCategory getCommandCategory(String commandName) {
        CommandCategory category;
        if (commandName.startsWith("/")) {
            commandName = commandName.substring(1);
        }
        if ((category = this.commandCategoryMap.get(commandName)) != null) {
            return category;
        }
        HashSet<String> aliases = new HashSet<String>();
        aliases.add(commandName);
        aliases.add("minecraft:" + commandName);
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            JavaPlugin javaPlugin;
            PluginCommand command;
            if (!(plugin instanceof JavaPlugin) || (command = (javaPlugin = (JavaPlugin)plugin).getCommand(commandName)) == null) continue;
            aliases.add(command.getName().toLowerCase());
            aliases.add(plugin.getName().toLowerCase() + ":" + command.getName().toLowerCase());
            for (String alias : command.getAliases()) {
                aliases.add(alias.toLowerCase());
                aliases.add(plugin.getName().toLowerCase() + ":" + alias.toLowerCase());
            }
        }
        PluginCommand command = Bukkit.getServer().getPluginCommand(commandName);
        if (command != null) {
            aliases.add(command.getName().toLowerCase());
            aliases.add("minecraft:" + command.getName().toLowerCase());
            for (String alias : command.getAliases()) {
                aliases.add(alias.toLowerCase());
                aliases.add("minecraft:" + alias.toLowerCase());
            }
        }
        category = CommandCategory.None;
        for (String alias : aliases) {
            if (this.instance.config_eavesdrop_whisperCommands.contains("/" + alias)) {
                category = CommandCategory.Whisper;
            } else if (this.instance.config_spam_monitorSlashCommands.contains("/" + alias)) {
                category = CommandCategory.Chat;
            }
            this.commandCategoryMap.put(alias.toLowerCase(), category);
        }
        return category;
    }

    static void makeSocialLogEntry(String name, String message) {
        StringBuilder entryBuilder = new StringBuilder(name);
        for (int i = name.length(); i < longestNameLength; ++i) {
            entryBuilder.append(' ');
        }
        entryBuilder.append(": ").append(message);
        longestNameLength = Math.max(longestNameLength, name.length());
        GriefPrevention.AddLogEntry(entryBuilder.toString(), CustomLogEntryTypes.SocialActivity, true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        if (this.instance.config_spam_enabled) {
            long millisecondsSinceLastLogin;
            long secondsSinceLastLogin;
            long cooldownRemaining;
            Date lastLoginThisSession;
            long now = Calendar.getInstance().getTimeInMillis();
            if (this.instance.config_spam_loginCooldownSeconds > 0 && event.getResult() == PlayerLoginEvent.Result.ALLOWED && !player.hasPermission("griefprevention.spam") && (lastLoginThisSession = this.lastLoginThisServerSessionMap.get(player.getUniqueId())) != null && (cooldownRemaining = (long)this.instance.config_spam_loginCooldownSeconds - (secondsSinceLastLogin = (millisecondsSinceLastLogin = now - lastLoginThisSession.getTime()) / 1000L)) > 0L) {
                event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
                event.setKickMessage("You must wait " + cooldownRemaining + " seconds before logging-in again.");
                event.disallow(event.getResult(), event.getKickMessage());
                return;
            }
            if (this.instance.config_smartBan && event.getResult() == PlayerLoginEvent.Result.KICK_BANNED) {
                this.tempBannedIps.add(new IpBanInfo(event.getAddress(), now + this.MILLISECONDS_IN_DAY, player.getName()));
            }
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        playerData.ipAddress = event.getAddress();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    void onPlayerJoin(PlayerJoinEvent event) {
        Integer taskID;
        String joinMessage;
        int ipLimit;
        final Player player = event.getPlayer();
        UUID playerID = player.getUniqueId();
        Date nowDate = new Date();
        long now = nowDate.getTime();
        PlayerData playerData = this.dataStore.getPlayerData(playerID);
        playerData.lastSpawn = now;
        this.lastLoginThisServerSessionMap.put(playerID, nowDate);
        if (GriefPrevention.isNewToServer(player)) {
            playerData.noChatLocation = player.getLocation();
        }
        if (!player.hasPlayedBefore()) {
            this.instance.checkPvpProtectionNeeded(player);
            if (this.instance.config_claims_worldModes.get(player.getWorld()) == ClaimsMode.Survival && !player.hasPermission("griefprevention.adminclaims") && this.dataStore.claims.size() > 10) {
                WelcomeTask task = new WelcomeTask(player);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)task, (long)this.instance.config_claims_manualDeliveryDelaySeconds * 20L);
            }
        }
        if (event.getJoinMessage() != null && this.shouldSilenceNotification()) {
            event.setJoinMessage(null);
        }
        if (this.instance.config_smartBan && !player.hasPlayedBefore()) {
            for (int i = 0; i < this.tempBannedIps.size(); ++i) {
                IpBanInfo info = this.tempBannedIps.get(i);
                String address = info.address.toString();
                if (now > info.expirationTimestamp) {
                    this.tempBannedIps.remove(i--);
                    continue;
                }
                if (!address.equals(playerData.ipAddress.toString())) continue;
                OfflinePlayer bannedPlayer = this.instance.getServer().getOfflinePlayer(info.bannedAccountName);
                if (!bannedPlayer.isBanned()) {
                    for (int j = 0; j < this.tempBannedIps.size(); ++j) {
                        IpBanInfo info2 = this.tempBannedIps.get(j);
                        if (!info2.address.toString().equals(address)) continue;
                        OfflinePlayer bannedAccount = this.instance.getServer().getOfflinePlayer(info2.bannedAccountName);
                        this.instance.getServer().getBanList(BanList.Type.NAME).pardon(bannedAccount.getName());
                        this.tempBannedIps.remove(j--);
                    }
                    break;
                }
                GriefPrevention.AddLogEntry("Auto-banned new player " + player.getName() + " because that account is using an IP address very recently used by banned player " + info.bannedAccountName + " (" + info.address.toString() + ").", CustomLogEntryTypes.AdminActivity);
                Collection players = this.instance.getServer().getOnlinePlayers();
                for (Player otherPlayer : players) {
                    if (!otherPlayer.isOp()) continue;
                    GriefPrevention.sendMessage(otherPlayer, TextMode.Success, Messages.AutoBanNotify, player.getName(), info.bannedAccountName);
                }
                PlayerKickBanTask task = new PlayerKickBanTask(player, "", "GriefPrevention Smart Ban - Shared Login:" + info.bannedAccountName, true);
                this.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)task, 10L);
                event.setJoinMessage("");
                break;
            }
        }
        GriefPrevention.cacheUUIDNamePair(player.getUniqueId(), player.getName());
        InetAddress ipAddress = playerData.ipAddress;
        if (ipAddress != null && (ipLimit = this.instance.config_ipLimit) > 0 && GriefPrevention.isNewToServer(player)) {
            int ipCount = 0;
            Collection players = this.instance.getServer().getOnlinePlayers();
            for (Player onlinePlayer : players) {
                if (onlinePlayer.getUniqueId().equals(player.getUniqueId())) continue;
                PlayerData otherData = this.instance.dataStore.getPlayerData(onlinePlayer.getUniqueId());
                if (!ipAddress.equals(otherData.ipAddress) || !GriefPrevention.isNewToServer(onlinePlayer)) continue;
                ++ipCount;
            }
            if (ipCount >= ipLimit) {
                PlayerKickBanTask task = new PlayerKickBanTask(player, this.instance.dataStore.getMessage(Messages.TooMuchIpOverlap, new String[0]), "GriefPrevention IP-sharing limit.", false);
                this.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)task, 100L);
                event.setJoinMessage(null);
                return;
            }
        }
        new IgnoreLoaderThread(playerID, playerData.ignoredPlayers).start();
        if (player.hasMetadata("GP_PORTALRESCUE")) {
            GriefPrevention.sendMessage(player, TextMode.Info, Messages.NetherPortalTrapDetectionMessage, 20L, new String[0]);
            new BukkitRunnable(){

                public void run() {
                    if (player.getPortalCooldown() > 8 && player.hasMetadata("GP_PORTALRESCUE")) {
                        GriefPrevention.AddLogEntry("Rescued " + player.getName() + " from a nether portal.\nTeleported from " + player.getLocation().toString() + " to " + ((Location)((MetadataValue)player.getMetadata("GP_PORTALRESCUE").get(0)).value()).toString(), CustomLogEntryTypes.Debug);
                        player.teleport((Location)((MetadataValue)player.getMetadata("GP_PORTALRESCUE").get(0)).value());
                        player.removeMetadata("GP_PORTALRESCUE", (Plugin)PlayerEventHandler.this.instance);
                    }
                }
            }.runTaskLater((Plugin)this.instance, 200L);
        } else {
            player.setPortalCooldown(0);
        }
        if (this.instance.config_spam_logoutMessageDelaySeconds > 0 && (joinMessage = event.getJoinMessage()) != null && !joinMessage.isEmpty() && (taskID = this.heldLogoutMessages.get(player.getUniqueId())) != null && Bukkit.getScheduler().isQueued(taskID.intValue())) {
            Bukkit.getScheduler().cancelTask(taskID.intValue());
            player.sendMessage(event.getJoinMessage());
            event.setJoinMessage("");
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = this.instance.dataStore.getPlayerData(player.getUniqueId());
        playerData.lastSpawn = Calendar.getInstance().getTimeInMillis();
        playerData.lastPvpTimestamp = 0L;
        if (playerData.messageOnRespawn != null) {
            GriefPrevention.sendMessage(player, ChatColor.RESET, playerData.messageOnRespawn, 40L);
            playerData.messageOnRespawn = null;
        }
        this.instance.checkPvpProtectionNeeded(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Long lastDeathTime = this.deathTimestamps.get(player.getUniqueId());
        long now = Calendar.getInstance().getTimeInMillis();
        if (lastDeathTime != null && now - lastDeathTime < (long)(this.instance.config_spam_deathMessageCooldownSeconds * 1000)) {
            player.sendMessage(event.getDeathMessage());
            event.setDeathMessage("");
        }
        this.deathTimestamps.put(player.getUniqueId(), now);
        PlayerData playerData = this.instance.dataStore.getPlayerData(player.getUniqueId());
        playerData.dropsAreUnlocked = false;
        playerData.receivedDropUnlockAdvertisement = false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerKicked(PlayerKickEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        playerData.wasKicked = true;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onPlayerQuit(PlayerQuitEvent event) {
        String quitMessage;
        boolean isBanned;
        Player player = event.getPlayer();
        UUID playerID = player.getUniqueId();
        PlayerData playerData = this.dataStore.getPlayerData(playerID);
        if (player.getPortalCooldown() < 9) {
            player.removeMetadata("GP_PORTALRESCUE", (Plugin)this.instance);
        }
        if ((isBanned = playerData.wasKicked ? player.isBanned() : false) && playerData.ipAddress != null) {
            long now = Calendar.getInstance().getTimeInMillis();
            this.tempBannedIps.add(new IpBanInfo(playerData.ipAddress, now + this.MILLISECONDS_IN_DAY, player.getName()));
        }
        if (event.getQuitMessage() != null && this.shouldSilenceNotification()) {
            event.setQuitMessage(null);
        }
        if (isBanned) {
            event.setQuitMessage(null);
        } else {
            this.dataStore.savePlayerData(player.getUniqueId(), playerData);
        }
        if (this.instance.config_pvp_punishLogout && playerData.inPvpCombat()) {
            player.setHealth(0.0);
        }
        if (playerData.siegeData != null && player.getHealth() > 0.0) {
            player.setHealth(0.0);
        }
        this.dataStore.clearCachedPlayerData(playerID);
        if (this.instance.config_spam_logoutMessageDelaySeconds > 0 && (quitMessage = event.getQuitMessage()) != null && !quitMessage.isEmpty()) {
            BroadcastMessageTask task = new BroadcastMessageTask(quitMessage);
            int taskID = Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)task, 20L * (long)this.instance.config_spam_logoutMessageDelaySeconds);
            this.heldLogoutMessages.put(playerID, taskID);
            event.setQuitMessage("");
        }
    }

    private boolean shouldSilenceNotification() {
        if (this.instance.config_spam_loginLogoutNotificationsPerMinute <= 0) {
            return false;
        }
        long ONE_MINUTE = 60000L;
        Long now = Calendar.getInstance().getTimeInMillis();
        for (int i = 0; i < this.recentLoginLogoutNotifications.size(); ++i) {
            Long notificationTimestamp = this.recentLoginLogoutNotifications.get(i);
            if (now - notificationTimestamp <= 60000L) break;
            this.recentLoginLogoutNotifications.remove(i--);
        }
        this.recentLoginLogoutNotifications.add(now);
        return this.recentLoginLogoutNotifications.size() > this.instance.config_spam_loginLogoutNotificationsPerMinute;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (this.instance.creativeRulesApply(player.getLocation())) {
            event.setCancelled(true);
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (!this.instance.config_pvp_allowCombatItemDrop && playerData.inPvpCombat()) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.PvPNoDrop, new String[0]);
            event.setCancelled(true);
        } else if (playerData.siegeData != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoDrop, new String[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    void onPlayerPortal(PlayerPortalEvent event) {
        if (event.getTo() == null || event.getTo().getWorld() == null) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            this.instance.startRescueTask(player, player.getLocation());
            if (!this.instance.claimsEnabledForWorld(event.getTo().getWorld())) {
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Claim toClaim;
        Player player = event.getPlayer();
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        PlayerTeleportEvent.TeleportCause cause = event.getCause();
        if ((cause == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT || cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && this.instance.config_claims_enderPearlsRequireAccessTrust) && (toClaim = this.dataStore.getClaimAt(event.getTo(), false, playerData.lastClaim)) != null) {
            playerData.lastClaim = toClaim;
            String noAccessReason = toClaim.allowAccess(player);
            if (noAccessReason != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, noAccessReason);
                event.setCancelled(true);
                if (cause == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                    player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.ENDER_PEARL)});
                }
            }
        }
        if (!this.instance.config_siege_enabledWorlds.contains(player.getWorld())) {
            return;
        }
        if (player.hasPermission("griefprevention.siegeteleport")) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.UNKNOWN) {
            return;
        }
        Location source = event.getFrom();
        Claim sourceClaim = this.dataStore.getClaimAt(source, false, playerData.lastClaim);
        if (sourceClaim != null && sourceClaim.siegeData != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoTeleport, new String[0]);
            event.setCancelled(true);
            return;
        }
        Location destination = event.getTo();
        Claim destinationClaim = this.dataStore.getClaimAt(destination, false, null);
        if (destinationClaim != null && destinationClaim.siegeData != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.BesiegedNoTeleport, new String[0]);
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerTriggerRaid(RaidTriggerEvent event) {
        if (!this.instance.config_claims_raidTriggersRequireBuildTrust) {
            return;
        }
        Player player = event.getPlayer();
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim toClaim = this.dataStore.getClaimAt(player.getLocation(), false, playerData.lastClaim);
        if (toClaim == null) {
            return;
        }
        playerData.lastClaim = toClaim;
        if (toClaim.allowBuild(player, Material.AIR) == null) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked().getType() == EntityType.ARMOR_STAND) {
            this.onPlayerInteractEntity((PlayerInteractEntityEvent)event);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        String failureReason;
        String noContainersReason;
        Claim claim;
        String noBuildReason;
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (!this.instance.claimsEnabledForWorld(entity.getWorld())) {
            return;
        }
        if (!this.instance.config_claims_protectHorses && entity instanceof AbstractHorse) {
            return;
        }
        if (!this.instance.config_claims_protectDonkeys && entity instanceof Donkey) {
            return;
        }
        if (!this.instance.config_claims_protectDonkeys && entity instanceof Mule) {
            return;
        }
        if (!this.instance.config_claims_protectLlamas && entity instanceof Llama) {
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            if (tameable.isTamed()) {
                if (tameable.getOwner() != null) {
                    UUID ownerID = tameable.getOwner().getUniqueId();
                    if (player.getUniqueId().equals(ownerID) || playerData.ignoreClaims) {
                        if (playerData.petGiveawayRecipient != null) {
                            tameable.setOwner((AnimalTamer)playerData.petGiveawayRecipient);
                            playerData.petGiveawayRecipient = null;
                            GriefPrevention.sendMessage(player, TextMode.Success, Messages.PetGiveawayConfirmation, new String[0]);
                            event.setCancelled(true);
                        }
                        return;
                    }
                    if (!this.instance.pvpRulesApply(entity.getLocation().getWorld()) || this.instance.config_pvp_protectPets) {
                        OfflinePlayer owner = this.instance.getServer().getOfflinePlayer(ownerID);
                        String ownerName = owner.getName();
                        if (ownerName == null) {
                            ownerName = "someone";
                        }
                        String message = this.instance.dataStore.getMessage(Messages.NotYourPet, ownerName);
                        if (player.hasPermission("griefprevention.ignoreclaims")) {
                            message = message + "  " + this.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                        }
                        GriefPrevention.sendMessage(player, TextMode.Err, message);
                        event.setCancelled(true);
                        return;
                    }
                }
            } else {
                tameable.setOwner(null);
                if (tameable instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)tameable;
                    holder.getInventory().clear();
                }
            }
        }
        if ((entity.getType() == EntityType.ARMOR_STAND || entity instanceof Hanging) && (noBuildReason = this.instance.allowBuild(player, entity.getLocation(), Material.ITEM_FRAME)) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            event.setCancelled(true);
            return;
        }
        if (entity.getType() == EntityType.ARMOR_STAND && this.instance.creativeRulesApply(player.getLocation())) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(entity.getLocation(), false, playerData.lastClaim)) == null) {
                return;
            }
            String noEntitiesReason = claim.allowMoreEntities(false);
            if (noEntitiesReason != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, noEntitiesReason);
                event.setCancelled(true);
                return;
            }
        }
        if (playerData.ignoreClaims) {
            return;
        }
        if (entity instanceof StorageMinecart || entity instanceof PoweredMinecart) {
            if (playerData.siegeData != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
            if (playerData.inPvpCombat()) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PvPNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
        }
        if (this.instance.config_claims_preventTheft && entity instanceof Vehicle && (claim = this.dataStore.getClaimAt(entity.getLocation(), false, null)) != null && entity instanceof InventoryHolder && (noContainersReason = claim.allowContainers(player)) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noContainersReason);
            event.setCancelled(true);
            return;
        }
        if ((this.instance.config_claims_preventTheft && (entity instanceof Animals || entity instanceof Fish) || entity.getType() == EntityType.VILLAGER && this.instance.config_claims_villagerTradingRequiresTrust) && (claim = this.dataStore.getClaimAt(entity.getLocation(), false, null)) != null && claim.allowContainers(player) != null) {
            String message = this.instance.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
            if (player.hasPermission("griefprevention.ignoreclaims")) {
                message = message + "  " + this.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
            }
            GriefPrevention.sendMessage(player, TextMode.Err, message);
            event.setCancelled(true);
            return;
        }
        if (this.instance.config_claims_preventTheft && entity instanceof Creature && this.instance.getItemInHand(player, event.getHand()).getType() == Material.LEAD && (claim = this.dataStore.getClaimAt(entity.getLocation(), false, playerData.lastClaim)) != null && (failureReason = claim.allowContainers(player)) != null) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(player, TextMode.Err, failureReason);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerThrowEgg(PlayerEggThrowEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(event.getEgg().getLocation(), false, playerData.lastClaim);
        if (playerData.ignoreClaims) {
            return;
        }
        if (claim != null && claim.allowContainers(player) != null) {
            String message = this.instance.dataStore.getMessage(Messages.NoContainersPermission, claim.getOwnerName());
            if (player.hasPermission("griefprevention.ignoreclaims")) {
                message = message + "  " + this.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
            }
            GriefPrevention.sendMessage(player, TextMode.Err, message);
            event.setHatching(false);
            if (player.getGameMode() == GameMode.SURVIVAL || player.getGameMode() == GameMode.ADVENTURE) {
                player.getInventory().addItem(new ItemStack[]{event.getEgg().getItem()});
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerFish(PlayerFishEvent event) {
        Entity entity = event.getCaught();
        if (entity == null) {
            return;
        }
        if (entity.getType() == EntityType.ARMOR_STAND || entity instanceof Animals) {
            String errorMessage;
            Player player = event.getPlayer();
            PlayerData playerData = this.instance.dataStore.getPlayerData(player.getUniqueId());
            Claim claim = this.instance.dataStore.getClaimAt(entity.getLocation(), false, playerData.lastClaim);
            if (claim != null && (errorMessage = claim.allowContainers(player)) != null) {
                event.setCancelled(true);
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoDamageClaimedEntity, claim.getOwnerName());
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        Item item = event.getItem();
        List data = item.getMetadata("GP_ITEMOWNER");
        if (data != null && data.size() > 0) {
            UUID ownerID = (UUID)((MetadataValue)data.get(0)).value();
            OfflinePlayer owner = this.instance.getServer().getOfflinePlayer(ownerID);
            String ownerName = GriefPrevention.lookupPlayerName(ownerID);
            if (owner.isOnline() && !player.equals(owner)) {
                PlayerData playerData = this.dataStore.getPlayerData(ownerID);
                if (!playerData.dropsAreUnlocked) {
                    event.setCancelled(true);
                    if (!playerData.receivedDropUnlockAdvertisement) {
                        GriefPrevention.sendMessage(owner.getPlayer(), TextMode.Instr, Messages.DropUnlockAdvertisement, new String[0]);
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.PickupBlockedExplanation, ownerName);
                        playerData.receivedDropUnlockAdvertisement = true;
                    }
                    return;
                }
            }
        }
        if (!this.instance.pvpRulesApply(player.getWorld())) {
            return;
        }
        if (this.instance.config_pvp_protectFreshSpawns && this.instance.getItemInHand(player, EquipmentSlot.HAND).getType() == Material.AIR) {
            PlayerData playerData = this.dataStore.getPlayerData(event.getPlayer().getUniqueId());
            if (playerData.pvpImmune) {
                long now = Calendar.getInstance().getTimeInMillis();
                long elapsedSinceLastSpawn = now - playerData.lastSpawn;
                if (elapsedSinceLastSpawn < 10000L) {
                    event.setCancelled(true);
                    return;
                }
                playerData.pvpImmune = false;
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.PvPImmunityEnd, new String[0]);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        int newSlot = event.getNewSlot();
        ItemStack newItemStack = player.getInventory().getItem(newSlot);
        if (newItemStack != null && newItemStack.getType() == this.instance.config_claims_modificationTool && this.instance.claimsEnabledForWorld(player.getWorld())) {
            EquipShovelProcessingTask task = new EquipShovelProcessingTask(player);
            this.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.instance, (Runnable)task, 15L);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent bucketEvent) {
        String noBuildReason;
        if (!this.instance.claimsEnabledForWorld(bucketEvent.getBlockClicked().getWorld())) {
            return;
        }
        Player player = bucketEvent.getPlayer();
        Block block = bucketEvent.getBlockClicked().getRelative(bucketEvent.getBlockFace());
        int minLavaDistance = 10;
        if (bucketEvent.getBucket() == Material.WATER_BUCKET && bucketEvent.getBlockClicked().getBlockData() instanceof Waterlogged) {
            block = bucketEvent.getBlockClicked();
        }
        if ((noBuildReason = this.instance.allowBuild(player, block.getLocation(), Material.WATER)) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            bucketEvent.setCancelled(true);
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(block.getLocation(), false, playerData.lastClaim);
        if (claim != null) {
            minLavaDistance = 3;
        } else if (this.instance.creativeRulesApply(block.getLocation()) && block.getY() >= this.instance.getSeaLevel(block.getWorld()) - 5 && !player.hasPermission("griefprevention.lava") && bucketEvent.getBucket() == Material.LAVA_BUCKET) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoWildernessBuckets, new String[0]);
            bucketEvent.setCancelled(true);
            return;
        }
        if (!this.doesAllowLavaProximityInWorld(block.getWorld()) && !player.hasPermission("griefprevention.lava") && bucketEvent.getBucket() == Material.LAVA_BUCKET) {
            List players = block.getWorld().getPlayers();
            for (Player otherPlayer : players) {
                Location location = otherPlayer.getLocation();
                if (otherPlayer.equals(player) || otherPlayer.getGameMode() != GameMode.SURVIVAL || !player.canSee(otherPlayer) || block.getY() < location.getBlockY() - 1 || !(location.distanceSquared(block.getLocation()) < (double)(minLavaDistance * minLavaDistance))) continue;
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoLavaNearOtherPlayer, "another player");
                bucketEvent.setCancelled(true);
                return;
            }
        }
        if (block.getY() >= this.instance.getSeaLevel(block.getWorld()) - 5 && !player.hasPermission("griefprevention.lava") && block.getWorld().getEnvironment() != World.Environment.NETHER) {
            BlockFace[] adjacentDirections;
            Set<Material> exclusionAdjacentTypes = bucketEvent.getBucket() == Material.WATER_BUCKET ? this.commonAdjacentBlocks_water : this.commonAdjacentBlocks_lava;
            boolean makeLogEntry = true;
            for (BlockFace direction : adjacentDirections = new BlockFace[]{BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.DOWN}) {
                Material adjacentBlockType = block.getRelative(direction).getType();
                if (!exclusionAdjacentTypes.contains(adjacentBlockType)) continue;
                makeLogEntry = false;
                break;
            }
            if (makeLogEntry) {
                GriefPrevention.AddLogEntry(player.getName() + " placed suspicious " + bucketEvent.getBucket().name() + " @ " + GriefPrevention.getfriendlyLocationString(block.getLocation()), CustomLogEntryTypes.SuspiciousActivity, true);
            }
        }
    }

    private boolean doesAllowLavaProximityInWorld(World world) {
        if (GriefPrevention.instance.pvpRulesApply(world)) {
            return GriefPrevention.instance.config_pvp_allowLavaNearPlayers;
        }
        return GriefPrevention.instance.config_pvp_allowLavaNearPlayers_NonPvp;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerBucketFill(PlayerBucketFillEvent bucketEvent) {
        Player player = bucketEvent.getPlayer();
        Block block = bucketEvent.getBlockClicked();
        if (!this.instance.claimsEnabledForWorld(block.getWorld())) {
            return;
        }
        String noBuildReason = this.instance.allowBuild(player, block.getLocation(), Material.AIR);
        if (noBuildReason != null) {
            BlockData blockData;
            Material blockType = block.getType();
            if (blockType == Material.AIR) {
                return;
            }
            if (!(!blockType.isSolid() || (blockData = block.getBlockData()) instanceof Waterlogged && ((Waterlogged)blockData).isWaterlogged())) {
                return;
            }
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            bucketEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    void onPlayerInteract(PlayerInteractEvent event) {
        Claim claim;
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        Material clickedBlockType = null;
        clickedBlockType = clickedBlock != null ? clickedBlock.getType() : Material.AIR;
        PlayerData playerData = null;
        if (action == Action.PHYSICAL) {
            if (clickedBlockType != Material.TURTLE_EGG) {
                return;
            }
            playerData = this.dataStore.getPlayerData(player.getUniqueId());
            Claim claim2 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim);
            if (claim2 != null) {
                playerData.lastClaim = claim2;
                String noAccessReason = claim2.allowBreak(player, clickedBlockType);
                if (noAccessReason != null) {
                    event.setCancelled(true);
                    return;
                }
            }
            return;
        }
        if (action == Action.LEFT_CLICK_BLOCK && clickedBlock != null) {
            Block adjacentBlock;
            byte lightLevel;
            if ((clickedBlock.getY() < clickedBlock.getWorld().getMaxHeight() - 1 || event.getBlockFace() != BlockFace.UP) && (lightLevel = (adjacentBlock = clickedBlock.getRelative(event.getBlockFace())).getLightFromBlocks()) == 15 && adjacentBlock.getType() == Material.FIRE) {
                Claim claim3;
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim3 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                    playerData.lastClaim = claim3;
                    String noBuildReason = claim3.allowBuild(player, Material.AIR);
                    if (noBuildReason != null) {
                        event.setCancelled(true);
                        GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                        player.sendBlockChange(adjacentBlock.getLocation(), adjacentBlock.getType(), adjacentBlock.getData());
                        return;
                    }
                }
            }
            if (!this.onLeftClickWatchList(clickedBlockType)) {
                return;
            }
        }
        if (clickedBlock != null && this.instance.config_claims_preventTheft && event.getAction() == Action.RIGHT_CLICK_BLOCK && (this.isInventoryHolder(clickedBlock) && clickedBlock.getType() != Material.LECTERN || clickedBlockType == Material.CAULDRON || clickedBlockType == Material.JUKEBOX || clickedBlockType == Material.ANVIL || clickedBlockType == Material.CHIPPED_ANVIL || clickedBlockType == Material.DAMAGED_ANVIL || clickedBlockType == Material.CAKE || clickedBlockType == Material.SWEET_BERRY_BUSH || clickedBlockType == Material.BEE_NEST || clickedBlockType == Material.BEEHIVE || clickedBlockType == Material.BEACON || clickedBlockType == Material.BELL || clickedBlockType == Material.STONECUTTER || clickedBlockType == Material.GRINDSTONE || clickedBlockType == Material.CARTOGRAPHY_TABLE || clickedBlockType == Material.LOOM || clickedBlockType == Material.RESPAWN_ANCHOR)) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if (playerData.siegeData != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
            if (playerData.inPvpCombat()) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PvPNoContainers, new String[0]);
                event.setCancelled(true);
                return;
            }
            claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim);
            if (claim != null) {
                playerData.lastClaim = claim;
                String noContainersReason = claim.allowContainers(player);
                if (noContainersReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noContainersReason);
                    return;
                }
            }
            if (playerData.pvpImmune) {
                playerData.pvpImmune = false;
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.PvPImmunityEnd, new String[0]);
            }
        } else if (clickedBlock != null && (this.instance.config_claims_lockWoodenDoors && Tag.WOODEN_DOORS.isTagged((Keyed)clickedBlockType) || this.instance.config_claims_preventButtonsSwitches && Tag.BEDS.isTagged((Keyed)clickedBlockType) || this.instance.config_claims_lockTrapDoors && Tag.WOODEN_TRAPDOORS.isTagged((Keyed)clickedBlockType) || this.instance.config_claims_lecternReadingRequiresAccessTrust && clickedBlockType == Material.LECTERN || this.instance.config_claims_lockFenceGates && Tag.FENCE_GATES.isTagged((Keyed)clickedBlockType))) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                playerData.lastClaim = claim;
                String noAccessReason = claim.allowAccess(player);
                if (noAccessReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noAccessReason);
                    return;
                }
            }
        } else if (clickedBlock != null && this.instance.config_claims_preventButtonsSwitches && (Tag.BUTTONS.isTagged((Keyed)clickedBlockType) || clickedBlockType == Material.LEVER)) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                playerData.lastClaim = claim;
                String noAccessReason = claim.allowAccess(player);
                if (noAccessReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noAccessReason);
                    return;
                }
            }
        } else if (clickedBlock != null && this.instance.config_claims_preventTheft && clickedBlockType == Material.CAKE) {
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null) {
                playerData.lastClaim = claim;
                String noContainerReason = claim.allowAccess(player);
                if (noContainerReason != null) {
                    event.setCancelled(true);
                    GriefPrevention.sendMessage(player, TextMode.Err, noContainerReason);
                    return;
                }
            }
        } else if (clickedBlock != null && (clickedBlockType == Material.NOTE_BLOCK || clickedBlockType == Material.REPEATER || clickedBlockType == Material.DRAGON_EGG || clickedBlockType == Material.DAYLIGHT_DETECTOR || clickedBlockType == Material.COMPARATOR || clickedBlockType == Material.REDSTONE_WIRE || Tag.FLOWER_POTS.isTagged((Keyed)clickedBlockType))) {
            String noBuildReason;
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if ((claim = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null && (noBuildReason = claim.allowBuild(player, clickedBlockType)) != null) {
                event.setCancelled(true);
                GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                return;
            }
        } else {
            Claim claim4;
            String noBuildReason;
            if (action != Action.RIGHT_CLICK_BLOCK && action != Action.RIGHT_CLICK_AIR) {
                return;
            }
            EquipmentSlot hand = event.getHand();
            ItemStack itemInHand = this.instance.getItemInHand(player, hand);
            Material materialInHand = itemInHand.getType();
            HashSet<Material> spawn_eggs = new HashSet<Material>();
            HashSet<Material> dyes = new HashSet<Material>();
            for (Material material : Material.values()) {
                if (material.isLegacy()) continue;
                if (material.name().endsWith("_SPAWN_EGG")) {
                    spawn_eggs.add(material);
                    continue;
                }
                if (!material.name().endsWith("_DYE")) continue;
                dyes.add(material);
            }
            if (clickedBlock != null && (materialInHand == Material.BONE_MEAL || materialInHand == Material.ARMOR_STAND || spawn_eggs.contains(materialInHand) && GriefPrevention.instance.config_claims_preventGlobalMonsterEggs || materialInHand == Material.END_CRYSTAL || materialInHand == Material.FLINT_AND_STEEL || dyes.contains(materialInHand))) {
                noBuildReason = this.instance.allowBuild(player, clickedBlock.getLocation(), clickedBlockType);
                if (noBuildReason != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                    event.setCancelled(true);
                }
                return;
            }
            if (clickedBlock != null && Tag.ITEMS_BOATS.isTagged((Keyed)materialInHand)) {
                String reason;
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim4 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null && (reason = claim4.allowContainers(player)) != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, reason);
                    event.setCancelled(true);
                }
                return;
            }
            if (!(clickedBlock == null || materialInHand != Material.MINECART && materialInHand != Material.FURNACE_MINECART && materialInHand != Material.CHEST_MINECART && materialInHand != Material.TNT_MINECART && materialInHand != Material.HOPPER_MINECART || this.instance.creativeRulesApply(clickedBlock.getLocation()))) {
                String reason;
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim4 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) != null && (reason = claim4.allowContainers(player)) != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, reason);
                    event.setCancelled(true);
                }
                return;
            }
            if (clickedBlock != null && (materialInHand == Material.MINECART || materialInHand == Material.FURNACE_MINECART || materialInHand == Material.CHEST_MINECART || materialInHand == Material.TNT_MINECART || materialInHand == Material.ARMOR_STAND || materialInHand == Material.ITEM_FRAME || spawn_eggs.contains(materialInHand) || materialInHand == Material.INFESTED_STONE || materialInHand == Material.INFESTED_COBBLESTONE || materialInHand == Material.INFESTED_STONE_BRICKS || materialInHand == Material.INFESTED_MOSSY_STONE_BRICKS || materialInHand == Material.INFESTED_CRACKED_STONE_BRICKS || materialInHand == Material.INFESTED_CHISELED_STONE_BRICKS || materialInHand == Material.HOPPER_MINECART) && this.instance.creativeRulesApply(clickedBlock.getLocation())) {
                Claim claim5;
                noBuildReason = this.instance.allowBuild(player, clickedBlock.getLocation(), Material.MINECART);
                if (noBuildReason != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                    event.setCancelled(true);
                    return;
                }
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim5 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) == null) {
                    return;
                }
                String noEntitiesReason = claim5.allowMoreEntities(false);
                if (noEntitiesReason != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noEntitiesReason);
                    event.setCancelled(true);
                    return;
                }
                return;
            }
            if (materialInHand == this.instance.config_claims_investigationTool && hand == EquipmentSlot.HAND) {
                if (!this.instance.claimsEnabledForWorld(player.getWorld())) {
                    return;
                }
                if (player.isSneaking() && player.hasPermission("griefprevention.visualizenearbyclaims")) {
                    Set<Claim> claims = this.dataStore.getNearbyClaims(player.getLocation());
                    ClaimInspectionEvent inspectionEvent = new ClaimInspectionEvent(player, null, claims, true);
                    Bukkit.getPluginManager().callEvent((Event)inspectionEvent);
                    if (inspectionEvent.isCancelled()) {
                        return;
                    }
                    Visualization visualization = Visualization.fromClaims(claims, player.getEyeLocation().getBlockY(), VisualizationType.Claim, player.getLocation());
                    Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, claims, true));
                    Visualization.Apply(player, visualization);
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.ShowNearbyClaims, String.valueOf(claims.size()));
                    return;
                }
                if (action == Action.RIGHT_CLICK_AIR) {
                    clickedBlock = PlayerEventHandler.getTargetBlock(player, 100);
                    clickedBlockType = clickedBlock.getType();
                }
                if (clickedBlock == null) {
                    return;
                }
                if (clickedBlockType == Material.AIR) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.TooFarAway, new String[0]);
                    Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, null, Collections.emptySet()));
                    Visualization.Revert(player);
                    return;
                }
                if (playerData == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                }
                if ((claim4 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim)) == null) {
                    ClaimInspectionEvent inspectionEvent = new ClaimInspectionEvent(player, clickedBlock, null);
                    Bukkit.getPluginManager().callEvent((Event)inspectionEvent);
                    if (inspectionEvent.isCancelled()) {
                        return;
                    }
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BlockNotClaimed, new String[0]);
                    Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, null, Collections.emptySet()));
                    Visualization.Revert(player);
                } else {
                    ClaimInspectionEvent inspectionEvent = new ClaimInspectionEvent(player, clickedBlock, claim4);
                    Bukkit.getPluginManager().callEvent((Event)inspectionEvent);
                    if (inspectionEvent.isCancelled()) {
                        return;
                    }
                    playerData.lastClaim = claim4;
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BlockClaimed, claim4.getOwnerName());
                    Visualization visualization = Visualization.FromClaim(claim4, player.getEyeLocation().getBlockY(), VisualizationType.Claim, player.getLocation());
                    Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, claim4));
                    Visualization.Apply(player, visualization);
                    if (player.hasPermission("griefprevention.seeclaimsize")) {
                        GriefPrevention.sendMessage(player, TextMode.Info, "  " + claim4.getWidth() + "x" + claim4.getHeight() + "=" + claim4.getArea());
                    }
                    if (!claim4.isAdminClaim() && (player.hasPermission("griefprevention.deleteclaims") || player.hasPermission("griefprevention.seeinactivity"))) {
                        if (claim4.parent != null) {
                            claim4 = claim4.parent;
                        }
                        Date lastLogin = new Date(Bukkit.getOfflinePlayer((UUID)claim4.ownerID).getLastPlayed());
                        Date now = new Date();
                        long daysElapsed = (now.getTime() - lastLogin.getTime()) / 86400000L;
                        GriefPrevention.sendMessage(player, TextMode.Info, Messages.PlayerOfflineTime, String.valueOf(daysElapsed));
                        if (this.instance.getServer().getPlayer(claim4.ownerID) == null) {
                            this.dataStore.clearCachedPlayerData(claim4.ownerID);
                        }
                    }
                }
                return;
            }
            if (materialInHand != this.instance.config_claims_modificationTool || hand != EquipmentSlot.HAND) {
                return;
            }
            event.setCancelled(true);
            if (playerData == null) {
                playerData = this.dataStore.getPlayerData(player.getUniqueId());
            }
            if (playerData.siegeData != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeNoShovel, new String[0]);
                event.setCancelled(true);
                return;
            }
            if (action == Action.RIGHT_CLICK_AIR) {
                clickedBlock = PlayerEventHandler.getTargetBlock(player, 100);
                clickedBlockType = clickedBlock.getType();
            }
            if (clickedBlock == null) {
                return;
            }
            if (clickedBlockType == Material.AIR) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.TooFarAway, new String[0]);
                return;
            }
            UUID playerID = player.getUniqueId();
            playerData = this.dataStore.getPlayerData(player.getUniqueId());
            if (playerData.shovelMode == ShovelMode.RestoreNature || playerData.shovelMode == ShovelMode.RestoreNatureAggressive) {
                Claim claim6 = this.dataStore.getClaimAt(clickedBlock.getLocation(), false, playerData.lastClaim);
                if (claim6 != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.BlockClaimed, claim6.getOwnerName());
                    Visualization visualization = Visualization.FromClaim(claim6, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                    Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, claim6));
                    Visualization.Apply(player, visualization);
                    return;
                }
                Chunk chunk = player.getWorld().getChunkAt(clickedBlock.getLocation());
                int miny = clickedBlock.getY();
                if (playerData.shovelMode != ShovelMode.RestoreNatureAggressive && miny > this.instance.getSeaLevel(chunk.getWorld()) - 10) {
                    miny = this.instance.getSeaLevel(chunk.getWorld()) - 10;
                }
                this.instance.restoreChunk(chunk, miny, playerData.shovelMode == ShovelMode.RestoreNatureAggressive, 0L, player);
                return;
            }
            if (playerData.shovelMode == ShovelMode.RestoreNatureFill) {
                ArrayList<Material> allowedFillBlocks = new ArrayList<Material>();
                World.Environment environment = clickedBlock.getWorld().getEnvironment();
                if (environment == World.Environment.NETHER) {
                    allowedFillBlocks.add(Material.NETHERRACK);
                } else if (environment == World.Environment.THE_END) {
                    allowedFillBlocks.add(Material.END_STONE);
                } else {
                    allowedFillBlocks.add(Material.GRASS);
                    allowedFillBlocks.add(Material.DIRT);
                    allowedFillBlocks.add(Material.STONE);
                    allowedFillBlocks.add(Material.SAND);
                    allowedFillBlocks.add(Material.SANDSTONE);
                    allowedFillBlocks.add(Material.ICE);
                }
                Block centerBlock = clickedBlock;
                int maxHeight = centerBlock.getY();
                int minx = centerBlock.getX() - playerData.fillRadius;
                int maxx = centerBlock.getX() + playerData.fillRadius;
                int minz = centerBlock.getZ() - playerData.fillRadius;
                int maxz = centerBlock.getZ() + playerData.fillRadius;
                int minHeight = maxHeight - 10;
                if (minHeight < 0) {
                    minHeight = 0;
                }
                Claim cachedClaim = null;
                for (int x = minx; x <= maxx; ++x) {
                    block2: for (int z = minz; z <= maxz; ++z) {
                        Location location = new Location(centerBlock.getWorld(), (double)x, (double)centerBlock.getY(), (double)z);
                        if (location.distance(centerBlock.getLocation()) > (double)playerData.fillRadius) continue;
                        Material defaultFiller = (Material)allowedFillBlocks.get(0);
                        if (allowedFillBlocks.contains(centerBlock.getType())) {
                            defaultFiller = centerBlock.getType();
                        } else if (centerBlock.getType() == Material.WATER) {
                            Block block = centerBlock.getWorld().getBlockAt(centerBlock.getLocation());
                            while (!allowedFillBlocks.contains(block.getType()) && block.getY() > centerBlock.getY() - 10) {
                                block = block.getRelative(BlockFace.DOWN);
                            }
                            if (allowedFillBlocks.contains(block.getType())) {
                                defaultFiller = block.getType();
                            }
                        }
                        for (int y = minHeight; y <= maxHeight; ++y) {
                            Block block = centerBlock.getWorld().getBlockAt(x, y, z);
                            Claim claim7 = this.dataStore.getClaimAt(block.getLocation(), false, cachedClaim);
                            if (claim7 != null) {
                                cachedClaim = claim7;
                                continue block2;
                            }
                            if (block.getType() != Material.AIR && block.getType() != Material.SNOW && (block.getType() != Material.WATER || ((Levelled)block.getBlockData()).getLevel() == 0) && block.getType() != Material.GRASS) continue;
                            if (y == maxHeight) {
                                block.setType(defaultFiller);
                                continue;
                            }
                            Block eastBlock = block.getRelative(BlockFace.EAST);
                            Block westBlock = block.getRelative(BlockFace.WEST);
                            Block northBlock = block.getRelative(BlockFace.NORTH);
                            Block southBlock = block.getRelative(BlockFace.SOUTH);
                            if (allowedFillBlocks.contains(eastBlock.getType())) {
                                block.setType(eastBlock.getType());
                                continue;
                            }
                            if (allowedFillBlocks.contains(westBlock.getType())) {
                                block.setType(westBlock.getType());
                                continue;
                            }
                            if (allowedFillBlocks.contains(northBlock.getType())) {
                                block.setType(northBlock.getType());
                                continue;
                            }
                            if (allowedFillBlocks.contains(southBlock.getType())) {
                                block.setType(southBlock.getType());
                                continue;
                            }
                            block.setType(defaultFiller);
                        }
                    }
                }
                return;
            }
            if (!player.hasPermission("griefprevention.createclaims")) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoCreateClaimPermission, new String[0]);
                return;
            }
            if (playerData.claimResizing != null && playerData.claimResizing.inDataStore) {
                int newz2;
                int newz1;
                int newx2;
                int newx1;
                if (clickedBlock.getLocation().equals((Object)playerData.lastShovelLocation)) {
                    return;
                }
                if (playerData.lastShovelLocation.getBlockX() == playerData.claimResizing.getLesserBoundaryCorner().getBlockX()) {
                    newx1 = clickedBlock.getX();
                    newx2 = playerData.claimResizing.getGreaterBoundaryCorner().getBlockX();
                } else {
                    newx1 = playerData.claimResizing.getLesserBoundaryCorner().getBlockX();
                    newx2 = clickedBlock.getX();
                }
                if (playerData.lastShovelLocation.getBlockZ() == playerData.claimResizing.getLesserBoundaryCorner().getBlockZ()) {
                    newz1 = clickedBlock.getZ();
                    newz2 = playerData.claimResizing.getGreaterBoundaryCorner().getBlockZ();
                } else {
                    newz1 = playerData.claimResizing.getLesserBoundaryCorner().getBlockZ();
                    newz2 = clickedBlock.getZ();
                }
                int newy1 = playerData.claimResizing.getLesserBoundaryCorner().getBlockY();
                int newy2 = clickedBlock.getY() - this.instance.config_claims_claimsExtendIntoGroundDistance;
                this.dataStore.resizeClaimWithChecks(player, playerData, newx1, newx2, newy1, newy2, newz1, newz2);
                return;
            }
            Claim claim8 = this.dataStore.getClaimAt(clickedBlock.getLocation(), true, playerData.lastClaim);
            if (claim8 != null) {
                Visualization visualization;
                String noEditReason = claim8.allowEdit(player);
                if (noEditReason == null) {
                    if (!(clickedBlock.getX() != claim8.getLesserBoundaryCorner().getBlockX() && clickedBlock.getX() != claim8.getGreaterBoundaryCorner().getBlockX() || clickedBlock.getZ() != claim8.getLesserBoundaryCorner().getBlockZ() && clickedBlock.getZ() != claim8.getGreaterBoundaryCorner().getBlockZ())) {
                        playerData.claimResizing = claim8;
                        playerData.lastShovelLocation = clickedBlock.getLocation();
                        GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ResizeStart, new String[0]);
                    } else if (playerData.shovelMode == ShovelMode.Subdivide) {
                        if (playerData.lastShovelLocation == null) {
                            if (claim8.parent != null) {
                                GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeFailOverlapSubdivision, new String[0]);
                            } else {
                                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SubdivisionStart, new String[0]);
                                playerData.lastShovelLocation = clickedBlock.getLocation();
                                playerData.claimSubdividing = claim8;
                            }
                        } else {
                            if (!playerData.lastShovelLocation.getWorld().equals(clickedBlock.getWorld())) {
                                playerData.lastShovelLocation = null;
                                this.onPlayerInteract(event);
                                return;
                            }
                            CreateClaimResult result = this.dataStore.createClaim(player.getWorld(), playerData.lastShovelLocation.getBlockX(), clickedBlock.getX(), playerData.lastShovelLocation.getBlockY() - this.instance.config_claims_claimsExtendIntoGroundDistance, clickedBlock.getY() - this.instance.config_claims_claimsExtendIntoGroundDistance, playerData.lastShovelLocation.getBlockZ(), clickedBlock.getZ(), null, playerData.claimSubdividing, null, player);
                            if (!result.succeeded) {
                                GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateSubdivisionOverlap, new String[0]);
                                Visualization visualization2 = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                                Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization2, result.claim));
                                Visualization.Apply(player, visualization2);
                                return;
                            }
                            GriefPrevention.sendMessage(player, TextMode.Success, Messages.SubdivisionSuccess, new String[0]);
                            Visualization visualization3 = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.Claim, player.getLocation());
                            Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization3, result.claim));
                            Visualization.Apply(player, visualization3);
                            playerData.lastShovelLocation = null;
                            playerData.claimSubdividing = null;
                        }
                    } else {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlap, new String[0]);
                        visualization = Visualization.FromClaim(claim8, clickedBlock.getY(), VisualizationType.Claim, player.getLocation());
                        Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, claim8));
                        Visualization.Apply(player, visualization);
                    }
                } else {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapOtherPlayer, claim8.getOwnerName());
                    visualization = Visualization.FromClaim(claim8, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                    Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, claim8));
                    Visualization.Apply(player, visualization);
                }
                return;
            }
            Location lastShovelLocation = playerData.lastShovelLocation;
            if (lastShovelLocation == null) {
                if (!this.instance.claimsEnabledForWorld(player.getWorld())) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClaimsDisabledWorld, new String[0]);
                    return;
                }
                if (this.instance.config_claims_maxClaimsPerPlayer > 0 && !player.hasPermission("griefprevention.overrideclaimcountlimit") && playerData.getClaims().size() >= this.instance.config_claims_maxClaimsPerPlayer) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClaimCreationFailedOverClaimCountLimit, new String[0]);
                    return;
                }
                playerData.lastShovelLocation = clickedBlock.getLocation();
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ClaimStart, new String[0]);
                Claim newClaim = new Claim(clickedBlock.getLocation(), clickedBlock.getLocation(), null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null);
                Visualization visualization = Visualization.FromClaim(newClaim, clickedBlock.getY(), VisualizationType.RestoreNature, player.getLocation());
                Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, newClaim));
                Visualization.Apply(player, visualization);
            } else {
                if (!lastShovelLocation.getWorld().equals(clickedBlock.getWorld())) {
                    playerData.lastShovelLocation = null;
                    this.onPlayerInteract(event);
                    return;
                }
                if (playerData.inPvpCombat()) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoClaimDuringPvP, new String[0]);
                    return;
                }
                int newClaimWidth = Math.abs(playerData.lastShovelLocation.getBlockX() - clickedBlock.getX()) + 1;
                int newClaimHeight = Math.abs(playerData.lastShovelLocation.getBlockZ() - clickedBlock.getZ()) + 1;
                if (playerData.shovelMode != ShovelMode.Admin) {
                    if (newClaimWidth < this.instance.config_claims_minWidth || newClaimHeight < this.instance.config_claims_minWidth) {
                        if (newClaimWidth != 1 && newClaimHeight != 1) {
                            GriefPrevention.sendMessage(player, TextMode.Err, Messages.NewClaimTooNarrow, String.valueOf(this.instance.config_claims_minWidth));
                        }
                        return;
                    }
                    int newArea = newClaimWidth * newClaimHeight;
                    if (newArea < this.instance.config_claims_minArea) {
                        if (newArea != 1) {
                            GriefPrevention.sendMessage(player, TextMode.Err, Messages.ResizeClaimInsufficientArea, String.valueOf(this.instance.config_claims_minArea));
                        }
                        return;
                    }
                }
                if (playerData.shovelMode != ShovelMode.Admin) {
                    int newClaimArea = newClaimWidth * newClaimHeight;
                    int remainingBlocks = playerData.getRemainingClaimBlocks();
                    if (newClaimArea > remainingBlocks) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimInsufficientBlocks, String.valueOf(newClaimArea - remainingBlocks));
                        this.instance.dataStore.tryAdvertiseAdminAlternatives(player);
                        return;
                    }
                } else {
                    playerID = null;
                }
                CreateClaimResult result = this.dataStore.createClaim(player.getWorld(), lastShovelLocation.getBlockX(), clickedBlock.getX(), lastShovelLocation.getBlockY() - this.instance.config_claims_claimsExtendIntoGroundDistance, clickedBlock.getY() - this.instance.config_claims_claimsExtendIntoGroundDistance, lastShovelLocation.getBlockZ(), clickedBlock.getZ(), playerID, null, null, player);
                if (!result.succeeded) {
                    if (result.claim != null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapShort, new String[0]);
                        Visualization visualization = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.ErrorClaim, player.getLocation());
                        Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, result.claim));
                        Visualization.Apply(player, visualization);
                    } else {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapRegion, new String[0]);
                    }
                    return;
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.CreateClaimSuccess, new String[0]);
                Visualization visualization = Visualization.FromClaim(result.claim, clickedBlock.getY(), VisualizationType.Claim, player.getLocation());
                Bukkit.getPluginManager().callEvent((Event)new VisualizationEvent(player, visualization, result.claim));
                Visualization.Apply(player, visualization);
                playerData.lastShovelLocation = null;
                if (!player.hasPermission("griefprevention.adminclaims") && result.claim.getArea() >= 1000) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BecomeMayor, 200L, new String[0]);
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SubdivisionVideo2, 201L, DataStore.SUBDIVISION_VIDEO_URL);
                }
                this.instance.autoExtendClaim(result.claim);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    void onTakeBook(PlayerTakeLecternBookEvent event) {
        Player player = event.getPlayer();
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(event.getLectern().getLocation(), false, playerData.lastClaim);
        if (claim != null) {
            playerData.lastClaim = claim;
            String noContainerReason = claim.allowContainers(player);
            if (noContainerReason != null) {
                event.setCancelled(true);
                player.closeInventory();
                GriefPrevention.sendMessage(player, TextMode.Err, noContainerReason);
            }
        }
    }

    private boolean isInventoryHolder(Block clickedBlock) {
        Material cacheKey = clickedBlock.getType();
        Boolean cachedValue = this.inventoryHolderCache.get(cacheKey);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isHolder = clickedBlock.getState() instanceof InventoryHolder;
        this.inventoryHolderCache.put(cacheKey, isHolder);
        return isHolder;
    }

    private boolean onLeftClickWatchList(Material material) {
        switch (material) {
            case OAK_BUTTON: 
            case SPRUCE_BUTTON: 
            case BIRCH_BUTTON: 
            case JUNGLE_BUTTON: 
            case ACACIA_BUTTON: 
            case DARK_OAK_BUTTON: 
            case STONE_BUTTON: 
            case LEVER: 
            case REPEATER: 
            case CAKE: 
            case DRAGON_EGG: {
                return true;
            }
        }
        return false;
    }

    static Block getTargetBlock(Player player, int maxDistance) throws IllegalStateException {
        Location eye = player.getEyeLocation();
        Material eyeMaterial = eye.getBlock().getType();
        boolean passThroughWater = eyeMaterial == Material.WATER;
        BlockIterator iterator = new BlockIterator(player.getLocation(), player.getEyeHeight(), maxDistance);
        Block result = player.getLocation().getBlock().getRelative(BlockFace.UP);
        while (iterator.hasNext()) {
            result = iterator.next();
            Material type = result.getType();
            if (type == Material.AIR || passThroughWater && type == Material.WATER || type == Material.GRASS || type == Material.SNOW) continue;
            return result;
        }
        return result;
    }
}

