/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.ShovelMode;
import me.ryanhamshire.GriefPrevention.SiegeData;
import me.ryanhamshire.GriefPrevention.Visualization;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;

public class PlayerData {
    public UUID playerID;
    private Vector<Claim> claims = null;
    private Integer accruedClaimBlocks = null;
    private int newlyAccruedClaimBlocks = 0;
    public Location lastAfkCheckLocation = null;
    private Integer bonusClaimBlocks = null;
    public ShovelMode shovelMode = ShovelMode.Basic;
    int fillRadius = 0;
    public Location lastShovelLocation = null;
    public Claim claimResizing = null;
    public Claim claimSubdividing = null;
    public boolean pendingTrapped = false;
    boolean warnedAboutBuildingOutsideClaims = false;
    long lastSiegeEndTimeStamp = 0L;
    boolean wasKicked = false;
    public Visualization currentVisualization = null;
    public boolean pvpImmune = false;
    public long lastSpawn = 0L;
    public boolean ignoreClaims = false;
    public Claim lastClaim = null;
    public SiegeData siegeData = null;
    public long lastPvpTimestamp = 0L;
    public String lastPvpPlayer = "";
    public boolean warnedAboutMajorDeletion = false;
    public InetAddress ipAddress;
    private int AccruedClaimBlocksLimit = -1;
    boolean receivedDropUnlockAdvertisement = false;
    boolean dropsAreUnlocked = false;
    String messageOnRespawn = null;
    OfflinePlayer petGiveawayRecipient = null;
    Long buildWarningTimestamp = null;
    Location noChatLocation = null;
    public ConcurrentHashMap<UUID, Boolean> ignoredPlayers = new ConcurrentHashMap();
    public boolean ignoreListChanged = false;
    boolean profanityWarned = false;

    public boolean inPvpCombat() {
        if (this.lastPvpTimestamp == 0L) {
            return false;
        }
        long now = Calendar.getInstance().getTimeInMillis();
        long elapsed = now - this.lastPvpTimestamp;
        if (elapsed > (long)(GriefPrevention.instance.config_pvp_combatTimeoutSeconds * 1000)) {
            this.lastPvpTimestamp = 0L;
            return false;
        }
        return true;
    }

    public int getRemainingClaimBlocks() {
        int remainingBlocks = this.getAccruedClaimBlocks() + this.getBonusClaimBlocks() + GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID);
        for (int i = 0; i < this.getClaims().size(); ++i) {
            Claim claim = this.getClaims().get(i);
            remainingBlocks -= claim.getArea();
        }
        return remainingBlocks;
    }

    public synchronized int getAccruedClaimBlocks() {
        if (this.accruedClaimBlocks == null) {
            this.loadDataFromSecondaryStorage();
        }
        if (this.newlyAccruedClaimBlocks > 0) {
            int accruedLimit = this.getAccruedClaimBlocksLimit();
            if (this.accruedClaimBlocks < accruedLimit) {
                int newTotal = this.accruedClaimBlocks + this.newlyAccruedClaimBlocks;
                this.accruedClaimBlocks = Math.min(newTotal, accruedLimit);
            }
            this.newlyAccruedClaimBlocks = 0;
            return this.accruedClaimBlocks;
        }
        return this.accruedClaimBlocks;
    }

    public void setAccruedClaimBlocks(Integer accruedClaimBlocks) {
        this.accruedClaimBlocks = accruedClaimBlocks;
        this.newlyAccruedClaimBlocks = 0;
    }

    public int getBonusClaimBlocks() {
        if (this.bonusClaimBlocks == null) {
            this.loadDataFromSecondaryStorage();
        }
        return this.bonusClaimBlocks;
    }

    public void setBonusClaimBlocks(Integer bonusClaimBlocks) {
        this.bonusClaimBlocks = bonusClaimBlocks;
    }

    private void loadDataFromSecondaryStorage() {
        PlayerData storageData = GriefPrevention.instance.dataStore.getPlayerDataFromStorage(this.playerID);
        if (this.accruedClaimBlocks == null) {
            if (storageData.accruedClaimBlocks != null) {
                this.accruedClaimBlocks = storageData.accruedClaimBlocks;
                if (GriefPrevention.instance.config_advanced_fixNegativeClaimblockAmounts && this.accruedClaimBlocks < GriefPrevention.instance.config_claims_initialBlocks) {
                    this.accruedClaimBlocks = GriefPrevention.instance.config_claims_initialBlocks;
                }
            } else {
                this.accruedClaimBlocks = GriefPrevention.instance.config_claims_initialBlocks;
            }
        }
        if (this.bonusClaimBlocks == null) {
            this.bonusClaimBlocks = storageData.bonusClaimBlocks != null ? storageData.bonusClaimBlocks : Integer.valueOf(0);
        }
    }

    public Vector<Claim> getClaims() {
        if (this.claims == null) {
            this.claims = new Vector();
            DataStore dataStore = GriefPrevention.instance.dataStore;
            int totalClaimsArea = 0;
            for (int i = 0; i < dataStore.claims.size(); ++i) {
                Claim claim = dataStore.claims.get(i);
                if (!claim.inDataStore) {
                    dataStore.claims.remove(i--);
                    continue;
                }
                if (!this.playerID.equals(claim.ownerID)) continue;
                this.claims.add(claim);
                totalClaimsArea += claim.getArea();
            }
            this.loadDataFromSecondaryStorage();
            int totalBlocks = this.accruedClaimBlocks + this.getBonusClaimBlocks() + GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID);
            if (GriefPrevention.instance.config_advanced_fixNegativeClaimblockAmounts && totalBlocks < totalClaimsArea) {
                OfflinePlayer player = GriefPrevention.instance.getServer().getOfflinePlayer(this.playerID);
                GriefPrevention.AddLogEntry(player.getName() + " has more claimed land than blocks available.  Adding blocks to fix.", CustomLogEntryTypes.Debug, true);
                GriefPrevention.AddLogEntry(player.getName() + " Accrued blocks: " + this.getAccruedClaimBlocks() + " Bonus blocks: " + this.getBonusClaimBlocks(), CustomLogEntryTypes.Debug, true);
                GriefPrevention.AddLogEntry("Total blocks: " + totalBlocks + " Total claimed area: " + totalClaimsArea, CustomLogEntryTypes.Debug, true);
                for (Claim claim : this.claims) {
                    if (!claim.inDataStore) continue;
                    GriefPrevention.AddLogEntry(GriefPrevention.getfriendlyLocationString(claim.getLesserBoundaryCorner()) + " // " + GriefPrevention.getfriendlyLocationString(claim.getGreaterBoundaryCorner()) + " = " + claim.getArea(), CustomLogEntryTypes.Debug, true);
                }
                this.accruedClaimBlocks = totalClaimsArea;
                int accruedLimit = this.getAccruedClaimBlocksLimit();
                this.accruedClaimBlocks = Math.min(accruedLimit, this.accruedClaimBlocks);
                GriefPrevention.AddLogEntry("New accrued blocks: " + this.accruedClaimBlocks, CustomLogEntryTypes.Debug, true);
                totalBlocks = this.accruedClaimBlocks + this.getBonusClaimBlocks() + GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID);
                GriefPrevention.AddLogEntry("New total blocks: " + totalBlocks, CustomLogEntryTypes.Debug, true);
                if (totalBlocks < totalClaimsArea) {
                    int bonusBlocksToAdd = totalClaimsArea - totalBlocks;
                    PlayerData playerData = this;
                    playerData.bonusClaimBlocks = playerData.bonusClaimBlocks + bonusBlocksToAdd;
                    GriefPrevention.AddLogEntry("Accrued blocks weren't enough. Adding " + bonusBlocksToAdd + " bonus blocks.", CustomLogEntryTypes.Debug, true);
                }
                GriefPrevention.AddLogEntry(player.getName() + " Accrued blocks: " + this.getAccruedClaimBlocks() + " Bonus blocks: " + this.getBonusClaimBlocks() + " Group Bonus Blocks: " + GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID), CustomLogEntryTypes.Debug, true);
                totalBlocks = this.accruedClaimBlocks + this.getBonusClaimBlocks() + GriefPrevention.instance.dataStore.getGroupBonusBlocks(this.playerID);
                GriefPrevention.AddLogEntry("Total blocks: " + totalBlocks + " Total claimed area: " + totalClaimsArea, CustomLogEntryTypes.Debug, true);
                GriefPrevention.AddLogEntry("Remaining claim blocks to use: " + this.getRemainingClaimBlocks() + " (should be 0)", CustomLogEntryTypes.Debug, true);
            }
        }
        for (int i = 0; i < this.claims.size(); ++i) {
            if (this.claims.get((int)i).inDataStore) continue;
            this.claims.remove(i--);
        }
        return this.claims;
    }

    public int getAccruedClaimBlocksLimit() {
        if (this.AccruedClaimBlocksLimit < 0) {
            return GriefPrevention.instance.config_claims_maxAccruedBlocks_default;
        }
        return this.AccruedClaimBlocksLimit;
    }

    public void setAccruedClaimBlocksLimit(int limit) {
        this.AccruedClaimBlocksLimit = limit;
    }

    public void accrueBlocks(int howMany) {
        this.newlyAccruedClaimBlocks += howMany;
    }
}

