/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.ryanhamshire.GriefPrevention.AutoExtendClaimTask;
import me.ryanhamshire.GriefPrevention.BlockEventHandler;
import me.ryanhamshire.GriefPrevention.BlockSnapshot;
import me.ryanhamshire.GriefPrevention.CheckForPortalTrapTask;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.CreateClaimResult;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.CustomLogger;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.DatabaseDataStore;
import me.ryanhamshire.GriefPrevention.DeliverClaimBlocksTask;
import me.ryanhamshire.GriefPrevention.EconomyHandler;
import me.ryanhamshire.GriefPrevention.EntityCleanupTask;
import me.ryanhamshire.GriefPrevention.EntityEventHandler;
import me.ryanhamshire.GriefPrevention.FindUnusedClaimsTask;
import me.ryanhamshire.GriefPrevention.FlatFileDataStore;
import me.ryanhamshire.GriefPrevention.IgnoreLoaderThread;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PendingItemProtection;
import me.ryanhamshire.GriefPrevention.PistonMode;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.PlayerEventHandler;
import me.ryanhamshire.GriefPrevention.PlayerRescueTask;
import me.ryanhamshire.GriefPrevention.PvPImmunityValidationTask;
import me.ryanhamshire.GriefPrevention.RestoreNatureProcessingTask;
import me.ryanhamshire.GriefPrevention.SendPlayerMessageTask;
import me.ryanhamshire.GriefPrevention.ShovelMode;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import me.ryanhamshire.GriefPrevention.WelcomeTask;
import me.ryanhamshire.GriefPrevention.events.PreventBlockBreakEvent;
import me.ryanhamshire.GriefPrevention.events.SaveTrappedPlayerEvent;
import me.ryanhamshire.GriefPrevention.events.TrustChangedEvent;
import me.ryanhamshire.GriefPrevention.metrics.MetricsHandler;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class GriefPrevention
extends JavaPlugin {
    public static GriefPrevention instance;
    private static Logger log;
    public DataStore dataStore;
    ArrayList<PendingItemProtection> pendingItemWatchList = new ArrayList();
    CustomLogger customLogger;
    public ConcurrentHashMap<World, ClaimsMode> config_claims_worldModes;
    private boolean config_creativeWorldsExist;
    public boolean config_claims_preventGlobalMonsterEggs;
    public boolean config_claims_preventTheft;
    public boolean config_claims_protectCreatures;
    public boolean config_claims_protectHorses;
    public boolean config_claims_protectDonkeys;
    public boolean config_claims_protectLlamas;
    public boolean config_claims_preventButtonsSwitches;
    public boolean config_claims_lockWoodenDoors;
    public boolean config_claims_lockTrapDoors;
    public boolean config_claims_lockFenceGates;
    public boolean config_claims_enderPearlsRequireAccessTrust;
    public boolean config_claims_raidTriggersRequireBuildTrust;
    public int config_claims_maxClaimsPerPlayer;
    public boolean config_claims_respectWorldGuard;
    public boolean config_claims_villagerTradingRequiresTrust;
    public int config_claims_initialBlocks;
    public double config_claims_abandonReturnRatio;
    public int config_claims_blocksAccruedPerHour_default;
    public int config_claims_maxAccruedBlocks_default;
    public int config_claims_accruedIdleThreshold;
    public int config_claims_accruedIdlePercent;
    public int config_claims_maxDepth;
    public int config_claims_expirationDays;
    public int config_claims_expirationExemptionTotalBlocks;
    public int config_claims_expirationExemptionBonusBlocks;
    public int config_claims_automaticClaimsForNewPlayersRadius;
    public int config_claims_automaticClaimsForNewPlayersRadiusMin;
    public int config_claims_claimsExtendIntoGroundDistance;
    public int config_claims_minWidth;
    public int config_claims_minArea;
    public int config_claims_chestClaimExpirationDays;
    public int config_claims_unusedClaimExpirationDays;
    public boolean config_claims_survivalAutoNatureRestoration;
    public boolean config_claims_allowTrappedInAdminClaims;
    public Material config_claims_investigationTool;
    public Material config_claims_modificationTool;
    public ArrayList<String> config_claims_commandsRequiringAccessTrust;
    public boolean config_claims_supplyPlayerManual;
    public int config_claims_manualDeliveryDelaySeconds;
    public boolean config_claims_firespreads;
    public boolean config_claims_firedamages;
    public boolean config_claims_lecternReadingRequiresAccessTrust;
    public ArrayList<World> config_siege_enabledWorlds;
    public Set<Material> config_siege_blocks;
    public int config_siege_doorsOpenSeconds;
    public int config_siege_cooldownEndInMinutes;
    public boolean config_spam_enabled;
    public int config_spam_loginCooldownSeconds;
    public int config_spam_loginLogoutNotificationsPerMinute;
    public ArrayList<String> config_spam_monitorSlashCommands;
    public boolean config_spam_banOffenders;
    public String config_spam_banMessage;
    public String config_spam_warningMessage;
    public String config_spam_allowedIpAddresses;
    public int config_spam_deathMessageCooldownSeconds;
    public int config_spam_logoutMessageDelaySeconds;
    HashMap<World, Boolean> config_pvp_specifiedWorlds;
    public boolean config_pvp_protectFreshSpawns;
    public boolean config_pvp_punishLogout;
    public int config_pvp_combatTimeoutSeconds;
    public boolean config_pvp_allowCombatItemDrop;
    public ArrayList<String> config_pvp_blockedCommands;
    public boolean config_pvp_noCombatInPlayerLandClaims;
    public boolean config_pvp_noCombatInAdminLandClaims;
    public boolean config_pvp_noCombatInAdminSubdivisions;
    public boolean config_pvp_allowLavaNearPlayers;
    public boolean config_pvp_allowLavaNearPlayers_NonPvp;
    public boolean config_pvp_allowFireNearPlayers;
    public boolean config_pvp_allowFireNearPlayers_NonPvp;
    public boolean config_pvp_protectPets;
    public boolean config_lockDeathDropsInPvpWorlds;
    public boolean config_lockDeathDropsInNonPvpWorlds;
    private EconomyHandler economyHandler;
    public int config_economy_claimBlocksMaxBonus;
    public double config_economy_claimBlocksPurchaseCost;
    public double config_economy_claimBlocksSellValue;
    public boolean config_blockClaimExplosions;
    public boolean config_blockSurfaceCreeperExplosions;
    public boolean config_blockSurfaceOtherExplosions;
    public boolean config_blockSkyTrees;
    public boolean config_fireSpreads;
    public boolean config_fireDestroys;
    public boolean config_whisperNotifications;
    public boolean config_signNotifications;
    public ArrayList<String> config_eavesdrop_whisperCommands;
    public boolean config_smartBan;
    public boolean config_endermenMoveBlocks;
    public boolean config_claims_ravagersBreakBlocks;
    public boolean config_silverfishBreakBlocks;
    public boolean config_creaturesTrampleCrops;
    public boolean config_rabbitsEatCrops;
    public boolean config_zombiesBreakDoors;
    public int config_ipLimit;
    public boolean config_trollFilterEnabled;
    public HashMap<String, Integer> config_seaLevelOverride;
    public boolean config_limitTreeGrowth;
    public PistonMode config_pistonMovement;
    public boolean config_pistonExplosionSound;
    public boolean config_advanced_fixNegativeClaimblockAmounts;
    public int config_advanced_claim_expiration_check_rate;
    public int config_advanced_offlineplayer_cache_days;
    public int config_logs_daysToKeep;
    public boolean config_logs_socialEnabled;
    public boolean config_logs_suspiciousEnabled;
    public boolean config_logs_adminEnabled;
    public boolean config_logs_debugEnabled;
    public boolean config_logs_mutedChatEnabled;
    public boolean config_ban_useCommand;
    public String config_ban_commandFormat;
    private String databaseUrl;
    private String databaseUserName;
    private String databasePassword;
    public static final int TREE_RADIUS = 5;
    public static final int NOTIFICATION_SECONDS = 20;
    ConcurrentHashMap<String, UUID> playerNameToIDMap = new ConcurrentHashMap();
    ConcurrentHashMap<UUID, BukkitTask> portalReturnTaskMap = new ConcurrentHashMap();

    public static synchronized void AddLogEntry(String entry, CustomLogEntryTypes customLogType, boolean excludeFromServerLogs) {
        if (customLogType != null && GriefPrevention.instance.customLogger != null) {
            GriefPrevention.instance.customLogger.AddEntry(entry, customLogType);
        }
        if (!excludeFromServerLogs) {
            log.info(entry);
        }
    }

    public static synchronized void AddLogEntry(String entry, CustomLogEntryTypes customLogType) {
        GriefPrevention.AddLogEntry(entry, customLogType, false);
    }

    public static synchronized void AddLogEntry(String entry) {
        GriefPrevention.AddLogEntry(entry, CustomLogEntryTypes.Debug);
    }

    public void onEnable() {
        Runnable task;
        instance = this;
        log = instance.getLogger();
        this.loadConfig();
        this.customLogger = new CustomLogger();
        GriefPrevention.AddLogEntry("Finished loading configuration.");
        if (this.databaseUrl.length() > 0) {
            try {
                DatabaseDataStore databaseStore = new DatabaseDataStore(this.databaseUrl, this.databaseUserName, this.databasePassword);
                if (FlatFileDataStore.hasData()) {
                    GriefPrevention.AddLogEntry("There appears to be some data on the hard drive.  Migrating those data to the database...");
                    FlatFileDataStore flatFileStore = new FlatFileDataStore();
                    this.dataStore = flatFileStore;
                    flatFileStore.migrateData(databaseStore);
                    GriefPrevention.AddLogEntry("Data migration process complete.");
                }
                this.dataStore = databaseStore;
            }
            catch (Exception e) {
                GriefPrevention.AddLogEntry("Because there was a problem with the database, GriefPrevention will not function properly.  Either update the database config settings resolve the issue, or delete those lines from your config.yml so that GriefPrevention can use the file system to store data.");
                e.printStackTrace();
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        if (this.dataStore == null) {
            File oldclaimdata = new File(this.getDataFolder(), "ClaimData");
            if (oldclaimdata.exists() && !FlatFileDataStore.hasData()) {
                File claimdata = new File("plugins" + File.separator + "GriefPreventionData" + File.separator + "ClaimData");
                oldclaimdata.renameTo(claimdata);
                File oldplayerdata = new File(this.getDataFolder(), "PlayerData");
                File playerdata = new File("plugins" + File.separator + "GriefPreventionData" + File.separator + "PlayerData");
                oldplayerdata.renameTo(playerdata);
            }
            try {
                this.dataStore = new FlatFileDataStore();
            }
            catch (Exception e) {
                GriefPrevention.AddLogEntry("Unable to initialize the file system data store.  Details:");
                GriefPrevention.AddLogEntry(e.getMessage());
                e.printStackTrace();
            }
        }
        String dataMode = this.dataStore instanceof FlatFileDataStore ? "(File Mode)" : "(Database Mode)";
        GriefPrevention.AddLogEntry("Finished loading data " + dataMode + ".");
        if (this.config_claims_blocksAccruedPerHour_default > 0) {
            task = new DeliverClaimBlocksTask(null, this);
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, task, 12000L, 12000L);
        }
        task = new EntityCleanupTask(0.0);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)instance, task, 2400L);
        FindUnusedClaimsTask task2 = new FindUnusedClaimsTask();
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)task2, 1200L, 20L * (long)this.config_advanced_claim_expiration_check_rate);
        PluginManager pluginManager = this.getServer().getPluginManager();
        PlayerEventHandler playerEventHandler = new PlayerEventHandler(this.dataStore, this);
        pluginManager.registerEvents((Listener)playerEventHandler, (Plugin)this);
        BlockEventHandler blockEventHandler = new BlockEventHandler(this.dataStore);
        pluginManager.registerEvents((Listener)blockEventHandler, (Plugin)this);
        EntityEventHandler entityEventHandler = new EntityEventHandler(this.dataStore, this);
        pluginManager.registerEvents((Listener)entityEventHandler, (Plugin)this);
        this.economyHandler = new EconomyHandler(this);
        pluginManager.registerEvents((Listener)this.economyHandler, (Plugin)this);
        OfflinePlayer[] offlinePlayers = this.getServer().getOfflinePlayers();
        CacheOfflinePlayerNamesThread namesThread = new CacheOfflinePlayerNamesThread(offlinePlayers, this.playerNameToIDMap);
        namesThread.setPriority(1);
        namesThread.start();
        Collection players = instance.getServer().getOnlinePlayers();
        for (Player player : players) {
            new IgnoreLoaderThread(player.getUniqueId(), this.dataStore.getPlayerData((UUID)player.getUniqueId()).ignoredPlayers).start();
        }
        GriefPrevention.AddLogEntry("Boot finished.");
        try {
            new MetricsHandler(this, dataMode);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void loadConfig() {
        String[] commands;
        List breakableBlocksList;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(DataStore.configFilePath));
        YamlConfiguration outConfig = new YamlConfiguration();
        outConfig.options().header("Default values are perfect for most servers.  If you want to customize and have a question, look for the answer here first: http://dev.bukkit.org/bukkit-plugins/grief-prevention/pages/setup-and-configuration/");
        List worlds = this.getServer().getWorlds();
        List deprecated_claimsEnabledWorldNames = config.getStringList("GriefPrevention.Claims.Worlds");
        for (int i = 0; i < deprecated_claimsEnabledWorldNames.size(); ++i) {
            String worldName = (String)deprecated_claimsEnabledWorldNames.get(i);
            World world = this.getServer().getWorld(worldName);
            if (world != null) continue;
            deprecated_claimsEnabledWorldNames.remove(i--);
        }
        List deprecated_creativeClaimsEnabledWorldNames = config.getStringList("GriefPrevention.Claims.CreativeRulesWorlds");
        for (int i = 0; i < deprecated_creativeClaimsEnabledWorldNames.size(); ++i) {
            String worldName = (String)deprecated_creativeClaimsEnabledWorldNames.get(i);
            World world = this.getServer().getWorld(worldName);
            if (world != null) continue;
            deprecated_claimsEnabledWorldNames.remove(i--);
        }
        this.config_pvp_allowFireNearPlayers = config.getBoolean("GriefPrevention.PvP.AllowFlintAndSteelNearOtherPlayers", false);
        this.config_pvp_allowLavaNearPlayers = config.getBoolean("GriefPrevention.PvP.AllowLavaDumpingNearOtherPlayers", false);
        this.config_claims_worldModes = new ConcurrentHashMap();
        this.config_creativeWorldsExist = false;
        for (World world : worlds) {
            String configSetting = config.getString("GriefPrevention.Claims.Mode." + world.getName());
            if (configSetting != null) {
                ClaimsMode claimsMode = this.configStringToClaimsMode(configSetting);
                if (claimsMode != null) {
                    this.config_claims_worldModes.put(world, claimsMode);
                    if (claimsMode != ClaimsMode.Creative) continue;
                    this.config_creativeWorldsExist = true;
                    continue;
                }
                GriefPrevention.AddLogEntry("Error: Invalid claim mode \"" + configSetting + "\".  Options are Survival, Creative, and Disabled.");
                this.config_claims_worldModes.put(world, ClaimsMode.Creative);
                this.config_creativeWorldsExist = true;
            }
            if (deprecated_creativeClaimsEnabledWorldNames.contains(world.getName())) {
                this.config_claims_worldModes.put(world, ClaimsMode.Creative);
                this.config_creativeWorldsExist = true;
            } else if (deprecated_claimsEnabledWorldNames.contains(world.getName())) {
                this.config_claims_worldModes.put(world, ClaimsMode.Survival);
            } else if (world.getName().toLowerCase().contains("survival")) {
                this.config_claims_worldModes.put(world, ClaimsMode.Survival);
            } else if (world.getName().toLowerCase().contains("creative")) {
                this.config_claims_worldModes.put(world, ClaimsMode.Creative);
                this.config_creativeWorldsExist = true;
            } else if (this.getServer().getDefaultGameMode() == GameMode.CREATIVE) {
                this.config_claims_worldModes.put(world, ClaimsMode.Creative);
                this.config_creativeWorldsExist = true;
            } else if (world.getEnvironment() == World.Environment.NORMAL) {
                this.config_claims_worldModes.put(world, ClaimsMode.Survival);
            } else {
                this.config_claims_worldModes.put(world, ClaimsMode.Disabled);
            }
            if (this.config_claims_worldModes.get(world) != ClaimsMode.Disabled || deprecated_claimsEnabledWorldNames.size() <= 0) continue;
            this.config_claims_worldModes.put(world, ClaimsMode.Survival);
        }
        this.config_pvp_specifiedWorlds = new HashMap();
        for (World world : worlds) {
            boolean pvpWorld = config.getBoolean("GriefPrevention.PvP.RulesEnabledInWorld." + world.getName(), world.getPVP());
            this.config_pvp_specifiedWorlds.put(world, pvpWorld);
        }
        this.config_seaLevelOverride = new HashMap();
        for (World world : worlds) {
            int seaLevelOverride = config.getInt("GriefPrevention.SeaLevelOverrides." + world.getName(), -1);
            outConfig.set("GriefPrevention.SeaLevelOverrides." + world.getName(), (Object)seaLevelOverride);
            this.config_seaLevelOverride.put(world.getName(), seaLevelOverride);
        }
        this.config_claims_preventGlobalMonsterEggs = config.getBoolean("GriefPrevention.Claims.PreventGlobalMonsterEggs", true);
        this.config_claims_preventTheft = config.getBoolean("GriefPrevention.Claims.PreventTheft", true);
        this.config_claims_protectCreatures = config.getBoolean("GriefPrevention.Claims.ProtectCreatures", true);
        this.config_claims_protectHorses = config.getBoolean("GriefPrevention.Claims.ProtectHorses", true);
        this.config_claims_protectDonkeys = config.getBoolean("GriefPrevention.Claims.ProtectDonkeys", true);
        this.config_claims_protectLlamas = config.getBoolean("GriefPrevention.Claims.ProtectLlamas", true);
        this.config_claims_preventButtonsSwitches = config.getBoolean("GriefPrevention.Claims.PreventButtonsSwitches", true);
        this.config_claims_lockWoodenDoors = config.getBoolean("GriefPrevention.Claims.LockWoodenDoors", false);
        this.config_claims_lockTrapDoors = config.getBoolean("GriefPrevention.Claims.LockTrapDoors", false);
        this.config_claims_lockFenceGates = config.getBoolean("GriefPrevention.Claims.LockFenceGates", true);
        this.config_claims_enderPearlsRequireAccessTrust = config.getBoolean("GriefPrevention.Claims.EnderPearlsRequireAccessTrust", true);
        this.config_claims_raidTriggersRequireBuildTrust = config.getBoolean("GriefPrevention.Claims.RaidTriggersRequireBuildTrust", true);
        this.config_claims_initialBlocks = config.getInt("GriefPrevention.Claims.InitialBlocks", 100);
        this.config_claims_blocksAccruedPerHour_default = config.getInt("GriefPrevention.Claims.BlocksAccruedPerHour", 100);
        this.config_claims_blocksAccruedPerHour_default = config.getInt("GriefPrevention.Claims.Claim Blocks Accrued Per Hour.Default", this.config_claims_blocksAccruedPerHour_default);
        this.config_claims_maxAccruedBlocks_default = config.getInt("GriefPrevention.Claims.MaxAccruedBlocks", 80000);
        this.config_claims_maxAccruedBlocks_default = config.getInt("GriefPrevention.Claims.Max Accrued Claim Blocks.Default", this.config_claims_maxAccruedBlocks_default);
        this.config_claims_accruedIdleThreshold = config.getInt("GriefPrevention.Claims.AccruedIdleThreshold", 0);
        this.config_claims_accruedIdleThreshold = config.getInt("GriefPrevention.Claims.Accrued Idle Threshold", this.config_claims_accruedIdleThreshold);
        this.config_claims_accruedIdlePercent = config.getInt("GriefPrevention.Claims.AccruedIdlePercent", 0);
        this.config_claims_abandonReturnRatio = config.getDouble("GriefPrevention.Claims.AbandonReturnRatio", 1.0);
        this.config_claims_automaticClaimsForNewPlayersRadius = config.getInt("GriefPrevention.Claims.AutomaticNewPlayerClaimsRadius", 4);
        this.config_claims_automaticClaimsForNewPlayersRadiusMin = Math.max(0, Math.min(this.config_claims_automaticClaimsForNewPlayersRadius, config.getInt("GriefPrevention.Claims.AutomaticNewPlayerClaimsRadiusMinimum", 0)));
        this.config_claims_claimsExtendIntoGroundDistance = Math.abs(config.getInt("GriefPrevention.Claims.ExtendIntoGroundDistance", 5));
        this.config_claims_minWidth = config.getInt("GriefPrevention.Claims.MinimumWidth", 5);
        this.config_claims_minArea = config.getInt("GriefPrevention.Claims.MinimumArea", 100);
        this.config_claims_maxDepth = config.getInt("GriefPrevention.Claims.MaximumDepth", 0);
        this.config_claims_chestClaimExpirationDays = config.getInt("GriefPrevention.Claims.Expiration.ChestClaimDays", 7);
        this.config_claims_unusedClaimExpirationDays = config.getInt("GriefPrevention.Claims.Expiration.UnusedClaimDays", 14);
        this.config_claims_expirationDays = config.getInt("GriefPrevention.Claims.Expiration.AllClaims.DaysInactive", 60);
        this.config_claims_expirationExemptionTotalBlocks = config.getInt("GriefPrevention.Claims.Expiration.AllClaims.ExceptWhenOwnerHasTotalClaimBlocks", 10000);
        this.config_claims_expirationExemptionBonusBlocks = config.getInt("GriefPrevention.Claims.Expiration.AllClaims.ExceptWhenOwnerHasBonusClaimBlocks", 5000);
        this.config_claims_survivalAutoNatureRestoration = config.getBoolean("GriefPrevention.Claims.Expiration.AutomaticNatureRestoration.SurvivalWorlds", false);
        this.config_claims_allowTrappedInAdminClaims = config.getBoolean("GriefPrevention.Claims.AllowTrappedInAdminClaims", false);
        this.config_claims_maxClaimsPerPlayer = config.getInt("GriefPrevention.Claims.MaximumNumberOfClaimsPerPlayer", 0);
        this.config_claims_respectWorldGuard = config.getBoolean("GriefPrevention.Claims.CreationRequiresWorldGuardBuildPermission", true);
        this.config_claims_villagerTradingRequiresTrust = config.getBoolean("GriefPrevention.Claims.VillagerTradingRequiresPermission", true);
        String accessTrustSlashCommands = config.getString("GriefPrevention.Claims.CommandsRequiringAccessTrust", "/sethome");
        this.config_claims_supplyPlayerManual = config.getBoolean("GriefPrevention.Claims.DeliverManuals", true);
        this.config_claims_manualDeliveryDelaySeconds = config.getInt("GriefPrevention.Claims.ManualDeliveryDelaySeconds", 30);
        this.config_claims_ravagersBreakBlocks = config.getBoolean("GriefPrevention.Claims.RavagersBreakBlocks", true);
        this.config_claims_firespreads = config.getBoolean("GriefPrevention.Claims.FireSpreadsInClaims", false);
        this.config_claims_firedamages = config.getBoolean("GriefPrevention.Claims.FireDamagesInClaims", false);
        this.config_claims_lecternReadingRequiresAccessTrust = config.getBoolean("GriefPrevention.Claims.LecternReadingRequiresAccessTrust", true);
        this.config_spam_enabled = config.getBoolean("GriefPrevention.Spam.Enabled", true);
        this.config_spam_loginCooldownSeconds = config.getInt("GriefPrevention.Spam.LoginCooldownSeconds", 60);
        this.config_spam_loginLogoutNotificationsPerMinute = config.getInt("GriefPrevention.Spam.LoginLogoutNotificationsPerMinute", 5);
        this.config_spam_warningMessage = config.getString("GriefPrevention.Spam.WarningMessage", "Please reduce your noise level.  Spammers will be banned.");
        this.config_spam_allowedIpAddresses = config.getString("GriefPrevention.Spam.AllowedIpAddresses", "1.2.3.4; 5.6.7.8");
        this.config_spam_banOffenders = config.getBoolean("GriefPrevention.Spam.BanOffenders", true);
        this.config_spam_banMessage = config.getString("GriefPrevention.Spam.BanMessage", "Banned for spam.");
        String slashCommandsToMonitor = config.getString("GriefPrevention.Spam.MonitorSlashCommands", "/me;/global;/local");
        slashCommandsToMonitor = config.getString("GriefPrevention.Spam.ChatSlashCommands", slashCommandsToMonitor);
        this.config_spam_deathMessageCooldownSeconds = config.getInt("GriefPrevention.Spam.DeathMessageCooldownSeconds", 120);
        this.config_spam_logoutMessageDelaySeconds = config.getInt("GriefPrevention.Spam.Logout Message Delay In Seconds", 0);
        this.config_pvp_protectFreshSpawns = config.getBoolean("GriefPrevention.PvP.ProtectFreshSpawns", true);
        this.config_pvp_punishLogout = config.getBoolean("GriefPrevention.PvP.PunishLogout", true);
        this.config_pvp_combatTimeoutSeconds = config.getInt("GriefPrevention.PvP.CombatTimeoutSeconds", 15);
        this.config_pvp_allowCombatItemDrop = config.getBoolean("GriefPrevention.PvP.AllowCombatItemDrop", false);
        String bannedPvPCommandsList = config.getString("GriefPrevention.PvP.BlockedSlashCommands", "/home;/vanish;/spawn;/tpa");
        this.config_economy_claimBlocksMaxBonus = config.getInt("GriefPrevention.Economy.ClaimBlocksMaxBonus", 0);
        this.config_economy_claimBlocksPurchaseCost = config.getDouble("GriefPrevention.Economy.ClaimBlocksPurchaseCost", 0.0);
        this.config_economy_claimBlocksSellValue = config.getDouble("GriefPrevention.Economy.ClaimBlocksSellValue", 0.0);
        this.config_lockDeathDropsInPvpWorlds = config.getBoolean("GriefPrevention.ProtectItemsDroppedOnDeath.PvPWorlds", false);
        this.config_lockDeathDropsInNonPvpWorlds = config.getBoolean("GriefPrevention.ProtectItemsDroppedOnDeath.NonPvPWorlds", true);
        this.config_blockClaimExplosions = config.getBoolean("GriefPrevention.BlockLandClaimExplosions", true);
        this.config_blockSurfaceCreeperExplosions = config.getBoolean("GriefPrevention.BlockSurfaceCreeperExplosions", true);
        this.config_blockSurfaceOtherExplosions = config.getBoolean("GriefPrevention.BlockSurfaceOtherExplosions", true);
        this.config_blockSkyTrees = config.getBoolean("GriefPrevention.LimitSkyTrees", true);
        this.config_limitTreeGrowth = config.getBoolean("GriefPrevention.LimitTreeGrowth", false);
        this.config_pistonExplosionSound = config.getBoolean("GriefPrevention.PistonExplosionSound", true);
        this.config_pistonMovement = PistonMode.of(config.getString("GriefPrevention.PistonMovement", "CLAIMS_ONLY"));
        if (config.isBoolean("GriefPrevention.LimitPistonsToLandClaims") && !config.getBoolean("GriefPrevention.LimitPistonsToLandClaims")) {
            this.config_pistonMovement = PistonMode.EVERYWHERE_SIMPLE;
        }
        if (config.isBoolean("GriefPrevention.CheckPistonMovement") && !config.getBoolean("GriefPrevention.CheckPistonMovement")) {
            this.config_pistonMovement = PistonMode.IGNORED;
        }
        this.config_fireSpreads = config.getBoolean("GriefPrevention.FireSpreads", false);
        this.config_fireDestroys = config.getBoolean("GriefPrevention.FireDestroys", false);
        this.config_whisperNotifications = config.getBoolean("GriefPrevention.AdminsGetWhispers", true);
        this.config_signNotifications = config.getBoolean("GriefPrevention.AdminsGetSignNotifications", true);
        String whisperCommandsToMonitor = config.getString("GriefPrevention.WhisperCommands", "/tell;/pm;/r;/whisper;/msg");
        whisperCommandsToMonitor = config.getString("GriefPrevention.Spam.WhisperSlashCommands", whisperCommandsToMonitor);
        this.config_smartBan = config.getBoolean("GriefPrevention.SmartBan", true);
        this.config_trollFilterEnabled = config.getBoolean("GriefPrevention.Mute New Players Using Banned Words", true);
        this.config_ipLimit = config.getInt("GriefPrevention.MaxPlayersPerIpAddress", 3);
        this.config_endermenMoveBlocks = config.getBoolean("GriefPrevention.EndermenMoveBlocks", false);
        this.config_silverfishBreakBlocks = config.getBoolean("GriefPrevention.SilverfishBreakBlocks", false);
        this.config_creaturesTrampleCrops = config.getBoolean("GriefPrevention.CreaturesTrampleCrops", false);
        this.config_rabbitsEatCrops = config.getBoolean("GriefPrevention.RabbitsEatCrops", true);
        this.config_zombiesBreakDoors = config.getBoolean("GriefPrevention.HardModeZombiesBreakDoors", false);
        this.config_ban_useCommand = config.getBoolean("GriefPrevention.UseBanCommand", false);
        this.config_ban_commandFormat = config.getString("GriefPrevention.BanCommandPattern", "ban %name% %reason%");
        String investigationToolMaterialName = Material.STICK.name();
        investigationToolMaterialName = config.getString("GriefPrevention.Claims.InvestigationTool", investigationToolMaterialName);
        this.config_claims_investigationTool = Material.getMaterial((String)investigationToolMaterialName);
        if (this.config_claims_investigationTool == null) {
            GriefPrevention.AddLogEntry("ERROR: Material " + investigationToolMaterialName + " not found.  Defaulting to the stick.  Please update your config.yml.");
            this.config_claims_investigationTool = Material.STICK;
        }
        String modificationToolMaterialName = Material.GOLDEN_SHOVEL.name();
        modificationToolMaterialName = config.getString("GriefPrevention.Claims.ModificationTool", modificationToolMaterialName);
        this.config_claims_modificationTool = Material.getMaterial((String)modificationToolMaterialName);
        if (this.config_claims_modificationTool == null) {
            GriefPrevention.AddLogEntry("ERROR: Material " + modificationToolMaterialName + " not found.  Defaulting to the golden shovel.  Please update your config.yml.");
            this.config_claims_modificationTool = Material.GOLDEN_SHOVEL;
        }
        ArrayList defaultSiegeWorldNames = new ArrayList();
        ArrayList siegeEnabledWorldNames = config.getStringList("GriefPrevention.Siege.Worlds");
        if (siegeEnabledWorldNames == null) {
            siegeEnabledWorldNames = defaultSiegeWorldNames;
        }
        this.config_siege_enabledWorlds = new ArrayList();
        for (Iterator worldName : siegeEnabledWorldNames) {
            World world = this.getServer().getWorld((String)((Object)worldName));
            if (world == null) {
                GriefPrevention.AddLogEntry("Error: Siege Configuration: There's no world named \"" + (String)((Object)worldName) + "\".  Please update your config.yml.");
                continue;
            }
            this.config_siege_enabledWorlds.add(world);
        }
        this.config_siege_blocks = EnumSet.noneOf(Material.class);
        this.config_siege_blocks.add(Material.DIRT);
        this.config_siege_blocks.add(Material.GRASS_BLOCK);
        this.config_siege_blocks.add(Material.GRASS);
        this.config_siege_blocks.add(Material.FERN);
        this.config_siege_blocks.add(Material.DEAD_BUSH);
        this.config_siege_blocks.add(Material.COBBLESTONE);
        this.config_siege_blocks.add(Material.GRAVEL);
        this.config_siege_blocks.add(Material.SAND);
        this.config_siege_blocks.add(Material.GLASS);
        this.config_siege_blocks.add(Material.GLASS_PANE);
        this.config_siege_blocks.add(Material.OAK_PLANKS);
        this.config_siege_blocks.add(Material.SPRUCE_PLANKS);
        this.config_siege_blocks.add(Material.BIRCH_PLANKS);
        this.config_siege_blocks.add(Material.JUNGLE_PLANKS);
        this.config_siege_blocks.add(Material.ACACIA_PLANKS);
        this.config_siege_blocks.add(Material.DARK_OAK_PLANKS);
        this.config_siege_blocks.add(Material.WHITE_WOOL);
        this.config_siege_blocks.add(Material.ORANGE_WOOL);
        this.config_siege_blocks.add(Material.MAGENTA_WOOL);
        this.config_siege_blocks.add(Material.LIGHT_BLUE_WOOL);
        this.config_siege_blocks.add(Material.YELLOW_WOOL);
        this.config_siege_blocks.add(Material.LIME_WOOL);
        this.config_siege_blocks.add(Material.PINK_WOOL);
        this.config_siege_blocks.add(Material.GRAY_WOOL);
        this.config_siege_blocks.add(Material.LIGHT_GRAY_WOOL);
        this.config_siege_blocks.add(Material.CYAN_WOOL);
        this.config_siege_blocks.add(Material.PURPLE_WOOL);
        this.config_siege_blocks.add(Material.BLUE_WOOL);
        this.config_siege_blocks.add(Material.BROWN_WOOL);
        this.config_siege_blocks.add(Material.GREEN_WOOL);
        this.config_siege_blocks.add(Material.RED_WOOL);
        this.config_siege_blocks.add(Material.BLACK_WOOL);
        this.config_siege_blocks.add(Material.SNOW);
        if (config.isList("GriefPrevention.Siege.BreakableBlocks")) {
            breakableBlocksList = config.getStringList("GriefPrevention.Siege.BreakableBlocks");
            this.config_siege_blocks = this.parseMaterialListFromConfig(breakableBlocksList);
        } else {
            breakableBlocksList = this.config_siege_blocks.stream().map(Enum::name).collect(Collectors.toList());
        }
        this.config_siege_doorsOpenSeconds = config.getInt("GriefPrevention.Siege.DoorsOpenDelayInSeconds", 300);
        this.config_siege_cooldownEndInMinutes = config.getInt("GriefPrevention.Siege.CooldownEndInMinutes", 60);
        this.config_pvp_noCombatInPlayerLandClaims = config.getBoolean("GriefPrevention.PvP.ProtectPlayersInLandClaims.PlayerOwnedClaims", this.config_siege_enabledWorlds.size() == 0);
        this.config_pvp_noCombatInAdminLandClaims = config.getBoolean("GriefPrevention.PvP.ProtectPlayersInLandClaims.AdministrativeClaims", this.config_siege_enabledWorlds.size() == 0);
        this.config_pvp_noCombatInAdminSubdivisions = config.getBoolean("GriefPrevention.PvP.ProtectPlayersInLandClaims.AdministrativeSubdivisions", this.config_siege_enabledWorlds.size() == 0);
        this.config_pvp_allowLavaNearPlayers = config.getBoolean("GriefPrevention.PvP.AllowLavaDumpingNearOtherPlayers.PvPWorlds", true);
        this.config_pvp_allowLavaNearPlayers_NonPvp = config.getBoolean("GriefPrevention.PvP.AllowLavaDumpingNearOtherPlayers.NonPvPWorlds", false);
        this.config_pvp_allowFireNearPlayers = config.getBoolean("GriefPrevention.PvP.AllowFlintAndSteelNearOtherPlayers.PvPWorlds", true);
        this.config_pvp_allowFireNearPlayers_NonPvp = config.getBoolean("GriefPrevention.PvP.AllowFlintAndSteelNearOtherPlayers.NonPvPWorlds", false);
        this.config_pvp_protectPets = config.getBoolean("GriefPrevention.PvP.ProtectPetsOutsideLandClaims", false);
        this.databaseUrl = config.getString("GriefPrevention.Database.URL", "");
        this.databaseUserName = config.getString("GriefPrevention.Database.UserName", "");
        this.databasePassword = config.getString("GriefPrevention.Database.Password", "");
        this.config_advanced_fixNegativeClaimblockAmounts = config.getBoolean("GriefPrevention.Advanced.fixNegativeClaimblockAmounts", true);
        this.config_advanced_claim_expiration_check_rate = config.getInt("GriefPrevention.Advanced.ClaimExpirationCheckRate", 60);
        this.config_advanced_offlineplayer_cache_days = config.getInt("GriefPrevention.Advanced.OfflinePlayer_cache_days", 90);
        this.config_logs_daysToKeep = config.getInt("GriefPrevention.Abridged Logs.Days To Keep", 7);
        this.config_logs_socialEnabled = config.getBoolean("GriefPrevention.Abridged Logs.Included Entry Types.Social Activity", true);
        this.config_logs_suspiciousEnabled = config.getBoolean("GriefPrevention.Abridged Logs.Included Entry Types.Suspicious Activity", true);
        this.config_logs_adminEnabled = config.getBoolean("GriefPrevention.Abridged Logs.Included Entry Types.Administrative Activity", false);
        this.config_logs_debugEnabled = config.getBoolean("GriefPrevention.Abridged Logs.Included Entry Types.Debug", false);
        this.config_logs_mutedChatEnabled = config.getBoolean("GriefPrevention.Abridged Logs.Included Entry Types.Muted Chat Messages", false);
        for (World world : this.config_claims_worldModes.keySet()) {
            outConfig.set("GriefPrevention.Claims.Mode." + world.getName(), (Object)this.config_claims_worldModes.get(world).name());
        }
        outConfig.set("GriefPrevention.Claims.PreventGlobalMonsterEggs", (Object)this.config_claims_preventGlobalMonsterEggs);
        outConfig.set("GriefPrevention.Claims.PreventTheft", (Object)this.config_claims_preventTheft);
        outConfig.set("GriefPrevention.Claims.ProtectCreatures", (Object)this.config_claims_protectCreatures);
        outConfig.set("GriefPrevention.Claims.PreventButtonsSwitches", (Object)this.config_claims_preventButtonsSwitches);
        outConfig.set("GriefPrevention.Claims.LockWoodenDoors", (Object)this.config_claims_lockWoodenDoors);
        outConfig.set("GriefPrevention.Claims.LockTrapDoors", (Object)this.config_claims_lockTrapDoors);
        outConfig.set("GriefPrevention.Claims.LockFenceGates", (Object)this.config_claims_lockFenceGates);
        outConfig.set("GriefPrevention.Claims.EnderPearlsRequireAccessTrust", (Object)this.config_claims_enderPearlsRequireAccessTrust);
        outConfig.set("GriefPrevention.Claims.RaidTriggersRequireBuildTrust", (Object)this.config_claims_raidTriggersRequireBuildTrust);
        outConfig.set("GriefPrevention.Claims.ProtectHorses", (Object)this.config_claims_protectHorses);
        outConfig.set("GriefPrevention.Claims.ProtectDonkeys", (Object)this.config_claims_protectDonkeys);
        outConfig.set("GriefPrevention.Claims.ProtectLlamas", (Object)this.config_claims_protectLlamas);
        outConfig.set("GriefPrevention.Claims.InitialBlocks", (Object)this.config_claims_initialBlocks);
        outConfig.set("GriefPrevention.Claims.Claim Blocks Accrued Per Hour.Default", (Object)this.config_claims_blocksAccruedPerHour_default);
        outConfig.set("GriefPrevention.Claims.Max Accrued Claim Blocks.Default", (Object)this.config_claims_maxAccruedBlocks_default);
        outConfig.set("GriefPrevention.Claims.Accrued Idle Threshold", (Object)this.config_claims_accruedIdleThreshold);
        outConfig.set("GriefPrevention.Claims.AccruedIdlePercent", (Object)this.config_claims_accruedIdlePercent);
        outConfig.set("GriefPrevention.Claims.AbandonReturnRatio", (Object)this.config_claims_abandonReturnRatio);
        outConfig.set("GriefPrevention.Claims.AutomaticNewPlayerClaimsRadius", (Object)this.config_claims_automaticClaimsForNewPlayersRadius);
        outConfig.set("GriefPrevention.Claims.AutomaticNewPlayerClaimsRadiusMinimum", (Object)this.config_claims_automaticClaimsForNewPlayersRadiusMin);
        outConfig.set("GriefPrevention.Claims.ExtendIntoGroundDistance", (Object)this.config_claims_claimsExtendIntoGroundDistance);
        outConfig.set("GriefPrevention.Claims.MinimumWidth", (Object)this.config_claims_minWidth);
        outConfig.set("GriefPrevention.Claims.MinimumArea", (Object)this.config_claims_minArea);
        outConfig.set("GriefPrevention.Claims.MaximumDepth", (Object)this.config_claims_maxDepth);
        outConfig.set("GriefPrevention.Claims.InvestigationTool", (Object)this.config_claims_investigationTool.name());
        outConfig.set("GriefPrevention.Claims.ModificationTool", (Object)this.config_claims_modificationTool.name());
        outConfig.set("GriefPrevention.Claims.Expiration.ChestClaimDays", (Object)this.config_claims_chestClaimExpirationDays);
        outConfig.set("GriefPrevention.Claims.Expiration.UnusedClaimDays", (Object)this.config_claims_unusedClaimExpirationDays);
        outConfig.set("GriefPrevention.Claims.Expiration.AllClaims.DaysInactive", (Object)this.config_claims_expirationDays);
        outConfig.set("GriefPrevention.Claims.Expiration.AllClaims.ExceptWhenOwnerHasTotalClaimBlocks", (Object)this.config_claims_expirationExemptionTotalBlocks);
        outConfig.set("GriefPrevention.Claims.Expiration.AllClaims.ExceptWhenOwnerHasBonusClaimBlocks", (Object)this.config_claims_expirationExemptionBonusBlocks);
        outConfig.set("GriefPrevention.Claims.Expiration.AutomaticNatureRestoration.SurvivalWorlds", (Object)this.config_claims_survivalAutoNatureRestoration);
        outConfig.set("GriefPrevention.Claims.AllowTrappedInAdminClaims", (Object)this.config_claims_allowTrappedInAdminClaims);
        outConfig.set("GriefPrevention.Claims.MaximumNumberOfClaimsPerPlayer", (Object)this.config_claims_maxClaimsPerPlayer);
        outConfig.set("GriefPrevention.Claims.CreationRequiresWorldGuardBuildPermission", (Object)this.config_claims_respectWorldGuard);
        outConfig.set("GriefPrevention.Claims.VillagerTradingRequiresPermission", (Object)this.config_claims_villagerTradingRequiresTrust);
        outConfig.set("GriefPrevention.Claims.CommandsRequiringAccessTrust", (Object)accessTrustSlashCommands);
        outConfig.set("GriefPrevention.Claims.DeliverManuals", (Object)this.config_claims_supplyPlayerManual);
        outConfig.set("GriefPrevention.Claims.ManualDeliveryDelaySeconds", (Object)this.config_claims_manualDeliveryDelaySeconds);
        outConfig.set("GriefPrevention.Claims.RavagersBreakBlocks", (Object)this.config_claims_ravagersBreakBlocks);
        outConfig.set("GriefPrevention.Claims.FireSpreadsInClaims", (Object)this.config_claims_firespreads);
        outConfig.set("GriefPrevention.Claims.FireDamagesInClaims", (Object)this.config_claims_firedamages);
        outConfig.set("GriefPrevention.Claims.LecternReadingRequiresAccessTrust", (Object)this.config_claims_lecternReadingRequiresAccessTrust);
        outConfig.set("GriefPrevention.Spam.Enabled", (Object)this.config_spam_enabled);
        outConfig.set("GriefPrevention.Spam.LoginCooldownSeconds", (Object)this.config_spam_loginCooldownSeconds);
        outConfig.set("GriefPrevention.Spam.LoginLogoutNotificationsPerMinute", (Object)this.config_spam_loginLogoutNotificationsPerMinute);
        outConfig.set("GriefPrevention.Spam.ChatSlashCommands", (Object)slashCommandsToMonitor);
        outConfig.set("GriefPrevention.Spam.WhisperSlashCommands", (Object)whisperCommandsToMonitor);
        outConfig.set("GriefPrevention.Spam.WarningMessage", (Object)this.config_spam_warningMessage);
        outConfig.set("GriefPrevention.Spam.BanOffenders", (Object)this.config_spam_banOffenders);
        outConfig.set("GriefPrevention.Spam.BanMessage", (Object)this.config_spam_banMessage);
        outConfig.set("GriefPrevention.Spam.AllowedIpAddresses", (Object)this.config_spam_allowedIpAddresses);
        outConfig.set("GriefPrevention.Spam.DeathMessageCooldownSeconds", (Object)this.config_spam_deathMessageCooldownSeconds);
        outConfig.set("GriefPrevention.Spam.Logout Message Delay In Seconds", (Object)this.config_spam_logoutMessageDelaySeconds);
        for (World world : worlds) {
            outConfig.set("GriefPrevention.PvP.RulesEnabledInWorld." + world.getName(), (Object)this.pvpRulesApply(world));
        }
        outConfig.set("GriefPrevention.PvP.ProtectFreshSpawns", (Object)this.config_pvp_protectFreshSpawns);
        outConfig.set("GriefPrevention.PvP.PunishLogout", (Object)this.config_pvp_punishLogout);
        outConfig.set("GriefPrevention.PvP.CombatTimeoutSeconds", (Object)this.config_pvp_combatTimeoutSeconds);
        outConfig.set("GriefPrevention.PvP.AllowCombatItemDrop", (Object)this.config_pvp_allowCombatItemDrop);
        outConfig.set("GriefPrevention.PvP.BlockedSlashCommands", (Object)bannedPvPCommandsList);
        outConfig.set("GriefPrevention.PvP.ProtectPlayersInLandClaims.PlayerOwnedClaims", (Object)this.config_pvp_noCombatInPlayerLandClaims);
        outConfig.set("GriefPrevention.PvP.ProtectPlayersInLandClaims.AdministrativeClaims", (Object)this.config_pvp_noCombatInAdminLandClaims);
        outConfig.set("GriefPrevention.PvP.ProtectPlayersInLandClaims.AdministrativeSubdivisions", (Object)this.config_pvp_noCombatInAdminSubdivisions);
        outConfig.set("GriefPrevention.PvP.AllowLavaDumpingNearOtherPlayers.PvPWorlds", (Object)this.config_pvp_allowLavaNearPlayers);
        outConfig.set("GriefPrevention.PvP.AllowLavaDumpingNearOtherPlayers.NonPvPWorlds", (Object)this.config_pvp_allowLavaNearPlayers_NonPvp);
        outConfig.set("GriefPrevention.PvP.AllowFlintAndSteelNearOtherPlayers.PvPWorlds", (Object)this.config_pvp_allowFireNearPlayers);
        outConfig.set("GriefPrevention.PvP.AllowFlintAndSteelNearOtherPlayers.NonPvPWorlds", (Object)this.config_pvp_allowFireNearPlayers_NonPvp);
        outConfig.set("GriefPrevention.PvP.ProtectPetsOutsideLandClaims", (Object)this.config_pvp_protectPets);
        outConfig.set("GriefPrevention.Economy.ClaimBlocksMaxBonus", (Object)this.config_economy_claimBlocksMaxBonus);
        outConfig.set("GriefPrevention.Economy.ClaimBlocksPurchaseCost", (Object)this.config_economy_claimBlocksPurchaseCost);
        outConfig.set("GriefPrevention.Economy.ClaimBlocksSellValue", (Object)this.config_economy_claimBlocksSellValue);
        outConfig.set("GriefPrevention.ProtectItemsDroppedOnDeath.PvPWorlds", (Object)this.config_lockDeathDropsInPvpWorlds);
        outConfig.set("GriefPrevention.ProtectItemsDroppedOnDeath.NonPvPWorlds", (Object)this.config_lockDeathDropsInNonPvpWorlds);
        outConfig.set("GriefPrevention.BlockLandClaimExplosions", (Object)this.config_blockClaimExplosions);
        outConfig.set("GriefPrevention.BlockSurfaceCreeperExplosions", (Object)this.config_blockSurfaceCreeperExplosions);
        outConfig.set("GriefPrevention.BlockSurfaceOtherExplosions", (Object)this.config_blockSurfaceOtherExplosions);
        outConfig.set("GriefPrevention.LimitSkyTrees", (Object)this.config_blockSkyTrees);
        outConfig.set("GriefPrevention.LimitTreeGrowth", (Object)this.config_limitTreeGrowth);
        outConfig.set("GriefPrevention.PistonMovement", (Object)this.config_pistonMovement.name());
        outConfig.set("GriefPrevention.CheckPistonMovement", null);
        outConfig.set("GriefPrevention.LimitPistonsToLandClaims", null);
        outConfig.set("GriefPrevention.PistonExplosionSound", (Object)this.config_pistonExplosionSound);
        outConfig.set("GriefPrevention.FireSpreads", (Object)this.config_fireSpreads);
        outConfig.set("GriefPrevention.FireDestroys", (Object)this.config_fireDestroys);
        outConfig.set("GriefPrevention.AdminsGetWhispers", (Object)this.config_whisperNotifications);
        outConfig.set("GriefPrevention.AdminsGetSignNotifications", (Object)this.config_signNotifications);
        outConfig.set("GriefPrevention.SmartBan", (Object)this.config_smartBan);
        outConfig.set("GriefPrevention.Mute New Players Using Banned Words", (Object)this.config_trollFilterEnabled);
        outConfig.set("GriefPrevention.MaxPlayersPerIpAddress", (Object)this.config_ipLimit);
        outConfig.set("GriefPrevention.Siege.Worlds", siegeEnabledWorldNames);
        outConfig.set("GriefPrevention.Siege.BreakableBlocks", breakableBlocksList);
        outConfig.set("GriefPrevention.Siege.DoorsOpenDelayInSeconds", (Object)this.config_siege_doorsOpenSeconds);
        outConfig.set("GriefPrevention.Siege.CooldownEndInMinutes", (Object)this.config_siege_cooldownEndInMinutes);
        outConfig.set("GriefPrevention.EndermenMoveBlocks", (Object)this.config_endermenMoveBlocks);
        outConfig.set("GriefPrevention.SilverfishBreakBlocks", (Object)this.config_silverfishBreakBlocks);
        outConfig.set("GriefPrevention.CreaturesTrampleCrops", (Object)this.config_creaturesTrampleCrops);
        outConfig.set("GriefPrevention.RabbitsEatCrops", (Object)this.config_rabbitsEatCrops);
        outConfig.set("GriefPrevention.HardModeZombiesBreakDoors", (Object)this.config_zombiesBreakDoors);
        outConfig.set("GriefPrevention.Database.URL", (Object)this.databaseUrl);
        outConfig.set("GriefPrevention.Database.UserName", (Object)this.databaseUserName);
        outConfig.set("GriefPrevention.Database.Password", (Object)this.databasePassword);
        outConfig.set("GriefPrevention.UseBanCommand", (Object)this.config_ban_useCommand);
        outConfig.set("GriefPrevention.BanCommandPattern", (Object)this.config_ban_commandFormat);
        outConfig.set("GriefPrevention.Advanced.fixNegativeClaimblockAmounts", (Object)this.config_advanced_fixNegativeClaimblockAmounts);
        outConfig.set("GriefPrevention.Advanced.ClaimExpirationCheckRate", (Object)this.config_advanced_claim_expiration_check_rate);
        outConfig.set("GriefPrevention.Advanced.OfflinePlayer_cache_days", (Object)this.config_advanced_offlineplayer_cache_days);
        outConfig.set("GriefPrevention.Abridged Logs.Days To Keep", (Object)this.config_logs_daysToKeep);
        outConfig.set("GriefPrevention.Abridged Logs.Included Entry Types.Social Activity", (Object)this.config_logs_socialEnabled);
        outConfig.set("GriefPrevention.Abridged Logs.Included Entry Types.Suspicious Activity", (Object)this.config_logs_suspiciousEnabled);
        outConfig.set("GriefPrevention.Abridged Logs.Included Entry Types.Administrative Activity", (Object)this.config_logs_adminEnabled);
        outConfig.set("GriefPrevention.Abridged Logs.Included Entry Types.Debug", (Object)this.config_logs_debugEnabled);
        outConfig.set("GriefPrevention.Abridged Logs.Included Entry Types.Muted Chat Messages", (Object)this.config_logs_mutedChatEnabled);
        try {
            outConfig.save(DataStore.configFilePath);
        }
        catch (IOException exception) {
            GriefPrevention.AddLogEntry("Unable to write to the configuration file at \"" + DataStore.configFilePath + "\"");
        }
        this.config_claims_commandsRequiringAccessTrust = new ArrayList();
        for (String command : commands = accessTrustSlashCommands.split(";")) {
            if (command.isEmpty()) continue;
            this.config_claims_commandsRequiringAccessTrust.add(command.trim().toLowerCase());
        }
        this.config_spam_monitorSlashCommands = new ArrayList();
        for (String command : commands = slashCommandsToMonitor.split(";")) {
            this.config_spam_monitorSlashCommands.add(command.trim().toLowerCase());
        }
        this.config_eavesdrop_whisperCommands = new ArrayList();
        for (String command : commands = whisperCommandsToMonitor.split(";")) {
            this.config_eavesdrop_whisperCommands.add(command.trim().toLowerCase());
        }
        this.config_pvp_blockedCommands = new ArrayList();
        for (String command : commands = bannedPvPCommandsList.split(";")) {
            this.config_pvp_blockedCommands.add(command.trim().toLowerCase());
        }
    }

    private ClaimsMode configStringToClaimsMode(String configSetting) {
        if (configSetting.equalsIgnoreCase("Survival")) {
            return ClaimsMode.Survival;
        }
        if (configSetting.equalsIgnoreCase("Creative")) {
            return ClaimsMode.Creative;
        }
        if (configSetting.equalsIgnoreCase("Disabled")) {
            return ClaimsMode.Disabled;
        }
        if (configSetting.equalsIgnoreCase("SurvivalRequiringClaims")) {
            return ClaimsMode.SurvivalRequiringClaims;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String idToDrop;
        PlayerData playerData;
        boolean clearPermissions;
        Claim claim;
        Player player;
        block252: {
            player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (cmd.getName().equalsIgnoreCase("claim") && player != null) {
                if (!instance.claimsEnabledForWorld(player.getWorld())) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClaimsDisabledWorld, new String[0]);
                    return true;
                }
                PlayerData playerData2 = this.dataStore.getPlayerData(player.getUniqueId());
                if (GriefPrevention.instance.config_claims_maxClaimsPerPlayer > 0 && !player.hasPermission("griefprevention.overrideclaimcountlimit") && playerData2.getClaims().size() >= GriefPrevention.instance.config_claims_maxClaimsPerPlayer) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClaimCreationFailedOverClaimCountLimit, new String[0]);
                    return true;
                }
                int radius = GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius;
                if (radius < 0) {
                    radius = (int)Math.ceil(Math.sqrt(GriefPrevention.instance.config_claims_minArea) / 2.0);
                }
                if (playerData2.getClaims().size() > 0) {
                    if (playerData2.getClaims().size() == 1 && player.getGameMode() != GameMode.CREATIVE && player.getItemInHand().getType() != GriefPrevention.instance.config_claims_modificationTool) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.MustHoldModificationToolForThat, new String[0]);
                        return true;
                    }
                    radius = (int)Math.ceil(Math.sqrt(GriefPrevention.instance.config_claims_minArea) / 2.0);
                }
                if (args.length > 0) {
                    int specifiedRadius;
                    if (playerData2.getClaims().size() < 2 && player.getGameMode() != GameMode.CREATIVE && player.getItemInHand().getType() != GriefPrevention.instance.config_claims_modificationTool) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.RadiusRequiresGoldenShovel, new String[0]);
                        return true;
                    }
                    try {
                        specifiedRadius = Integer.parseInt(args[0]);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    if (specifiedRadius < radius) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.MinimumRadius, String.valueOf(radius));
                        return true;
                    }
                    radius = specifiedRadius;
                }
                if (radius < 0) {
                    radius = 0;
                }
                Location lc = player.getLocation().add((double)(-radius), 0.0, (double)(-radius));
                Location gc = player.getLocation().add((double)radius, 0.0, (double)radius);
                int area = Math.abs((gc.getBlockX() - lc.getBlockX() + 1) * (gc.getBlockZ() - lc.getBlockZ() + 1));
                int remaining = playerData2.getRemainingClaimBlocks();
                if (remaining < area) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimInsufficientBlocks, String.valueOf(area - remaining));
                    GriefPrevention.instance.dataStore.tryAdvertiseAdminAlternatives(player);
                    return true;
                }
                CreateClaimResult result = this.dataStore.createClaim(lc.getWorld(), lc.getBlockX(), gc.getBlockX(), lc.getBlockY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance - 1, gc.getWorld().getHighestBlockYAt(gc) - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance - 1, lc.getBlockZ(), gc.getBlockZ(), player.getUniqueId(), null, null, player);
                if (!result.succeeded) {
                    if (result.claim != null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapShort, new String[0]);
                        Visualization visualization = Visualization.FromClaim(result.claim, player.getEyeLocation().getBlockY(), VisualizationType.ErrorClaim, player.getLocation());
                        Visualization.Apply(player, visualization);
                        return true;
                    }
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.CreateClaimFailOverlapRegion, new String[0]);
                    return true;
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.CreateClaimSuccess, new String[0]);
                if (instance.creativeRulesApply(player.getLocation())) {
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.CreativeBasicsVideo2, DataStore.CREATIVE_VIDEO_URL);
                } else if (instance.claimsEnabledForWorld(player.getLocation().getWorld())) {
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
                }
                Visualization visualization = Visualization.FromClaim(result.claim, player.getEyeLocation().getBlockY(), VisualizationType.Claim, player.getLocation());
                Visualization.Apply(player, visualization);
                playerData2.claimResizing = null;
                playerData2.lastShovelLocation = null;
                this.autoExtendClaim(result.claim);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("extendclaim") && player != null) {
                int amount;
                if (args.length < 1) {
                    if (instance.creativeRulesApply(player.getLocation())) {
                        GriefPrevention.sendMessage(player, TextMode.Instr, Messages.CreativeBasicsVideo2, DataStore.CREATIVE_VIDEO_URL);
                        return false;
                    }
                    if (!instance.claimsEnabledForWorld(player.getLocation().getWorld())) return false;
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
                    return false;
                }
                try {
                    amount = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException e) {
                    if (instance.creativeRulesApply(player.getLocation())) {
                        GriefPrevention.sendMessage(player, TextMode.Instr, Messages.CreativeBasicsVideo2, DataStore.CREATIVE_VIDEO_URL);
                        return false;
                    }
                    if (!instance.claimsEnabledForWorld(player.getLocation().getWorld())) return false;
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
                    return false;
                }
                if (player.getGameMode() != GameMode.CREATIVE && player.getItemInHand().getType() != GriefPrevention.instance.config_claims_modificationTool) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.MustHoldModificationToolForThat, new String[0]);
                    return true;
                }
                PlayerData playerData3 = this.dataStore.getPlayerData(player.getUniqueId());
                Claim claim2 = this.dataStore.getClaimAt(player.getLocation(), true, playerData3.lastClaim);
                if (claim2 == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.StandInClaimToResize, new String[0]);
                    return true;
                }
                String errorMessage = claim2.allowEdit(player);
                if (errorMessage != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NotYourClaim, new String[0]);
                    return true;
                }
                org.bukkit.util.Vector direction = player.getLocation().getDirection();
                if (direction.getY() > 0.75) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.ClaimsExtendToSky, new String[0]);
                    return true;
                }
                if (direction.getY() < -0.75) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.ClaimsAutoExtendDownward, new String[0]);
                    return true;
                }
                Location lc = claim2.getLesserBoundaryCorner();
                Location gc = claim2.getGreaterBoundaryCorner();
                int newx1 = lc.getBlockX();
                int newx2 = gc.getBlockX();
                int newy1 = lc.getBlockY();
                int newy2 = gc.getBlockY();
                int newz1 = lc.getBlockZ();
                int newz2 = gc.getBlockZ();
                if (Math.abs(direction.getX()) < 0.3) {
                    if (direction.getZ() > 0.0) {
                        newz2 += amount;
                    } else {
                        newz1 -= amount;
                    }
                } else if (Math.abs(direction.getZ()) < 0.3) {
                    if (direction.getX() > 0.0) {
                        newx2 += amount;
                    } else {
                        newx1 -= amount;
                    }
                } else {
                    if (direction.getX() > 0.0) {
                        newx2 += amount;
                    } else {
                        newx1 -= amount;
                    }
                    if (direction.getZ() > 0.0) {
                        newz2 += amount;
                    } else {
                        newz1 -= amount;
                    }
                }
                playerData3.claimResizing = claim2;
                this.dataStore.resizeClaimWithChecks(player, playerData3, newx1, newx2, newy1, newy2, newz1, newz2);
                playerData3.claimResizing = null;
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("abandonclaim") && player != null) {
                return this.abandonClaimHandler(player, false);
            }
            if (cmd.getName().equalsIgnoreCase("abandontoplevelclaim") && player != null) {
                return this.abandonClaimHandler(player, true);
            }
            if (cmd.getName().equalsIgnoreCase("ignoreclaims") && player != null) {
                PlayerData playerData4 = this.dataStore.getPlayerData(player.getUniqueId());
                boolean bl = playerData4.ignoreClaims = !playerData4.ignoreClaims;
                if (!playerData4.ignoreClaims) {
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.RespectingClaims, new String[0]);
                    return true;
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.IgnoringClaims, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("abandonallclaims") && player != null) {
                if (args.length > 1) {
                    return false;
                }
                if (args.length != 1 || !"confirm".equalsIgnoreCase(args[0])) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ConfirmAbandonAllClaims, new String[0]);
                    return true;
                }
                PlayerData playerData5 = this.dataStore.getPlayerData(player.getUniqueId());
                int originalClaimCount = playerData5.getClaims().size();
                if (originalClaimCount == 0) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.YouHaveNoClaims, new String[0]);
                    return true;
                }
                if (this.config_claims_abandonReturnRatio != 1.0) {
                    for (Claim claim3 : playerData5.getClaims()) {
                        playerData5.setAccruedClaimBlocks(playerData5.getAccruedClaimBlocks() - (int)Math.ceil((double)claim3.getArea() * (1.0 - this.config_claims_abandonReturnRatio)));
                    }
                }
                this.dataStore.deleteClaimsForPlayer(player.getUniqueId(), false);
                int remainingBlocks = playerData5.getRemainingClaimBlocks();
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.SuccessfulAbandon, String.valueOf(remainingBlocks));
                Visualization.Revert(player);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("restorenature") && player != null) {
                PlayerData playerData6 = this.dataStore.getPlayerData(player.getUniqueId());
                playerData6.shovelMode = ShovelMode.RestoreNature;
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.RestoreNatureActivate, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("restorenatureaggressive") && player != null) {
                PlayerData playerData7 = this.dataStore.getPlayerData(player.getUniqueId());
                playerData7.shovelMode = ShovelMode.RestoreNatureAggressive;
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.RestoreNatureAggressiveActivate, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("restorenaturefill") && player != null) {
                PlayerData playerData8 = this.dataStore.getPlayerData(player.getUniqueId());
                playerData8.shovelMode = ShovelMode.RestoreNatureFill;
                playerData8.fillRadius = 2;
                if (args.length > 0) {
                    try {
                        playerData8.fillRadius = Integer.parseInt(args[0]);
                    }
                    catch (Exception originalClaimCount) {
                        // empty catch block
                    }
                }
                if (playerData8.fillRadius < 0) {
                    playerData8.fillRadius = 2;
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.FillModeActive, String.valueOf(playerData8.fillRadius));
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("trust") && player != null) {
                if (args.length != 1) {
                    return false;
                }
                this.handleTrustCommand(player, ClaimPermission.Build, args[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("transferclaim") && player != null) {
                Claim claim4 = this.dataStore.getClaimAt(player.getLocation(), true, null);
                if (claim4 == null) {
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.TransferClaimMissing, new String[0]);
                    return true;
                }
                if (claim4.isAdminClaim() && !player.hasPermission("griefprevention.adminclaims")) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.TransferClaimPermission, new String[0]);
                    return true;
                }
                UUID newOwnerID = null;
                String ownerName = "admin";
                if (args.length > 0) {
                    OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
                    if (targetPlayer == null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                        return true;
                    }
                    newOwnerID = targetPlayer.getUniqueId();
                    ownerName = targetPlayer.getName();
                }
                try {
                    this.dataStore.changeClaimOwner(claim4, newOwnerID);
                }
                catch (DataStore.NoTransferException e) {
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.TransferTopLevel, new String[0]);
                    return true;
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.TransferSuccess, new String[0]);
                GriefPrevention.AddLogEntry(player.getName() + " transferred a claim at " + GriefPrevention.getfriendlyLocationString(claim4.getLesserBoundaryCorner()) + " to " + ownerName + ".", CustomLogEntryTypes.AdminActivity);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("trustlist") && player != null) {
                Claim claim5 = this.dataStore.getClaimAt(player.getLocation(), true, null);
                if (claim5 == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.TrustListNoClaim, new String[0]);
                    return true;
                }
                String errorMessage = claim5.allowGrantPermission(player);
                if (errorMessage != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, errorMessage);
                    return true;
                }
                ArrayList<String> builders = new ArrayList<String>();
                ArrayList<String> containers = new ArrayList<String>();
                ArrayList<String> accessors = new ArrayList<String>();
                ArrayList<String> managers = new ArrayList<String>();
                claim5.getPermissions(builders, containers, accessors, managers);
                GriefPrevention.sendMessage(player, TextMode.Info, Messages.TrustListHeader, new String[0]);
                StringBuilder permissions = new StringBuilder();
                permissions.append(ChatColor.GOLD).append('>');
                if (managers.size() > 0) {
                    for (String manager : managers) {
                        permissions.append(this.trustEntryToPlayerName(manager)).append(' ');
                    }
                }
                player.sendMessage(permissions.toString());
                permissions = new StringBuilder();
                permissions.append(ChatColor.YELLOW).append('>');
                if (builders.size() > 0) {
                    for (String builder : builders) {
                        permissions.append(this.trustEntryToPlayerName(builder)).append(' ');
                    }
                }
                player.sendMessage(permissions.toString());
                permissions = new StringBuilder();
                permissions.append(ChatColor.GREEN).append('>');
                if (containers.size() > 0) {
                    for (String container : containers) {
                        permissions.append(this.trustEntryToPlayerName(container)).append(' ');
                    }
                }
                player.sendMessage(permissions.toString());
                permissions = new StringBuilder();
                permissions.append(ChatColor.BLUE).append('>');
                if (accessors.size() > 0) {
                    for (String accessor : accessors) {
                        permissions.append(this.trustEntryToPlayerName(accessor)).append(' ');
                    }
                }
                player.sendMessage(permissions.toString());
                player.sendMessage(ChatColor.GOLD + this.dataStore.getMessage(Messages.Manage, new String[0]) + " " + ChatColor.YELLOW + this.dataStore.getMessage(Messages.Build, new String[0]) + " " + ChatColor.GREEN + this.dataStore.getMessage(Messages.Containers, new String[0]) + " " + ChatColor.BLUE + this.dataStore.getMessage(Messages.Access, new String[0]));
                if (!claim5.getSubclaimRestrictions()) return true;
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.HasSubclaimRestriction, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("untrust") && player != null) {
                if (args.length != 1) {
                    return false;
                }
                claim = this.dataStore.getClaimAt(player.getLocation(), true, null);
                if (args[0].contains(".") && !args[0].startsWith("[") && !args[0].endsWith("]")) {
                    args[0] = "[" + args[0] + "]";
                }
                clearPermissions = false;
                OfflinePlayer otherPlayer = null;
                if (args[0].equals("all")) {
                    if (claim != null && claim.allowEdit(player) != null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClearPermsOwnerOnly, new String[0]);
                        return true;
                    }
                    clearPermissions = true;
                } else if (!args[0].startsWith("[") || !args[0].endsWith("]")) {
                    otherPlayer = this.resolvePlayerByName(args[0]);
                    if (!clearPermissions && otherPlayer == null && !args[0].equals("public")) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                        return true;
                    }
                    if (otherPlayer != null) {
                        args[0] = otherPlayer.getName();
                    }
                }
                if (claim == null) {
                    playerData = this.dataStore.getPlayerData(player.getUniqueId());
                    idToDrop = args[0];
                    if (otherPlayer != null) {
                        idToDrop = otherPlayer.getUniqueId().toString();
                    }
                    TrustChangedEvent event = new TrustChangedEvent(player, playerData.getClaims(), null, false, idToDrop);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return true;
                    }
                    break block252;
                } else {
                    if (claim.allowGrantPermission(player) != null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoPermissionTrust, claim.getOwnerName());
                        return true;
                    }
                    if (clearPermissions) {
                        if (claim.allowEdit(player) != null) {
                            GriefPrevention.sendMessage(player, TextMode.Err, Messages.UntrustAllOwnerOnly, new String[0]);
                            return true;
                        }
                        TrustChangedEvent event = new TrustChangedEvent(player, claim, null, false, args[0]);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return true;
                        }
                        claim.clearPermissions();
                        GriefPrevention.sendMessage(player, TextMode.Success, Messages.ClearPermissionsOneClaim, new String[0]);
                    } else {
                        boolean targetIsManager;
                        String idToDrop2 = args[0];
                        if (otherPlayer != null) {
                            idToDrop2 = otherPlayer.getUniqueId().toString();
                        }
                        if ((targetIsManager = claim.managers.contains(idToDrop2)) && claim.allowEdit(player) != null) {
                            GriefPrevention.sendMessage(player, TextMode.Err, Messages.ManagersDontUntrustManagers, claim.getOwnerName());
                            return true;
                        }
                        TrustChangedEvent event = new TrustChangedEvent(player, claim, null, false, idToDrop2);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            return true;
                        }
                        claim.dropPermission(idToDrop2);
                        claim.managers.remove(idToDrop2);
                        if (args[0].equals("public")) {
                            args[0] = "the public";
                        }
                        GriefPrevention.sendMessage(player, TextMode.Success, Messages.UntrustIndividualSingleClaim, args[0]);
                    }
                    this.dataStore.saveClaim(claim);
                    return true;
                }
            }
            if (cmd.getName().equalsIgnoreCase("accesstrust") && player != null) {
                if (args.length != 1) {
                    return false;
                }
                this.handleTrustCommand(player, ClaimPermission.Access, args[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("containertrust") && player != null) {
                if (args.length != 1) {
                    return false;
                }
                this.handleTrustCommand(player, ClaimPermission.Inventory, args[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("permissiontrust") && player != null) {
                if (args.length != 1) {
                    return false;
                }
                this.handleTrustCommand(player, null, args[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("restrictsubclaim") && player != null) {
                PlayerData playerData9 = this.dataStore.getPlayerData(player.getUniqueId());
                Claim claim6 = this.dataStore.getClaimAt(player.getLocation(), true, playerData9.lastClaim);
                if (claim6 == null || claim6.parent == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.StandInSubclaim, new String[0]);
                    return true;
                }
                if (!playerData9.ignoreClaims && (claim6.isAdminClaim() ? !player.hasPermission("griefprevention.adminclaims") : !player.getUniqueId().equals(claim6.parent.ownerID))) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.OnlyOwnersModifyClaims, claim6.getOwnerName());
                    return true;
                }
                if (claim6.getSubclaimRestrictions()) {
                    claim6.setSubclaimRestrictions(false);
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.SubclaimUnrestricted, new String[0]);
                } else {
                    claim6.setSubclaimRestrictions(true);
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.SubclaimRestricted, new String[0]);
                }
                this.dataStore.saveClaim(claim6);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("buyclaimblocks") && player != null) {
                int blockCount;
                EconomyHandler.EconomyWrapper economyWrapper = this.economyHandler.getWrapper();
                if (economyWrapper == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.BuySellNotConfigured, new String[0]);
                    return true;
                }
                if (!player.hasPermission("griefprevention.buysellclaimblocks")) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoPermissionForCommand, new String[0]);
                    return true;
                }
                if (GriefPrevention.instance.config_economy_claimBlocksPurchaseCost == 0.0) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.OnlySellBlocks, new String[0]);
                    return true;
                }
                Economy economy = economyWrapper.getEconomy();
                if (args.length != 1) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BlockPurchaseCost, String.valueOf(GriefPrevention.instance.config_economy_claimBlocksPurchaseCost), String.valueOf(economy.getBalance((OfflinePlayer)player)));
                    return false;
                }
                PlayerData playerData10 = this.dataStore.getPlayerData(player.getUniqueId());
                try {
                    blockCount = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (blockCount <= 0) {
                    return false;
                }
                double totalCost = (double)blockCount * GriefPrevention.instance.config_economy_claimBlocksPurchaseCost;
                double balance = economy.getBalance((OfflinePlayer)player);
                if (totalCost > balance) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.InsufficientFunds, String.valueOf(totalCost), String.valueOf(balance));
                    return true;
                }
                int newBonusClaimBlocks = playerData10.getBonusClaimBlocks() + blockCount;
                int bonusBlocksLimit = GriefPrevention.instance.config_economy_claimBlocksMaxBonus;
                if (bonusBlocksLimit != 0 && newBonusClaimBlocks > bonusBlocksLimit) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.MaxBonusReached, String.valueOf(blockCount), String.valueOf(bonusBlocksLimit));
                    return true;
                }
                economy.withdrawPlayer((OfflinePlayer)player, totalCost);
                playerData10.setBonusClaimBlocks(playerData10.getBonusClaimBlocks() + blockCount);
                this.dataStore.savePlayerData(player.getUniqueId(), playerData10);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.PurchaseConfirmation, String.valueOf(totalCost), String.valueOf(playerData10.getRemainingClaimBlocks()));
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("sellclaimblocks") && player != null) {
                int blockCount;
                EconomyHandler.EconomyWrapper economyWrapper = this.economyHandler.getWrapper();
                if (economyWrapper == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.BuySellNotConfigured, new String[0]);
                    return true;
                }
                if (!player.hasPermission("griefprevention.buysellclaimblocks")) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoPermissionForCommand, new String[0]);
                    return true;
                }
                if (GriefPrevention.instance.config_economy_claimBlocksSellValue == 0.0) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.OnlyPurchaseBlocks, new String[0]);
                    return true;
                }
                PlayerData playerData11 = this.dataStore.getPlayerData(player.getUniqueId());
                int availableBlocks = playerData11.getRemainingClaimBlocks();
                if (args.length != 1) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.BlockSaleValue, String.valueOf(GriefPrevention.instance.config_economy_claimBlocksSellValue), String.valueOf(availableBlocks));
                    return false;
                }
                try {
                    blockCount = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (blockCount <= 0) {
                    return false;
                }
                if (blockCount > availableBlocks) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NotEnoughBlocksForSale, new String[0]);
                    return true;
                }
                double totalValue = (double)blockCount * GriefPrevention.instance.config_economy_claimBlocksSellValue;
                economyWrapper.getEconomy().depositPlayer((OfflinePlayer)player, totalValue);
                playerData11.setBonusClaimBlocks(playerData11.getBonusClaimBlocks() - blockCount);
                this.dataStore.savePlayerData(player.getUniqueId(), playerData11);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.BlockSaleConfirmation, String.valueOf(totalValue), String.valueOf(playerData11.getRemainingClaimBlocks()));
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("adminclaims") && player != null) {
                PlayerData playerData12 = this.dataStore.getPlayerData(player.getUniqueId());
                playerData12.shovelMode = ShovelMode.Admin;
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.AdminClaimsMode, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("basicclaims") && player != null) {
                PlayerData playerData13 = this.dataStore.getPlayerData(player.getUniqueId());
                playerData13.shovelMode = ShovelMode.Basic;
                playerData13.claimSubdividing = null;
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.BasicClaimsMode, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("subdivideclaims") && player != null) {
                PlayerData playerData14 = this.dataStore.getPlayerData(player.getUniqueId());
                playerData14.shovelMode = ShovelMode.Subdivide;
                playerData14.claimSubdividing = null;
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SubdivisionMode, new String[0]);
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SubdivisionVideo2, DataStore.SUBDIVISION_VIDEO_URL);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("deleteclaim") && player != null) {
                Claim claim7 = this.dataStore.getClaimAt(player.getLocation(), true, null);
                if (claim7 == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.DeleteClaimMissing, new String[0]);
                    return true;
                }
                if (claim7.isAdminClaim() && !player.hasPermission("griefprevention.adminclaims")) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.CantDeleteAdminClaim, new String[0]);
                    return true;
                }
                PlayerData playerData15 = this.dataStore.getPlayerData(player.getUniqueId());
                if (claim7.children.size() > 0 && !playerData15.warnedAboutMajorDeletion) {
                    GriefPrevention.sendMessage(player, TextMode.Warn, Messages.DeletionSubdivisionWarning, new String[0]);
                    playerData15.warnedAboutMajorDeletion = true;
                    return true;
                }
                claim7.removeSurfaceFluids(null);
                this.dataStore.deleteClaim(claim7, true, true);
                if (instance.creativeRulesApply(claim7.getLesserBoundaryCorner()) || GriefPrevention.instance.config_claims_survivalAutoNatureRestoration) {
                    instance.restoreClaim(claim7, 0L);
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.DeleteSuccess, new String[0]);
                GriefPrevention.AddLogEntry(player.getName() + " deleted " + claim7.getOwnerName() + "'s claim at " + GriefPrevention.getfriendlyLocationString(claim7.getLesserBoundaryCorner()), CustomLogEntryTypes.AdminActivity);
                Visualization.Revert(player);
                playerData15.warnedAboutMajorDeletion = false;
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("claimexplosions") && player != null) {
                Claim claim8 = this.dataStore.getClaimAt(player.getLocation(), true, null);
                if (claim8 == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.DeleteClaimMissing, new String[0]);
                    return true;
                }
                String noBuildReason = claim8.allowBuild(player, Material.STONE);
                if (noBuildReason != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
                    return true;
                }
                if (claim8.areExplosivesAllowed) {
                    claim8.areExplosivesAllowed = false;
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.ExplosivesDisabled, new String[0]);
                    return true;
                }
                claim8.areExplosivesAllowed = true;
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.ExplosivesEnabled, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("deleteallclaims")) {
                if (args.length != 1) {
                    return false;
                }
                OfflinePlayer otherPlayer = this.resolvePlayerByName(args[0]);
                if (otherPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                this.dataStore.deleteClaimsForPlayer(otherPlayer.getUniqueId(), true);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.DeleteAllSuccess, otherPlayer.getName());
                if (player == null) return true;
                GriefPrevention.AddLogEntry(player.getName() + " deleted all claims belonging to " + otherPlayer.getName() + ".", CustomLogEntryTypes.AdminActivity);
                Visualization.Revert(player);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("deleteclaimsinworld")) {
                if (player != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ConsoleOnlyCommand, new String[0]);
                    return true;
                }
                if (args.length != 1) {
                    return false;
                }
                World world = Bukkit.getServer().getWorld(args[0]);
                if (world == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.WorldNotFound, new String[0]);
                    return true;
                }
                this.dataStore.deleteClaimsInWorld(world, true);
                GriefPrevention.AddLogEntry("Deleted all claims in world: " + world.getName() + ".", CustomLogEntryTypes.AdminActivity);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("deleteuserclaimsinworld")) {
                if (player != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.ConsoleOnlyCommand, new String[0]);
                    return true;
                }
                if (args.length != 1) {
                    return false;
                }
                World world = Bukkit.getServer().getWorld(args[0]);
                if (world == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.WorldNotFound, new String[0]);
                    return true;
                }
                this.dataStore.deleteClaimsInWorld(world, false);
                GriefPrevention.AddLogEntry("Deleted all user claims in world: " + world.getName() + ".", CustomLogEntryTypes.AdminActivity);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("claimbook")) {
                if (args.length != 1) {
                    return false;
                }
                Player otherPlayer = this.getServer().getPlayer(args[0]);
                if (otherPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                WelcomeTask task = new WelcomeTask(otherPlayer);
                task.run();
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("claimslist")) {
                Player otherPlayer;
                if (args.length > 1) {
                    return false;
                }
                if (args.length < 1) {
                    if (player == null) return false;
                    otherPlayer = player;
                } else {
                    if (player != null && !player.hasPermission("griefprevention.claimslistother")) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.ClaimsListNoPermission, new String[0]);
                        return true;
                    }
                    otherPlayer = this.resolvePlayerByName(args[0]);
                    if (otherPlayer == null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                        return true;
                    }
                }
                PlayerData playerData16 = this.dataStore.getPlayerData(otherPlayer.getUniqueId());
                Vector<Claim> claims = playerData16.getClaims();
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.StartBlockMath, String.valueOf(playerData16.getAccruedClaimBlocks()), String.valueOf(playerData16.getBonusClaimBlocks() + this.dataStore.getGroupBonusBlocks(otherPlayer.getUniqueId())), String.valueOf(playerData16.getAccruedClaimBlocks() + playerData16.getBonusClaimBlocks() + this.dataStore.getGroupBonusBlocks(otherPlayer.getUniqueId())));
                if (claims.size() > 0) {
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ClaimsListHeader, new String[0]);
                    for (int i = 0; i < playerData16.getClaims().size(); ++i) {
                        Claim claim9 = playerData16.getClaims().get(i);
                        GriefPrevention.sendMessage(player, TextMode.Instr, GriefPrevention.getfriendlyLocationString(claim9.getLesserBoundaryCorner()) + this.dataStore.getMessage(Messages.ContinueBlockMath, String.valueOf(claim9.getArea())));
                    }
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.EndBlockMath, String.valueOf(playerData16.getRemainingClaimBlocks()));
                }
                if (otherPlayer.isOnline()) return true;
                this.dataStore.clearCachedPlayerData(otherPlayer.getUniqueId());
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("adminclaimslist")) {
                Vector<Claim> claims = new Vector<Claim>();
                for (Claim claim10 : this.dataStore.claims) {
                    if (claim10.ownerID != null) continue;
                    claims.add(claim10);
                }
                if (claims.size() <= 0) return true;
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ClaimsListHeader, new String[0]);
                Iterator<Claim> playerData16 = claims.iterator();
                while (playerData16.hasNext()) {
                    Claim claim10;
                    claim10 = playerData16.next();
                    GriefPrevention.sendMessage(player, TextMode.Instr, GriefPrevention.getfriendlyLocationString(claim10.getLesserBoundaryCorner()));
                }
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("unlockdrops") && player != null) {
                PlayerData playerData17;
                if (player.hasPermission("griefprevention.unlockothersdrops") && args.length == 1) {
                    Player otherPlayer = Bukkit.getPlayer((String)args[0]);
                    if (otherPlayer == null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                        return true;
                    }
                    playerData17 = this.dataStore.getPlayerData(otherPlayer.getUniqueId());
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.DropUnlockOthersConfirmation, otherPlayer.getName());
                } else {
                    playerData17 = this.dataStore.getPlayerData(player.getUniqueId());
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.DropUnlockConfirmation, new String[0]);
                }
                playerData17.dropsAreUnlocked = true;
                return true;
            }
            if (player != null && cmd.getName().equalsIgnoreCase("deletealladminclaims")) {
                if (!player.hasPermission("griefprevention.deleteclaims")) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoDeletePermission, new String[0]);
                    return true;
                }
                this.dataStore.deleteClaimsForPlayer(null, true);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.AllAdminDeleted, new String[0]);
                if (player == null) return true;
                GriefPrevention.AddLogEntry(player.getName() + " deleted all administrative claims.", CustomLogEntryTypes.AdminActivity);
                Visualization.Revert(player);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("adjustbonusclaimblocks")) {
                OfflinePlayer targetPlayer;
                int adjustment;
                if (args.length != 2) {
                    return false;
                }
                try {
                    adjustment = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (args[0].startsWith("[") && args[0].endsWith("]")) {
                    String permissionIdentifier = args[0].substring(1, args[0].length() - 1);
                    int newTotal = this.dataStore.adjustGroupBonusBlocks(permissionIdentifier, adjustment);
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.AdjustGroupBlocksSuccess, permissionIdentifier, String.valueOf(adjustment), String.valueOf(newTotal));
                    if (player == null) return true;
                    GriefPrevention.AddLogEntry(player.getName() + " adjusted " + permissionIdentifier + "'s bonus claim blocks by " + adjustment + ".");
                    return true;
                }
                try {
                    UUID playerID = UUID.fromString(args[0]);
                    targetPlayer = this.getServer().getOfflinePlayer(playerID);
                }
                catch (IllegalArgumentException e) {
                    targetPlayer = this.resolvePlayerByName(args[0]);
                }
                if (targetPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                PlayerData playerData18 = this.dataStore.getPlayerData(targetPlayer.getUniqueId());
                playerData18.setBonusClaimBlocks(playerData18.getBonusClaimBlocks() + adjustment);
                this.dataStore.savePlayerData(targetPlayer.getUniqueId(), playerData18);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.AdjustBlocksSuccess, targetPlayer.getName(), String.valueOf(adjustment), String.valueOf(playerData18.getBonusClaimBlocks()));
                if (player == null) return true;
                GriefPrevention.AddLogEntry(player.getName() + " adjusted " + targetPlayer.getName() + "'s bonus claim blocks by " + adjustment + ".", CustomLogEntryTypes.AdminActivity);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("adjustbonusclaimblocksall")) {
                int adjustment;
                if (args.length != 1) {
                    return false;
                }
                try {
                    adjustment = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                Collection players = this.getServer().getOnlinePlayers();
                StringBuilder builder = new StringBuilder();
                Iterator i = players.iterator();
                while (true) {
                    if (!i.hasNext()) {
                        GriefPrevention.sendMessage(player, TextMode.Success, Messages.AdjustBlocksAllSuccess, String.valueOf(adjustment));
                        GriefPrevention.AddLogEntry("Adjusted all " + players.size() + "players' bonus claim blocks by " + adjustment + ".  " + builder.toString(), CustomLogEntryTypes.AdminActivity);
                        return true;
                    }
                    Player onlinePlayer = (Player)i.next();
                    UUID playerID = onlinePlayer.getUniqueId();
                    PlayerData playerData19 = this.dataStore.getPlayerData(playerID);
                    playerData19.setBonusClaimBlocks(playerData19.getBonusClaimBlocks() + adjustment);
                    this.dataStore.savePlayerData(playerID, playerData19);
                    builder.append(onlinePlayer.getName()).append(' ');
                }
            }
            if (cmd.getName().equalsIgnoreCase("setaccruedclaimblocks")) {
                int newAmount;
                if (args.length != 2) {
                    return false;
                }
                try {
                    newAmount = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
                if (targetPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                PlayerData playerData20 = this.dataStore.getPlayerData(targetPlayer.getUniqueId());
                playerData20.setAccruedClaimBlocks(newAmount);
                this.dataStore.savePlayerData(targetPlayer.getUniqueId(), playerData20);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.SetClaimBlocksSuccess, new String[0]);
                if (player == null) return true;
                GriefPrevention.AddLogEntry(player.getName() + " set " + targetPlayer.getName() + "'s accrued claim blocks to " + newAmount + ".", CustomLogEntryTypes.AdminActivity);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("trapped") && player != null) {
                PlayerData playerData21 = this.dataStore.getPlayerData(player.getUniqueId());
                Claim claim11 = this.dataStore.getClaimAt(player.getLocation(), false, playerData21.lastClaim);
                if (playerData21.pendingTrapped) {
                    return true;
                }
                if (claim11 == null || claim11.allowBuild(player, Material.AIR) == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NotTrappedHere, new String[0]);
                    return true;
                }
                SaveTrappedPlayerEvent event = new SaveTrappedPlayerEvent(claim11);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (player.getWorld().getEnvironment() != World.Environment.NORMAL && event.getDestination() == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.TrappedWontWorkHere, new String[0]);
                    return true;
                }
                if (!GriefPrevention.instance.config_claims_allowTrappedInAdminClaims && claim11.isAdminClaim() && event.getDestination() == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.TrappedWontWorkHere, new String[0]);
                    return true;
                }
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.RescuePending, new String[0]);
                PlayerRescueTask task = new PlayerRescueTask(player, player.getLocation(), event.getDestination());
                this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)task, 200L);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("siege") && player != null) {
                if (!this.siegeEnabledForWorld(player.getWorld())) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NonSiegeWorld, new String[0]);
                    return true;
                }
                if (args.length > 1) {
                    return false;
                }
                Player attacker = player;
                PlayerData attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
                if (attackerData.siegeData != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.AlreadySieging, new String[0]);
                    return true;
                }
                if (attackerData.pvpImmune) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.CantFightWhileImmune, new String[0]);
                    return true;
                }
                Player defender = null;
                if (args.length >= 1) {
                    defender = this.getServer().getPlayer(args[0]);
                    if (defender == null) {
                        GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                        return true;
                    }
                } else {
                    if (attackerData.lastPvpPlayer.length() <= 0) return false;
                    defender = this.getServer().getPlayer(attackerData.lastPvpPlayer);
                    if (defender == null) {
                        return false;
                    }
                }
                if (attacker.getName().equals(defender.getName())) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoSiegeYourself, new String[0]);
                    return true;
                }
                if (defender.hasPermission("griefprevention.siegeimmune")) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeImmune, new String[0]);
                    return true;
                }
                PlayerData defenderData = this.dataStore.getPlayerData(defender.getUniqueId());
                if (defenderData.siegeData != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.AlreadyUnderSiegePlayer, new String[0]);
                    return true;
                }
                if (defenderData.pvpImmune) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoSiegeDefenseless, new String[0]);
                    return true;
                }
                Claim defenderClaim = this.dataStore.getClaimAt(defender.getLocation(), false, null);
                if (defenderClaim == null || defenderClaim.allowAccess(defender) != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NotSiegableThere, new String[0]);
                    return true;
                }
                if (!defenderClaim.isNear(attacker.getLocation(), 25)) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeTooFarAway, new String[0]);
                    return true;
                }
                if (defenderClaim.siegeData != null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.AlreadyUnderSiegeArea, new String[0]);
                    return true;
                }
                if (defenderClaim.isAdminClaim()) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoSiegeAdminClaim, new String[0]);
                    return true;
                }
                if (this.dataStore.onCooldown(attacker, defender, defenderClaim)) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.SiegeOnCooldown, new String[0]);
                    return true;
                }
                this.dataStore.startSiege(attacker, defender, defenderClaim);
                GriefPrevention.sendMessage(defender, TextMode.Warn, Messages.SiegeAlert, attacker.getName());
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.SiegeConfirmed, defender.getName());
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("softmute")) {
                if (args.length != 1) {
                    return false;
                }
                OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
                if (targetPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                boolean isMuted = this.dataStore.toggleSoftMute(targetPlayer.getUniqueId());
                if (!isMuted) {
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.UnSoftMuted, targetPlayer.getName());
                    return true;
                }
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.SoftMuted, targetPlayer.getName());
                String executorName = "console";
                if (player != null) {
                    executorName = player.getName();
                }
                GriefPrevention.AddLogEntry(executorName + " muted " + targetPlayer.getName() + ".", CustomLogEntryTypes.AdminActivity, true);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("gpreload")) {
                this.loadConfig();
                if (player != null) {
                    GriefPrevention.sendMessage(player, TextMode.Success, "Configuration updated.  If you have updated your Grief Prevention JAR, you still need to /reload or reboot your server.");
                    return true;
                }
                GriefPrevention.AddLogEntry("Configuration updated.  If you have updated your Grief Prevention JAR, you still need to /reload or reboot your server.");
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("givepet") && player != null) {
                if (args.length < 1) {
                    return false;
                }
                PlayerData playerData22 = this.dataStore.getPlayerData(player.getUniqueId());
                if (args[0].equalsIgnoreCase("cancel")) {
                    playerData22.petGiveawayRecipient = null;
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.PetTransferCancellation, new String[0]);
                    return true;
                }
                OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
                if (targetPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                playerData22.petGiveawayRecipient = targetPlayer;
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ReadyToTransferPet, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("gpblockinfo") && player != null) {
                ItemStack inHand = player.getInventory().getItemInMainHand();
                player.sendMessage("In Hand: " + inHand.getType().name());
                Block inWorld = player.getTargetBlockExact(300, FluidCollisionMode.ALWAYS);
                if (inWorld == null) {
                    inWorld = player.getEyeLocation().getBlock();
                }
                player.sendMessage("In World: " + inWorld.getType().name());
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("ignoreplayer") && player != null) {
                if (args.length < 1) {
                    return false;
                }
                OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
                if (targetPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                this.setIgnoreStatus((OfflinePlayer)player, targetPlayer, IgnoreMode.StandardIgnore);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.IgnoreConfirmation, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("unignoreplayer") && player != null) {
                if (args.length < 1) {
                    return false;
                }
                OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
                if (targetPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                PlayerData playerData23 = this.dataStore.getPlayerData(player.getUniqueId());
                Boolean ignoreStatus = playerData23.ignoredPlayers.get(targetPlayer.getUniqueId());
                if (ignoreStatus != null && !ignoreStatus.booleanValue()) {
                    this.setIgnoreStatus((OfflinePlayer)player, targetPlayer, IgnoreMode.None);
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.UnIgnoreConfirmation, new String[0]);
                    return true;
                }
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NotIgnoringPlayer, new String[0]);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("ignoredplayerlist") && player != null) {
                PlayerData playerData24 = this.dataStore.getPlayerData(player.getUniqueId());
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<UUID, Boolean> entry : playerData24.ignoredPlayers.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().booleanValue()) continue;
                    builder.append(GriefPrevention.lookupPlayerName(entry.getKey()));
                    builder.append(" ");
                }
                String list = builder.toString().trim();
                if (list.isEmpty()) {
                    GriefPrevention.sendMessage(player, TextMode.Info, Messages.NotIgnoringAnyone, new String[0]);
                    return true;
                }
                GriefPrevention.sendMessage(player, TextMode.Info, list);
                return true;
            }
            if (cmd.getName().equalsIgnoreCase("separate")) {
                if (args.length < 2) {
                    return false;
                }
                OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
                if (targetPlayer == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                OfflinePlayer targetPlayer2 = this.resolvePlayerByName(args[1]);
                if (targetPlayer2 == null) {
                    GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                    return true;
                }
                this.setIgnoreStatus(targetPlayer, targetPlayer2, IgnoreMode.AdminIgnore);
                GriefPrevention.sendMessage(player, TextMode.Success, Messages.SeparateConfirmation, new String[0]);
                return true;
            }
            if (!cmd.getName().equalsIgnoreCase("unseparate")) return false;
            if (args.length < 2) {
                return false;
            }
            OfflinePlayer targetPlayer = this.resolvePlayerByName(args[0]);
            if (targetPlayer == null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                return true;
            }
            OfflinePlayer targetPlayer2 = this.resolvePlayerByName(args[1]);
            if (targetPlayer2 == null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                return true;
            }
            this.setIgnoreStatus(targetPlayer, targetPlayer2, IgnoreMode.None);
            this.setIgnoreStatus(targetPlayer2, targetPlayer, IgnoreMode.None);
            GriefPrevention.sendMessage(player, TextMode.Success, Messages.UnSeparateConfirmation, new String[0]);
            return true;
        }
        for (int i = 0; i < playerData.getClaims().size(); ++i) {
            claim = playerData.getClaims().get(i);
            if (clearPermissions) {
                claim.clearPermissions();
            } else {
                claim.dropPermission(idToDrop);
                claim.managers.remove(idToDrop);
            }
            this.dataStore.saveClaim(claim);
        }
        if (args[0].equals("public")) {
            args[0] = "the public";
        }
        if (!clearPermissions) {
            GriefPrevention.sendMessage(player, TextMode.Success, Messages.UntrustIndividualAllClaims, args[0]);
            return true;
        }
        GriefPrevention.sendMessage(player, TextMode.Success, Messages.UntrustEveryoneAllClaims, new String[0]);
        return true;
    }

    void setIgnoreStatus(OfflinePlayer ignorer, OfflinePlayer ignoree, IgnoreMode mode) {
        PlayerData playerData = this.dataStore.getPlayerData(ignorer.getUniqueId());
        if (mode == IgnoreMode.None) {
            playerData.ignoredPlayers.remove(ignoree.getUniqueId());
        } else {
            playerData.ignoredPlayers.put(ignoree.getUniqueId(), mode != IgnoreMode.StandardIgnore);
        }
        playerData.ignoreListChanged = true;
        if (!ignorer.isOnline()) {
            this.dataStore.savePlayerData(ignorer.getUniqueId(), playerData);
            this.dataStore.clearCachedPlayerData(ignorer.getUniqueId());
        }
    }

    private String trustEntryToPlayerName(String entry) {
        if (entry.startsWith("[") || entry.equals("public")) {
            return entry;
        }
        return GriefPrevention.lookupPlayerName(entry);
    }

    public static String getfriendlyLocationString(Location location) {
        return location.getWorld().getName() + ": x" + location.getBlockX() + ", z" + location.getBlockZ();
    }

    private boolean abandonClaimHandler(Player player, boolean deleteTopLevelClaim) {
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(player.getLocation(), true, null);
        if (claim == null) {
            GriefPrevention.sendMessage(player, TextMode.Instr, Messages.AbandonClaimMissing, new String[0]);
        } else if (claim.allowEdit(player) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.NotYourClaim, new String[0]);
        } else {
            if (claim.children.size() > 0 && !deleteTopLevelClaim) {
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.DeleteTopLevelClaim, new String[0]);
                return true;
            }
            claim.removeSurfaceFluids(null);
            this.dataStore.deleteClaim(claim, true, false);
            if (instance.creativeRulesApply(claim.getLesserBoundaryCorner())) {
                GriefPrevention.AddLogEntry(player.getName() + " abandoned a claim @ " + GriefPrevention.getfriendlyLocationString(claim.getLesserBoundaryCorner()));
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.UnclaimCleanupWarning, new String[0]);
                instance.restoreClaim(claim, 2400L);
            }
            if (this.config_claims_abandonReturnRatio != 1.0 && claim.parent == null && claim.ownerID.equals(playerData.playerID)) {
                playerData.setAccruedClaimBlocks(playerData.getAccruedClaimBlocks() - (int)Math.ceil((double)claim.getArea() * (1.0 - this.config_claims_abandonReturnRatio)));
            }
            int remainingBlocks = playerData.getRemainingClaimBlocks();
            GriefPrevention.sendMessage(player, TextMode.Success, Messages.AbandonSuccess, String.valueOf(remainingBlocks));
            Visualization.Revert(player);
            playerData.warnedAboutMajorDeletion = false;
        }
        return true;
    }

    private void handleTrustCommand(Player player, ClaimPermission permissionLevel, String recipientName) {
        Claim claim = this.dataStore.getClaimAt(player.getLocation(), true, null);
        String permission = null;
        OfflinePlayer otherPlayer = null;
        UUID recipientID = null;
        if (recipientName.startsWith("[") && recipientName.endsWith("]")) {
            permission = recipientName.substring(1, recipientName.length() - 1);
            if (permission == null || permission.isEmpty()) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.InvalidPermissionID, new String[0]);
                return;
            }
        } else if (recipientName.contains(".")) {
            permission = recipientName;
        } else {
            otherPlayer = this.resolvePlayerByName(recipientName);
            if (otherPlayer == null && !recipientName.equals("public") && !recipientName.equals("all")) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerNotFound2, new String[0]);
                return;
            }
            if (otherPlayer != null) {
                recipientName = otherPlayer.getName();
                recipientID = otherPlayer.getUniqueId();
            } else {
                recipientName = "public";
            }
        }
        ArrayList<Claim> targetClaims = new ArrayList<Claim>();
        if (claim == null) {
            PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
            targetClaims.addAll(playerData.getClaims());
        } else {
            if (claim.allowGrantPermission(player) != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.NoPermissionTrust, claim.getOwnerName());
                return;
            }
            String errorMessage = null;
            if (permissionLevel == null) {
                errorMessage = claim.allowEdit(player);
                if (errorMessage != null) {
                    errorMessage = "Only " + claim.getOwnerName() + " can grant /PermissionTrust here.";
                }
            } else {
                switch (permissionLevel) {
                    case Access: {
                        errorMessage = claim.allowAccess(player);
                        break;
                    }
                    case Inventory: {
                        errorMessage = claim.allowContainers(player);
                        break;
                    }
                    default: {
                        errorMessage = claim.allowBuild(player, Material.AIR);
                    }
                }
            }
            if (errorMessage != null) {
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.CantGrantThatPermission, new String[0]);
                return;
            }
            targetClaims.add(claim);
        }
        if (targetClaims.size() == 0) {
            GriefPrevention.sendMessage(player, TextMode.Err, Messages.GrantPermissionNoClaim, new String[0]);
            return;
        }
        String identifierToAdd = recipientName;
        if (permission != null) {
            identifierToAdd = "[" + permission + "]";
        } else if (recipientID != null) {
            identifierToAdd = recipientID.toString();
        }
        TrustChangedEvent event = new TrustChangedEvent(player, targetClaims, permissionLevel, true, identifierToAdd);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        for (Claim currentClaim : targetClaims) {
            if (permissionLevel == null) {
                if (!currentClaim.managers.contains(identifierToAdd)) {
                    currentClaim.managers.add(identifierToAdd);
                }
            } else {
                currentClaim.setPermission(identifierToAdd, permissionLevel);
            }
            this.dataStore.saveClaim(currentClaim);
        }
        if (recipientName.equals("public")) {
            recipientName = this.dataStore.getMessage(Messages.CollectivePublic, new String[0]);
        }
        String permissionDescription = permissionLevel == null ? this.dataStore.getMessage(Messages.PermissionsPermission, new String[0]) : (permissionLevel == ClaimPermission.Build ? this.dataStore.getMessage(Messages.BuildPermission, new String[0]) : (permissionLevel == ClaimPermission.Access ? this.dataStore.getMessage(Messages.AccessPermission, new String[0]) : this.dataStore.getMessage(Messages.ContainersPermission, new String[0])));
        String location = claim == null ? this.dataStore.getMessage(Messages.LocationAllClaims, new String[0]) : this.dataStore.getMessage(Messages.LocationCurrentClaim, new String[0]);
        GriefPrevention.sendMessage(player, TextMode.Success, Messages.GrantPermissionConfirmation, recipientName, permissionDescription, location);
    }

    public OfflinePlayer resolvePlayerByName(String name) {
        Player targetPlayer = this.getServer().getPlayerExact(name);
        if (targetPlayer != null) {
            return targetPlayer;
        }
        UUID bestMatchID = null;
        bestMatchID = this.playerNameToIDMap.get(name);
        if (bestMatchID == null) {
            bestMatchID = this.playerNameToIDMap.get(name.toLowerCase());
        }
        if (bestMatchID == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(bestMatchID);
    }

    static String lookupPlayerName(UUID playerID) {
        if (playerID == null) {
            return "somebody";
        }
        OfflinePlayer player = instance.getServer().getOfflinePlayer(playerID);
        if (player.hasPlayedBefore() || player.isOnline()) {
            return player.getName();
        }
        return "someone(" + playerID.toString() + ")";
    }

    static void cacheUUIDNamePair(UUID playerID, String playerName) {
        GriefPrevention.instance.playerNameToIDMap.put(playerName, playerID);
        GriefPrevention.instance.playerNameToIDMap.put(playerName.toLowerCase(), playerID);
    }

    static String lookupPlayerName(String playerID) {
        UUID id;
        try {
            id = UUID.fromString(playerID);
        }
        catch (IllegalArgumentException ex) {
            GriefPrevention.AddLogEntry("Error: Tried to look up a local player name for invalid UUID: " + playerID);
            return "someone";
        }
        return GriefPrevention.lookupPlayerName(id);
    }

    public void onDisable() {
        Collection players = this.getServer().getOnlinePlayers();
        for (Player player : players) {
            UUID playerID = player.getUniqueId();
            PlayerData playerData = this.dataStore.getPlayerData(playerID);
            this.dataStore.savePlayerDataSync(playerID, playerData);
        }
        this.dataStore.close();
        this.customLogger.WriteEntries();
        GriefPrevention.AddLogEntry("GriefPrevention disabled.");
    }

    public void checkPvpProtectionNeeded(Player player) {
        if (!this.config_pvp_protectFreshSpawns) {
            return;
        }
        if (!this.pvpRulesApply(player.getWorld())) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (player.hasPermission("griefprevention.nopvpimmunity")) {
            return;
        }
        if (GriefPrevention.isInventoryEmpty(player)) {
            PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
            playerData.pvpImmune = true;
            GriefPrevention.sendMessage(player, TextMode.Success, Messages.PvPImmunityStart, 5L, new String[0]);
            PvPImmunityValidationTask task = new PvPImmunityValidationTask(player);
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)task, 1200L);
        }
    }

    static boolean isInventoryEmpty(Player player) {
        ItemStack[] generalStacks;
        ItemStack[] armorStacks;
        PlayerInventory inventory = player.getInventory();
        for (ItemStack armorStack : armorStacks = inventory.getArmorContents()) {
            if (armorStack == null || armorStack.getType() == Material.AIR) continue;
            return false;
        }
        for (ItemStack generalStack : generalStacks = inventory.getContents()) {
            if (generalStack == null || generalStack.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public boolean siegeEnabledForWorld(World world) {
        return this.config_siege_enabledWorlds.contains(world);
    }

    public Location ejectPlayer(Player player) {
        Location candidateLocation = player.getLocation();
        while (true) {
            Claim claim = null;
            claim = GriefPrevention.instance.dataStore.getClaimAt(candidateLocation, false, null);
            if (claim == null) break;
            candidateLocation = new Location(claim.lesserBoundaryCorner.getWorld(), (double)(claim.lesserBoundaryCorner.getBlockX() - 1), (double)claim.lesserBoundaryCorner.getBlockY(), (double)(claim.lesserBoundaryCorner.getBlockZ() - 1));
        }
        GriefPrevention.GuaranteeChunkLoaded(candidateLocation);
        Block highestBlock = candidateLocation.getWorld().getHighestBlockAt(candidateLocation.getBlockX(), candidateLocation.getBlockZ());
        Location destination = new Location(highestBlock.getWorld(), (double)highestBlock.getX(), (double)(highestBlock.getY() + 2), (double)highestBlock.getZ());
        player.teleport(destination);
        return destination;
    }

    private static void GuaranteeChunkLoaded(Location location) {
        Chunk chunk = location.getChunk();
        while (!chunk.isLoaded() || !chunk.load(true)) {
        }
    }

    public static void sendMessage(Player player, ChatColor color, Messages messageID, String ... args) {
        GriefPrevention.sendMessage(player, color, messageID, 0L, args);
    }

    public static void sendMessage(Player player, ChatColor color, Messages messageID, long delayInTicks, String ... args) {
        String message = GriefPrevention.instance.dataStore.getMessage(messageID, args);
        GriefPrevention.sendMessage(player, color, message, delayInTicks);
    }

    public static void sendMessage(Player player, ChatColor color, String message) {
        if (message == null || message.length() == 0) {
            return;
        }
        if (player == null) {
            GriefPrevention.AddLogEntry(color + message);
        } else {
            player.sendMessage(color + message);
        }
    }

    public static void sendMessage(Player player, ChatColor color, String message, long delayInTicks) {
        SendPlayerMessageTask task = new SendPlayerMessageTask(player, color, message);
        if (delayInTicks > 0L) {
            instance.getServer().getScheduler().runTaskLater((Plugin)instance, (Runnable)task, delayInTicks);
        } else {
            task.run();
        }
    }

    public boolean claimsEnabledForWorld(World world) {
        ClaimsMode mode = this.config_claims_worldModes.get(world);
        return mode != null && mode != ClaimsMode.Disabled;
    }

    boolean creativeRulesApply(Location location) {
        if (!this.config_creativeWorldsExist) {
            return false;
        }
        return this.config_claims_worldModes.get(location.getWorld()) == ClaimsMode.Creative;
    }

    public String allowBuild(Player player, Location location) {
        return this.allowBuild(player, location, location.getBlock().getType());
    }

    public String allowBuild(Player player, Location location, Material material) {
        if (!instance.claimsEnabledForWorld(location.getWorld())) {
            return null;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(location, false, playerData.lastClaim);
        if (playerData.ignoreClaims) {
            return null;
        }
        if (claim == null) {
            if (this.creativeRulesApply(location) || this.config_claims_worldModes.get(location.getWorld()) == ClaimsMode.SurvivalRequiringClaims) {
                if (material != Material.CHEST || playerData.getClaims().size() > 0 || GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius == -1) {
                    String reason = this.dataStore.getMessage(Messages.NoBuildOutsideClaims, new String[0]);
                    if (player.hasPermission("griefprevention.ignoreclaims")) {
                        reason = reason + "  " + this.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                    }
                    reason = reason + "  " + this.dataStore.getMessage(Messages.CreativeBasicsVideo2, DataStore.CREATIVE_VIDEO_URL);
                    return reason;
                }
                return null;
            }
            return null;
        }
        playerData.lastClaim = claim;
        return claim.allowBuild(player, material);
    }

    public String allowBreak(Player player, Block block, Location location) {
        return this.allowBreak(player, block, location, null);
    }

    public String allowBreak(Player player, Block block, Location location, BlockBreakEvent breakEvent) {
        if (!instance.claimsEnabledForWorld(location.getWorld())) {
            return null;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        Claim claim = this.dataStore.getClaimAt(location, false, playerData.lastClaim);
        if (playerData.ignoreClaims) {
            return null;
        }
        if (claim == null) {
            if (this.creativeRulesApply(location) || this.config_claims_worldModes.get(location.getWorld()) == ClaimsMode.SurvivalRequiringClaims) {
                String reason = this.dataStore.getMessage(Messages.NoBuildOutsideClaims, new String[0]);
                if (player.hasPermission("griefprevention.ignoreclaims")) {
                    reason = reason + "  " + this.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                }
                reason = reason + "  " + this.dataStore.getMessage(Messages.CreativeBasicsVideo2, DataStore.CREATIVE_VIDEO_URL);
                return reason;
            }
            return null;
        }
        playerData.lastClaim = claim;
        String cancel = claim.allowBreak(player, block.getType());
        if (cancel != null && breakEvent != null) {
            PreventBlockBreakEvent preventionEvent = new PreventBlockBreakEvent(breakEvent);
            Bukkit.getPluginManager().callEvent((Event)preventionEvent);
            if (preventionEvent.isCancelled()) {
                cancel = null;
            }
        }
        return cancel;
    }

    public void restoreClaim(Claim claim, long delayInTicks) {
        if (claim.isAdminClaim()) {
            return;
        }
        if (claim.getArea() > 10000) {
            return;
        }
        ArrayList<Chunk> chunks = claim.getChunks();
        for (Chunk chunk : chunks) {
            this.restoreChunk(chunk, this.getSeaLevel(chunk.getWorld()) - 15, false, delayInTicks, null);
        }
    }

    public void restoreChunk(Chunk chunk, int miny, boolean aggressiveMode, long delayInTicks, Player playerReceivingVisualization) {
        int maxHeight = chunk.getWorld().getMaxHeight();
        BlockSnapshot[][][] snapshots = new BlockSnapshot[18][maxHeight][18];
        Block startBlock = chunk.getBlock(0, 0, 0);
        Location startLocation = new Location(chunk.getWorld(), (double)(startBlock.getX() - 1), 0.0, (double)(startBlock.getZ() - 1));
        for (int x = 0; x < snapshots.length; ++x) {
            for (int z = 0; z < snapshots[0][0].length; ++z) {
                for (int y = 0; y < snapshots[0].length; ++y) {
                    Block block = chunk.getWorld().getBlockAt(startLocation.getBlockX() + x, startLocation.getBlockY() + y, startLocation.getBlockZ() + z);
                    snapshots[x][y][z] = new BlockSnapshot(block.getLocation(), block.getType(), block.getBlockData());
                }
            }
        }
        Location lesserBoundaryCorner = chunk.getBlock(0, 0, 0).getLocation();
        Location greaterBoundaryCorner = chunk.getBlock(15, 0, 15).getLocation();
        RestoreNatureProcessingTask task = new RestoreNatureProcessingTask(snapshots, miny, chunk.getWorld().getEnvironment(), lesserBoundaryCorner.getBlock().getBiome(), lesserBoundaryCorner, greaterBoundaryCorner, this.getSeaLevel(chunk.getWorld()), aggressiveMode, instance.creativeRulesApply(lesserBoundaryCorner), playerReceivingVisualization);
        instance.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)instance, (Runnable)task, delayInTicks);
    }

    private Set<Material> parseMaterialListFromConfig(List<String> stringsToParse) {
        EnumSet<Material> materials = EnumSet.noneOf(Material.class);
        for (int i = 0; i < stringsToParse.size(); ++i) {
            String string = stringsToParse.get(i);
            if (string == null) continue;
            Material material = Material.getMaterial((String)string.toUpperCase());
            if (material == null) {
                if (string.contains("can't")) continue;
                stringsToParse.set(i, string + "     <-- can't understand this entry, see BukkitDev documentation");
                GriefPrevention.AddLogEntry(String.format("ERROR: Invalid material %s.  Please update your config.yml.", string));
                continue;
            }
            materials.add(material);
        }
        return materials;
    }

    public int getSeaLevel(World world) {
        Integer overrideValue = this.config_seaLevelOverride.get(world.getName());
        if (overrideValue == null || overrideValue == -1) {
            return world.getSeaLevel();
        }
        return overrideValue;
    }

    public boolean containsBlockedIP(String message) {
        message = message.replace("\r\n", "");
        Pattern ipAddressPattern = Pattern.compile("([0-9]{1,3}\\.){3}[0-9]{1,3}");
        Matcher matcher = ipAddressPattern.matcher(message);
        return matcher.find() && !GriefPrevention.instance.config_spam_allowedIpAddresses.contains(matcher.group());
    }

    void autoExtendClaim(Claim newClaim) {
        Location lesserCorner = newClaim.getLesserBoundaryCorner();
        Location greaterCorner = newClaim.getGreaterBoundaryCorner();
        World world = lesserCorner.getWorld();
        ArrayList<ChunkSnapshot> snapshots = new ArrayList<ChunkSnapshot>();
        for (int chunkx = lesserCorner.getBlockX() / 16; chunkx <= greaterCorner.getBlockX() / 16; ++chunkx) {
            for (int chunkz = lesserCorner.getBlockZ() / 16; chunkz <= greaterCorner.getBlockZ() / 16; ++chunkz) {
                if (!world.isChunkLoaded(chunkx, chunkz)) continue;
                snapshots.add(world.getChunkAt(chunkx, chunkz).getChunkSnapshot(true, true, false));
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)instance, (Runnable)new AutoExtendClaimTask(newClaim, snapshots, world.getEnvironment()));
    }

    public boolean pvpRulesApply(World world) {
        Boolean configSetting = this.config_pvp_specifiedWorlds.get(world);
        if (configSetting != null) {
            return configSetting;
        }
        return world.getPVP();
    }

    public static boolean isNewToServer(Player player) {
        if (player.getStatistic(Statistic.PICKUP, Material.OAK_LOG) > 0 || player.getStatistic(Statistic.PICKUP, Material.SPRUCE_LOG) > 0 || player.getStatistic(Statistic.PICKUP, Material.BIRCH_LOG) > 0 || player.getStatistic(Statistic.PICKUP, Material.JUNGLE_LOG) > 0 || player.getStatistic(Statistic.PICKUP, Material.ACACIA_LOG) > 0 || player.getStatistic(Statistic.PICKUP, Material.DARK_OAK_LOG) > 0) {
            return false;
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        return playerData.getClaims().size() <= 0;
    }

    static void banPlayer(Player player, String reason, String source) {
        if (GriefPrevention.instance.config_ban_useCommand) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), GriefPrevention.instance.config_ban_commandFormat.replace("%name%", player.getName()).replace("%reason%", reason));
        } else {
            BanList bans = Bukkit.getServer().getBanList(BanList.Type.NAME);
            bans.addBan(player.getName(), reason, null, source);
            if (player.isOnline()) {
                player.kickPlayer(reason);
            }
        }
    }

    public ItemStack getItemInHand(Player player, EquipmentSlot hand) {
        if (hand == EquipmentSlot.OFF_HAND) {
            return player.getInventory().getItemInOffHand();
        }
        return player.getInventory().getItemInMainHand();
    }

    public boolean claimIsPvPSafeZone(Claim claim) {
        if (claim.siegeData != null) {
            return false;
        }
        return claim.isAdminClaim() && claim.parent == null && GriefPrevention.instance.config_pvp_noCombatInAdminLandClaims || claim.isAdminClaim() && claim.parent != null && GriefPrevention.instance.config_pvp_noCombatInAdminSubdivisions || !claim.isAdminClaim() && GriefPrevention.instance.config_pvp_noCombatInPlayerLandClaims;
    }

    public void startRescueTask(Player player, Location location) {
        BukkitTask task = new CheckForPortalTrapTask(player, this, location).runTaskLater((Plugin)instance, 600L);
        if (this.portalReturnTaskMap.containsKey(player.getUniqueId())) {
            this.portalReturnTaskMap.put(player.getUniqueId(), task).cancel();
        } else {
            this.portalReturnTaskMap.put(player.getUniqueId(), task);
        }
    }

    private class CacheOfflinePlayerNamesThread
    extends Thread {
        private final OfflinePlayer[] offlinePlayers;
        private final ConcurrentHashMap<String, UUID> playerNameToIDMap;

        CacheOfflinePlayerNamesThread(OfflinePlayer[] offlinePlayers, ConcurrentHashMap<String, UUID> playerNameToIDMap) {
            this.offlinePlayers = offlinePlayers;
            this.playerNameToIDMap = playerNameToIDMap;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long millisecondsPerDay = 86400000L;
            for (OfflinePlayer player : this.offlinePlayers) {
                try {
                    String playerName;
                    long lastSeen;
                    long diff;
                    long daysDiff;
                    UUID playerID = player.getUniqueId();
                    if (playerID == null || (daysDiff = (diff = now - (lastSeen = player.getLastPlayed())) / 86400000L) > (long)GriefPrevention.this.config_advanced_offlineplayer_cache_days || (playerName = player.getName()) == null) continue;
                    this.playerNameToIDMap.put(playerName, playerID);
                    this.playerNameToIDMap.put(playerName.toLowerCase(), playerID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum IgnoreMode {
        None,
        StandardIgnore,
        AdminIgnore;

    }
}

