/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.ShovelMode;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;

class EquipShovelProcessingTask
implements Runnable {
    private final Player player;

    public EquipShovelProcessingTask(Player player) {
        this.player = player;
    }

    @Override
    public void run() {
        if (GriefPrevention.instance.getItemInHand(this.player, EquipmentSlot.HAND).getType() != GriefPrevention.instance.config_claims_modificationTool) {
            return;
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(this.player.getUniqueId());
        playerData.lastShovelLocation = null;
        playerData.claimResizing = null;
        if (playerData.shovelMode != ShovelMode.Basic) {
            playerData.shovelMode = ShovelMode.Basic;
            GriefPrevention.sendMessage(this.player, TextMode.Info, Messages.ShovelBasicClaimMode, new String[0]);
        }
        int remainingBlocks = playerData.getRemainingClaimBlocks();
        GriefPrevention.sendMessage(this.player, TextMode.Instr, Messages.RemainingBlocks, String.valueOf(remainingBlocks));
        if (GriefPrevention.instance.creativeRulesApply(this.player.getLocation())) {
            GriefPrevention.sendMessage(this.player, TextMode.Instr, Messages.CreativeBasicsVideo2, DataStore.CREATIVE_VIDEO_URL);
        } else if (GriefPrevention.instance.claimsEnabledForWorld(this.player.getLocation().getWorld())) {
            GriefPrevention.sendMessage(this.player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
        }
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(this.player.getLocation(), true, playerData.lastClaim);
        if (claim != null && claim.allowEdit(this.player) == null) {
            playerData.lastClaim = claim;
            Visualization.Apply(this.player, Visualization.FromClaim(claim, this.player.getEyeLocation().getBlockY(), VisualizationType.Claim, this.player.getLocation()));
        }
    }
}

