/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.ClaimsMode;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PendingItemProtection;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.events.PreventPvPEvent;
import me.ryanhamshire.GriefPrevention.events.ProtectDeathDropsEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class EntityEventHandler
implements Listener {
    private final DataStore dataStore;
    private final GriefPrevention instance;
    private final NamespacedKey luredByPlayer;
    public static final HashSet<PotionEffectType> positiveEffects = new HashSet<PotionEffectType>(Arrays.asList(PotionEffectType.ABSORPTION, PotionEffectType.DAMAGE_RESISTANCE, PotionEffectType.FAST_DIGGING, PotionEffectType.FIRE_RESISTANCE, PotionEffectType.HEAL, PotionEffectType.HEALTH_BOOST, PotionEffectType.INCREASE_DAMAGE, PotionEffectType.INVISIBILITY, PotionEffectType.JUMP, PotionEffectType.NIGHT_VISION, PotionEffectType.REGENERATION, PotionEffectType.SATURATION, PotionEffectType.SPEED, PotionEffectType.WATER_BREATHING));

    public EntityEventHandler(DataStore dataStore, GriefPrevention plugin) {
        this.dataStore = dataStore;
        this.instance = plugin;
        this.luredByPlayer = new NamespacedKey((Plugin)plugin, "lured_by_player");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityFormBlock(EntityBlockFormEvent event) {
        Player player;
        String noBuildReason;
        Entity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER && (noBuildReason = GriefPrevention.instance.allowBuild(player = (Player)event.getEntity(), event.getBlock().getLocation(), event.getNewState().getType())) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onLightningStrike(LightningStrikeEvent event) {
        if (event.getCause() == LightningStrikeEvent.Cause.TRIDENT) {
            event.getLightning().setMetadata("GP_TRIDENT", (MetadataValue)new FixedMetadataValue((Plugin)GriefPrevention.instance, (Object)event.getLightning().getLocation()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityChangeBLock(EntityChangeBlockEvent event) {
        if (!GriefPrevention.instance.config_endermenMoveBlocks && event.getEntityType() == EntityType.ENDERMAN) {
            event.setCancelled(true);
        } else if (!GriefPrevention.instance.config_silverfishBreakBlocks && event.getEntityType() == EntityType.SILVERFISH) {
            event.setCancelled(true);
        } else if (!GriefPrevention.instance.config_rabbitsEatCrops && event.getEntityType() == EntityType.RABBIT) {
            event.setCancelled(true);
        } else if (GriefPrevention.instance.config_claims_worldModes.get(event.getBlock().getWorld()) != ClaimsMode.Disabled) {
            if (event.getEntityType() == EntityType.WITHER) {
                Claim claim = this.dataStore.getClaimAt(event.getBlock().getLocation(), false, null);
                if (claim == null || !claim.areExplosivesAllowed || !GriefPrevention.instance.config_blockClaimExplosions) {
                    event.setCancelled(true);
                }
            } else if (!GriefPrevention.instance.config_claims_ravagersBreakBlocks && event.getEntityType() == EntityType.RAVAGER) {
                event.setCancelled(true);
            } else if (event.getTo() == Material.DIRT && event.getBlock().getType() == Material.FARMLAND) {
                if (event.getEntityType() != EntityType.PLAYER) {
                    event.setCancelled(true);
                } else {
                    Block block;
                    Player player = (Player)event.getEntity();
                    if (GriefPrevention.instance.allowBreak(player, block = event.getBlock(), block.getLocation()) != null) {
                        event.setCancelled(true);
                    }
                }
            }
        } else if (event.getEntity() instanceof Vehicle && !event.getEntity().getPassengers().isEmpty()) {
            Block block;
            Entity driver = (Entity)event.getEntity().getPassengers().get(0);
            if (driver instanceof Player && GriefPrevention.instance.allowBreak((Player)driver, block = event.getBlock(), block.getLocation()) != null) {
                event.setCancelled(true);
            }
        } else if (event.getEntityType() == EntityType.FALLING_BLOCK) {
            FallingBlock entity = (FallingBlock)event.getEntity();
            Block block = event.getBlock();
            if (event.getTo() == Material.AIR) {
                entity.setMetadata("GP_FALLINGBLOCK", (MetadataValue)new FixedMetadataValue((Plugin)GriefPrevention.instance, (Object)block.getLocation()));
            } else {
                List values = entity.getMetadata("GP_FALLINGBLOCK");
                if (values.size() < 1) {
                    return;
                }
                Location originalLocation = (Location)((MetadataValue)values.get(0)).value();
                Location newLocation = block.getLocation();
                if (originalLocation.getBlockX() != newLocation.getBlockX() || originalLocation.getBlockZ() != newLocation.getBlockZ()) {
                    if (GriefPrevention.instance.config_claims_worldModes.get(newLocation.getWorld()) == ClaimsMode.Creative) {
                        event.setCancelled(true);
                        return;
                    }
                    Claim claim = this.dataStore.getClaimAt(newLocation, false, null);
                    if (claim != null && !claim.contains(originalLocation, false, false)) {
                        event.setCancelled(true);
                        ItemStack itemStack = new ItemStack(entity.getMaterial(), 1);
                        Item item = block.getWorld().dropItem(entity.getLocation(), itemStack);
                        item.setVelocity(new Vector());
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onFallingBlockEnterPortal(EntityPortalEnterEvent event) {
        if (event.getEntityType() != EntityType.FALLING_BLOCK) {
            return;
        }
        event.getEntity().removeMetadata("GP_FALLINGBLOCK", (Plugin)this.instance);
    }

    @EventHandler(ignoreCancelled=true)
    void onTNTExitPortal(EntityPortalExitEvent event) {
        if (event.getEntityType() != EntityType.PRIMED_TNT) {
            return;
        }
        if (event.getTo().getWorld().getEnvironment() != World.Environment.THE_END) {
            return;
        }
        event.getEntity().remove();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onZombieBreakDoor(EntityBreakDoorEvent event) {
        if (!GriefPrevention.instance.config_zombiesBreakDoors) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityInteract(EntityInteractEvent event) {
        Material material = event.getBlock().getType();
        if (material == Material.FARMLAND) {
            if (!GriefPrevention.instance.config_creaturesTrampleCrops) {
                event.setCancelled(true);
            } else {
                Entity rider = event.getEntity().getPassenger();
                if (rider != null && rider.getType() == EntityType.PLAYER) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityExplode(EntityExplodeEvent explodeEvent) {
        this.handleExplosion(explodeEvent.getLocation(), explodeEvent.getEntity(), explodeEvent.blockList());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockExplode(BlockExplodeEvent explodeEvent) {
        this.handleExplosion(explodeEvent.getBlock().getLocation(), null, explodeEvent.blockList());
    }

    void handleExplosion(Location location, Entity entity, List<Block> blocks) {
        boolean applySurfaceRules;
        World world = location.getWorld();
        if (!GriefPrevention.instance.claimsEnabledForWorld(world)) {
            return;
        }
        boolean isCreeper = entity != null && entity.getType() == EntityType.CREEPER;
        boolean bl = applySurfaceRules = world.getEnvironment() == World.Environment.NORMAL && (isCreeper && GriefPrevention.instance.config_blockSurfaceCreeperExplosions || !isCreeper && GriefPrevention.instance.config_blockSurfaceOtherExplosions);
        if (GriefPrevention.instance.creativeRulesApply(location)) {
            for (int i = 0; i < blocks.size(); ++i) {
                Block block = blocks.get(i);
                blocks.remove(i--);
            }
            return;
        }
        ArrayList<Block> explodedBlocks = new ArrayList<Block>();
        Claim cachedClaim = null;
        for (Block block : blocks) {
            Material material;
            boolean breakable;
            if (block.getType() == Material.AIR) continue;
            Claim claim = this.dataStore.getClaimAt(block.getLocation(), false, cachedClaim);
            if (claim != null) {
                cachedClaim = claim;
            }
            if (claim != null && (claim.areExplosivesAllowed || !GriefPrevention.instance.config_blockClaimExplosions)) {
                explodedBlocks.add(block);
                continue;
            }
            if (claim != null && claim.siegeData != null && (breakable = GriefPrevention.instance.config_siege_blocks.contains(material = block.getType())) || claim != null || applySurfaceRules && block.getLocation().getBlockY() >= GriefPrevention.instance.getSeaLevel(world) - 7) continue;
            explodedBlocks.add(block);
        }
        blocks.clear();
        blocks.addAll(explodedBlocks);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        if (GriefPrevention.instance.creativeRulesApply(event.getLocation())) {
            event.setCancelled(true);
        }
        ArrayList<PendingItemProtection> watchList = GriefPrevention.instance.pendingItemWatchList;
        Item newItem = event.getEntity();
        Long now = null;
        for (int i = 0; i < watchList.size(); ++i) {
            PendingItemProtection pendingProtection = watchList.get(i);
            if (now == null) {
                now = System.currentTimeMillis();
            }
            if (pendingProtection.expirationTimestamp < now) {
                watchList.remove(i--);
                continue;
            }
            if (pendingProtection.itemStack.getAmount() != newItem.getItemStack().getAmount() || pendingProtection.itemStack.getType() != newItem.getItemStack().getType()) continue;
            Location spawn = event.getLocation();
            Location expected = pendingProtection.location;
            if (!spawn.getWorld().equals(expected.getWorld()) || spawn.getX() < expected.getX() - 5.0 || spawn.getX() > expected.getX() + 5.0 || spawn.getZ() < expected.getZ() - 5.0 || spawn.getZ() > expected.getZ() + 5.0 || spawn.getY() < expected.getY() - 15.0 || spawn.getY() > expected.getY() + 3.0) continue;
            newItem.setMetadata("GP_ITEMOWNER", (MetadataValue)new FixedMetadataValue((Plugin)GriefPrevention.instance, (Object)pendingProtection.owner));
            watchList.remove(i);
            break;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onExpBottle(ExpBottleEvent event) {
        if (GriefPrevention.instance.creativeRulesApply(event.getEntity().getLocation())) {
            event.setExperience(0);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntitySpawn(CreatureSpawnEvent event) {
        if (!GriefPrevention.instance.creativeRulesApply(event.getLocation())) {
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG && reason != CreatureSpawnEvent.SpawnReason.BUILD_IRONGOLEM && reason != CreatureSpawnEvent.SpawnReason.BUILD_SNOWMAN && event.getEntityType() != EntityType.ARMOR_STAND) {
            event.setCancelled(true);
            return;
        }
        Claim claim = this.dataStore.getClaimAt(event.getLocation(), false, null);
        if (claim == null || claim.allowMoreEntities(true) != null) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        World world;
        boolean isPvPWorld;
        LivingEntity entity = event.getEntity();
        if (!GriefPrevention.instance.claimsEnabledForWorld(entity.getWorld())) {
            return;
        }
        if (GriefPrevention.instance.creativeRulesApply(entity.getLocation())) {
            event.setDroppedExp(0);
            event.getDrops().clear();
        }
        if (entity.getType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)entity;
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.siegeData != null) {
            this.dataStore.endSiege(playerData.siegeData, null, player.getName(), event.getDrops());
        }
        if ((isPvPWorld = GriefPrevention.instance.pvpRulesApply(world = entity.getWorld())) && GriefPrevention.instance.config_lockDeathDropsInPvpWorlds || !isPvPWorld && GriefPrevention.instance.config_lockDeathDropsInNonPvpWorlds) {
            Claim claim = this.dataStore.getClaimAt(player.getLocation(), false, playerData.lastClaim);
            ProtectDeathDropsEvent protectionEvent = new ProtectDeathDropsEvent(claim);
            Bukkit.getPluginManager().callEvent((Event)protectionEvent);
            if (!protectionEvent.isCancelled()) {
                long expirationTime = System.currentTimeMillis() + 3000L;
                Location deathLocation = player.getLocation();
                UUID playerID = player.getUniqueId();
                List drops = event.getDrops();
                for (ItemStack stack : drops) {
                    GriefPrevention.instance.pendingItemWatchList.add(new PendingItemProtection(deathLocation, playerID, expirationTime, stack));
                }
                playerData.dropsAreUnlocked = false;
                playerData.receivedDropUnlockAdvertisement = false;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onItemMerge(ItemMergeEvent event) {
        Item item = event.getEntity();
        List data = item.getMetadata("GP_ITEMOWNER");
        event.setCancelled(data != null && data.size() > 0);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityPickup(EntityChangeBlockEvent event) {
        if (event.getEntity().getType() == EntityType.ENDERMAN && this.dataStore.getClaimAt(event.getBlock().getLocation(), false, null) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onHangingBreak(HangingBreakEvent event) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getCause() == HangingBreakEvent.RemoveCause.PHYSICS) {
            return;
        }
        if (event.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION) {
            event.setCancelled(true);
            return;
        }
        if (!(event instanceof HangingBreakByEntityEvent)) {
            event.setCancelled(true);
            return;
        }
        HangingBreakByEntityEvent entityEvent = (HangingBreakByEntityEvent)event;
        Entity remover = entityEvent.getRemover();
        if (remover.getType() != EntityType.PLAYER) {
            event.setCancelled(true);
            return;
        }
        Player playerRemover = (Player)entityEvent.getRemover();
        String noBuildReason = GriefPrevention.instance.allowBuild(playerRemover, event.getEntity().getLocation(), Material.AIR);
        if (noBuildReason != null) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(playerRemover, TextMode.Err, noBuildReason);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPaintingPlace(HangingPlaceEvent event) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getBlock().getWorld())) {
            return;
        }
        String noBuildReason = GriefPrevention.instance.allowBuild(event.getPlayer(), event.getEntity().getLocation(), Material.PAINTING);
        if (noBuildReason != null) {
            event.setCancelled(true);
            GriefPrevention.sendMessage(event.getPlayer(), TextMode.Err, noBuildReason);
            return;
        }
        if (GriefPrevention.instance.creativeRulesApply(event.getEntity().getLocation())) {
            PlayerData playerData = this.dataStore.getPlayerData(event.getPlayer().getUniqueId());
            Claim claim = this.dataStore.getClaimAt(event.getBlock().getLocation(), false, playerData.lastClaim);
            if (claim == null) {
                return;
            }
            String noEntitiesReason = claim.allowMoreEntities(false);
            if (noEntitiesReason != null) {
                GriefPrevention.sendMessage(event.getPlayer(), TextMode.Err, noEntitiesReason);
                event.setCancelled(true);
                return;
            }
        }
    }

    private boolean isMonster(Entity entity) {
        if (entity instanceof Monster) {
            return true;
        }
        EntityType type = entity.getType();
        if (type == EntityType.GHAST || type == EntityType.MAGMA_CUBE || type == EntityType.SHULKER) {
            return true;
        }
        if (type == EntityType.SLIME) {
            return ((Slime)entity).getSize() > 0;
        }
        if (type == EntityType.RABBIT) {
            return ((Rabbit)entity).getRabbitType() == Rabbit.Type.THE_KILLER_BUNNY;
        }
        if (type == EntityType.PANDA) {
            return ((Panda)entity).getMainGene() == Panda.Gene.AGGRESSIVE;
        }
        if (type == EntityType.HOGLIN || type == EntityType.POLAR_BEAR) {
            return !entity.getPersistentDataContainer().has(this.luredByPlayer, PersistentDataType.BYTE) && ((Mob)entity).getTarget() != null;
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityTarget(EntityTargetEvent event) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
            return;
        }
        EntityType entityType = event.getEntityType();
        if (entityType != EntityType.HOGLIN && entityType != EntityType.POLAR_BEAR) {
            return;
        }
        if (event.getReason() == EntityTargetEvent.TargetReason.TEMPT) {
            event.getEntity().getPersistentDataContainer().set(this.luredByPlayer, PersistentDataType.BYTE, (Object)1);
        } else {
            event.getEntity().getPersistentDataContainer().remove(this.luredByPlayer);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        this.handleEntityDamageEvent(event, true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityCombustByEntity(EntityCombustByEntityEvent event) {
        EntityDamageByEntityEvent eventWrapper = new EntityDamageByEntityEvent(event.getCombuster(), event.getEntity(), EntityDamageEvent.DamageCause.FIRE_TICK, (double)event.getDuration());
        this.handleEntityDamageEvent((EntityDamageEvent)eventWrapper, false);
        event.setCancelled(eventWrapper.isCancelled());
    }

    private void handleEntityDamageEvent(EntityDamageEvent event, boolean sendErrorMessagesToPlayers) {
        Claim defenderClaim;
        PlayerData attackerData;
        Player defender;
        EntityDamageEvent.DamageCause cause;
        Tameable tameable;
        if (this.isMonster(event.getEntity())) {
            return;
        }
        if (event.getEntity() instanceof Horse && !GriefPrevention.instance.config_claims_protectHorses) {
            return;
        }
        if (event.getEntity() instanceof Donkey && !GriefPrevention.instance.config_claims_protectDonkeys) {
            return;
        }
        if (event.getEntity() instanceof Mule && !GriefPrevention.instance.config_claims_protectDonkeys) {
            return;
        }
        if (event.getEntity() instanceof Llama && !GriefPrevention.instance.config_claims_protectLlamas) {
            return;
        }
        if (event.getEntityType() == EntityType.DROPPED_ITEM && event.getEntity().hasMetadata("GP_ITEMOWNER")) {
            event.setCancelled(true);
        }
        if (event.getEntity() instanceof Tameable && !GriefPrevention.instance.pvpRulesApply(event.getEntity().getWorld()) && (tameable = (Tameable)event.getEntity()).isTamed() && (cause = event.getCause()) != null && (cause == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || cause == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || cause == EntityDamageEvent.DamageCause.FALLING_BLOCK || cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK || cause == EntityDamageEvent.DamageCause.LAVA || cause == EntityDamageEvent.DamageCause.SUFFOCATION || cause == EntityDamageEvent.DamageCause.CONTACT || cause == EntityDamageEvent.DamageCause.DROWNING)) {
            event.setCancelled(true);
            return;
        }
        if (this.handleBlockExplosionDamage(event)) {
            return;
        }
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent subEvent = (EntityDamageByEntityEvent)event;
        if (subEvent.getDamager() instanceof LightningStrike && subEvent.getDamager().hasMetadata("GP_TRIDENT")) {
            event.setCancelled(true);
            return;
        }
        Player attacker = null;
        Projectile arrow = null;
        Firework firework = null;
        Entity damageSource = subEvent.getDamager();
        if (damageSource != null) {
            List data;
            if (damageSource.getType() == EntityType.PLAYER) {
                attacker = (Player)damageSource;
            } else if (damageSource instanceof Projectile) {
                arrow = (Projectile)damageSource;
                if (arrow.getShooter() instanceof Player) {
                    attacker = (Player)arrow.getShooter();
                }
            } else if (subEvent.getDamager() instanceof Firework && (damageSource = subEvent.getDamager()).hasMetadata("GP_FIREWORK") && (data = damageSource.getMetadata("GP_FIREWORK")) != null && data.size() > 0) {
                firework = (Firework)damageSource;
                attacker = (Player)((MetadataValue)data.get(0)).value();
            }
            if (damageSource.getType() == EntityType.AREA_EFFECT_CLOUD && event.getEntityType() == EntityType.PLAYER && GriefPrevention.instance.pvpRulesApply(event.getEntity().getWorld())) {
                Player damaged = (Player)event.getEntity();
                PlayerData damagedData = GriefPrevention.instance.dataStore.getPlayerData(damaged.getUniqueId());
                if (GriefPrevention.instance.config_pvp_protectFreshSpawns && damagedData.pvpImmune) {
                    event.setCancelled(true);
                    return;
                }
                Claim damagedClaim = GriefPrevention.instance.dataStore.getClaimAt(damaged.getLocation(), false, damagedData.lastClaim);
                if (damagedClaim != null) {
                    damagedData.lastClaim = damagedClaim;
                    if (GriefPrevention.instance.claimIsPvPSafeZone(damagedClaim)) {
                        PreventPvPEvent pvpEvent = new PreventPvPEvent(damagedClaim, attacker, (Entity)damaged);
                        Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                        if (!pvpEvent.isCancelled()) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                }
            }
        }
        if (firework != null && event.getEntityType() == EntityType.PLAYER && !GriefPrevention.instance.pvpRulesApply(attacker.getWorld()) && attacker != (defender = (Player)event.getEntity())) {
            event.setCancelled(true);
            return;
        }
        if (attacker != null && event.getEntityType() == EntityType.PLAYER && GriefPrevention.instance.pvpRulesApply(attacker.getWorld()) && attacker != (defender = (Player)event.getEntity())) {
            PlayerData defenderData = this.dataStore.getPlayerData(((Player)event.getEntity()).getUniqueId());
            attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
            if (GriefPrevention.instance.config_pvp_protectFreshSpawns) {
                if (defenderData.pvpImmune) {
                    event.setCancelled(true);
                    if (sendErrorMessagesToPlayers) {
                        GriefPrevention.sendMessage(attacker, TextMode.Err, Messages.ThatPlayerPvPImmune, new String[0]);
                    }
                    return;
                }
                if (attackerData.pvpImmune) {
                    event.setCancelled(true);
                    if (sendErrorMessagesToPlayers) {
                        GriefPrevention.sendMessage(attacker, TextMode.Err, Messages.CantFightWhileImmune, new String[0]);
                    }
                    return;
                }
            }
            if (GriefPrevention.instance.config_pvp_noCombatInPlayerLandClaims || GriefPrevention.instance.config_pvp_noCombatInAdminLandClaims) {
                Claim attackerClaim = this.dataStore.getClaimAt(attacker.getLocation(), false, attackerData.lastClaim);
                if (!attackerData.ignoreClaims) {
                    if (attackerClaim != null && !attackerData.inPvpCombat() && GriefPrevention.instance.claimIsPvPSafeZone(attackerClaim)) {
                        attackerData.lastClaim = attackerClaim;
                        PreventPvPEvent pvpEvent = new PreventPvPEvent(attackerClaim, attacker, (Entity)defender);
                        Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                        if (!pvpEvent.isCancelled()) {
                            event.setCancelled(true);
                            if (sendErrorMessagesToPlayers) {
                                GriefPrevention.sendMessage(attacker, TextMode.Err, Messages.CantFightWhileImmune, new String[0]);
                            }
                        }
                        return;
                    }
                    defenderClaim = this.dataStore.getClaimAt(defender.getLocation(), false, defenderData.lastClaim);
                    if (defenderClaim != null && !defenderData.inPvpCombat() && GriefPrevention.instance.claimIsPvPSafeZone(defenderClaim)) {
                        defenderData.lastClaim = defenderClaim;
                        PreventPvPEvent pvpEvent = new PreventPvPEvent(defenderClaim, attacker, (Entity)defender);
                        Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                        if (!pvpEvent.isCancelled()) {
                            event.setCancelled(true);
                            if (sendErrorMessagesToPlayers) {
                                GriefPrevention.sendMessage(attacker, TextMode.Err, Messages.PlayerInPvPSafeZone, new String[0]);
                            }
                        }
                        return;
                    }
                }
            }
        }
        if (event instanceof EntityDamageByEntityEvent) {
            Claim claim;
            PlayerData playerData;
            Claim cachedClaim;
            if (!GriefPrevention.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
                return;
            }
            if (event.getEntityType() == EntityType.PLAYER) {
                Tameable pet;
                defender = (Player)event.getEntity();
                Entity damager = subEvent.getDamager();
                if (damager != null && damager instanceof Tameable && (pet = (Tameable)damager).isTamed() && pet.getOwner() != null) {
                    PlayerData defenderData = GriefPrevention.instance.dataStore.getPlayerData(event.getEntity().getUniqueId());
                    if (!defenderData.pvpImmune && !defenderData.inPvpCombat() && (defenderClaim = this.dataStore.getClaimAt(defender.getLocation(), false, defenderData.lastClaim)) != null && !defenderData.inPvpCombat() && GriefPrevention.instance.claimIsPvPSafeZone(defenderClaim)) {
                        defenderData.lastClaim = defenderClaim;
                        PreventPvPEvent pvpEvent = new PreventPvPEvent(defenderClaim, attacker, (Entity)defender);
                        Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                        if (!pvpEvent.isCancelled()) {
                            event.setCancelled(true);
                            if (damager instanceof Creature) {
                                ((Creature)damager).setTarget(null);
                            }
                        }
                        return;
                    }
                }
            }
            if (subEvent.getEntityType() == EntityType.ITEM_FRAME || subEvent.getEntityType() == EntityType.ARMOR_STAND || subEvent.getEntityType() == EntityType.VILLAGER || subEvent.getEntityType() == EntityType.ENDER_CRYSTAL) {
                if (subEvent.getEntityType() == EntityType.VILLAGER && !GriefPrevention.instance.config_claims_protectCreatures) {
                    return;
                }
                if (subEvent.getEntityType() == EntityType.POLAR_BEAR) {
                    return;
                }
                cachedClaim = null;
                playerData = null;
                if (attacker != null) {
                    playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
                    cachedClaim = playerData.lastClaim;
                }
                if ((claim = this.dataStore.getClaimAt(event.getEntity().getLocation(), false, cachedClaim)) != null) {
                    if (attacker == null) {
                        if (event.getEntityType() == EntityType.VILLAGER && damageSource != null && damageSource instanceof Zombie) {
                            return;
                        }
                        event.setCancelled(true);
                        return;
                    }
                    String failureReason = claim.allowBuild(attacker, Material.AIR);
                    if (failureReason != null) {
                        event.setCancelled(true);
                        if (sendErrorMessagesToPlayers) {
                            GriefPrevention.sendMessage(attacker, TextMode.Err, failureReason);
                        }
                        return;
                    }
                }
            }
            if ((subEvent.getEntity() instanceof Creature || subEvent.getEntity() instanceof WaterMob) && GriefPrevention.instance.config_claims_protectCreatures) {
                String message;
                Tameable tameable2;
                if (subEvent.getEntity() instanceof Tameable && (tameable2 = (Tameable)subEvent.getEntity()).isTamed() && tameable2.getOwner() != null && attacker != null) {
                    UUID ownerID = tameable2.getOwner().getUniqueId();
                    if (attacker.getUniqueId().equals(ownerID)) {
                        return;
                    }
                    attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
                    if (attackerData.ignoreClaims) {
                        return;
                    }
                    if (!GriefPrevention.instance.pvpRulesApply(subEvent.getEntity().getLocation().getWorld()) || GriefPrevention.instance.config_pvp_protectPets && subEvent.getEntityType() != EntityType.WOLF) {
                        OfflinePlayer owner = GriefPrevention.instance.getServer().getOfflinePlayer(ownerID);
                        String ownerName = owner.getName();
                        if (ownerName == null) {
                            ownerName = "someone";
                        }
                        String message2 = GriefPrevention.instance.dataStore.getMessage(Messages.NoDamageClaimedEntity, ownerName);
                        if (attacker.hasPermission("griefprevention.ignoreclaims")) {
                            message2 = message2 + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                        }
                        if (sendErrorMessagesToPlayers) {
                            GriefPrevention.sendMessage(attacker, TextMode.Err, message2);
                        }
                        PreventPvPEvent pvpEvent = new PreventPvPEvent(new Claim(subEvent.getEntity().getLocation(), subEvent.getEntity().getLocation(), null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null), attacker, (Entity)tameable2);
                        Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                        if (!pvpEvent.isCancelled()) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    if (attackerData.pvpImmune) {
                        event.setCancelled(true);
                        if (sendErrorMessagesToPlayers) {
                            GriefPrevention.sendMessage(attacker, TextMode.Err, Messages.CantFightWhileImmune, new String[0]);
                        }
                        return;
                    }
                    if (tameable2.getType() == EntityType.WOLF && !tameable2.getOwner().equals(attacker)) {
                        if (((Wolf)tameable2).getTarget() != null && ((Wolf)tameable2).getTarget() == attacker) {
                            return;
                        }
                        event.setCancelled(true);
                        String ownerName = GriefPrevention.instance.getServer().getOfflinePlayer(ownerID).getName();
                        message = GriefPrevention.instance.dataStore.getMessage(Messages.NoDamageClaimedEntity, ownerName);
                        if (attacker.hasPermission("griefprevention.ignoreclaims")) {
                            message = message + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                        }
                        if (sendErrorMessagesToPlayers) {
                            GriefPrevention.sendMessage(attacker, TextMode.Err, message);
                        }
                        return;
                    }
                }
                cachedClaim = null;
                playerData = null;
                if (!(attacker != null || damageSource == null || damageSource.getType() == EntityType.CREEPER || damageSource.getType() == EntityType.WITHER || damageSource.getType() == EntityType.ENDER_CRYSTAL || damageSource.getType() == EntityType.AREA_EFFECT_CLOUD || damageSource.getType() == EntityType.WITCH || damageSource instanceof Projectile || damageSource instanceof Explosive || damageSource instanceof ExplosiveMinecart)) {
                    return;
                }
                if (attacker != null) {
                    playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
                    cachedClaim = playerData.lastClaim;
                }
                if ((claim = this.dataStore.getClaimAt(event.getEntity().getLocation(), false, cachedClaim)) != null) {
                    if (attacker == null) {
                        if (event.getEntityType() == EntityType.VILLAGER && damageSource != null && (damageSource.getType() == EntityType.ZOMBIE || damageSource.getType() == EntityType.VINDICATOR || damageSource.getType() == EntityType.EVOKER || damageSource.getType() == EntityType.EVOKER_FANGS || damageSource.getType() == EntityType.VEX)) {
                            return;
                        }
                        event.setCancelled(true);
                        if (damageSource instanceof Projectile) {
                            damageSource.remove();
                        }
                    } else if (!event.getEntity().getWorld().getPVP() || event.getEntity().getType() != EntityType.WOLF) {
                        String noContainersReason = claim.allowContainers(attacker);
                        if (noContainersReason != null) {
                            event.setCancelled(true);
                            if (arrow != null && arrow.getType() != EntityType.TRIDENT) {
                                arrow.remove();
                            }
                            if (damageSource != null && damageSource.getType() == EntityType.FIREWORK && event.getEntity().getType() != EntityType.PLAYER) {
                                return;
                            }
                            if (sendErrorMessagesToPlayers) {
                                message = GriefPrevention.instance.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
                                if (attacker.hasPermission("griefprevention.ignoreclaims")) {
                                    message = message + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                                }
                                GriefPrevention.sendMessage(attacker, TextMode.Err, message);
                            }
                            event.setCancelled(true);
                        }
                        if (playerData != null) {
                            playerData.lastClaim = claim;
                        }
                    }
                }
            }
        }
    }

    private boolean handleBlockExplosionDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
            return false;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            return false;
        }
        Claim claim = GriefPrevention.instance.dataStore.getClaimAt(entity.getLocation(), false, null);
        if (claim == null) {
            return false;
        }
        event.setCancelled(true);
        return true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onCrossbowFireWork(EntityShootBowEvent shootEvent) {
        if (shootEvent.getEntity() instanceof Player && shootEvent.getProjectile() instanceof Firework) {
            shootEvent.getProjectile().setMetadata("GP_FIREWORK", (MetadataValue)new FixedMetadataValue((Plugin)GriefPrevention.instance, (Object)shootEvent.getEntity()));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onEntityDamageMonitor(EntityDamageEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER) {
            return;
        }
        Player defender = (Player)event.getEntity();
        if (!(event instanceof EntityDamageByEntityEvent)) {
            return;
        }
        if (event.getDamage() == 0.0) {
            return;
        }
        EntityDamageByEntityEvent subEvent = (EntityDamageByEntityEvent)event;
        if (!GriefPrevention.instance.pvpRulesApply(defender.getWorld())) {
            return;
        }
        Player attacker = null;
        Projectile arrow = null;
        Entity damageSource = subEvent.getDamager();
        if (damageSource != null) {
            List data;
            if (damageSource.getType() == EntityType.PLAYER) {
                attacker = (Player)damageSource;
            } else if (damageSource instanceof Projectile) {
                arrow = (Projectile)damageSource;
                if (arrow.getShooter() instanceof Player) {
                    attacker = (Player)arrow.getShooter();
                }
            } else if (damageSource instanceof Firework && damageSource.hasMetadata("GP_FIREWORK") && (data = damageSource.getMetadata("GP_FIREWORK")) != null && data.size() > 0) {
                attacker = (Player)((MetadataValue)data.get(0)).value();
            }
        }
        if (attacker == null) {
            return;
        }
        PlayerData defenderData = this.dataStore.getPlayerData(defender.getUniqueId());
        PlayerData attackerData = this.dataStore.getPlayerData(attacker.getUniqueId());
        if (attacker != defender) {
            long now;
            defenderData.lastPvpTimestamp = now = Calendar.getInstance().getTimeInMillis();
            defenderData.lastPvpPlayer = attacker.getName();
            attackerData.lastPvpTimestamp = now;
            attackerData.lastPvpPlayer = defender.getName();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onVehicleDamage(VehicleDamageEvent event) {
        Claim claim;
        if (!GriefPrevention.instance.config_claims_preventTheft) {
            return;
        }
        if (event.getVehicle() == null) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getVehicle().getWorld())) {
            return;
        }
        Player attacker = null;
        Entity damageSource = event.getAttacker();
        EntityType damageSourceType = null;
        if (damageSource != null) {
            List data;
            damageSourceType = damageSource.getType();
            if (damageSource.getType() == EntityType.PLAYER) {
                attacker = (Player)damageSource;
            } else if (damageSource instanceof Projectile) {
                Projectile arrow = (Projectile)damageSource;
                if (arrow.getShooter() instanceof Player) {
                    attacker = (Player)arrow.getShooter();
                }
            } else if (damageSource instanceof Firework && damageSource.hasMetadata("GP_FIREWORK") && (data = damageSource.getMetadata("GP_FIREWORK")) != null && data.size() > 0) {
                attacker = (Player)((MetadataValue)data.get(0)).value();
            }
        }
        if (attacker == null && damageSourceType != EntityType.CREEPER && damageSourceType != EntityType.WITHER && damageSourceType != EntityType.PRIMED_TNT) {
            return;
        }
        Claim cachedClaim = null;
        PlayerData playerData = null;
        if (attacker != null) {
            playerData = this.dataStore.getPlayerData(attacker.getUniqueId());
            cachedClaim = playerData.lastClaim;
        }
        if ((claim = this.dataStore.getClaimAt(event.getVehicle().getLocation(), false, cachedClaim)) != null) {
            if (attacker == null) {
                event.setCancelled(true);
            } else {
                String noContainersReason = claim.allowContainers(attacker);
                if (noContainersReason != null) {
                    event.setCancelled(true);
                    String message = GriefPrevention.instance.dataStore.getMessage(Messages.NoDamageClaimedEntity, claim.getOwnerName());
                    if (attacker.hasPermission("griefprevention.ignoreclaims")) {
                        message = message + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
                    }
                    GriefPrevention.sendMessage(attacker, TextMode.Err, message);
                    event.setCancelled(true);
                }
                if (playerData != null) {
                    playerData.lastClaim = claim;
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPotionSplash(PotionSplashEvent event) {
        ThrownPotion potion = event.getPotion();
        ProjectileSource projectileSource = potion.getShooter();
        if (projectileSource == null) {
            return;
        }
        Player thrower = null;
        if (projectileSource instanceof Player) {
            thrower = (Player)projectileSource;
        }
        Collection effects = potion.getEffects();
        for (PotionEffect effect : effects) {
            PotionEffectType effectType = effect.getType();
            if (effectType.getName().equals("JUMP") || effectType.getName().equals("POISON")) {
                Claim cachedClaim = null;
                for (LivingEntity effected : event.getAffectedEntities()) {
                    Claim claim;
                    if (effected.getType() != EntityType.VILLAGER && !(effected instanceof Animals) || (claim = this.dataStore.getClaimAt(effected.getLocation(), false, cachedClaim)) == null) continue;
                    cachedClaim = claim;
                    if (thrower != null && claim.allowContainers(thrower) == null) continue;
                    event.setIntensity(effected, 0.0);
                    GriefPrevention.sendMessage(thrower, TextMode.Err, Messages.NoDamageClaimedEntity, claim.getOwnerName());
                    return;
                }
            }
            if (thrower == null) {
                return;
            }
            if (positiveEffects.contains(effectType)) continue;
            for (LivingEntity effected : event.getAffectedEntities()) {
                if (effected == thrower || effected.getType() != EntityType.PLAYER || !GriefPrevention.instance.config_pvp_noCombatInPlayerLandClaims && !GriefPrevention.instance.config_pvp_noCombatInAdminLandClaims) continue;
                Player effectedPlayer = (Player)effected;
                PlayerData defenderData = this.dataStore.getPlayerData(effectedPlayer.getUniqueId());
                PlayerData attackerData = this.dataStore.getPlayerData(thrower.getUniqueId());
                Claim attackerClaim = this.dataStore.getClaimAt(thrower.getLocation(), false, attackerData.lastClaim);
                if (attackerClaim != null && GriefPrevention.instance.claimIsPvPSafeZone(attackerClaim)) {
                    attackerData.lastClaim = attackerClaim;
                    PreventPvPEvent pvpEvent = new PreventPvPEvent(attackerClaim, thrower, (Entity)effectedPlayer);
                    Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                    if (pvpEvent.isCancelled()) continue;
                    event.setIntensity(effected, 0.0);
                    GriefPrevention.sendMessage(thrower, TextMode.Err, Messages.CantFightWhileImmune, new String[0]);
                    continue;
                }
                Claim defenderClaim = this.dataStore.getClaimAt(effectedPlayer.getLocation(), false, defenderData.lastClaim);
                if (defenderClaim == null || !GriefPrevention.instance.claimIsPvPSafeZone(defenderClaim)) continue;
                defenderData.lastClaim = defenderClaim;
                PreventPvPEvent pvpEvent = new PreventPvPEvent(defenderClaim, thrower, (Entity)effectedPlayer);
                Bukkit.getPluginManager().callEvent((Event)pvpEvent);
                if (pvpEvent.isCancelled()) continue;
                event.setIntensity(effected, 0.0);
                GriefPrevention.sendMessage(thrower, TextMode.Err, Messages.PlayerInPvPSafeZone, new String[0]);
            }
        }
    }
}

