/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

class CustomLogger {
    private final SimpleDateFormat timestampFormat = new SimpleDateFormat("HH:mm");
    private final SimpleDateFormat filenameFormat = new SimpleDateFormat("yyyy_MM_dd");
    private final String logFolderPath = DataStore.dataLayerFolderPath + File.separator + "Logs";
    private final int secondsBetweenWrites = 300;
    private final StringBuffer queuedEntries = new StringBuffer();
    private static final Pattern inlineFormatterPattern = Pattern.compile("\u00a7.");

    CustomLogger() {
        File logFolder = new File(this.logFolderPath);
        logFolder.mkdirs();
        this.DeleteExpiredLogs();
        int daysToKeepLogs = GriefPrevention.instance.config_logs_daysToKeep;
        if (daysToKeepLogs > 0) {
            BukkitScheduler scheduler = GriefPrevention.instance.getServer().getScheduler();
            long ticksPerSecond = 20L;
            long ticksPerDay = 1728000L;
            EntryWriter entryWriter = new EntryWriter();
            this.getClass();
            this.getClass();
            scheduler.runTaskTimerAsynchronously((Plugin)GriefPrevention.instance, (Runnable)entryWriter, 300L * 20L, 300L * 20L);
            scheduler.runTaskTimerAsynchronously((Plugin)GriefPrevention.instance, (Runnable)new ExpiredLogRemover(), 1728000L, 1728000L);
        }
    }

    void AddEntry(String entry, CustomLogEntryTypes entryType) {
        int daysToKeepLogs = GriefPrevention.instance.config_logs_daysToKeep;
        if (daysToKeepLogs == 0) {
            return;
        }
        if (!this.isEnabledType(entryType)) {
            return;
        }
        Matcher matcher = inlineFormatterPattern.matcher(entry);
        entry = matcher.replaceAll("");
        String timestamp = this.timestampFormat.format(new Date());
        this.queuedEntries.append(timestamp).append(' ').append(entry).append('\n');
    }

    private boolean isEnabledType(CustomLogEntryTypes entryType) {
        if (entryType == CustomLogEntryTypes.Exception) {
            return true;
        }
        if (entryType == CustomLogEntryTypes.SocialActivity && !GriefPrevention.instance.config_logs_socialEnabled) {
            return false;
        }
        if (entryType == CustomLogEntryTypes.SuspiciousActivity && !GriefPrevention.instance.config_logs_suspiciousEnabled) {
            return false;
        }
        if (entryType == CustomLogEntryTypes.AdminActivity && !GriefPrevention.instance.config_logs_adminEnabled) {
            return false;
        }
        if (entryType == CustomLogEntryTypes.Debug && !GriefPrevention.instance.config_logs_debugEnabled) {
            return false;
        }
        return entryType != CustomLogEntryTypes.MutedChat || GriefPrevention.instance.config_logs_mutedChatEnabled;
    }

    void WriteEntries() {
        try {
            if (this.queuedEntries.length() == 0) {
                return;
            }
            String filename = this.filenameFormat.format(new Date()) + ".log";
            String filepath = this.logFolderPath + File.separator + filename;
            File logFile = new File(filepath);
            Files.append((CharSequence)this.queuedEntries.toString(), (File)logFile, (Charset)Charset.forName("UTF-8"));
            this.queuedEntries.setLength(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void DeleteExpiredLogs() {
        try {
            File logFolder = new File(this.logFolderPath);
            File[] files = logFolder.listFiles();
            int daysToKeepLogs = GriefPrevention.instance.config_logs_daysToKeep;
            Calendar expirationBoundary = Calendar.getInstance();
            expirationBoundary.add(5, -daysToKeepLogs);
            for (File file : files) {
                String filename;
                String[] dateParts;
                if (file.isDirectory() || (dateParts = (filename = file.getName().replace(".log", "")).split("_")).length != 3) continue;
                try {
                    int year = Integer.parseInt(dateParts[0]);
                    int month = Integer.parseInt(dateParts[1]) - 1;
                    int day = Integer.parseInt(dateParts[2]);
                    Calendar filedate = Calendar.getInstance();
                    filedate.set(year, month, day);
                    if (!filedate.before(expirationBoundary)) continue;
                    file.delete();
                }
                catch (NumberFormatException e) {
                    GriefPrevention.AddLogEntry("Ignoring an unexpected file in the abridged logs folder: " + file.getName(), CustomLogEntryTypes.Debug, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ExpiredLogRemover
    implements Runnable {
        private ExpiredLogRemover() {
        }

        @Override
        public void run() {
            CustomLogger.this.DeleteExpiredLogs();
        }
    }

    private class EntryWriter
    implements Runnable {
        private EntryWriter() {
        }

        @Override
        public void run() {
            CustomLogger.this.WriteEntries();
        }
    }
}

