/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CustomLogEntryTypes;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.events.ClaimExpirationEvent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

class CleanupUnusedClaimTask
implements Runnable {
    Claim claim;
    PlayerData ownerData;
    OfflinePlayer ownerInfo;

    CleanupUnusedClaimTask(Claim claim, PlayerData ownerData, OfflinePlayer ownerInfo) {
        this.claim = claim;
        this.ownerData = ownerData;
        this.ownerInfo = ownerInfo;
    }

    @Override
    public void run() {
        int areaOfDefaultClaim = 0;
        if (GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius >= 0) {
            areaOfDefaultClaim = (int)Math.pow(GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius * 2 + 1, 2.0);
        }
        if (this.claim.getArea() <= areaOfDefaultClaim && GriefPrevention.instance.config_claims_chestClaimExpirationDays > 0) {
            Calendar sevenDaysAgo = Calendar.getInstance();
            sevenDaysAgo.add(5, -GriefPrevention.instance.config_claims_chestClaimExpirationDays);
            boolean newPlayerClaimsExpired = sevenDaysAgo.getTime().after(new Date(this.ownerInfo.getLastPlayed()));
            if (newPlayerClaimsExpired && this.ownerData.getClaims().size() == 1) {
                if (this.expireEventCanceled()) {
                    return;
                }
                this.claim.removeSurfaceFluids(null);
                GriefPrevention.instance.dataStore.deleteClaim(this.claim, true, true);
                if (GriefPrevention.instance.creativeRulesApply(this.claim.getLesserBoundaryCorner()) || GriefPrevention.instance.config_claims_survivalAutoNatureRestoration) {
                    GriefPrevention.instance.restoreClaim(this.claim, 0L);
                }
                GriefPrevention.AddLogEntry(" " + this.claim.getOwnerName() + "'s new player claim expired.", CustomLogEntryTypes.AdminActivity);
            }
        } else if (GriefPrevention.instance.config_claims_expirationDays > 0) {
            Calendar earliestPermissibleLastLogin = Calendar.getInstance();
            earliestPermissibleLastLogin.add(5, -GriefPrevention.instance.config_claims_expirationDays);
            if (earliestPermissibleLastLogin.getTime().after(new Date(this.ownerInfo.getLastPlayed()))) {
                if (this.expireEventCanceled()) {
                    return;
                }
                Vector<Claim> claims = new Vector<Claim>(this.ownerData.getClaims());
                GriefPrevention.instance.dataStore.deleteClaimsForPlayer(this.claim.ownerID, true);
                GriefPrevention.AddLogEntry(" All of " + this.claim.getOwnerName() + "'s claims have expired.", CustomLogEntryTypes.AdminActivity);
                GriefPrevention.AddLogEntry("earliestPermissibleLastLogin#getTime: " + earliestPermissibleLastLogin.getTime(), CustomLogEntryTypes.Debug, true);
                GriefPrevention.AddLogEntry("ownerInfo#getLastPlayed: " + this.ownerInfo.getLastPlayed(), CustomLogEntryTypes.Debug, true);
                for (Claim claim : claims) {
                    if (!GriefPrevention.instance.creativeRulesApply(claim.getLesserBoundaryCorner()) && !GriefPrevention.instance.config_claims_survivalAutoNatureRestoration) continue;
                    GriefPrevention.instance.restoreClaim(claim, 0L);
                }
            }
        } else if (GriefPrevention.instance.config_claims_unusedClaimExpirationDays > 0 && GriefPrevention.instance.creativeRulesApply(this.claim.getLesserBoundaryCorner())) {
            if (this.claim.isAdminClaim() || this.claim.getWidth() > 25 || this.claim.getHeight() > 25) {
                return;
            }
            int minInvestment = 400;
            long investmentScore = this.claim.getPlayerInvestmentScore();
            if (investmentScore < (long)minInvestment) {
                Calendar sevenDaysAgo = Calendar.getInstance();
                sevenDaysAgo.add(5, -GriefPrevention.instance.config_claims_unusedClaimExpirationDays);
                boolean claimExpired = sevenDaysAgo.getTime().after(new Date(this.ownerInfo.getLastPlayed()));
                if (claimExpired) {
                    if (this.expireEventCanceled()) {
                        return;
                    }
                    GriefPrevention.instance.dataStore.deleteClaim(this.claim, true, true);
                    GriefPrevention.AddLogEntry("Removed " + this.claim.getOwnerName() + "'s unused claim @ " + GriefPrevention.getfriendlyLocationString(this.claim.getLesserBoundaryCorner()), CustomLogEntryTypes.AdminActivity);
                    GriefPrevention.instance.restoreClaim(this.claim, 0L);
                }
            }
        }
    }

    public boolean expireEventCanceled() {
        ClaimExpirationEvent event = new ClaimExpirationEvent(this.claim);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }
}

