/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.ryanhamshire.GriefPrevention.BlockEventHandler;
import me.ryanhamshire.GriefPrevention.ClaimPermission;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.RestoreNatureProcessingTask;
import me.ryanhamshire.GriefPrevention.SiegeData;
import me.ryanhamshire.GriefPrevention.util.BoundingBox;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Claim {
    Location lesserBoundaryCorner;
    Location greaterBoundaryCorner;
    public Date modifiedDate;
    Long id = null;
    public UUID ownerID;
    public ArrayList<String> managers = new ArrayList();
    private HashMap<String, ClaimPermission> playerIDToClaimPermissionMap = new HashMap();
    public boolean inDataStore = false;
    public boolean areExplosivesAllowed = false;
    public Claim parent = null;
    private boolean inheritNothing = false;
    public ArrayList<Claim> children = new ArrayList();
    public SiegeData siegeData = null;
    public boolean doorsOpen = false;
    private static final Set<Material> PLACEABLE_FARMING_BLOCKS = EnumSet.of(Material.PUMPKIN_STEM, new Material[]{Material.WHEAT, Material.MELON_STEM, Material.CARROTS, Material.POTATOES, Material.NETHER_WART, Material.BEETROOTS});

    public boolean isAdminClaim() {
        if (this.parent != null) {
            return this.parent.isAdminClaim();
        }
        return this.ownerID == null;
    }

    public Long getID() {
        return this.id;
    }

    Claim() {
        this.modifiedDate = Calendar.getInstance().getTime();
    }

    public boolean canSiege(Player defender) {
        if (this.isAdminClaim()) {
            return false;
        }
        return this.allowAccess(defender) == null;
    }

    public void removeSurfaceFluids(Claim exclusionClaim) {
        if (this.isAdminClaim()) {
            return;
        }
        if (this.getArea() > 10000) {
            return;
        }
        if (!GriefPrevention.instance.creativeRulesApply(this.lesserBoundaryCorner)) {
            return;
        }
        Location lesser = this.getLesserBoundaryCorner();
        Location greater = this.getGreaterBoundaryCorner();
        if (lesser.getWorld().getEnvironment() == World.Environment.NETHER) {
            return;
        }
        int seaLevel = 0;
        if (lesser.getWorld().getEnvironment() == World.Environment.NORMAL) {
            seaLevel = GriefPrevention.instance.getSeaLevel(lesser.getWorld());
        }
        for (int x = lesser.getBlockX(); x <= greater.getBlockX(); ++x) {
            for (int z = lesser.getBlockZ(); z <= greater.getBlockZ(); ++z) {
                for (int y = seaLevel - 1; y <= lesser.getWorld().getMaxHeight(); ++y) {
                    Block block = lesser.getWorld().getBlockAt(x, y, z);
                    if (exclusionClaim != null && exclusionClaim.contains(block.getLocation(), true, false) || block.getType() != Material.LAVA && block.getType() != Material.WATER) continue;
                    block.setType(Material.AIR);
                }
            }
        }
    }

    boolean hasSurfaceFluids() {
        Location lesser = this.getLesserBoundaryCorner();
        Location greater = this.getGreaterBoundaryCorner();
        if (this.getArea() > 10000) {
            return false;
        }
        int seaLevel = 0;
        if (lesser.getWorld().getEnvironment() == World.Environment.NORMAL) {
            seaLevel = GriefPrevention.instance.getSeaLevel(lesser.getWorld());
        }
        for (int x = lesser.getBlockX(); x <= greater.getBlockX(); ++x) {
            for (int z = lesser.getBlockZ(); z <= greater.getBlockZ(); ++z) {
                for (int y = seaLevel - 1; y <= lesser.getWorld().getMaxHeight(); ++y) {
                    Block block = lesser.getWorld().getBlockAt(x, y, z);
                    if (block.getType() != Material.WATER && block.getType() != Material.LAVA) continue;
                    return true;
                }
            }
        }
        return false;
    }

    Claim(Location lesserBoundaryCorner, Location greaterBoundaryCorner, UUID ownerID, List<String> builderIDs, List<String> containerIDs, List<String> accessorIDs, List<String> managerIDs, boolean inheritNothing, Long id) {
        this.modifiedDate = Calendar.getInstance().getTime();
        this.id = id;
        this.lesserBoundaryCorner = lesserBoundaryCorner;
        this.greaterBoundaryCorner = greaterBoundaryCorner;
        this.ownerID = ownerID;
        for (String builderID : builderIDs) {
            this.setPermission(builderID, ClaimPermission.Build);
        }
        for (String containerID : containerIDs) {
            this.setPermission(containerID, ClaimPermission.Inventory);
        }
        for (String accessorID : accessorIDs) {
            this.setPermission(accessorID, ClaimPermission.Access);
        }
        for (String managerID : managerIDs) {
            if (managerID == null || managerID.isEmpty()) continue;
            this.managers.add(managerID);
        }
        this.inheritNothing = inheritNothing;
    }

    Claim(Location lesserBoundaryCorner, Location greaterBoundaryCorner, UUID ownerID, List<String> builderIDs, List<String> containerIDs, List<String> accessorIDs, List<String> managerIDs, Long id) {
        this(lesserBoundaryCorner, greaterBoundaryCorner, ownerID, builderIDs, containerIDs, accessorIDs, managerIDs, false, id);
    }

    public Claim(Claim claim) {
        this.modifiedDate = claim.modifiedDate;
        this.lesserBoundaryCorner = claim.greaterBoundaryCorner.clone();
        this.greaterBoundaryCorner = claim.greaterBoundaryCorner.clone();
        this.id = claim.id;
        this.ownerID = claim.ownerID;
        this.managers = new ArrayList<String>(claim.managers);
        this.playerIDToClaimPermissionMap = new HashMap<String, ClaimPermission>(claim.playerIDToClaimPermissionMap);
        this.inDataStore = false;
        this.areExplosivesAllowed = claim.areExplosivesAllowed;
        this.parent = claim.parent;
        this.inheritNothing = claim.inheritNothing;
        this.children = new ArrayList<Claim>(claim.children);
        this.siegeData = claim.siegeData;
        this.doorsOpen = claim.doorsOpen;
    }

    public int getArea() {
        int claimWidth = this.greaterBoundaryCorner.getBlockX() - this.lesserBoundaryCorner.getBlockX() + 1;
        int claimHeight = this.greaterBoundaryCorner.getBlockZ() - this.lesserBoundaryCorner.getBlockZ() + 1;
        return claimWidth * claimHeight;
    }

    public int getWidth() {
        return this.greaterBoundaryCorner.getBlockX() - this.lesserBoundaryCorner.getBlockX() + 1;
    }

    public int getHeight() {
        return this.greaterBoundaryCorner.getBlockZ() - this.lesserBoundaryCorner.getBlockZ() + 1;
    }

    public boolean getSubclaimRestrictions() {
        return this.inheritNothing;
    }

    public void setSubclaimRestrictions(boolean inheritNothing) {
        this.inheritNothing = inheritNothing;
    }

    public boolean isNear(Location location, int howNear) {
        Claim claim = new Claim(new Location(this.lesserBoundaryCorner.getWorld(), (double)(this.lesserBoundaryCorner.getBlockX() - howNear), (double)this.lesserBoundaryCorner.getBlockY(), (double)(this.lesserBoundaryCorner.getBlockZ() - howNear)), new Location(this.greaterBoundaryCorner.getWorld(), (double)(this.greaterBoundaryCorner.getBlockX() + howNear), (double)this.greaterBoundaryCorner.getBlockY(), (double)(this.greaterBoundaryCorner.getBlockZ() + howNear)), null, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), null);
        return claim.contains(location, false, true);
    }

    public String allowEdit(Player player) {
        if (player == null) {
            return "";
        }
        if (this.isAdminClaim() ? player.hasPermission("griefprevention.adminclaims") : player.hasPermission("griefprevention.deleteclaims")) {
            return null;
        }
        if (player.getUniqueId().equals(this.ownerID)) {
            if (this.siegeData != null) {
                return GriefPrevention.instance.dataStore.getMessage(Messages.NoModifyDuringSiege, new String[0]);
            }
            return null;
        }
        if (this.parent != null) {
            if (player.getUniqueId().equals(this.parent.ownerID)) {
                return null;
            }
            if (!this.inheritNothing) {
                return this.parent.allowEdit(player);
            }
        }
        return GriefPrevention.instance.dataStore.getMessage(Messages.OnlyOwnersModifyClaims, this.getOwnerName());
    }

    private static boolean placeableForFarming(Material material) {
        return PLACEABLE_FARMING_BLOCKS.contains(material);
    }

    public String allowBuild(Player player, Material material) {
        if (player == null) {
            return "";
        }
        GriefPrevention.instance.dataStore.tryExtendSiege(player, this);
        if (this.isAdminClaim() && player.hasPermission("griefprevention.adminclaims")) {
            return null;
        }
        if (this.siegeData != null) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildUnderSiege, this.siegeData.attacker.getName());
        }
        PlayerData playerData = GriefPrevention.instance.dataStore.getPlayerData(player.getUniqueId());
        if (playerData.inPvpCombat()) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildPvP, new String[0]);
        }
        if (player.getUniqueId().equals(this.ownerID) || GriefPrevention.instance.dataStore.getPlayerData((UUID)player.getUniqueId()).ignoreClaims) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Build)) {
            return null;
        }
        if (ClaimPermission.Build.isGrantedBy(this.playerIDToClaimPermissionMap.get("public"))) {
            return null;
        }
        if (this.allowContainers(player) == null && Claim.placeableForFarming(material)) {
            return null;
        }
        if (this.parent != null) {
            if (player.getUniqueId().equals(this.parent.ownerID)) {
                return null;
            }
            if (!this.inheritNothing) {
                return this.parent.allowBuild(player, material);
            }
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoBuildPermission, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = reason + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    public boolean hasExplicitPermission(UUID uuid, ClaimPermission level) {
        return level.isGrantedBy(this.playerIDToClaimPermissionMap.get(uuid.toString()));
    }

    public boolean hasExplicitPermission(Player player, ClaimPermission level) {
        if (this.hasExplicitPermission(player.getUniqueId(), level)) {
            return true;
        }
        for (Map.Entry<String, ClaimPermission> stringToPermission : this.playerIDToClaimPermissionMap.entrySet()) {
            String node = stringToPermission.getKey();
            if (node.length() < 3 || node.charAt(0) != '[' || node.charAt(node.length() - 1) != ']' || !level.isGrantedBy(stringToPermission.getValue()) || !player.hasPermission(node.substring(1, node.length() - 1))) continue;
            return true;
        }
        return false;
    }

    public String allowBreak(Player player, Material material) {
        if (this.siegeData != null || this.doorsOpen) {
            boolean breakable = GriefPrevention.instance.config_siege_blocks.contains(material);
            if (!breakable) {
                return GriefPrevention.instance.dataStore.getMessage(Messages.NonSiegeMaterial, new String[0]);
            }
            if (player.getUniqueId().equals(this.ownerID)) {
                return GriefPrevention.instance.dataStore.getMessage(Messages.NoOwnerBuildUnderSiege, new String[0]);
            }
            return null;
        }
        return this.allowBuild(player, material);
    }

    public String allowAccess(Player player) {
        if (this.doorsOpen) {
            return null;
        }
        if (this.isAdminClaim() && player.hasPermission("griefprevention.adminclaims")) {
            return null;
        }
        if (player.getUniqueId().equals(this.ownerID) || GriefPrevention.instance.dataStore.getPlayerData((UUID)player.getUniqueId()).ignoreClaims) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Access)) {
            return null;
        }
        if (ClaimPermission.Access.isGrantedBy(this.playerIDToClaimPermissionMap.get("public"))) {
            return null;
        }
        if (this.parent != null) {
            if (player.getUniqueId().equals(this.parent.ownerID)) {
                return null;
            }
            if (!this.inheritNothing) {
                return this.parent.allowAccess(player);
            }
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoAccessPermission, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = reason + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    public String allowContainers(Player player) {
        if (player == null) {
            return "";
        }
        GriefPrevention.instance.dataStore.tryExtendSiege(player, this);
        if (this.siegeData != null) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.NoContainersSiege, this.siegeData.attacker.getName());
        }
        if (player.getUniqueId().equals(this.ownerID) || GriefPrevention.instance.dataStore.getPlayerData((UUID)player.getUniqueId()).ignoreClaims) {
            return null;
        }
        if (this.isAdminClaim() && player.hasPermission("griefprevention.adminclaims")) {
            return null;
        }
        if (this.hasExplicitPermission(player, ClaimPermission.Inventory)) {
            return null;
        }
        if (ClaimPermission.Inventory.isGrantedBy(this.playerIDToClaimPermissionMap.get("public"))) {
            return null;
        }
        if (this.parent != null) {
            if (player.getUniqueId().equals(this.parent.ownerID)) {
                return null;
            }
            if (!this.inheritNothing) {
                return this.parent.allowContainers(player);
            }
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoContainersPermission, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = reason + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    public String allowGrantPermission(Player player) {
        if (player == null) {
            return "";
        }
        if (this.allowEdit(player) == null) {
            return null;
        }
        for (String managerID : this.managers) {
            if (managerID == null) continue;
            if (player.getUniqueId().toString().equals(managerID)) {
                return null;
            }
            if (!managerID.startsWith("[") || !managerID.endsWith("]") || (managerID = managerID.substring(1, managerID.length() - 1)).isEmpty() || !player.hasPermission(managerID)) continue;
            return null;
        }
        if (this.parent != null) {
            if (player.getUniqueId().equals(this.parent.ownerID)) {
                return null;
            }
            if (!this.inheritNothing) {
                return this.parent.allowGrantPermission(player);
            }
        }
        String reason = GriefPrevention.instance.dataStore.getMessage(Messages.NoPermissionTrust, this.getOwnerName());
        if (player.hasPermission("griefprevention.ignoreclaims")) {
            reason = reason + "  " + GriefPrevention.instance.dataStore.getMessage(Messages.IgnoreClaimsAdvertisement, new String[0]);
        }
        return reason;
    }

    public ClaimPermission getPermission(String playerID) {
        if (playerID == null || playerID.isEmpty()) {
            return null;
        }
        return this.playerIDToClaimPermissionMap.get(playerID.toLowerCase());
    }

    public void setPermission(String playerID, ClaimPermission permissionLevel) {
        if (playerID == null || playerID.isEmpty()) {
            return;
        }
        this.playerIDToClaimPermissionMap.put(playerID.toLowerCase(), permissionLevel);
    }

    public void dropPermission(String playerID) {
        this.playerIDToClaimPermissionMap.remove(playerID.toLowerCase());
        for (Claim child : this.children) {
            child.dropPermission(playerID);
        }
    }

    public void clearPermissions() {
        this.playerIDToClaimPermissionMap.clear();
        this.managers.clear();
        for (Claim child : this.children) {
            child.clearPermissions();
        }
    }

    public void getPermissions(ArrayList<String> builders, ArrayList<String> containers, ArrayList<String> accessors, ArrayList<String> managers) {
        for (Map.Entry<String, ClaimPermission> entry : this.playerIDToClaimPermissionMap.entrySet()) {
            if (entry.getValue() == ClaimPermission.Build) {
                builders.add(entry.getKey());
                continue;
            }
            if (entry.getValue() == ClaimPermission.Inventory) {
                containers.add(entry.getKey());
                continue;
            }
            accessors.add(entry.getKey());
        }
        managers.addAll(this.managers);
    }

    public Location getLesserBoundaryCorner() {
        return this.lesserBoundaryCorner.clone();
    }

    public Location getGreaterBoundaryCorner() {
        return this.greaterBoundaryCorner.clone();
    }

    public String getOwnerName() {
        if (this.parent != null) {
            return this.parent.getOwnerName();
        }
        if (this.ownerID == null) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.OwnerNameForAdminClaims, new String[0]);
        }
        return GriefPrevention.lookupPlayerName(this.ownerID);
    }

    public UUID getOwnerID() {
        if (this.parent != null) {
            return this.parent.ownerID;
        }
        return this.ownerID;
    }

    public boolean contains(Location location, boolean ignoreHeight, boolean excludeSubdivisions) {
        int z;
        int y;
        if (!Objects.equals(location.getWorld(), this.lesserBoundaryCorner.getWorld())) {
            return false;
        }
        int x = location.getBlockX();
        if (!new BoundingBox(this).contains(x, y = ignoreHeight ? location.getBlockY() : this.getLesserBoundaryCorner().getBlockY(), z = location.getBlockZ())) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.contains(location, ignoreHeight, false);
        }
        if (excludeSubdivisions) {
            for (Claim child : this.children) {
                if (!child.contains(location, ignoreHeight, true)) continue;
                return false;
            }
        }
        return true;
    }

    boolean overlaps(Claim otherClaim) {
        if (!Objects.equals(this.lesserBoundaryCorner.getWorld(), otherClaim.getLesserBoundaryCorner().getWorld())) {
            return false;
        }
        return new BoundingBox(this).intersects(new BoundingBox(otherClaim));
    }

    public String allowMoreEntities(boolean remove) {
        if (this.parent != null) {
            return this.parent.allowMoreEntities(remove);
        }
        if (!GriefPrevention.instance.creativeRulesApply(this.getLesserBoundaryCorner())) {
            return null;
        }
        if (this.isAdminClaim()) {
            return null;
        }
        if (this.getArea() > 10000) {
            return null;
        }
        int maxEntities = this.getArea() / 50;
        if (maxEntities == 0) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.ClaimTooSmallForEntities, new String[0]);
        }
        int totalEntities = 0;
        ArrayList<Chunk> chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            Entity[] entities;
            for (Entity entity : entities = chunk.getEntities()) {
                if (entity instanceof Player || !this.contains(entity.getLocation(), false, false) || !remove || ++totalEntities <= maxEntities) continue;
                entity.remove();
            }
        }
        if (totalEntities >= maxEntities) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.TooManyEntitiesInClaim, new String[0]);
        }
        return null;
    }

    public String allowMoreActiveBlocks() {
        if (this.parent != null) {
            return this.parent.allowMoreActiveBlocks();
        }
        int maxActives = this.getArea() / 100;
        if (maxActives == 0) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.ClaimTooSmallForActiveBlocks, new String[0]);
        }
        int totalActives = 0;
        ArrayList<Chunk> chunks = this.getChunks();
        for (Chunk chunk : chunks) {
            BlockState[] actives;
            for (BlockState active : actives = chunk.getTileEntities()) {
                if (!BlockEventHandler.isActiveBlock(active) || !this.contains(active.getLocation(), false, false)) continue;
                ++totalActives;
            }
        }
        if (totalActives >= maxActives) {
            return GriefPrevention.instance.dataStore.getMessage(Messages.TooManyActiveBlocksInClaim, new String[0]);
        }
        return null;
    }

    boolean greaterThan(Claim otherClaim) {
        Location thisCorner = this.getLesserBoundaryCorner();
        Location otherCorner = otherClaim.getLesserBoundaryCorner();
        if (thisCorner.getBlockX() > otherCorner.getBlockX()) {
            return true;
        }
        if (thisCorner.getBlockX() < otherCorner.getBlockX()) {
            return false;
        }
        if (thisCorner.getBlockZ() > otherCorner.getBlockZ()) {
            return true;
        }
        if (thisCorner.getBlockZ() < otherCorner.getBlockZ()) {
            return false;
        }
        return thisCorner.getWorld().getName().compareTo(otherCorner.getWorld().getName()) < 0;
    }

    long getPlayerInvestmentScore() {
        Location lesserBoundaryCorner = this.getLesserBoundaryCorner();
        Set<Material> playerBlocks = RestoreNatureProcessingTask.getPlayerBlocks(lesserBoundaryCorner.getWorld().getEnvironment(), lesserBoundaryCorner.getBlock().getBiome());
        double score = 0.0;
        boolean creativeMode = GriefPrevention.instance.creativeRulesApply(lesserBoundaryCorner);
        for (int x = this.lesserBoundaryCorner.getBlockX(); x <= this.greaterBoundaryCorner.getBlockX(); ++x) {
            for (int z = this.lesserBoundaryCorner.getBlockZ(); z <= this.greaterBoundaryCorner.getBlockZ(); ++z) {
                Block block;
                int y;
                for (y = this.lesserBoundaryCorner.getBlockY(); y < GriefPrevention.instance.getSeaLevel(this.lesserBoundaryCorner.getWorld()) - 5; ++y) {
                    block = this.lesserBoundaryCorner.getWorld().getBlockAt(x, y, z);
                    if (!playerBlocks.contains(block.getType())) continue;
                    if (block.getType() == Material.CHEST && !creativeMode) {
                        score += 10.0;
                        continue;
                    }
                    score += 0.5;
                }
                while (y < this.lesserBoundaryCorner.getWorld().getMaxHeight()) {
                    block = this.lesserBoundaryCorner.getWorld().getBlockAt(x, y, z);
                    if (playerBlocks.contains(block.getType())) {
                        score = block.getType() == Material.CHEST && !creativeMode ? (score += 10.0) : (creativeMode && block.getType() == Material.LAVA ? (score -= 10.0) : (score += 1.0));
                    }
                    ++y;
                }
            }
        }
        return (long)score;
    }

    public ArrayList<Chunk> getChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        World world = this.getLesserBoundaryCorner().getWorld();
        Chunk lesserChunk = this.getLesserBoundaryCorner().getChunk();
        Chunk greaterChunk = this.getGreaterBoundaryCorner().getChunk();
        for (int x = lesserChunk.getX(); x <= greaterChunk.getX(); ++x) {
            for (int z = lesserChunk.getZ(); z <= greaterChunk.getZ(); ++z) {
                chunks.add(world.getChunkAt(x, z));
            }
        }
        return chunks;
    }

    ArrayList<Long> getChunkHashes() {
        return DataStore.getChunkHashes(this);
    }
}

