/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiPredicate;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.CreateClaimResult;
import me.ryanhamshire.GriefPrevention.DataStore;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.Messages;
import me.ryanhamshire.GriefPrevention.PistonMode;
import me.ryanhamshire.GriefPrevention.PlayerData;
import me.ryanhamshire.GriefPrevention.PlayerEventHandler;
import me.ryanhamshire.GriefPrevention.TextMode;
import me.ryanhamshire.GriefPrevention.Visualization;
import me.ryanhamshire.GriefPrevention.VisualizationType;
import me.ryanhamshire.GriefPrevention.util.BoundingBox;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Dispenser;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class BlockEventHandler
implements Listener {
    private final DataStore dataStore;
    private final EnumSet<Material> trashBlocks;
    private static final BlockFace[] HORIZONTAL_DIRECTIONS = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
    private Claim lastSpreadClaim = null;

    public BlockEventHandler(DataStore dataStore) {
        this.dataStore = dataStore;
        this.trashBlocks = EnumSet.noneOf(Material.class);
        this.trashBlocks.add(Material.COBBLESTONE);
        this.trashBlocks.add(Material.TORCH);
        this.trashBlocks.add(Material.DIRT);
        this.trashBlocks.add(Material.OAK_SAPLING);
        this.trashBlocks.add(Material.SPRUCE_SAPLING);
        this.trashBlocks.add(Material.BIRCH_SAPLING);
        this.trashBlocks.add(Material.JUNGLE_SAPLING);
        this.trashBlocks.add(Material.ACACIA_SAPLING);
        this.trashBlocks.add(Material.DARK_OAK_SAPLING);
        this.trashBlocks.add(Material.GRAVEL);
        this.trashBlocks.add(Material.SAND);
        this.trashBlocks.add(Material.TNT);
        this.trashBlocks.add(Material.CRAFTING_TABLE);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent breakEvent) {
        Block block;
        Player player = breakEvent.getPlayer();
        String noBuildReason = GriefPrevention.instance.allowBreak(player, block = breakEvent.getBlock(), block.getLocation(), breakEvent);
        if (noBuildReason != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            breakEvent.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignChanged(SignChangeEvent event) {
        Player player = event.getPlayer();
        Block sign = event.getBlock();
        if (player == null || sign == null) {
            return;
        }
        String noBuildReason = GriefPrevention.instance.allowBuild(player, sign.getLocation(), sign.getType());
        if (noBuildReason != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            event.setCancelled(true);
            return;
        }
        if (!GriefPrevention.instance.config_signNotifications) {
            return;
        }
        StringBuilder lines = new StringBuilder(" placed a sign @ " + GriefPrevention.getfriendlyLocationString(event.getBlock().getLocation()));
        boolean notEmpty = false;
        for (int i = 0; i < event.getLines().length; ++i) {
            String withoutSpaces = event.getLine(i).replace(" ", "");
            if (withoutSpaces.isEmpty()) continue;
            notEmpty = true;
            lines.append("\n  ").append(event.getLine(i));
        }
        String signMessage = lines.toString();
        if (!player.hasPermission("griefprevention.spam") && GriefPrevention.instance.containsBlockedIP(signMessage)) {
            event.setCancelled(true);
            return;
        }
        PlayerData playerData = this.dataStore.getPlayerData(player.getUniqueId());
        if (notEmpty) {
            GriefPrevention.AddLogEntry(player.getName() + lines.toString().replace("\n  ", ";"), null);
            PlayerEventHandler.makeSocialLogEntry(player.getName(), signMessage);
            if (!player.hasPermission("griefprevention.eavesdropsigns")) {
                Collection players = GriefPrevention.instance.getServer().getOnlinePlayers();
                for (Player otherPlayer : players) {
                    if (!otherPlayer.hasPermission("griefprevention.eavesdropsigns")) continue;
                    otherPlayer.sendMessage(ChatColor.GRAY + player.getName() + signMessage);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlocksPlace(BlockMultiPlaceEvent placeEvent) {
        Player player = placeEvent.getPlayer();
        if (!GriefPrevention.instance.claimsEnabledForWorld(placeEvent.getBlock().getWorld())) {
            return;
        }
        for (BlockState block : placeEvent.getReplacedBlockStates()) {
            String noBuildReason = GriefPrevention.instance.allowBuild(player, block.getLocation(), block.getType());
            if (noBuildReason == null) continue;
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            placeEvent.setCancelled(true);
            return;
        }
    }

    private boolean doesAllowFireProximityInWorld(World world) {
        if (GriefPrevention.instance.pvpRulesApply(world)) {
            return GriefPrevention.instance.config_pvp_allowFireNearPlayers;
        }
        return GriefPrevention.instance.config_pvp_allowFireNearPlayers_NonPvp;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPlace(BlockPlaceEvent placeEvent) {
        String noPlaceReason;
        Claim claim;
        PlayerData playerData;
        Player player = placeEvent.getPlayer();
        Block block = placeEvent.getBlock();
        if (block.getType() == Material.FIRE && !this.doesAllowFireProximityInWorld(block.getWorld())) {
            List players = block.getWorld().getPlayers();
            for (Player otherPlayer : players) {
                if (otherPlayer.getGameMode() == GameMode.CREATIVE || otherPlayer.getGameMode() == GameMode.SPECTATOR) continue;
                Location location = otherPlayer.getLocation();
                if (otherPlayer.equals(player) || !(location.distanceSquared(block.getLocation()) < 9.0) || !player.canSee(otherPlayer)) continue;
                GriefPrevention.sendMessage(player, TextMode.Err, Messages.PlayerTooCloseForFire2, new String[0]);
                placeEvent.setCancelled(true);
                return;
            }
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(placeEvent.getBlock().getWorld())) {
            return;
        }
        String noBuildReason = GriefPrevention.instance.allowBuild(player, block.getLocation(), block.getType());
        if (noBuildReason != null) {
            playerData = this.dataStore.getPlayerData(player.getUniqueId());
            claim = this.dataStore.getClaimAt(block.getLocation(), true, playerData.lastClaim);
            if (block.getType() == Material.LECTERN && placeEvent.getBlockReplacedState().getType() == Material.LECTERN && claim != null) {
                playerData.lastClaim = claim;
                String noContainerReason = claim.allowContainers(player);
                if (noContainerReason == null) {
                    return;
                }
                placeEvent.setCancelled(true);
                GriefPrevention.sendMessage(player, TextMode.Err, noContainerReason);
                return;
            }
            GriefPrevention.sendMessage(player, TextMode.Err, noBuildReason);
            placeEvent.setCancelled(true);
            return;
        }
        playerData = this.dataStore.getPlayerData(player.getUniqueId());
        claim = this.dataStore.getClaimAt(block.getLocation(), true, playerData.lastClaim);
        this.denyConnectingDoubleChestsAcrossClaimBoundary(claim, block, player);
        if (claim != null) {
            playerData.lastClaim = claim;
            if (block.getType() == Material.TNT && !claim.areExplosivesAllowed && playerData.siegeData == null) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoTNTDamageClaims, new String[0]);
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.ClaimExplosivesAdvertisement, new String[0]);
            }
            if (block.getY() <= claim.lesserBoundaryCorner.getBlockY() && claim.allowBuild(player, block.getType()) == null) {
                this.dataStore.extendClaim(claim, block.getY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance);
            }
            playerData.warnedAboutBuildingOutsideClaims = false;
        } else if (GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius > -1 && player.hasPermission("griefprevention.createclaims") && block.getType() == Material.CHEST) {
            if (GriefPrevention.instance.config_claims_preventTheft && block.getY() < GriefPrevention.instance.config_claims_maxDepth) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.TooDeepToClaim, new String[0]);
                return;
            }
            if (playerData.getClaims().size() == 0) {
                if (GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius == 0) {
                    this.dataStore.createClaim(block.getWorld(), block.getX(), block.getX(), block.getY(), block.getY(), block.getZ(), block.getZ(), player.getUniqueId(), null, null, player);
                    GriefPrevention.sendMessage(player, TextMode.Success, Messages.ChestClaimConfirmation, new String[0]);
                } else {
                    if ((double)playerData.getRemainingClaimBlocks() < Math.pow(1 + 2 * GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadiusMin, 2.0)) {
                        GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoEnoughBlocksForChestClaim, new String[0]);
                        return;
                    }
                    CreateClaimResult result = null;
                    for (int radius = GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadius; radius >= GriefPrevention.instance.config_claims_automaticClaimsForNewPlayersRadiusMin; --radius) {
                        int area = (radius * 2 + 1) * (radius * 2 + 1);
                        if (playerData.getRemainingClaimBlocks() < area) continue;
                        result = this.dataStore.createClaim(block.getWorld(), block.getX() - radius, block.getX() + radius, block.getY() - GriefPrevention.instance.config_claims_claimsExtendIntoGroundDistance, block.getY(), block.getZ() - radius, block.getZ() + radius, player.getUniqueId(), null, null, player);
                        if (result.succeeded) break;
                    }
                    if (result != null && result.claim != null) {
                        if (result.succeeded) {
                            GriefPrevention.sendMessage(player, TextMode.Success, Messages.AutomaticClaimNotification, new String[0]);
                            Visualization visualization = Visualization.FromClaim(result.claim, block.getY(), VisualizationType.Claim, player.getLocation());
                            Visualization.Apply(player, visualization);
                        } else {
                            GriefPrevention.sendMessage(player, TextMode.Err, Messages.AutomaticClaimOtherClaimTooClose, new String[0]);
                            Visualization visualization = Visualization.FromClaim(result.claim, block.getY(), VisualizationType.ErrorClaim, player.getLocation());
                            Visualization.Apply(player, visualization);
                        }
                    }
                }
                GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
            }
            if (GriefPrevention.instance.config_claims_preventTheft && this.dataStore.getClaimAt(block.getLocation(), false, playerData.lastClaim) == null) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.UnprotectedChestWarning, new String[0]);
            }
        } else if (Tag.SAPLINGS.isTagged((Keyed)block.getType()) && GriefPrevention.instance.config_blockSkyTrees && GriefPrevention.instance.claimsEnabledForWorld(player.getWorld())) {
            Block earthBlock = placeEvent.getBlockAgainst();
            if (earthBlock.getType() != Material.GRASS && (earthBlock.getRelative(BlockFace.DOWN).getType() == Material.AIR || earthBlock.getRelative(BlockFace.DOWN).getRelative(BlockFace.DOWN).getType() == Material.AIR)) {
                placeEvent.setCancelled(true);
            }
        } else if (!this.trashBlocks.contains(block.getType()) && GriefPrevention.instance.claimsEnabledForWorld(block.getWorld()) && !playerData.warnedAboutBuildingOutsideClaims && !player.hasPermission("griefprevention.adminclaims") && player.hasPermission("griefprevention.createclaims") && (playerData.lastClaim == null && playerData.getClaims().size() == 0 || playerData.lastClaim != null && playerData.lastClaim.isNear(player.getLocation(), 15))) {
            Long now = null;
            if (playerData.buildWarningTimestamp == null || (now = Long.valueOf(System.currentTimeMillis())) - playerData.buildWarningTimestamp > 600000L) {
                GriefPrevention.sendMessage(player, TextMode.Warn, Messages.BuildingOutsideClaims, new String[0]);
                playerData.warnedAboutBuildingOutsideClaims = true;
                if (now == null) {
                    now = System.currentTimeMillis();
                }
                playerData.buildWarningTimestamp = now;
                if (playerData.getClaims().size() < 2) {
                    GriefPrevention.sendMessage(player, TextMode.Instr, Messages.SurvivalBasicsVideo2, DataStore.SURVIVAL_VIDEO_URL);
                }
                if (playerData.lastClaim != null) {
                    Visualization visualization = Visualization.FromClaim(playerData.lastClaim, block.getY(), VisualizationType.Claim, player.getLocation());
                    Visualization.Apply(player, visualization);
                }
            }
        }
        if (GriefPrevention.instance.config_blockSurfaceOtherExplosions && block.getType() == Material.TNT && block.getWorld().getEnvironment() != World.Environment.NETHER && block.getY() > GriefPrevention.instance.getSeaLevel(block.getWorld()) - 5 && claim == null && playerData.siegeData == null) {
            GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoTNTDamageAboveSeaLevel, new String[0]);
        }
        if (GriefPrevention.instance.config_pistonMovement == PistonMode.CLAIMS_ONLY && (block.getType() == Material.PISTON || block.getType() == Material.STICKY_PISTON) && claim == null) {
            GriefPrevention.sendMessage(player, TextMode.Warn, Messages.NoPistonsOutsideClaims, new String[0]);
        }
        if (!player.hasPermission("griefprevention.adminclaims") && GriefPrevention.instance.creativeRulesApply(block.getLocation()) && BlockEventHandler.isActiveBlock(block) && (noPlaceReason = claim.allowMoreActiveBlocks()) != null) {
            GriefPrevention.sendMessage(player, TextMode.Err, noPlaceReason);
            placeEvent.setCancelled(true);
            return;
        }
    }

    static boolean isActiveBlock(Block block) {
        return BlockEventHandler.isActiveBlock(block.getType());
    }

    static boolean isActiveBlock(BlockState state) {
        return BlockEventHandler.isActiveBlock(state.getType());
    }

    static boolean isActiveBlock(Material type) {
        return type == Material.HOPPER || type == Material.BEACON || type == Material.SPAWNER;
    }

    private void denyConnectingDoubleChestsAcrossClaimBoundary(Claim claim, Block block, Player player) {
        UUID claimOwner = null;
        if (claim != null) {
            claimOwner = claim.getOwnerID();
        }
        if (block.getBlockData() instanceof Chest) {
            for (BlockFace face : HORIZONTAL_DIRECTIONS) {
                UUID relativeClaimOwner;
                Block relative = block.getRelative(face);
                if (!(relative.getBlockData() instanceof Chest)) continue;
                Claim relativeClaim = this.dataStore.getClaimAt(relative.getLocation(), true, claim);
                UUID uUID = relativeClaimOwner = relativeClaim == null ? null : relativeClaim.getOwnerID();
                if (Objects.equals(claimOwner, relativeClaimOwner)) break;
                Chest chest = (Chest)block.getBlockData();
                chest.setType(Chest.Type.SINGLE);
                block.setBlockData((BlockData)chest);
                Chest relativeChest = (Chest)relative.getBlockData();
                relativeChest.setType(Chest.Type.SINGLE);
                relative.setBlockData((BlockData)relativeChest);
                player.sendBlockChange(relative.getLocation(), (BlockData)relativeChest);
                break;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        this.onPistonEvent((BlockPistonEvent)event, event.getBlocks(), false);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        this.onPistonEvent((BlockPistonEvent)event, event.getBlocks(), true);
    }

    private void onPistonEvent(BlockPistonEvent event, List<Block> blocks, boolean isRetract) {
        BiPredicate<Claim, BoundingBox> intersectionHandler;
        PistonMode pistonMode = GriefPrevention.instance.config_pistonMovement;
        if (pistonMode == PistonMode.IGNORED) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getBlock().getWorld())) {
            return;
        }
        BlockFace direction = event.getDirection();
        Block pistonBlock = event.getBlock();
        Claim pistonClaim = this.dataStore.getClaimAt(pistonBlock.getLocation(), false, pistonMode != PistonMode.CLAIMS_ONLY, null);
        if (pistonClaim == null && pistonMode == PistonMode.CLAIMS_ONLY) {
            event.setCancelled(true);
            return;
        }
        if (blocks.isEmpty()) {
            if (isRetract) {
                return;
            }
            Block invadedBlock = pistonBlock.getRelative(direction);
            Claim invadedClaim = this.dataStore.getClaimAt(invadedBlock.getLocation(), false, pistonMode != PistonMode.CLAIMS_ONLY, pistonClaim);
            if (!(invadedClaim == null || pistonClaim != null && Objects.equals(pistonClaim.getOwnerID(), invadedClaim.getOwnerID()))) {
                event.setCancelled(true);
            }
            return;
        }
        BoundingBox movedBlocks = BoundingBox.ofBlocks(blocks);
        movedBlocks.resize(direction, 1);
        if (pistonClaim != null) {
            if (new BoundingBox(pistonClaim).contains(movedBlocks)) {
                return;
            }
            if (pistonMode == PistonMode.CLAIMS_ONLY) {
                event.setCancelled(true);
                return;
            }
        }
        if (movedBlocks.getLength() == 1 && movedBlocks.getWidth() == 1) {
            if (isRetract && direction == BlockFace.UP) {
                return;
            }
            if (!isRetract && direction == BlockFace.DOWN) {
                return;
            }
        }
        ArrayList<Claim> intersectable = new ArrayList<Claim>();
        int chunkXMax = movedBlocks.getMaxX() >> 4;
        int chunkZMax = movedBlocks.getMaxZ() >> 4;
        for (int chunkX = movedBlocks.getMinX() >> 4; chunkX <= chunkXMax; ++chunkX) {
            for (int chunkZ = movedBlocks.getMinZ() >> 4; chunkZ <= chunkZMax; ++chunkZ) {
                ArrayList<Claim> chunkClaims = this.dataStore.chunksToClaimsMap.get(DataStore.getChunkHash(chunkX, chunkZ));
                if (chunkClaims == null) continue;
                for (Claim claim2 : chunkClaims) {
                    if (pistonClaim == claim2 || !pistonBlock.getWorld().equals(claim2.getLesserBoundaryCorner().getWorld())) continue;
                    intersectable.add(claim2);
                }
            }
        }
        Claim finalPistonClaim = pistonClaim;
        if (pistonMode == PistonMode.EVERYWHERE_SIMPLE) {
            intersectionHandler = (claim, claimBoundingBox) -> {
                if (finalPistonClaim == null || !Objects.equals(finalPistonClaim.getOwnerID(), claim.getOwnerID())) {
                    event.setCancelled(true);
                    return true;
                }
                return false;
            };
        } else {
            HashSet<Block> checkBlocks = new HashSet<Block>(blocks);
            for (Block block : blocks) {
                if (block.getPistonMoveReaction() == PistonMoveReaction.BREAK) continue;
                checkBlocks.add(block.getRelative(direction));
            }
            intersectionHandler = (claim, claimBoundingBox) -> {
                if (checkBlocks.stream().noneMatch(claimBoundingBox::contains)) {
                    return false;
                }
                if (finalPistonClaim == null || !Objects.equals(finalPistonClaim.getOwnerID(), claim.getOwnerID())) {
                    event.setCancelled(true);
                    if (GriefPrevention.instance.config_pistonExplosionSound) {
                        pistonBlock.getWorld().createExplosion(pistonBlock.getLocation(), 0.0f);
                    }
                    pistonBlock.getWorld().dropItem(pistonBlock.getLocation(), new ItemStack(event.isSticky() ? Material.STICKY_PISTON : Material.PISTON));
                    pistonBlock.setType(Material.AIR);
                    return true;
                }
                return false;
            };
        }
        for (Claim claim3 : intersectable) {
            BoundingBox claimBoundingBox2 = new BoundingBox(claim3);
            if (!claimBoundingBox2.intersects(movedBlocks) || !intersectionHandler.test(claim3, claimBoundingBox2)) continue;
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockIgnite(BlockIgniteEvent igniteEvent) {
        Claim claim;
        ProjectileSource shooter;
        if (!GriefPrevention.instance.claimsEnabledForWorld(igniteEvent.getBlock().getWorld())) {
            return;
        }
        if (igniteEvent.getCause() == BlockIgniteEvent.IgniteCause.LIGHTNING && GriefPrevention.instance.dataStore.getClaimAt(igniteEvent.getIgnitingEntity().getLocation(), false, null) != null) {
            igniteEvent.setCancelled(true);
        }
        if (igniteEvent.getCause() == BlockIgniteEvent.IgniteCause.FIREBALL && igniteEvent.getIgnitingEntity() instanceof Fireball && (shooter = ((Fireball)igniteEvent.getIgnitingEntity()).getShooter()) instanceof BlockProjectileSource && (claim = GriefPrevention.instance.dataStore.getClaimAt(igniteEvent.getBlock().getLocation(), false, null)) != null && GriefPrevention.instance.dataStore.getClaimAt(((BlockProjectileSource)shooter).getBlock().getLocation(), false, claim) == claim) {
            return;
        }
        if (igniteEvent.getCause() == BlockIgniteEvent.IgniteCause.ARROW) {
            Claim claim2 = GriefPrevention.instance.dataStore.getClaimAt(igniteEvent.getBlock().getLocation(), false, null);
            if (claim2 == null) {
                if (!GriefPrevention.instance.config_fireDestroys || !GriefPrevention.instance.config_fireSpreads) {
                    igniteEvent.setCancelled(true);
                }
                return;
            }
            if (igniteEvent.getIgnitingEntity() instanceof Projectile) {
                ProjectileSource shooter2 = ((Projectile)igniteEvent.getIgnitingEntity()).getShooter();
                if (shooter2 instanceof Player && claim2.allowBuild((Player)shooter2, Material.TNT) == null) {
                    return;
                }
                if (shooter2 instanceof BlockProjectileSource && GriefPrevention.instance.dataStore.getClaimAt(((BlockProjectileSource)shooter2).getBlock().getLocation(), false, claim2) == claim2) {
                    return;
                }
            }
            igniteEvent.setCancelled(true);
            return;
        }
        if (!GriefPrevention.instance.config_fireSpreads && igniteEvent.getCause() != BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL && igniteEvent.getCause() != BlockIgniteEvent.IgniteCause.LIGHTNING) {
            igniteEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockSpread(BlockSpreadEvent spreadEvent) {
        if (spreadEvent.getSource().getType() != Material.FIRE) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(spreadEvent.getBlock().getWorld())) {
            return;
        }
        if (!GriefPrevention.instance.config_fireSpreads) {
            spreadEvent.setCancelled(true);
            Block underBlock = spreadEvent.getSource().getRelative(BlockFace.DOWN);
            if (underBlock.getType() != Material.NETHERRACK) {
                spreadEvent.getSource().setType(Material.AIR);
            }
            return;
        }
        if (this.dataStore.getClaimAt(spreadEvent.getBlock().getLocation(), false, null) != null) {
            if (GriefPrevention.instance.config_claims_firespreads) {
                return;
            }
            spreadEvent.setCancelled(true);
            Block source = spreadEvent.getSource();
            if (source.getRelative(BlockFace.DOWN).getType() != Material.NETHERRACK) {
                source.setType(Material.AIR);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBurn(BlockBurnEvent burnEvent) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(burnEvent.getBlock().getWorld())) {
            return;
        }
        if (!GriefPrevention.instance.config_fireDestroys) {
            Block[] adjacentBlocks;
            burnEvent.setCancelled(true);
            Block block = burnEvent.getBlock();
            for (Block adjacentBlock : adjacentBlocks = new Block[]{block.getRelative(BlockFace.UP), block.getRelative(BlockFace.DOWN), block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.SOUTH), block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.WEST)}) {
                if (adjacentBlock.getType() != Material.FIRE || adjacentBlock.getRelative(BlockFace.DOWN).getType() == Material.NETHERRACK) continue;
                adjacentBlock.setType(Material.AIR);
            }
            Block aboveBlock = block.getRelative(BlockFace.UP);
            if (aboveBlock.getType() == Material.FIRE) {
                aboveBlock.setType(Material.AIR);
            }
            return;
        }
        if (this.dataStore.getClaimAt(burnEvent.getBlock().getLocation(), false, null) != null) {
            if (GriefPrevention.instance.config_claims_firedamages) {
                return;
            }
            burnEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onBlockFromTo(BlockFromToEvent spreadEvent) {
        if (spreadEvent.getFace() == BlockFace.DOWN) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(spreadEvent.getBlock().getWorld())) {
            return;
        }
        Block toBlock = spreadEvent.getToBlock();
        Location toLocation = toBlock.getLocation();
        Claim toClaim = this.dataStore.getClaimAt(toLocation, false, this.lastSpreadClaim);
        if (toClaim != null) {
            this.lastSpreadClaim = toClaim;
            if (!(toClaim.contains(spreadEvent.getBlock().getLocation(), false, true) || toClaim.parent != null && toClaim.parent.contains(spreadEvent.getBlock().getLocation(), false, false))) {
                spreadEvent.setCancelled(true);
            }
        } else if (GriefPrevention.instance.creativeRulesApply(toLocation)) {
            spreadEvent.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onForm(BlockFormEvent event) {
        Claim claim;
        Material type;
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (GriefPrevention.instance.creativeRulesApply(location) && ((type = block.getType()) == Material.COBBLESTONE || type == Material.OBSIDIAN || type == Material.LAVA || type == Material.WATER) && (claim = GriefPrevention.instance.dataStore.getClaimAt(location, false, null)) == null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void chorusFlower(ProjectileHitEvent event) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getHitBlock() == null || event.getHitBlock().getType() != Material.CHORUS_FLOWER) {
            return;
        }
        Block block = event.getHitBlock();
        Claim claim = this.dataStore.getClaimAt(block.getLocation(), false, null);
        if (claim == null) {
            return;
        }
        Player shooter = null;
        Projectile projectile = event.getEntity();
        if (projectile.getShooter() instanceof Player) {
            shooter = (Player)projectile.getShooter();
        }
        if (shooter == null) {
            event.getHitBlock().setType(Material.AIR);
            Bukkit.getScheduler().runTask((Plugin)GriefPrevention.instance, () -> event.getHitBlock().setBlockData(block.getBlockData()));
            return;
        }
        String allowContainer = claim.allowContainers(shooter);
        if (allowContainer != null) {
            event.getHitBlock().setType(Material.AIR);
            Bukkit.getScheduler().runTask((Plugin)GriefPrevention.instance, () -> event.getHitBlock().setBlockData(block.getBlockData()));
            GriefPrevention.sendMessage(shooter, TextMode.Err, allowContainer);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDispense(BlockDispenseEvent dispenseEvent) {
        if (!GriefPrevention.instance.claimsEnabledForWorld(dispenseEvent.getBlock().getWorld())) {
            return;
        }
        Block fromBlock = dispenseEvent.getBlock();
        BlockData fromData = fromBlock.getBlockData();
        if (!(fromData instanceof Dispenser)) {
            return;
        }
        Dispenser dispenser = (Dispenser)fromData;
        Block toBlock = fromBlock.getRelative(dispenser.getFacing());
        Claim fromClaim = this.dataStore.getClaimAt(fromBlock.getLocation(), false, null);
        Claim toClaim = this.dataStore.getClaimAt(toBlock.getLocation(), false, fromClaim);
        Material materialDispensed = dispenseEvent.getItem().getType();
        if ((materialDispensed == Material.WATER_BUCKET || materialDispensed == Material.LAVA_BUCKET) && GriefPrevention.instance.creativeRulesApply(dispenseEvent.getBlock().getLocation()) && toClaim == null) {
            dispenseEvent.setCancelled(true);
            return;
        }
        if (fromClaim == null && toClaim == null) {
            return;
        }
        if (fromClaim == toClaim) {
            return;
        }
        dispenseEvent.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onTreeGrow(StructureGrowEvent growEvent) {
        if (!GriefPrevention.instance.config_limitTreeGrowth) {
            return;
        }
        if (!GriefPrevention.instance.claimsEnabledForWorld(growEvent.getWorld())) {
            return;
        }
        Location rootLocation = growEvent.getLocation();
        Claim rootClaim = this.dataStore.getClaimAt(rootLocation, false, null);
        String rootOwnerName = null;
        if (rootClaim != null) {
            if (rootClaim.parent != null) {
                rootClaim = rootClaim.parent;
            }
            if (rootClaim.isAdminClaim()) {
                return;
            }
            rootOwnerName = rootClaim.getOwnerName();
        }
        for (int i = 0; i < growEvent.getBlocks().size(); ++i) {
            BlockState block = (BlockState)growEvent.getBlocks().get(i);
            Claim blockClaim = this.dataStore.getClaimAt(block.getLocation(), false, rootClaim);
            if (blockClaim == null || rootOwnerName != null && rootOwnerName.equals(blockClaim.getOwnerName())) continue;
            growEvent.getBlocks().remove(i--);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        Item item;
        List data;
        InventoryHolder holder = event.getInventory().getHolder();
        if ((holder instanceof HopperMinecart || holder instanceof Hopper) && (data = (item = event.getItem()).getMetadata("GP_ITEMOWNER")) != null && data.size() > 0) {
            UUID ownerID = (UUID)((MetadataValue)data.get(0)).value();
            OfflinePlayer owner = GriefPrevention.instance.getServer().getOfflinePlayer(ownerID);
            if (owner.isOnline()) {
                PlayerData playerData = this.dataStore.getPlayerData(ownerID);
                if (!playerData.dropsAreUnlocked) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemFrameBrokenByBoat(HangingBreakEvent event) {
        if (event.getCause() != HangingBreakEvent.RemoveCause.PHYSICS) {
            return;
        }
        if (this.dataStore.getClaimAt(event.getEntity().getLocation(), false, null) != null) {
            event.setCancelled(true);
        }
    }
}

