/*
 * Decompiled with CFR 0.152.
 */
package me.ryanhamshire.GriefPrevention;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.ryanhamshire.GriefPrevention.Claim;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.RestoreNatureProcessingTask;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.plugin.Plugin;

class AutoExtendClaimTask
implements Runnable {
    private final Claim claim;
    private final ArrayList<ChunkSnapshot> chunks;
    private final World.Environment worldType;
    private final Map<Biome, Set<Material>> biomeMaterials = new HashMap<Biome, Set<Material>>();

    public AutoExtendClaimTask(Claim claim, ArrayList<ChunkSnapshot> chunks, World.Environment worldType) {
        this.claim = claim;
        this.chunks = chunks;
        this.worldType = worldType;
    }

    @Override
    public void run() {
        int newY = this.getLowestBuiltY();
        if (newY < this.claim.getLesserBoundaryCorner().getBlockY()) {
            Bukkit.getScheduler().runTask((Plugin)GriefPrevention.instance, (Runnable)new ExecuteExtendClaimTask(this.claim, newY));
        }
    }

    private int getLowestBuiltY() {
        int y = this.claim.getLesserBoundaryCorner().getBlockY();
        if (this.yTooSmall(y)) {
            return y;
        }
        for (ChunkSnapshot chunk : this.chunks) {
            boolean ychanged = true;
            while (!this.yTooSmall(y) && ychanged) {
                ychanged = false;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        Material blockType = chunk.getBlockType(x, y, z);
                        Biome biome = chunk.getBiome(x, y, z);
                        while (!this.yTooSmall(y) && this.getBiomeBlocks(biome).contains(blockType)) {
                            ychanged = true;
                            blockType = chunk.getBlockType(x, --y, z);
                            biome = chunk.getBiome(x, y, z);
                        }
                        if (!this.yTooSmall(y)) continue;
                        return y;
                    }
                }
            }
            if (!this.yTooSmall(y)) continue;
            return y;
        }
        return y;
    }

    private Set<Material> getBiomeBlocks(Biome biome) {
        return this.biomeMaterials.computeIfAbsent(biome, newBiome -> RestoreNatureProcessingTask.getPlayerBlocks(this.worldType, newBiome));
    }

    private boolean yTooSmall(int y) {
        return y == 0 || y <= GriefPrevention.instance.config_claims_maxDepth;
    }

    private class ExecuteExtendClaimTask
    implements Runnable {
        private final Claim claim;
        private final int newY;

        public ExecuteExtendClaimTask(Claim claim, int newY) {
            this.claim = claim;
            this.newY = newY;
        }

        @Override
        public void run() {
            GriefPrevention.instance.dataStore.extendClaim(this.claim, this.newY);
        }
    }
}

