/*
 * Decompiled with CFR 0.152.
 */
package gotap.com.tapglkitandroid.gl.Shaders;

import android.content.Context;
import android.graphics.Color;
import android.opengl.GLES20;
import android.os.Build;
import gotap.com.tapglkitandroid.gl.R;
import gotap.com.tapglkitandroid.gl.Shaders.BaseShader;
import gotap.com.tapglkitandroid.gl.Views.TapRender;

public class TapLoadingShader
extends BaseShader {
    private final String kUniformOutterCircleColorKey = "outterCircleColor";
    private final String kUniformInnerCircleColorKey = "innerCircleColor";
    private final String kUniformClearColorKey = "clearColor";
    private final String kUniformUsesCustomColorsKey = "usesCustomColors";
    private final String kUniformTimeKey = "time";
    private int outterCircleColorUniform;
    private int innerCircleColorUniform;
    private int clearColorUniform;
    private int usesCustomColorsUniform;
    private int timeUniform;
    private float[] outterColorComponents = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] innerColorComponents = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    float timer = 0.0f;

    public TapLoadingShader(Context context, TapRender.TapRenderListener listener) {
        super(context, listener);
    }

    @Override
    int vertexShaderRaw() {
        return R.raw.vertex_shader;
    }

    @Override
    int fragmentShaderRaw() {
        return Build.VERSION.SDK_INT < 21 ? R.raw.fragment_shader : R.raw.fragment_shader_android_5_and_above;
    }

    @Override
    void obtainAttributesAndUniformsForShader() {
        this.outterCircleColorUniform = GLES20.glGetUniformLocation((int)this.programId, (String)"outterCircleColor");
        this.innerCircleColorUniform = GLES20.glGetUniformLocation((int)this.programId, (String)"innerCircleColor");
        this.clearColorUniform = GLES20.glGetUniformLocation((int)this.programId, (String)"clearColor");
        this.usesCustomColorsUniform = GLES20.glGetUniformLocation((int)this.programId, (String)"usesCustomColors");
        this.timeUniform = GLES20.glGetUniformLocation((int)this.programId, (String)"time");
    }

    @Override
    void drawElement() {
        GLES20.glUniform1i((int)this.usesCustomColorsUniform, (int)0);
        if (this.listener == null) {
            float f = this.timer;
            this.timer = f + 1.0f;
            GLES20.glUniform1f((int)this.timeUniform, (float)(f / 60.0f));
        } else {
            GLES20.glUniform1f((int)this.timeUniform, (float)this.listener.getTimer());
            if (this.listener.useCustomColor()) {
                this.setColor();
                GLES20.glUniform1i((int)this.usesCustomColorsUniform, (int)1);
            }
        }
        GLES20.glUniform4f((int)this.outterCircleColorUniform, (float)this.outterColorComponents[0], (float)this.outterColorComponents[1], (float)this.outterColorComponents[2], (float)this.outterColorComponents[3]);
        GLES20.glUniform4f((int)this.innerCircleColorUniform, (float)this.innerColorComponents[0], (float)this.innerColorComponents[1], (float)this.innerColorComponents[2], (float)this.innerColorComponents[3]);
        GLES20.glUniform4f((int)this.clearColorUniform, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    void setColor() {
        this.outterColorComponents[0] = (float)Color.red((int)this.listener.getColor()) / 255.0f;
        this.outterColorComponents[1] = (float)Color.green((int)this.listener.getColor()) / 255.0f;
        this.outterColorComponents[2] = (float)Color.blue((int)this.listener.getColor()) / 255.0f;
        this.outterColorComponents[3] = (float)Color.alpha((int)this.listener.getColor()) / 255.0f;
        this.innerColorComponents[0] = (float)Color.red((int)this.listener.getColor()) / 255.0f;
        this.innerColorComponents[1] = (float)Color.green((int)this.listener.getColor()) / 255.0f;
        this.innerColorComponents[2] = (float)Color.blue((int)this.listener.getColor()) / 255.0f;
        this.innerColorComponents[3] = (float)Color.alpha((int)this.listener.getColor()) / 255.0f;
    }
}

