/*
 * Decompiled with CFR 0.152.
 */
package company.tap.tapcardvalidator_android;

import company.tap.tapcardvalidator_android.CardBINRange;
import company.tap.tapcardvalidator_android.CardBrand;
import company.tap.tapcardvalidator_android.CardValidationState;
import company.tap.tapcardvalidator_android.DefinedCardBrand;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class CardValidator {
    private static final String WHITESPACE_REGEX = "[\t \u00a0\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000]+";
    private static final String INTERNATIONAL_DIGITS_SET = "0123456789";

    public static DefinedCardBrand validate(String cardNumber) {
        return CardValidator.validate(cardNumber, null);
    }

    public static DefinedCardBrand validate(String cardNumber, ArrayList<CardBrand> preferredBrands) {
        String number = cardNumber.replaceAll(WHITESPACE_REGEX, "");
        if (number.isEmpty()) {
            return new DefinedCardBrand(CardValidationState.incomplete, null);
        }
        if (!CardValidator.containsOnlyInternationalDigits(number)) {
            return new DefinedCardBrand(CardValidationState.invalid, null);
        }
        CardBINRange binRange = CardBINRange.mostSpecific(number, preferredBrands);
        CardBrand cardBrand = binRange.getCardBrand();
        if (preferredBrands != null && preferredBrands.size() > 0 && cardBrand == CardBrand.unknown) {
            binRange = CardBINRange.mostSpecific(number);
            cardBrand = binRange.getCardBrand();
        }
        if (cardBrand == CardBrand.unknown) {
            return new DefinedCardBrand(CardValidationState.invalid, null);
        }
        if (CardValidator.arrayContains(binRange.getCardNumberLengths(), number.length())) {
            return new DefinedCardBrand(CardValidator.passesLuhn(number) ? CardValidationState.valid : CardValidationState.invalid, cardBrand);
        }
        if (number.length() > CardValidator.arrayMax(binRange.getCardNumberLengths())) {
            return new DefinedCardBrand(CardValidationState.invalid, cardBrand);
        }
        return new DefinedCardBrand(CardValidationState.incomplete, cardBrand);
    }

    public int getCardLength(CardBrand cardBrand) {
        List<CardBINRange> cardBINRanges = CardBINRange.ranges(cardBrand);
        if (cardBINRanges.isEmpty()) {
            return 0;
        }
        int[] dummy = CardBINRange.ranges(cardBrand).get(0).getCardNumberLengths();
        if (dummy.length == 0) {
            return 0;
        }
        return CardValidator.arrayMax(dummy);
    }

    public static int[] spacings(CardBrand card) {
        if (card == CardBrand.americanExpress) {
            return new int[]{3, 9};
        }
        return new int[]{3, 7, 11};
    }

    public static int cvvLength(CardBrand card) {
        if (card == null || card == CardBrand.unknown || card == CardBrand.americanExpress) {
            return 4;
        }
        return 3;
    }

    public static CardBrand paymentCardBrand(String cardNumber, CardBrand[] brands) {
        String number = cardNumber.replaceAll(WHITESPACE_REGEX, "");
        if (number.length() == 0 || !CardValidator.containsOnlyInternationalDigits(number)) {
            return null;
        }
        LinkedHashSet<CardBrand> possibleBrands = CardBINRange.possibleBrands(number);
        for (CardBrand cardBrand : possibleBrands) {
            if (!CardValidator.collectionContains(brands, cardBrand)) continue;
            return cardBrand;
        }
        return null;
    }

    private static String trimmingCharacters(String string, String regex) {
        return string.replaceAll("^" + regex, "").replaceAll(regex + "$", "");
    }

    private static boolean containsOnlyInternationalDigits(String string) {
        String nonDigitsRegex = "[^0123456789]";
        return string.replaceAll(nonDigitsRegex, "").length() == string.length();
    }

    private static boolean passesLuhn(String number) {
        int sum = 0;
        String reversedNumber = new StringBuilder(number).reverse().toString();
        for (int i = 0; i < reversedNumber.length(); ++i) {
            boolean odd;
            char c = reversedNumber.charAt(i);
            int digit = Character.getNumericValue(c);
            if (digit < 0) {
                return false;
            }
            boolean bl = odd = i % 2 == 1;
            if (odd && digit >= 0 && digit <= 8) {
                sum += digit * 2 % 9;
                continue;
            }
            sum += digit;
        }
        return sum % 10 == 0;
    }

    private static boolean arrayContains(int[] arr, int value) {
        for (int i : arr) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean collectionContains(T[] arr, T value) {
        for (T i : arr) {
            if (i != value && !i.equals(value)) continue;
            return true;
        }
        return false;
    }

    private static int arrayMax(int[] arr) {
        int value = arr[0];
        for (int i : arr) {
            if (i <= value) continue;
            value = i;
        }
        return value;
    }
}

