/*
 * Decompiled with CFR 0.152.
 */
package com.shockwave.pdfium;

import android.graphics.RectF;
import android.os.ParcelFileDescriptor;
import androidx.collection.ArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PdfDocument {
    long mNativeDocPtr;
    ParcelFileDescriptor parcelFileDescriptor;
    final Map<Integer, Long> mNativePagesPtr = new ArrayMap();

    PdfDocument() {
    }

    public boolean hasPage(int index) {
        return this.mNativePagesPtr.containsKey(index);
    }

    public static class Link {
        private RectF bounds;
        private Integer destPageIdx;
        private String uri;

        public Link(RectF bounds, Integer destPageIdx, String uri) {
            this.bounds = bounds;
            this.destPageIdx = destPageIdx;
            this.uri = uri;
        }

        public Integer getDestPageIdx() {
            return this.destPageIdx;
        }

        public String getUri() {
            return this.uri;
        }

        public RectF getBounds() {
            return this.bounds;
        }
    }

    public static class Bookmark {
        private List<Bookmark> children = new ArrayList<Bookmark>();
        String title;
        long pageIdx;
        long mNativePtr;

        public List<Bookmark> getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public String getTitle() {
            return this.title;
        }

        public long getPageIdx() {
            return this.pageIdx;
        }
    }

    public static class Meta {
        String title;
        String author;
        String subject;
        String keywords;
        String creator;
        String producer;
        String creationDate;
        String modDate;

        public String getTitle() {
            return this.title;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getSubject() {
            return this.subject;
        }

        public String getKeywords() {
            return this.keywords;
        }

        public String getCreator() {
            return this.creator;
        }

        public String getProducer() {
            return this.producer;
        }

        public String getCreationDate() {
            return this.creationDate;
        }

        public String getModDate() {
            return this.modDate;
        }
    }
}

