/*
 * Decompiled with CFR 0.152.
 */
package com.goodayapps.widget;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0012\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/goodayapps/widget/CenterCropDrawable;", "Landroid/graphics/drawable/Drawable;", "target", "(Landroid/graphics/drawable/Drawable;)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getOpacity", "", "setAlpha", "alpha", "setBounds", "bounds", "Landroid/graphics/Rect;", "left", "top", "right", "bottom", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "avatar-view_release"})
public final class CenterCropDrawable
extends Drawable {
    @NotNull
    private final Drawable target;

    public CenterCropDrawable(@NotNull Drawable target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    public void setBounds(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        super.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        RectF sourceRect = new RectF(0.0f, 0.0f, (float)this.target.getIntrinsicWidth(), (float)this.target.getIntrinsicHeight());
        RectF screenRect = new RectF((float)left, (float)top, (float)right, (float)bottom);
        Matrix matrix = new Matrix();
        matrix.setRectToRect(screenRect, sourceRect, Matrix.ScaleToFit.CENTER);
        Matrix inverse = new Matrix();
        matrix.invert(inverse);
        inverse.mapRect(sourceRect);
        this.target.setBounds(MathKt.roundToInt((float)sourceRect.left), MathKt.roundToInt((float)sourceRect.top), MathKt.roundToInt((float)sourceRect.right), MathKt.roundToInt((float)sourceRect.bottom));
        super.setBounds(left, top, right, bottom);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.clipRect(this.getBounds());
        this.target.draw(canvas);
        canvas.restore();
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.target.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.target.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return this.target.getOpacity();
    }
}

