/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.cs.treccar_v2.read_data;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import edu.unh.cs.treccar_v2.Header;
import edu.unh.cs.treccar_v2.read_data.CborDataItemIterator;
import edu.unh.cs.treccar_v2.read_data.CborRuntimeException;
import edu.unh.cs.treccar_v2.read_data.DeserializeData;
import java.util.Iterator;

public abstract class CborListWithHeaderIterator<T>
implements Iterator<T> {
    private final CborDataItemIterator listIter;
    private DataItem firstElem;
    private Header.TrecCarHeader header = null;

    public CborListWithHeaderIterator(CborDecoder decoder) throws CborRuntimeException {
        try {
            DataItem dataItem = decoder.decodeNext();
            try {
                this.header = DeserializeData.headerFromCbor(dataItem);
                try {
                    decoder.setAutoDecodeInfinitiveArrays(false);
                    Array arr = (Array)decoder.decodeNext();
                    decoder.setAutoDecodeInfinitiveArrays(true);
                }
                catch (CborException e) {
                    throw new CborRuntimeException(e);
                }
                this.firstElem = null;
            }
            catch (Header.InvalidHeaderException e) {
                this.header = null;
                this.firstElem = dataItem;
            }
            this.listIter = new CborDataItemIterator(decoder);
        }
        catch (CborException e) {
            throw new CborRuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.firstElem != null || this.listIter.hasNext();
    }

    @Override
    public T next() {
        if (this.firstElem != null) {
            DataItem first = this.firstElem;
            this.firstElem = null;
            return this.parseItem(first);
        }
        return this.parseItem(this.listIter.next());
    }

    protected abstract T parseItem(DataItem var1);

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Read-only iterator.");
    }

    public Header.TrecCarHeader getHeader() {
        return this.header;
    }
}

