/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.cs.treccar_v2;

import java.util.ArrayList;
import java.util.Objects;

public class Header {

    public static final class Transform {
        private final String toolName;
        private final String toolCommit;
        private String toolInfo = "<unknown>";

        public Transform(String toolName, String toolCommit) {
            this.toolName = toolName;
            this.toolCommit = toolCommit;
        }

        public String getToolName() {
            return this.toolName;
        }

        public String getToolCommit() {
            return this.toolCommit;
        }

        public String getToolInfo() {
            return this.toolInfo;
        }

        public void setToolInfo(String toolInfo) {
            this.toolInfo = toolInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Transform)) {
                return false;
            }
            Transform transform = (Transform)o;
            return Objects.equals(this.getToolName(), transform.getToolName()) && Objects.equals(this.getToolCommit(), transform.getToolCommit()) && Objects.equals(this.getToolInfo(), transform.getToolInfo());
        }

        public int hashCode() {
            return Objects.hash(this.getToolName(), this.getToolCommit(), this.getToolInfo());
        }

        public String toString() {
            return "Transform{toolName='" + this.toolName + '\'' + ", toolCommit='" + this.toolCommit + '\'' + ", toolInfo='" + this.toolInfo + '\'' + '}';
        }
    }

    public static final class SiteProvenance {
        private String provSiteId;
        private String language;
        private String sourceName;
        private final ArrayList<String> siteComments = new ArrayList();

        public SiteProvenance(String provSiteId, String language, String sourceName) {
            this.provSiteId = provSiteId;
            this.language = language;
            this.sourceName = sourceName;
        }

        public String getProvSiteId() {
            return this.provSiteId;
        }

        public void setProvSiteId(String provSiteId) {
            this.provSiteId = provSiteId;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public ArrayList<String> getSiteComments() {
            return this.siteComments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SiteProvenance)) {
                return false;
            }
            SiteProvenance that = (SiteProvenance)o;
            return Objects.equals(this.getProvSiteId(), that.getProvSiteId()) && Objects.equals(this.getLanguage(), that.getLanguage()) && Objects.equals(this.getSourceName(), that.getSourceName());
        }

        public int hashCode() {
            return Objects.hash(this.getProvSiteId(), this.getLanguage(), this.getSourceName());
        }

        public String toString() {
            return "SiteProvenance{provSiteId='" + this.provSiteId + '\'' + ", language='" + this.language + '\'' + ", sourceName='" + this.sourceName + '\'' + ", siteComments=" + this.siteComments + '}';
        }
    }

    public static final class Provenance {
        private final ArrayList<SiteProvenance> siteProvenance = new ArrayList();
        private final String dataReleaseName;
        private final ArrayList<String> comments = new ArrayList();
        private final ArrayList<Transform> transforms = new ArrayList();

        public Provenance(String dataReleaseName) {
            this.dataReleaseName = dataReleaseName;
        }

        public ArrayList<SiteProvenance> getSiteProvenance() {
            return this.siteProvenance;
        }

        public String getDataReleaseName() {
            return this.dataReleaseName;
        }

        public ArrayList<String> getComments() {
            return this.comments;
        }

        public ArrayList<Transform> getTransforms() {
            return this.transforms;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Provenance)) {
                return false;
            }
            Provenance that = (Provenance)o;
            return Objects.equals(this.getSiteProvenance(), that.getSiteProvenance()) && Objects.equals(this.getDataReleaseName(), that.getDataReleaseName());
        }

        public int hashCode() {
            return Objects.hash(this.getSiteProvenance(), this.getDataReleaseName());
        }

        public String toString() {
            return "Provenance{\nsiteProvenance=" + this.siteProvenance + "\n, dataReleaseName='" + this.dataReleaseName + '\'' + "\n, comments=" + this.comments + "\n, transforms=" + this.transforms + "\n}";
        }
    }

    public static final class InvalidHeaderException
    extends Exception {
    }

    public static final class TrecCarHeader {
        final FileType fileType;
        final Provenance provenance;

        public TrecCarHeader(FileType fileType, Provenance provenance) {
            this.fileType = fileType;
            this.provenance = provenance;
        }

        public FileType getFileType() {
            return this.fileType;
        }

        public Provenance getProvenance() {
            return this.provenance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TrecCarHeader)) {
                return false;
            }
            TrecCarHeader that = (TrecCarHeader)o;
            return this.getFileType() == that.getFileType() && Objects.equals(this.getProvenance(), that.getProvenance());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getFileType(), this.getProvenance()});
        }

        public String toString() {
            return "TrecCarHeader{\nfileType=" + (Object)((Object)this.fileType) + "\n, provenance=" + this.provenance + "\n}";
        }
    }

    public static enum FileType {
        PagesFile(0),
        OutlinesFile(1),
        ParagraphsFile(2);

        private int value;
        private static FileType[] values;

        private FileType(int value) {
            this.value = value;
        }

        public static FileType fromInt(int i) {
            if (values == null) {
                values = FileType.values();
            }
            return values[i];
        }

        static {
            values = null;
        }
    }
}

